// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_MOCKS_MOCK_NET_APP_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_MOCKS_MOCK_NET_APP_CONNECTION_H

#include "google/cloud/netapp/v1/net_app_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace netapp_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `NetAppConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `NetAppClient`. To do so,
 * construct an object of type `NetAppClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockNetAppConnection : public netapp_v1::NetAppConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::StoragePool>),
              ListStoragePools,
              (google::cloud::netapp::v1::ListStoragePoolsRequest request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::StoragePool>>,
      CreateStoragePool,
      (google::cloud::netapp::v1::CreateStoragePoolRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::netapp::v1::StoragePool>, GetStoragePool,
              (google::cloud::netapp::v1::GetStoragePoolRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::StoragePool>>,
      UpdateStoragePool,
      (google::cloud::netapp::v1::UpdateStoragePoolRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
      DeleteStoragePool,
      (google::cloud::netapp::v1::DeleteStoragePoolRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::Volume>), ListVolumes,
              (google::cloud::netapp::v1::ListVolumesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::netapp::v1::Volume>, GetVolume,
              (google::cloud::netapp::v1::GetVolumeRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::Volume>>, CreateVolume,
              (google::cloud::netapp::v1::CreateVolumeRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::Volume>>, UpdateVolume,
              (google::cloud::netapp::v1::UpdateVolumeRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
              DeleteVolume,
              (google::cloud::netapp::v1::DeleteVolumeRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::Volume>>, RevertVolume,
              (google::cloud::netapp::v1::RevertVolumeRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::Snapshot>), ListSnapshots,
              (google::cloud::netapp::v1::ListSnapshotsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::netapp::v1::Snapshot>, GetSnapshot,
              (google::cloud::netapp::v1::GetSnapshotRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::Snapshot>>,
              CreateSnapshot,
              (google::cloud::netapp::v1::CreateSnapshotRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
              DeleteSnapshot,
              (google::cloud::netapp::v1::DeleteSnapshotRequest const& request),
              (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::Snapshot>>,
              UpdateSnapshot,
              (google::cloud::netapp::v1::UpdateSnapshotRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::ActiveDirectory>),
              ListActiveDirectories,
              (google::cloud::netapp::v1::ListActiveDirectoriesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::netapp::v1::ActiveDirectory>, GetActiveDirectory,
      (google::cloud::netapp::v1::GetActiveDirectoryRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>,
      CreateActiveDirectory,
      (google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>,
      UpdateActiveDirectory,
      (google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
      DeleteActiveDirectory,
      (google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::KmsConfig>),
              ListKmsConfigs,
              (google::cloud::netapp::v1::ListKmsConfigsRequest request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::KmsConfig>>, CreateKmsConfig,
      (google::cloud::netapp::v1::CreateKmsConfigRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::netapp::v1::KmsConfig>, GetKmsConfig,
              (google::cloud::netapp::v1::GetKmsConfigRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::KmsConfig>>, UpdateKmsConfig,
      (google::cloud::netapp::v1::UpdateKmsConfigRequest const& request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::netapp::v1::KmsConfig>>,
              EncryptVolumes,
              (google::cloud::netapp::v1::EncryptVolumesRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse>,
      VerifyKmsConfig,
      (google::cloud::netapp::v1::VerifyKmsConfigRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
      DeleteKmsConfig,
      (google::cloud::netapp::v1::DeleteKmsConfigRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::netapp::v1::Replication>),
              ListReplications,
              (google::cloud::netapp::v1::ListReplicationsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::netapp::v1::Replication>, GetReplication,
              (google::cloud::netapp::v1::GetReplicationRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::Replication>>,
      CreateReplication,
      (google::cloud::netapp::v1::CreateReplicationRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>,
      DeleteReplication,
      (google::cloud::netapp::v1::DeleteReplicationRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::Replication>>,
      UpdateReplication,
      (google::cloud::netapp::v1::UpdateReplicationRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::Replication>>, StopReplication,
      (google::cloud::netapp::v1::StopReplicationRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::Replication>>,
      ResumeReplication,
      (google::cloud::netapp::v1::ResumeReplicationRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::netapp::v1::Replication>>,
      ReverseReplicationDirection,
      (google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_MOCKS_MOCK_NET_APP_CONNECTION_H
