// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/hub.proto

#include "google/cloud/networkconnectivity/v1/internal/hub_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

HubServiceTracingStub::HubServiceTracingStub(
    std::shared_ptr<HubServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::networkconnectivity::v1::ListHubsResponse>
HubServiceTracingStub::ListHubs(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListHubsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListHubs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->ListHubs(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::Hub>
HubServiceTracingStub::GetHub(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::GetHubRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "GetHub");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetHub(context, request));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncCreateHub(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::CreateHubRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "CreateHub");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateHub(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncUpdateHub(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::UpdateHubRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "UpdateHub");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateHub(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncDeleteHub(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::DeleteHubRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "DeleteHub");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteHub(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::networkconnectivity::v1::ListHubSpokesResponse>
HubServiceTracingStub::ListHubSpokes(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListHubSpokesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListHubSpokes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListHubSpokes(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::ListSpokesResponse>
HubServiceTracingStub::ListSpokes(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListSpokesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListSpokes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSpokes(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::Spoke>
HubServiceTracingStub::GetSpoke(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::GetSpokeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "GetSpoke");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetSpoke(context, request));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncCreateSpoke(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::CreateSpokeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "CreateSpoke");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateSpoke(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncUpdateSpoke(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::UpdateSpokeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "UpdateSpoke");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateSpoke(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncRejectHubSpoke(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "RejectHubSpoke");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRejectHubSpoke(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncAcceptHubSpoke(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "AcceptHubSpoke");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncAcceptHubSpoke(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncDeleteSpoke(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::networkconnectivity::v1::DeleteSpokeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "DeleteSpoke");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteSpoke(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::networkconnectivity::v1::RouteTable>
HubServiceTracingStub::GetRouteTable(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::GetRouteTableRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "GetRouteTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRouteTable(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::Route>
HubServiceTracingStub::GetRoute(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::GetRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "GetRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetRoute(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::ListRoutesResponse>
HubServiceTracingStub::ListRoutes(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListRoutesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListRoutes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRoutes(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::ListRouteTablesResponse>
HubServiceTracingStub::ListRouteTables(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListRouteTablesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListRouteTables");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRouteTables(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::Group>
HubServiceTracingStub::GetGroup(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::GetGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "GetGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetGroup(context, request));
}

StatusOr<google::cloud::networkconnectivity::v1::ListGroupsResponse>
HubServiceTracingStub::ListGroups(
    grpc::ClientContext& context,
    google::cloud::networkconnectivity::v1::ListGroupsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkconnectivity.v1.HubService", "ListGroups");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListGroups(context, request));
}

future<StatusOr<google::longrunning::Operation>>
HubServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> HubServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<HubServiceStub> MakeHubServiceTracingStub(
    std::shared_ptr<HubServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<HubServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google
