// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#include "google/cloud/orgpolicy/v2/org_policy_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace orgpolicy_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OrgPolicyConnectionIdempotencyPolicy::~OrgPolicyConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy>
OrgPolicyConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<OrgPolicyConnectionIdempotencyPolicy>(*this);
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::ListConstraints(
    google::cloud::orgpolicy::v2::ListConstraintsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::ListPolicies(
    google::cloud::orgpolicy::v2::ListPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::GetPolicy(
    google::cloud::orgpolicy::v2::GetPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::GetEffectivePolicy(
    google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::CreatePolicy(
    google::cloud::orgpolicy::v2::CreatePolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::UpdatePolicy(
    google::cloud::orgpolicy::v2::UpdatePolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency OrgPolicyConnectionIdempotencyPolicy::DeletePolicy(
    google::cloud::orgpolicy::v2::DeletePolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy>
MakeDefaultOrgPolicyConnectionIdempotencyPolicy() {
  return std::make_unique<OrgPolicyConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy_v2
}  // namespace cloud
}  // namespace google
