// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

#include "google/cloud/redis/cluster/v1/cloud_redis_cluster_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace redis_cluster_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudRedisClusterClient::CloudRedisClusterClient(
    std::shared_ptr<CloudRedisClusterConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudRedisClusterClient::~CloudRedisClusterClient() = default;

StreamRange<google::cloud::redis::cluster::v1::Cluster>
CloudRedisClusterClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::cluster::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StreamRange<google::cloud::redis::cluster::v1::Cluster>
CloudRedisClusterClient::ListClusters(
    google::cloud::redis::cluster::v1::ListClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(std::move(request));
}

StatusOr<google::cloud::redis::cluster::v1::Cluster>
CloudRedisClusterClient::GetCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::cluster::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::cloud::redis::cluster::v1::Cluster>
CloudRedisClusterClient::GetCluster(
    google::cloud::redis::cluster::v1::GetClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

future<StatusOr<google::cloud::redis::cluster::v1::Cluster>>
CloudRedisClusterClient::UpdateCluster(
    google::cloud::redis::cluster::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::cluster::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(request);
}

future<StatusOr<google::cloud::redis::cluster::v1::Cluster>>
CloudRedisClusterClient::UpdateCluster(
    google::cloud::redis::cluster::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

future<StatusOr<google::protobuf::Any>> CloudRedisClusterClient::DeleteCluster(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::cluster::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

future<StatusOr<google::protobuf::Any>> CloudRedisClusterClient::DeleteCluster(
    google::cloud::redis::cluster::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

future<StatusOr<google::cloud::redis::cluster::v1::Cluster>>
CloudRedisClusterClient::CreateCluster(
    std::string const& parent,
    google::cloud::redis::cluster::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::cluster::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(request);
}

future<StatusOr<google::cloud::redis::cluster::v1::Cluster>>
CloudRedisClusterClient::CreateCluster(
    google::cloud::redis::cluster::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis_cluster_v1
}  // namespace cloud
}  // namespace google
