// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_MOCKS_MOCK_TELCO_AUTOMATION_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_MOCKS_MOCK_TELCO_AUTOMATION_CONNECTION_H

#include "google/cloud/telcoautomation/v1/telco_automation_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace telcoautomation_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `TelcoAutomationConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `TelcoAutomationClient`. To do so,
 * construct an object of type `TelcoAutomationClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockTelcoAutomationConnection
    : public telcoautomation_v1::TelcoAutomationConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::OrchestrationCluster>),
      ListOrchestrationClusters,
      (google::cloud::telcoautomation::v1::ListOrchestrationClustersRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>,
      GetOrchestrationCluster,
      (google::cloud::telcoautomation::v1::GetOrchestrationClusterRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<
          StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>>,
      CreateOrchestrationCluster,
      (google::cloud::telcoautomation::v1::
           CreateOrchestrationClusterRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>,
      DeleteOrchestrationCluster,
      (google::cloud::telcoautomation::v1::
           DeleteOrchestrationClusterRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::telcoautomation::v1::EdgeSlm>),
              ListEdgeSlms,
              (google::cloud::telcoautomation::v1::ListEdgeSlmsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>, GetEdgeSlm,
      (google::cloud::telcoautomation::v1::GetEdgeSlmRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>>,
      CreateEdgeSlm,
      (google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>,
      DeleteEdgeSlm,
      (google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::telcoautomation::v1::Blueprint>,
              CreateBlueprint,
              (google::cloud::telcoautomation::v1::CreateBlueprintRequest const&
                   request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::telcoautomation::v1::Blueprint>,
              UpdateBlueprint,
              (google::cloud::telcoautomation::v1::UpdateBlueprintRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Blueprint>, GetBlueprint,
      (google::cloud::telcoautomation::v1::GetBlueprintRequest const& request),
      (override));

  MOCK_METHOD(Status, DeleteBlueprint,
              (google::cloud::telcoautomation::v1::DeleteBlueprintRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::Blueprint>),
      ListBlueprints,
      (google::cloud::telcoautomation::v1::ListBlueprintsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Blueprint>, ApproveBlueprint,
      (google::cloud::telcoautomation::v1::ApproveBlueprintRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Blueprint>, ProposeBlueprint,
      (google::cloud::telcoautomation::v1::ProposeBlueprintRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::telcoautomation::v1::Blueprint>,
              RejectBlueprint,
              (google::cloud::telcoautomation::v1::RejectBlueprintRequest const&
                   request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::telcoautomation::v1::Blueprint>),
              ListBlueprintRevisions,
              (google::cloud::telcoautomation::v1::ListBlueprintRevisionsRequest
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::Blueprint>),
      SearchBlueprintRevisions,
      (google::cloud::telcoautomation::v1::SearchBlueprintRevisionsRequest
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::Deployment>),
      SearchDeploymentRevisions,
      (google::cloud::telcoautomation::v1::SearchDeploymentRevisionsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::telcoautomation::v1::DiscardBlueprintChangesResponse>,
      DiscardBlueprintChanges,
      (google::cloud::telcoautomation::v1::DiscardBlueprintChangesRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::PublicBlueprint>),
      ListPublicBlueprints,
      (google::cloud::telcoautomation::v1::ListPublicBlueprintsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::PublicBlueprint>,
      GetPublicBlueprint,
      (google::cloud::telcoautomation::v1::GetPublicBlueprintRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Deployment>,
      CreateDeployment,
      (google::cloud::telcoautomation::v1::CreateDeploymentRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Deployment>,
      UpdateDeployment,
      (google::cloud::telcoautomation::v1::UpdateDeploymentRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Deployment>, GetDeployment,
      (google::cloud::telcoautomation::v1::GetDeploymentRequest const& request),
      (override));

  MOCK_METHOD(
      Status, RemoveDeployment,
      (google::cloud::telcoautomation::v1::RemoveDeploymentRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::Deployment>),
      ListDeployments,
      (google::cloud::telcoautomation::v1::ListDeploymentsRequest request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::Deployment>),
      ListDeploymentRevisions,
      (google::cloud::telcoautomation::v1::ListDeploymentRevisionsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::telcoautomation::v1::DiscardDeploymentChangesResponse>,
      DiscardDeploymentChanges,
      (google::cloud::telcoautomation::v1::
           DiscardDeploymentChangesRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::telcoautomation::v1::Deployment>,
              ApplyDeployment,
              (google::cloud::telcoautomation::v1::ApplyDeploymentRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::telcoautomation::v1::ComputeDeploymentStatusResponse>,
      ComputeDeploymentStatus,
      (google::cloud::telcoautomation::v1::ComputeDeploymentStatusRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::Deployment>,
      RollbackDeployment,
      (google::cloud::telcoautomation::v1::RollbackDeploymentRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>,
      GetHydratedDeployment,
      (google::cloud::telcoautomation::v1::GetHydratedDeploymentRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::telcoautomation::v1::HydratedDeployment>),
      ListHydratedDeployments,
      (google::cloud::telcoautomation::v1::ListHydratedDeploymentsRequest
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>,
              UpdateHydratedDeployment,
              (google::cloud::telcoautomation::v1::
                   UpdateHydratedDeploymentRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>,
      ApplyHydratedDeployment,
      (google::cloud::telcoautomation::v1::ApplyHydratedDeploymentRequest const&
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace telcoautomation_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_MOCKS_MOCK_TELCO_AUTOMATION_CONNECTION_H
