// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/internal/transcoder_auth_decorator.h"
#include <google/cloud/video/transcoder/v1/services.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace video_transcoder_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranscoderServiceAuth::TranscoderServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<TranscoderServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceAuth::CreateJob(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::CreateJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateJob(context, request);
}

StatusOr<google::cloud::video::transcoder::v1::ListJobsResponse>
TranscoderServiceAuth::ListJobs(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::ListJobsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListJobs(context, request);
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceAuth::GetJob(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::GetJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetJob(context, request);
}

Status TranscoderServiceAuth::DeleteJob(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::DeleteJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteJob(context, request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceAuth::CreateJobTemplate(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateJobTemplate(context, request);
}

StatusOr<google::cloud::video::transcoder::v1::ListJobTemplatesResponse>
TranscoderServiceAuth::ListJobTemplates(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::ListJobTemplatesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListJobTemplates(context, request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceAuth::GetJobTemplate(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetJobTemplate(context, request);
}

Status TranscoderServiceAuth::DeleteJobTemplate(
    grpc::ClientContext& context,
    google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteJobTemplate(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1_internal
}  // namespace cloud
}  // namespace google
