// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/internal/vmware_engine_connection_impl.h"
#include "google/cloud/vmwareengine/v1/internal/vmware_engine_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<vmwareengine_v1::VmwareEngineRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<vmwareengine_v1::VmwareEngineRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<vmwareengine_v1::VmwareEngineBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<vmwareengine_v1::VmwareEngineConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<vmwareengine_v1::VmwareEngineConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<vmwareengine_v1::VmwareEnginePollingPolicyOption>()
      ->clone();
}

}  // namespace

VmwareEngineConnectionImpl::VmwareEngineConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<vmwareengine_v1_internal::VmwareEngineStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      VmwareEngineConnection::options())) {}

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineConnectionImpl::ListPrivateClouds(
    google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPrivateClouds(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListPrivateCloudsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::vmwareengine::v1::ListPrivateCloudsRequest const&
                    request) {
              return stub->ListPrivateClouds(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListPrivateCloudsResponse r) {
        std::vector<google::cloud::vmwareengine::v1::PrivateCloud> result(
            r.private_clouds().size());
        auto& messages = *r.mutable_private_clouds();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineConnectionImpl::GetPrivateCloud(
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPrivateCloud(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::GetPrivateCloudRequest const&
                 request) { return stub_->GetPrivateCloud(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::CreatePrivateCloud(
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
              request) {
        return stub->AsyncCreatePrivateCloud(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePrivateCloud(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
              request) {
        return stub->AsyncUpdatePrivateCloud(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePrivateCloud(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::DeletePrivateCloud(
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
              request) {
        return stub->AsyncDeletePrivateCloud(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePrivateCloud(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::UndeletePrivateCloud(
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
              request) {
        return stub->AsyncUndeletePrivateCloud(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeletePrivateCloud(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineConnectionImpl::ListClusters(
    google::cloud::vmwareengine::v1::ListClustersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListClusters(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::Cluster>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListClustersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::ListClustersRequest const&
                       request) {
              return stub->ListClusters(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListClustersResponse r) {
        std::vector<google::cloud::vmwareengine::v1::Cluster> result(
            r.clusters().size());
        auto& messages = *r.mutable_clusters();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineConnectionImpl::GetCluster(
    google::cloud::vmwareengine::v1::GetClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCluster(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vmwareengine::v1::GetClusterRequest const& request) {
        return stub_->GetCluster(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineConnectionImpl::CreateCluster(
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::Cluster>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::CreateClusterRequest const&
              request) {
        return stub->AsyncCreateCluster(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::Cluster>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCluster(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineConnectionImpl::UpdateCluster(
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::Cluster>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UpdateClusterRequest const&
              request) {
        return stub->AsyncUpdateCluster(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::Cluster>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCluster(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnectionImpl::DeleteCluster(
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::DeleteClusterRequest const&
              request) {
        return stub->AsyncDeleteCluster(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vmwareengine::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCluster(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineConnectionImpl::ListSubnets(
    google::cloud::vmwareengine::v1::ListSubnetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSubnets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::Subnet>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListSubnetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::ListSubnetsRequest const&
                       request) { return stub->ListSubnets(context, request); },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListSubnetsResponse r) {
        std::vector<google::cloud::vmwareengine::v1::Subnet> result(
            r.subnets().size());
        auto& messages = *r.mutable_subnets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineConnectionImpl::GetSubnet(
    google::cloud::vmwareengine::v1::GetSubnetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSubnet(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::GetSubnetRequest const& request) {
        return stub_->GetSubnet(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineConnectionImpl::UpdateSubnet(
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::Subnet>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
        return stub->AsyncUpdateSubnet(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::Subnet>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSubnet(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineConnectionImpl::ListNodeTypes(
    google::cloud::vmwareengine::v1::ListNodeTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNodeTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::NodeType>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListNodeTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::ListNodeTypesRequest const&
                       request) {
              return stub->ListNodeTypes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListNodeTypesResponse r) {
        std::vector<google::cloud::vmwareengine::v1::NodeType> result(
            r.node_types().size());
        auto& messages = *r.mutable_node_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineConnectionImpl::GetNodeType(
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNodeType(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request) {
        return stub_->GetNodeType(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineConnectionImpl::ShowNsxCredentials(
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ShowNsxCredentials(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const&
                 request) {
        return stub_->ShowNsxCredentials(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineConnectionImpl::ShowVcenterCredentials(
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ShowVcenterCredentials(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
              request) {
        return stub_->ShowVcenterCredentials(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::ResetNsxCredentials(
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
              request) {
        return stub->AsyncResetNsxCredentials(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResetNsxCredentials(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnectionImpl::ResetVcenterCredentials(
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateCloud>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
              request) {
        return stub->AsyncResetVcenterCredentials(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateCloud>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResetVcenterCredentials(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineConnectionImpl::CreateHcxActivationKey(
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::HcxActivationKey>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
              request) {
        return stub->AsyncCreateHcxActivationKey(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::HcxActivationKey>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateHcxActivationKey(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineConnectionImpl::ListHcxActivationKeys(
    google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListHcxActivationKeys(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::
                       ListHcxActivationKeysRequest const& request) {
              return stub->ListHcxActivationKeys(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListHcxActivationKeysResponse r) {
        std::vector<google::cloud::vmwareengine::v1::HcxActivationKey> result(
            r.hcx_activation_keys().size());
        auto& messages = *r.mutable_hcx_activation_keys();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineConnectionImpl::GetHcxActivationKey(
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetHcxActivationKey(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
                 request) {
        return stub_->GetHcxActivationKey(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineConnectionImpl::GetNetworkPolicy(
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNetworkPolicy(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const&
                 request) { return stub_->GetNetworkPolicy(context, request); },
      request, __func__);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineConnectionImpl::ListNetworkPolicies(
    google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNetworkPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::
                       ListNetworkPoliciesRequest const& request) {
              return stub->ListNetworkPolicies(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListNetworkPoliciesResponse r) {
        std::vector<google::cloud::vmwareengine::v1::NetworkPolicy> result(
            r.network_policies().size());
        auto& messages = *r.mutable_network_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineConnectionImpl::CreateNetworkPolicy(
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::NetworkPolicy>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
              request) {
        return stub->AsyncCreateNetworkPolicy(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::NetworkPolicy>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateNetworkPolicy(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineConnectionImpl::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::NetworkPolicy>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
              request) {
        return stub->AsyncUpdateNetworkPolicy(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::NetworkPolicy>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNetworkPolicy(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnectionImpl::DeleteNetworkPolicy(
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
              request) {
        return stub->AsyncDeleteNetworkPolicy(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vmwareengine::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteNetworkPolicy(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineConnectionImpl::CreateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::VmwareEngineNetwork>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::vmwareengine::v1::
                         CreateVmwareEngineNetworkRequest const& request) {
        return stub->AsyncCreateVmwareEngineNetwork(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::VmwareEngineNetwork>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateVmwareEngineNetwork(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineConnectionImpl::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::VmwareEngineNetwork>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::vmwareengine::v1::
                         UpdateVmwareEngineNetworkRequest const& request) {
        return stub->AsyncUpdateVmwareEngineNetwork(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::VmwareEngineNetwork>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateVmwareEngineNetwork(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnectionImpl::DeleteVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::vmwareengine::v1::
                         DeleteVmwareEngineNetworkRequest const& request) {
        return stub->AsyncDeleteVmwareEngineNetwork(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vmwareengine::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteVmwareEngineNetwork(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineConnectionImpl::GetVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetVmwareEngineNetwork(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
              request) {
        return stub_->GetVmwareEngineNetwork(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineConnectionImpl::ListVmwareEngineNetworks(
    google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListVmwareEngineNetworks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::
              ListVmwareEngineNetworksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::
                       ListVmwareEngineNetworksRequest const& request) {
              return stub->ListVmwareEngineNetworks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListVmwareEngineNetworksResponse r) {
        std::vector<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
            result(r.vmware_engine_networks().size());
        auto& messages = *r.mutable_vmware_engine_networks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineConnectionImpl::CreatePrivateConnection(
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateConnection>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
              request) {
        return stub->AsyncCreatePrivateConnection(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateConnection>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePrivateConnection(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineConnectionImpl::GetPrivateConnection(
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPrivateConnection(request),
      [this](grpc::ClientContext& context,
             google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
                 request) {
        return stub_->GetPrivateConnection(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineConnectionImpl::ListPrivateConnections(
    google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListPrivateConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vmwareengine::v1::
                       ListPrivateConnectionsRequest const& request) {
              return stub->ListPrivateConnections(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::ListPrivateConnectionsResponse r) {
        std::vector<google::cloud::vmwareengine::v1::PrivateConnection> result(
            r.private_connections().size());
        auto& messages = *r.mutable_private_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineConnectionImpl::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::PrivateConnection>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
              request) {
        return stub->AsyncUpdatePrivateConnection(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vmwareengine::v1::PrivateConnection>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePrivateConnection(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnectionImpl::DeletePrivateConnection(
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vmwareengine::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
              request) {
        return stub->AsyncDeletePrivateConnection(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vmwareengine::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePrivateConnection(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineConnectionImpl::ListPrivateConnectionPeeringRoutes(
    google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListPrivateConnectionPeeringRoutes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<vmwareengine_v1::VmwareEngineRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::vmwareengine::v1::
              ListPrivateConnectionPeeringRoutesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::vmwareengine::v1::
                    ListPrivateConnectionPeeringRoutesRequest const& request) {
              return stub->ListPrivateConnectionPeeringRoutes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vmwareengine::v1::
             ListPrivateConnectionPeeringRoutesResponse r) {
        std::vector<google::cloud::vmwareengine::v1::PeeringRoute> result(
            r.peering_routes().size());
        auto& messages = *r.mutable_peering_routes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1_internal
}  // namespace cloud
}  // namespace google
