/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Retry {
    private static final Logger logger = Logger.getLogger(Retry.class.getName());
    private int numTries;

    public Retry(int numTries) {
        Preconditions.checkArgument(numTries > 0);
        this.numTries = numTries;
    }

    public <T> T retry(Retryable<T> retryable) {
        int numRetries = 0;
        ArrayList<Exception> exceptions = Lists.newArrayList();
        while (true) {
            try {
                return retryable.run();
            }
            catch (Exception e) {
                exceptions.add(e);
                if (++numRetries == this.numTries) {
                    StringBuilder exceptionsString = new StringBuilder();
                    for (int i = 0; i < exceptions.size(); ++i) {
                        exceptionsString.append("\nFailure " + (i + 1) + ": " + exceptions.get(i));
                    }
                    throw new RuntimeException("Failed after " + this.numTries + " tries." + exceptionsString, e);
                }
                logger.info("Retrying statement; number of times failed: " + numRetries + "; exception\n:" + e);
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Retryable<T> {
        public T run() throws Exception;
    }
}

