/* sage.h was originally generated by the autoSql program, which also 
 * generated sage.c and sage.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SAGE_H
#define SAGE_H

struct sage
/* stores sage data in terms of uni-gene identifiers. */
    {
    struct sage *next;  /* Next in singly linked list. */
    int uni;	/* Number portion of uni-gene identifier, add 'Hs.' for full identifier. */
    char gb[65];	/* Genebank accesion number. */
    char gi[65];	/* gi field in unigene descriptions. */
    char *description;	/* Description from uni-gene fasta headers. */
    int numTags;	/* Number of tags. */
    char **tags;	/* Tags for this unigene sequence. */
    int numExps;	/* Number of experiments. */
    int *exps;	/* index of experiments in order of aves and stdevs. */
    float *meds;	/* The median count of all tags for each experiment. */
    float *aves;	/* The average count of all tags for each experiment. */
    float *stdevs;	/* Standard deviation of all counts for each experiment */
    };

struct sage *sageLoad(char **row);
/* Load a sage from row fetched with select * from sage
 * from database.  Dispose of this with sageFree(). */

struct sage *sageLoadAll(char *fileName);
/* Load all sage from a tab-separated file.
 * Dispose of this with sageFreeList(). */

struct sage *sageCommaIn(char **pS, struct sage *ret);
/* Create a sage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sage */

void sageFree(struct sage **pEl);
/* Free a single dynamically allocated sage such as created
 * with sageLoad(). */

void sageFreeList(struct sage **pList);
/* Free a list of dynamically allocated sage's */

void sageOutput(struct sage *el, FILE *f, char sep, char lastSep);
/* Print out sage.  Separate fields with sep. Follow last field with lastSep. */

#define sageTabOut(el,f) sageOutput(el,f,'\t','\n');
/* Print out sage as a line in a tab-separated file. */

#define sageCommaOut(el,f) sageOutput(el,f,',',',');
/* Print out sage as a comma separated list including final comma. */

#endif /* SAGE_H */

