'use client';
'use strict';

var React = require('react');
var useIsomorphicEffect = require('../use-isomorphic-effect/use-isomorphic-effect.cjs');

function useOrientation() {
  const [orientation, setOrientation] = React.useState({ angle: 0, type: "landscape-primary" });
  const handleOrientationChange = (event) => {
    const target = event.currentTarget;
    setOrientation({ angle: target?.angle || 0, type: target?.type || "landscape-primary" });
  };
  useIsomorphicEffect.useIsomorphicEffect(() => {
    window.screen.orientation?.addEventListener("change", handleOrientationChange);
    return () => window.screen.orientation?.removeEventListener("change", handleOrientationChange);
  }, []);
  return orientation;
}

exports.useOrientation = useOrientation;
//# sourceMappingURL=use-orientation.cjs.map
