// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddCustomRoutingEndpoints = "AddCustomRoutingEndpoints"

// AddCustomRoutingEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the AddCustomRoutingEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddCustomRoutingEndpoints for more information on using the AddCustomRoutingEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddCustomRoutingEndpointsRequest method.
//	req, resp := client.AddCustomRoutingEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints
func (c *GlobalAccelerator) AddCustomRoutingEndpointsRequest(input *AddCustomRoutingEndpointsInput) (req *request.Request, output *AddCustomRoutingEndpointsOutput) {
	op := &request.Operation{
		Name:       opAddCustomRoutingEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCustomRoutingEndpointsInput{}
	}

	output = &AddCustomRoutingEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddCustomRoutingEndpoints API operation for AWS Global Accelerator.
//
// Associate a virtual private cloud (VPC) subnet endpoint with your custom
// routing accelerator.
//
// The listener port range must be large enough to support the number of IP
// addresses that can be specified in your subnet. The number of ports required
// is: subnet size times the number of ports per destination EC2 instances.
// For example, a subnet defined as /24 requires a listener port range of at
// least 255 ports.
//
// Note: You must have enough remaining listener ports available to map to the
// subnet ports, or the call will fail with a LimitExceededException.
//
// By default, all destinations in a subnet in a custom routing accelerator
// cannot receive traffic. To enable all destinations to receive traffic, or
// to specify individual port mappings that can receive traffic, see the AllowCustomRoutingTraffic
// (https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation AddCustomRoutingEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - EndpointAlreadyExistsException
//     The endpoint that you specified doesn't exist.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - ConflictException
//     You can't use both of those options.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints
func (c *GlobalAccelerator) AddCustomRoutingEndpoints(input *AddCustomRoutingEndpointsInput) (*AddCustomRoutingEndpointsOutput, error) {
	req, out := c.AddCustomRoutingEndpointsRequest(input)
	return out, req.Send()
}

// AddCustomRoutingEndpointsWithContext is the same as AddCustomRoutingEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See AddCustomRoutingEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) AddCustomRoutingEndpointsWithContext(ctx aws.Context, input *AddCustomRoutingEndpointsInput, opts ...request.Option) (*AddCustomRoutingEndpointsOutput, error) {
	req, out := c.AddCustomRoutingEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddEndpoints = "AddEndpoints"

// AddEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the AddEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddEndpoints for more information on using the AddEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddEndpointsRequest method.
//	req, resp := client.AddEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddEndpoints
func (c *GlobalAccelerator) AddEndpointsRequest(input *AddEndpointsInput) (req *request.Request, output *AddEndpointsOutput) {
	op := &request.Operation{
		Name:       opAddEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddEndpointsInput{}
	}

	output = &AddEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddEndpoints API operation for AWS Global Accelerator.
//
// Add endpoints to an endpoint group. The AddEndpoints API operation is the
// recommended option for adding endpoints. The alternative options are to add
// endpoints when you create an endpoint group (with the CreateEndpointGroup
// (https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html)
// API) or when you update an endpoint group (with the UpdateEndpointGroup (https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html)
// API).
//
// There are two advantages to using AddEndpoints to add endpoints in Global
// Accelerator:
//
//   - It's faster, because Global Accelerator only has to resolve the new
//     endpoints that you're adding, rather than resolving new and existing endpoints.
//
//   - It's more convenient, because you don't need to specify the current
//     endpoints that are already in the endpoint group, in addition to the new
//     endpoints that you want to add.
//
// For information about endpoint types and requirements for endpoints that
// you can add to Global Accelerator, see Endpoints for standard accelerators
// (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation AddEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - TransactionInProgressException
//     There's already a transaction in progress. Another transaction can't be processed.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddEndpoints
func (c *GlobalAccelerator) AddEndpoints(input *AddEndpointsInput) (*AddEndpointsOutput, error) {
	req, out := c.AddEndpointsRequest(input)
	return out, req.Send()
}

// AddEndpointsWithContext is the same as AddEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See AddEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) AddEndpointsWithContext(ctx aws.Context, input *AddEndpointsInput, opts ...request.Option) (*AddEndpointsOutput, error) {
	req, out := c.AddEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdvertiseByoipCidr = "AdvertiseByoipCidr"

// AdvertiseByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the AdvertiseByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdvertiseByoipCidr for more information on using the AdvertiseByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AdvertiseByoipCidrRequest method.
//	req, resp := client.AdvertiseByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr
func (c *GlobalAccelerator) AdvertiseByoipCidrRequest(input *AdvertiseByoipCidrInput) (req *request.Request, output *AdvertiseByoipCidrOutput) {
	op := &request.Operation{
		Name:       opAdvertiseByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdvertiseByoipCidrInput{}
	}

	output = &AdvertiseByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdvertiseByoipCidr API operation for AWS Global Accelerator.
//
// Advertises an IPv4 address range that is provisioned for use with your Amazon
// Web Services resources through bring your own IP addresses (BYOIP). It can
// take a few minutes before traffic to the specified addresses starts routing
// to Amazon Web Services because of propagation delays.
//
// To stop advertising the BYOIP address range, use WithdrawByoipCidr (https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html).
//
// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation AdvertiseByoipCidr for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - ByoipCidrNotFoundException
//     The CIDR that you specified was not found or is incorrect.
//
//   - IncorrectCidrStateException
//     The CIDR that you specified is not valid for this action. For example, the
//     state of the CIDR might be incorrect for this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr
func (c *GlobalAccelerator) AdvertiseByoipCidr(input *AdvertiseByoipCidrInput) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	return out, req.Send()
}

// AdvertiseByoipCidrWithContext is the same as AdvertiseByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See AdvertiseByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) AdvertiseByoipCidrWithContext(ctx aws.Context, input *AdvertiseByoipCidrInput, opts ...request.Option) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllowCustomRoutingTraffic = "AllowCustomRoutingTraffic"

// AllowCustomRoutingTrafficRequest generates a "aws/request.Request" representing the
// client's request for the AllowCustomRoutingTraffic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllowCustomRoutingTraffic for more information on using the AllowCustomRoutingTraffic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AllowCustomRoutingTrafficRequest method.
//	req, resp := client.AllowCustomRoutingTrafficRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic
func (c *GlobalAccelerator) AllowCustomRoutingTrafficRequest(input *AllowCustomRoutingTrafficInput) (req *request.Request, output *AllowCustomRoutingTrafficOutput) {
	op := &request.Operation{
		Name:       opAllowCustomRoutingTraffic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllowCustomRoutingTrafficInput{}
	}

	output = &AllowCustomRoutingTrafficOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AllowCustomRoutingTraffic API operation for AWS Global Accelerator.
//
// Specify the Amazon EC2 instance (destination) IP addresses and ports for
// a VPC subnet endpoint that can receive traffic for a custom routing accelerator.
// You can allow traffic to all destinations in the subnet endpoint, or allow
// traffic to a specified list of destination IP addresses and ports in the
// subnet. Note that you cannot specify IP addresses or ports outside of the
// range that you configured for the endpoint group.
//
// After you make changes, you can verify that the updates are complete by checking
// the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation AllowCustomRoutingTraffic for usage and error information.
//
// Returned Error Types:
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic
func (c *GlobalAccelerator) AllowCustomRoutingTraffic(input *AllowCustomRoutingTrafficInput) (*AllowCustomRoutingTrafficOutput, error) {
	req, out := c.AllowCustomRoutingTrafficRequest(input)
	return out, req.Send()
}

// AllowCustomRoutingTrafficWithContext is the same as AllowCustomRoutingTraffic with the addition of
// the ability to pass a context and additional request options.
//
// See AllowCustomRoutingTraffic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) AllowCustomRoutingTrafficWithContext(ctx aws.Context, input *AllowCustomRoutingTrafficInput, opts ...request.Option) (*AllowCustomRoutingTrafficOutput, error) {
	req, out := c.AllowCustomRoutingTrafficRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccelerator = "CreateAccelerator"

// CreateAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccelerator for more information on using the CreateAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAcceleratorRequest method.
//	req, resp := client.CreateAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator
func (c *GlobalAccelerator) CreateAcceleratorRequest(input *CreateAcceleratorInput) (req *request.Request, output *CreateAcceleratorOutput) {
	op := &request.Operation{
		Name:       opCreateAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAcceleratorInput{}
	}

	output = &CreateAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccelerator API operation for AWS Global Accelerator.
//
// Create an accelerator. An accelerator includes one or more listeners that
// process inbound connections and direct traffic to one or more endpoint groups,
// each of which includes endpoints, such as Network Load Balancers.
//
// Global Accelerator is a global service that supports endpoints in multiple
// Amazon Web Services Regions but you must specify the US West (Oregon) Region
// to create, update, or otherwise work with accelerators. That is, for example,
// specify --region us-west-2 on Amazon Web Services CLI commands.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator
func (c *GlobalAccelerator) CreateAccelerator(input *CreateAcceleratorInput) (*CreateAcceleratorOutput, error) {
	req, out := c.CreateAcceleratorRequest(input)
	return out, req.Send()
}

// CreateAcceleratorWithContext is the same as CreateAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateAcceleratorWithContext(ctx aws.Context, input *CreateAcceleratorInput, opts ...request.Option) (*CreateAcceleratorOutput, error) {
	req, out := c.CreateAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCrossAccountAttachment = "CreateCrossAccountAttachment"

// CreateCrossAccountAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateCrossAccountAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCrossAccountAttachment for more information on using the CreateCrossAccountAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCrossAccountAttachmentRequest method.
//	req, resp := client.CreateCrossAccountAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCrossAccountAttachment
func (c *GlobalAccelerator) CreateCrossAccountAttachmentRequest(input *CreateCrossAccountAttachmentInput) (req *request.Request, output *CreateCrossAccountAttachmentOutput) {
	op := &request.Operation{
		Name:       opCreateCrossAccountAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCrossAccountAttachmentInput{}
	}

	output = &CreateCrossAccountAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCrossAccountAttachment API operation for AWS Global Accelerator.
//
// Create a cross-account attachment in Global Accelerator. You create a cross-account
// attachment to specify the principals who have permission to work with resources
// in accelerators in their own account. You specify, in the same attachment,
// the resources that are shared.
//
// A principal can be an Amazon Web Services account number or the Amazon Resource
// Name (ARN) for an accelerator. For account numbers that are listed as principals,
// to work with a resource listed in the attachment, you must sign in to an
// account specified as a principal. Then, you can work with resources that
// are listed, with any of your accelerators. If an accelerator ARN is listed
// in the cross-account attachment as a principal, anyone with permission to
// make updates to the accelerator can work with resources that are listed in
// the attachment.
//
// Specify each principal and resource separately. To specify two CIDR address
// pools, list them individually under Resources, and so on. For a command line
// operation, for example, you might use a statement like the following:
//
// "Resources": [{"Cidr": "169.254.60.0/24"},{"Cidr": "169.254.59.0/24"}]
//
// For more information, see Working with cross-account attachments and resources
// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateCrossAccountAttachment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - TransactionInProgressException
//     There's already a transaction in progress. Another transaction can't be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCrossAccountAttachment
func (c *GlobalAccelerator) CreateCrossAccountAttachment(input *CreateCrossAccountAttachmentInput) (*CreateCrossAccountAttachmentOutput, error) {
	req, out := c.CreateCrossAccountAttachmentRequest(input)
	return out, req.Send()
}

// CreateCrossAccountAttachmentWithContext is the same as CreateCrossAccountAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCrossAccountAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateCrossAccountAttachmentWithContext(ctx aws.Context, input *CreateCrossAccountAttachmentInput, opts ...request.Option) (*CreateCrossAccountAttachmentOutput, error) {
	req, out := c.CreateCrossAccountAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomRoutingAccelerator = "CreateCustomRoutingAccelerator"

// CreateCustomRoutingAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomRoutingAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomRoutingAccelerator for more information on using the CreateCustomRoutingAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomRoutingAcceleratorRequest method.
//	req, resp := client.CreateCustomRoutingAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator
func (c *GlobalAccelerator) CreateCustomRoutingAcceleratorRequest(input *CreateCustomRoutingAcceleratorInput) (req *request.Request, output *CreateCustomRoutingAcceleratorOutput) {
	op := &request.Operation{
		Name:       opCreateCustomRoutingAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomRoutingAcceleratorInput{}
	}

	output = &CreateCustomRoutingAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomRoutingAccelerator API operation for AWS Global Accelerator.
//
// Create a custom routing accelerator. A custom routing accelerator directs
// traffic to one of possibly thousands of Amazon EC2 instance destinations
// running in a single or multiple virtual private clouds (VPC) subnet endpoints.
//
// Be aware that, by default, all destination EC2 instances in a VPC subnet
// endpoint cannot receive traffic. To enable all destinations to receive traffic,
// or to specify individual port mappings that can receive traffic, see the
// AllowCustomRoutingTraffic (https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html)
// operation.
//
// Global Accelerator is a global service that supports endpoints in multiple
// Amazon Web Services Regions but you must specify the US West (Oregon) Region
// to create, update, or otherwise work with accelerators. That is, for example,
// specify --region us-west-2 on Amazon Web Services CLI commands.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateCustomRoutingAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator
func (c *GlobalAccelerator) CreateCustomRoutingAccelerator(input *CreateCustomRoutingAcceleratorInput) (*CreateCustomRoutingAcceleratorOutput, error) {
	req, out := c.CreateCustomRoutingAcceleratorRequest(input)
	return out, req.Send()
}

// CreateCustomRoutingAcceleratorWithContext is the same as CreateCustomRoutingAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomRoutingAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateCustomRoutingAcceleratorWithContext(ctx aws.Context, input *CreateCustomRoutingAcceleratorInput, opts ...request.Option) (*CreateCustomRoutingAcceleratorOutput, error) {
	req, out := c.CreateCustomRoutingAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomRoutingEndpointGroup = "CreateCustomRoutingEndpointGroup"

// CreateCustomRoutingEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomRoutingEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomRoutingEndpointGroup for more information on using the CreateCustomRoutingEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomRoutingEndpointGroupRequest method.
//	req, resp := client.CreateCustomRoutingEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup
func (c *GlobalAccelerator) CreateCustomRoutingEndpointGroupRequest(input *CreateCustomRoutingEndpointGroupInput) (req *request.Request, output *CreateCustomRoutingEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opCreateCustomRoutingEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomRoutingEndpointGroupInput{}
	}

	output = &CreateCustomRoutingEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomRoutingEndpointGroup API operation for AWS Global Accelerator.
//
// Create an endpoint group for the specified listener for a custom routing
// accelerator. An endpoint group is a collection of endpoints in one Amazon
// Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateCustomRoutingEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - EndpointGroupAlreadyExistsException
//     The endpoint group that you specified already exists.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidPortRangeException
//     The port numbers that you specified are not valid numbers or are not unique
//     for this accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup
func (c *GlobalAccelerator) CreateCustomRoutingEndpointGroup(input *CreateCustomRoutingEndpointGroupInput) (*CreateCustomRoutingEndpointGroupOutput, error) {
	req, out := c.CreateCustomRoutingEndpointGroupRequest(input)
	return out, req.Send()
}

// CreateCustomRoutingEndpointGroupWithContext is the same as CreateCustomRoutingEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomRoutingEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateCustomRoutingEndpointGroupWithContext(ctx aws.Context, input *CreateCustomRoutingEndpointGroupInput, opts ...request.Option) (*CreateCustomRoutingEndpointGroupOutput, error) {
	req, out := c.CreateCustomRoutingEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomRoutingListener = "CreateCustomRoutingListener"

// CreateCustomRoutingListenerRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomRoutingListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomRoutingListener for more information on using the CreateCustomRoutingListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomRoutingListenerRequest method.
//	req, resp := client.CreateCustomRoutingListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener
func (c *GlobalAccelerator) CreateCustomRoutingListenerRequest(input *CreateCustomRoutingListenerInput) (req *request.Request, output *CreateCustomRoutingListenerOutput) {
	op := &request.Operation{
		Name:       opCreateCustomRoutingListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomRoutingListenerInput{}
	}

	output = &CreateCustomRoutingListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomRoutingListener API operation for AWS Global Accelerator.
//
// Create a listener to process inbound connections from clients to a custom
// routing accelerator. Connections arrive to assigned static IP addresses on
// the port range that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateCustomRoutingListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InvalidPortRangeException
//     The port numbers that you specified are not valid numbers or are not unique
//     for this accelerator.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener
func (c *GlobalAccelerator) CreateCustomRoutingListener(input *CreateCustomRoutingListenerInput) (*CreateCustomRoutingListenerOutput, error) {
	req, out := c.CreateCustomRoutingListenerRequest(input)
	return out, req.Send()
}

// CreateCustomRoutingListenerWithContext is the same as CreateCustomRoutingListener with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomRoutingListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateCustomRoutingListenerWithContext(ctx aws.Context, input *CreateCustomRoutingListenerInput, opts ...request.Option) (*CreateCustomRoutingListenerOutput, error) {
	req, out := c.CreateCustomRoutingListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointGroup = "CreateEndpointGroup"

// CreateEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointGroup for more information on using the CreateEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointGroupRequest method.
//	req, resp := client.CreateEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup
func (c *GlobalAccelerator) CreateEndpointGroupRequest(input *CreateEndpointGroupInput) (req *request.Request, output *CreateEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointGroupInput{}
	}

	output = &CreateEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointGroup API operation for AWS Global Accelerator.
//
// Create an endpoint group for the specified listener. An endpoint group is
// a collection of endpoints in one Amazon Web Services Region. A resource must
// be valid and active when you add it as an endpoint.
//
// For more information about endpoint types and requirements for endpoints
// that you can add to Global Accelerator, see Endpoints for standard accelerators
// (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - EndpointGroupAlreadyExistsException
//     The endpoint group that you specified already exists.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup
func (c *GlobalAccelerator) CreateEndpointGroup(input *CreateEndpointGroupInput) (*CreateEndpointGroupOutput, error) {
	req, out := c.CreateEndpointGroupRequest(input)
	return out, req.Send()
}

// CreateEndpointGroupWithContext is the same as CreateEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateEndpointGroupWithContext(ctx aws.Context, input *CreateEndpointGroupInput, opts ...request.Option) (*CreateEndpointGroupOutput, error) {
	req, out := c.CreateEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateListener = "CreateListener"

// CreateListenerRequest generates a "aws/request.Request" representing the
// client's request for the CreateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateListener for more information on using the CreateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateListenerRequest method.
//	req, resp := client.CreateListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener
func (c *GlobalAccelerator) CreateListenerRequest(input *CreateListenerInput) (req *request.Request, output *CreateListenerOutput) {
	op := &request.Operation{
		Name:       opCreateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateListenerInput{}
	}

	output = &CreateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateListener API operation for AWS Global Accelerator.
//
// Create a listener to process inbound connections from clients to an accelerator.
// Connections arrive to assigned static IP addresses on a port, port range,
// or list of port ranges that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InvalidPortRangeException
//     The port numbers that you specified are not valid numbers or are not unique
//     for this accelerator.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener
func (c *GlobalAccelerator) CreateListener(input *CreateListenerInput) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	return out, req.Send()
}

// CreateListenerWithContext is the same as CreateListener with the addition of
// the ability to pass a context and additional request options.
//
// See CreateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateListenerWithContext(ctx aws.Context, input *CreateListenerInput, opts ...request.Option) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccelerator = "DeleteAccelerator"

// DeleteAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccelerator for more information on using the DeleteAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAcceleratorRequest method.
//	req, resp := client.DeleteAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator
func (c *GlobalAccelerator) DeleteAcceleratorRequest(input *DeleteAcceleratorInput) (req *request.Request, output *DeleteAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDeleteAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAcceleratorInput{}
	}

	output = &DeleteAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccelerator API operation for AWS Global Accelerator.
//
// Delete an accelerator. Before you can delete an accelerator, you must disable
// it and remove all dependent resources (listeners and endpoint groups). To
// disable the accelerator, update the accelerator to set Enabled to false.
//
// When you create an accelerator, by default, Global Accelerator provides you
// with a set of two static IP addresses. Alternatively, you can bring your
// own IP address ranges to Global Accelerator and assign IP addresses from
// those ranges.
//
// The IP addresses are assigned to your accelerator for as long as it exists,
// even if you disable the accelerator and it no longer accepts or routes traffic.
// However, when you delete an accelerator, you lose the static IP addresses
// that are assigned to the accelerator, so you can no longer route traffic
// by using them. As a best practice, ensure that you have permissions in place
// to avoid inadvertently deleting accelerators. You can use IAM policies with
// Global Accelerator to limit the users who have permissions to delete an accelerator.
// For more information, see Identity and access management (https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - AcceleratorNotDisabledException
//     The accelerator that you specified could not be disabled.
//
//   - AssociatedListenerFoundException
//     The accelerator that you specified has a listener associated with it. You
//     must remove all dependent resources from an accelerator before you can delete
//     it.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator
func (c *GlobalAccelerator) DeleteAccelerator(input *DeleteAcceleratorInput) (*DeleteAcceleratorOutput, error) {
	req, out := c.DeleteAcceleratorRequest(input)
	return out, req.Send()
}

// DeleteAcceleratorWithContext is the same as DeleteAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteAcceleratorWithContext(ctx aws.Context, input *DeleteAcceleratorInput, opts ...request.Option) (*DeleteAcceleratorOutput, error) {
	req, out := c.DeleteAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCrossAccountAttachment = "DeleteCrossAccountAttachment"

// DeleteCrossAccountAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCrossAccountAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCrossAccountAttachment for more information on using the DeleteCrossAccountAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCrossAccountAttachmentRequest method.
//	req, resp := client.DeleteCrossAccountAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCrossAccountAttachment
func (c *GlobalAccelerator) DeleteCrossAccountAttachmentRequest(input *DeleteCrossAccountAttachmentInput) (req *request.Request, output *DeleteCrossAccountAttachmentOutput) {
	op := &request.Operation{
		Name:       opDeleteCrossAccountAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCrossAccountAttachmentInput{}
	}

	output = &DeleteCrossAccountAttachmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCrossAccountAttachment API operation for AWS Global Accelerator.
//
// Delete a cross-account attachment. When you delete an attachment, Global
// Accelerator revokes the permission to use the resources in the attachment
// from all principals in the list of principals. Global Accelerator revokes
// the permission for specific resources.
//
// For more information, see Working with cross-account attachments and resources
// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteCrossAccountAttachment for usage and error information.
//
// Returned Error Types:
//
//   - AttachmentNotFoundException
//     No cross-account attachment was found.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - TransactionInProgressException
//     There's already a transaction in progress. Another transaction can't be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCrossAccountAttachment
func (c *GlobalAccelerator) DeleteCrossAccountAttachment(input *DeleteCrossAccountAttachmentInput) (*DeleteCrossAccountAttachmentOutput, error) {
	req, out := c.DeleteCrossAccountAttachmentRequest(input)
	return out, req.Send()
}

// DeleteCrossAccountAttachmentWithContext is the same as DeleteCrossAccountAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCrossAccountAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteCrossAccountAttachmentWithContext(ctx aws.Context, input *DeleteCrossAccountAttachmentInput, opts ...request.Option) (*DeleteCrossAccountAttachmentOutput, error) {
	req, out := c.DeleteCrossAccountAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomRoutingAccelerator = "DeleteCustomRoutingAccelerator"

// DeleteCustomRoutingAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomRoutingAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomRoutingAccelerator for more information on using the DeleteCustomRoutingAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomRoutingAcceleratorRequest method.
//	req, resp := client.DeleteCustomRoutingAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator
func (c *GlobalAccelerator) DeleteCustomRoutingAcceleratorRequest(input *DeleteCustomRoutingAcceleratorInput) (req *request.Request, output *DeleteCustomRoutingAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomRoutingAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomRoutingAcceleratorInput{}
	}

	output = &DeleteCustomRoutingAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomRoutingAccelerator API operation for AWS Global Accelerator.
//
// Delete a custom routing accelerator. Before you can delete an accelerator,
// you must disable it and remove all dependent resources (listeners and endpoint
// groups). To disable the accelerator, update the accelerator to set Enabled
// to false.
//
// When you create a custom routing accelerator, by default, Global Accelerator
// provides you with a set of two static IP addresses.
//
// The IP addresses are assigned to your accelerator for as long as it exists,
// even if you disable the accelerator and it no longer accepts or routes traffic.
// However, when you delete an accelerator, you lose the static IP addresses
// that are assigned to the accelerator, so you can no longer route traffic
// by using them. As a best practice, ensure that you have permissions in place
// to avoid inadvertently deleting accelerators. You can use IAM policies with
// Global Accelerator to limit the users who have permissions to delete an accelerator.
// For more information, see Identity and access management (https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteCustomRoutingAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - AcceleratorNotDisabledException
//     The accelerator that you specified could not be disabled.
//
//   - AssociatedListenerFoundException
//     The accelerator that you specified has a listener associated with it. You
//     must remove all dependent resources from an accelerator before you can delete
//     it.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator
func (c *GlobalAccelerator) DeleteCustomRoutingAccelerator(input *DeleteCustomRoutingAcceleratorInput) (*DeleteCustomRoutingAcceleratorOutput, error) {
	req, out := c.DeleteCustomRoutingAcceleratorRequest(input)
	return out, req.Send()
}

// DeleteCustomRoutingAcceleratorWithContext is the same as DeleteCustomRoutingAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomRoutingAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteCustomRoutingAcceleratorWithContext(ctx aws.Context, input *DeleteCustomRoutingAcceleratorInput, opts ...request.Option) (*DeleteCustomRoutingAcceleratorOutput, error) {
	req, out := c.DeleteCustomRoutingAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomRoutingEndpointGroup = "DeleteCustomRoutingEndpointGroup"

// DeleteCustomRoutingEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomRoutingEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomRoutingEndpointGroup for more information on using the DeleteCustomRoutingEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomRoutingEndpointGroupRequest method.
//	req, resp := client.DeleteCustomRoutingEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup
func (c *GlobalAccelerator) DeleteCustomRoutingEndpointGroupRequest(input *DeleteCustomRoutingEndpointGroupInput) (req *request.Request, output *DeleteCustomRoutingEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomRoutingEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomRoutingEndpointGroupInput{}
	}

	output = &DeleteCustomRoutingEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomRoutingEndpointGroup API operation for AWS Global Accelerator.
//
// Delete an endpoint group from a listener for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteCustomRoutingEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup
func (c *GlobalAccelerator) DeleteCustomRoutingEndpointGroup(input *DeleteCustomRoutingEndpointGroupInput) (*DeleteCustomRoutingEndpointGroupOutput, error) {
	req, out := c.DeleteCustomRoutingEndpointGroupRequest(input)
	return out, req.Send()
}

// DeleteCustomRoutingEndpointGroupWithContext is the same as DeleteCustomRoutingEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomRoutingEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteCustomRoutingEndpointGroupWithContext(ctx aws.Context, input *DeleteCustomRoutingEndpointGroupInput, opts ...request.Option) (*DeleteCustomRoutingEndpointGroupOutput, error) {
	req, out := c.DeleteCustomRoutingEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomRoutingListener = "DeleteCustomRoutingListener"

// DeleteCustomRoutingListenerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomRoutingListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomRoutingListener for more information on using the DeleteCustomRoutingListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomRoutingListenerRequest method.
//	req, resp := client.DeleteCustomRoutingListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener
func (c *GlobalAccelerator) DeleteCustomRoutingListenerRequest(input *DeleteCustomRoutingListenerInput) (req *request.Request, output *DeleteCustomRoutingListenerOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomRoutingListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomRoutingListenerInput{}
	}

	output = &DeleteCustomRoutingListenerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomRoutingListener API operation for AWS Global Accelerator.
//
// Delete a listener for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteCustomRoutingListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - AssociatedEndpointGroupFoundException
//     The listener that you specified has an endpoint group associated with it.
//     You must remove all dependent resources from a listener before you can delete
//     it.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener
func (c *GlobalAccelerator) DeleteCustomRoutingListener(input *DeleteCustomRoutingListenerInput) (*DeleteCustomRoutingListenerOutput, error) {
	req, out := c.DeleteCustomRoutingListenerRequest(input)
	return out, req.Send()
}

// DeleteCustomRoutingListenerWithContext is the same as DeleteCustomRoutingListener with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomRoutingListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteCustomRoutingListenerWithContext(ctx aws.Context, input *DeleteCustomRoutingListenerInput, opts ...request.Option) (*DeleteCustomRoutingListenerOutput, error) {
	req, out := c.DeleteCustomRoutingListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointGroup = "DeleteEndpointGroup"

// DeleteEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointGroup for more information on using the DeleteEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointGroupRequest method.
//	req, resp := client.DeleteEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup
func (c *GlobalAccelerator) DeleteEndpointGroupRequest(input *DeleteEndpointGroupInput) (req *request.Request, output *DeleteEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointGroupInput{}
	}

	output = &DeleteEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpointGroup API operation for AWS Global Accelerator.
//
// Delete an endpoint group from a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup
func (c *GlobalAccelerator) DeleteEndpointGroup(input *DeleteEndpointGroupInput) (*DeleteEndpointGroupOutput, error) {
	req, out := c.DeleteEndpointGroupRequest(input)
	return out, req.Send()
}

// DeleteEndpointGroupWithContext is the same as DeleteEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteEndpointGroupWithContext(ctx aws.Context, input *DeleteEndpointGroupInput, opts ...request.Option) (*DeleteEndpointGroupOutput, error) {
	req, out := c.DeleteEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteListener = "DeleteListener"

// DeleteListenerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteListener for more information on using the DeleteListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteListenerRequest method.
//	req, resp := client.DeleteListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener
func (c *GlobalAccelerator) DeleteListenerRequest(input *DeleteListenerInput) (req *request.Request, output *DeleteListenerOutput) {
	op := &request.Operation{
		Name:       opDeleteListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteListenerInput{}
	}

	output = &DeleteListenerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteListener API operation for AWS Global Accelerator.
//
// Delete a listener from an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - AssociatedEndpointGroupFoundException
//     The listener that you specified has an endpoint group associated with it.
//     You must remove all dependent resources from a listener before you can delete
//     it.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener
func (c *GlobalAccelerator) DeleteListener(input *DeleteListenerInput) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	return out, req.Send()
}

// DeleteListenerWithContext is the same as DeleteListener with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteListenerWithContext(ctx aws.Context, input *DeleteListenerInput, opts ...request.Option) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDenyCustomRoutingTraffic = "DenyCustomRoutingTraffic"

// DenyCustomRoutingTrafficRequest generates a "aws/request.Request" representing the
// client's request for the DenyCustomRoutingTraffic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DenyCustomRoutingTraffic for more information on using the DenyCustomRoutingTraffic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DenyCustomRoutingTrafficRequest method.
//	req, resp := client.DenyCustomRoutingTrafficRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic
func (c *GlobalAccelerator) DenyCustomRoutingTrafficRequest(input *DenyCustomRoutingTrafficInput) (req *request.Request, output *DenyCustomRoutingTrafficOutput) {
	op := &request.Operation{
		Name:       opDenyCustomRoutingTraffic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DenyCustomRoutingTrafficInput{}
	}

	output = &DenyCustomRoutingTrafficOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DenyCustomRoutingTraffic API operation for AWS Global Accelerator.
//
// Specify the Amazon EC2 instance (destination) IP addresses and ports for
// a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator.
// You can deny traffic to all destinations in the VPC endpoint, or deny traffic
// to a specified list of destination IP addresses and ports. Note that you
// cannot specify IP addresses or ports outside of the range that you configured
// for the endpoint group.
//
// After you make changes, you can verify that the updates are complete by checking
// the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DenyCustomRoutingTraffic for usage and error information.
//
// Returned Error Types:
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic
func (c *GlobalAccelerator) DenyCustomRoutingTraffic(input *DenyCustomRoutingTrafficInput) (*DenyCustomRoutingTrafficOutput, error) {
	req, out := c.DenyCustomRoutingTrafficRequest(input)
	return out, req.Send()
}

// DenyCustomRoutingTrafficWithContext is the same as DenyCustomRoutingTraffic with the addition of
// the ability to pass a context and additional request options.
//
// See DenyCustomRoutingTraffic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DenyCustomRoutingTrafficWithContext(ctx aws.Context, input *DenyCustomRoutingTrafficInput, opts ...request.Option) (*DenyCustomRoutingTrafficOutput, error) {
	req, out := c.DenyCustomRoutingTrafficRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionByoipCidr = "DeprovisionByoipCidr"

// DeprovisionByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionByoipCidr for more information on using the DeprovisionByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeprovisionByoipCidrRequest method.
//	req, resp := client.DeprovisionByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr
func (c *GlobalAccelerator) DeprovisionByoipCidrRequest(input *DeprovisionByoipCidrInput) (req *request.Request, output *DeprovisionByoipCidrOutput) {
	op := &request.Operation{
		Name:       opDeprovisionByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionByoipCidrInput{}
	}

	output = &DeprovisionByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionByoipCidr API operation for AWS Global Accelerator.
//
// Releases the specified address range that you provisioned to use with your
// Amazon Web Services resources through bring your own IP addresses (BYOIP)
// and deletes the corresponding address pool.
//
// Before you can release an address range, you must stop advertising it by
// using WithdrawByoipCidr (https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html)
// and you must not have any accelerators that are using static IP addresses
// allocated from its address range.
//
// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeprovisionByoipCidr for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - ByoipCidrNotFoundException
//     The CIDR that you specified was not found or is incorrect.
//
//   - IncorrectCidrStateException
//     The CIDR that you specified is not valid for this action. For example, the
//     state of the CIDR might be incorrect for this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr
func (c *GlobalAccelerator) DeprovisionByoipCidr(input *DeprovisionByoipCidrInput) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	return out, req.Send()
}

// DeprovisionByoipCidrWithContext is the same as DeprovisionByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeprovisionByoipCidrWithContext(ctx aws.Context, input *DeprovisionByoipCidrInput, opts ...request.Option) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccelerator = "DescribeAccelerator"

// DescribeAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccelerator for more information on using the DescribeAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAcceleratorRequest method.
//	req, resp := client.DescribeAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator
func (c *GlobalAccelerator) DescribeAcceleratorRequest(input *DescribeAcceleratorInput) (req *request.Request, output *DescribeAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDescribeAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAcceleratorInput{}
	}

	output = &DescribeAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccelerator API operation for AWS Global Accelerator.
//
// Describe an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator
func (c *GlobalAccelerator) DescribeAccelerator(input *DescribeAcceleratorInput) (*DescribeAcceleratorOutput, error) {
	req, out := c.DescribeAcceleratorRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorWithContext is the same as DescribeAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeAcceleratorWithContext(ctx aws.Context, input *DescribeAcceleratorInput, opts ...request.Option) (*DescribeAcceleratorOutput, error) {
	req, out := c.DescribeAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAcceleratorAttributes = "DescribeAcceleratorAttributes"

// DescribeAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAcceleratorAttributes for more information on using the DescribeAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAcceleratorAttributesRequest method.
//	req, resp := client.DescribeAcceleratorAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes
func (c *GlobalAccelerator) DescribeAcceleratorAttributesRequest(input *DescribeAcceleratorAttributesInput) (req *request.Request, output *DescribeAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAcceleratorAttributesInput{}
	}

	output = &DescribeAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Describe the attributes of an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes
func (c *GlobalAccelerator) DescribeAcceleratorAttributes(input *DescribeAcceleratorAttributesInput) (*DescribeAcceleratorAttributesOutput, error) {
	req, out := c.DescribeAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorAttributesWithContext is the same as DescribeAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeAcceleratorAttributesWithContext(ctx aws.Context, input *DescribeAcceleratorAttributesInput, opts ...request.Option) (*DescribeAcceleratorAttributesOutput, error) {
	req, out := c.DescribeAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCrossAccountAttachment = "DescribeCrossAccountAttachment"

// DescribeCrossAccountAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCrossAccountAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCrossAccountAttachment for more information on using the DescribeCrossAccountAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCrossAccountAttachmentRequest method.
//	req, resp := client.DescribeCrossAccountAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCrossAccountAttachment
func (c *GlobalAccelerator) DescribeCrossAccountAttachmentRequest(input *DescribeCrossAccountAttachmentInput) (req *request.Request, output *DescribeCrossAccountAttachmentOutput) {
	op := &request.Operation{
		Name:       opDescribeCrossAccountAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCrossAccountAttachmentInput{}
	}

	output = &DescribeCrossAccountAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCrossAccountAttachment API operation for AWS Global Accelerator.
//
// Gets configuration information about a cross-account attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeCrossAccountAttachment for usage and error information.
//
// Returned Error Types:
//
//   - AttachmentNotFoundException
//     No cross-account attachment was found.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCrossAccountAttachment
func (c *GlobalAccelerator) DescribeCrossAccountAttachment(input *DescribeCrossAccountAttachmentInput) (*DescribeCrossAccountAttachmentOutput, error) {
	req, out := c.DescribeCrossAccountAttachmentRequest(input)
	return out, req.Send()
}

// DescribeCrossAccountAttachmentWithContext is the same as DescribeCrossAccountAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCrossAccountAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeCrossAccountAttachmentWithContext(ctx aws.Context, input *DescribeCrossAccountAttachmentInput, opts ...request.Option) (*DescribeCrossAccountAttachmentOutput, error) {
	req, out := c.DescribeCrossAccountAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomRoutingAccelerator = "DescribeCustomRoutingAccelerator"

// DescribeCustomRoutingAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomRoutingAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomRoutingAccelerator for more information on using the DescribeCustomRoutingAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomRoutingAcceleratorRequest method.
//	req, resp := client.DescribeCustomRoutingAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator
func (c *GlobalAccelerator) DescribeCustomRoutingAcceleratorRequest(input *DescribeCustomRoutingAcceleratorInput) (req *request.Request, output *DescribeCustomRoutingAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomRoutingAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomRoutingAcceleratorInput{}
	}

	output = &DescribeCustomRoutingAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomRoutingAccelerator API operation for AWS Global Accelerator.
//
// Describe a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeCustomRoutingAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator
func (c *GlobalAccelerator) DescribeCustomRoutingAccelerator(input *DescribeCustomRoutingAcceleratorInput) (*DescribeCustomRoutingAcceleratorOutput, error) {
	req, out := c.DescribeCustomRoutingAcceleratorRequest(input)
	return out, req.Send()
}

// DescribeCustomRoutingAcceleratorWithContext is the same as DescribeCustomRoutingAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomRoutingAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeCustomRoutingAcceleratorWithContext(ctx aws.Context, input *DescribeCustomRoutingAcceleratorInput, opts ...request.Option) (*DescribeCustomRoutingAcceleratorOutput, error) {
	req, out := c.DescribeCustomRoutingAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomRoutingAcceleratorAttributes = "DescribeCustomRoutingAcceleratorAttributes"

// DescribeCustomRoutingAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomRoutingAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomRoutingAcceleratorAttributes for more information on using the DescribeCustomRoutingAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomRoutingAcceleratorAttributesRequest method.
//	req, resp := client.DescribeCustomRoutingAcceleratorAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes
func (c *GlobalAccelerator) DescribeCustomRoutingAcceleratorAttributesRequest(input *DescribeCustomRoutingAcceleratorAttributesInput) (req *request.Request, output *DescribeCustomRoutingAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomRoutingAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomRoutingAcceleratorAttributesInput{}
	}

	output = &DescribeCustomRoutingAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomRoutingAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Describe the attributes of a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeCustomRoutingAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes
func (c *GlobalAccelerator) DescribeCustomRoutingAcceleratorAttributes(input *DescribeCustomRoutingAcceleratorAttributesInput) (*DescribeCustomRoutingAcceleratorAttributesOutput, error) {
	req, out := c.DescribeCustomRoutingAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// DescribeCustomRoutingAcceleratorAttributesWithContext is the same as DescribeCustomRoutingAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomRoutingAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeCustomRoutingAcceleratorAttributesWithContext(ctx aws.Context, input *DescribeCustomRoutingAcceleratorAttributesInput, opts ...request.Option) (*DescribeCustomRoutingAcceleratorAttributesOutput, error) {
	req, out := c.DescribeCustomRoutingAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomRoutingEndpointGroup = "DescribeCustomRoutingEndpointGroup"

// DescribeCustomRoutingEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomRoutingEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomRoutingEndpointGroup for more information on using the DescribeCustomRoutingEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomRoutingEndpointGroupRequest method.
//	req, resp := client.DescribeCustomRoutingEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup
func (c *GlobalAccelerator) DescribeCustomRoutingEndpointGroupRequest(input *DescribeCustomRoutingEndpointGroupInput) (req *request.Request, output *DescribeCustomRoutingEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomRoutingEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomRoutingEndpointGroupInput{}
	}

	output = &DescribeCustomRoutingEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomRoutingEndpointGroup API operation for AWS Global Accelerator.
//
// Describe an endpoint group for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeCustomRoutingEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup
func (c *GlobalAccelerator) DescribeCustomRoutingEndpointGroup(input *DescribeCustomRoutingEndpointGroupInput) (*DescribeCustomRoutingEndpointGroupOutput, error) {
	req, out := c.DescribeCustomRoutingEndpointGroupRequest(input)
	return out, req.Send()
}

// DescribeCustomRoutingEndpointGroupWithContext is the same as DescribeCustomRoutingEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomRoutingEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeCustomRoutingEndpointGroupWithContext(ctx aws.Context, input *DescribeCustomRoutingEndpointGroupInput, opts ...request.Option) (*DescribeCustomRoutingEndpointGroupOutput, error) {
	req, out := c.DescribeCustomRoutingEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomRoutingListener = "DescribeCustomRoutingListener"

// DescribeCustomRoutingListenerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomRoutingListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomRoutingListener for more information on using the DescribeCustomRoutingListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomRoutingListenerRequest method.
//	req, resp := client.DescribeCustomRoutingListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener
func (c *GlobalAccelerator) DescribeCustomRoutingListenerRequest(input *DescribeCustomRoutingListenerInput) (req *request.Request, output *DescribeCustomRoutingListenerOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomRoutingListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomRoutingListenerInput{}
	}

	output = &DescribeCustomRoutingListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomRoutingListener API operation for AWS Global Accelerator.
//
// The description of a listener for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeCustomRoutingListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener
func (c *GlobalAccelerator) DescribeCustomRoutingListener(input *DescribeCustomRoutingListenerInput) (*DescribeCustomRoutingListenerOutput, error) {
	req, out := c.DescribeCustomRoutingListenerRequest(input)
	return out, req.Send()
}

// DescribeCustomRoutingListenerWithContext is the same as DescribeCustomRoutingListener with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomRoutingListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeCustomRoutingListenerWithContext(ctx aws.Context, input *DescribeCustomRoutingListenerInput, opts ...request.Option) (*DescribeCustomRoutingListenerOutput, error) {
	req, out := c.DescribeCustomRoutingListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpointGroup = "DescribeEndpointGroup"

// DescribeEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointGroup for more information on using the DescribeEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointGroupRequest method.
//	req, resp := client.DescribeEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup
func (c *GlobalAccelerator) DescribeEndpointGroupRequest(input *DescribeEndpointGroupInput) (req *request.Request, output *DescribeEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointGroupInput{}
	}

	output = &DescribeEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointGroup API operation for AWS Global Accelerator.
//
// Describe an endpoint group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup
func (c *GlobalAccelerator) DescribeEndpointGroup(input *DescribeEndpointGroupInput) (*DescribeEndpointGroupOutput, error) {
	req, out := c.DescribeEndpointGroupRequest(input)
	return out, req.Send()
}

// DescribeEndpointGroupWithContext is the same as DescribeEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeEndpointGroupWithContext(ctx aws.Context, input *DescribeEndpointGroupInput, opts ...request.Option) (*DescribeEndpointGroupOutput, error) {
	req, out := c.DescribeEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeListener = "DescribeListener"

// DescribeListenerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeListener for more information on using the DescribeListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeListenerRequest method.
//	req, resp := client.DescribeListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener
func (c *GlobalAccelerator) DescribeListenerRequest(input *DescribeListenerInput) (req *request.Request, output *DescribeListenerOutput) {
	op := &request.Operation{
		Name:       opDescribeListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeListenerInput{}
	}

	output = &DescribeListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeListener API operation for AWS Global Accelerator.
//
// Describe a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener
func (c *GlobalAccelerator) DescribeListener(input *DescribeListenerInput) (*DescribeListenerOutput, error) {
	req, out := c.DescribeListenerRequest(input)
	return out, req.Send()
}

// DescribeListenerWithContext is the same as DescribeListener with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeListenerWithContext(ctx aws.Context, input *DescribeListenerInput, opts ...request.Option) (*DescribeListenerOutput, error) {
	req, out := c.DescribeListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccelerators = "ListAccelerators"

// ListAcceleratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccelerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccelerators for more information on using the ListAccelerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAcceleratorsRequest method.
//	req, resp := client.ListAcceleratorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators
func (c *GlobalAccelerator) ListAcceleratorsRequest(input *ListAcceleratorsInput) (req *request.Request, output *ListAcceleratorsOutput) {
	op := &request.Operation{
		Name:       opListAccelerators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAcceleratorsInput{}
	}

	output = &ListAcceleratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccelerators API operation for AWS Global Accelerator.
//
// List the accelerators for an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListAccelerators for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators
func (c *GlobalAccelerator) ListAccelerators(input *ListAcceleratorsInput) (*ListAcceleratorsOutput, error) {
	req, out := c.ListAcceleratorsRequest(input)
	return out, req.Send()
}

// ListAcceleratorsWithContext is the same as ListAccelerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccelerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListAcceleratorsWithContext(ctx aws.Context, input *ListAcceleratorsInput, opts ...request.Option) (*ListAcceleratorsOutput, error) {
	req, out := c.ListAcceleratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAcceleratorsPages iterates over the pages of a ListAccelerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccelerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccelerators operation.
//	pageNum := 0
//	err := client.ListAcceleratorsPages(params,
//	    func(page *globalaccelerator.ListAcceleratorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListAcceleratorsPages(input *ListAcceleratorsInput, fn func(*ListAcceleratorsOutput, bool) bool) error {
	return c.ListAcceleratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAcceleratorsPagesWithContext same as ListAcceleratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListAcceleratorsPagesWithContext(ctx aws.Context, input *ListAcceleratorsInput, fn func(*ListAcceleratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAcceleratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAcceleratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAcceleratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListByoipCidrs = "ListByoipCidrs"

// ListByoipCidrsRequest generates a "aws/request.Request" representing the
// client's request for the ListByoipCidrs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListByoipCidrs for more information on using the ListByoipCidrs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListByoipCidrsRequest method.
//	req, resp := client.ListByoipCidrsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs
func (c *GlobalAccelerator) ListByoipCidrsRequest(input *ListByoipCidrsInput) (req *request.Request, output *ListByoipCidrsOutput) {
	op := &request.Operation{
		Name:       opListByoipCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListByoipCidrsInput{}
	}

	output = &ListByoipCidrsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListByoipCidrs API operation for AWS Global Accelerator.
//
// Lists the IP address ranges that were specified in calls to ProvisionByoipCidr
// (https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html),
// including the current state and a history of state changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListByoipCidrs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs
func (c *GlobalAccelerator) ListByoipCidrs(input *ListByoipCidrsInput) (*ListByoipCidrsOutput, error) {
	req, out := c.ListByoipCidrsRequest(input)
	return out, req.Send()
}

// ListByoipCidrsWithContext is the same as ListByoipCidrs with the addition of
// the ability to pass a context and additional request options.
//
// See ListByoipCidrs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListByoipCidrsWithContext(ctx aws.Context, input *ListByoipCidrsInput, opts ...request.Option) (*ListByoipCidrsOutput, error) {
	req, out := c.ListByoipCidrsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListByoipCidrsPages iterates over the pages of a ListByoipCidrs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListByoipCidrs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListByoipCidrs operation.
//	pageNum := 0
//	err := client.ListByoipCidrsPages(params,
//	    func(page *globalaccelerator.ListByoipCidrsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListByoipCidrsPages(input *ListByoipCidrsInput, fn func(*ListByoipCidrsOutput, bool) bool) error {
	return c.ListByoipCidrsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListByoipCidrsPagesWithContext same as ListByoipCidrsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListByoipCidrsPagesWithContext(ctx aws.Context, input *ListByoipCidrsInput, fn func(*ListByoipCidrsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListByoipCidrsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListByoipCidrsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListByoipCidrsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCrossAccountAttachments = "ListCrossAccountAttachments"

// ListCrossAccountAttachmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListCrossAccountAttachments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrossAccountAttachments for more information on using the ListCrossAccountAttachments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCrossAccountAttachmentsRequest method.
//	req, resp := client.ListCrossAccountAttachmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountAttachments
func (c *GlobalAccelerator) ListCrossAccountAttachmentsRequest(input *ListCrossAccountAttachmentsInput) (req *request.Request, output *ListCrossAccountAttachmentsOutput) {
	op := &request.Operation{
		Name:       opListCrossAccountAttachments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCrossAccountAttachmentsInput{}
	}

	output = &ListCrossAccountAttachmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrossAccountAttachments API operation for AWS Global Accelerator.
//
// List the cross-account attachments that have been created in Global Accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCrossAccountAttachments for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountAttachments
func (c *GlobalAccelerator) ListCrossAccountAttachments(input *ListCrossAccountAttachmentsInput) (*ListCrossAccountAttachmentsOutput, error) {
	req, out := c.ListCrossAccountAttachmentsRequest(input)
	return out, req.Send()
}

// ListCrossAccountAttachmentsWithContext is the same as ListCrossAccountAttachments with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrossAccountAttachments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCrossAccountAttachmentsWithContext(ctx aws.Context, input *ListCrossAccountAttachmentsInput, opts ...request.Option) (*ListCrossAccountAttachmentsOutput, error) {
	req, out := c.ListCrossAccountAttachmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCrossAccountAttachmentsPages iterates over the pages of a ListCrossAccountAttachments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCrossAccountAttachments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCrossAccountAttachments operation.
//	pageNum := 0
//	err := client.ListCrossAccountAttachmentsPages(params,
//	    func(page *globalaccelerator.ListCrossAccountAttachmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCrossAccountAttachmentsPages(input *ListCrossAccountAttachmentsInput, fn func(*ListCrossAccountAttachmentsOutput, bool) bool) error {
	return c.ListCrossAccountAttachmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCrossAccountAttachmentsPagesWithContext same as ListCrossAccountAttachmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCrossAccountAttachmentsPagesWithContext(ctx aws.Context, input *ListCrossAccountAttachmentsInput, fn func(*ListCrossAccountAttachmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCrossAccountAttachmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCrossAccountAttachmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCrossAccountAttachmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCrossAccountResourceAccounts = "ListCrossAccountResourceAccounts"

// ListCrossAccountResourceAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListCrossAccountResourceAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrossAccountResourceAccounts for more information on using the ListCrossAccountResourceAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCrossAccountResourceAccountsRequest method.
//	req, resp := client.ListCrossAccountResourceAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResourceAccounts
func (c *GlobalAccelerator) ListCrossAccountResourceAccountsRequest(input *ListCrossAccountResourceAccountsInput) (req *request.Request, output *ListCrossAccountResourceAccountsOutput) {
	op := &request.Operation{
		Name:       opListCrossAccountResourceAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCrossAccountResourceAccountsInput{}
	}

	output = &ListCrossAccountResourceAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrossAccountResourceAccounts API operation for AWS Global Accelerator.
//
// List the accounts that have cross-account resources.
//
// For more information, see Working with cross-account attachments and resources
// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCrossAccountResourceAccounts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResourceAccounts
func (c *GlobalAccelerator) ListCrossAccountResourceAccounts(input *ListCrossAccountResourceAccountsInput) (*ListCrossAccountResourceAccountsOutput, error) {
	req, out := c.ListCrossAccountResourceAccountsRequest(input)
	return out, req.Send()
}

// ListCrossAccountResourceAccountsWithContext is the same as ListCrossAccountResourceAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrossAccountResourceAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCrossAccountResourceAccountsWithContext(ctx aws.Context, input *ListCrossAccountResourceAccountsInput, opts ...request.Option) (*ListCrossAccountResourceAccountsOutput, error) {
	req, out := c.ListCrossAccountResourceAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCrossAccountResources = "ListCrossAccountResources"

// ListCrossAccountResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListCrossAccountResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrossAccountResources for more information on using the ListCrossAccountResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCrossAccountResourcesRequest method.
//	req, resp := client.ListCrossAccountResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResources
func (c *GlobalAccelerator) ListCrossAccountResourcesRequest(input *ListCrossAccountResourcesInput) (req *request.Request, output *ListCrossAccountResourcesOutput) {
	op := &request.Operation{
		Name:       opListCrossAccountResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCrossAccountResourcesInput{}
	}

	output = &ListCrossAccountResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrossAccountResources API operation for AWS Global Accelerator.
//
// List the cross-account resources available to work with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCrossAccountResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResources
func (c *GlobalAccelerator) ListCrossAccountResources(input *ListCrossAccountResourcesInput) (*ListCrossAccountResourcesOutput, error) {
	req, out := c.ListCrossAccountResourcesRequest(input)
	return out, req.Send()
}

// ListCrossAccountResourcesWithContext is the same as ListCrossAccountResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrossAccountResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCrossAccountResourcesWithContext(ctx aws.Context, input *ListCrossAccountResourcesInput, opts ...request.Option) (*ListCrossAccountResourcesOutput, error) {
	req, out := c.ListCrossAccountResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCrossAccountResourcesPages iterates over the pages of a ListCrossAccountResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCrossAccountResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCrossAccountResources operation.
//	pageNum := 0
//	err := client.ListCrossAccountResourcesPages(params,
//	    func(page *globalaccelerator.ListCrossAccountResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCrossAccountResourcesPages(input *ListCrossAccountResourcesInput, fn func(*ListCrossAccountResourcesOutput, bool) bool) error {
	return c.ListCrossAccountResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCrossAccountResourcesPagesWithContext same as ListCrossAccountResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCrossAccountResourcesPagesWithContext(ctx aws.Context, input *ListCrossAccountResourcesInput, fn func(*ListCrossAccountResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCrossAccountResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCrossAccountResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCrossAccountResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomRoutingAccelerators = "ListCustomRoutingAccelerators"

// ListCustomRoutingAcceleratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomRoutingAccelerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomRoutingAccelerators for more information on using the ListCustomRoutingAccelerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomRoutingAcceleratorsRequest method.
//	req, resp := client.ListCustomRoutingAcceleratorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators
func (c *GlobalAccelerator) ListCustomRoutingAcceleratorsRequest(input *ListCustomRoutingAcceleratorsInput) (req *request.Request, output *ListCustomRoutingAcceleratorsOutput) {
	op := &request.Operation{
		Name:       opListCustomRoutingAccelerators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomRoutingAcceleratorsInput{}
	}

	output = &ListCustomRoutingAcceleratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomRoutingAccelerators API operation for AWS Global Accelerator.
//
// List the custom routing accelerators for an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCustomRoutingAccelerators for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators
func (c *GlobalAccelerator) ListCustomRoutingAccelerators(input *ListCustomRoutingAcceleratorsInput) (*ListCustomRoutingAcceleratorsOutput, error) {
	req, out := c.ListCustomRoutingAcceleratorsRequest(input)
	return out, req.Send()
}

// ListCustomRoutingAcceleratorsWithContext is the same as ListCustomRoutingAccelerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomRoutingAccelerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingAcceleratorsWithContext(ctx aws.Context, input *ListCustomRoutingAcceleratorsInput, opts ...request.Option) (*ListCustomRoutingAcceleratorsOutput, error) {
	req, out := c.ListCustomRoutingAcceleratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomRoutingAcceleratorsPages iterates over the pages of a ListCustomRoutingAccelerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomRoutingAccelerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomRoutingAccelerators operation.
//	pageNum := 0
//	err := client.ListCustomRoutingAcceleratorsPages(params,
//	    func(page *globalaccelerator.ListCustomRoutingAcceleratorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCustomRoutingAcceleratorsPages(input *ListCustomRoutingAcceleratorsInput, fn func(*ListCustomRoutingAcceleratorsOutput, bool) bool) error {
	return c.ListCustomRoutingAcceleratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomRoutingAcceleratorsPagesWithContext same as ListCustomRoutingAcceleratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingAcceleratorsPagesWithContext(ctx aws.Context, input *ListCustomRoutingAcceleratorsInput, fn func(*ListCustomRoutingAcceleratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomRoutingAcceleratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomRoutingAcceleratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomRoutingAcceleratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomRoutingEndpointGroups = "ListCustomRoutingEndpointGroups"

// ListCustomRoutingEndpointGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomRoutingEndpointGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomRoutingEndpointGroups for more information on using the ListCustomRoutingEndpointGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomRoutingEndpointGroupsRequest method.
//	req, resp := client.ListCustomRoutingEndpointGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups
func (c *GlobalAccelerator) ListCustomRoutingEndpointGroupsRequest(input *ListCustomRoutingEndpointGroupsInput) (req *request.Request, output *ListCustomRoutingEndpointGroupsOutput) {
	op := &request.Operation{
		Name:       opListCustomRoutingEndpointGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomRoutingEndpointGroupsInput{}
	}

	output = &ListCustomRoutingEndpointGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomRoutingEndpointGroups API operation for AWS Global Accelerator.
//
// List the endpoint groups that are associated with a listener for a custom
// routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCustomRoutingEndpointGroups for usage and error information.
//
// Returned Error Types:
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups
func (c *GlobalAccelerator) ListCustomRoutingEndpointGroups(input *ListCustomRoutingEndpointGroupsInput) (*ListCustomRoutingEndpointGroupsOutput, error) {
	req, out := c.ListCustomRoutingEndpointGroupsRequest(input)
	return out, req.Send()
}

// ListCustomRoutingEndpointGroupsWithContext is the same as ListCustomRoutingEndpointGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomRoutingEndpointGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingEndpointGroupsWithContext(ctx aws.Context, input *ListCustomRoutingEndpointGroupsInput, opts ...request.Option) (*ListCustomRoutingEndpointGroupsOutput, error) {
	req, out := c.ListCustomRoutingEndpointGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomRoutingEndpointGroupsPages iterates over the pages of a ListCustomRoutingEndpointGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomRoutingEndpointGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomRoutingEndpointGroups operation.
//	pageNum := 0
//	err := client.ListCustomRoutingEndpointGroupsPages(params,
//	    func(page *globalaccelerator.ListCustomRoutingEndpointGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCustomRoutingEndpointGroupsPages(input *ListCustomRoutingEndpointGroupsInput, fn func(*ListCustomRoutingEndpointGroupsOutput, bool) bool) error {
	return c.ListCustomRoutingEndpointGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomRoutingEndpointGroupsPagesWithContext same as ListCustomRoutingEndpointGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingEndpointGroupsPagesWithContext(ctx aws.Context, input *ListCustomRoutingEndpointGroupsInput, fn func(*ListCustomRoutingEndpointGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomRoutingEndpointGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomRoutingEndpointGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomRoutingEndpointGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomRoutingListeners = "ListCustomRoutingListeners"

// ListCustomRoutingListenersRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomRoutingListeners operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomRoutingListeners for more information on using the ListCustomRoutingListeners
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomRoutingListenersRequest method.
//	req, resp := client.ListCustomRoutingListenersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners
func (c *GlobalAccelerator) ListCustomRoutingListenersRequest(input *ListCustomRoutingListenersInput) (req *request.Request, output *ListCustomRoutingListenersOutput) {
	op := &request.Operation{
		Name:       opListCustomRoutingListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomRoutingListenersInput{}
	}

	output = &ListCustomRoutingListenersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomRoutingListeners API operation for AWS Global Accelerator.
//
// List the listeners for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCustomRoutingListeners for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners
func (c *GlobalAccelerator) ListCustomRoutingListeners(input *ListCustomRoutingListenersInput) (*ListCustomRoutingListenersOutput, error) {
	req, out := c.ListCustomRoutingListenersRequest(input)
	return out, req.Send()
}

// ListCustomRoutingListenersWithContext is the same as ListCustomRoutingListeners with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomRoutingListeners for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingListenersWithContext(ctx aws.Context, input *ListCustomRoutingListenersInput, opts ...request.Option) (*ListCustomRoutingListenersOutput, error) {
	req, out := c.ListCustomRoutingListenersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomRoutingListenersPages iterates over the pages of a ListCustomRoutingListeners operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomRoutingListeners method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomRoutingListeners operation.
//	pageNum := 0
//	err := client.ListCustomRoutingListenersPages(params,
//	    func(page *globalaccelerator.ListCustomRoutingListenersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCustomRoutingListenersPages(input *ListCustomRoutingListenersInput, fn func(*ListCustomRoutingListenersOutput, bool) bool) error {
	return c.ListCustomRoutingListenersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomRoutingListenersPagesWithContext same as ListCustomRoutingListenersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingListenersPagesWithContext(ctx aws.Context, input *ListCustomRoutingListenersInput, fn func(*ListCustomRoutingListenersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomRoutingListenersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomRoutingListenersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomRoutingListenersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomRoutingPortMappings = "ListCustomRoutingPortMappings"

// ListCustomRoutingPortMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomRoutingPortMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomRoutingPortMappings for more information on using the ListCustomRoutingPortMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomRoutingPortMappingsRequest method.
//	req, resp := client.ListCustomRoutingPortMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsRequest(input *ListCustomRoutingPortMappingsInput) (req *request.Request, output *ListCustomRoutingPortMappingsOutput) {
	op := &request.Operation{
		Name:       opListCustomRoutingPortMappings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomRoutingPortMappingsInput{}
	}

	output = &ListCustomRoutingPortMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomRoutingPortMappings API operation for AWS Global Accelerator.
//
// Provides a complete mapping from the public accelerator IP address and port
// to destination EC2 instance IP addresses and ports in the virtual public
// cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet
// endpoint that you add, Global Accelerator creates a new static port mapping
// for the accelerator. The port mappings don't change after Global Accelerator
// generates them, so you can retrieve and cache the full mapping on your servers.
//
// If you remove a subnet from your accelerator, Global Accelerator removes
// (reclaims) the port mappings. If you add a subnet to your accelerator, Global
// Accelerator creates new port mappings (the existing ones don't change). If
// you add or remove EC2 instances in your subnet, the port mappings don't change,
// because the mappings are created when you add the subnet to Global Accelerator.
//
// The mappings also include a flag for each destination denoting which destination
// IP addresses and ports are allowed or denied traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCustomRoutingPortMappings for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings
func (c *GlobalAccelerator) ListCustomRoutingPortMappings(input *ListCustomRoutingPortMappingsInput) (*ListCustomRoutingPortMappingsOutput, error) {
	req, out := c.ListCustomRoutingPortMappingsRequest(input)
	return out, req.Send()
}

// ListCustomRoutingPortMappingsWithContext is the same as ListCustomRoutingPortMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomRoutingPortMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsWithContext(ctx aws.Context, input *ListCustomRoutingPortMappingsInput, opts ...request.Option) (*ListCustomRoutingPortMappingsOutput, error) {
	req, out := c.ListCustomRoutingPortMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomRoutingPortMappingsPages iterates over the pages of a ListCustomRoutingPortMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomRoutingPortMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomRoutingPortMappings operation.
//	pageNum := 0
//	err := client.ListCustomRoutingPortMappingsPages(params,
//	    func(page *globalaccelerator.ListCustomRoutingPortMappingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsPages(input *ListCustomRoutingPortMappingsInput, fn func(*ListCustomRoutingPortMappingsOutput, bool) bool) error {
	return c.ListCustomRoutingPortMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomRoutingPortMappingsPagesWithContext same as ListCustomRoutingPortMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsPagesWithContext(ctx aws.Context, input *ListCustomRoutingPortMappingsInput, fn func(*ListCustomRoutingPortMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomRoutingPortMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomRoutingPortMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomRoutingPortMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomRoutingPortMappingsByDestination = "ListCustomRoutingPortMappingsByDestination"

// ListCustomRoutingPortMappingsByDestinationRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomRoutingPortMappingsByDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomRoutingPortMappingsByDestination for more information on using the ListCustomRoutingPortMappingsByDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomRoutingPortMappingsByDestinationRequest method.
//	req, resp := client.ListCustomRoutingPortMappingsByDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsByDestinationRequest(input *ListCustomRoutingPortMappingsByDestinationInput) (req *request.Request, output *ListCustomRoutingPortMappingsByDestinationOutput) {
	op := &request.Operation{
		Name:       opListCustomRoutingPortMappingsByDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomRoutingPortMappingsByDestinationInput{}
	}

	output = &ListCustomRoutingPortMappingsByDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomRoutingPortMappingsByDestination API operation for AWS Global Accelerator.
//
// List the port mappings for a specific EC2 instance (destination) in a VPC
// subnet endpoint. The response is the mappings for one destination IP address.
// This is useful when your subnet endpoint has mappings that span multiple
// custom routing accelerators in your account, or for scenarios where you only
// want to list the port mappings for a specific destination instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListCustomRoutingPortMappingsByDestination for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - EndpointNotFoundException
//     The endpoint that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsByDestination(input *ListCustomRoutingPortMappingsByDestinationInput) (*ListCustomRoutingPortMappingsByDestinationOutput, error) {
	req, out := c.ListCustomRoutingPortMappingsByDestinationRequest(input)
	return out, req.Send()
}

// ListCustomRoutingPortMappingsByDestinationWithContext is the same as ListCustomRoutingPortMappingsByDestination with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomRoutingPortMappingsByDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsByDestinationWithContext(ctx aws.Context, input *ListCustomRoutingPortMappingsByDestinationInput, opts ...request.Option) (*ListCustomRoutingPortMappingsByDestinationOutput, error) {
	req, out := c.ListCustomRoutingPortMappingsByDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomRoutingPortMappingsByDestinationPages iterates over the pages of a ListCustomRoutingPortMappingsByDestination operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomRoutingPortMappingsByDestination method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomRoutingPortMappingsByDestination operation.
//	pageNum := 0
//	err := client.ListCustomRoutingPortMappingsByDestinationPages(params,
//	    func(page *globalaccelerator.ListCustomRoutingPortMappingsByDestinationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsByDestinationPages(input *ListCustomRoutingPortMappingsByDestinationInput, fn func(*ListCustomRoutingPortMappingsByDestinationOutput, bool) bool) error {
	return c.ListCustomRoutingPortMappingsByDestinationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomRoutingPortMappingsByDestinationPagesWithContext same as ListCustomRoutingPortMappingsByDestinationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListCustomRoutingPortMappingsByDestinationPagesWithContext(ctx aws.Context, input *ListCustomRoutingPortMappingsByDestinationInput, fn func(*ListCustomRoutingPortMappingsByDestinationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomRoutingPortMappingsByDestinationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomRoutingPortMappingsByDestinationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomRoutingPortMappingsByDestinationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpointGroups = "ListEndpointGroups"

// ListEndpointGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointGroups for more information on using the ListEndpointGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEndpointGroupsRequest method.
//	req, resp := client.ListEndpointGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups
func (c *GlobalAccelerator) ListEndpointGroupsRequest(input *ListEndpointGroupsInput) (req *request.Request, output *ListEndpointGroupsOutput) {
	op := &request.Operation{
		Name:       opListEndpointGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointGroupsInput{}
	}

	output = &ListEndpointGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointGroups API operation for AWS Global Accelerator.
//
// List the endpoint groups that are associated with a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListEndpointGroups for usage and error information.
//
// Returned Error Types:
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups
func (c *GlobalAccelerator) ListEndpointGroups(input *ListEndpointGroupsInput) (*ListEndpointGroupsOutput, error) {
	req, out := c.ListEndpointGroupsRequest(input)
	return out, req.Send()
}

// ListEndpointGroupsWithContext is the same as ListEndpointGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListEndpointGroupsWithContext(ctx aws.Context, input *ListEndpointGroupsInput, opts ...request.Option) (*ListEndpointGroupsOutput, error) {
	req, out := c.ListEndpointGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointGroupsPages iterates over the pages of a ListEndpointGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEndpointGroups operation.
//	pageNum := 0
//	err := client.ListEndpointGroupsPages(params,
//	    func(page *globalaccelerator.ListEndpointGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListEndpointGroupsPages(input *ListEndpointGroupsInput, fn func(*ListEndpointGroupsOutput, bool) bool) error {
	return c.ListEndpointGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointGroupsPagesWithContext same as ListEndpointGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListEndpointGroupsPagesWithContext(ctx aws.Context, input *ListEndpointGroupsInput, fn func(*ListEndpointGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListListeners = "ListListeners"

// ListListenersRequest generates a "aws/request.Request" representing the
// client's request for the ListListeners operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListListeners for more information on using the ListListeners
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListListenersRequest method.
//	req, resp := client.ListListenersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners
func (c *GlobalAccelerator) ListListenersRequest(input *ListListenersInput) (req *request.Request, output *ListListenersOutput) {
	op := &request.Operation{
		Name:       opListListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListListenersInput{}
	}

	output = &ListListenersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListListeners API operation for AWS Global Accelerator.
//
// List the listeners for an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListListeners for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InvalidNextTokenException
//     There isn't another item to return.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners
func (c *GlobalAccelerator) ListListeners(input *ListListenersInput) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	return out, req.Send()
}

// ListListenersWithContext is the same as ListListeners with the addition of
// the ability to pass a context and additional request options.
//
// See ListListeners for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListListenersWithContext(ctx aws.Context, input *ListListenersInput, opts ...request.Option) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListListenersPages iterates over the pages of a ListListeners operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListListeners method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListListeners operation.
//	pageNum := 0
//	err := client.ListListenersPages(params,
//	    func(page *globalaccelerator.ListListenersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GlobalAccelerator) ListListenersPages(input *ListListenersInput, fn func(*ListListenersOutput, bool) bool) error {
	return c.ListListenersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListListenersPagesWithContext same as ListListenersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListListenersPagesWithContext(ctx aws.Context, input *ListListenersInput, fn func(*ListListenersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListListenersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListListenersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListListenersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource
func (c *GlobalAccelerator) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Global Accelerator.
//
// List all tags for an accelerator.
//
// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource
func (c *GlobalAccelerator) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opProvisionByoipCidr = "ProvisionByoipCidr"

// ProvisionByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvisionByoipCidr for more information on using the ProvisionByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ProvisionByoipCidrRequest method.
//	req, resp := client.ProvisionByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr
func (c *GlobalAccelerator) ProvisionByoipCidrRequest(input *ProvisionByoipCidrInput) (req *request.Request, output *ProvisionByoipCidrOutput) {
	op := &request.Operation{
		Name:       opProvisionByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionByoipCidrInput{}
	}

	output = &ProvisionByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvisionByoipCidr API operation for AWS Global Accelerator.
//
// Provisions an IP address range to use with your Amazon Web Services resources
// through bring your own IP addresses (BYOIP) and creates a corresponding address
// pool. After the address range is provisioned, it is ready to be advertised
// using AdvertiseByoipCidr (https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html).
//
// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ProvisionByoipCidr for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - IncorrectCidrStateException
//     The CIDR that you specified is not valid for this action. For example, the
//     state of the CIDR might be incorrect for this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr
func (c *GlobalAccelerator) ProvisionByoipCidr(input *ProvisionByoipCidrInput) (*ProvisionByoipCidrOutput, error) {
	req, out := c.ProvisionByoipCidrRequest(input)
	return out, req.Send()
}

// ProvisionByoipCidrWithContext is the same as ProvisionByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See ProvisionByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ProvisionByoipCidrWithContext(ctx aws.Context, input *ProvisionByoipCidrInput, opts ...request.Option) (*ProvisionByoipCidrOutput, error) {
	req, out := c.ProvisionByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveCustomRoutingEndpoints = "RemoveCustomRoutingEndpoints"

// RemoveCustomRoutingEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveCustomRoutingEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveCustomRoutingEndpoints for more information on using the RemoveCustomRoutingEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveCustomRoutingEndpointsRequest method.
//	req, resp := client.RemoveCustomRoutingEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints
func (c *GlobalAccelerator) RemoveCustomRoutingEndpointsRequest(input *RemoveCustomRoutingEndpointsInput) (req *request.Request, output *RemoveCustomRoutingEndpointsOutput) {
	op := &request.Operation{
		Name:       opRemoveCustomRoutingEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveCustomRoutingEndpointsInput{}
	}

	output = &RemoveCustomRoutingEndpointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveCustomRoutingEndpoints API operation for AWS Global Accelerator.
//
// Remove endpoints from a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation RemoveCustomRoutingEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - EndpointNotFoundException
//     The endpoint that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - ConflictException
//     You can't use both of those options.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints
func (c *GlobalAccelerator) RemoveCustomRoutingEndpoints(input *RemoveCustomRoutingEndpointsInput) (*RemoveCustomRoutingEndpointsOutput, error) {
	req, out := c.RemoveCustomRoutingEndpointsRequest(input)
	return out, req.Send()
}

// RemoveCustomRoutingEndpointsWithContext is the same as RemoveCustomRoutingEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveCustomRoutingEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) RemoveCustomRoutingEndpointsWithContext(ctx aws.Context, input *RemoveCustomRoutingEndpointsInput, opts ...request.Option) (*RemoveCustomRoutingEndpointsOutput, error) {
	req, out := c.RemoveCustomRoutingEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveEndpoints = "RemoveEndpoints"

// RemoveEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveEndpoints for more information on using the RemoveEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveEndpointsRequest method.
//	req, resp := client.RemoveEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveEndpoints
func (c *GlobalAccelerator) RemoveEndpointsRequest(input *RemoveEndpointsInput) (req *request.Request, output *RemoveEndpointsOutput) {
	op := &request.Operation{
		Name:       opRemoveEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveEndpointsInput{}
	}

	output = &RemoveEndpointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveEndpoints API operation for AWS Global Accelerator.
//
// Remove endpoints from an endpoint group.
//
// The RemoveEndpoints API operation is the recommended option for removing
// endpoints. The alternative is to remove endpoints by updating an endpoint
// group by using the UpdateEndpointGroup (https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html)
// API operation. There are two advantages to using AddEndpoints to remove endpoints
// instead:
//
//   - It's more convenient, because you only need to specify the endpoints
//     that you want to remove. With the UpdateEndpointGroup API operation, you
//     must specify all of the endpoints in the endpoint group except the ones
//     that you want to remove from the group.
//
//   - It's faster, because Global Accelerator doesn't need to resolve any
//     endpoints. With the UpdateEndpointGroup API operation, Global Accelerator
//     must resolve all of the endpoints that remain in the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation RemoveEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - TransactionInProgressException
//     There's already a transaction in progress. Another transaction can't be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveEndpoints
func (c *GlobalAccelerator) RemoveEndpoints(input *RemoveEndpointsInput) (*RemoveEndpointsOutput, error) {
	req, out := c.RemoveEndpointsRequest(input)
	return out, req.Send()
}

// RemoveEndpointsWithContext is the same as RemoveEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) RemoveEndpointsWithContext(ctx aws.Context, input *RemoveEndpointsInput, opts ...request.Option) (*RemoveEndpointsOutput, error) {
	req, out := c.RemoveEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource
func (c *GlobalAccelerator) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Global Accelerator.
//
// Add tags to an accelerator resource.
//
// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource
func (c *GlobalAccelerator) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource
func (c *GlobalAccelerator) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Global Accelerator.
//
// Remove tags from a Global Accelerator resource. When you specify a tag key,
// the action removes both that key and its associated value. The operation
// succeeds even if you attempt to remove tags from an accelerator that was
// already removed.
//
// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource
func (c *GlobalAccelerator) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccelerator = "UpdateAccelerator"

// UpdateAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccelerator for more information on using the UpdateAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAcceleratorRequest method.
//	req, resp := client.UpdateAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator
func (c *GlobalAccelerator) UpdateAcceleratorRequest(input *UpdateAcceleratorInput) (req *request.Request, output *UpdateAcceleratorOutput) {
	op := &request.Operation{
		Name:       opUpdateAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAcceleratorInput{}
	}

	output = &UpdateAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccelerator API operation for AWS Global Accelerator.
//
// Update an accelerator to make changes, such as the following:
//
//   - Change the name of the accelerator.
//
//   - Disable the accelerator so that it no longer accepts or routes traffic,
//     or so that you can delete it.
//
//   - Enable the accelerator, if it is disabled.
//
//   - Change the IP address type to dual-stack if it is IPv4, or change the
//     IP address type to IPv4 if it's dual-stack.
//
// Be aware that static IP addresses remain assigned to your accelerator for
// as long as it exists, even if you disable the accelerator and it no longer
// accepts or routes traffic. However, when you delete the accelerator, you
// lose the static IP addresses that are assigned to it, so you can no longer
// route traffic by using them.
//
// Global Accelerator is a global service that supports endpoints in multiple
// Amazon Web Services Regions but you must specify the US West (Oregon) Region
// to create, update, or otherwise work with accelerators. That is, for example,
// specify --region us-west-2 on Amazon Web Services CLI commands.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator
func (c *GlobalAccelerator) UpdateAccelerator(input *UpdateAcceleratorInput) (*UpdateAcceleratorOutput, error) {
	req, out := c.UpdateAcceleratorRequest(input)
	return out, req.Send()
}

// UpdateAcceleratorWithContext is the same as UpdateAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateAcceleratorWithContext(ctx aws.Context, input *UpdateAcceleratorInput, opts ...request.Option) (*UpdateAcceleratorOutput, error) {
	req, out := c.UpdateAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAcceleratorAttributes = "UpdateAcceleratorAttributes"

// UpdateAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAcceleratorAttributes for more information on using the UpdateAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAcceleratorAttributesRequest method.
//	req, resp := client.UpdateAcceleratorAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes
func (c *GlobalAccelerator) UpdateAcceleratorAttributesRequest(input *UpdateAcceleratorAttributesInput) (req *request.Request, output *UpdateAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAcceleratorAttributesInput{}
	}

	output = &UpdateAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Update the attributes for an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes
func (c *GlobalAccelerator) UpdateAcceleratorAttributes(input *UpdateAcceleratorAttributesInput) (*UpdateAcceleratorAttributesOutput, error) {
	req, out := c.UpdateAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// UpdateAcceleratorAttributesWithContext is the same as UpdateAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateAcceleratorAttributesWithContext(ctx aws.Context, input *UpdateAcceleratorAttributesInput, opts ...request.Option) (*UpdateAcceleratorAttributesOutput, error) {
	req, out := c.UpdateAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrossAccountAttachment = "UpdateCrossAccountAttachment"

// UpdateCrossAccountAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrossAccountAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrossAccountAttachment for more information on using the UpdateCrossAccountAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCrossAccountAttachmentRequest method.
//	req, resp := client.UpdateCrossAccountAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCrossAccountAttachment
func (c *GlobalAccelerator) UpdateCrossAccountAttachmentRequest(input *UpdateCrossAccountAttachmentInput) (req *request.Request, output *UpdateCrossAccountAttachmentOutput) {
	op := &request.Operation{
		Name:       opUpdateCrossAccountAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrossAccountAttachmentInput{}
	}

	output = &UpdateCrossAccountAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCrossAccountAttachment API operation for AWS Global Accelerator.
//
// Update a cross-account attachment to add or remove principals or resources.
// When you update an attachment to remove a principal (account ID or accelerator)
// or a resource, Global Accelerator revokes the permission for specific resources.
//
// For more information, see Working with cross-account attachments and resources
// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateCrossAccountAttachment for usage and error information.
//
// Returned Error Types:
//
//   - AttachmentNotFoundException
//     No cross-account attachment was found.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - TransactionInProgressException
//     There's already a transaction in progress. Another transaction can't be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCrossAccountAttachment
func (c *GlobalAccelerator) UpdateCrossAccountAttachment(input *UpdateCrossAccountAttachmentInput) (*UpdateCrossAccountAttachmentOutput, error) {
	req, out := c.UpdateCrossAccountAttachmentRequest(input)
	return out, req.Send()
}

// UpdateCrossAccountAttachmentWithContext is the same as UpdateCrossAccountAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrossAccountAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateCrossAccountAttachmentWithContext(ctx aws.Context, input *UpdateCrossAccountAttachmentInput, opts ...request.Option) (*UpdateCrossAccountAttachmentOutput, error) {
	req, out := c.UpdateCrossAccountAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomRoutingAccelerator = "UpdateCustomRoutingAccelerator"

// UpdateCustomRoutingAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomRoutingAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomRoutingAccelerator for more information on using the UpdateCustomRoutingAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomRoutingAcceleratorRequest method.
//	req, resp := client.UpdateCustomRoutingAcceleratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator
func (c *GlobalAccelerator) UpdateCustomRoutingAcceleratorRequest(input *UpdateCustomRoutingAcceleratorInput) (req *request.Request, output *UpdateCustomRoutingAcceleratorOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomRoutingAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomRoutingAcceleratorInput{}
	}

	output = &UpdateCustomRoutingAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCustomRoutingAccelerator API operation for AWS Global Accelerator.
//
// Update a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateCustomRoutingAccelerator for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator
func (c *GlobalAccelerator) UpdateCustomRoutingAccelerator(input *UpdateCustomRoutingAcceleratorInput) (*UpdateCustomRoutingAcceleratorOutput, error) {
	req, out := c.UpdateCustomRoutingAcceleratorRequest(input)
	return out, req.Send()
}

// UpdateCustomRoutingAcceleratorWithContext is the same as UpdateCustomRoutingAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomRoutingAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateCustomRoutingAcceleratorWithContext(ctx aws.Context, input *UpdateCustomRoutingAcceleratorInput, opts ...request.Option) (*UpdateCustomRoutingAcceleratorOutput, error) {
	req, out := c.UpdateCustomRoutingAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomRoutingAcceleratorAttributes = "UpdateCustomRoutingAcceleratorAttributes"

// UpdateCustomRoutingAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomRoutingAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomRoutingAcceleratorAttributes for more information on using the UpdateCustomRoutingAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomRoutingAcceleratorAttributesRequest method.
//	req, resp := client.UpdateCustomRoutingAcceleratorAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes
func (c *GlobalAccelerator) UpdateCustomRoutingAcceleratorAttributesRequest(input *UpdateCustomRoutingAcceleratorAttributesInput) (req *request.Request, output *UpdateCustomRoutingAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomRoutingAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomRoutingAcceleratorAttributesInput{}
	}

	output = &UpdateCustomRoutingAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCustomRoutingAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Update the attributes for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateCustomRoutingAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//
//   - AcceleratorNotFoundException
//     The accelerator that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes
func (c *GlobalAccelerator) UpdateCustomRoutingAcceleratorAttributes(input *UpdateCustomRoutingAcceleratorAttributesInput) (*UpdateCustomRoutingAcceleratorAttributesOutput, error) {
	req, out := c.UpdateCustomRoutingAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// UpdateCustomRoutingAcceleratorAttributesWithContext is the same as UpdateCustomRoutingAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomRoutingAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateCustomRoutingAcceleratorAttributesWithContext(ctx aws.Context, input *UpdateCustomRoutingAcceleratorAttributesInput, opts ...request.Option) (*UpdateCustomRoutingAcceleratorAttributesOutput, error) {
	req, out := c.UpdateCustomRoutingAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomRoutingListener = "UpdateCustomRoutingListener"

// UpdateCustomRoutingListenerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomRoutingListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomRoutingListener for more information on using the UpdateCustomRoutingListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomRoutingListenerRequest method.
//	req, resp := client.UpdateCustomRoutingListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener
func (c *GlobalAccelerator) UpdateCustomRoutingListenerRequest(input *UpdateCustomRoutingListenerInput) (req *request.Request, output *UpdateCustomRoutingListenerOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomRoutingListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomRoutingListenerInput{}
	}

	output = &UpdateCustomRoutingListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCustomRoutingListener API operation for AWS Global Accelerator.
//
// Update a listener for a custom routing accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateCustomRoutingListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidPortRangeException
//     The port numbers that you specified are not valid numbers or are not unique
//     for this accelerator.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener
func (c *GlobalAccelerator) UpdateCustomRoutingListener(input *UpdateCustomRoutingListenerInput) (*UpdateCustomRoutingListenerOutput, error) {
	req, out := c.UpdateCustomRoutingListenerRequest(input)
	return out, req.Send()
}

// UpdateCustomRoutingListenerWithContext is the same as UpdateCustomRoutingListener with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomRoutingListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateCustomRoutingListenerWithContext(ctx aws.Context, input *UpdateCustomRoutingListenerInput, opts ...request.Option) (*UpdateCustomRoutingListenerOutput, error) {
	req, out := c.UpdateCustomRoutingListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointGroup = "UpdateEndpointGroup"

// UpdateEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointGroup for more information on using the UpdateEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEndpointGroupRequest method.
//	req, resp := client.UpdateEndpointGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup
func (c *GlobalAccelerator) UpdateEndpointGroupRequest(input *UpdateEndpointGroupInput) (req *request.Request, output *UpdateEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointGroupInput{}
	}

	output = &UpdateEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointGroup API operation for AWS Global Accelerator.
//
// Update an endpoint group. A resource must be valid and active when you add
// it as an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateEndpointGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - EndpointGroupNotFoundException
//     The endpoint group that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
//   - AccessDeniedException
//     You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup
func (c *GlobalAccelerator) UpdateEndpointGroup(input *UpdateEndpointGroupInput) (*UpdateEndpointGroupOutput, error) {
	req, out := c.UpdateEndpointGroupRequest(input)
	return out, req.Send()
}

// UpdateEndpointGroupWithContext is the same as UpdateEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateEndpointGroupWithContext(ctx aws.Context, input *UpdateEndpointGroupInput, opts ...request.Option) (*UpdateEndpointGroupOutput, error) {
	req, out := c.UpdateEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateListener = "UpdateListener"

// UpdateListenerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateListener for more information on using the UpdateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateListenerRequest method.
//	req, resp := client.UpdateListenerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener
func (c *GlobalAccelerator) UpdateListenerRequest(input *UpdateListenerInput) (req *request.Request, output *UpdateListenerOutput) {
	op := &request.Operation{
		Name:       opUpdateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateListenerInput{}
	}

	output = &UpdateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateListener API operation for AWS Global Accelerator.
//
// Update a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateListener for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - InvalidPortRangeException
//     The port numbers that you specified are not valid numbers or are not unique
//     for this accelerator.
//
//   - ListenerNotFoundException
//     The listener that you specified doesn't exist.
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - LimitExceededException
//     Processing your request would cause you to exceed an Global Accelerator limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener
func (c *GlobalAccelerator) UpdateListener(input *UpdateListenerInput) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	return out, req.Send()
}

// UpdateListenerWithContext is the same as UpdateListener with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateListenerWithContext(ctx aws.Context, input *UpdateListenerInput, opts ...request.Option) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opWithdrawByoipCidr = "WithdrawByoipCidr"

// WithdrawByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the WithdrawByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See WithdrawByoipCidr for more information on using the WithdrawByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the WithdrawByoipCidrRequest method.
//	req, resp := client.WithdrawByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr
func (c *GlobalAccelerator) WithdrawByoipCidrRequest(input *WithdrawByoipCidrInput) (req *request.Request, output *WithdrawByoipCidrOutput) {
	op := &request.Operation{
		Name:       opWithdrawByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &WithdrawByoipCidrInput{}
	}

	output = &WithdrawByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// WithdrawByoipCidr API operation for AWS Global Accelerator.
//
// Stops advertising an address range that is provisioned as an address pool.
// You can perform this operation at most once every 10 seconds, even if you
// specify different address ranges each time.
//
// It can take a few minutes before traffic to the specified addresses stops
// routing to Amazon Web Services because of propagation delays.
//
// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
// in the Global Accelerator Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation WithdrawByoipCidr for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceErrorException
//     There was an internal error for Global Accelerator.
//
//   - InvalidArgumentException
//     An argument that you specified is invalid.
//
//   - AccessDeniedException
//     You don't have access permission.
//
//   - ByoipCidrNotFoundException
//     The CIDR that you specified was not found or is incorrect.
//
//   - IncorrectCidrStateException
//     The CIDR that you specified is not valid for this action. For example, the
//     state of the CIDR might be incorrect for this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr
func (c *GlobalAccelerator) WithdrawByoipCidr(input *WithdrawByoipCidrInput) (*WithdrawByoipCidrOutput, error) {
	req, out := c.WithdrawByoipCidrRequest(input)
	return out, req.Send()
}

// WithdrawByoipCidrWithContext is the same as WithdrawByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See WithdrawByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) WithdrawByoipCidrWithContext(ctx aws.Context, input *WithdrawByoipCidrInput, opts ...request.Option) (*WithdrawByoipCidrOutput, error) {
	req, out := c.WithdrawByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An accelerator is a complex type that includes one or more listeners that
// process inbound connections and then direct traffic to one or more endpoint
// groups, each of which includes endpoints, such as load balancers.
type Accelerator struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator.
	AcceleratorArn *string `type:"string"`

	// The date and time that the accelerator was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Domain Name System (DNS) name that Global Accelerator creates that points
	// to an accelerator's static IPv4 addresses.
	//
	// The naming convention for the DNS name for an accelerator is the following:
	// A lowercase letter a, followed by a 16-bit random hex string, followed by
	// .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.
	//
	// If you have a dual-stack accelerator, you also have a second DNS name, DualStackDnsName,
	// that points to both the A record and the AAAA record for all four static
	// addresses for the accelerator: two IPv4 addresses and two IPv6 addresses.
	//
	// For more information about the default DNS name, see Support for DNS addressing
	// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html)
	// in the Global Accelerator Developer Guide.
	DnsName *string `type:"string"`

	// The Domain Name System (DNS) name that Global Accelerator creates that points
	// to a dual-stack accelerator's four static IP addresses: two IPv4 addresses
	// and two IPv6 addresses.
	//
	// The naming convention for the dual-stack DNS name is the following: A lowercase
	// letter a, followed by a 16-bit random hex string, followed by .dualstack.awsglobalaccelerator.com.
	// For example: a1234567890abcdef.dualstack.awsglobalaccelerator.com.
	//
	// Note: Global Accelerator also assigns a default DNS name, DnsName, to your
	// accelerator that points just to the static IPv4 addresses.
	//
	// For more information, see Support for DNS addressing in Global Accelerator
	// (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing)
	// in the Global Accelerator Developer Guide.
	DualStackDnsName *string `type:"string"`

	// Indicates whether the accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// A history of changes that you make to an accelerator in Global Accelerator.
	Events []*AcceleratorEvent `type:"list"`

	// The IP address type that an accelerator supports. For a standard accelerator,
	// the value can be IPV4 or DUAL_STACK.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The static IP addresses that Global Accelerator associates with the accelerator.
	IpSets []*IpSet `type:"list"`

	// The date and time that the accelerator was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the accelerator. The name must contain only alphanumeric characters
	// or hyphens (-), and must not begin or end with a hyphen.
	Name *string `type:"string"`

	// Describes the deployment status of the accelerator.
	Status *string `type:"string" enum:"AcceleratorStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Accelerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Accelerator) GoString() string {
	return s.String()
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *Accelerator) SetAcceleratorArn(v string) *Accelerator {
	s.AcceleratorArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Accelerator) SetCreatedTime(v time.Time) *Accelerator {
	s.CreatedTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *Accelerator) SetDnsName(v string) *Accelerator {
	s.DnsName = &v
	return s
}

// SetDualStackDnsName sets the DualStackDnsName field's value.
func (s *Accelerator) SetDualStackDnsName(v string) *Accelerator {
	s.DualStackDnsName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Accelerator) SetEnabled(v bool) *Accelerator {
	s.Enabled = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *Accelerator) SetEvents(v []*AcceleratorEvent) *Accelerator {
	s.Events = v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *Accelerator) SetIpAddressType(v string) *Accelerator {
	s.IpAddressType = &v
	return s
}

// SetIpSets sets the IpSets field's value.
func (s *Accelerator) SetIpSets(v []*IpSet) *Accelerator {
	s.IpSets = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Accelerator) SetLastModifiedTime(v time.Time) *Accelerator {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Accelerator) SetName(v string) *Accelerator {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Accelerator) SetStatus(v string) *Accelerator {
	s.Status = &v
	return s
}

// Attributes of an accelerator.
type AcceleratorAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute
	// is required if FlowLogsEnabled is true.
	//
	// If you specify slash (/) for the S3 bucket prefix, the log file bucket folder
	// structure will include a double slash (//), like the following:
	//
	// s3-bucket_name//AWSLogs/aws_account_id
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorAttributes) GoString() string {
	return s.String()
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *AcceleratorAttributes) SetFlowLogsEnabled(v bool) *AcceleratorAttributes {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *AcceleratorAttributes) SetFlowLogsS3Bucket(v string) *AcceleratorAttributes {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *AcceleratorAttributes) SetFlowLogsS3Prefix(v string) *AcceleratorAttributes {
	s.FlowLogsS3Prefix = &v
	return s
}

// A complex type that contains a Timestamp value and Message for changes that
// you make to an accelerator in Global Accelerator. Messages stored here provide
// progress or error information when you update an accelerator from IPv4 to
// dual-stack, or from dual-stack to IPv4. Global Accelerator stores a maximum
// of ten event messages.
type AcceleratorEvent struct {
	_ struct{} `type:"structure"`

	// A string that contains an Event message describing changes or errors when
	// you update an accelerator in Global Accelerator from IPv4 to dual-stack,
	// or dual-stack to IPv4.
	Message *string `type:"string"`

	// A timestamp for when you update an accelerator in Global Accelerator from
	// IPv4 to dual-stack, or dual-stack to IPv4.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorEvent) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AcceleratorEvent) SetMessage(v string) *AcceleratorEvent {
	s.Message = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AcceleratorEvent) SetTimestamp(v time.Time) *AcceleratorEvent {
	s.Timestamp = &v
	return s
}

// The accelerator that you specified could not be disabled.
type AcceleratorNotDisabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorNotDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorNotDisabledException) GoString() string {
	return s.String()
}

func newErrorAcceleratorNotDisabledException(v protocol.ResponseMetadata) error {
	return &AcceleratorNotDisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AcceleratorNotDisabledException) Code() string {
	return "AcceleratorNotDisabledException"
}

// Message returns the exception's message.
func (s *AcceleratorNotDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AcceleratorNotDisabledException) OrigErr() error {
	return nil
}

func (s *AcceleratorNotDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AcceleratorNotDisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AcceleratorNotDisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The accelerator that you specified doesn't exist.
type AcceleratorNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorNotFoundException) GoString() string {
	return s.String()
}

func newErrorAcceleratorNotFoundException(v protocol.ResponseMetadata) error {
	return &AcceleratorNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AcceleratorNotFoundException) Code() string {
	return "AcceleratorNotFoundException"
}

// Message returns the exception's message.
func (s *AcceleratorNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AcceleratorNotFoundException) OrigErr() error {
	return nil
}

func (s *AcceleratorNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AcceleratorNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AcceleratorNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You don't have access permission.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddCustomRoutingEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects to add to a custom routing accelerator.
	//
	// EndpointConfigurations is a required field
	EndpointConfigurations []*CustomRoutingEndpointConfiguration `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint group for the custom routing
	// endpoint.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomRoutingEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomRoutingEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCustomRoutingEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCustomRoutingEndpointsInput"}
	if s.EndpointConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigurations"))
	}
	if s.EndpointConfigurations != nil && len(s.EndpointConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointConfigurations", 1))
	}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *AddCustomRoutingEndpointsInput) SetEndpointConfigurations(v []*CustomRoutingEndpointConfiguration) *AddCustomRoutingEndpointsInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *AddCustomRoutingEndpointsInput) SetEndpointGroupArn(v string) *AddCustomRoutingEndpointsInput {
	s.EndpointGroupArn = &v
	return s
}

type AddCustomRoutingEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint objects added to the custom routing accelerator.
	EndpointDescriptions []*CustomRoutingEndpointDescription `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group for the custom routing
	// endpoint.
	EndpointGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomRoutingEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomRoutingEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointDescriptions sets the EndpointDescriptions field's value.
func (s *AddCustomRoutingEndpointsOutput) SetEndpointDescriptions(v []*CustomRoutingEndpointDescription) *AddCustomRoutingEndpointsOutput {
	s.EndpointDescriptions = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *AddCustomRoutingEndpointsOutput) SetEndpointGroupArn(v string) *AddCustomRoutingEndpointsOutput {
	s.EndpointGroupArn = &v
	return s
}

type AddEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	//
	// EndpointConfigurations is a required field
	EndpointConfigurations []*EndpointConfiguration `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddEndpointsInput"}
	if s.EndpointConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigurations"))
	}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *AddEndpointsInput) SetEndpointConfigurations(v []*EndpointConfiguration) *AddEndpointsInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *AddEndpointsInput) SetEndpointGroupArn(v string) *AddEndpointsInput {
	s.EndpointGroupArn = &v
	return s
}

type AddEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointDescriptions []*EndpointDescription `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointDescriptions sets the EndpointDescriptions field's value.
func (s *AddEndpointsOutput) SetEndpointDescriptions(v []*EndpointDescription) *AddEndpointsOutput {
	s.EndpointDescriptions = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *AddEndpointsOutput) SetEndpointGroupArn(v string) *AddEndpointsOutput {
	s.EndpointGroupArn = &v
	return s
}

type AdvertiseByoipCidrInput struct {
	_ struct{} `type:"structure"`

	// The address range, in CIDR notation. This must be the exact range that you
	// provisioned. You can't advertise only a portion of the provisioned range.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvertiseByoipCidrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvertiseByoipCidrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvertiseByoipCidrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvertiseByoipCidrInput"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *AdvertiseByoipCidrInput) SetCidr(v string) *AdvertiseByoipCidrInput {
	s.Cidr = &v
	return s
}

type AdvertiseByoipCidrOutput struct {
	_ struct{} `type:"structure"`

	// Information about the address range.
	ByoipCidr *ByoipCidr `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvertiseByoipCidrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvertiseByoipCidrOutput) GoString() string {
	return s.String()
}

// SetByoipCidr sets the ByoipCidr field's value.
func (s *AdvertiseByoipCidrOutput) SetByoipCidr(v *ByoipCidr) *AdvertiseByoipCidrOutput {
	s.ByoipCidr = v
	return s
}

type AllowCustomRoutingTrafficInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether all destination IP addresses and ports for a specified
	// VPC subnet endpoint can receive traffic from a custom routing accelerator.
	// The value is TRUE or FALSE.
	//
	// When set to TRUE, all destinations in the custom routing VPC subnet can receive
	// traffic. Note that you cannot specify destination IP addresses and ports
	// when the value is set to TRUE.
	//
	// When set to FALSE (or not specified), you must specify a list of destination
	// IP addresses that are allowed to receive traffic. A list of ports is optional.
	// If you don't specify a list of ports, the ports that can accept traffic is
	// the same as the ports configured for the endpoint group.
	//
	// The default value is FALSE.
	AllowAllTrafficToEndpoint *bool `type:"boolean"`

	// A list of specific Amazon EC2 instance IP addresses (destination addresses)
	// in a subnet that you want to allow to receive traffic. The IP addresses must
	// be a subset of the IP addresses that you specified for the endpoint group.
	//
	// DestinationAddresses is required if AllowAllTrafficToEndpoint is FALSE or
	// is not specified.
	DestinationAddresses []*string `type:"list"`

	// A list of specific Amazon EC2 instance ports (destination ports) that you
	// want to allow to receive traffic.
	DestinationPorts []*int64 `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// An ID for the endpoint. For custom routing accelerators, this is the virtual
	// private cloud (VPC) subnet ID.
	//
	// EndpointId is a required field
	EndpointId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowCustomRoutingTrafficInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowCustomRoutingTrafficInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowCustomRoutingTrafficInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowCustomRoutingTrafficInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAllTrafficToEndpoint sets the AllowAllTrafficToEndpoint field's value.
func (s *AllowCustomRoutingTrafficInput) SetAllowAllTrafficToEndpoint(v bool) *AllowCustomRoutingTrafficInput {
	s.AllowAllTrafficToEndpoint = &v
	return s
}

// SetDestinationAddresses sets the DestinationAddresses field's value.
func (s *AllowCustomRoutingTrafficInput) SetDestinationAddresses(v []*string) *AllowCustomRoutingTrafficInput {
	s.DestinationAddresses = v
	return s
}

// SetDestinationPorts sets the DestinationPorts field's value.
func (s *AllowCustomRoutingTrafficInput) SetDestinationPorts(v []*int64) *AllowCustomRoutingTrafficInput {
	s.DestinationPorts = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *AllowCustomRoutingTrafficInput) SetEndpointGroupArn(v string) *AllowCustomRoutingTrafficInput {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *AllowCustomRoutingTrafficInput) SetEndpointId(v string) *AllowCustomRoutingTrafficInput {
	s.EndpointId = &v
	return s
}

type AllowCustomRoutingTrafficOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowCustomRoutingTrafficOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowCustomRoutingTrafficOutput) GoString() string {
	return s.String()
}

// The listener that you specified has an endpoint group associated with it.
// You must remove all dependent resources from a listener before you can delete
// it.
type AssociatedEndpointGroupFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedEndpointGroupFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedEndpointGroupFoundException) GoString() string {
	return s.String()
}

func newErrorAssociatedEndpointGroupFoundException(v protocol.ResponseMetadata) error {
	return &AssociatedEndpointGroupFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociatedEndpointGroupFoundException) Code() string {
	return "AssociatedEndpointGroupFoundException"
}

// Message returns the exception's message.
func (s *AssociatedEndpointGroupFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociatedEndpointGroupFoundException) OrigErr() error {
	return nil
}

func (s *AssociatedEndpointGroupFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociatedEndpointGroupFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociatedEndpointGroupFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The accelerator that you specified has a listener associated with it. You
// must remove all dependent resources from an accelerator before you can delete
// it.
type AssociatedListenerFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedListenerFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedListenerFoundException) GoString() string {
	return s.String()
}

func newErrorAssociatedListenerFoundException(v protocol.ResponseMetadata) error {
	return &AssociatedListenerFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociatedListenerFoundException) Code() string {
	return "AssociatedListenerFoundException"
}

// Message returns the exception's message.
func (s *AssociatedListenerFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociatedListenerFoundException) OrigErr() error {
	return nil
}

func (s *AssociatedListenerFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociatedListenerFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociatedListenerFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A cross-account attachment in Global Accelerator. A cross-account attachment
// specifies the principals who have permission to work with resources in your
// account, which you also list in the attachment.
type Attachment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cross-account attachment.
	AttachmentArn *string `type:"string"`

	// The date and time that the cross-account attachment was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The date and time that the cross-account attachment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the cross-account attachment.
	Name *string `type:"string"`

	// The principals included in the cross-account attachment.
	Principals []*string `type:"list"`

	// The resources included in the cross-account attachment.
	Resources []*Resource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) GoString() string {
	return s.String()
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *Attachment) SetAttachmentArn(v string) *Attachment {
	s.AttachmentArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Attachment) SetCreatedTime(v time.Time) *Attachment {
	s.CreatedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Attachment) SetLastModifiedTime(v time.Time) *Attachment {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Attachment) SetName(v string) *Attachment {
	s.Name = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *Attachment) SetPrincipals(v []*string) *Attachment {
	s.Principals = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Attachment) SetResources(v []*Resource) *Attachment {
	s.Resources = v
	return s
}

// No cross-account attachment was found.
type AttachmentNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentNotFoundException) GoString() string {
	return s.String()
}

func newErrorAttachmentNotFoundException(v protocol.ResponseMetadata) error {
	return &AttachmentNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AttachmentNotFoundException) Code() string {
	return "AttachmentNotFoundException"
}

// Message returns the exception's message.
func (s *AttachmentNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AttachmentNotFoundException) OrigErr() error {
	return nil
}

func (s *AttachmentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AttachmentNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AttachmentNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about an IP address range that is provisioned for use with your
// Amazon Web Services resources through bring your own IP address (BYOIP).
//
// The following describes each BYOIP State that your IP address range can be
// in.
//
//   - PENDING_PROVISIONING — You’ve submitted a request to provision an
//     IP address range but it is not yet provisioned with Global Accelerator.
//
//   - READY — The address range is provisioned with Global Accelerator and
//     can be advertised.
//
//   - PENDING_ADVERTISING — You’ve submitted a request for Global Accelerator
//     to advertise an address range but it is not yet being advertised.
//
//   - ADVERTISING — The address range is being advertised by Global Accelerator.
//
//   - PENDING_WITHDRAWING — You’ve submitted a request to withdraw an
//     address range from being advertised but it is still being advertised by
//     Global Accelerator.
//
//   - PENDING_DEPROVISIONING — You’ve submitted a request to deprovision
//     an address range from Global Accelerator but it is still provisioned.
//
//   - DEPROVISIONED — The address range is deprovisioned from Global Accelerator.
//
//   - FAILED_PROVISION — The request to provision the address range from
//     Global Accelerator was not successful. Please make sure that you provide
//     all of the correct information, and try again. If the request fails a
//     second time, contact Amazon Web Services support.
//
//   - FAILED_ADVERTISING — The request for Global Accelerator to advertise
//     the address range was not successful. Please make sure that you provide
//     all of the correct information, and try again. If the request fails a
//     second time, contact Amazon Web Services support.
//
//   - FAILED_WITHDRAW — The request to withdraw the address range from advertising
//     by Global Accelerator was not successful. Please make sure that you provide
//     all of the correct information, and try again. If the request fails a
//     second time, contact Amazon Web Services support.
//
//   - FAILED_DEPROVISION — The request to deprovision the address range
//     from Global Accelerator was not successful. Please make sure that you
//     provide all of the correct information, and try again. If the request
//     fails a second time, contact Amazon Web Services support.
type ByoipCidr struct {
	_ struct{} `type:"structure"`

	// The address range, in CIDR notation.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	Cidr *string `type:"string"`

	// A history of status changes for an IP address range that you bring to Global
	// Accelerator through bring your own IP address (BYOIP).
	Events []*ByoipCidrEvent `type:"list"`

	// The state of the address pool.
	State *string `type:"string" enum:"ByoipCidrState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidr) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidr) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *ByoipCidr) SetCidr(v string) *ByoipCidr {
	s.Cidr = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *ByoipCidr) SetEvents(v []*ByoipCidrEvent) *ByoipCidr {
	s.Events = v
	return s
}

// SetState sets the State field's value.
func (s *ByoipCidr) SetState(v string) *ByoipCidr {
	s.State = &v
	return s
}

// A complex type that contains a Message and a Timestamp value for changes
// that you make in the status of an IP address range that you bring to Global
// Accelerator through bring your own IP address (BYOIP).
type ByoipCidrEvent struct {
	_ struct{} `type:"structure"`

	// A string that contains an Event message describing changes that you make
	// in the status of an IP address range that you bring to Global Accelerator
	// through bring your own IP address (BYOIP).
	Message *string `type:"string"`

	// A timestamp for when you make a status change for an IP address range that
	// you bring to Global Accelerator through bring your own IP address (BYOIP).
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidrEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidrEvent) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ByoipCidrEvent) SetMessage(v string) *ByoipCidrEvent {
	s.Message = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ByoipCidrEvent) SetTimestamp(v time.Time) *ByoipCidrEvent {
	s.Timestamp = &v
	return s
}

// The CIDR that you specified was not found or is incorrect.
type ByoipCidrNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidrNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByoipCidrNotFoundException) GoString() string {
	return s.String()
}

func newErrorByoipCidrNotFoundException(v protocol.ResponseMetadata) error {
	return &ByoipCidrNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ByoipCidrNotFoundException) Code() string {
	return "ByoipCidrNotFoundException"
}

// Message returns the exception's message.
func (s *ByoipCidrNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ByoipCidrNotFoundException) OrigErr() error {
	return nil
}

func (s *ByoipCidrNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ByoipCidrNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ByoipCidrNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides authorization for Amazon to bring a specific IP address range to
// a specific Amazon Web Services account using bring your own IP addresses
// (BYOIP).
//
// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
// in the Global Accelerator Developer Guide.
type CidrAuthorizationContext struct {
	_ struct{} `type:"structure"`

	// The plain-text authorization message for the prefix and account.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The signed authorization message for the prefix and account.
	//
	// Signature is a required field
	Signature *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CidrAuthorizationContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CidrAuthorizationContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CidrAuthorizationContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CidrAuthorizationContext"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Signature == nil {
		invalidParams.Add(request.NewErrParamRequired("Signature"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *CidrAuthorizationContext) SetMessage(v string) *CidrAuthorizationContext {
	s.Message = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *CidrAuthorizationContext) SetSignature(v string) *CidrAuthorizationContext {
	s.Signature = &v
	return s
}

// You can't use both of those options.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, an accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of an accelerator.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The IP address type that an accelerator supports. For a standard accelerator,
	// the value can be IPV4 or DUAL_STACK.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// Optionally, if you've added your own IP address pool to Global Accelerator
	// (BYOIP), you can choose an IPv4 address from your own pool to use for the
	// accelerator's static IPv4 address when you create an accelerator.
	//
	// After you bring an address range to Amazon Web Services, it appears in your
	// account as an address pool. When you create an accelerator, you can assign
	// one IPv4 address from your range to it. Global Accelerator assigns you a
	// second static IPv4 address from an Amazon IP address range. If you bring
	// two IPv4 address ranges to Amazon Web Services, you can assign one IPv4 address
	// from each range to your accelerator. This restriction is because Global Accelerator
	// assigns each address range to a different network zone, for high availability.
	//
	// You can specify one or two addresses, separated by a space. Do not include
	// the /32 suffix.
	//
	// Note that you can't update IP addresses for an existing accelerator. To change
	// them, you must create a new accelerator with the new addresses.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	IpAddresses []*string `type:"list"`

	// The name of the accelerator. The name can have a maximum of 64 characters,
	// must contain only alphanumeric characters, periods (.), or hyphens (-), and
	// must not begin or end with a hyphen or period.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Create tags for an accelerator.
	//
	// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
	// in the Global Accelerator Developer Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAcceleratorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateAcceleratorInput) SetEnabled(v bool) *CreateAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateAcceleratorInput) SetIdempotencyToken(v string) *CreateAcceleratorInput {
	s.IdempotencyToken = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateAcceleratorInput) SetIpAddressType(v string) *CreateAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *CreateAcceleratorInput) SetIpAddresses(v []*string) *CreateAcceleratorInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAcceleratorInput) SetName(v string) *CreateAcceleratorInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAcceleratorInput) SetTags(v []*Tag) *CreateAcceleratorInput {
	s.Tags = v
	return s
}

type CreateAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The accelerator that is created by specifying a listener and the supported
	// IP address types.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *CreateAcceleratorOutput) SetAccelerator(v *Accelerator) *CreateAcceleratorOutput {
	s.Accelerator = v
	return s
}

type CreateCrossAccountAttachmentInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The name of the cross-account attachment.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The principals to include in the cross-account attachment. A principal can
	// be an Amazon Web Services account number or the Amazon Resource Name (ARN)
	// for an accelerator.
	Principals []*string `type:"list"`

	// The Amazon Resource Names (ARNs) for the resources to include in the cross-account
	// attachment. A resource can be any supported Amazon Web Services resource
	// type for Global Accelerator or a CIDR range for a bring your own IP address
	// (BYOIP) address pool.
	Resources []*Resource `type:"list"`

	// Add tags for a cross-account attachment.
	//
	// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
	// in the Global Accelerator Developer Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCrossAccountAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCrossAccountAttachmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCrossAccountAttachmentInput) SetIdempotencyToken(v string) *CreateCrossAccountAttachmentInput {
	s.IdempotencyToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCrossAccountAttachmentInput) SetName(v string) *CreateCrossAccountAttachmentInput {
	s.Name = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *CreateCrossAccountAttachmentInput) SetPrincipals(v []*string) *CreateCrossAccountAttachmentInput {
	s.Principals = v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateCrossAccountAttachmentInput) SetResources(v []*Resource) *CreateCrossAccountAttachmentInput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCrossAccountAttachmentInput) SetTags(v []*Tag) *CreateCrossAccountAttachmentInput {
	s.Tags = v
	return s
}

type CreateCrossAccountAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the cross-account attachment.
	CrossAccountAttachment *Attachment `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAttachmentOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAttachment sets the CrossAccountAttachment field's value.
func (s *CreateCrossAccountAttachmentOutput) SetCrossAccountAttachment(v *Attachment) *CreateCrossAccountAttachmentOutput {
	s.CrossAccountAttachment = v
	return s
}

type CreateCustomRoutingAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, an accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The IP address type that an accelerator supports. For a custom routing accelerator,
	// the value must be IPV4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// Optionally, if you've added your own IP address pool to Global Accelerator
	// (BYOIP), you can choose an IPv4 address from your own pool to use for the
	// accelerator's static IPv4 address when you create an accelerator.
	//
	// After you bring an address range to Amazon Web Services, it appears in your
	// account as an address pool. When you create an accelerator, you can assign
	// one IPv4 address from your range to it. Global Accelerator assigns you a
	// second static IPv4 address from an Amazon IP address range. If you bring
	// two IPv4 address ranges to Amazon Web Services, you can assign one IPv4 address
	// from each range to your accelerator. This restriction is because Global Accelerator
	// assigns each address range to a different network zone, for high availability.
	//
	// You can specify one or two addresses, separated by a space. Do not include
	// the /32 suffix.
	//
	// Note that you can't update IP addresses for an existing accelerator. To change
	// them, you must create a new accelerator with the new addresses.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	IpAddresses []*string `type:"list"`

	// The name of a custom routing accelerator. The name can have a maximum of
	// 64 characters, must contain only alphanumeric characters or hyphens (-),
	// and must not begin or end with a hyphen.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Create tags for an accelerator.
	//
	// For more information, see Tagging in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
	// in the Global Accelerator Developer Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomRoutingAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomRoutingAcceleratorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetEnabled(v bool) *CreateCustomRoutingAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetIdempotencyToken(v string) *CreateCustomRoutingAcceleratorInput {
	s.IdempotencyToken = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetIpAddressType(v string) *CreateCustomRoutingAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetIpAddresses(v []*string) *CreateCustomRoutingAcceleratorInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetName(v string) *CreateCustomRoutingAcceleratorInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomRoutingAcceleratorInput) SetTags(v []*Tag) *CreateCustomRoutingAcceleratorInput {
	s.Tags = v
	return s
}

type CreateCustomRoutingAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The accelerator that is created.
	Accelerator *CustomRoutingAccelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *CreateCustomRoutingAcceleratorOutput) SetAccelerator(v *CustomRoutingAccelerator) *CreateCustomRoutingAcceleratorOutput {
	s.Accelerator = v
	return s
}

type CreateCustomRoutingEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// Sets the port range and protocol for all endpoints (virtual private cloud
	// subnets) in a custom routing endpoint group to accept client traffic on.
	//
	// DestinationConfigurations is a required field
	DestinationConfigurations []*CustomRoutingDestinationConfiguration `min:"1" type:"list" required:"true"`

	// The Amazon Web Services Region where the endpoint group is located. A listener
	// can have only one endpoint group in a specific Region.
	//
	// EndpointGroupRegion is a required field
	EndpointGroupRegion *string `type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomRoutingEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomRoutingEndpointGroupInput"}
	if s.DestinationConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfigurations"))
	}
	if s.DestinationConfigurations != nil && len(s.DestinationConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationConfigurations", 1))
	}
	if s.EndpointGroupRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupRegion"))
	}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.DestinationConfigurations != nil {
		for i, v := range s.DestinationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DestinationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfigurations sets the DestinationConfigurations field's value.
func (s *CreateCustomRoutingEndpointGroupInput) SetDestinationConfigurations(v []*CustomRoutingDestinationConfiguration) *CreateCustomRoutingEndpointGroupInput {
	s.DestinationConfigurations = v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *CreateCustomRoutingEndpointGroupInput) SetEndpointGroupRegion(v string) *CreateCustomRoutingEndpointGroupInput {
	s.EndpointGroupRegion = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCustomRoutingEndpointGroupInput) SetIdempotencyToken(v string) *CreateCustomRoutingEndpointGroupInput {
	s.IdempotencyToken = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *CreateCustomRoutingEndpointGroupInput) SetListenerArn(v string) *CreateCustomRoutingEndpointGroupInput {
	s.ListenerArn = &v
	return s
}

type CreateCustomRoutingEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The information about the endpoint group created for a custom routing accelerator.
	EndpointGroup *CustomRoutingEndpointGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *CreateCustomRoutingEndpointGroupOutput) SetEndpointGroup(v *CustomRoutingEndpointGroup) *CreateCustomRoutingEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type CreateCustomRoutingListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The port range to support for connections from clients to your accelerator.
	//
	// Separately, you set port ranges for endpoints. For more information, see
	// About endpoints for custom routing accelerators (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).
	//
	// PortRanges is a required field
	PortRanges []*PortRange `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomRoutingListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomRoutingListenerInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.PortRanges == nil {
		invalidParams.Add(request.NewErrParamRequired("PortRanges"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *CreateCustomRoutingListenerInput) SetAcceleratorArn(v string) *CreateCustomRoutingListenerInput {
	s.AcceleratorArn = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCustomRoutingListenerInput) SetIdempotencyToken(v string) *CreateCustomRoutingListenerInput {
	s.IdempotencyToken = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *CreateCustomRoutingListenerInput) SetPortRanges(v []*PortRange) *CreateCustomRoutingListenerInput {
	s.PortRanges = v
	return s
}

type CreateCustomRoutingListenerOutput struct {
	_ struct{} `type:"structure"`

	// The listener that you've created for a custom routing accelerator.
	Listener *CustomRoutingListener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomRoutingListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *CreateCustomRoutingListenerOutput) SetListener(v *CustomRoutingListener) *CreateCustomRoutingListenerOutput {
	s.Listener = v
	return s
}

type CreateEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointConfigurations []*EndpointConfiguration `type:"list"`

	// The Amazon Web Services Region where the endpoint group is located. A listener
	// can have only one endpoint group in a specific Region.
	//
	// EndpointGroupRegion is a required field
	EndpointGroupRegion *string `type:"string" required:"true"`

	// The time—10 seconds or 30 seconds—between each health check for an endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this specifies the path that is the destination
	// for health check targets. The default value is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that Global Accelerator uses to check the health of endpoints that
	// are part of this endpoint group. The default port is the listener port that
	// this endpoint group is associated with. If listener port is a list of ports,
	// Global Accelerator uses the first port in the list.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// Override specific listener ports used to route traffic to endpoints that
	// are part of this endpoint group. For example, you can create a port override
	// in which the listener receives user traffic on ports 80 and 443, but your
	// accelerator routes that traffic to ports 1080 and 1443, respectively, on
	// the endpoints.
	//
	// For more information, see Overriding listener ports (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
	// in the Global Accelerator Developer Guide.
	PortOverrides []*PortOverride `type:"list"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an Amazon Web Services Region. Additional
	// traffic is distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointGroupInput"}
	if s.EndpointGroupRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupRegion"))
	}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 10 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 10))
	}
	if s.HealthCheckPort != nil && *s.HealthCheckPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckPort", 1))
	}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.ThresholdCount != nil && *s.ThresholdCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThresholdCount", 1))
	}
	if s.PortOverrides != nil {
		for i, v := range s.PortOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *CreateEndpointGroupInput) SetEndpointConfigurations(v []*EndpointConfiguration) *CreateEndpointGroupInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *CreateEndpointGroupInput) SetEndpointGroupRegion(v string) *CreateEndpointGroupInput {
	s.EndpointGroupRegion = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckIntervalSeconds(v int64) *CreateEndpointGroupInput {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckPath(v string) *CreateEndpointGroupInput {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckPort(v int64) *CreateEndpointGroupInput {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckProtocol(v string) *CreateEndpointGroupInput {
	s.HealthCheckProtocol = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateEndpointGroupInput) SetIdempotencyToken(v string) *CreateEndpointGroupInput {
	s.IdempotencyToken = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *CreateEndpointGroupInput) SetListenerArn(v string) *CreateEndpointGroupInput {
	s.ListenerArn = &v
	return s
}

// SetPortOverrides sets the PortOverrides field's value.
func (s *CreateEndpointGroupInput) SetPortOverrides(v []*PortOverride) *CreateEndpointGroupInput {
	s.PortOverrides = v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *CreateEndpointGroupInput) SetThresholdCount(v int64) *CreateEndpointGroupInput {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *CreateEndpointGroupInput) SetTrafficDialPercentage(v float64) *CreateEndpointGroupInput {
	s.TrafficDialPercentage = &v
	return s
}

type CreateEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The information about the endpoint group that was created.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *CreateEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *CreateEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type CreateListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your accelerator.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Client affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// Global Accelerator uses a consistent-flow hashing algorithm to choose the
	// optimal endpoint for a connection. If client affinity is NONE, Global Accelerator
	// uses the "five-tuple" (5-tuple) properties—source IP address, source port,
	// destination IP address, destination port, and protocol—to select the hash
	// value, and then chooses the best endpoint. However, with this setting, if
	// someone uses different ports to connect to Global Accelerator, their connections
	// might not be always routed to the same endpoint because the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The list of port ranges to support for connections from clients to your accelerator.
	//
	// PortRanges is a required field
	PortRanges []*PortRange `min:"1" type:"list" required:"true"`

	// The protocol for connections from clients to your accelerator.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListenerInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.PortRanges == nil {
		invalidParams.Add(request.NewErrParamRequired("PortRanges"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *CreateListenerInput) SetAcceleratorArn(v string) *CreateListenerInput {
	s.AcceleratorArn = &v
	return s
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *CreateListenerInput) SetClientAffinity(v string) *CreateListenerInput {
	s.ClientAffinity = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateListenerInput) SetIdempotencyToken(v string) *CreateListenerInput {
	s.IdempotencyToken = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *CreateListenerInput) SetPortRanges(v []*PortRange) *CreateListenerInput {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateListenerInput) SetProtocol(v string) *CreateListenerInput {
	s.Protocol = &v
	return s
}

type CreateListenerOutput struct {
	_ struct{} `type:"structure"`

	// The listener that you've created.
	Listener *Listener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *CreateListenerOutput) SetListener(v *Listener) *CreateListenerOutput {
	s.Listener = v
	return s
}

// An endpoint (Amazon Web Services resource) or an IP address range, in CIDR
// format, that is listed in a cross-account attachment. A cross-account resource
// can be added to an accelerator by specified principals, which are also listed
// in the attachment.
//
// For more information, see Working with cross-account attachments and resources
// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html)
// in the Global Accelerator Developer Guide.
type CrossAccountResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cross-account attachment that specifies
	// the resources (endpoints or CIDR range) that can be added to accelerators
	// and principals that have permission to add them.
	AttachmentArn *string `type:"string"`

	// An IP address range, in CIDR format, that is specified as an Amazon Web Services
	// resource. The address must be provisioned and advertised in Global Accelerator
	// by following the bring your own IP address (BYOIP) process for Global Accelerator.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	Cidr *string `type:"string"`

	// The endpoint ID for the endpoint that is listed in a cross-account attachment
	// and can be added to an accelerator by specified principals.
	EndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossAccountResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossAccountResource) GoString() string {
	return s.String()
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *CrossAccountResource) SetAttachmentArn(v string) *CrossAccountResource {
	s.AttachmentArn = &v
	return s
}

// SetCidr sets the Cidr field's value.
func (s *CrossAccountResource) SetCidr(v string) *CrossAccountResource {
	s.Cidr = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *CrossAccountResource) SetEndpointId(v string) *CrossAccountResource {
	s.EndpointId = &v
	return s
}

// Attributes of a custom routing accelerator.
type CustomRoutingAccelerator struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom routing accelerator.
	AcceleratorArn *string `type:"string"`

	// The date and time that the accelerator was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Domain Name System (DNS) name that Global Accelerator creates that points
	// to an accelerator's static IPv4 addresses.
	//
	// The naming convention for the DNS name is the following: A lowercase letter
	// a, followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com.
	// For example: a1234567890abcdef.awsglobalaccelerator.com.
	//
	// If you have a dual-stack accelerator, you also have a second DNS name, DualStackDnsName,
	// that points to both the A record and the AAAA record for all four static
	// addresses for the accelerator: two IPv4 addresses and two IPv6 addresses.
	//
	// For more information about the default DNS name, see Support for DNS addressing
	// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html)
	// in the Global Accelerator Developer Guide.
	DnsName *string `type:"string"`

	// Indicates whether the accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// The IP address type that an accelerator supports. For a custom routing accelerator,
	// the value must be IPV4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The static IP addresses that Global Accelerator associates with the accelerator.
	IpSets []*IpSet `type:"list"`

	// The date and time that the accelerator was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the accelerator. The name must contain only alphanumeric characters
	// or hyphens (-), and must not begin or end with a hyphen.
	Name *string `type:"string"`

	// Describes the deployment status of the accelerator.
	Status *string `type:"string" enum:"CustomRoutingAcceleratorStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingAccelerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingAccelerator) GoString() string {
	return s.String()
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *CustomRoutingAccelerator) SetAcceleratorArn(v string) *CustomRoutingAccelerator {
	s.AcceleratorArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CustomRoutingAccelerator) SetCreatedTime(v time.Time) *CustomRoutingAccelerator {
	s.CreatedTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *CustomRoutingAccelerator) SetDnsName(v string) *CustomRoutingAccelerator {
	s.DnsName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CustomRoutingAccelerator) SetEnabled(v bool) *CustomRoutingAccelerator {
	s.Enabled = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CustomRoutingAccelerator) SetIpAddressType(v string) *CustomRoutingAccelerator {
	s.IpAddressType = &v
	return s
}

// SetIpSets sets the IpSets field's value.
func (s *CustomRoutingAccelerator) SetIpSets(v []*IpSet) *CustomRoutingAccelerator {
	s.IpSets = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CustomRoutingAccelerator) SetLastModifiedTime(v time.Time) *CustomRoutingAccelerator {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomRoutingAccelerator) SetName(v string) *CustomRoutingAccelerator {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CustomRoutingAccelerator) SetStatus(v string) *CustomRoutingAccelerator {
	s.Status = &v
	return s
}

// Attributes of a custom routing accelerator.
type CustomRoutingAcceleratorAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute
	// is required if FlowLogsEnabled is true.
	//
	// If you don’t specify a prefix, the flow logs are stored in the root of
	// the bucket. If you specify slash (/) for the S3 bucket prefix, the log file
	// bucket folder structure will include a double slash (//), like the following:
	//
	// DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingAcceleratorAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingAcceleratorAttributes) GoString() string {
	return s.String()
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *CustomRoutingAcceleratorAttributes) SetFlowLogsEnabled(v bool) *CustomRoutingAcceleratorAttributes {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *CustomRoutingAcceleratorAttributes) SetFlowLogsS3Bucket(v string) *CustomRoutingAcceleratorAttributes {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *CustomRoutingAcceleratorAttributes) SetFlowLogsS3Prefix(v string) *CustomRoutingAcceleratorAttributes {
	s.FlowLogsS3Prefix = &v
	return s
}

// For a custom routing accelerator, sets the port range and protocol for all
// endpoints (virtual private cloud subnets) in an endpoint group to accept
// client traffic on.
type CustomRoutingDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The first port, inclusive, in the range of ports for the endpoint group that
	// is associated with a custom routing accelerator.
	//
	// FromPort is a required field
	FromPort *int64 `min:"1" type:"integer" required:"true"`

	// The protocol for the endpoint group that is associated with a custom routing
	// accelerator. The protocol can be either TCP or UDP.
	//
	// Protocols is a required field
	Protocols []*string `min:"1" type:"list" required:"true" enum:"CustomRoutingProtocol"`

	// The last port, inclusive, in the range of ports for the endpoint group that
	// is associated with a custom routing accelerator.
	//
	// ToPort is a required field
	ToPort *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomRoutingDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomRoutingDestinationConfiguration"}
	if s.FromPort == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPort"))
	}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.Protocols == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocols"))
	}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.ToPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPort"))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *CustomRoutingDestinationConfiguration) SetFromPort(v int64) *CustomRoutingDestinationConfiguration {
	s.FromPort = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CustomRoutingDestinationConfiguration) SetProtocols(v []*string) *CustomRoutingDestinationConfiguration {
	s.Protocols = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *CustomRoutingDestinationConfiguration) SetToPort(v int64) *CustomRoutingDestinationConfiguration {
	s.ToPort = &v
	return s
}

// For a custom routing accelerator, describes the port range and protocol for
// all endpoints (virtual private cloud subnets) in an endpoint group to accept
// client traffic on.
type CustomRoutingDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The first port, inclusive, in the range of ports for the endpoint group that
	// is associated with a custom routing accelerator.
	FromPort *int64 `min:"1" type:"integer"`

	// The protocol for the endpoint group that is associated with a custom routing
	// accelerator. The protocol can be either TCP or UDP.
	Protocols []*string `type:"list" enum:"Protocol"`

	// The last port, inclusive, in the range of ports for the endpoint group that
	// is associated with a custom routing accelerator.
	ToPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingDestinationDescription) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *CustomRoutingDestinationDescription) SetFromPort(v int64) *CustomRoutingDestinationDescription {
	s.FromPort = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CustomRoutingDestinationDescription) SetProtocols(v []*string) *CustomRoutingDestinationDescription {
	s.Protocols = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *CustomRoutingDestinationDescription) SetToPort(v int64) *CustomRoutingDestinationDescription {
	s.ToPort = &v
	return s
}

// The list of endpoint objects. For custom routing, this is a list of virtual
// private cloud (VPC) subnet IDs.
type CustomRoutingEndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cross-account attachment that specifies
	// the endpoints (resources) that can be added to accelerators and principals
	// that have permission to add the endpoints.
	AttachmentArn *string `type:"string"`

	// An ID for the endpoint. For custom routing accelerators, this is the virtual
	// private cloud (VPC) subnet ID.
	EndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointConfiguration) GoString() string {
	return s.String()
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *CustomRoutingEndpointConfiguration) SetAttachmentArn(v string) *CustomRoutingEndpointConfiguration {
	s.AttachmentArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *CustomRoutingEndpointConfiguration) SetEndpointId(v string) *CustomRoutingEndpointConfiguration {
	s.EndpointId = &v
	return s
}

// A complex type for an endpoint for a custom routing accelerator. Each endpoint
// group can include one or more endpoints, which are virtual private cloud
// (VPC) subnets.
type CustomRoutingEndpointDescription struct {
	_ struct{} `type:"structure"`

	// An ID for the endpoint. For custom routing accelerators, this is the virtual
	// private cloud (VPC) subnet ID.
	EndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointDescription) GoString() string {
	return s.String()
}

// SetEndpointId sets the EndpointId field's value.
func (s *CustomRoutingEndpointDescription) SetEndpointId(v string) *CustomRoutingEndpointDescription {
	s.EndpointId = &v
	return s
}

// A complex type for the endpoint group for a custom routing accelerator. An
// Amazon Web Services Region can have only one endpoint group for a specific
// listener.
type CustomRoutingEndpointGroup struct {
	_ struct{} `type:"structure"`

	// For a custom routing accelerator, describes the port range and protocol for
	// all endpoints (virtual private cloud subnets) in an endpoint group to accept
	// client traffic on.
	DestinationDescriptions []*CustomRoutingDestinationDescription `type:"list"`

	// For a custom routing accelerator, describes the endpoints (virtual private
	// cloud subnets) in an endpoint group to accept client traffic on.
	EndpointDescriptions []*CustomRoutingEndpointDescription `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`

	// The Amazon Web Services Region where the endpoint group is located.
	EndpointGroupRegion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingEndpointGroup) GoString() string {
	return s.String()
}

// SetDestinationDescriptions sets the DestinationDescriptions field's value.
func (s *CustomRoutingEndpointGroup) SetDestinationDescriptions(v []*CustomRoutingDestinationDescription) *CustomRoutingEndpointGroup {
	s.DestinationDescriptions = v
	return s
}

// SetEndpointDescriptions sets the EndpointDescriptions field's value.
func (s *CustomRoutingEndpointGroup) SetEndpointDescriptions(v []*CustomRoutingEndpointDescription) *CustomRoutingEndpointGroup {
	s.EndpointDescriptions = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *CustomRoutingEndpointGroup) SetEndpointGroupArn(v string) *CustomRoutingEndpointGroup {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *CustomRoutingEndpointGroup) SetEndpointGroupRegion(v string) *CustomRoutingEndpointGroup {
	s.EndpointGroupRegion = &v
	return s
}

// A complex type for a listener for a custom routing accelerator.
type CustomRoutingListener struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The port range to support for connections from clients to your accelerator.
	//
	// Separately, you set port ranges for endpoints. For more information, see
	// About endpoints for custom routing accelerators (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).
	PortRanges []*PortRange `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomRoutingListener) GoString() string {
	return s.String()
}

// SetListenerArn sets the ListenerArn field's value.
func (s *CustomRoutingListener) SetListenerArn(v string) *CustomRoutingListener {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *CustomRoutingListener) SetPortRanges(v []*PortRange) *CustomRoutingListener {
	s.PortRanges = v
	return s
}

type DeleteAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an accelerator.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DeleteAcceleratorInput) SetAcceleratorArn(v string) *DeleteAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DeleteAcceleratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAcceleratorOutput) GoString() string {
	return s.String()
}

type DeleteCrossAccountAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the cross-account attachment to delete.
	//
	// AttachmentArn is a required field
	AttachmentArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCrossAccountAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCrossAccountAttachmentInput"}
	if s.AttachmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *DeleteCrossAccountAttachmentInput) SetAttachmentArn(v string) *DeleteCrossAccountAttachmentInput {
	s.AttachmentArn = &v
	return s
}

type DeleteCrossAccountAttachmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAttachmentOutput) GoString() string {
	return s.String()
}

type DeleteCustomRoutingAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomRoutingAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomRoutingAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DeleteCustomRoutingAcceleratorInput) SetAcceleratorArn(v string) *DeleteCustomRoutingAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DeleteCustomRoutingAcceleratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingAcceleratorOutput) GoString() string {
	return s.String()
}

type DeleteCustomRoutingEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to delete.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomRoutingEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomRoutingEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DeleteCustomRoutingEndpointGroupInput) SetEndpointGroupArn(v string) *DeleteCustomRoutingEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DeleteCustomRoutingEndpointGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingEndpointGroupOutput) GoString() string {
	return s.String()
}

type DeleteCustomRoutingListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to delete.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomRoutingListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomRoutingListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DeleteCustomRoutingListenerInput) SetListenerArn(v string) *DeleteCustomRoutingListenerInput {
	s.ListenerArn = &v
	return s
}

type DeleteCustomRoutingListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomRoutingListenerOutput) GoString() string {
	return s.String()
}

type DeleteEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to delete.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DeleteEndpointGroupInput) SetEndpointGroupArn(v string) *DeleteEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DeleteEndpointGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointGroupOutput) GoString() string {
	return s.String()
}

type DeleteListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DeleteListenerInput) SetListenerArn(v string) *DeleteListenerInput {
	s.ListenerArn = &v
	return s
}

type DeleteListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListenerOutput) GoString() string {
	return s.String()
}

type DenyCustomRoutingTrafficInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether all destination IP addresses and ports for a specified
	// VPC subnet endpoint cannot receive traffic from a custom routing accelerator.
	// The value is TRUE or FALSE.
	//
	// When set to TRUE, no destinations in the custom routing VPC subnet can receive
	// traffic. Note that you cannot specify destination IP addresses and ports
	// when the value is set to TRUE.
	//
	// When set to FALSE (or not specified), you must specify a list of destination
	// IP addresses that cannot receive traffic. A list of ports is optional. If
	// you don't specify a list of ports, the ports that can accept traffic is the
	// same as the ports configured for the endpoint group.
	//
	// The default value is FALSE.
	DenyAllTrafficToEndpoint *bool `type:"boolean"`

	// A list of specific Amazon EC2 instance IP addresses (destination addresses)
	// in a subnet that you want to prevent from receiving traffic. The IP addresses
	// must be a subset of the IP addresses allowed for the VPC subnet associated
	// with the endpoint group.
	DestinationAddresses []*string `type:"list"`

	// A list of specific Amazon EC2 instance ports (destination ports) in a subnet
	// endpoint that you want to prevent from receiving traffic.
	DestinationPorts []*int64 `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// An ID for the endpoint. For custom routing accelerators, this is the virtual
	// private cloud (VPC) subnet ID.
	//
	// EndpointId is a required field
	EndpointId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DenyCustomRoutingTrafficInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DenyCustomRoutingTrafficInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DenyCustomRoutingTrafficInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DenyCustomRoutingTrafficInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDenyAllTrafficToEndpoint sets the DenyAllTrafficToEndpoint field's value.
func (s *DenyCustomRoutingTrafficInput) SetDenyAllTrafficToEndpoint(v bool) *DenyCustomRoutingTrafficInput {
	s.DenyAllTrafficToEndpoint = &v
	return s
}

// SetDestinationAddresses sets the DestinationAddresses field's value.
func (s *DenyCustomRoutingTrafficInput) SetDestinationAddresses(v []*string) *DenyCustomRoutingTrafficInput {
	s.DestinationAddresses = v
	return s
}

// SetDestinationPorts sets the DestinationPorts field's value.
func (s *DenyCustomRoutingTrafficInput) SetDestinationPorts(v []*int64) *DenyCustomRoutingTrafficInput {
	s.DestinationPorts = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DenyCustomRoutingTrafficInput) SetEndpointGroupArn(v string) *DenyCustomRoutingTrafficInput {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DenyCustomRoutingTrafficInput) SetEndpointId(v string) *DenyCustomRoutingTrafficInput {
	s.EndpointId = &v
	return s
}

type DenyCustomRoutingTrafficOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DenyCustomRoutingTrafficOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DenyCustomRoutingTrafficOutput) GoString() string {
	return s.String()
}

type DeprovisionByoipCidrInput struct {
	_ struct{} `type:"structure"`

	// The address range, in CIDR notation. The prefix must be the same prefix that
	// you specified when you provisioned the address range.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprovisionByoipCidrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprovisionByoipCidrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprovisionByoipCidrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprovisionByoipCidrInput"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *DeprovisionByoipCidrInput) SetCidr(v string) *DeprovisionByoipCidrInput {
	s.Cidr = &v
	return s
}

type DeprovisionByoipCidrOutput struct {
	_ struct{} `type:"structure"`

	// Information about the address range.
	ByoipCidr *ByoipCidr `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprovisionByoipCidrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprovisionByoipCidrOutput) GoString() string {
	return s.String()
}

// SetByoipCidr sets the ByoipCidr field's value.
func (s *DeprovisionByoipCidrOutput) SetByoipCidr(v *ByoipCidr) *DeprovisionByoipCidrOutput {
	s.ByoipCidr = v
	return s
}

type DescribeAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator with the attributes that
	// you want to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeAcceleratorAttributesInput) SetAcceleratorArn(v string) *DescribeAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes of the accelerator.
	AcceleratorAttributes *AcceleratorAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *DescribeAcceleratorAttributesOutput) SetAcceleratorAttributes(v *AcceleratorAttributes) *DescribeAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type DescribeAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeAcceleratorInput) SetAcceleratorArn(v string) *DescribeAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The description of the accelerator.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *DescribeAcceleratorOutput) SetAccelerator(v *Accelerator) *DescribeAcceleratorOutput {
	s.Accelerator = v
	return s
}

type DescribeCrossAccountAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the cross-account attachment to describe.
	//
	// AttachmentArn is a required field
	AttachmentArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCrossAccountAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCrossAccountAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCrossAccountAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCrossAccountAttachmentInput"}
	if s.AttachmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *DescribeCrossAccountAttachmentInput) SetAttachmentArn(v string) *DescribeCrossAccountAttachmentInput {
	s.AttachmentArn = &v
	return s
}

type DescribeCrossAccountAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the cross-account attachment.
	CrossAccountAttachment *Attachment `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCrossAccountAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCrossAccountAttachmentOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAttachment sets the CrossAccountAttachment field's value.
func (s *DescribeCrossAccountAttachmentOutput) SetCrossAccountAttachment(v *Attachment) *DescribeCrossAccountAttachmentOutput {
	s.CrossAccountAttachment = v
	return s
}

type DescribeCustomRoutingAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom routing accelerator to describe
	// the attributes for.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomRoutingAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomRoutingAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeCustomRoutingAcceleratorAttributesInput) SetAcceleratorArn(v string) *DescribeCustomRoutingAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeCustomRoutingAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes of the custom routing accelerator.
	AcceleratorAttributes *CustomRoutingAcceleratorAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *DescribeCustomRoutingAcceleratorAttributesOutput) SetAcceleratorAttributes(v *CustomRoutingAcceleratorAttributes) *DescribeCustomRoutingAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type DescribeCustomRoutingAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomRoutingAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomRoutingAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeCustomRoutingAcceleratorInput) SetAcceleratorArn(v string) *DescribeCustomRoutingAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeCustomRoutingAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The description of the custom routing accelerator.
	Accelerator *CustomRoutingAccelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *DescribeCustomRoutingAcceleratorOutput) SetAccelerator(v *CustomRoutingAccelerator) *DescribeCustomRoutingAcceleratorOutput {
	s.Accelerator = v
	return s
}

type DescribeCustomRoutingEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to describe.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomRoutingEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomRoutingEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DescribeCustomRoutingEndpointGroupInput) SetEndpointGroupArn(v string) *DescribeCustomRoutingEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DescribeCustomRoutingEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of an endpoint group for a custom routing accelerator.
	EndpointGroup *CustomRoutingEndpointGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *DescribeCustomRoutingEndpointGroupOutput) SetEndpointGroup(v *CustomRoutingEndpointGroup) *DescribeCustomRoutingEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type DescribeCustomRoutingListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to describe.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomRoutingListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomRoutingListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DescribeCustomRoutingListenerInput) SetListenerArn(v string) *DescribeCustomRoutingListenerInput {
	s.ListenerArn = &v
	return s
}

type DescribeCustomRoutingListenerOutput struct {
	_ struct{} `type:"structure"`

	// The description of a listener for a custom routing accelerator.
	Listener *CustomRoutingListener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomRoutingListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *DescribeCustomRoutingListenerOutput) SetListener(v *CustomRoutingListener) *DescribeCustomRoutingListenerOutput {
	s.Listener = v
	return s
}

type DescribeEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to describe.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DescribeEndpointGroupInput) SetEndpointGroupArn(v string) *DescribeEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DescribeEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of an endpoint group.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *DescribeEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *DescribeEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type DescribeListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to describe.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DescribeListenerInput) SetListenerArn(v string) *DescribeListenerInput {
	s.ListenerArn = &v
	return s
}

type DescribeListenerOutput struct {
	_ struct{} `type:"structure"`

	// The description of a listener.
	Listener *Listener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *DescribeListenerOutput) SetListener(v *Listener) *DescribeListenerOutput {
	s.Listener = v
	return s
}

// The port mappings for a specified endpoint IP address (destination).
type DestinationPortMapping struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom routing accelerator that you
	// have port mappings for.
	AcceleratorArn *string `type:"string"`

	// The IP address/port combinations (sockets) that map to a given destination
	// socket address.
	AcceleratorSocketAddresses []*SocketAddress `type:"list"`

	// The endpoint IP address/port combination for traffic received on the accelerator
	// socket address.
	DestinationSocketAddress *SocketAddress `type:"structure"`

	// Indicates whether or not a port mapping destination can receive traffic.
	// The value is either ALLOW, if traffic is allowed to the destination, or DENY,
	// if traffic is not allowed to the destination.
	DestinationTrafficState *string `type:"string" enum:"CustomRoutingDestinationTrafficState"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`

	// The Amazon Web Services Region for the endpoint group.
	EndpointGroupRegion *string `type:"string"`

	// The ID for the virtual private cloud (VPC) subnet.
	EndpointId *string `type:"string"`

	// The IP address type that an accelerator supports. For a custom routing accelerator,
	// the value must be IPV4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationPortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationPortMapping) GoString() string {
	return s.String()
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DestinationPortMapping) SetAcceleratorArn(v string) *DestinationPortMapping {
	s.AcceleratorArn = &v
	return s
}

// SetAcceleratorSocketAddresses sets the AcceleratorSocketAddresses field's value.
func (s *DestinationPortMapping) SetAcceleratorSocketAddresses(v []*SocketAddress) *DestinationPortMapping {
	s.AcceleratorSocketAddresses = v
	return s
}

// SetDestinationSocketAddress sets the DestinationSocketAddress field's value.
func (s *DestinationPortMapping) SetDestinationSocketAddress(v *SocketAddress) *DestinationPortMapping {
	s.DestinationSocketAddress = v
	return s
}

// SetDestinationTrafficState sets the DestinationTrafficState field's value.
func (s *DestinationPortMapping) SetDestinationTrafficState(v string) *DestinationPortMapping {
	s.DestinationTrafficState = &v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DestinationPortMapping) SetEndpointGroupArn(v string) *DestinationPortMapping {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *DestinationPortMapping) SetEndpointGroupRegion(v string) *DestinationPortMapping {
	s.EndpointGroupRegion = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DestinationPortMapping) SetEndpointId(v string) *DestinationPortMapping {
	s.EndpointId = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *DestinationPortMapping) SetIpAddressType(v string) *DestinationPortMapping {
	s.IpAddressType = &v
	return s
}

// The endpoint that you specified doesn't exist.
type EndpointAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorEndpointAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &EndpointAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointAlreadyExistsException) Code() string {
	return "EndpointAlreadyExistsException"
}

// Message returns the exception's message.
func (s *EndpointAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *EndpointAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type for endpoints. A resource must be valid and active when you
// add it as an endpoint.
type EndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cross-account attachment that specifies
	// the endpoints (resources) that can be added to accelerators and principals
	// that have permission to add the endpoints.
	AttachmentArn *string `type:"string"`

	// Indicates whether client IP address preservation is enabled for an endpoint.
	// The value is true or false. The default value is true for Application Load
	// Balancer endpoints.
	//
	// If the value is set to true, the client's IP address is preserved in the
	// X-Forwarded-For request header as traffic travels to applications on the
	// endpoint fronted by the accelerator.
	//
	// Client IP address preservation is supported, in specific Amazon Web Services
	// Regions, for endpoints that are Application Load Balancers, Amazon EC2 instances,
	// and Network Load Balancers with security groups. IMPORTANT: You cannot use
	// client IP address preservation with Network Load Balancers with TLS listeners.
	//
	// For more information, see Preserve client IP addresses in Global Accelerator
	// (https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html)
	// in the Global Accelerator Developer Guide.
	ClientIPPreservationEnabled *bool `type:"boolean"`

	// An ID for the endpoint. If the endpoint is a Network Load Balancer or Application
	// Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If
	// the endpoint is an Elastic IP address, this is the Elastic IP address allocation
	// ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must
	// be valid and active when you add it as an endpoint.
	//
	// For cross-account endpoints, this must be the ARN of the resource.
	EndpointId *string `type:"string"`

	// The weight associated with the endpoint. When you add weights to endpoints,
	// you configure Global Accelerator to route traffic based on proportions that
	// you specify. For example, you might specify endpoint weights of 4, 5, 5,
	// and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed
	// to the first endpoint, 5/20 is routed both to the second and third endpoints,
	// and 6/20 is routed to the last endpoint. For more information, see Endpoint
	// weights (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html)
	// in the Global Accelerator Developer Guide.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointConfiguration) GoString() string {
	return s.String()
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *EndpointConfiguration) SetAttachmentArn(v string) *EndpointConfiguration {
	s.AttachmentArn = &v
	return s
}

// SetClientIPPreservationEnabled sets the ClientIPPreservationEnabled field's value.
func (s *EndpointConfiguration) SetClientIPPreservationEnabled(v bool) *EndpointConfiguration {
	s.ClientIPPreservationEnabled = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointConfiguration) SetEndpointId(v string) *EndpointConfiguration {
	s.EndpointId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *EndpointConfiguration) SetWeight(v int64) *EndpointConfiguration {
	s.Weight = &v
	return s
}

// A complex type for an endpoint. Each endpoint group can include one or more
// endpoints, such as load balancers.
type EndpointDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether client IP address preservation is enabled for an endpoint.
	// The value is true or false. The default value is true for Application Load
	// Balancers endpoints.
	//
	// If the value is set to true, the client's IP address is preserved in the
	// X-Forwarded-For request header as traffic travels to applications on the
	// endpoint fronted by the accelerator.
	//
	// Client IP address preservation is supported, in specific Amazon Web Services
	// Regions, for endpoints that are Application Load Balancers, Amazon EC2 instances,
	// and Network Load Balancers with security groups. IMPORTANT: You cannot use
	// client IP address preservation with Network Load Balancers with TLS listeners.
	//
	// For more information, see Preserve client IP addresses in Global Accelerator
	// (https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html)
	// in the Global Accelerator Developer Guide.
	ClientIPPreservationEnabled *bool `type:"boolean"`

	// An ID for the endpoint. If the endpoint is a Network Load Balancer or Application
	// Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If
	// the endpoint is an Elastic IP address, this is the Elastic IP address allocation
	// ID. For Amazon EC2 instances, this is the EC2 instance ID.
	//
	// An Application Load Balancer can be either internal or internet-facing.
	EndpointId *string `type:"string"`

	// Returns a null result.
	HealthReason *string `type:"string"`

	// The health status of the endpoint.
	HealthState *string `type:"string" enum:"HealthState"`

	// The weight associated with the endpoint. When you add weights to endpoints,
	// you configure Global Accelerator to route traffic based on proportions that
	// you specify. For example, you might specify endpoint weights of 4, 5, 5,
	// and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed
	// to the first endpoint, 5/20 is routed both to the second and third endpoints,
	// and 6/20 is routed to the last endpoint. For more information, see Endpoint
	// weights (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html)
	// in the Global Accelerator Developer Guide.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointDescription) GoString() string {
	return s.String()
}

// SetClientIPPreservationEnabled sets the ClientIPPreservationEnabled field's value.
func (s *EndpointDescription) SetClientIPPreservationEnabled(v bool) *EndpointDescription {
	s.ClientIPPreservationEnabled = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointDescription) SetEndpointId(v string) *EndpointDescription {
	s.EndpointId = &v
	return s
}

// SetHealthReason sets the HealthReason field's value.
func (s *EndpointDescription) SetHealthReason(v string) *EndpointDescription {
	s.HealthReason = &v
	return s
}

// SetHealthState sets the HealthState field's value.
func (s *EndpointDescription) SetHealthState(v string) *EndpointDescription {
	s.HealthState = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *EndpointDescription) SetWeight(v int64) *EndpointDescription {
	s.Weight = &v
	return s
}

// A complex type for the endpoint group. An Amazon Web Services Region can
// have only one endpoint group for a specific listener.
type EndpointGroup struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointDescriptions []*EndpointDescription `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`

	// The Amazon Web Services Region where the endpoint group is located.
	EndpointGroupRegion *string `type:"string"`

	// The time—10 seconds or 30 seconds—between health checks for each endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this value provides the ping path that Global
	// Accelerator uses for the destination on the endpoints for health checks.
	// The default is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that Global Accelerator uses to perform health checks on endpoints
	// that are part of this endpoint group.
	//
	// The default port is the port for the listener that this endpoint group is
	// associated with. If the listener port is a list, Global Accelerator uses
	// the first specified port in the list of ports.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that Global Accelerator uses to perform health checks on endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// Allows you to override the destination ports used to route traffic to an
	// endpoint. Using a port override lets you map a list of external destination
	// ports (that your users send traffic to) to a list of internal destination
	// ports that you want an application endpoint to receive traffic on.
	PortOverrides []*PortOverride `type:"list"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an Amazon Web Services Region. Additional
	// traffic is distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroup) GoString() string {
	return s.String()
}

// SetEndpointDescriptions sets the EndpointDescriptions field's value.
func (s *EndpointGroup) SetEndpointDescriptions(v []*EndpointDescription) *EndpointGroup {
	s.EndpointDescriptions = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *EndpointGroup) SetEndpointGroupArn(v string) *EndpointGroup {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *EndpointGroup) SetEndpointGroupRegion(v string) *EndpointGroup {
	s.EndpointGroupRegion = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *EndpointGroup) SetHealthCheckIntervalSeconds(v int64) *EndpointGroup {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *EndpointGroup) SetHealthCheckPath(v string) *EndpointGroup {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *EndpointGroup) SetHealthCheckPort(v int64) *EndpointGroup {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *EndpointGroup) SetHealthCheckProtocol(v string) *EndpointGroup {
	s.HealthCheckProtocol = &v
	return s
}

// SetPortOverrides sets the PortOverrides field's value.
func (s *EndpointGroup) SetPortOverrides(v []*PortOverride) *EndpointGroup {
	s.PortOverrides = v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *EndpointGroup) SetThresholdCount(v int64) *EndpointGroup {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *EndpointGroup) SetTrafficDialPercentage(v float64) *EndpointGroup {
	s.TrafficDialPercentage = &v
	return s
}

// The endpoint group that you specified already exists.
type EndpointGroupAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroupAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroupAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorEndpointGroupAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &EndpointGroupAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointGroupAlreadyExistsException) Code() string {
	return "EndpointGroupAlreadyExistsException"
}

// Message returns the exception's message.
func (s *EndpointGroupAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointGroupAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *EndpointGroupAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointGroupAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointGroupAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The endpoint group that you specified doesn't exist.
type EndpointGroupNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroupNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointGroupNotFoundException) GoString() string {
	return s.String()
}

func newErrorEndpointGroupNotFoundException(v protocol.ResponseMetadata) error {
	return &EndpointGroupNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointGroupNotFoundException) Code() string {
	return "EndpointGroupNotFoundException"
}

// Message returns the exception's message.
func (s *EndpointGroupNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointGroupNotFoundException) OrigErr() error {
	return nil
}

func (s *EndpointGroupNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointGroupNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointGroupNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type for an endpoint. Specifies information about the endpoint
// to remove from the endpoint group.
type EndpointIdentifier struct {
	_ struct{} `type:"structure"`

	// Indicates whether client IP address preservation is enabled for an endpoint.
	// The value is true or false.
	//
	// If the value is set to true, the client's IP address is preserved in the
	// X-Forwarded-For request header as traffic travels to applications on the
	// endpoint fronted by the accelerator.
	ClientIPPreservationEnabled *bool `type:"boolean"`

	// An ID for the endpoint. If the endpoint is a Network Load Balancer or Application
	// Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If
	// the endpoint is an Elastic IP address, this is the Elastic IP address allocation
	// ID. For Amazon EC2 instances, this is the EC2 instance ID.
	//
	// An Application Load Balancer can be either internal or internet-facing.
	//
	// EndpointId is a required field
	EndpointId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointIdentifier"}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIPPreservationEnabled sets the ClientIPPreservationEnabled field's value.
func (s *EndpointIdentifier) SetClientIPPreservationEnabled(v bool) *EndpointIdentifier {
	s.ClientIPPreservationEnabled = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointIdentifier) SetEndpointId(v string) *EndpointIdentifier {
	s.EndpointId = &v
	return s
}

// The endpoint that you specified doesn't exist.
type EndpointNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointNotFoundException) GoString() string {
	return s.String()
}

func newErrorEndpointNotFoundException(v protocol.ResponseMetadata) error {
	return &EndpointNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EndpointNotFoundException) Code() string {
	return "EndpointNotFoundException"
}

// Message returns the exception's message.
func (s *EndpointNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EndpointNotFoundException) OrigErr() error {
	return nil
}

func (s *EndpointNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EndpointNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EndpointNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The CIDR that you specified is not valid for this action. For example, the
// state of the CIDR might be incorrect for this action.
type IncorrectCidrStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectCidrStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectCidrStateException) GoString() string {
	return s.String()
}

func newErrorIncorrectCidrStateException(v protocol.ResponseMetadata) error {
	return &IncorrectCidrStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectCidrStateException) Code() string {
	return "IncorrectCidrStateException"
}

// Message returns the exception's message.
func (s *IncorrectCidrStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectCidrStateException) OrigErr() error {
	return nil
}

func (s *IncorrectCidrStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectCidrStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectCidrStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was an internal error for Global Accelerator.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An argument that you specified is invalid.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There isn't another item to return.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The port numbers that you specified are not valid numbers or are not unique
// for this accelerator.
type InvalidPortRangeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPortRangeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPortRangeException) GoString() string {
	return s.String()
}

func newErrorInvalidPortRangeException(v protocol.ResponseMetadata) error {
	return &InvalidPortRangeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPortRangeException) Code() string {
	return "InvalidPortRangeException"
}

// Message returns the exception's message.
func (s *InvalidPortRangeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPortRangeException) OrigErr() error {
	return nil
}

func (s *InvalidPortRangeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPortRangeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPortRangeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type for the set of IP addresses for an accelerator.
type IpSet struct {
	_ struct{} `type:"structure"`

	// The types of IP addresses included in this IP set.
	IpAddressFamily *string `type:"string" enum:"IpAddressFamily"`

	// The array of IP addresses in the IP address set. An IP address set can have
	// a maximum of two IP addresses.
	IpAddresses []*string `type:"list"`

	// IpFamily is deprecated and has been replaced by IpAddressFamily.
	//
	// Deprecated: IpFamily has been replaced by IpAddressFamily
	IpFamily *string `deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpSet) GoString() string {
	return s.String()
}

// SetIpAddressFamily sets the IpAddressFamily field's value.
func (s *IpSet) SetIpAddressFamily(v string) *IpSet {
	s.IpAddressFamily = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *IpSet) SetIpAddresses(v []*string) *IpSet {
	s.IpAddresses = v
	return s
}

// SetIpFamily sets the IpFamily field's value.
func (s *IpSet) SetIpFamily(v string) *IpSet {
	s.IpFamily = &v
	return s
}

// Processing your request would cause you to exceed an Global Accelerator limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAcceleratorsInput struct {
	_ struct{} `type:"structure"`

	// The number of Global Accelerator objects that you want to return with this
	// call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAcceleratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAcceleratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAcceleratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAcceleratorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAcceleratorsInput) SetMaxResults(v int64) *ListAcceleratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAcceleratorsInput) SetNextToken(v string) *ListAcceleratorsInput {
	s.NextToken = &v
	return s
}

type ListAcceleratorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of accelerators for a customer account.
	Accelerators []*Accelerator `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAcceleratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAcceleratorsOutput) GoString() string {
	return s.String()
}

// SetAccelerators sets the Accelerators field's value.
func (s *ListAcceleratorsOutput) SetAccelerators(v []*Accelerator) *ListAcceleratorsOutput {
	s.Accelerators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAcceleratorsOutput) SetNextToken(v string) *ListAcceleratorsOutput {
	s.NextToken = &v
	return s
}

type ListByoipCidrsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListByoipCidrsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListByoipCidrsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListByoipCidrsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListByoipCidrsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListByoipCidrsInput) SetMaxResults(v int64) *ListByoipCidrsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListByoipCidrsInput) SetNextToken(v string) *ListByoipCidrsInput {
	s.NextToken = &v
	return s
}

type ListByoipCidrsOutput struct {
	_ struct{} `type:"structure"`

	// Information about your address ranges.
	ByoipCidrs []*ByoipCidr `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListByoipCidrsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListByoipCidrsOutput) GoString() string {
	return s.String()
}

// SetByoipCidrs sets the ByoipCidrs field's value.
func (s *ListByoipCidrsOutput) SetByoipCidrs(v []*ByoipCidr) *ListByoipCidrsOutput {
	s.ByoipCidrs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListByoipCidrsOutput) SetNextToken(v string) *ListByoipCidrsOutput {
	s.NextToken = &v
	return s
}

type ListCrossAccountAttachmentsInput struct {
	_ struct{} `type:"structure"`

	// The number of cross-account attachment objects that you want to return with
	// this call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAttachmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAttachmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCrossAccountAttachmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCrossAccountAttachmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCrossAccountAttachmentsInput) SetMaxResults(v int64) *ListCrossAccountAttachmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountAttachmentsInput) SetNextToken(v string) *ListCrossAccountAttachmentsInput {
	s.NextToken = &v
	return s
}

type ListCrossAccountAttachmentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the cross-account attachments.
	CrossAccountAttachments []*Attachment `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAttachmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAttachmentsOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAttachments sets the CrossAccountAttachments field's value.
func (s *ListCrossAccountAttachmentsOutput) SetCrossAccountAttachments(v []*Attachment) *ListCrossAccountAttachmentsOutput {
	s.CrossAccountAttachments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountAttachmentsOutput) SetNextToken(v string) *ListCrossAccountAttachmentsOutput {
	s.NextToken = &v
	return s
}

type ListCrossAccountResourceAccountsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourceAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourceAccountsInput) GoString() string {
	return s.String()
}

type ListCrossAccountResourceAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The account IDs of principals (resource owners) in a cross-account attachment
	// who can work with resources listed in the same attachment.
	ResourceOwnerAwsAccountIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourceAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourceAccountsOutput) GoString() string {
	return s.String()
}

// SetResourceOwnerAwsAccountIds sets the ResourceOwnerAwsAccountIds field's value.
func (s *ListCrossAccountResourceAccountsOutput) SetResourceOwnerAwsAccountIds(v []*string) *ListCrossAccountResourceAccountsOutput {
	s.ResourceOwnerAwsAccountIds = v
	return s
}

type ListCrossAccountResourcesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an accelerator in a cross-account attachment.
	AcceleratorArn *string `type:"string"`

	// The number of cross-account resource objects that you want to return with
	// this call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`

	// The account ID of a resource owner in a cross-account attachment.
	//
	// ResourceOwnerAwsAccountId is a required field
	ResourceOwnerAwsAccountId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCrossAccountResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCrossAccountResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwnerAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwnerAwsAccountId"))
	}
	if s.ResourceOwnerAwsAccountId != nil && len(*s.ResourceOwnerAwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceOwnerAwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *ListCrossAccountResourcesInput) SetAcceleratorArn(v string) *ListCrossAccountResourcesInput {
	s.AcceleratorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCrossAccountResourcesInput) SetMaxResults(v int64) *ListCrossAccountResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountResourcesInput) SetNextToken(v string) *ListCrossAccountResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceOwnerAwsAccountId sets the ResourceOwnerAwsAccountId field's value.
func (s *ListCrossAccountResourcesInput) SetResourceOwnerAwsAccountId(v string) *ListCrossAccountResourcesInput {
	s.ResourceOwnerAwsAccountId = &v
	return s
}

type ListCrossAccountResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The cross-account resources used with an accelerator.
	CrossAccountResources []*CrossAccountResource `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountResourcesOutput) GoString() string {
	return s.String()
}

// SetCrossAccountResources sets the CrossAccountResources field's value.
func (s *ListCrossAccountResourcesOutput) SetCrossAccountResources(v []*CrossAccountResource) *ListCrossAccountResourcesOutput {
	s.CrossAccountResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountResourcesOutput) SetNextToken(v string) *ListCrossAccountResourcesOutput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingAcceleratorsInput struct {
	_ struct{} `type:"structure"`

	// The number of custom routing Global Accelerator objects that you want to
	// return with this call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingAcceleratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingAcceleratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomRoutingAcceleratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomRoutingAcceleratorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomRoutingAcceleratorsInput) SetMaxResults(v int64) *ListCustomRoutingAcceleratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingAcceleratorsInput) SetNextToken(v string) *ListCustomRoutingAcceleratorsInput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingAcceleratorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of custom routing accelerators for a customer account.
	Accelerators []*CustomRoutingAccelerator `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingAcceleratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingAcceleratorsOutput) GoString() string {
	return s.String()
}

// SetAccelerators sets the Accelerators field's value.
func (s *ListCustomRoutingAcceleratorsOutput) SetAccelerators(v []*CustomRoutingAccelerator) *ListCustomRoutingAcceleratorsOutput {
	s.Accelerators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingAcceleratorsOutput) SetNextToken(v string) *ListCustomRoutingAcceleratorsOutput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingEndpointGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to list endpoint groups for.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The number of endpoint group objects that you want to return with this call.
	// The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingEndpointGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingEndpointGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomRoutingEndpointGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomRoutingEndpointGroupsInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *ListCustomRoutingEndpointGroupsInput) SetListenerArn(v string) *ListCustomRoutingEndpointGroupsInput {
	s.ListenerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomRoutingEndpointGroupsInput) SetMaxResults(v int64) *ListCustomRoutingEndpointGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingEndpointGroupsInput) SetNextToken(v string) *ListCustomRoutingEndpointGroupsInput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingEndpointGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the endpoint groups associated with a listener for a custom routing
	// accelerator.
	EndpointGroups []*CustomRoutingEndpointGroup `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingEndpointGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingEndpointGroupsOutput) GoString() string {
	return s.String()
}

// SetEndpointGroups sets the EndpointGroups field's value.
func (s *ListCustomRoutingEndpointGroupsOutput) SetEndpointGroups(v []*CustomRoutingEndpointGroup) *ListCustomRoutingEndpointGroupsOutput {
	s.EndpointGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingEndpointGroupsOutput) SetNextToken(v string) *ListCustomRoutingEndpointGroupsOutput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingListenersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to list listeners for.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// The number of listener objects that you want to return with this call. The
	// default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingListenersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomRoutingListenersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomRoutingListenersInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *ListCustomRoutingListenersInput) SetAcceleratorArn(v string) *ListCustomRoutingListenersInput {
	s.AcceleratorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomRoutingListenersInput) SetMaxResults(v int64) *ListCustomRoutingListenersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingListenersInput) SetNextToken(v string) *ListCustomRoutingListenersInput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingListenersOutput struct {
	_ struct{} `type:"structure"`

	// The list of listeners for a custom routing accelerator.
	Listeners []*CustomRoutingListener `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingListenersOutput) GoString() string {
	return s.String()
}

// SetListeners sets the Listeners field's value.
func (s *ListCustomRoutingListenersOutput) SetListeners(v []*CustomRoutingListener) *ListCustomRoutingListenersOutput {
	s.Listeners = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingListenersOutput) SetNextToken(v string) *ListCustomRoutingListenersOutput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingPortMappingsByDestinationInput struct {
	_ struct{} `type:"structure"`

	// The endpoint IP address in a virtual private cloud (VPC) subnet for which
	// you want to receive back port mappings.
	//
	// DestinationAddress is a required field
	DestinationAddress *string `type:"string" required:"true"`

	// The ID for the virtual private cloud (VPC) subnet.
	//
	// EndpointId is a required field
	EndpointId *string `type:"string" required:"true"`

	// The number of destination port mappings that you want to return with this
	// call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsByDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsByDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomRoutingPortMappingsByDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomRoutingPortMappingsByDestinationInput"}
	if s.DestinationAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationAddress"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationAddress sets the DestinationAddress field's value.
func (s *ListCustomRoutingPortMappingsByDestinationInput) SetDestinationAddress(v string) *ListCustomRoutingPortMappingsByDestinationInput {
	s.DestinationAddress = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *ListCustomRoutingPortMappingsByDestinationInput) SetEndpointId(v string) *ListCustomRoutingPortMappingsByDestinationInput {
	s.EndpointId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomRoutingPortMappingsByDestinationInput) SetMaxResults(v int64) *ListCustomRoutingPortMappingsByDestinationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingPortMappingsByDestinationInput) SetNextToken(v string) *ListCustomRoutingPortMappingsByDestinationInput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingPortMappingsByDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The port mappings for the endpoint IP address that you specified in the request.
	DestinationPortMappings []*DestinationPortMapping `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsByDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsByDestinationOutput) GoString() string {
	return s.String()
}

// SetDestinationPortMappings sets the DestinationPortMappings field's value.
func (s *ListCustomRoutingPortMappingsByDestinationOutput) SetDestinationPortMappings(v []*DestinationPortMapping) *ListCustomRoutingPortMappingsByDestinationOutput {
	s.DestinationPortMappings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingPortMappingsByDestinationOutput) SetNextToken(v string) *ListCustomRoutingPortMappingsByDestinationOutput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingPortMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to list the custom routing
	// port mappings for.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint group to list the custom routing
	// port mappings for.
	EndpointGroupArn *string `type:"string"`

	// The number of destination port mappings that you want to return with this
	// call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomRoutingPortMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomRoutingPortMappingsInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *ListCustomRoutingPortMappingsInput) SetAcceleratorArn(v string) *ListCustomRoutingPortMappingsInput {
	s.AcceleratorArn = &v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *ListCustomRoutingPortMappingsInput) SetEndpointGroupArn(v string) *ListCustomRoutingPortMappingsInput {
	s.EndpointGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomRoutingPortMappingsInput) SetMaxResults(v int64) *ListCustomRoutingPortMappingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingPortMappingsInput) SetNextToken(v string) *ListCustomRoutingPortMappingsInput {
	s.NextToken = &v
	return s
}

type ListCustomRoutingPortMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`

	// The port mappings for a custom routing accelerator.
	PortMappings []*PortMapping `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomRoutingPortMappingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomRoutingPortMappingsOutput) SetNextToken(v string) *ListCustomRoutingPortMappingsOutput {
	s.NextToken = &v
	return s
}

// SetPortMappings sets the PortMappings field's value.
func (s *ListCustomRoutingPortMappingsOutput) SetPortMappings(v []*PortMapping) *ListCustomRoutingPortMappingsOutput {
	s.PortMappings = v
	return s
}

type ListEndpointGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The number of endpoint group objects that you want to return with this call.
	// The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointGroupsInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *ListEndpointGroupsInput) SetListenerArn(v string) *ListEndpointGroupsInput {
	s.ListenerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointGroupsInput) SetMaxResults(v int64) *ListEndpointGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointGroupsInput) SetNextToken(v string) *ListEndpointGroupsInput {
	s.NextToken = &v
	return s
}

type ListEndpointGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the endpoint groups associated with a listener.
	EndpointGroups []*EndpointGroup `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointGroupsOutput) GoString() string {
	return s.String()
}

// SetEndpointGroups sets the EndpointGroups field's value.
func (s *ListEndpointGroupsOutput) SetEndpointGroups(v []*EndpointGroup) *ListEndpointGroupsOutput {
	s.EndpointGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointGroupsOutput) SetNextToken(v string) *ListEndpointGroupsOutput {
	s.NextToken = &v
	return s
}

type ListListenersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator for which you want to list
	// listener objects.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// The number of listener objects that you want to return with this call. The
	// default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListListenersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListListenersInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *ListListenersInput) SetAcceleratorArn(v string) *ListListenersInput {
	s.AcceleratorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListListenersInput) SetMaxResults(v int64) *ListListenersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersInput) SetNextToken(v string) *ListListenersInput {
	s.NextToken = &v
	return s
}

type ListListenersOutput struct {
	_ struct{} `type:"structure"`

	// The list of listeners for an accelerator.
	Listeners []*Listener `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListListenersOutput) GoString() string {
	return s.String()
}

// SetListeners sets the Listeners field's value.
func (s *ListListenersOutput) SetListeners(v []*Listener) *ListListenersOutput {
	s.Listeners = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersOutput) SetNextToken(v string) *ListListenersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN
	// uniquely identifies an accelerator.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Root level tag for the Tags parameters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type for a listener.
type Listener struct {
	_ struct{} `type:"structure"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Client affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// Global Accelerator uses a consistent-flow hashing algorithm to choose the
	// optimal endpoint for a connection. If client affinity is NONE, Global Accelerator
	// uses the "five-tuple" (5-tuple) properties—source IP address, source port,
	// destination IP address, destination port, and protocol—to select the hash
	// value, and then chooses the best endpoint. However, with this setting, if
	// someone uses different ports to connect to Global Accelerator, their connections
	// might not be always routed to the same endpoint because the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The list of port ranges for the connections from clients to the accelerator.
	PortRanges []*PortRange `min:"1" type:"list"`

	// The protocol for the connections from clients to the accelerator.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Listener) GoString() string {
	return s.String()
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *Listener) SetClientAffinity(v string) *Listener {
	s.ClientAffinity = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *Listener) SetListenerArn(v string) *Listener {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *Listener) SetPortRanges(v []*PortRange) *Listener {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Listener) SetProtocol(v string) *Listener {
	s.Protocol = &v
	return s
}

// The listener that you specified doesn't exist.
type ListenerNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListenerNotFoundException) GoString() string {
	return s.String()
}

func newErrorListenerNotFoundException(v protocol.ResponseMetadata) error {
	return &ListenerNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ListenerNotFoundException) Code() string {
	return "ListenerNotFoundException"
}

// Message returns the exception's message.
func (s *ListenerNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ListenerNotFoundException) OrigErr() error {
	return nil
}

func (s *ListenerNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ListenerNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ListenerNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns the ports and associated IP addresses and ports of Amazon EC2 instances
// in your virtual private cloud (VPC) subnets. Custom routing is a port mapping
// protocol in Global Accelerator that statically associates port ranges with
// VPC subnets, which allows Global Accelerator to route to specific instances
// and ports within one or more subnets.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The accelerator port.
	AcceleratorPort *int64 `min:"1" type:"integer"`

	// The EC2 instance IP address and port number in the virtual private cloud
	// (VPC) subnet.
	DestinationSocketAddress *SocketAddress `type:"structure"`

	// Indicates whether or not a port mapping destination can receive traffic.
	// The value is either ALLOW, if traffic is allowed to the destination, or DENY,
	// if traffic is not allowed to the destination.
	DestinationTrafficState *string `type:"string" enum:"CustomRoutingDestinationTrafficState"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`

	// The IP address of the VPC subnet (the subnet ID).
	EndpointId *string `type:"string"`

	// The protocols supported by the endpoint group.
	Protocols []*string `min:"1" type:"list" enum:"CustomRoutingProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortMapping) GoString() string {
	return s.String()
}

// SetAcceleratorPort sets the AcceleratorPort field's value.
func (s *PortMapping) SetAcceleratorPort(v int64) *PortMapping {
	s.AcceleratorPort = &v
	return s
}

// SetDestinationSocketAddress sets the DestinationSocketAddress field's value.
func (s *PortMapping) SetDestinationSocketAddress(v *SocketAddress) *PortMapping {
	s.DestinationSocketAddress = v
	return s
}

// SetDestinationTrafficState sets the DestinationTrafficState field's value.
func (s *PortMapping) SetDestinationTrafficState(v string) *PortMapping {
	s.DestinationTrafficState = &v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *PortMapping) SetEndpointGroupArn(v string) *PortMapping {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *PortMapping) SetEndpointId(v string) *PortMapping {
	s.EndpointId = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *PortMapping) SetProtocols(v []*string) *PortMapping {
	s.Protocols = v
	return s
}

// Override specific listener ports used to route traffic to endpoints that
// are part of an endpoint group. For example, you can create a port override
// in which the listener receives user traffic on ports 80 and 443, but your
// accelerator routes that traffic to ports 1080 and 1443, respectively, on
// the endpoints.
//
// For more information, see Overriding listener ports (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
// in the Global Accelerator Developer Guide.
type PortOverride struct {
	_ struct{} `type:"structure"`

	// The endpoint port that you want a listener port to be mapped to. This is
	// the port on the endpoint, such as the Application Load Balancer or Amazon
	// EC2 instance.
	EndpointPort *int64 `min:"1" type:"integer"`

	// The listener port that you want to map to a specific endpoint port. This
	// is the port that user traffic arrives to the Global Accelerator on.
	ListenerPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortOverride"}
	if s.EndpointPort != nil && *s.EndpointPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndpointPort", 1))
	}
	if s.ListenerPort != nil && *s.ListenerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ListenerPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointPort sets the EndpointPort field's value.
func (s *PortOverride) SetEndpointPort(v int64) *PortOverride {
	s.EndpointPort = &v
	return s
}

// SetListenerPort sets the ListenerPort field's value.
func (s *PortOverride) SetListenerPort(v int64) *PortOverride {
	s.ListenerPort = &v
	return s
}

// A complex type for a range of ports for a listener.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the range of ports, inclusive.
	FromPort *int64 `min:"1" type:"integer"`

	// The last port in the range of ports, inclusive.
	ToPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortRange"}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *PortRange) SetFromPort(v int64) *PortRange {
	s.FromPort = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *PortRange) SetToPort(v int64) *PortRange {
	s.ToPort = &v
	return s
}

type ProvisionByoipCidrInput struct {
	_ struct{} `type:"structure"`

	// The public IPv4 address range, in CIDR notation. The most specific IP prefix
	// that you can specify is /24. The address range cannot overlap with another
	// address range that you've brought to this Amazon Web Services Region or another
	// Region.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`

	// A signed document that proves that you are authorized to bring the specified
	// IP address range to Amazon using BYOIP.
	//
	// CidrAuthorizationContext is a required field
	CidrAuthorizationContext *CidrAuthorizationContext `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionByoipCidrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionByoipCidrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionByoipCidrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionByoipCidrInput"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}
	if s.CidrAuthorizationContext == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrAuthorizationContext"))
	}
	if s.CidrAuthorizationContext != nil {
		if err := s.CidrAuthorizationContext.Validate(); err != nil {
			invalidParams.AddNested("CidrAuthorizationContext", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *ProvisionByoipCidrInput) SetCidr(v string) *ProvisionByoipCidrInput {
	s.Cidr = &v
	return s
}

// SetCidrAuthorizationContext sets the CidrAuthorizationContext field's value.
func (s *ProvisionByoipCidrInput) SetCidrAuthorizationContext(v *CidrAuthorizationContext) *ProvisionByoipCidrInput {
	s.CidrAuthorizationContext = v
	return s
}

type ProvisionByoipCidrOutput struct {
	_ struct{} `type:"structure"`

	// Information about the address range.
	ByoipCidr *ByoipCidr `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionByoipCidrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionByoipCidrOutput) GoString() string {
	return s.String()
}

// SetByoipCidr sets the ByoipCidr field's value.
func (s *ProvisionByoipCidrOutput) SetByoipCidr(v *ByoipCidr) *ProvisionByoipCidrOutput {
	s.ByoipCidr = v
	return s
}

type RemoveCustomRoutingEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to remove endpoints
	// from.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// The IDs for the endpoints. For custom routing accelerators, endpoint IDs
	// are the virtual private cloud (VPC) subnet IDs.
	//
	// EndpointIds is a required field
	EndpointIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveCustomRoutingEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveCustomRoutingEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveCustomRoutingEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveCustomRoutingEndpointsInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.EndpointIds == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *RemoveCustomRoutingEndpointsInput) SetEndpointGroupArn(v string) *RemoveCustomRoutingEndpointsInput {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointIds sets the EndpointIds field's value.
func (s *RemoveCustomRoutingEndpointsInput) SetEndpointIds(v []*string) *RemoveCustomRoutingEndpointsInput {
	s.EndpointIds = v
	return s
}

type RemoveCustomRoutingEndpointsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveCustomRoutingEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveCustomRoutingEndpointsOutput) GoString() string {
	return s.String()
}

type RemoveEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// The identifiers of the endpoints that you want to remove.
	//
	// EndpointIdentifiers is a required field
	EndpointIdentifiers []*EndpointIdentifier `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveEndpointsInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.EndpointIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIdentifiers"))
	}
	if s.EndpointIdentifiers != nil && len(s.EndpointIdentifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointIdentifiers", 1))
	}
	if s.EndpointIdentifiers != nil {
		for i, v := range s.EndpointIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EndpointIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *RemoveEndpointsInput) SetEndpointGroupArn(v string) *RemoveEndpointsInput {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointIdentifiers sets the EndpointIdentifiers field's value.
func (s *RemoveEndpointsInput) SetEndpointIdentifiers(v []*EndpointIdentifier) *RemoveEndpointsInput {
	s.EndpointIdentifiers = v
	return s
}

type RemoveEndpointsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveEndpointsOutput) GoString() string {
	return s.String()
}

// A resource is one of the following: the ARN for an Amazon Web Services resource
// that is supported by Global Accelerator to be added as an endpoint, or a
// CIDR range that specifies a bring your own IP (BYOIP) address pool.
type Resource struct {
	_ struct{} `type:"structure"`

	// An IP address range, in CIDR format, that is specified as resource. The address
	// must be provisioned and advertised in Global Accelerator by following the
	// bring your own IP address (BYOIP) process for Global Accelerator
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	Cidr *string `type:"string"`

	// The endpoint ID for the endpoint that is specified as a Amazon Web Services
	// resource.
	//
	// An endpoint ID for the cross-account feature is the ARN of an Amazon Web
	// Services resource, such as a Network Load Balancer, that Global Accelerator
	// supports as an endpoint for an accelerator.
	EndpointId *string `type:"string"`

	// The Amazon Web Services Region where a shared endpoint resource is located.
	Region *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *Resource) SetCidr(v string) *Resource {
	s.Cidr = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *Resource) SetEndpointId(v string) *Resource {
	s.EndpointId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// An IP address/port combination.
type SocketAddress struct {
	_ struct{} `type:"structure"`

	// The IP address for the socket address.
	IpAddress *string `type:"string"`

	// The port for the socket address.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SocketAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SocketAddress) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *SocketAddress) SetIpAddress(v string) *SocketAddress {
	s.IpAddress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SocketAddress) SetPort(v int64) *SocketAddress {
	s.Port = &v
	return s
}

// A complex type that contains a Tag key and Tag value.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that contains a Tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that contains a Tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Global Accelerator resource to add
	// tags to. An ARN uniquely identifies a resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags to add to a resource. A tag consists of a key and a value that you
	// define.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// There's already a transaction in progress. Another transaction can't be processed.
type TransactionInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionInProgressException) GoString() string {
	return s.String()
}

func newErrorTransactionInProgressException(v protocol.ResponseMetadata) error {
	return &TransactionInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TransactionInProgressException) Code() string {
	return "TransactionInProgressException"
}

// Message returns the exception's message.
func (s *TransactionInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TransactionInProgressException) OrigErr() error {
	return nil
}

func (s *TransactionInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TransactionInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TransactionInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Global Accelerator resource to remove
	// tags from. An ARN uniquely identifies a resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tag key pairs that you want to remove from the specified resources.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator that you want to update.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Update whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow Logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// Update the prefix for the location in the Amazon S3 bucket for the flow logs.
	// Attribute is required if FlowLogsEnabled is true.
	//
	// If you specify slash (/) for the S3 bucket prefix, the log file bucket folder
	// structure will include a double slash (//), like the following:
	//
	// s3-bucket_name//AWSLogs/aws_account_id
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateAcceleratorAttributesInput) SetAcceleratorArn(v string) *UpdateAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsEnabled(v bool) *UpdateAcceleratorAttributesInput {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsS3Bucket(v string) *UpdateAcceleratorAttributesInput {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsS3Prefix(v string) *UpdateAcceleratorAttributesInput {
	s.FlowLogsS3Prefix = &v
	return s
}

type UpdateAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Updated attributes for the accelerator.
	AcceleratorAttributes *AcceleratorAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *UpdateAcceleratorAttributesOutput) SetAcceleratorAttributes(v *AcceleratorAttributes) *UpdateAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type UpdateAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to update.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// The IP address type that an accelerator supports. For a standard accelerator,
	// the value can be IPV4 or DUAL_STACK.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The IP addresses for an accelerator.
	IpAddresses []*string `type:"list"`

	// The name of the accelerator. The name can have a maximum of 64 characters,
	// must contain only alphanumeric characters, periods (.), or hyphens (-), and
	// must not begin or end with a hyphen or period.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateAcceleratorInput) SetAcceleratorArn(v string) *UpdateAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateAcceleratorInput) SetEnabled(v bool) *UpdateAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *UpdateAcceleratorInput) SetIpAddressType(v string) *UpdateAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *UpdateAcceleratorInput) SetIpAddresses(v []*string) *UpdateAcceleratorInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAcceleratorInput) SetName(v string) *UpdateAcceleratorInput {
	s.Name = &v
	return s
}

type UpdateAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated accelerator.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *UpdateAcceleratorOutput) SetAccelerator(v *Accelerator) *UpdateAcceleratorOutput {
	s.Accelerator = v
	return s
}

type UpdateCrossAccountAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The principals to add to the cross-account attachment. A principal is an
	// account or the Amazon Resource Name (ARN) of an accelerator that the attachment
	// gives permission to work with resources from another account. The resources
	// are also listed in the attachment.
	//
	// To add more than one principal, separate the account numbers or accelerator
	// ARNs, or both, with commas.
	AddPrincipals []*string `type:"list"`

	// The resources to add to the cross-account attachment. A resource listed in
	// a cross-account attachment can be used with an accelerator by the principals
	// that are listed in the attachment.
	//
	// To add more than one resource, separate the resource ARNs with commas.
	AddResources []*Resource `type:"list"`

	// The Amazon Resource Name (ARN) of the cross-account attachment to update.
	//
	// AttachmentArn is a required field
	AttachmentArn *string `type:"string" required:"true"`

	// The name of the cross-account attachment.
	Name *string `type:"string"`

	// The principals to remove from the cross-account attachment. A principal is
	// an account or the Amazon Resource Name (ARN) of an accelerator that the attachment
	// gives permission to work with resources from another account. The resources
	// are also listed in the attachment.
	//
	// To remove more than one principal, separate the account numbers or accelerator
	// ARNs, or both, with commas.
	RemovePrincipals []*string `type:"list"`

	// The resources to remove from the cross-account attachment. A resource listed
	// in a cross-account attachment can be used with an accelerator by the principals
	// that are listed in the attachment.
	//
	// To remove more than one resource, separate the resource ARNs with commas.
	RemoveResources []*Resource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrossAccountAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrossAccountAttachmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCrossAccountAttachmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCrossAccountAttachmentInput"}
	if s.AttachmentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddPrincipals sets the AddPrincipals field's value.
func (s *UpdateCrossAccountAttachmentInput) SetAddPrincipals(v []*string) *UpdateCrossAccountAttachmentInput {
	s.AddPrincipals = v
	return s
}

// SetAddResources sets the AddResources field's value.
func (s *UpdateCrossAccountAttachmentInput) SetAddResources(v []*Resource) *UpdateCrossAccountAttachmentInput {
	s.AddResources = v
	return s
}

// SetAttachmentArn sets the AttachmentArn field's value.
func (s *UpdateCrossAccountAttachmentInput) SetAttachmentArn(v string) *UpdateCrossAccountAttachmentInput {
	s.AttachmentArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCrossAccountAttachmentInput) SetName(v string) *UpdateCrossAccountAttachmentInput {
	s.Name = &v
	return s
}

// SetRemovePrincipals sets the RemovePrincipals field's value.
func (s *UpdateCrossAccountAttachmentInput) SetRemovePrincipals(v []*string) *UpdateCrossAccountAttachmentInput {
	s.RemovePrincipals = v
	return s
}

// SetRemoveResources sets the RemoveResources field's value.
func (s *UpdateCrossAccountAttachmentInput) SetRemoveResources(v []*Resource) *UpdateCrossAccountAttachmentInput {
	s.RemoveResources = v
	return s
}

type UpdateCrossAccountAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated cross-account attachment.
	CrossAccountAttachment *Attachment `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrossAccountAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrossAccountAttachmentOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAttachment sets the CrossAccountAttachment field's value.
func (s *UpdateCrossAccountAttachmentOutput) SetCrossAccountAttachment(v *Attachment) *UpdateCrossAccountAttachmentOutput {
	s.CrossAccountAttachment = v
	return s
}

type UpdateCustomRoutingAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom routing accelerator to update
	// attributes for.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Update whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// Update the prefix for the location in the Amazon S3 bucket for the flow logs.
	// Attribute is required if FlowLogsEnabled is true.
	//
	// If you don’t specify a prefix, the flow logs are stored in the root of
	// the bucket. If you specify slash (/) for the S3 bucket prefix, the log file
	// bucket folder structure will include a double slash (//), like the following:
	//
	// DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomRoutingAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomRoutingAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateCustomRoutingAcceleratorAttributesInput) SetAcceleratorArn(v string) *UpdateCustomRoutingAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *UpdateCustomRoutingAcceleratorAttributesInput) SetFlowLogsEnabled(v bool) *UpdateCustomRoutingAcceleratorAttributesInput {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *UpdateCustomRoutingAcceleratorAttributesInput) SetFlowLogsS3Bucket(v string) *UpdateCustomRoutingAcceleratorAttributesInput {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *UpdateCustomRoutingAcceleratorAttributesInput) SetFlowLogsS3Prefix(v string) *UpdateCustomRoutingAcceleratorAttributesInput {
	s.FlowLogsS3Prefix = &v
	return s
}

type UpdateCustomRoutingAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Updated custom routing accelerator.
	AcceleratorAttributes *CustomRoutingAcceleratorAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *UpdateCustomRoutingAcceleratorAttributesOutput) SetAcceleratorAttributes(v *CustomRoutingAcceleratorAttributes) *UpdateCustomRoutingAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type UpdateCustomRoutingAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to update.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// The IP address type that an accelerator supports. For a custom routing accelerator,
	// the value must be IPV4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The IP addresses for an accelerator.
	IpAddresses []*string `type:"list"`

	// The name of the accelerator. The name can have a maximum of 64 characters,
	// must contain only alphanumeric characters, periods (.), or hyphens (-), and
	// must not begin or end with a hyphen or period.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomRoutingAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomRoutingAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateCustomRoutingAcceleratorInput) SetAcceleratorArn(v string) *UpdateCustomRoutingAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateCustomRoutingAcceleratorInput) SetEnabled(v bool) *UpdateCustomRoutingAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *UpdateCustomRoutingAcceleratorInput) SetIpAddressType(v string) *UpdateCustomRoutingAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *UpdateCustomRoutingAcceleratorInput) SetIpAddresses(v []*string) *UpdateCustomRoutingAcceleratorInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCustomRoutingAcceleratorInput) SetName(v string) *UpdateCustomRoutingAcceleratorInput {
	s.Name = &v
	return s
}

type UpdateCustomRoutingAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated custom routing accelerator.
	Accelerator *CustomRoutingAccelerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *UpdateCustomRoutingAcceleratorOutput) SetAccelerator(v *CustomRoutingAccelerator) *UpdateCustomRoutingAcceleratorOutput {
	s.Accelerator = v
	return s
}

type UpdateCustomRoutingListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to update.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The updated port range to support for connections from clients to your accelerator.
	// If you remove ports that are currently being used by a subnet endpoint, the
	// call fails.
	//
	// Separately, you set port ranges for endpoints. For more information, see
	// About endpoints for custom routing accelerators (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).
	//
	// PortRanges is a required field
	PortRanges []*PortRange `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomRoutingListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomRoutingListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.PortRanges == nil {
		invalidParams.Add(request.NewErrParamRequired("PortRanges"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *UpdateCustomRoutingListenerInput) SetListenerArn(v string) *UpdateCustomRoutingListenerInput {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *UpdateCustomRoutingListenerInput) SetPortRanges(v []*PortRange) *UpdateCustomRoutingListenerInput {
	s.PortRanges = v
	return s
}

type UpdateCustomRoutingListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information for the updated listener for a custom routing accelerator.
	Listener *CustomRoutingListener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomRoutingListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *UpdateCustomRoutingListenerOutput) SetListener(v *CustomRoutingListener) *UpdateCustomRoutingListenerOutput {
	s.Listener = v
	return s
}

type UpdateEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects. A resource must be valid and active when you
	// add it as an endpoint.
	EndpointConfigurations []*EndpointConfiguration `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// The time—10 seconds or 30 seconds—between each health check for an endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this specifies the path that is the destination
	// for health check targets. The default value is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that Global Accelerator uses to check the health of endpoints that
	// are part of this endpoint group. The default port is the listener port that
	// this endpoint group is associated with. If the listener port is a list of
	// ports, Global Accelerator uses the first port in the list.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// Override specific listener ports used to route traffic to endpoints that
	// are part of this endpoint group. For example, you can create a port override
	// in which the listener receives user traffic on ports 80 and 443, but your
	// accelerator routes that traffic to ports 1080 and 1443, respectively, on
	// the endpoints.
	//
	// For more information, see Overriding listener ports (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
	// in the Global Accelerator Developer Guide.
	PortOverrides []*PortOverride `type:"list"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an Amazon Web Services Region. Additional
	// traffic is distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 10 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 10))
	}
	if s.HealthCheckPort != nil && *s.HealthCheckPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckPort", 1))
	}
	if s.ThresholdCount != nil && *s.ThresholdCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThresholdCount", 1))
	}
	if s.PortOverrides != nil {
		for i, v := range s.PortOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *UpdateEndpointGroupInput) SetEndpointConfigurations(v []*EndpointConfiguration) *UpdateEndpointGroupInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *UpdateEndpointGroupInput) SetEndpointGroupArn(v string) *UpdateEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckIntervalSeconds(v int64) *UpdateEndpointGroupInput {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckPath(v string) *UpdateEndpointGroupInput {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckPort(v int64) *UpdateEndpointGroupInput {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckProtocol(v string) *UpdateEndpointGroupInput {
	s.HealthCheckProtocol = &v
	return s
}

// SetPortOverrides sets the PortOverrides field's value.
func (s *UpdateEndpointGroupInput) SetPortOverrides(v []*PortOverride) *UpdateEndpointGroupInput {
	s.PortOverrides = v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *UpdateEndpointGroupInput) SetThresholdCount(v int64) *UpdateEndpointGroupInput {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *UpdateEndpointGroupInput) SetTrafficDialPercentage(v float64) *UpdateEndpointGroupInput {
	s.TrafficDialPercentage = &v
	return s
}

type UpdateEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The information about the endpoint group that was updated.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *UpdateEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *UpdateEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type UpdateListenerInput struct {
	_ struct{} `type:"structure"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Client affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// Global Accelerator uses a consistent-flow hashing algorithm to choose the
	// optimal endpoint for a connection. If client affinity is NONE, Global Accelerator
	// uses the "five-tuple" (5-tuple) properties—source IP address, source port,
	// destination IP address, destination port, and protocol—to select the hash
	// value, and then chooses the best endpoint. However, with this setting, if
	// someone uses different ports to connect to Global Accelerator, their connections
	// might not be always routed to the same endpoint because the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// The Amazon Resource Name (ARN) of the listener to update.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The updated list of port ranges for the connections from clients to the accelerator.
	PortRanges []*PortRange `min:"1" type:"list"`

	// The updated protocol for the connections from clients to the accelerator.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *UpdateListenerInput) SetClientAffinity(v string) *UpdateListenerInput {
	s.ClientAffinity = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *UpdateListenerInput) SetListenerArn(v string) *UpdateListenerInput {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *UpdateListenerInput) SetPortRanges(v []*PortRange) *UpdateListenerInput {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateListenerInput) SetProtocol(v string) *UpdateListenerInput {
	s.Protocol = &v
	return s
}

type UpdateListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information for the updated listener.
	Listener *Listener `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *UpdateListenerOutput) SetListener(v *Listener) *UpdateListenerOutput {
	s.Listener = v
	return s
}

type WithdrawByoipCidrInput struct {
	_ struct{} `type:"structure"`

	// The address range, in CIDR notation.
	//
	// For more information, see Bring your own IP addresses (BYOIP) (https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
	// in the Global Accelerator Developer Guide.
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WithdrawByoipCidrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WithdrawByoipCidrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WithdrawByoipCidrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WithdrawByoipCidrInput"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *WithdrawByoipCidrInput) SetCidr(v string) *WithdrawByoipCidrInput {
	s.Cidr = &v
	return s
}

type WithdrawByoipCidrOutput struct {
	_ struct{} `type:"structure"`

	// Information about the BYOIP address pool.
	ByoipCidr *ByoipCidr `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WithdrawByoipCidrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WithdrawByoipCidrOutput) GoString() string {
	return s.String()
}

// SetByoipCidr sets the ByoipCidr field's value.
func (s *WithdrawByoipCidrOutput) SetByoipCidr(v *ByoipCidr) *WithdrawByoipCidrOutput {
	s.ByoipCidr = v
	return s
}

const (
	// AcceleratorStatusDeployed is a AcceleratorStatus enum value
	AcceleratorStatusDeployed = "DEPLOYED"

	// AcceleratorStatusInProgress is a AcceleratorStatus enum value
	AcceleratorStatusInProgress = "IN_PROGRESS"
)

// AcceleratorStatus_Values returns all elements of the AcceleratorStatus enum
func AcceleratorStatus_Values() []string {
	return []string{
		AcceleratorStatusDeployed,
		AcceleratorStatusInProgress,
	}
}

const (
	// ByoipCidrStatePendingProvisioning is a ByoipCidrState enum value
	ByoipCidrStatePendingProvisioning = "PENDING_PROVISIONING"

	// ByoipCidrStateReady is a ByoipCidrState enum value
	ByoipCidrStateReady = "READY"

	// ByoipCidrStatePendingAdvertising is a ByoipCidrState enum value
	ByoipCidrStatePendingAdvertising = "PENDING_ADVERTISING"

	// ByoipCidrStateAdvertising is a ByoipCidrState enum value
	ByoipCidrStateAdvertising = "ADVERTISING"

	// ByoipCidrStatePendingWithdrawing is a ByoipCidrState enum value
	ByoipCidrStatePendingWithdrawing = "PENDING_WITHDRAWING"

	// ByoipCidrStatePendingDeprovisioning is a ByoipCidrState enum value
	ByoipCidrStatePendingDeprovisioning = "PENDING_DEPROVISIONING"

	// ByoipCidrStateDeprovisioned is a ByoipCidrState enum value
	ByoipCidrStateDeprovisioned = "DEPROVISIONED"

	// ByoipCidrStateFailedProvision is a ByoipCidrState enum value
	ByoipCidrStateFailedProvision = "FAILED_PROVISION"

	// ByoipCidrStateFailedAdvertising is a ByoipCidrState enum value
	ByoipCidrStateFailedAdvertising = "FAILED_ADVERTISING"

	// ByoipCidrStateFailedWithdraw is a ByoipCidrState enum value
	ByoipCidrStateFailedWithdraw = "FAILED_WITHDRAW"

	// ByoipCidrStateFailedDeprovision is a ByoipCidrState enum value
	ByoipCidrStateFailedDeprovision = "FAILED_DEPROVISION"
)

// ByoipCidrState_Values returns all elements of the ByoipCidrState enum
func ByoipCidrState_Values() []string {
	return []string{
		ByoipCidrStatePendingProvisioning,
		ByoipCidrStateReady,
		ByoipCidrStatePendingAdvertising,
		ByoipCidrStateAdvertising,
		ByoipCidrStatePendingWithdrawing,
		ByoipCidrStatePendingDeprovisioning,
		ByoipCidrStateDeprovisioned,
		ByoipCidrStateFailedProvision,
		ByoipCidrStateFailedAdvertising,
		ByoipCidrStateFailedWithdraw,
		ByoipCidrStateFailedDeprovision,
	}
}

const (
	// ClientAffinityNone is a ClientAffinity enum value
	ClientAffinityNone = "NONE"

	// ClientAffinitySourceIp is a ClientAffinity enum value
	ClientAffinitySourceIp = "SOURCE_IP"
)

// ClientAffinity_Values returns all elements of the ClientAffinity enum
func ClientAffinity_Values() []string {
	return []string{
		ClientAffinityNone,
		ClientAffinitySourceIp,
	}
}

const (
	// CustomRoutingAcceleratorStatusDeployed is a CustomRoutingAcceleratorStatus enum value
	CustomRoutingAcceleratorStatusDeployed = "DEPLOYED"

	// CustomRoutingAcceleratorStatusInProgress is a CustomRoutingAcceleratorStatus enum value
	CustomRoutingAcceleratorStatusInProgress = "IN_PROGRESS"
)

// CustomRoutingAcceleratorStatus_Values returns all elements of the CustomRoutingAcceleratorStatus enum
func CustomRoutingAcceleratorStatus_Values() []string {
	return []string{
		CustomRoutingAcceleratorStatusDeployed,
		CustomRoutingAcceleratorStatusInProgress,
	}
}

const (
	// CustomRoutingDestinationTrafficStateAllow is a CustomRoutingDestinationTrafficState enum value
	CustomRoutingDestinationTrafficStateAllow = "ALLOW"

	// CustomRoutingDestinationTrafficStateDeny is a CustomRoutingDestinationTrafficState enum value
	CustomRoutingDestinationTrafficStateDeny = "DENY"
)

// CustomRoutingDestinationTrafficState_Values returns all elements of the CustomRoutingDestinationTrafficState enum
func CustomRoutingDestinationTrafficState_Values() []string {
	return []string{
		CustomRoutingDestinationTrafficStateAllow,
		CustomRoutingDestinationTrafficStateDeny,
	}
}

const (
	// CustomRoutingProtocolTcp is a CustomRoutingProtocol enum value
	CustomRoutingProtocolTcp = "TCP"

	// CustomRoutingProtocolUdp is a CustomRoutingProtocol enum value
	CustomRoutingProtocolUdp = "UDP"
)

// CustomRoutingProtocol_Values returns all elements of the CustomRoutingProtocol enum
func CustomRoutingProtocol_Values() []string {
	return []string{
		CustomRoutingProtocolTcp,
		CustomRoutingProtocolUdp,
	}
}

const (
	// HealthCheckProtocolTcp is a HealthCheckProtocol enum value
	HealthCheckProtocolTcp = "TCP"

	// HealthCheckProtocolHttp is a HealthCheckProtocol enum value
	HealthCheckProtocolHttp = "HTTP"

	// HealthCheckProtocolHttps is a HealthCheckProtocol enum value
	HealthCheckProtocolHttps = "HTTPS"
)

// HealthCheckProtocol_Values returns all elements of the HealthCheckProtocol enum
func HealthCheckProtocol_Values() []string {
	return []string{
		HealthCheckProtocolTcp,
		HealthCheckProtocolHttp,
		HealthCheckProtocolHttps,
	}
}

const (
	// HealthStateInitial is a HealthState enum value
	HealthStateInitial = "INITIAL"

	// HealthStateHealthy is a HealthState enum value
	HealthStateHealthy = "HEALTHY"

	// HealthStateUnhealthy is a HealthState enum value
	HealthStateUnhealthy = "UNHEALTHY"
)

// HealthState_Values returns all elements of the HealthState enum
func HealthState_Values() []string {
	return []string{
		HealthStateInitial,
		HealthStateHealthy,
		HealthStateUnhealthy,
	}
}

const (
	// IpAddressFamilyIpv4 is a IpAddressFamily enum value
	IpAddressFamilyIpv4 = "IPv4"

	// IpAddressFamilyIpv6 is a IpAddressFamily enum value
	IpAddressFamilyIpv6 = "IPv6"
)

// IpAddressFamily_Values returns all elements of the IpAddressFamily enum
func IpAddressFamily_Values() []string {
	return []string{
		IpAddressFamilyIpv4,
		IpAddressFamilyIpv6,
	}
}

const (
	// IpAddressTypeIpv4 is a IpAddressType enum value
	IpAddressTypeIpv4 = "IPV4"

	// IpAddressTypeDualStack is a IpAddressType enum value
	IpAddressTypeDualStack = "DUAL_STACK"
)

// IpAddressType_Values returns all elements of the IpAddressType enum
func IpAddressType_Values() []string {
	return []string{
		IpAddressTypeIpv4,
		IpAddressTypeDualStack,
	}
}

const (
	// ProtocolTcp is a Protocol enum value
	ProtocolTcp = "TCP"

	// ProtocolUdp is a Protocol enum value
	ProtocolUdp = "UDP"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolTcp,
		ProtocolUdp,
	}
}
