/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.internal.AbstractNativeComponentSpec;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;

public abstract class AbstractTargetedNativeComponentSpec
extends AbstractNativeComponentSpec
implements TargetedNativeComponentInternal {
    private final List<PlatformRequirement> targetPlatforms = new ArrayList<PlatformRequirement>();
    private final Set<String> buildTypes = new HashSet<String>();
    private final Set<String> flavors = new HashSet<String>();

    public List<PlatformRequirement> getTargetPlatforms() {
        return Collections.unmodifiableList(this.targetPlatforms);
    }

    public void targetPlatform(String targetPlatform) {
        this.targetPlatforms.add(DefaultPlatformRequirement.create((String)targetPlatform));
    }

    @Override
    public void targetFlavors(String ... flavorSelectors) {
        Collections.addAll(this.flavors, flavorSelectors);
    }

    @Override
    public void targetBuildTypes(String ... buildTypeSelectors) {
        Collections.addAll(this.buildTypes, buildTypeSelectors);
    }

    @Override
    public Set<Flavor> chooseFlavors(Set<? extends Flavor> candidates) {
        return this.chooseElements(Flavor.class, candidates, this.flavors);
    }

    @Override
    public Set<BuildType> chooseBuildTypes(Set<? extends BuildType> candidates) {
        return this.chooseElements(BuildType.class, candidates, this.buildTypes);
    }

    protected <T extends Named> Set<T> chooseElements(Class<T> type, Set<? extends T> candidates, Set<String> names) {
        if (names.isEmpty()) {
            return new LinkedHashSet<T>(candidates);
        }
        HashSet<String> unusedNames = new HashSet<String>(names);
        LinkedHashSet<Named> chosen = new LinkedHashSet<Named>();
        for (Named candidate : candidates) {
            if (!unusedNames.remove(candidate.getName())) continue;
            chosen.add(candidate);
        }
        if (!unusedNames.isEmpty()) {
            throw new InvalidUserDataException(String.format("Invalid %s: '%s'", type.getSimpleName(), unusedNames.iterator().next()));
        }
        return chosen;
    }
}

