/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This interface is used to instantiate either a real GrMC4020Source if you've
 * got the hardware, or to instantiate a zero source if you don't.  This keeps
 * us from having to touch a bunch of code depending on availability of hardware.
 *
 * This can't be a template, because the implementation needs to include config.h
 * in order to get the result of configure's test for the existence of the hardware.
 */

#include <mc4020_bitmask.h>
#include <VrSource.h>

// produce a stream of shorts from the A/D
VrSource<short> *
make_GrMC4020SourceS (double sampling_freq = 20e6,
		      unsigned long bitmask = MCC_CH0_EN | MCC_ALL_5V);
