var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js
var require_BigInteger = __commonJS({
  "../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js"(exports, module) {
    var bigInt = function(undefined2) {
      "use strict";
      var BASE = 1e7, LOG_BASE = 7, MAX_INT = 9007199254740992, MAX_INT_ARR = smallToArray(MAX_INT), DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
      var supportsNativeBigInt = typeof BigInt === "function";
      function Integer2(v3, radix, alphabet, caseSensitive) {
        if (typeof v3 === "undefined")
          return Integer2[0];
        if (typeof radix !== "undefined")
          return +radix === 10 && !alphabet ? parseValue(v3) : parseBase(v3, radix, alphabet, caseSensitive);
        return parseValue(v3);
      }
      function BigInteger(value, sign2) {
        this.value = value;
        this.sign = sign2;
        this.isSmall = false;
      }
      BigInteger.prototype = Object.create(Integer2.prototype);
      function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
      }
      SmallInteger.prototype = Object.create(Integer2.prototype);
      function NativeBigInt(value) {
        this.value = value;
      }
      NativeBigInt.prototype = Object.create(Integer2.prototype);
      function isPrecise(n2) {
        return -MAX_INT < n2 && n2 < MAX_INT;
      }
      function smallToArray(n2) {
        if (n2 < 1e7)
          return [n2];
        if (n2 < 1e14)
          return [n2 % 1e7, Math.floor(n2 / 1e7)];
        return [n2 % 1e7, Math.floor(n2 / 1e7) % 1e7, Math.floor(n2 / 1e14)];
      }
      function arrayToSmall(arr) {
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
          switch (length) {
            case 0:
              return 0;
            case 1:
              return arr[0];
            case 2:
              return arr[0] + arr[1] * BASE;
            default:
              return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
          }
        }
        return arr;
      }
      function trim(v3) {
        var i5 = v3.length;
        while (v3[--i5] === 0)
          ;
        v3.length = i5 + 1;
      }
      function createArray(length) {
        var x5 = new Array(length);
        var i5 = -1;
        while (++i5 < length) {
          x5[i5] = 0;
        }
        return x5;
      }
      function truncate(n2) {
        if (n2 > 0)
          return Math.floor(n2);
        return Math.ceil(n2);
      }
      function add4(a4, b4) {
        var l_a = a4.length, l_b = b4.length, r3 = new Array(l_a), carry = 0, base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l_b; i5++) {
          sum = a4[i5] + b4[i5] + carry;
          carry = sum >= base2 ? 1 : 0;
          r3[i5] = sum - carry * base2;
        }
        while (i5 < l_a) {
          sum = a4[i5] + carry;
          carry = sum === base2 ? 1 : 0;
          r3[i5++] = sum - carry * base2;
        }
        if (carry > 0)
          r3.push(carry);
        return r3;
      }
      function addAny(a4, b4) {
        if (a4.length >= b4.length)
          return add4(a4, b4);
        return add4(b4, a4);
      }
      function addSmall(a4, carry) {
        var l3 = a4.length, r3 = new Array(l3), base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l3; i5++) {
          sum = a4[i5] - base2 + carry;
          carry = Math.floor(sum / base2);
          r3[i5] = sum - carry * base2;
          carry += 1;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      BigInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var a4 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return new BigInteger(addSmall(a4, Math.abs(b4)), this.sign);
        }
        return new BigInteger(addAny(a4, b4), this.sign);
      };
      BigInteger.prototype.plus = BigInteger.prototype.add;
      SmallInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value;
        if (a4 < 0 !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          if (isPrecise(a4 + b4))
            return new SmallInteger(a4 + b4);
          b4 = smallToArray(Math.abs(b4));
        }
        return new BigInteger(addSmall(b4, Math.abs(a4)), a4 < 0);
      };
      SmallInteger.prototype.plus = SmallInteger.prototype.add;
      NativeBigInt.prototype.add = function(v3) {
        return new NativeBigInt(this.value + parseValue(v3).value);
      };
      NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
      function subtract(a4, b4) {
        var a_l = a4.length, b_l = b4.length, r3 = new Array(a_l), borrow = 0, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < b_l; i5++) {
          difference = a4[i5] - borrow - b4[i5];
          if (difference < 0) {
            difference += base2;
            borrow = 1;
          } else
            borrow = 0;
          r3[i5] = difference;
        }
        for (i5 = b_l; i5 < a_l; i5++) {
          difference = a4[i5] - borrow;
          if (difference < 0)
            difference += base2;
          else {
            r3[i5++] = difference;
            break;
          }
          r3[i5] = difference;
        }
        for (; i5 < a_l; i5++) {
          r3[i5] = a4[i5];
        }
        trim(r3);
        return r3;
      }
      function subtractAny(a4, b4, sign2) {
        var value;
        if (compareAbs(a4, b4) >= 0) {
          value = subtract(a4, b4);
        } else {
          value = subtract(b4, a4);
          sign2 = !sign2;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
          if (sign2)
            value = -value;
          return new SmallInteger(value);
        }
        return new BigInteger(value, sign2);
      }
      function subtractSmall(a4, b4, sign2) {
        var l3 = a4.length, r3 = new Array(l3), carry = -b4, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < l3; i5++) {
          difference = a4[i5] + carry;
          carry = Math.floor(difference / base2);
          difference %= base2;
          r3[i5] = difference < 0 ? difference + base2 : difference;
        }
        r3 = arrayToSmall(r3);
        if (typeof r3 === "number") {
          if (sign2)
            r3 = -r3;
          return new SmallInteger(r3);
        }
        return new BigInteger(r3, sign2);
      }
      BigInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.add(n2.negate());
        }
        var a4 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return subtractSmall(a4, Math.abs(b4), this.sign);
        return subtractAny(a4, b4, this.sign);
      };
      BigInteger.prototype.minus = BigInteger.prototype.subtract;
      SmallInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value;
        if (a4 < 0 !== n2.sign) {
          return this.add(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          return new SmallInteger(a4 - b4);
        }
        return subtractSmall(b4, Math.abs(a4), a4 >= 0);
      };
      SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
      NativeBigInt.prototype.subtract = function(v3) {
        return new NativeBigInt(this.value - parseValue(v3).value);
      };
      NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
      BigInteger.prototype.negate = function() {
        return new BigInteger(this.value, !this.sign);
      };
      SmallInteger.prototype.negate = function() {
        var sign2 = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign2;
        return small;
      };
      NativeBigInt.prototype.negate = function() {
        return new NativeBigInt(-this.value);
      };
      BigInteger.prototype.abs = function() {
        return new BigInteger(this.value, false);
      };
      SmallInteger.prototype.abs = function() {
        return new SmallInteger(Math.abs(this.value));
      };
      NativeBigInt.prototype.abs = function() {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
      };
      function multiplyLong(a4, b4) {
        var a_l = a4.length, b_l = b4.length, l3 = a_l + b_l, r3 = createArray(l3), base2 = BASE, product, carry, i5, a_i, b_j;
        for (i5 = 0; i5 < a_l; ++i5) {
          a_i = a4[i5];
          for (var j4 = 0; j4 < b_l; ++j4) {
            b_j = b4[j4];
            product = a_i * b_j + r3[i5 + j4];
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
            r3[i5 + j4 + 1] += carry;
          }
        }
        trim(r3);
        return r3;
      }
      function multiplySmall(a4, b4) {
        var l3 = a4.length, r3 = new Array(l3), base2 = BASE, carry = 0, product, i5;
        for (i5 = 0; i5 < l3; i5++) {
          product = a4[i5] * b4 + carry;
          carry = Math.floor(product / base2);
          r3[i5] = product - carry * base2;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      function shiftLeft(x5, n2) {
        var r3 = [];
        while (n2-- > 0)
          r3.push(0);
        return r3.concat(x5);
      }
      function multiplyKaratsuba(x5, y4) {
        var n2 = Math.max(x5.length, y4.length);
        if (n2 <= 30)
          return multiplyLong(x5, y4);
        n2 = Math.ceil(n2 / 2);
        var b4 = x5.slice(n2), a4 = x5.slice(0, n2), d4 = y4.slice(n2), c4 = y4.slice(0, n2);
        var ac = multiplyKaratsuba(a4, c4), bd = multiplyKaratsuba(b4, d4), abcd = multiplyKaratsuba(addAny(a4, b4), addAny(c4, d4));
        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n2)), shiftLeft(bd, 2 * n2));
        trim(product);
        return product;
      }
      function useKaratsuba(l1, l22) {
        return -0.012 * l1 - 0.012 * l22 + 15e-6 * l1 * l22 > 0;
      }
      BigInteger.prototype.multiply = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value, sign2 = this.sign !== n2.sign, abs;
        if (n2.isSmall) {
          if (b4 === 0)
            return Integer2[0];
          if (b4 === 1)
            return this;
          if (b4 === -1)
            return this.negate();
          abs = Math.abs(b4);
          if (abs < BASE) {
            return new BigInteger(multiplySmall(a4, abs), sign2);
          }
          b4 = smallToArray(abs);
        }
        if (useKaratsuba(a4.length, b4.length))
          return new BigInteger(multiplyKaratsuba(a4, b4), sign2);
        return new BigInteger(multiplyLong(a4, b4), sign2);
      };
      BigInteger.prototype.times = BigInteger.prototype.multiply;
      function multiplySmallAndArray(a4, b4, sign2) {
        if (a4 < BASE) {
          return new BigInteger(multiplySmall(b4, a4), sign2);
        }
        return new BigInteger(multiplyLong(b4, smallToArray(a4)), sign2);
      }
      SmallInteger.prototype._multiplyBySmall = function(a4) {
        if (isPrecise(a4.value * this.value)) {
          return new SmallInteger(a4.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a4.value), smallToArray(Math.abs(this.value)), this.sign !== a4.sign);
      };
      BigInteger.prototype._multiplyBySmall = function(a4) {
        if (a4.value === 0)
          return Integer2[0];
        if (a4.value === 1)
          return this;
        if (a4.value === -1)
          return this.negate();
        return multiplySmallAndArray(Math.abs(a4.value), this.value, this.sign !== a4.sign);
      };
      SmallInteger.prototype.multiply = function(v3) {
        return parseValue(v3)._multiplyBySmall(this);
      };
      SmallInteger.prototype.times = SmallInteger.prototype.multiply;
      NativeBigInt.prototype.multiply = function(v3) {
        return new NativeBigInt(this.value * parseValue(v3).value);
      };
      NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
      function square(a4) {
        var l3 = a4.length, r3 = createArray(l3 + l3), base2 = BASE, product, carry, i5, a_i, a_j;
        for (i5 = 0; i5 < l3; i5++) {
          a_i = a4[i5];
          carry = 0 - a_i * a_i;
          for (var j4 = i5; j4 < l3; j4++) {
            a_j = a4[j4];
            product = 2 * (a_i * a_j) + r3[i5 + j4] + carry;
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
          }
          r3[i5 + l3] = carry;
        }
        trim(r3);
        return r3;
      }
      BigInteger.prototype.square = function() {
        return new BigInteger(square(this.value), false);
      };
      SmallInteger.prototype.square = function() {
        var value = this.value * this.value;
        if (isPrecise(value))
          return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
      };
      NativeBigInt.prototype.square = function(v3) {
        return new NativeBigInt(this.value * this.value);
      };
      function divMod1(a4, b4) {
        var a_l = a4.length, b_l = b4.length, base2 = BASE, result = createArray(b4.length), divisorMostSignificantDigit = b4[b_l - 1], lambda = Math.ceil(base2 / (2 * divisorMostSignificantDigit)), remainder = multiplySmall(a4, lambda), divisor = multiplySmall(b4, lambda), quotientDigit, shift, carry, borrow, i5, l3, q5;
        if (remainder.length <= a_l)
          remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
          quotientDigit = base2 - 1;
          if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
            quotientDigit = Math.floor((remainder[shift + b_l] * base2 + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
          }
          carry = 0;
          borrow = 0;
          l3 = divisor.length;
          for (i5 = 0; i5 < l3; i5++) {
            carry += quotientDigit * divisor[i5];
            q5 = Math.floor(carry / base2);
            borrow += remainder[shift + i5] - (carry - q5 * base2);
            carry = q5;
            if (borrow < 0) {
              remainder[shift + i5] = borrow + base2;
              borrow = -1;
            } else {
              remainder[shift + i5] = borrow;
              borrow = 0;
            }
          }
          while (borrow !== 0) {
            quotientDigit -= 1;
            carry = 0;
            for (i5 = 0; i5 < l3; i5++) {
              carry += remainder[shift + i5] - base2 + divisor[i5];
              if (carry < 0) {
                remainder[shift + i5] = carry + base2;
                carry = 0;
              } else {
                remainder[shift + i5] = carry;
                carry = 1;
              }
            }
            borrow += carry;
          }
          result[shift] = quotientDigit;
        }
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
      }
      function divMod2(a4, b4) {
        var a_l = a4.length, b_l = b4.length, result = [], part = [], base2 = BASE, guess, xlen, highx, highy, check;
        while (a_l) {
          part.unshift(a4[--a_l]);
          trim(part);
          if (compareAbs(part, b4) < 0) {
            result.push(0);
            continue;
          }
          xlen = part.length;
          highx = part[xlen - 1] * base2 + part[xlen - 2];
          highy = b4[b_l - 1] * base2 + b4[b_l - 2];
          if (xlen > b_l) {
            highx = (highx + 1) * base2;
          }
          guess = Math.ceil(highx / highy);
          do {
            check = multiplySmall(b4, guess);
            if (compareAbs(check, part) <= 0)
              break;
            guess--;
          } while (guess);
          result.push(guess);
          part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
      }
      function divModSmall(value, lambda) {
        var length = value.length, quotient = createArray(length), base2 = BASE, i5, q5, remainder, divisor;
        remainder = 0;
        for (i5 = length - 1; i5 >= 0; --i5) {
          divisor = remainder * base2 + value[i5];
          q5 = truncate(divisor / lambda);
          remainder = divisor - q5 * lambda;
          quotient[i5] = q5 | 0;
        }
        return [quotient, remainder | 0];
      }
      function divModAny(self2, v3) {
        var value, n2 = parseValue(v3);
        if (supportsNativeBigInt) {
          return [new NativeBigInt(self2.value / n2.value), new NativeBigInt(self2.value % n2.value)];
        }
        var a4 = self2.value, b4 = n2.value;
        var quotient;
        if (b4 === 0)
          throw new Error("Cannot divide by zero");
        if (self2.isSmall) {
          if (n2.isSmall) {
            return [new SmallInteger(truncate(a4 / b4)), new SmallInteger(a4 % b4)];
          }
          return [Integer2[0], self2];
        }
        if (n2.isSmall) {
          if (b4 === 1)
            return [self2, Integer2[0]];
          if (b4 == -1)
            return [self2.negate(), Integer2[0]];
          var abs = Math.abs(b4);
          if (abs < BASE) {
            value = divModSmall(a4, abs);
            quotient = arrayToSmall(value[0]);
            var remainder = value[1];
            if (self2.sign)
              remainder = -remainder;
            if (typeof quotient === "number") {
              if (self2.sign !== n2.sign)
                quotient = -quotient;
              return [new SmallInteger(quotient), new SmallInteger(remainder)];
            }
            return [new BigInteger(quotient, self2.sign !== n2.sign), new SmallInteger(remainder)];
          }
          b4 = smallToArray(abs);
        }
        var comparison = compareAbs(a4, b4);
        if (comparison === -1)
          return [Integer2[0], self2];
        if (comparison === 0)
          return [Integer2[self2.sign === n2.sign ? 1 : -1], Integer2[0]];
        if (a4.length + b4.length <= 200)
          value = divMod1(a4, b4);
        else
          value = divMod2(a4, b4);
        quotient = value[0];
        var qSign = self2.sign !== n2.sign, mod = value[1], mSign = self2.sign;
        if (typeof quotient === "number") {
          if (qSign)
            quotient = -quotient;
          quotient = new SmallInteger(quotient);
        } else
          quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
          if (mSign)
            mod = -mod;
          mod = new SmallInteger(mod);
        } else
          mod = new BigInteger(mod, mSign);
        return [quotient, mod];
      }
      BigInteger.prototype.divmod = function(v3) {
        var result = divModAny(this, v3);
        return {
          quotient: result[0],
          remainder: result[1]
        };
      };
      NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;
      BigInteger.prototype.divide = function(v3) {
        return divModAny(this, v3)[0];
      };
      NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function(v3) {
        return new NativeBigInt(this.value / parseValue(v3).value);
      };
      SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;
      BigInteger.prototype.mod = function(v3) {
        return divModAny(this, v3)[1];
      };
      NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function(v3) {
        return new NativeBigInt(this.value % parseValue(v3).value);
      };
      SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;
      BigInteger.prototype.pow = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value, value, x5, y4;
        if (b4 === 0)
          return Integer2[1];
        if (a4 === 0)
          return Integer2[0];
        if (a4 === 1)
          return Integer2[1];
        if (a4 === -1)
          return n2.isEven() ? Integer2[1] : Integer2[-1];
        if (n2.sign) {
          return Integer2[0];
        }
        if (!n2.isSmall)
          throw new Error("The exponent " + n2.toString() + " is too large.");
        if (this.isSmall) {
          if (isPrecise(value = Math.pow(a4, b4)))
            return new SmallInteger(truncate(value));
        }
        x5 = this;
        y4 = Integer2[1];
        while (true) {
          if (b4 & true) {
            y4 = y4.times(x5);
            --b4;
          }
          if (b4 === 0)
            break;
          b4 /= 2;
          x5 = x5.square();
        }
        return y4;
      };
      SmallInteger.prototype.pow = BigInteger.prototype.pow;
      NativeBigInt.prototype.pow = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value, b4 = n2.value;
        var _0 = BigInt(0), _1 = BigInt(1), _22 = BigInt(2);
        if (b4 === _0)
          return Integer2[1];
        if (a4 === _0)
          return Integer2[0];
        if (a4 === _1)
          return Integer2[1];
        if (a4 === BigInt(-1))
          return n2.isEven() ? Integer2[1] : Integer2[-1];
        if (n2.isNegative())
          return new NativeBigInt(_0);
        var x5 = this;
        var y4 = Integer2[1];
        while (true) {
          if ((b4 & _1) === _1) {
            y4 = y4.times(x5);
            --b4;
          }
          if (b4 === _0)
            break;
          b4 /= _22;
          x5 = x5.square();
        }
        return y4;
      };
      BigInteger.prototype.modPow = function(exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero())
          throw new Error("Cannot take modPow with modulus 0");
        var r3 = Integer2[1], base2 = this.mod(mod);
        if (exp.isNegative()) {
          exp = exp.multiply(Integer2[-1]);
          base2 = base2.modInv(mod);
        }
        while (exp.isPositive()) {
          if (base2.isZero())
            return Integer2[0];
          if (exp.isOdd())
            r3 = r3.multiply(base2).mod(mod);
          exp = exp.divide(2);
          base2 = base2.square().mod(mod);
        }
        return r3;
      };
      NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;
      function compareAbs(a4, b4) {
        if (a4.length !== b4.length) {
          return a4.length > b4.length ? 1 : -1;
        }
        for (var i5 = a4.length - 1; i5 >= 0; i5--) {
          if (a4[i5] !== b4[i5])
            return a4[i5] > b4[i5] ? 1 : -1;
        }
        return 0;
      }
      BigInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return 1;
        return compareAbs(a4, b4);
      };
      SmallInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a4 = Math.abs(this.value), b4 = n2.value;
        if (n2.isSmall) {
          b4 = Math.abs(b4);
          return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
        }
        return -1;
      };
      NativeBigInt.prototype.compareAbs = function(v3) {
        var a4 = this.value;
        var b4 = parseValue(v3).value;
        a4 = a4 >= 0 ? a4 : -a4;
        b4 = b4 >= 0 ? b4 : -b4;
        return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
      };
      BigInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (this.sign !== n2.sign) {
          return n2.sign ? 1 : -1;
        }
        if (n2.isSmall) {
          return this.sign ? -1 : 1;
        }
        return compareAbs(a4, b4) * (this.sign ? -1 : 1);
      };
      BigInteger.prototype.compareTo = BigInteger.prototype.compare;
      SmallInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return a4 == b4 ? 0 : a4 > b4 ? 1 : -1;
        }
        if (a4 < 0 !== n2.sign) {
          return a4 < 0 ? -1 : 1;
        }
        return a4 < 0 ? 1 : -1;
      };
      SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
      NativeBigInt.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var a4 = this.value;
        var b4 = parseValue(v3).value;
        return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
      };
      NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
      BigInteger.prototype.equals = function(v3) {
        return this.compare(v3) === 0;
      };
      NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;
      BigInteger.prototype.notEquals = function(v3) {
        return this.compare(v3) !== 0;
      };
      NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;
      BigInteger.prototype.greater = function(v3) {
        return this.compare(v3) > 0;
      };
      NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;
      BigInteger.prototype.lesser = function(v3) {
        return this.compare(v3) < 0;
      };
      NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;
      BigInteger.prototype.greaterOrEquals = function(v3) {
        return this.compare(v3) >= 0;
      };
      NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;
      BigInteger.prototype.lesserOrEquals = function(v3) {
        return this.compare(v3) <= 0;
      };
      NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;
      BigInteger.prototype.isEven = function() {
        return (this.value[0] & 1) === 0;
      };
      SmallInteger.prototype.isEven = function() {
        return (this.value & 1) === 0;
      };
      NativeBigInt.prototype.isEven = function() {
        return (this.value & BigInt(1)) === BigInt(0);
      };
      BigInteger.prototype.isOdd = function() {
        return (this.value[0] & 1) === 1;
      };
      SmallInteger.prototype.isOdd = function() {
        return (this.value & 1) === 1;
      };
      NativeBigInt.prototype.isOdd = function() {
        return (this.value & BigInt(1)) === BigInt(1);
      };
      BigInteger.prototype.isPositive = function() {
        return !this.sign;
      };
      SmallInteger.prototype.isPositive = function() {
        return this.value > 0;
      };
      NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;
      BigInteger.prototype.isNegative = function() {
        return this.sign;
      };
      SmallInteger.prototype.isNegative = function() {
        return this.value < 0;
      };
      NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;
      BigInteger.prototype.isUnit = function() {
        return false;
      };
      SmallInteger.prototype.isUnit = function() {
        return Math.abs(this.value) === 1;
      };
      NativeBigInt.prototype.isUnit = function() {
        return this.abs().value === BigInt(1);
      };
      BigInteger.prototype.isZero = function() {
        return false;
      };
      SmallInteger.prototype.isZero = function() {
        return this.value === 0;
      };
      NativeBigInt.prototype.isZero = function() {
        return this.value === BigInt(0);
      };
      BigInteger.prototype.isDivisibleBy = function(v3) {
        var n2 = parseValue(v3);
        if (n2.isZero())
          return false;
        if (n2.isUnit())
          return true;
        if (n2.compareAbs(2) === 0)
          return this.isEven();
        return this.mod(n2).isZero();
      };
      NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;
      function isBasicPrime(v3) {
        var n2 = v3.abs();
        if (n2.isUnit())
          return false;
        if (n2.equals(2) || n2.equals(3) || n2.equals(5))
          return true;
        if (n2.isEven() || n2.isDivisibleBy(3) || n2.isDivisibleBy(5))
          return false;
        if (n2.lesser(49))
          return true;
      }
      function millerRabinTest(n2, a4) {
        var nPrev = n2.prev(), b4 = nPrev, r3 = 0, d4, t4, i5, x5;
        while (b4.isEven())
          b4 = b4.divide(2), r3++;
        next:
          for (i5 = 0; i5 < a4.length; i5++) {
            if (n2.lesser(a4[i5]))
              continue;
            x5 = bigInt(a4[i5]).modPow(b4, n2);
            if (x5.isUnit() || x5.equals(nPrev))
              continue;
            for (d4 = r3 - 1; d4 != 0; d4--) {
              x5 = x5.square().mod(n2);
              if (x5.isUnit())
                return false;
              if (x5.equals(nPrev))
                continue next;
            }
            return false;
          }
        return true;
      }
      BigInteger.prototype.isPrime = function(strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var bits = n2.bitLength();
        if (bits <= 64)
          return millerRabinTest(n2, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t4 = Math.ceil(strict === true ? 2 * Math.pow(logN, 2) : logN);
        for (var a4 = [], i5 = 0; i5 < t4; i5++) {
          a4.push(bigInt(i5 + 2));
        }
        return millerRabinTest(n2, a4);
      };
      NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;
      BigInteger.prototype.isProbablePrime = function(iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var t4 = iterations === undefined2 ? 5 : iterations;
        for (var a4 = [], i5 = 0; i5 < t4; i5++) {
          a4.push(bigInt.randBetween(2, n2.minus(2), rng));
        }
        return millerRabinTest(n2, a4);
      };
      NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;
      BigInteger.prototype.modInv = function(n2) {
        var t4 = bigInt.zero, newT = bigInt.one, r3 = parseValue(n2), newR = this.abs(), q5, lastT, lastR;
        while (!newR.isZero()) {
          q5 = r3.divide(newR);
          lastT = t4;
          lastR = r3;
          t4 = newT;
          r3 = newR;
          newT = lastT.subtract(q5.multiply(newT));
          newR = lastR.subtract(q5.multiply(newR));
        }
        if (!r3.isUnit())
          throw new Error(this.toString() + " and " + n2.toString() + " are not co-prime");
        if (t4.compare(0) === -1) {
          t4 = t4.add(n2);
        }
        if (this.isNegative()) {
          return t4.negate();
        }
        return t4;
      };
      NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;
      BigInteger.prototype.next = function() {
        var value = this.value;
        if (this.sign) {
          return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
      };
      SmallInteger.prototype.next = function() {
        var value = this.value;
        if (value + 1 < MAX_INT)
          return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
      };
      NativeBigInt.prototype.next = function() {
        return new NativeBigInt(this.value + BigInt(1));
      };
      BigInteger.prototype.prev = function() {
        var value = this.value;
        if (this.sign) {
          return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
      };
      SmallInteger.prototype.prev = function() {
        var value = this.value;
        if (value - 1 > -MAX_INT)
          return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
      };
      NativeBigInt.prototype.prev = function() {
        return new NativeBigInt(this.value - BigInt(1));
      };
      var powersOfTwo = [1];
      while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
        powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
      var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];
      function shift_isSmall(n2) {
        return Math.abs(n2) <= BASE;
      }
      BigInteger.prototype.shiftLeft = function(v3) {
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftRight(-n2);
        var result = this;
        if (result.isZero())
          return result;
        while (n2 >= powers2Length) {
          result = result.multiply(highestPower2);
          n2 -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n2]);
      };
      NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;
      BigInteger.prototype.shiftRight = function(v3) {
        var remQuo;
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftLeft(-n2);
        var result = this;
        while (n2 >= powers2Length) {
          if (result.isZero() || result.isNegative() && result.isUnit())
            return result;
          remQuo = divModAny(result, highestPower2);
          result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
          n2 -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n2]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
      };
      NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;
      function bitwise(x5, y4, fn2) {
        y4 = parseValue(y4);
        var xSign = x5.isNegative(), ySign = y4.isNegative();
        var xRem = xSign ? x5.not() : x5, yRem = ySign ? y4.not() : y4;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
          xDivMod = divModAny(xRem, highestPower2);
          xDigit = xDivMod[1].toJSNumber();
          if (xSign) {
            xDigit = highestPower2 - 1 - xDigit;
          }
          yDivMod = divModAny(yRem, highestPower2);
          yDigit = yDivMod[1].toJSNumber();
          if (ySign) {
            yDigit = highestPower2 - 1 - yDigit;
          }
          xRem = xDivMod[0];
          yRem = yDivMod[0];
          result.push(fn2(xDigit, yDigit));
        }
        var sum = fn2(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i5 = result.length - 1; i5 >= 0; i5 -= 1) {
          sum = sum.multiply(highestPower2).add(bigInt(result[i5]));
        }
        return sum;
      }
      BigInteger.prototype.not = function() {
        return this.negate().prev();
      };
      NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;
      BigInteger.prototype.and = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 & b4;
        });
      };
      NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;
      BigInteger.prototype.or = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 | b4;
        });
      };
      NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;
      BigInteger.prototype.xor = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 ^ b4;
        });
      };
      NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;
      var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
      function roughLOB(n2) {
        var v3 = n2.value, x5 = typeof v3 === "number" ? v3 | LOBMASK_I : typeof v3 === "bigint" ? v3 | BigInt(LOBMASK_I) : v3[0] + v3[1] * BASE | LOBMASK_BI;
        return x5 & -x5;
      }
      function integerLogarithm(value, base2) {
        if (base2.compareTo(value) <= 0) {
          var tmp = integerLogarithm(value, base2.square(base2));
          var p4 = tmp.p;
          var e4 = tmp.e;
          var t4 = p4.multiply(base2);
          return t4.compareTo(value) <= 0 ? { p: t4, e: e4 * 2 + 1 } : { p: p4, e: e4 * 2 };
        }
        return { p: bigInt(1), e: 0 };
      }
      BigInteger.prototype.bitLength = function() {
        var n2 = this;
        if (n2.compareTo(bigInt(0)) < 0) {
          n2 = n2.negate().subtract(bigInt(1));
        }
        if (n2.compareTo(bigInt(0)) === 0) {
          return bigInt(0);
        }
        return bigInt(integerLogarithm(n2, bigInt(2)).e).add(bigInt(1));
      };
      NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;
      function max(a4, b4) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        return a4.greater(b4) ? a4 : b4;
      }
      function min(a4, b4) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        return a4.lesser(b4) ? a4 : b4;
      }
      function gcd(a4, b4) {
        a4 = parseValue(a4).abs();
        b4 = parseValue(b4).abs();
        if (a4.equals(b4))
          return a4;
        if (a4.isZero())
          return b4;
        if (b4.isZero())
          return a4;
        var c4 = Integer2[1], d4, t4;
        while (a4.isEven() && b4.isEven()) {
          d4 = min(roughLOB(a4), roughLOB(b4));
          a4 = a4.divide(d4);
          b4 = b4.divide(d4);
          c4 = c4.multiply(d4);
        }
        while (a4.isEven()) {
          a4 = a4.divide(roughLOB(a4));
        }
        do {
          while (b4.isEven()) {
            b4 = b4.divide(roughLOB(b4));
          }
          if (a4.greater(b4)) {
            t4 = b4;
            b4 = a4;
            a4 = t4;
          }
          b4 = b4.subtract(a4);
        } while (!b4.isZero());
        return c4.isUnit() ? a4 : a4.multiply(c4);
      }
      function lcm(a4, b4) {
        a4 = parseValue(a4).abs();
        b4 = parseValue(b4).abs();
        return a4.divide(gcd(a4, b4)).multiply(b4);
      }
      function randBetween(a4, b4, rng) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        var usedRNG = rng || Math.random;
        var low = min(a4, b4), high = max(a4, b4);
        var range = high.subtract(low).add(1);
        if (range.isSmall)
          return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i5 = 0; i5 < digits.length; i5++) {
          var top = restricted ? digits[i5] + (i5 + 1 < digits.length ? digits[i5 + 1] / BASE : 0) : BASE;
          var digit = truncate(usedRNG() * top);
          result.push(digit);
          if (digit < digits[i5])
            restricted = false;
        }
        return low.add(Integer2.fromArray(result, BASE, false));
      }
      var parseBase = function(text, base2, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
          text = text.toLowerCase();
          alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i5;
        var absBase = Math.abs(base2);
        var alphabetValues = {};
        for (i5 = 0; i5 < alphabet.length; i5++) {
          alphabetValues[alphabet[i5]] = i5;
        }
        for (i5 = 0; i5 < length; i5++) {
          var c4 = text[i5];
          if (c4 === "-")
            continue;
          if (c4 in alphabetValues) {
            if (alphabetValues[c4] >= absBase) {
              if (c4 === "1" && absBase === 1)
                continue;
              throw new Error(c4 + " is not a valid digit in base " + base2 + ".");
            }
          }
        }
        base2 = parseValue(base2);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i5 = isNegative ? 1 : 0; i5 < text.length; i5++) {
          var c4 = text[i5];
          if (c4 in alphabetValues)
            digits.push(parseValue(alphabetValues[c4]));
          else if (c4 === "<") {
            var start = i5;
            do {
              i5++;
            } while (text[i5] !== ">" && i5 < text.length);
            digits.push(parseValue(text.slice(start + 1, i5)));
          } else
            throw new Error(c4 + " is not a valid character");
        }
        return parseBaseFromArray(digits, base2, isNegative);
      };
      function parseBaseFromArray(digits, base2, isNegative) {
        var val = Integer2[0], pow = Integer2[1], i5;
        for (i5 = digits.length - 1; i5 >= 0; i5--) {
          val = val.add(digits[i5].times(pow));
          pow = pow.times(base2);
        }
        return isNegative ? val.negate() : val;
      }
      function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
          return alphabet[digit];
        }
        return "<" + digit + ">";
      }
      function toBase(n2, base2) {
        base2 = bigInt(base2);
        if (base2.isZero()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base2.equals(-1)) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          if (n2.isNegative())
            return {
              value: [].concat.apply(
                [],
                Array.apply(null, Array(-n2.toJSNumber())).map(Array.prototype.valueOf, [1, 0])
              ),
              isNegative: false
            };
          var arr = Array.apply(null, Array(n2.toJSNumber() - 1)).map(Array.prototype.valueOf, [0, 1]);
          arr.unshift([1]);
          return {
            value: [].concat.apply([], arr),
            isNegative: false
          };
        }
        var neg = false;
        if (n2.isNegative() && base2.isPositive()) {
          neg = true;
          n2 = n2.abs();
        }
        if (base2.isUnit()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          return {
            value: Array.apply(null, Array(n2.toJSNumber())).map(Number.prototype.valueOf, 1),
            isNegative: neg
          };
        }
        var out = [];
        var left = n2, divmod;
        while (left.isNegative() || left.compareAbs(base2) >= 0) {
          divmod = left.divmod(base2);
          left = divmod.quotient;
          var digit = divmod.remainder;
          if (digit.isNegative()) {
            digit = base2.minus(digit).abs();
            left = left.next();
          }
          out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
      }
      function toBaseString(n2, base2, alphabet) {
        var arr = toBase(n2, base2);
        return (arr.isNegative ? "-" : "") + arr.value.map(function(x5) {
          return stringify(x5, alphabet);
        }).join("");
      }
      BigInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      SmallInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      NativeBigInt.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      BigInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix !== 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        var v3 = this.value, l3 = v3.length, str = String(v3[--l3]), zeros = "0000000", digit;
        while (--l3 >= 0) {
          digit = String(v3[l3]);
          str += zeros.slice(digit.length) + digit;
        }
        var sign2 = this.sign ? "-" : "";
        return sign2 + str;
      };
      SmallInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix != 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        return String(this.value);
      };
      NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
      NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function() {
        return this.toString();
      };
      BigInteger.prototype.valueOf = function() {
        return parseInt(this.toString(), 10);
      };
      BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
      SmallInteger.prototype.valueOf = function() {
        return this.value;
      };
      SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
      NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function() {
        return parseInt(this.toString(), 10);
      };
      function parseStringValue(v3) {
        if (isPrecise(+v3)) {
          var x5 = +v3;
          if (x5 === truncate(x5))
            return supportsNativeBigInt ? new NativeBigInt(BigInt(x5)) : new SmallInteger(x5);
          throw new Error("Invalid integer: " + v3);
        }
        var sign2 = v3[0] === "-";
        if (sign2)
          v3 = v3.slice(1);
        var split = v3.split(/e/i);
        if (split.length > 2)
          throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
          var exp = split[1];
          if (exp[0] === "+")
            exp = exp.slice(1);
          exp = +exp;
          if (exp !== truncate(exp) || !isPrecise(exp))
            throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
          var text = split[0];
          var decimalPlace = text.indexOf(".");
          if (decimalPlace >= 0) {
            exp -= text.length - decimalPlace - 1;
            text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
          }
          if (exp < 0)
            throw new Error("Cannot include negative exponent part for integers");
          text += new Array(exp + 1).join("0");
          v3 = text;
        }
        var isValid3 = /^([0-9][0-9]*)$/.test(v3);
        if (!isValid3)
          throw new Error("Invalid integer: " + v3);
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(sign2 ? "-" + v3 : v3));
        }
        var r3 = [], max2 = v3.length, l3 = LOG_BASE, min2 = max2 - l3;
        while (max2 > 0) {
          r3.push(+v3.slice(min2, max2));
          min2 -= l3;
          if (min2 < 0)
            min2 = 0;
          max2 -= l3;
        }
        trim(r3);
        return new BigInteger(r3, sign2);
      }
      function parseNumberValue(v3) {
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(v3));
        }
        if (isPrecise(v3)) {
          if (v3 !== truncate(v3))
            throw new Error(v3 + " is not an integer.");
          return new SmallInteger(v3);
        }
        return parseStringValue(v3.toString());
      }
      function parseValue(v3) {
        if (typeof v3 === "number") {
          return parseNumberValue(v3);
        }
        if (typeof v3 === "string") {
          return parseStringValue(v3);
        }
        if (typeof v3 === "bigint") {
          return new NativeBigInt(v3);
        }
        return v3;
      }
      for (var i4 = 0; i4 < 1e3; i4++) {
        Integer2[i4] = parseValue(i4);
        if (i4 > 0)
          Integer2[-i4] = parseValue(-i4);
      }
      Integer2.one = Integer2[1];
      Integer2.zero = Integer2[0];
      Integer2.minusOne = Integer2[-1];
      Integer2.max = max;
      Integer2.min = min;
      Integer2.gcd = gcd;
      Integer2.lcm = lcm;
      Integer2.isInstance = function(x5) {
        return x5 instanceof BigInteger || x5 instanceof SmallInteger || x5 instanceof NativeBigInt;
      };
      Integer2.randBetween = randBetween;
      Integer2.fromArray = function(digits, base2, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base2 || 10), isNegative);
      };
      return Integer2;
    }();
    if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
      module.exports = bigInt;
    }
    if (typeof define === "function" && define.amd) {
      define(function() {
        return bigInt;
      });
    }
  }
});

// ../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js
var require_jed = __commonJS({
  "../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js"(exports, module) {
    (function(root, undef) {
      var ArrayProto = Array.prototype, ObjProto = Object.prototype, slice = ArrayProto.slice, hasOwnProp = ObjProto.hasOwnProperty, nativeForEach = ArrayProto.forEach, breaker = {};
      var _3 = {
        forEach: function(obj, iterator, context) {
          var i4, l3, key;
          if (obj === null) {
            return;
          }
          if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
          } else if (obj.length === +obj.length) {
            for (i4 = 0, l3 = obj.length; i4 < l3; i4++) {
              if (i4 in obj && iterator.call(context, obj[i4], i4, obj) === breaker) {
                return;
              }
            }
          } else {
            for (key in obj) {
              if (hasOwnProp.call(obj, key)) {
                if (iterator.call(context, obj[key], key, obj) === breaker) {
                  return;
                }
              }
            }
          }
        },
        extend: function(obj) {
          this.forEach(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
              obj[prop] = source[prop];
            }
          });
          return obj;
        }
      };
      var Jed2 = function(options) {
        this.defaults = {
          "locale_data": {
            "messages": {
              "": {
                "domain": "messages",
                "lang": "en",
                "plural_forms": "nplurals=2; plural=(n != 1);"
              }
              // There are no default keys, though
            }
          },
          // The default domain if one is missing
          "domain": "messages",
          // enable debug mode to log untranslated strings to the console
          "debug": false
        };
        this.options = _3.extend({}, this.defaults, options);
        this.textdomain(this.options.domain);
        if (options.domain && !this.options.locale_data[this.options.domain]) {
          throw new Error("Text domain set to non-existent domain: `" + options.domain + "`");
        }
      };
      Jed2.context_delimiter = String.fromCharCode(4);
      function getPluralFormFunc(plural_form_string) {
        return Jed2.PF.compile(plural_form_string || "nplurals=2; plural=(n != 1);");
      }
      function Chain(key, i18n2) {
        this._key = key;
        this._i18n = i18n2;
      }
      _3.extend(Chain.prototype, {
        onDomain: function(domain) {
          this._domain = domain;
          return this;
        },
        withContext: function(context) {
          this._context = context;
          return this;
        },
        ifPlural: function(num, pkey) {
          this._val = num;
          this._pkey = pkey;
          return this;
        },
        fetch: function(sArr) {
          if ({}.toString.call(sArr) != "[object Array]") {
            sArr = [].slice.call(arguments, 0);
          }
          return (sArr && sArr.length ? Jed2.sprintf : function(x5) {
            return x5;
          })(
            this._i18n.dcnpgettext(this._domain, this._context, this._key, this._pkey, this._val),
            sArr
          );
        }
      });
      _3.extend(Jed2.prototype, {
        // The sexier api start point
        translate: function(key) {
          return new Chain(key, this);
        },
        textdomain: function(domain) {
          if (!domain) {
            return this._textdomain;
          }
          this._textdomain = domain;
        },
        gettext: function(key) {
          return this.dcnpgettext.call(this, undef, undef, key);
        },
        dgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        dcgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        ngettext: function(skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, undef, skey, pkey, val);
        },
        dngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        dcngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        pgettext: function(context, key) {
          return this.dcnpgettext.call(this, undef, context, key);
        },
        dpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        dcpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        npgettext: function(context, skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, context, skey, pkey, val);
        },
        dnpgettext: function(domain, context, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, context, skey, pkey, val);
        },
        // The most fully qualified gettext function. It has every option.
        // Since it has every option, we can use it from every other method.
        // This is the bread and butter.
        // Technically there should be one more argument in this function for 'Category',
        // but since we never use it, we might as well not waste the bytes to define it.
        dcnpgettext: function(domain, context, singular_key, plural_key, val) {
          plural_key = plural_key || singular_key;
          domain = domain || this._textdomain;
          var fallback;
          if (!this.options) {
            fallback = new Jed2();
            return fallback.dcnpgettext.call(fallback, void 0, void 0, singular_key, plural_key, val);
          }
          if (!this.options.locale_data) {
            throw new Error("No locale data provided.");
          }
          if (!this.options.locale_data[domain]) {
            throw new Error("Domain `" + domain + "` was not found.");
          }
          if (!this.options.locale_data[domain][""]) {
            throw new Error("No locale meta information provided.");
          }
          if (!singular_key) {
            throw new Error("No translation key found.");
          }
          var key = context ? context + Jed2.context_delimiter + singular_key : singular_key, locale_data = this.options.locale_data, dict = locale_data[domain], defaultConf = (locale_data.messages || this.defaults.locale_data.messages)[""], pluralForms = dict[""].plural_forms || dict[""]["Plural-Forms"] || dict[""]["plural-forms"] || defaultConf.plural_forms || defaultConf["Plural-Forms"] || defaultConf["plural-forms"], val_list, res;
          var val_idx;
          if (val === void 0) {
            val_idx = 0;
          } else {
            if (typeof val != "number") {
              val = parseInt(val, 10);
              if (isNaN(val)) {
                throw new Error("The number that was passed in is not a number.");
              }
            }
            val_idx = getPluralFormFunc(pluralForms)(val);
          }
          if (!dict) {
            throw new Error("No domain named `" + domain + "` could be found.");
          }
          val_list = dict[key];
          if (!val_list || val_idx > val_list.length) {
            if (this.options.missing_key_callback) {
              this.options.missing_key_callback(key, domain);
            }
            res = [singular_key, plural_key];
            if (this.options.debug === true) {
              console.log(res[getPluralFormFunc(pluralForms)(val)]);
            }
            return res[getPluralFormFunc()(val)];
          }
          res = val_list[val_idx];
          if (!res) {
            res = [singular_key, plural_key];
            return res[getPluralFormFunc()(val)];
          }
          return res;
        }
      });
      var sprintf = function() {
        function get_type(variable) {
          return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
          for (var output = []; multiplier > 0; output[--multiplier] = input) {
          }
          return output.join("");
        }
        var str_format = function() {
          if (!str_format.cache.hasOwnProperty(arguments[0])) {
            str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
          }
          return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
        str_format.format = function(parse_tree, argv) {
          var cursor = 1, tree_length = parse_tree.length, node_type = "", arg, output = [], i4, k5, match6, pad, pad_character, pad_length;
          for (i4 = 0; i4 < tree_length; i4++) {
            node_type = get_type(parse_tree[i4]);
            if (node_type === "string") {
              output.push(parse_tree[i4]);
            } else if (node_type === "array") {
              match6 = parse_tree[i4];
              if (match6[2]) {
                arg = argv[cursor];
                for (k5 = 0; k5 < match6[2].length; k5++) {
                  if (!arg.hasOwnProperty(match6[2][k5])) {
                    throw sprintf('[sprintf] property "%s" does not exist', match6[2][k5]);
                  }
                  arg = arg[match6[2][k5]];
                }
              } else if (match6[1]) {
                arg = argv[match6[1]];
              } else {
                arg = argv[cursor++];
              }
              if (/[^s]/.test(match6[8]) && get_type(arg) != "number") {
                throw sprintf("[sprintf] expecting number but found %s", get_type(arg));
              }
              if (typeof arg == "undefined" || arg === null) {
                arg = "";
              }
              switch (match6[8]) {
                case "b":
                  arg = arg.toString(2);
                  break;
                case "c":
                  arg = String.fromCharCode(arg);
                  break;
                case "d":
                  arg = parseInt(arg, 10);
                  break;
                case "e":
                  arg = match6[7] ? arg.toExponential(match6[7]) : arg.toExponential();
                  break;
                case "f":
                  arg = match6[7] ? parseFloat(arg).toFixed(match6[7]) : parseFloat(arg);
                  break;
                case "o":
                  arg = arg.toString(8);
                  break;
                case "s":
                  arg = (arg = String(arg)) && match6[7] ? arg.substring(0, match6[7]) : arg;
                  break;
                case "u":
                  arg = Math.abs(arg);
                  break;
                case "x":
                  arg = arg.toString(16);
                  break;
                case "X":
                  arg = arg.toString(16).toUpperCase();
                  break;
              }
              arg = /[def]/.test(match6[8]) && match6[3] && arg >= 0 ? "+" + arg : arg;
              pad_character = match6[4] ? match6[4] == "0" ? "0" : match6[4].charAt(1) : " ";
              pad_length = match6[6] - String(arg).length;
              pad = match6[6] ? str_repeat(pad_character, pad_length) : "";
              output.push(match6[5] ? arg + pad : pad + arg);
            }
          }
          return output.join("");
        };
        str_format.cache = {};
        str_format.parse = function(fmt) {
          var _fmt = fmt, match6 = [], parse_tree = [], arg_names = 0;
          while (_fmt) {
            if ((match6 = /^[^\x25]+/.exec(_fmt)) !== null) {
              parse_tree.push(match6[0]);
            } else if ((match6 = /^\x25{2}/.exec(_fmt)) !== null) {
              parse_tree.push("%");
            } else if ((match6 = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
              if (match6[2]) {
                arg_names |= 1;
                var field_list = [], replacement_field = match6[2], field_match = [];
                if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                  while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                    if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw "[sprintf] huh?";
                    }
                  }
                } else {
                  throw "[sprintf] huh?";
                }
                match6[2] = field_list;
              } else {
                arg_names |= 2;
              }
              if (arg_names === 3) {
                throw "[sprintf] mixing positional and named placeholders is not (yet) supported";
              }
              parse_tree.push(match6);
            } else {
              throw "[sprintf] huh?";
            }
            _fmt = _fmt.substring(match6[0].length);
          }
          return parse_tree;
        };
        return str_format;
      }();
      var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
      };
      Jed2.parse_plural = function(plural_forms, n2) {
        plural_forms = plural_forms.replace(/n/g, n2);
        return Jed2.parse_expression(plural_forms);
      };
      Jed2.sprintf = function(fmt, args) {
        if ({}.toString.call(args) == "[object Array]") {
          return vsprintf(fmt, [].slice.call(args));
        }
        return sprintf.apply(this, [].slice.call(arguments));
      };
      Jed2.prototype.sprintf = function() {
        return Jed2.sprintf.apply(this, arguments);
      };
      Jed2.PF = {};
      Jed2.PF.parse = function(p4) {
        var plural_str = Jed2.PF.extractPluralExpr(p4);
        return Jed2.PF.parser.parse.call(Jed2.PF.parser, plural_str);
      };
      Jed2.PF.compile = function(p4) {
        function imply(val) {
          return val === true ? 1 : val ? val : 0;
        }
        var ast = Jed2.PF.parse(p4);
        return function(n2) {
          return imply(Jed2.PF.interpreter(ast)(n2));
        };
      };
      Jed2.PF.interpreter = function(ast) {
        return function(n2) {
          var res;
          switch (ast.type) {
            case "GROUP":
              return Jed2.PF.interpreter(ast.expr)(n2);
            case "TERNARY":
              if (Jed2.PF.interpreter(ast.expr)(n2)) {
                return Jed2.PF.interpreter(ast.truthy)(n2);
              }
              return Jed2.PF.interpreter(ast.falsey)(n2);
            case "OR":
              return Jed2.PF.interpreter(ast.left)(n2) || Jed2.PF.interpreter(ast.right)(n2);
            case "AND":
              return Jed2.PF.interpreter(ast.left)(n2) && Jed2.PF.interpreter(ast.right)(n2);
            case "LT":
              return Jed2.PF.interpreter(ast.left)(n2) < Jed2.PF.interpreter(ast.right)(n2);
            case "GT":
              return Jed2.PF.interpreter(ast.left)(n2) > Jed2.PF.interpreter(ast.right)(n2);
            case "LTE":
              return Jed2.PF.interpreter(ast.left)(n2) <= Jed2.PF.interpreter(ast.right)(n2);
            case "GTE":
              return Jed2.PF.interpreter(ast.left)(n2) >= Jed2.PF.interpreter(ast.right)(n2);
            case "EQ":
              return Jed2.PF.interpreter(ast.left)(n2) == Jed2.PF.interpreter(ast.right)(n2);
            case "NEQ":
              return Jed2.PF.interpreter(ast.left)(n2) != Jed2.PF.interpreter(ast.right)(n2);
            case "MOD":
              return Jed2.PF.interpreter(ast.left)(n2) % Jed2.PF.interpreter(ast.right)(n2);
            case "VAR":
              return n2;
            case "NUM":
              return ast.val;
            default:
              throw new Error("Invalid Token found.");
          }
        };
      };
      Jed2.PF.extractPluralExpr = function(p4) {
        p4 = p4.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
        if (!/;\s*$/.test(p4)) {
          p4 = p4.concat(";");
        }
        var nplurals_re = /nplurals\=(\d+);/, plural_re = /plural\=(.*);/, nplurals_matches = p4.match(nplurals_re), res = {}, plural_matches;
        if (nplurals_matches.length > 1) {
          res.nplurals = nplurals_matches[1];
        } else {
          throw new Error("nplurals not found in plural_forms string: " + p4);
        }
        p4 = p4.replace(nplurals_re, "");
        plural_matches = p4.match(plural_re);
        if (!(plural_matches && plural_matches.length > 1)) {
          throw new Error("`plural` expression not found: " + p4);
        }
        return plural_matches[1];
      };
      Jed2.PF.parser = function() {
        var parser = {
          trace: function trace() {
          },
          yy: {},
          symbols_: { "error": 2, "expressions": 3, "e": 4, "EOF": 5, "?": 6, ":": 7, "||": 8, "&&": 9, "<": 10, "<=": 11, ">": 12, ">=": 13, "!=": 14, "==": 15, "%": 16, "(": 17, ")": 18, "n": 19, "NUMBER": 20, "$accept": 0, "$end": 1 },
          terminals_: { 2: "error", 5: "EOF", 6: "?", 7: ":", 8: "||", 9: "&&", 10: "<", 11: "<=", 12: ">", 13: ">=", 14: "!=", 15: "==", 16: "%", 17: "(", 18: ")", 19: "n", 20: "NUMBER" },
          productions_: [0, [3, 2], [4, 5], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [4, 1]],
          performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
            var $0 = $$.length - 1;
            switch (yystate) {
              case 1:
                return { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 2:
                this.$ = { type: "TERNARY", expr: $$[$0 - 4], truthy: $$[$0 - 2], falsey: $$[$0] };
                break;
              case 3:
                this.$ = { type: "OR", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 4:
                this.$ = { type: "AND", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 5:
                this.$ = { type: "LT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 6:
                this.$ = { type: "LTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 7:
                this.$ = { type: "GT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 8:
                this.$ = { type: "GTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 9:
                this.$ = { type: "NEQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 10:
                this.$ = { type: "EQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 11:
                this.$ = { type: "MOD", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 12:
                this.$ = { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 13:
                this.$ = { type: "VAR" };
                break;
              case 14:
                this.$ = { type: "NUM", val: Number(yytext) };
                break;
            }
          },
          table: [{ 3: 1, 4: 2, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 1: [3] }, { 5: [1, 6], 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 4: 17, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 13], 6: [2, 13], 7: [2, 13], 8: [2, 13], 9: [2, 13], 10: [2, 13], 11: [2, 13], 12: [2, 13], 13: [2, 13], 14: [2, 13], 15: [2, 13], 16: [2, 13], 18: [2, 13] }, { 5: [2, 14], 6: [2, 14], 7: [2, 14], 8: [2, 14], 9: [2, 14], 10: [2, 14], 11: [2, 14], 12: [2, 14], 13: [2, 14], 14: [2, 14], 15: [2, 14], 16: [2, 14], 18: [2, 14] }, { 1: [2, 1] }, { 4: 18, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 19, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 20, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 21, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 22, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 23, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 24, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 25, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 26, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 27, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [1, 28] }, { 6: [1, 7], 7: [1, 29], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 5: [2, 3], 6: [2, 3], 7: [2, 3], 8: [2, 3], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 3] }, { 5: [2, 4], 6: [2, 4], 7: [2, 4], 8: [2, 4], 9: [2, 4], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 4] }, { 5: [2, 5], 6: [2, 5], 7: [2, 5], 8: [2, 5], 9: [2, 5], 10: [2, 5], 11: [2, 5], 12: [2, 5], 13: [2, 5], 14: [2, 5], 15: [2, 5], 16: [1, 16], 18: [2, 5] }, { 5: [2, 6], 6: [2, 6], 7: [2, 6], 8: [2, 6], 9: [2, 6], 10: [2, 6], 11: [2, 6], 12: [2, 6], 13: [2, 6], 14: [2, 6], 15: [2, 6], 16: [1, 16], 18: [2, 6] }, { 5: [2, 7], 6: [2, 7], 7: [2, 7], 8: [2, 7], 9: [2, 7], 10: [2, 7], 11: [2, 7], 12: [2, 7], 13: [2, 7], 14: [2, 7], 15: [2, 7], 16: [1, 16], 18: [2, 7] }, { 5: [2, 8], 6: [2, 8], 7: [2, 8], 8: [2, 8], 9: [2, 8], 10: [2, 8], 11: [2, 8], 12: [2, 8], 13: [2, 8], 14: [2, 8], 15: [2, 8], 16: [1, 16], 18: [2, 8] }, { 5: [2, 9], 6: [2, 9], 7: [2, 9], 8: [2, 9], 9: [2, 9], 10: [2, 9], 11: [2, 9], 12: [2, 9], 13: [2, 9], 14: [2, 9], 15: [2, 9], 16: [1, 16], 18: [2, 9] }, { 5: [2, 10], 6: [2, 10], 7: [2, 10], 8: [2, 10], 9: [2, 10], 10: [2, 10], 11: [2, 10], 12: [2, 10], 13: [2, 10], 14: [2, 10], 15: [2, 10], 16: [1, 16], 18: [2, 10] }, { 5: [2, 11], 6: [2, 11], 7: [2, 11], 8: [2, 11], 9: [2, 11], 10: [2, 11], 11: [2, 11], 12: [2, 11], 13: [2, 11], 14: [2, 11], 15: [2, 11], 16: [2, 11], 18: [2, 11] }, { 5: [2, 12], 6: [2, 12], 7: [2, 12], 8: [2, 12], 9: [2, 12], 10: [2, 12], 11: [2, 12], 12: [2, 12], 13: [2, 12], 14: [2, 12], 15: [2, 12], 16: [2, 12], 18: [2, 12] }, { 4: 30, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 2], 6: [1, 7], 7: [2, 2], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 2] }],
          defaultActions: { 6: [2, 1] },
          parseError: function parseError(str, hash4) {
            throw new Error(str);
          },
          parse: function parse2(input) {
            var self2 = this, stack = [0], vstack = [null], lstack = [], table2 = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            if (typeof this.lexer.yylloc == "undefined")
              this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);
            if (typeof this.yy.parseError === "function")
              this.parseError = this.yy.parseError;
            function popStack(n2) {
              stack.length = stack.length - 2 * n2;
              vstack.length = vstack.length - n2;
              lstack.length = lstack.length - n2;
            }
            function lex() {
              var token;
              token = self2.lexer.lex() || 1;
              if (typeof token !== "number") {
                token = self2.symbols_[token] || token;
              }
              return token;
            }
            var symbol, preErrorSymbol, state, action, a4, r3, yyval = {}, p4, len, newState, expected;
            while (true) {
              state = stack[stack.length - 1];
              if (this.defaultActions[state]) {
                action = this.defaultActions[state];
              } else {
                if (symbol == null)
                  symbol = lex();
                action = table2[state] && table2[state][symbol];
              }
              _handle_error:
                if (typeof action === "undefined" || !action.length || !action[0]) {
                  if (!recovering) {
                    expected = [];
                    for (p4 in table2[state])
                      if (this.terminals_[p4] && p4 > 2) {
                        expected.push("'" + this.terminals_[p4] + "'");
                      }
                    var errStr = "";
                    if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + this.terminals_[symbol] + "'";
                    } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1 ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                    }
                    this.parseError(
                      errStr,
                      { text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected }
                    );
                  }
                  if (recovering == 3) {
                    if (symbol == EOF) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    symbol = lex();
                  }
                  while (1) {
                    if (TERROR.toString() in table2[state]) {
                      break;
                    }
                    if (state == 0) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    popStack(1);
                    state = stack[stack.length - 1];
                  }
                  preErrorSymbol = symbol;
                  symbol = TERROR;
                  state = stack[stack.length - 1];
                  action = table2[state] && table2[state][TERROR];
                  recovering = 3;
                }
              if (action[0] instanceof Array && action.length > 1) {
                throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
              }
              switch (action[0]) {
                case 1:
                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]);
                  symbol = null;
                  if (!preErrorSymbol) {
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                      recovering--;
                  } else {
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                  }
                  break;
                case 2:
                  len = this.productions_[action[1]][1];
                  yyval.$ = vstack[vstack.length - len];
                  yyval._$ = {
                    first_line: lstack[lstack.length - (len || 1)].first_line,
                    last_line: lstack[lstack.length - 1].last_line,
                    first_column: lstack[lstack.length - (len || 1)].first_column,
                    last_column: lstack[lstack.length - 1].last_column
                  };
                  r3 = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
                  if (typeof r3 !== "undefined") {
                    return r3;
                  }
                  if (len) {
                    stack = stack.slice(0, -1 * len * 2);
                    vstack = vstack.slice(0, -1 * len);
                    lstack = lstack.slice(0, -1 * len);
                  }
                  stack.push(this.productions_[action[1]][0]);
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  newState = table2[stack[stack.length - 2]][stack[stack.length - 1]];
                  stack.push(newState);
                  break;
                case 3:
                  return true;
              }
            }
            return true;
          }
        };
        var lexer = function() {
          var lexer2 = {
            EOF: 1,
            parseError: function parseError(str, hash4) {
              if (this.yy.parseError) {
                this.yy.parseError(str, hash4);
              } else {
                throw new Error(str);
              }
            },
            setInput: function(input) {
              this._input = input;
              this._more = this._less = this.done = false;
              this.yylineno = this.yyleng = 0;
              this.yytext = this.matched = this.match = "";
              this.conditionStack = ["INITIAL"];
              this.yylloc = { first_line: 1, first_column: 0, last_line: 1, last_column: 0 };
              return this;
            },
            input: function() {
              var ch = this._input[0];
              this.yytext += ch;
              this.yyleng++;
              this.match += ch;
              this.matched += ch;
              var lines = ch.match(/\n/);
              if (lines)
                this.yylineno++;
              this._input = this._input.slice(1);
              return ch;
            },
            unput: function(ch) {
              this._input = ch + this._input;
              return this;
            },
            more: function() {
              this._more = true;
              return this;
            },
            pastInput: function() {
              var past = this.matched.substr(0, this.matched.length - this.match.length);
              return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
              var next = this.match;
              if (next.length < 20) {
                next += this._input.substr(0, 20 - next.length);
              }
              return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
            },
            showPosition: function() {
              var pre = this.pastInput();
              var c4 = new Array(pre.length + 1).join("-");
              return pre + this.upcomingInput() + "\n" + c4 + "^";
            },
            next: function() {
              if (this.done) {
                return this.EOF;
              }
              if (!this._input)
                this.done = true;
              var token, match6, col, lines;
              if (!this._more) {
                this.yytext = "";
                this.match = "";
              }
              var rules = this._currentRules();
              for (var i4 = 0; i4 < rules.length; i4++) {
                match6 = this._input.match(this.rules[rules[i4]]);
                if (match6) {
                  lines = match6[0].match(/\n.*/g);
                  if (lines)
                    this.yylineno += lines.length;
                  this.yylloc = {
                    first_line: this.yylloc.last_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.last_column,
                    last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match6[0].length
                  };
                  this.yytext += match6[0];
                  this.match += match6[0];
                  this.matches = match6;
                  this.yyleng = this.yytext.length;
                  this._more = false;
                  this._input = this._input.slice(match6[0].length);
                  this.matched += match6[0];
                  token = this.performAction.call(this, this.yy, this, rules[i4], this.conditionStack[this.conditionStack.length - 1]);
                  if (token)
                    return token;
                  else
                    return;
                }
              }
              if (this._input === "") {
                return this.EOF;
              } else {
                this.parseError(
                  "Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(),
                  { text: "", token: null, line: this.yylineno }
                );
              }
            },
            lex: function lex() {
              var r3 = this.next();
              if (typeof r3 !== "undefined") {
                return r3;
              } else {
                return this.lex();
              }
            },
            begin: function begin(condition) {
              this.conditionStack.push(condition);
            },
            popState: function popState() {
              return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
              return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
              return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
              this.begin(condition);
            }
          };
          lexer2.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            var YYSTATE = YY_START;
            switch ($avoiding_name_collisions) {
              case 0:
                break;
              case 1:
                return 20;
                break;
              case 2:
                return 19;
                break;
              case 3:
                return 8;
                break;
              case 4:
                return 9;
                break;
              case 5:
                return 6;
                break;
              case 6:
                return 7;
                break;
              case 7:
                return 11;
                break;
              case 8:
                return 13;
                break;
              case 9:
                return 10;
                break;
              case 10:
                return 12;
                break;
              case 11:
                return 14;
                break;
              case 12:
                return 15;
                break;
              case 13:
                return 16;
                break;
              case 14:
                return 17;
                break;
              case 15:
                return 18;
                break;
              case 16:
                return 5;
                break;
              case 17:
                return "INVALID";
                break;
            }
          };
          lexer2.rules = [/^\s+/, /^[0-9]+(\.[0-9]+)?\b/, /^n\b/, /^\|\|/, /^&&/, /^\?/, /^:/, /^<=/, /^>=/, /^</, /^>/, /^!=/, /^==/, /^%/, /^\(/, /^\)/, /^$/, /^./];
          lexer2.conditions = { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], "inclusive": true } };
          return lexer2;
        }();
        parser.lexer = lexer;
        return parser;
      }();
      if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
          exports = module.exports = Jed2;
        }
        exports.Jed = Jed2;
      } else {
        if (typeof define === "function" && define.amd) {
          define(function() {
            return Jed2;
          });
        }
        root["Jed"] = Jed2;
      }
    })(exports);
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
function s(n2, l3) {
  for (var u4 in l3)
    n2[u4] = l3[u4];
  return n2;
}
function a(n2) {
  var l3 = n2.parentNode;
  l3 && l3.removeChild(n2);
}
function h(l3, u4, i4) {
  var t4, o3, r3, f3 = {};
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  if (arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), "function" == typeof l3 && null != l3.defaultProps)
    for (r3 in l3.defaultProps)
      void 0 === f3[r3] && (f3[r3] = l3.defaultProps[r3]);
  return v(l3, f3, t4, o3, null);
}
function v(n2, i4, t4, o3, r3) {
  var f3 = { type: n2, props: i4, key: t4, ref: o3, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r3 ? ++u : r3 };
  return null == r3 && null != l.vnode && l.vnode(f3), f3;
}
function y() {
  return { current: null };
}
function p2(n2) {
  return n2.children;
}
function d(n2, l3) {
  this.props = n2, this.context = l3;
}
function _(n2, l3) {
  if (null == l3)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u4; l3 < n2.__k.length; l3++)
    if (null != (u4 = n2.__k[l3]) && null != u4.__e)
      return u4.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l3, u4;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l3 = 0; l3 < n2.__k.length; l3++)
      if (null != (u4 = n2.__k[l3]) && null != u4.__e) {
        n2.__e = n2.__c.base = u4.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l3) {
      return n3.__v.__b - l3.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l3, u4, i4, t4, o3, r3;
      n3.__d && (o3 = (t4 = (l3 = n3).__v).__e, (r3 = l3.__P) && (u4 = [], (i4 = s({}, t4)).__v = t4.__v + 1, j(r3, t4, i4, l3.__n, void 0 !== r3.ownerSVGElement, null != t4.__h ? [o3] : null, u4, null == o3 ? _(t4) : o3, t4.__h), z(u4, t4), t4.__e != o3 && k(t4)));
    });
}
function w(n2, l3, u4, i4, t4, o3, r3, c4, s4, a4) {
  var h3, y4, d4, k5, b4, g4, w5, x5 = i4 && i4.__k || e, C3 = x5.length;
  for (u4.__k = [], h3 = 0; h3 < l3.length; h3++)
    if (null != (k5 = u4.__k[h3] = null == (k5 = l3[h3]) || "boolean" == typeof k5 ? null : "string" == typeof k5 || "number" == typeof k5 || "bigint" == typeof k5 ? v(null, k5, null, null, k5) : Array.isArray(k5) ? v(p2, { children: k5 }, null, null, null) : k5.__b > 0 ? v(k5.type, k5.props, k5.key, k5.ref ? k5.ref : null, k5.__v) : k5)) {
      if (k5.__ = u4, k5.__b = u4.__b + 1, null === (d4 = x5[h3]) || d4 && k5.key == d4.key && k5.type === d4.type)
        x5[h3] = void 0;
      else
        for (y4 = 0; y4 < C3; y4++) {
          if ((d4 = x5[y4]) && k5.key == d4.key && k5.type === d4.type) {
            x5[y4] = void 0;
            break;
          }
          d4 = null;
        }
      j(n2, k5, d4 = d4 || f, t4, o3, r3, c4, s4, a4), b4 = k5.__e, (y4 = k5.ref) && d4.ref != y4 && (w5 || (w5 = []), d4.ref && w5.push(d4.ref, null, k5), w5.push(y4, k5.__c || b4, k5)), null != b4 ? (null == g4 && (g4 = b4), "function" == typeof k5.type && k5.__k === d4.__k ? k5.__d = s4 = m(k5, s4, n2) : s4 = A2(n2, k5, d4, x5, b4, s4), "function" == typeof u4.type && (u4.__d = s4)) : s4 && d4.__e == s4 && s4.parentNode != n2 && (s4 = _(d4));
    }
  for (u4.__e = g4, h3 = C3; h3--; )
    null != x5[h3] && N(x5[h3], x5[h3]);
  if (w5)
    for (h3 = 0; h3 < w5.length; h3++)
      M2(w5[h3], w5[++h3], w5[++h3]);
}
function m(n2, l3, u4) {
  for (var i4, t4 = n2.__k, o3 = 0; t4 && o3 < t4.length; o3++)
    (i4 = t4[o3]) && (i4.__ = n2, l3 = "function" == typeof i4.type ? m(i4, l3, u4) : A2(u4, i4, i4, t4, i4.__e, l3));
  return l3;
}
function x(n2, l3) {
  return l3 = l3 || [], null == n2 || "boolean" == typeof n2 || (Array.isArray(n2) ? n2.some(function(n3) {
    x(n3, l3);
  }) : l3.push(n2)), l3;
}
function A2(n2, l3, u4, i4, t4, o3) {
  var r3, f3, e4;
  if (void 0 !== l3.__d)
    r3 = l3.__d, l3.__d = void 0;
  else if (null == u4 || t4 != o3 || null == t4.parentNode)
    n:
      if (null == o3 || o3.parentNode !== n2)
        n2.appendChild(t4), r3 = null;
      else {
        for (f3 = o3, e4 = 0; (f3 = f3.nextSibling) && e4 < i4.length; e4 += 1)
          if (f3 == t4)
            break n;
        n2.insertBefore(t4, o3), r3 = o3;
      }
  return void 0 !== r3 ? r3 : t4.nextSibling;
}
function C(n2, l3, u4, i4, t4) {
  var o3;
  for (o3 in u4)
    "children" === o3 || "key" === o3 || o3 in l3 || H(n2, o3, null, u4[o3], i4);
  for (o3 in l3)
    t4 && "function" != typeof l3[o3] || "children" === o3 || "key" === o3 || "value" === o3 || "checked" === o3 || u4[o3] === l3[o3] || H(n2, o3, l3[o3], u4[o3], i4);
}
function $(n2, l3, u4) {
  "-" === l3[0] ? n2.setProperty(l3, u4) : n2[l3] = null == u4 ? "" : "number" != typeof u4 || c.test(l3) ? u4 : u4 + "px";
}
function H(n2, l3, u4, i4, t4) {
  var o3;
  n:
    if ("style" === l3)
      if ("string" == typeof u4)
        n2.style.cssText = u4;
      else {
        if ("string" == typeof i4 && (n2.style.cssText = i4 = ""), i4)
          for (l3 in i4)
            u4 && l3 in u4 || $(n2.style, l3, "");
        if (u4)
          for (l3 in u4)
            i4 && u4[l3] === i4[l3] || $(n2.style, l3, u4[l3]);
      }
    else if ("o" === l3[0] && "n" === l3[1])
      o3 = l3 !== (l3 = l3.replace(/Capture$/, "")), l3 = l3.toLowerCase() in n2 ? l3.toLowerCase().slice(2) : l3.slice(2), n2.l || (n2.l = {}), n2.l[l3 + o3] = u4, u4 ? i4 || n2.addEventListener(l3, o3 ? T : I2, o3) : n2.removeEventListener(l3, o3 ? T : I2, o3);
    else if ("dangerouslySetInnerHTML" !== l3) {
      if (t4)
        l3 = l3.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l3 && "list" !== l3 && "form" !== l3 && "tabIndex" !== l3 && "download" !== l3 && l3 in n2)
        try {
          n2[l3] = null == u4 ? "" : u4;
          break n;
        } catch (n3) {
        }
      "function" == typeof u4 || (null == u4 || false === u4 && -1 == l3.indexOf("-") ? n2.removeAttribute(l3) : n2.setAttribute(l3, u4));
    }
}
function I2(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u4, i4, t4, o3, r3, f3, e4, c4) {
  var a4, h3, v3, y4, _3, k5, b4, g4, m4, x5, A5, C3, $3, H4, I5, T5 = u4.type;
  if (void 0 !== u4.constructor)
    return null;
  null != i4.__h && (c4 = i4.__h, e4 = u4.__e = i4.__e, u4.__h = null, r3 = [e4]), (a4 = l.__b) && a4(u4);
  try {
    n:
      if ("function" == typeof T5) {
        if (g4 = u4.props, m4 = (a4 = T5.contextType) && t4[a4.__c], x5 = a4 ? m4 ? m4.props.value : a4.__ : t4, i4.__c ? b4 = (h3 = u4.__c = i4.__c).__ = h3.__E : ("prototype" in T5 && T5.prototype.render ? u4.__c = h3 = new T5(g4, x5) : (u4.__c = h3 = new d(g4, x5), h3.constructor = T5, h3.render = O), m4 && m4.sub(h3), h3.props = g4, h3.state || (h3.state = {}), h3.context = x5, h3.__n = t4, v3 = h3.__d = true, h3.__h = [], h3._sb = []), null == h3.__s && (h3.__s = h3.state), null != T5.getDerivedStateFromProps && (h3.__s == h3.state && (h3.__s = s({}, h3.__s)), s(h3.__s, T5.getDerivedStateFromProps(g4, h3.__s))), y4 = h3.props, _3 = h3.state, v3)
          null == T5.getDerivedStateFromProps && null != h3.componentWillMount && h3.componentWillMount(), null != h3.componentDidMount && h3.__h.push(h3.componentDidMount);
        else {
          if (null == T5.getDerivedStateFromProps && g4 !== y4 && null != h3.componentWillReceiveProps && h3.componentWillReceiveProps(g4, x5), !h3.__e && null != h3.shouldComponentUpdate && false === h3.shouldComponentUpdate(g4, h3.__s, x5) || u4.__v === i4.__v) {
            for (h3.props = g4, h3.state = h3.__s, u4.__v !== i4.__v && (h3.__d = false), h3.__v = u4, u4.__e = i4.__e, u4.__k = i4.__k, u4.__k.forEach(function(n3) {
              n3 && (n3.__ = u4);
            }), A5 = 0; A5 < h3._sb.length; A5++)
              h3.__h.push(h3._sb[A5]);
            h3._sb = [], h3.__h.length && f3.push(h3);
            break n;
          }
          null != h3.componentWillUpdate && h3.componentWillUpdate(g4, h3.__s, x5), null != h3.componentDidUpdate && h3.__h.push(function() {
            h3.componentDidUpdate(y4, _3, k5);
          });
        }
        if (h3.context = x5, h3.props = g4, h3.__v = u4, h3.__P = n2, C3 = l.__r, $3 = 0, "prototype" in T5 && T5.prototype.render) {
          for (h3.state = h3.__s, h3.__d = false, C3 && C3(u4), a4 = h3.render(h3.props, h3.state, h3.context), H4 = 0; H4 < h3._sb.length; H4++)
            h3.__h.push(h3._sb[H4]);
          h3._sb = [];
        } else
          do {
            h3.__d = false, C3 && C3(u4), a4 = h3.render(h3.props, h3.state, h3.context), h3.state = h3.__s;
          } while (h3.__d && ++$3 < 25);
        h3.state = h3.__s, null != h3.getChildContext && (t4 = s(s({}, t4), h3.getChildContext())), v3 || null == h3.getSnapshotBeforeUpdate || (k5 = h3.getSnapshotBeforeUpdate(y4, _3)), I5 = null != a4 && a4.type === p2 && null == a4.key ? a4.props.children : a4, w(n2, Array.isArray(I5) ? I5 : [I5], u4, i4, t4, o3, r3, f3, e4, c4), h3.base = u4.__e, u4.__h = null, h3.__h.length && f3.push(h3), b4 && (h3.__E = h3.__ = null), h3.__e = false;
      } else
        null == r3 && u4.__v === i4.__v ? (u4.__k = i4.__k, u4.__e = i4.__e) : u4.__e = L2(i4.__e, u4, i4, t4, o3, r3, f3, c4);
    (a4 = l.diffed) && a4(u4);
  } catch (n3) {
    u4.__v = null, (c4 || null != r3) && (u4.__e = e4, u4.__h = !!c4, r3[r3.indexOf(e4)] = null), l.__e(n3, u4, i4);
  }
}
function z(n2, u4) {
  l.__c && l.__c(u4, n2), n2.some(function(u5) {
    try {
      n2 = u5.__h, u5.__h = [], n2.some(function(n3) {
        n3.call(u5);
      });
    } catch (n3) {
      l.__e(n3, u5.__v);
    }
  });
}
function L2(l3, u4, i4, t4, o3, r3, e4, c4) {
  var s4, h3, v3, y4 = i4.props, p4 = u4.props, d4 = u4.type, k5 = 0;
  if ("svg" === d4 && (o3 = true), null != r3) {
    for (; k5 < r3.length; k5++)
      if ((s4 = r3[k5]) && "setAttribute" in s4 == !!d4 && (d4 ? s4.localName === d4 : 3 === s4.nodeType)) {
        l3 = s4, r3[k5] = null;
        break;
      }
  }
  if (null == l3) {
    if (null === d4)
      return document.createTextNode(p4);
    l3 = o3 ? document.createElementNS("http://www.w3.org/2000/svg", d4) : document.createElement(d4, p4.is && p4), r3 = null, c4 = false;
  }
  if (null === d4)
    y4 === p4 || c4 && l3.data === p4 || (l3.data = p4);
  else {
    if (r3 = r3 && n.call(l3.childNodes), h3 = (y4 = i4.props || f).dangerouslySetInnerHTML, v3 = p4.dangerouslySetInnerHTML, !c4) {
      if (null != r3)
        for (y4 = {}, k5 = 0; k5 < l3.attributes.length; k5++)
          y4[l3.attributes[k5].name] = l3.attributes[k5].value;
      (v3 || h3) && (v3 && (h3 && v3.__html == h3.__html || v3.__html === l3.innerHTML) || (l3.innerHTML = v3 && v3.__html || ""));
    }
    if (C(l3, p4, y4, o3, c4), v3)
      u4.__k = [];
    else if (k5 = u4.props.children, w(l3, Array.isArray(k5) ? k5 : [k5], u4, i4, t4, o3 && "foreignObject" !== d4, r3, e4, r3 ? r3[0] : i4.__k && _(i4, 0), c4), null != r3)
      for (k5 = r3.length; k5--; )
        null != r3[k5] && a(r3[k5]);
    c4 || ("value" in p4 && void 0 !== (k5 = p4.value) && (k5 !== l3.value || "progress" === d4 && !k5 || "option" === d4 && k5 !== y4.value) && H(l3, "value", k5, y4.value, false), "checked" in p4 && void 0 !== (k5 = p4.checked) && k5 !== l3.checked && H(l3, "checked", k5, y4.checked, false));
  }
  return l3;
}
function M2(n2, u4, i4) {
  try {
    "function" == typeof n2 ? n2(u4) : n2.current = u4;
  } catch (n3) {
    l.__e(n3, i4);
  }
}
function N(n2, u4, i4) {
  var t4, o3;
  if (l.unmount && l.unmount(n2), (t4 = n2.ref) && (t4.current && t4.current !== n2.__e || M2(t4, null, u4)), null != (t4 = n2.__c)) {
    if (t4.componentWillUnmount)
      try {
        t4.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u4);
      }
    t4.base = t4.__P = null, n2.__c = void 0;
  }
  if (t4 = n2.__k)
    for (o3 = 0; o3 < t4.length; o3++)
      t4[o3] && N(t4[o3], u4, i4 || "function" != typeof n2.type);
  i4 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l3, u4) {
  return this.constructor(n2, u4);
}
function P(u4, i4, t4) {
  var o3, r3, e4;
  l.__ && l.__(u4, i4), r3 = (o3 = "function" == typeof t4) ? null : t4 && t4.__k || i4.__k, e4 = [], j(i4, u4 = (!o3 && t4 || i4).__k = h(p2, null, [u4]), r3 || f, f, void 0 !== i4.ownerSVGElement, !o3 && t4 ? [t4] : r3 ? null : i4.firstChild ? n.call(i4.childNodes) : null, e4, !o3 && t4 ? t4 : r3 ? r3.__e : i4.firstChild, o3), z(e4, u4);
}
function S2(n2, l3) {
  P(n2, l3, S2);
}
function q(l3, u4, i4) {
  var t4, o3, r3, f3 = s({}, l3.props);
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  return arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), v(l3.type, f3, t4 || l3.key, o3 || l3.ref, null);
}
function B(n2, l3) {
  var u4 = { __c: l3 = "__cC" + r++, __: n2, Consumer: function(n3, l4) {
    return n3.children(l4);
  }, Provider: function(n3) {
    var u5, i4;
    return this.getChildContext || (u5 = [], (i4 = {})[l3] = this, this.getChildContext = function() {
      return i4;
    }, this.shouldComponentUpdate = function(n4) {
      this.props.value !== n4.value && u5.some(b);
    }, this.sub = function(n4) {
      u5.push(n4);
      var l4 = n4.componentWillUnmount;
      n4.componentWillUnmount = function() {
        u5.splice(u5.indexOf(n4), 1), l4 && l4.call(n4);
      };
    }), n3.children;
  } };
  return u4.Provider.__ = u4.Consumer.contextType = u4;
}
var n, l, u, i, t, o, r, f, e, c;
var init_preact_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js"() {
    f = {};
    e = [];
    c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
    n = e.slice, l = { __e: function(n2, l3, u4, i4) {
      for (var t4, o3, r3; l3 = l3.__; )
        if ((t4 = l3.__c) && !t4.__)
          try {
            if ((o3 = t4.constructor) && null != o3.getDerivedStateFromError && (t4.setState(o3.getDerivedStateFromError(n2)), r3 = t4.__d), null != t4.componentDidCatch && (t4.componentDidCatch(n2, i4 || {}), r3 = t4.__d), r3)
              return t4.__E = t4;
          } catch (l4) {
            n2 = l4;
          }
      throw n2;
    } }, u = 0, i = function(n2) {
      return null != n2 && void 0 === n2.constructor;
    }, d.prototype.setState = function(n2, l3) {
      var u4;
      u4 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u4), this.props)), n2 && s(u4, n2), null != n2 && this.__v && (l3 && this._sb.push(l3), b(this));
    }, d.prototype.forceUpdate = function(n2) {
      this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
    }, d.prototype.render = p2, t = [], g.__r = 0, r = 0;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js
function d2(t4, u4) {
  l.__h && l.__h(r2, t4, o2 || u4), o2 = 0;
  var i4 = r2.__H || (r2.__H = { __: [], __h: [] });
  return t4 >= i4.__.length && i4.__.push({ __V: c2 }), i4.__[t4];
}
function p3(n2) {
  return o2 = 1, y2(B2, n2);
}
function y2(n2, u4, i4) {
  var o3 = d2(t2++, 2);
  if (o3.t = n2, !o3.__c && (o3.__ = [i4 ? i4(u4) : B2(void 0, u4), function(n3) {
    var t4 = o3.__N ? o3.__N[0] : o3.__[0], r3 = o3.t(t4, n3);
    t4 !== r3 && (o3.__N = [r3, o3.__[1]], o3.__c.setState({}));
  }], o3.__c = r2, !r2.u)) {
    r2.u = true;
    var f3 = r2.shouldComponentUpdate;
    r2.shouldComponentUpdate = function(n3, t4, r3) {
      if (!o3.__c.__H)
        return true;
      var u5 = o3.__c.__H.__.filter(function(n4) {
        return n4.__c;
      });
      if (u5.every(function(n4) {
        return !n4.__N;
      }))
        return !f3 || f3.call(this, n3, t4, r3);
      var i5 = false;
      return u5.forEach(function(n4) {
        if (n4.__N) {
          var t5 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t5 !== n4.__[0] && (i5 = true);
        }
      }), !(!i5 && o3.__c.props === n3) && (!f3 || f3.call(this, n3, t4, r3));
    };
  }
  return o3.__N || o3.__;
}
function h2(u4, i4) {
  var o3 = d2(t2++, 3);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__H.__h.push(o3));
}
function s2(u4, i4) {
  var o3 = d2(t2++, 4);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__h.push(o3));
}
function _2(n2) {
  return o2 = 5, F(function() {
    return { current: n2 };
  }, []);
}
function A3(n2, t4, r3) {
  o2 = 6, s2(function() {
    return "function" == typeof n2 ? (n2(t4()), function() {
      return n2(null);
    }) : n2 ? (n2.current = t4(), function() {
      return n2.current = null;
    }) : void 0;
  }, null == r3 ? r3 : r3.concat(n2));
}
function F(n2, r3) {
  var u4 = d2(t2++, 7);
  return z2(u4.__H, r3) ? (u4.__V = n2(), u4.i = r3, u4.__h = n2, u4.__V) : u4.__;
}
function T2(n2, t4) {
  return o2 = 8, F(function() {
    return n2;
  }, t4);
}
function q2(n2) {
  var u4 = r2.context[n2.__c], i4 = d2(t2++, 9);
  return i4.c = n2, u4 ? (null == i4.__ && (i4.__ = true, u4.sub(r2)), u4.props.value) : n2.__;
}
function x2(t4, r3) {
  l.useDebugValue && l.useDebugValue(r3 ? r3(t4) : t4);
}
function P2(n2) {
  var u4 = d2(t2++, 10), i4 = p3();
  return u4.__ = n2, r2.componentDidCatch || (r2.componentDidCatch = function(n3, t4) {
    u4.__ && u4.__(n3, t4), i4[1](n3);
  }), [i4[0], function() {
    i4[1](void 0);
  }];
}
function V() {
  var n2 = d2(t2++, 11);
  if (!n2.__) {
    for (var u4 = r2.__v; null !== u4 && !u4.__m && null !== u4.__; )
      u4 = u4.__;
    var i4 = u4.__m || (u4.__m = [0, 0]);
    n2.__ = "P" + i4[0] + "-" + i4[1]++;
  }
  return n2.__;
}
function b2() {
  for (var t4; t4 = f2.shift(); )
    if (t4.__P && t4.__H)
      try {
        t4.__H.__h.forEach(k2), t4.__H.__h.forEach(w2), t4.__H.__h = [];
      } catch (r3) {
        t4.__H.__h = [], l.__e(r3, t4.__v);
      }
}
function j2(n2) {
  var t4, r3 = function() {
    clearTimeout(u4), g2 && cancelAnimationFrame(t4), setTimeout(n2);
  }, u4 = setTimeout(r3, 100);
  g2 && (t4 = requestAnimationFrame(r3));
}
function k2(n2) {
  var t4 = r2, u4 = n2.__c;
  "function" == typeof u4 && (n2.__c = void 0, u4()), r2 = t4;
}
function w2(n2) {
  var t4 = r2;
  n2.__c = n2.__(), r2 = t4;
}
function z2(n2, t4) {
  return !n2 || n2.length !== t4.length || t4.some(function(t5, r3) {
    return t5 !== n2[r3];
  });
}
function B2(n2, t4) {
  return "function" == typeof t4 ? t4(n2) : t4;
}
var t2, r2, u2, i2, o2, f2, c2, e2, a2, v2, l2, m2, g2;
var init_hooks_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js"() {
    init_preact_module();
    o2 = 0;
    f2 = [];
    c2 = [];
    e2 = l.__b;
    a2 = l.__r;
    v2 = l.diffed;
    l2 = l.__c;
    m2 = l.unmount;
    l.__b = function(n2) {
      r2 = null, e2 && e2(n2);
    }, l.__r = function(n2) {
      a2 && a2(n2), t2 = 0;
      var i4 = (r2 = n2.__c).__H;
      i4 && (u2 === r2 ? (i4.__h = [], r2.__h = [], i4.__.forEach(function(n3) {
        n3.__N && (n3.__ = n3.__N), n3.__V = c2, n3.__N = n3.i = void 0;
      })) : (i4.__h.forEach(k2), i4.__h.forEach(w2), i4.__h = [])), u2 = r2;
    }, l.diffed = function(t4) {
      v2 && v2(t4);
      var o3 = t4.__c;
      o3 && o3.__H && (o3.__H.__h.length && (1 !== f2.push(o3) && i2 === l.requestAnimationFrame || ((i2 = l.requestAnimationFrame) || j2)(b2)), o3.__H.__.forEach(function(n2) {
        n2.i && (n2.__H = n2.i), n2.__V !== c2 && (n2.__ = n2.__V), n2.i = void 0, n2.__V = c2;
      })), u2 = r2 = null;
    }, l.__c = function(t4, r3) {
      r3.some(function(t5) {
        try {
          t5.__h.forEach(k2), t5.__h = t5.__h.filter(function(n2) {
            return !n2.__ || w2(n2);
          });
        } catch (u4) {
          r3.some(function(n2) {
            n2.__h && (n2.__h = []);
          }), r3 = [], l.__e(u4, t5.__v);
        }
      }), l2 && l2(t4, r3);
    }, l.unmount = function(t4) {
      m2 && m2(t4);
      var r3, u4 = t4.__c;
      u4 && u4.__H && (u4.__H.__.forEach(function(n2) {
        try {
          k2(n2);
        } catch (n3) {
          r3 = n3;
        }
      }), u4.__H = void 0, r3 && l.__e(r3, u4.__v));
    };
    g2 = "function" == typeof requestAnimationFrame;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js
var compat_module_exports = {};
__export(compat_module_exports, {
  Children: () => O2,
  Component: () => d,
  Fragment: () => p2,
  PureComponent: () => w3,
  StrictMode: () => vn2,
  Suspense: () => D3,
  SuspenseList: () => V2,
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: () => rn,
  cloneElement: () => cn,
  createContext: () => B,
  createElement: () => h,
  createFactory: () => on,
  createPortal: () => j3,
  createRef: () => y,
  default: () => bn,
  findDOMNode: () => an,
  flushSync: () => hn,
  forwardRef: () => k3,
  hydrate: () => q3,
  isValidElement: () => ln,
  lazy: () => M3,
  memo: () => R,
  render: () => Y2,
  startTransition: () => dn,
  unmountComponentAtNode: () => fn,
  unstable_batchedUpdates: () => sn,
  useCallback: () => T2,
  useContext: () => q2,
  useDebugValue: () => x2,
  useDeferredValue: () => pn,
  useEffect: () => h2,
  useErrorBoundary: () => P2,
  useId: () => V,
  useImperativeHandle: () => A3,
  useInsertionEffect: () => yn,
  useLayoutEffect: () => s2,
  useMemo: () => F,
  useReducer: () => y2,
  useRef: () => _2,
  useState: () => p3,
  useSyncExternalStore: () => _n,
  useTransition: () => mn,
  version: () => un
});
function g3(n2, t4) {
  for (var e4 in t4)
    n2[e4] = t4[e4];
  return n2;
}
function C2(n2, t4) {
  for (var e4 in n2)
    if ("__source" !== e4 && !(e4 in t4))
      return true;
  for (var r3 in t4)
    if ("__source" !== r3 && n2[r3] !== t4[r3])
      return true;
  return false;
}
function E(n2, t4) {
  return n2 === t4 && (0 !== n2 || 1 / n2 == 1 / t4) || n2 != n2 && t4 != t4;
}
function w3(n2) {
  this.props = n2;
}
function R(n2, e4) {
  function r3(n3) {
    var t4 = this.props.ref, r4 = t4 == n3.ref;
    return !r4 && t4 && (t4.call ? t4(null) : t4.current = null), e4 ? !e4(this.props, n3) || !r4 : C2(this.props, n3);
  }
  function u4(e5) {
    return this.shouldComponentUpdate = r3, h(n2, e5);
  }
  return u4.displayName = "Memo(" + (n2.displayName || n2.name) + ")", u4.prototype.isReactComponent = true, u4.__f = true, u4;
}
function k3(n2) {
  function t4(t5) {
    var e4 = g3({}, t5);
    return delete e4.ref, n2(e4, t5.ref || null);
  }
  return t4.$$typeof = N2, t4.render = t4, t4.prototype.isReactComponent = t4.__f = true, t4.displayName = "ForwardRef(" + (n2.displayName || n2.name) + ")", t4;
}
function L3(n2, t4, e4) {
  return n2 && (n2.__c && n2.__c.__H && (n2.__c.__H.__.forEach(function(n3) {
    "function" == typeof n3.__c && n3.__c();
  }), n2.__c.__H = null), null != (n2 = g3({}, n2)).__c && (n2.__c.__P === e4 && (n2.__c.__P = t4), n2.__c = null), n2.__k = n2.__k && n2.__k.map(function(n3) {
    return L3(n3, t4, e4);
  })), n2;
}
function U(n2, t4, e4) {
  return n2 && (n2.__v = null, n2.__k = n2.__k && n2.__k.map(function(n3) {
    return U(n3, t4, e4);
  }), n2.__c && n2.__c.__P === t4 && (n2.__e && e4.insertBefore(n2.__e, n2.__d), n2.__c.__e = true, n2.__c.__P = e4)), n2;
}
function D3() {
  this.__u = 0, this.t = null, this.__b = null;
}
function F2(n2) {
  var t4 = n2.__.__c;
  return t4 && t4.__a && t4.__a(n2);
}
function M3(n2) {
  var e4, r3, u4;
  function o3(o4) {
    if (e4 || (e4 = n2()).then(function(n3) {
      r3 = n3.default || n3;
    }, function(n3) {
      u4 = n3;
    }), u4)
      throw u4;
    if (!r3)
      throw e4;
    return h(r3, o4);
  }
  return o3.displayName = "Lazy", o3.__f = true, o3;
}
function V2() {
  this.u = null, this.o = null;
}
function P3(n2) {
  return this.getChildContext = function() {
    return n2.context;
  }, n2.children;
}
function $2(n2) {
  var e4 = this, r3 = n2.i;
  e4.componentWillUnmount = function() {
    P(null, e4.l), e4.l = null, e4.i = null;
  }, e4.i && e4.i !== r3 && e4.componentWillUnmount(), n2.__v ? (e4.l || (e4.i = r3, e4.l = { nodeType: 1, parentNode: r3, childNodes: [], appendChild: function(n3) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, insertBefore: function(n3, t4) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, removeChild: function(n3) {
    this.childNodes.splice(this.childNodes.indexOf(n3) >>> 1, 1), e4.i.removeChild(n3);
  } }), P(h(P3, { context: e4.context }, n2.__v), e4.l)) : e4.l && e4.componentWillUnmount();
}
function j3(n2, e4) {
  var r3 = h($2, { __v: n2, i: e4 });
  return r3.containerInfo = e4, r3;
}
function Y2(n2, t4, e4) {
  return null == t4.__k && (t4.textContent = ""), P(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function q3(n2, t4, e4) {
  return S2(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function J() {
}
function K3() {
  return this.cancelBubble;
}
function Q() {
  return this.defaultPrevented;
}
function on(n2) {
  return h.bind(null, n2);
}
function ln(n2) {
  return !!n2 && n2.$$typeof === z3;
}
function cn(n2) {
  return ln(n2) ? q.apply(null, arguments) : n2;
}
function fn(n2) {
  return !!n2.__k && (P(null, n2), true);
}
function an(n2) {
  return n2 && (n2.base || 1 === n2.nodeType && n2) || null;
}
function dn(n2) {
  n2();
}
function pn(n2) {
  return n2;
}
function mn() {
  return [false, dn];
}
function _n(n2, t4) {
  var e4 = t4(), r3 = p3({ h: { __: e4, v: t4 } }), u4 = r3[0].h, o3 = r3[1];
  return s2(function() {
    u4.__ = e4, u4.v = t4, E(u4.__, t4()) || o3({ h: u4 });
  }, [n2, e4, t4]), h2(function() {
    return E(u4.__, u4.v()) || o3({ h: u4 }), n2(function() {
      E(u4.__, u4.v()) || o3({ h: u4 });
    });
  }, [n2]), e4;
}
var x3, N2, A4, O2, T3, I3, W, z3, B3, H2, Z2, G, X2, nn, tn, en, rn, un, sn, hn, vn2, yn, bn;
var init_compat_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js"() {
    init_preact_module();
    init_preact_module();
    init_hooks_module();
    init_hooks_module();
    (w3.prototype = new d()).isPureReactComponent = true, w3.prototype.shouldComponentUpdate = function(n2, t4) {
      return C2(this.props, n2) || C2(this.state, t4);
    };
    x3 = l.__b;
    l.__b = function(n2) {
      n2.type && n2.type.__f && n2.ref && (n2.props.ref = n2.ref, n2.ref = null), x3 && x3(n2);
    };
    N2 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.forward_ref") || 3911;
    A4 = function(n2, t4) {
      return null == n2 ? null : x(x(n2).map(t4));
    };
    O2 = { map: A4, forEach: A4, count: function(n2) {
      return n2 ? x(n2).length : 0;
    }, only: function(n2) {
      var t4 = x(n2);
      if (1 !== t4.length)
        throw "Children.only";
      return t4[0];
    }, toArray: x };
    T3 = l.__e;
    l.__e = function(n2, t4, e4, r3) {
      if (n2.then) {
        for (var u4, o3 = t4; o3 = o3.__; )
          if ((u4 = o3.__c) && u4.__c)
            return null == t4.__e && (t4.__e = e4.__e, t4.__k = e4.__k), u4.__c(n2, t4);
      }
      T3(n2, t4, e4, r3);
    };
    I3 = l.unmount;
    l.unmount = function(n2) {
      var t4 = n2.__c;
      t4 && t4.__R && t4.__R(), t4 && true === n2.__h && (n2.type = null), I3 && I3(n2);
    }, (D3.prototype = new d()).__c = function(n2, t4) {
      var e4 = t4.__c, r3 = this;
      null == r3.t && (r3.t = []), r3.t.push(e4);
      var u4 = F2(r3.__v), o3 = false, i4 = function() {
        o3 || (o3 = true, e4.__R = null, u4 ? u4(l3) : l3());
      };
      e4.__R = i4;
      var l3 = function() {
        if (!--r3.__u) {
          if (r3.state.__a) {
            var n3 = r3.state.__a;
            r3.__v.__k[0] = U(n3, n3.__c.__P, n3.__c.__O);
          }
          var t5;
          for (r3.setState({ __a: r3.__b = null }); t5 = r3.t.pop(); )
            t5.forceUpdate();
        }
      }, c4 = true === t4.__h;
      r3.__u++ || c4 || r3.setState({ __a: r3.__b = r3.__v.__k[0] }), n2.then(i4, i4);
    }, D3.prototype.componentWillUnmount = function() {
      this.t = [];
    }, D3.prototype.render = function(n2, e4) {
      if (this.__b) {
        if (this.__v.__k) {
          var r3 = document.createElement("div"), o3 = this.__v.__k[0].__c;
          this.__v.__k[0] = L3(this.__b, r3, o3.__O = o3.__P);
        }
        this.__b = null;
      }
      var i4 = e4.__a && h(p2, null, n2.fallback);
      return i4 && (i4.__h = null), [h(p2, null, e4.__a ? null : n2.children), i4];
    };
    W = function(n2, t4, e4) {
      if (++e4[1] === e4[0] && n2.o.delete(t4), n2.props.revealOrder && ("t" !== n2.props.revealOrder[0] || !n2.o.size))
        for (e4 = n2.u; e4; ) {
          for (; e4.length > 3; )
            e4.pop()();
          if (e4[1] < e4[0])
            break;
          n2.u = e4 = e4[2];
        }
    };
    (V2.prototype = new d()).__a = function(n2) {
      var t4 = this, e4 = F2(t4.__v), r3 = t4.o.get(n2);
      return r3[0]++, function(u4) {
        var o3 = function() {
          t4.props.revealOrder ? (r3.push(u4), W(t4, n2, r3)) : u4();
        };
        e4 ? e4(o3) : o3();
      };
    }, V2.prototype.render = function(n2) {
      this.u = null, this.o = /* @__PURE__ */ new Map();
      var t4 = x(n2.children);
      n2.revealOrder && "b" === n2.revealOrder[0] && t4.reverse();
      for (var e4 = t4.length; e4--; )
        this.o.set(t4[e4], this.u = [1, 0, this.u]);
      return n2.children;
    }, V2.prototype.componentDidUpdate = V2.prototype.componentDidMount = function() {
      var n2 = this;
      this.o.forEach(function(t4, e4) {
        W(n2, e4, t4);
      });
    };
    z3 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103;
    B3 = /^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/;
    H2 = "undefined" != typeof document;
    Z2 = function(n2) {
      return ("undefined" != typeof Symbol && "symbol" == typeof Symbol() ? /fil|che|rad/i : /fil|che|ra/i).test(n2);
    };
    d.prototype.isReactComponent = {}, ["componentWillMount", "componentWillReceiveProps", "componentWillUpdate"].forEach(function(t4) {
      Object.defineProperty(d.prototype, t4, { configurable: true, get: function() {
        return this["UNSAFE_" + t4];
      }, set: function(n2) {
        Object.defineProperty(this, t4, { configurable: true, writable: true, value: n2 });
      } });
    });
    G = l.event;
    l.event = function(n2) {
      return G && (n2 = G(n2)), n2.persist = J, n2.isPropagationStopped = K3, n2.isDefaultPrevented = Q, n2.nativeEvent = n2;
    };
    nn = { configurable: true, get: function() {
      return this.class;
    } };
    tn = l.vnode;
    l.vnode = function(n2) {
      var t4 = n2.type, e4 = n2.props, u4 = e4;
      if ("string" == typeof t4) {
        var o3 = -1 === t4.indexOf("-");
        for (var i4 in u4 = {}, e4) {
          var l3 = e4[i4];
          H2 && "children" === i4 && "noscript" === t4 || "value" === i4 && "defaultValue" in e4 && null == l3 || ("defaultValue" === i4 && "value" in e4 && null == e4.value ? i4 = "value" : "download" === i4 && true === l3 ? l3 = "" : /ondoubleclick/i.test(i4) ? i4 = "ondblclick" : /^onchange(textarea|input)/i.test(i4 + t4) && !Z2(e4.type) ? i4 = "oninput" : /^onfocus$/i.test(i4) ? i4 = "onfocusin" : /^onblur$/i.test(i4) ? i4 = "onfocusout" : /^on(Ani|Tra|Tou|BeforeInp|Compo)/.test(i4) ? i4 = i4.toLowerCase() : o3 && B3.test(i4) ? i4 = i4.replace(/[A-Z0-9]/g, "-$&").toLowerCase() : null === l3 && (l3 = void 0), /^oninput$/i.test(i4) && (i4 = i4.toLowerCase(), u4[i4] && (i4 = "oninputCapture")), u4[i4] = l3);
        }
        "select" == t4 && u4.multiple && Array.isArray(u4.value) && (u4.value = x(e4.children).forEach(function(n3) {
          n3.props.selected = -1 != u4.value.indexOf(n3.props.value);
        })), "select" == t4 && null != u4.defaultValue && (u4.value = x(e4.children).forEach(function(n3) {
          n3.props.selected = u4.multiple ? -1 != u4.defaultValue.indexOf(n3.props.value) : u4.defaultValue == n3.props.value;
        })), n2.props = u4, e4.class != e4.className && (nn.enumerable = "className" in e4, null != e4.className && (u4.class = e4.className), Object.defineProperty(u4, "className", nn));
      }
      n2.$$typeof = z3, tn && tn(n2);
    };
    en = l.__r;
    l.__r = function(n2) {
      en && en(n2), X2 = n2.__c;
    };
    rn = { ReactCurrentDispatcher: { current: { readContext: function(n2) {
      return X2.__n[n2.__c].props.value;
    } } } };
    un = "17.0.2";
    sn = function(n2, t4) {
      return n2(t4);
    };
    hn = function(n2, t4) {
      return n2(t4);
    };
    vn2 = p2;
    yn = s2;
    bn = { useState: p3, useId: V, useReducer: y2, useEffect: h2, useLayoutEffect: s2, useInsertionEffect: yn, useTransition: mn, useDeferredValue: pn, useSyncExternalStore: _n, startTransition: dn, useRef: _2, useImperativeHandle: A3, useMemo: F, useCallback: T2, useContext: q2, useDebugValue: x2, version: "17.0.2", Children: O2, render: Y2, hydrate: q3, unmountComponentAtNode: fn, createPortal: j3, createElement: h, createContext: B, createFactory: on, cloneElement: cn, createRef: y, Fragment: p2, isValidElement: ln, findDOMNode: an, Component: d, PureComponent: w3, memo: R, forwardRef: k3, flushSync: hn, unstable_batchedUpdates: sn, StrictMode: vn2, Suspense: D3, SuspenseList: V2, lazy: M3, __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: rn };
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js
var require_use_sync_external_store_shim_production_min = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js"(exports) {
    "use strict";
    var e4 = (init_compat_module(), __toCommonJS(compat_module_exports));
    function h3(a4, b4) {
      return a4 === b4 && (0 !== a4 || 1 / a4 === 1 / b4) || a4 !== a4 && b4 !== b4;
    }
    var k5 = "function" === typeof Object.is ? Object.is : h3;
    var l3 = e4.useState;
    var m4 = e4.useEffect;
    var n2 = e4.useLayoutEffect;
    var p4 = e4.useDebugValue;
    function q5(a4, b4) {
      var d4 = b4(), f3 = l3({ inst: { value: d4, getSnapshot: b4 } }), c4 = f3[0].inst, g4 = f3[1];
      n2(function() {
        c4.value = d4;
        c4.getSnapshot = b4;
        r3(c4) && g4({ inst: c4 });
      }, [a4, d4, b4]);
      m4(function() {
        r3(c4) && g4({ inst: c4 });
        return a4(function() {
          r3(c4) && g4({ inst: c4 });
        });
      }, [a4]);
      p4(d4);
      return d4;
    }
    function r3(a4) {
      var b4 = a4.getSnapshot;
      a4 = a4.value;
      try {
        var d4 = b4();
        return !k5(a4, d4);
      } catch (f3) {
        return true;
      }
    }
    function t4(a4, b4) {
      return b4();
    }
    var u4 = "undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement ? t4 : q5;
    exports.useSyncExternalStore = void 0 !== e4.useSyncExternalStore ? e4.useSyncExternalStore : u4;
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js
var require_shim = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js"(exports, module) {
    "use strict";
    if (true) {
      module.exports = require_use_sync_external_store_shim_production_min();
    } else {
      module.exports = null;
    }
  }
});

// ../taler-util/lib/nacl-fast.js
var gf = function(init = []) {
  const r3 = new Float64Array(16);
  if (init)
    for (let i4 = 0; i4 < init.length; i4++)
      r3[i4] = init[i4];
  return r3;
};
var randombytes = function(x5, n2) {
  throw new Error("no PRNG");
};
var _9 = new Uint8Array(32);
_9[0] = 9;
var gf0 = gf();
var gf1 = gf([1]);
var _121665 = gf([56129, 1]);
var D = gf([
  30883,
  4953,
  19914,
  30187,
  55467,
  16705,
  2637,
  112,
  59544,
  30585,
  16505,
  36039,
  65139,
  11119,
  27886,
  20995
]);
var D2 = gf([
  61785,
  9906,
  39828,
  60374,
  45398,
  33411,
  5274,
  224,
  53552,
  61171,
  33010,
  6542,
  64743,
  22239,
  55772,
  9222
]);
var X = gf([
  54554,
  36645,
  11616,
  51542,
  42930,
  38181,
  51040,
  26924,
  56412,
  64982,
  57905,
  49316,
  21502,
  52590,
  14035,
  8553
]);
var Y = gf([
  26200,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214
]);
var I = gf([
  41136,
  18958,
  6951,
  50414,
  58488,
  44335,
  6150,
  12099,
  55207,
  15867,
  153,
  11085,
  57099,
  20417,
  9344,
  11139
]);
function ts64(x5, i4, h3, l3) {
  x5[i4] = h3 >> 24 & 255;
  x5[i4 + 1] = h3 >> 16 & 255;
  x5[i4 + 2] = h3 >> 8 & 255;
  x5[i4 + 3] = h3 & 255;
  x5[i4 + 4] = l3 >> 24 & 255;
  x5[i4 + 5] = l3 >> 16 & 255;
  x5[i4 + 6] = l3 >> 8 & 255;
  x5[i4 + 7] = l3 & 255;
}
function vn(x5, xi, y4, yi, n2) {
  let i4, d4 = 0;
  for (i4 = 0; i4 < n2; i4++)
    d4 |= x5[xi + i4] ^ y4[yi + i4];
  return (1 & d4 - 1 >>> 8) - 1;
}
function crypto_verify_32(x5, xi, y4, yi) {
  return vn(x5, xi, y4, yi, 32);
}
function core_salsa20(o3, p4, k5, c4) {
  var j0 = c4[0] & 255 | (c4[1] & 255) << 8 | (c4[2] & 255) << 16 | (c4[3] & 255) << 24, j1 = k5[0] & 255 | (k5[1] & 255) << 8 | (k5[2] & 255) << 16 | (k5[3] & 255) << 24, j22 = k5[4] & 255 | (k5[5] & 255) << 8 | (k5[6] & 255) << 16 | (k5[7] & 255) << 24, j32 = k5[8] & 255 | (k5[9] & 255) << 8 | (k5[10] & 255) << 16 | (k5[11] & 255) << 24, j4 = k5[12] & 255 | (k5[13] & 255) << 8 | (k5[14] & 255) << 16 | (k5[15] & 255) << 24, j5 = c4[4] & 255 | (c4[5] & 255) << 8 | (c4[6] & 255) << 16 | (c4[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c4[8] & 255 | (c4[9] & 255) << 8 | (c4[10] & 255) << 16 | (c4[11] & 255) << 24, j11 = k5[16] & 255 | (k5[17] & 255) << 8 | (k5[18] & 255) << 16 | (k5[19] & 255) << 24, j12 = k5[20] & 255 | (k5[21] & 255) << 8 | (k5[22] & 255) << 16 | (k5[23] & 255) << 24, j13 = k5[24] & 255 | (k5[25] & 255) << 8 | (k5[26] & 255) << 16 | (k5[27] & 255) << 24, j14 = k5[28] & 255 | (k5[29] & 255) << 8 | (k5[30] & 255) << 16 | (k5[31] & 255) << 24, j15 = c4[12] & 255 | (c4[13] & 255) << 8 | (c4[14] & 255) << 16 | (c4[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x5 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u4;
  for (var i4 = 0; i4 < 20; i4 += 2) {
    u4 = x0 + x12 | 0;
    x42 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x42 + x0 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x42 | 0;
    x12 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x12 + x8 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x1 | 0;
    x9 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x9 + x5 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x9 | 0;
    x1 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x1 + x13 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x6 | 0;
    x14 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x14 + x10 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x14 | 0;
    x6 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x6 + x22 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x11 | 0;
    x32 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x32 + x15 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x32 | 0;
    x11 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x11 + x7 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x0 + x32 | 0;
    x1 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x1 + x0 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x1 | 0;
    x32 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x32 + x22 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x42 | 0;
    x6 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x6 + x5 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x6 | 0;
    x42 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x42 + x7 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x9 | 0;
    x11 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x11 + x10 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x11 | 0;
    x9 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x9 + x8 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x14 | 0;
    x12 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x12 + x15 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x12 | 0;
    x14 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x14 + x13 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
  }
  x0 = x0 + j0 | 0;
  x1 = x1 + j1 | 0;
  x22 = x22 + j22 | 0;
  x32 = x32 + j32 | 0;
  x42 = x42 + j4 | 0;
  x5 = x5 + j5 | 0;
  x6 = x6 + j6 | 0;
  x7 = x7 + j7 | 0;
  x8 = x8 + j8 | 0;
  x9 = x9 + j9 | 0;
  x10 = x10 + j10 | 0;
  x11 = x11 + j11 | 0;
  x12 = x12 + j12 | 0;
  x13 = x13 + j13 | 0;
  x14 = x14 + j14 | 0;
  x15 = x15 + j15 | 0;
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x1 >>> 0 & 255;
  o3[5] = x1 >>> 8 & 255;
  o3[6] = x1 >>> 16 & 255;
  o3[7] = x1 >>> 24 & 255;
  o3[8] = x22 >>> 0 & 255;
  o3[9] = x22 >>> 8 & 255;
  o3[10] = x22 >>> 16 & 255;
  o3[11] = x22 >>> 24 & 255;
  o3[12] = x32 >>> 0 & 255;
  o3[13] = x32 >>> 8 & 255;
  o3[14] = x32 >>> 16 & 255;
  o3[15] = x32 >>> 24 & 255;
  o3[16] = x42 >>> 0 & 255;
  o3[17] = x42 >>> 8 & 255;
  o3[18] = x42 >>> 16 & 255;
  o3[19] = x42 >>> 24 & 255;
  o3[20] = x5 >>> 0 & 255;
  o3[21] = x5 >>> 8 & 255;
  o3[22] = x5 >>> 16 & 255;
  o3[23] = x5 >>> 24 & 255;
  o3[24] = x6 >>> 0 & 255;
  o3[25] = x6 >>> 8 & 255;
  o3[26] = x6 >>> 16 & 255;
  o3[27] = x6 >>> 24 & 255;
  o3[28] = x7 >>> 0 & 255;
  o3[29] = x7 >>> 8 & 255;
  o3[30] = x7 >>> 16 & 255;
  o3[31] = x7 >>> 24 & 255;
  o3[32] = x8 >>> 0 & 255;
  o3[33] = x8 >>> 8 & 255;
  o3[34] = x8 >>> 16 & 255;
  o3[35] = x8 >>> 24 & 255;
  o3[36] = x9 >>> 0 & 255;
  o3[37] = x9 >>> 8 & 255;
  o3[38] = x9 >>> 16 & 255;
  o3[39] = x9 >>> 24 & 255;
  o3[40] = x10 >>> 0 & 255;
  o3[41] = x10 >>> 8 & 255;
  o3[42] = x10 >>> 16 & 255;
  o3[43] = x10 >>> 24 & 255;
  o3[44] = x11 >>> 0 & 255;
  o3[45] = x11 >>> 8 & 255;
  o3[46] = x11 >>> 16 & 255;
  o3[47] = x11 >>> 24 & 255;
  o3[48] = x12 >>> 0 & 255;
  o3[49] = x12 >>> 8 & 255;
  o3[50] = x12 >>> 16 & 255;
  o3[51] = x12 >>> 24 & 255;
  o3[52] = x13 >>> 0 & 255;
  o3[53] = x13 >>> 8 & 255;
  o3[54] = x13 >>> 16 & 255;
  o3[55] = x13 >>> 24 & 255;
  o3[56] = x14 >>> 0 & 255;
  o3[57] = x14 >>> 8 & 255;
  o3[58] = x14 >>> 16 & 255;
  o3[59] = x14 >>> 24 & 255;
  o3[60] = x15 >>> 0 & 255;
  o3[61] = x15 >>> 8 & 255;
  o3[62] = x15 >>> 16 & 255;
  o3[63] = x15 >>> 24 & 255;
}
function core_hsalsa20(o3, p4, k5, c4) {
  var j0 = c4[0] & 255 | (c4[1] & 255) << 8 | (c4[2] & 255) << 16 | (c4[3] & 255) << 24, j1 = k5[0] & 255 | (k5[1] & 255) << 8 | (k5[2] & 255) << 16 | (k5[3] & 255) << 24, j22 = k5[4] & 255 | (k5[5] & 255) << 8 | (k5[6] & 255) << 16 | (k5[7] & 255) << 24, j32 = k5[8] & 255 | (k5[9] & 255) << 8 | (k5[10] & 255) << 16 | (k5[11] & 255) << 24, j4 = k5[12] & 255 | (k5[13] & 255) << 8 | (k5[14] & 255) << 16 | (k5[15] & 255) << 24, j5 = c4[4] & 255 | (c4[5] & 255) << 8 | (c4[6] & 255) << 16 | (c4[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c4[8] & 255 | (c4[9] & 255) << 8 | (c4[10] & 255) << 16 | (c4[11] & 255) << 24, j11 = k5[16] & 255 | (k5[17] & 255) << 8 | (k5[18] & 255) << 16 | (k5[19] & 255) << 24, j12 = k5[20] & 255 | (k5[21] & 255) << 8 | (k5[22] & 255) << 16 | (k5[23] & 255) << 24, j13 = k5[24] & 255 | (k5[25] & 255) << 8 | (k5[26] & 255) << 16 | (k5[27] & 255) << 24, j14 = k5[28] & 255 | (k5[29] & 255) << 8 | (k5[30] & 255) << 16 | (k5[31] & 255) << 24, j15 = c4[12] & 255 | (c4[13] & 255) << 8 | (c4[14] & 255) << 16 | (c4[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x5 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u4;
  for (var i4 = 0; i4 < 20; i4 += 2) {
    u4 = x0 + x12 | 0;
    x42 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x42 + x0 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x42 | 0;
    x12 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x12 + x8 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x1 | 0;
    x9 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x9 + x5 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x9 | 0;
    x1 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x1 + x13 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x6 | 0;
    x14 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x14 + x10 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x14 | 0;
    x6 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x6 + x22 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x11 | 0;
    x32 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x32 + x15 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x32 | 0;
    x11 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x11 + x7 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x0 + x32 | 0;
    x1 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x1 + x0 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x1 | 0;
    x32 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x32 + x22 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x42 | 0;
    x6 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x6 + x5 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x6 | 0;
    x42 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x42 + x7 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x9 | 0;
    x11 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x11 + x10 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x11 | 0;
    x9 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x9 + x8 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x14 | 0;
    x12 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x12 + x15 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x12 | 0;
    x14 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x14 + x13 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
  }
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x5 >>> 0 & 255;
  o3[5] = x5 >>> 8 & 255;
  o3[6] = x5 >>> 16 & 255;
  o3[7] = x5 >>> 24 & 255;
  o3[8] = x10 >>> 0 & 255;
  o3[9] = x10 >>> 8 & 255;
  o3[10] = x10 >>> 16 & 255;
  o3[11] = x10 >>> 24 & 255;
  o3[12] = x15 >>> 0 & 255;
  o3[13] = x15 >>> 8 & 255;
  o3[14] = x15 >>> 16 & 255;
  o3[15] = x15 >>> 24 & 255;
  o3[16] = x6 >>> 0 & 255;
  o3[17] = x6 >>> 8 & 255;
  o3[18] = x6 >>> 16 & 255;
  o3[19] = x6 >>> 24 & 255;
  o3[20] = x7 >>> 0 & 255;
  o3[21] = x7 >>> 8 & 255;
  o3[22] = x7 >>> 16 & 255;
  o3[23] = x7 >>> 24 & 255;
  o3[24] = x8 >>> 0 & 255;
  o3[25] = x8 >>> 8 & 255;
  o3[26] = x8 >>> 16 & 255;
  o3[27] = x8 >>> 24 & 255;
  o3[28] = x9 >>> 0 & 255;
  o3[29] = x9 >>> 8 & 255;
  o3[30] = x9 >>> 16 & 255;
  o3[31] = x9 >>> 24 & 255;
}
var sigma = new Uint8Array([
  101,
  120,
  112,
  97,
  110,
  100,
  32,
  51,
  50,
  45,
  98,
  121,
  116,
  101,
  32,
  107
]);
function crypto_stream_salsa20_xor(c4, cpos, m4, mpos, b4, n2, k5) {
  var z5 = new Uint8Array(16), x5 = new Uint8Array(64);
  var u4, i4;
  for (i4 = 0; i4 < 16; i4++)
    z5[i4] = 0;
  for (i4 = 0; i4 < 8; i4++)
    z5[i4] = n2[i4];
  while (b4 >= 64) {
    core_salsa20(x5, z5, k5, sigma);
    for (i4 = 0; i4 < 64; i4++)
      c4[cpos + i4] = m4[mpos + i4] ^ x5[i4];
    u4 = 1;
    for (i4 = 8; i4 < 16; i4++) {
      u4 = u4 + (z5[i4] & 255) | 0;
      z5[i4] = u4 & 255;
      u4 >>>= 8;
    }
    b4 -= 64;
    cpos += 64;
    mpos += 64;
  }
  if (b4 > 0) {
    core_salsa20(x5, z5, k5, sigma);
    for (i4 = 0; i4 < b4; i4++)
      c4[cpos + i4] = m4[mpos + i4] ^ x5[i4];
  }
  return 0;
}
function crypto_stream_xor(c4, cpos, m4, mpos, d4, n2, k5) {
  var s4 = new Uint8Array(32);
  core_hsalsa20(s4, n2, k5, sigma);
  var sn2 = new Uint8Array(8);
  for (var i4 = 0; i4 < 8; i4++)
    sn2[i4] = n2[i4 + 16];
  return crypto_stream_salsa20_xor(c4, cpos, m4, mpos, d4, sn2, s4);
}
var poly1305 = class {
  constructor(key) {
    this.buffer = new Uint8Array(16);
    this.r = new Uint16Array(10);
    this.h = new Uint16Array(10);
    this.pad = new Uint16Array(8);
    this.leftover = 0;
    this.fin = 0;
    var t0, t1, t22, t32, t4, t5, t6, t7;
    t0 = key[0] & 255 | (key[1] & 255) << 8;
    this.r[0] = t0 & 8191;
    t1 = key[2] & 255 | (key[3] & 255) << 8;
    this.r[1] = (t0 >>> 13 | t1 << 3) & 8191;
    t22 = key[4] & 255 | (key[5] & 255) << 8;
    this.r[2] = (t1 >>> 10 | t22 << 6) & 7939;
    t32 = key[6] & 255 | (key[7] & 255) << 8;
    this.r[3] = (t22 >>> 7 | t32 << 9) & 8191;
    t4 = key[8] & 255 | (key[9] & 255) << 8;
    this.r[4] = (t32 >>> 4 | t4 << 12) & 255;
    this.r[5] = t4 >>> 1 & 8190;
    t5 = key[10] & 255 | (key[11] & 255) << 8;
    this.r[6] = (t4 >>> 14 | t5 << 2) & 8191;
    t6 = key[12] & 255 | (key[13] & 255) << 8;
    this.r[7] = (t5 >>> 11 | t6 << 5) & 8065;
    t7 = key[14] & 255 | (key[15] & 255) << 8;
    this.r[8] = (t6 >>> 8 | t7 << 8) & 8191;
    this.r[9] = t7 >>> 5 & 127;
    this.pad[0] = key[16] & 255 | (key[17] & 255) << 8;
    this.pad[1] = key[18] & 255 | (key[19] & 255) << 8;
    this.pad[2] = key[20] & 255 | (key[21] & 255) << 8;
    this.pad[3] = key[22] & 255 | (key[23] & 255) << 8;
    this.pad[4] = key[24] & 255 | (key[25] & 255) << 8;
    this.pad[5] = key[26] & 255 | (key[27] & 255) << 8;
    this.pad[6] = key[28] & 255 | (key[29] & 255) << 8;
    this.pad[7] = key[30] & 255 | (key[31] & 255) << 8;
  }
  blocks(m4, mpos, bytes) {
    var hibit = this.fin ? 0 : 1 << 11;
    var t0, t1, t22, t32, t4, t5, t6, t7, c4;
    var d0, d1, d23, d32, d4, d5, d6, d7, d8, d9;
    var h0 = this.h[0], h1 = this.h[1], h22 = this.h[2], h3 = this.h[3], h4 = this.h[4], h5 = this.h[5], h6 = this.h[6], h7 = this.h[7], h8 = this.h[8], h9 = this.h[9];
    var r0 = this.r[0], r1 = this.r[1], r22 = this.r[2], r3 = this.r[3], r4 = this.r[4], r5 = this.r[5], r6 = this.r[6], r7 = this.r[7], r8 = this.r[8], r9 = this.r[9];
    while (bytes >= 16) {
      t0 = m4[mpos + 0] & 255 | (m4[mpos + 1] & 255) << 8;
      h0 += t0 & 8191;
      t1 = m4[mpos + 2] & 255 | (m4[mpos + 3] & 255) << 8;
      h1 += (t0 >>> 13 | t1 << 3) & 8191;
      t22 = m4[mpos + 4] & 255 | (m4[mpos + 5] & 255) << 8;
      h22 += (t1 >>> 10 | t22 << 6) & 8191;
      t32 = m4[mpos + 6] & 255 | (m4[mpos + 7] & 255) << 8;
      h3 += (t22 >>> 7 | t32 << 9) & 8191;
      t4 = m4[mpos + 8] & 255 | (m4[mpos + 9] & 255) << 8;
      h4 += (t32 >>> 4 | t4 << 12) & 8191;
      h5 += t4 >>> 1 & 8191;
      t5 = m4[mpos + 10] & 255 | (m4[mpos + 11] & 255) << 8;
      h6 += (t4 >>> 14 | t5 << 2) & 8191;
      t6 = m4[mpos + 12] & 255 | (m4[mpos + 13] & 255) << 8;
      h7 += (t5 >>> 11 | t6 << 5) & 8191;
      t7 = m4[mpos + 14] & 255 | (m4[mpos + 15] & 255) << 8;
      h8 += (t6 >>> 8 | t7 << 8) & 8191;
      h9 += t7 >>> 5 | hibit;
      c4 = 0;
      d0 = c4;
      d0 += h0 * r0;
      d0 += h1 * (5 * r9);
      d0 += h22 * (5 * r8);
      d0 += h3 * (5 * r7);
      d0 += h4 * (5 * r6);
      c4 = d0 >>> 13;
      d0 &= 8191;
      d0 += h5 * (5 * r5);
      d0 += h6 * (5 * r4);
      d0 += h7 * (5 * r3);
      d0 += h8 * (5 * r22);
      d0 += h9 * (5 * r1);
      c4 += d0 >>> 13;
      d0 &= 8191;
      d1 = c4;
      d1 += h0 * r1;
      d1 += h1 * r0;
      d1 += h22 * (5 * r9);
      d1 += h3 * (5 * r8);
      d1 += h4 * (5 * r7);
      c4 = d1 >>> 13;
      d1 &= 8191;
      d1 += h5 * (5 * r6);
      d1 += h6 * (5 * r5);
      d1 += h7 * (5 * r4);
      d1 += h8 * (5 * r3);
      d1 += h9 * (5 * r22);
      c4 += d1 >>> 13;
      d1 &= 8191;
      d23 = c4;
      d23 += h0 * r22;
      d23 += h1 * r1;
      d23 += h22 * r0;
      d23 += h3 * (5 * r9);
      d23 += h4 * (5 * r8);
      c4 = d23 >>> 13;
      d23 &= 8191;
      d23 += h5 * (5 * r7);
      d23 += h6 * (5 * r6);
      d23 += h7 * (5 * r5);
      d23 += h8 * (5 * r4);
      d23 += h9 * (5 * r3);
      c4 += d23 >>> 13;
      d23 &= 8191;
      d32 = c4;
      d32 += h0 * r3;
      d32 += h1 * r22;
      d32 += h22 * r1;
      d32 += h3 * r0;
      d32 += h4 * (5 * r9);
      c4 = d32 >>> 13;
      d32 &= 8191;
      d32 += h5 * (5 * r8);
      d32 += h6 * (5 * r7);
      d32 += h7 * (5 * r6);
      d32 += h8 * (5 * r5);
      d32 += h9 * (5 * r4);
      c4 += d32 >>> 13;
      d32 &= 8191;
      d4 = c4;
      d4 += h0 * r4;
      d4 += h1 * r3;
      d4 += h22 * r22;
      d4 += h3 * r1;
      d4 += h4 * r0;
      c4 = d4 >>> 13;
      d4 &= 8191;
      d4 += h5 * (5 * r9);
      d4 += h6 * (5 * r8);
      d4 += h7 * (5 * r7);
      d4 += h8 * (5 * r6);
      d4 += h9 * (5 * r5);
      c4 += d4 >>> 13;
      d4 &= 8191;
      d5 = c4;
      d5 += h0 * r5;
      d5 += h1 * r4;
      d5 += h22 * r3;
      d5 += h3 * r22;
      d5 += h4 * r1;
      c4 = d5 >>> 13;
      d5 &= 8191;
      d5 += h5 * r0;
      d5 += h6 * (5 * r9);
      d5 += h7 * (5 * r8);
      d5 += h8 * (5 * r7);
      d5 += h9 * (5 * r6);
      c4 += d5 >>> 13;
      d5 &= 8191;
      d6 = c4;
      d6 += h0 * r6;
      d6 += h1 * r5;
      d6 += h22 * r4;
      d6 += h3 * r3;
      d6 += h4 * r22;
      c4 = d6 >>> 13;
      d6 &= 8191;
      d6 += h5 * r1;
      d6 += h6 * r0;
      d6 += h7 * (5 * r9);
      d6 += h8 * (5 * r8);
      d6 += h9 * (5 * r7);
      c4 += d6 >>> 13;
      d6 &= 8191;
      d7 = c4;
      d7 += h0 * r7;
      d7 += h1 * r6;
      d7 += h22 * r5;
      d7 += h3 * r4;
      d7 += h4 * r3;
      c4 = d7 >>> 13;
      d7 &= 8191;
      d7 += h5 * r22;
      d7 += h6 * r1;
      d7 += h7 * r0;
      d7 += h8 * (5 * r9);
      d7 += h9 * (5 * r8);
      c4 += d7 >>> 13;
      d7 &= 8191;
      d8 = c4;
      d8 += h0 * r8;
      d8 += h1 * r7;
      d8 += h22 * r6;
      d8 += h3 * r5;
      d8 += h4 * r4;
      c4 = d8 >>> 13;
      d8 &= 8191;
      d8 += h5 * r3;
      d8 += h6 * r22;
      d8 += h7 * r1;
      d8 += h8 * r0;
      d8 += h9 * (5 * r9);
      c4 += d8 >>> 13;
      d8 &= 8191;
      d9 = c4;
      d9 += h0 * r9;
      d9 += h1 * r8;
      d9 += h22 * r7;
      d9 += h3 * r6;
      d9 += h4 * r5;
      c4 = d9 >>> 13;
      d9 &= 8191;
      d9 += h5 * r4;
      d9 += h6 * r3;
      d9 += h7 * r22;
      d9 += h8 * r1;
      d9 += h9 * r0;
      c4 += d9 >>> 13;
      d9 &= 8191;
      c4 = (c4 << 2) + c4 | 0;
      c4 = c4 + d0 | 0;
      d0 = c4 & 8191;
      c4 = c4 >>> 13;
      d1 += c4;
      h0 = d0;
      h1 = d1;
      h22 = d23;
      h3 = d32;
      h4 = d4;
      h5 = d5;
      h6 = d6;
      h7 = d7;
      h8 = d8;
      h9 = d9;
      mpos += 16;
      bytes -= 16;
    }
    this.h[0] = h0;
    this.h[1] = h1;
    this.h[2] = h22;
    this.h[3] = h3;
    this.h[4] = h4;
    this.h[5] = h5;
    this.h[6] = h6;
    this.h[7] = h7;
    this.h[8] = h8;
    this.h[9] = h9;
  }
  finish(mac, macpos) {
    var g4 = new Uint16Array(10);
    var c4, mask, f3, i4;
    if (this.leftover) {
      i4 = this.leftover;
      this.buffer[i4++] = 1;
      for (; i4 < 16; i4++)
        this.buffer[i4] = 0;
      this.fin = 1;
      this.blocks(this.buffer, 0, 16);
    }
    c4 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    for (i4 = 2; i4 < 10; i4++) {
      this.h[i4] += c4;
      c4 = this.h[i4] >>> 13;
      this.h[i4] &= 8191;
    }
    this.h[0] += c4 * 5;
    c4 = this.h[0] >>> 13;
    this.h[0] &= 8191;
    this.h[1] += c4;
    c4 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    this.h[2] += c4;
    g4[0] = this.h[0] + 5;
    c4 = g4[0] >>> 13;
    g4[0] &= 8191;
    for (i4 = 1; i4 < 10; i4++) {
      g4[i4] = this.h[i4] + c4;
      c4 = g4[i4] >>> 13;
      g4[i4] &= 8191;
    }
    g4[9] -= 1 << 13;
    mask = (c4 ^ 1) - 1;
    for (i4 = 0; i4 < 10; i4++)
      g4[i4] &= mask;
    mask = ~mask;
    for (i4 = 0; i4 < 10; i4++)
      this.h[i4] = this.h[i4] & mask | g4[i4];
    this.h[0] = (this.h[0] | this.h[1] << 13) & 65535;
    this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 65535;
    this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 65535;
    this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 65535;
    this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 65535;
    this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 65535;
    this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 65535;
    this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 65535;
    f3 = this.h[0] + this.pad[0];
    this.h[0] = f3 & 65535;
    for (i4 = 1; i4 < 8; i4++) {
      f3 = (this.h[i4] + this.pad[i4] | 0) + (f3 >>> 16) | 0;
      this.h[i4] = f3 & 65535;
    }
    mac[macpos + 0] = this.h[0] >>> 0 & 255;
    mac[macpos + 1] = this.h[0] >>> 8 & 255;
    mac[macpos + 2] = this.h[1] >>> 0 & 255;
    mac[macpos + 3] = this.h[1] >>> 8 & 255;
    mac[macpos + 4] = this.h[2] >>> 0 & 255;
    mac[macpos + 5] = this.h[2] >>> 8 & 255;
    mac[macpos + 6] = this.h[3] >>> 0 & 255;
    mac[macpos + 7] = this.h[3] >>> 8 & 255;
    mac[macpos + 8] = this.h[4] >>> 0 & 255;
    mac[macpos + 9] = this.h[4] >>> 8 & 255;
    mac[macpos + 10] = this.h[5] >>> 0 & 255;
    mac[macpos + 11] = this.h[5] >>> 8 & 255;
    mac[macpos + 12] = this.h[6] >>> 0 & 255;
    mac[macpos + 13] = this.h[6] >>> 8 & 255;
    mac[macpos + 14] = this.h[7] >>> 0 & 255;
    mac[macpos + 15] = this.h[7] >>> 8 & 255;
  }
  update(m4, mpos, bytes) {
    let i4;
    let want;
    if (this.leftover) {
      want = 16 - this.leftover;
      if (want > bytes)
        want = bytes;
      for (i4 = 0; i4 < want; i4++)
        this.buffer[this.leftover + i4] = m4[mpos + i4];
      bytes -= want;
      mpos += want;
      this.leftover += want;
      if (this.leftover < 16)
        return;
      this.blocks(this.buffer, 0, 16);
      this.leftover = 0;
    }
    if (bytes >= 16) {
      want = bytes - bytes % 16;
      this.blocks(m4, mpos, want);
      mpos += want;
      bytes -= want;
    }
    if (bytes) {
      for (i4 = 0; i4 < bytes; i4++)
        this.buffer[this.leftover + i4] = m4[mpos + i4];
      this.leftover += bytes;
    }
  }
};
function crypto_onetimeauth(out, outpos, m4, mpos, n2, k5) {
  var s4 = new poly1305(k5);
  s4.update(m4, mpos, n2);
  s4.finish(out, outpos);
  return 0;
}
function crypto_secretbox(c4, m4, d4, n2, k5) {
  var i4;
  if (d4 < 32)
    return -1;
  crypto_stream_xor(c4, 0, m4, 0, d4, n2, k5);
  crypto_onetimeauth(c4, 16, c4, 32, d4 - 32, c4);
  for (i4 = 0; i4 < 16; i4++)
    c4[i4] = 0;
  return 0;
}
function set25519(r3, a4) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    r3[i4] = a4[i4] | 0;
}
function car25519(o3) {
  let i4, v3, c4 = 1;
  for (i4 = 0; i4 < 16; i4++) {
    v3 = o3[i4] + c4 + 65535;
    c4 = Math.floor(v3 / 65536);
    o3[i4] = v3 - c4 * 65536;
  }
  o3[0] += c4 - 1 + 37 * (c4 - 1);
}
function sel25519(p4, q5, b4) {
  let t4;
  const c4 = ~(b4 - 1);
  for (let i4 = 0; i4 < 16; i4++) {
    t4 = c4 & (p4[i4] ^ q5[i4]);
    p4[i4] ^= t4;
    q5[i4] ^= t4;
  }
}
function pack25519(o3, n2) {
  let i4, j4, b4;
  const m4 = gf(), t4 = gf();
  for (i4 = 0; i4 < 16; i4++)
    t4[i4] = n2[i4];
  car25519(t4);
  car25519(t4);
  car25519(t4);
  for (j4 = 0; j4 < 2; j4++) {
    m4[0] = t4[0] - 65517;
    for (i4 = 1; i4 < 15; i4++) {
      m4[i4] = t4[i4] - 65535 - (m4[i4 - 1] >> 16 & 1);
      m4[i4 - 1] &= 65535;
    }
    m4[15] = t4[15] - 32767 - (m4[14] >> 16 & 1);
    b4 = m4[15] >> 16 & 1;
    m4[14] &= 65535;
    sel25519(t4, m4, 1 - b4);
  }
  for (i4 = 0; i4 < 16; i4++) {
    o3[2 * i4] = t4[i4] & 255;
    o3[2 * i4 + 1] = t4[i4] >> 8;
  }
}
function neq25519(a4, b4) {
  const c4 = new Uint8Array(32), d4 = new Uint8Array(32);
  pack25519(c4, a4);
  pack25519(d4, b4);
  return crypto_verify_32(c4, 0, d4, 0);
}
function par25519(a4) {
  const d4 = new Uint8Array(32);
  pack25519(d4, a4);
  return d4[0] & 1;
}
function unpack25519(o3, n2) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    o3[i4] = n2[2 * i4] + (n2[2 * i4 + 1] << 8);
  o3[15] &= 32767;
}
function A(o3, a4, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a4[i4] + b4[i4];
}
function Z(o3, a4, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a4[i4] - b4[i4];
}
function M(o3, a4, b4) {
  let v3, c4, t0 = 0, t1 = 0, t22 = 0, t32 = 0, t4 = 0, t5 = 0, t6 = 0, t7 = 0, t8 = 0, t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0, t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t222 = 0, t23 = 0, t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0;
  const b0 = b4[0], b1 = b4[1], b22 = b4[2], b32 = b4[3], b42 = b4[4], b5 = b4[5], b6 = b4[6], b7 = b4[7], b8 = b4[8], b9 = b4[9], b10 = b4[10], b11 = b4[11], b12 = b4[12], b13 = b4[13], b14 = b4[14], b15 = b4[15];
  v3 = a4[0];
  t0 += v3 * b0;
  t1 += v3 * b1;
  t22 += v3 * b22;
  t32 += v3 * b32;
  t4 += v3 * b42;
  t5 += v3 * b5;
  t6 += v3 * b6;
  t7 += v3 * b7;
  t8 += v3 * b8;
  t9 += v3 * b9;
  t10 += v3 * b10;
  t11 += v3 * b11;
  t12 += v3 * b12;
  t13 += v3 * b13;
  t14 += v3 * b14;
  t15 += v3 * b15;
  v3 = a4[1];
  t1 += v3 * b0;
  t22 += v3 * b1;
  t32 += v3 * b22;
  t4 += v3 * b32;
  t5 += v3 * b42;
  t6 += v3 * b5;
  t7 += v3 * b6;
  t8 += v3 * b7;
  t9 += v3 * b8;
  t10 += v3 * b9;
  t11 += v3 * b10;
  t12 += v3 * b11;
  t13 += v3 * b12;
  t14 += v3 * b13;
  t15 += v3 * b14;
  t16 += v3 * b15;
  v3 = a4[2];
  t22 += v3 * b0;
  t32 += v3 * b1;
  t4 += v3 * b22;
  t5 += v3 * b32;
  t6 += v3 * b42;
  t7 += v3 * b5;
  t8 += v3 * b6;
  t9 += v3 * b7;
  t10 += v3 * b8;
  t11 += v3 * b9;
  t12 += v3 * b10;
  t13 += v3 * b11;
  t14 += v3 * b12;
  t15 += v3 * b13;
  t16 += v3 * b14;
  t17 += v3 * b15;
  v3 = a4[3];
  t32 += v3 * b0;
  t4 += v3 * b1;
  t5 += v3 * b22;
  t6 += v3 * b32;
  t7 += v3 * b42;
  t8 += v3 * b5;
  t9 += v3 * b6;
  t10 += v3 * b7;
  t11 += v3 * b8;
  t12 += v3 * b9;
  t13 += v3 * b10;
  t14 += v3 * b11;
  t15 += v3 * b12;
  t16 += v3 * b13;
  t17 += v3 * b14;
  t18 += v3 * b15;
  v3 = a4[4];
  t4 += v3 * b0;
  t5 += v3 * b1;
  t6 += v3 * b22;
  t7 += v3 * b32;
  t8 += v3 * b42;
  t9 += v3 * b5;
  t10 += v3 * b6;
  t11 += v3 * b7;
  t12 += v3 * b8;
  t13 += v3 * b9;
  t14 += v3 * b10;
  t15 += v3 * b11;
  t16 += v3 * b12;
  t17 += v3 * b13;
  t18 += v3 * b14;
  t19 += v3 * b15;
  v3 = a4[5];
  t5 += v3 * b0;
  t6 += v3 * b1;
  t7 += v3 * b22;
  t8 += v3 * b32;
  t9 += v3 * b42;
  t10 += v3 * b5;
  t11 += v3 * b6;
  t12 += v3 * b7;
  t13 += v3 * b8;
  t14 += v3 * b9;
  t15 += v3 * b10;
  t16 += v3 * b11;
  t17 += v3 * b12;
  t18 += v3 * b13;
  t19 += v3 * b14;
  t20 += v3 * b15;
  v3 = a4[6];
  t6 += v3 * b0;
  t7 += v3 * b1;
  t8 += v3 * b22;
  t9 += v3 * b32;
  t10 += v3 * b42;
  t11 += v3 * b5;
  t12 += v3 * b6;
  t13 += v3 * b7;
  t14 += v3 * b8;
  t15 += v3 * b9;
  t16 += v3 * b10;
  t17 += v3 * b11;
  t18 += v3 * b12;
  t19 += v3 * b13;
  t20 += v3 * b14;
  t21 += v3 * b15;
  v3 = a4[7];
  t7 += v3 * b0;
  t8 += v3 * b1;
  t9 += v3 * b22;
  t10 += v3 * b32;
  t11 += v3 * b42;
  t12 += v3 * b5;
  t13 += v3 * b6;
  t14 += v3 * b7;
  t15 += v3 * b8;
  t16 += v3 * b9;
  t17 += v3 * b10;
  t18 += v3 * b11;
  t19 += v3 * b12;
  t20 += v3 * b13;
  t21 += v3 * b14;
  t222 += v3 * b15;
  v3 = a4[8];
  t8 += v3 * b0;
  t9 += v3 * b1;
  t10 += v3 * b22;
  t11 += v3 * b32;
  t12 += v3 * b42;
  t13 += v3 * b5;
  t14 += v3 * b6;
  t15 += v3 * b7;
  t16 += v3 * b8;
  t17 += v3 * b9;
  t18 += v3 * b10;
  t19 += v3 * b11;
  t20 += v3 * b12;
  t21 += v3 * b13;
  t222 += v3 * b14;
  t23 += v3 * b15;
  v3 = a4[9];
  t9 += v3 * b0;
  t10 += v3 * b1;
  t11 += v3 * b22;
  t12 += v3 * b32;
  t13 += v3 * b42;
  t14 += v3 * b5;
  t15 += v3 * b6;
  t16 += v3 * b7;
  t17 += v3 * b8;
  t18 += v3 * b9;
  t19 += v3 * b10;
  t20 += v3 * b11;
  t21 += v3 * b12;
  t222 += v3 * b13;
  t23 += v3 * b14;
  t24 += v3 * b15;
  v3 = a4[10];
  t10 += v3 * b0;
  t11 += v3 * b1;
  t12 += v3 * b22;
  t13 += v3 * b32;
  t14 += v3 * b42;
  t15 += v3 * b5;
  t16 += v3 * b6;
  t17 += v3 * b7;
  t18 += v3 * b8;
  t19 += v3 * b9;
  t20 += v3 * b10;
  t21 += v3 * b11;
  t222 += v3 * b12;
  t23 += v3 * b13;
  t24 += v3 * b14;
  t25 += v3 * b15;
  v3 = a4[11];
  t11 += v3 * b0;
  t12 += v3 * b1;
  t13 += v3 * b22;
  t14 += v3 * b32;
  t15 += v3 * b42;
  t16 += v3 * b5;
  t17 += v3 * b6;
  t18 += v3 * b7;
  t19 += v3 * b8;
  t20 += v3 * b9;
  t21 += v3 * b10;
  t222 += v3 * b11;
  t23 += v3 * b12;
  t24 += v3 * b13;
  t25 += v3 * b14;
  t26 += v3 * b15;
  v3 = a4[12];
  t12 += v3 * b0;
  t13 += v3 * b1;
  t14 += v3 * b22;
  t15 += v3 * b32;
  t16 += v3 * b42;
  t17 += v3 * b5;
  t18 += v3 * b6;
  t19 += v3 * b7;
  t20 += v3 * b8;
  t21 += v3 * b9;
  t222 += v3 * b10;
  t23 += v3 * b11;
  t24 += v3 * b12;
  t25 += v3 * b13;
  t26 += v3 * b14;
  t27 += v3 * b15;
  v3 = a4[13];
  t13 += v3 * b0;
  t14 += v3 * b1;
  t15 += v3 * b22;
  t16 += v3 * b32;
  t17 += v3 * b42;
  t18 += v3 * b5;
  t19 += v3 * b6;
  t20 += v3 * b7;
  t21 += v3 * b8;
  t222 += v3 * b9;
  t23 += v3 * b10;
  t24 += v3 * b11;
  t25 += v3 * b12;
  t26 += v3 * b13;
  t27 += v3 * b14;
  t28 += v3 * b15;
  v3 = a4[14];
  t14 += v3 * b0;
  t15 += v3 * b1;
  t16 += v3 * b22;
  t17 += v3 * b32;
  t18 += v3 * b42;
  t19 += v3 * b5;
  t20 += v3 * b6;
  t21 += v3 * b7;
  t222 += v3 * b8;
  t23 += v3 * b9;
  t24 += v3 * b10;
  t25 += v3 * b11;
  t26 += v3 * b12;
  t27 += v3 * b13;
  t28 += v3 * b14;
  t29 += v3 * b15;
  v3 = a4[15];
  t15 += v3 * b0;
  t16 += v3 * b1;
  t17 += v3 * b22;
  t18 += v3 * b32;
  t19 += v3 * b42;
  t20 += v3 * b5;
  t21 += v3 * b6;
  t222 += v3 * b7;
  t23 += v3 * b8;
  t24 += v3 * b9;
  t25 += v3 * b10;
  t26 += v3 * b11;
  t27 += v3 * b12;
  t28 += v3 * b13;
  t29 += v3 * b14;
  t30 += v3 * b15;
  t0 += 38 * t16;
  t1 += 38 * t17;
  t22 += 38 * t18;
  t32 += 38 * t19;
  t4 += 38 * t20;
  t5 += 38 * t21;
  t6 += 38 * t222;
  t7 += 38 * t23;
  t8 += 38 * t24;
  t9 += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  o3[0] = t0;
  o3[1] = t1;
  o3[2] = t22;
  o3[3] = t32;
  o3[4] = t4;
  o3[5] = t5;
  o3[6] = t6;
  o3[7] = t7;
  o3[8] = t8;
  o3[9] = t9;
  o3[10] = t10;
  o3[11] = t11;
  o3[12] = t12;
  o3[13] = t13;
  o3[14] = t14;
  o3[15] = t15;
}
function S(o3, a4) {
  M(o3, a4, a4);
}
function inv25519(o3, i4) {
  const c4 = gf();
  let a4;
  for (a4 = 0; a4 < 16; a4++)
    c4[a4] = i4[a4];
  for (a4 = 253; a4 >= 0; a4--) {
    S(c4, c4);
    if (a4 !== 2 && a4 !== 4)
      M(c4, c4, i4);
  }
  for (a4 = 0; a4 < 16; a4++)
    o3[a4] = c4[a4];
}
function pow2523(o3, i4) {
  const c4 = gf();
  let a4;
  for (a4 = 0; a4 < 16; a4++)
    c4[a4] = i4[a4];
  for (a4 = 250; a4 >= 0; a4--) {
    S(c4, c4);
    if (a4 !== 1)
      M(c4, c4, i4);
  }
  for (a4 = 0; a4 < 16; a4++)
    o3[a4] = c4[a4];
}
var K = [
  1116352408,
  3609767458,
  1899447441,
  602891725,
  3049323471,
  3964484399,
  3921009573,
  2173295548,
  961987163,
  4081628472,
  1508970993,
  3053834265,
  2453635748,
  2937671579,
  2870763221,
  3664609560,
  3624381080,
  2734883394,
  310598401,
  1164996542,
  607225278,
  1323610764,
  1426881987,
  3590304994,
  1925078388,
  4068182383,
  2162078206,
  991336113,
  2614888103,
  633803317,
  3248222580,
  3479774868,
  3835390401,
  2666613458,
  4022224774,
  944711139,
  264347078,
  2341262773,
  604807628,
  2007800933,
  770255983,
  1495990901,
  1249150122,
  1856431235,
  1555081692,
  3175218132,
  1996064986,
  2198950837,
  2554220882,
  3999719339,
  2821834349,
  766784016,
  2952996808,
  2566594879,
  3210313671,
  3203337956,
  3336571891,
  1034457026,
  3584528711,
  2466948901,
  113926993,
  3758326383,
  338241895,
  168717936,
  666307205,
  1188179964,
  773529912,
  1546045734,
  1294757372,
  1522805485,
  1396182291,
  2643833823,
  1695183700,
  2343527390,
  1986661051,
  1014477480,
  2177026350,
  1206759142,
  2456956037,
  344077627,
  2730485921,
  1290863460,
  2820302411,
  3158454273,
  3259730800,
  3505952657,
  3345764771,
  106217008,
  3516065817,
  3606008344,
  3600352804,
  1432725776,
  4094571909,
  1467031594,
  275423344,
  851169720,
  430227734,
  3100823752,
  506948616,
  1363258195,
  659060556,
  3750685593,
  883997877,
  3785050280,
  958139571,
  3318307427,
  1322822218,
  3812723403,
  1537002063,
  2003034995,
  1747873779,
  3602036899,
  1955562222,
  1575990012,
  2024104815,
  1125592928,
  2227730452,
  2716904306,
  2361852424,
  442776044,
  2428436474,
  593698344,
  2756734187,
  3733110249,
  3204031479,
  2999351573,
  3329325298,
  3815920427,
  3391569614,
  3928383900,
  3515267271,
  566280711,
  3940187606,
  3454069534,
  4118630271,
  4000239992,
  116418474,
  1914138554,
  174292421,
  2731055270,
  289380356,
  3203993006,
  460393269,
  320620315,
  685471733,
  587496836,
  852142971,
  1086792851,
  1017036298,
  365543100,
  1126000580,
  2618297676,
  1288033470,
  3409855158,
  1501505948,
  4234509866,
  1607167915,
  987167468,
  1816402316,
  1246189591
];
function crypto_hashblocks_hl(hh, hl, m4, n2) {
  const wh = new Int32Array(16), wl = new Int32Array(16);
  let bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7, bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7, th, tl, i4, j4, h3, l3, a4, b4, c4, d4;
  let ah0 = hh[0], ah1 = hh[1], ah2 = hh[2], ah3 = hh[3], ah4 = hh[4], ah5 = hh[5], ah6 = hh[6], ah7 = hh[7], al0 = hl[0], al1 = hl[1], al2 = hl[2], al3 = hl[3], al4 = hl[4], al5 = hl[5], al6 = hl[6], al7 = hl[7];
  let pos = 0;
  while (n2 >= 128) {
    for (i4 = 0; i4 < 16; i4++) {
      j4 = 8 * i4 + pos;
      wh[i4] = m4[j4 + 0] << 24 | m4[j4 + 1] << 16 | m4[j4 + 2] << 8 | m4[j4 + 3];
      wl[i4] = m4[j4 + 4] << 24 | m4[j4 + 5] << 16 | m4[j4 + 6] << 8 | m4[j4 + 7];
    }
    for (i4 = 0; i4 < 80; i4++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;
      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;
      h3 = ah7;
      l3 = al7;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = (ah4 >>> 14 | al4 << 32 - 14) ^ (ah4 >>> 18 | al4 << 32 - 18) ^ (al4 >>> 41 - 32 | ah4 << 32 - (41 - 32));
      l3 = (al4 >>> 14 | ah4 << 32 - 14) ^ (al4 >>> 18 | ah4 << 32 - 18) ^ (ah4 >>> 41 - 32 | al4 << 32 - (41 - 32));
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = ah4 & ah5 ^ ~ah4 & ah6;
      l3 = al4 & al5 ^ ~al4 & al6;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = K[i4 * 2];
      l3 = K[i4 * 2 + 1];
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = wh[i4 % 16];
      l3 = wl[i4 % 16];
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      th = c4 & 65535 | d4 << 16;
      tl = a4 & 65535 | b4 << 16;
      h3 = th;
      l3 = tl;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = (ah0 >>> 28 | al0 << 32 - 28) ^ (al0 >>> 34 - 32 | ah0 << 32 - (34 - 32)) ^ (al0 >>> 39 - 32 | ah0 << 32 - (39 - 32));
      l3 = (al0 >>> 28 | ah0 << 32 - 28) ^ (ah0 >>> 34 - 32 | al0 << 32 - (34 - 32)) ^ (ah0 >>> 39 - 32 | al0 << 32 - (39 - 32));
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
      l3 = al0 & al1 ^ al0 & al2 ^ al1 & al2;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      bh7 = c4 & 65535 | d4 << 16;
      bl7 = a4 & 65535 | b4 << 16;
      h3 = bh3;
      l3 = bl3;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = th;
      l3 = tl;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      bh3 = c4 & 65535 | d4 << 16;
      bl3 = a4 & 65535 | b4 << 16;
      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;
      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;
      if (i4 % 16 === 15) {
        for (j4 = 0; j4 < 16; j4++) {
          h3 = wh[j4];
          l3 = wl[j4];
          a4 = l3 & 65535;
          b4 = l3 >>> 16;
          c4 = h3 & 65535;
          d4 = h3 >>> 16;
          h3 = wh[(j4 + 9) % 16];
          l3 = wl[(j4 + 9) % 16];
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          th = wh[(j4 + 1) % 16];
          tl = wl[(j4 + 1) % 16];
          h3 = (th >>> 1 | tl << 32 - 1) ^ (th >>> 8 | tl << 32 - 8) ^ th >>> 7;
          l3 = (tl >>> 1 | th << 32 - 1) ^ (tl >>> 8 | th << 32 - 8) ^ (tl >>> 7 | th << 32 - 7);
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          th = wh[(j4 + 14) % 16];
          tl = wl[(j4 + 14) % 16];
          h3 = (th >>> 19 | tl << 32 - 19) ^ (tl >>> 61 - 32 | th << 32 - (61 - 32)) ^ th >>> 6;
          l3 = (tl >>> 19 | th << 32 - 19) ^ (th >>> 61 - 32 | tl << 32 - (61 - 32)) ^ (tl >>> 6 | th << 32 - 6);
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          b4 += a4 >>> 16;
          c4 += b4 >>> 16;
          d4 += c4 >>> 16;
          wh[j4] = c4 & 65535 | d4 << 16;
          wl[j4] = a4 & 65535 | b4 << 16;
        }
      }
    }
    h3 = ah0;
    l3 = al0;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[0];
    l3 = hl[0];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[0] = ah0 = c4 & 65535 | d4 << 16;
    hl[0] = al0 = a4 & 65535 | b4 << 16;
    h3 = ah1;
    l3 = al1;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[1];
    l3 = hl[1];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[1] = ah1 = c4 & 65535 | d4 << 16;
    hl[1] = al1 = a4 & 65535 | b4 << 16;
    h3 = ah2;
    l3 = al2;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[2];
    l3 = hl[2];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[2] = ah2 = c4 & 65535 | d4 << 16;
    hl[2] = al2 = a4 & 65535 | b4 << 16;
    h3 = ah3;
    l3 = al3;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[3];
    l3 = hl[3];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[3] = ah3 = c4 & 65535 | d4 << 16;
    hl[3] = al3 = a4 & 65535 | b4 << 16;
    h3 = ah4;
    l3 = al4;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[4];
    l3 = hl[4];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[4] = ah4 = c4 & 65535 | d4 << 16;
    hl[4] = al4 = a4 & 65535 | b4 << 16;
    h3 = ah5;
    l3 = al5;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[5];
    l3 = hl[5];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[5] = ah5 = c4 & 65535 | d4 << 16;
    hl[5] = al5 = a4 & 65535 | b4 << 16;
    h3 = ah6;
    l3 = al6;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[6];
    l3 = hl[6];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[6] = ah6 = c4 & 65535 | d4 << 16;
    hl[6] = al6 = a4 & 65535 | b4 << 16;
    h3 = ah7;
    l3 = al7;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[7];
    l3 = hl[7];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[7] = ah7 = c4 & 65535 | d4 << 16;
    hl[7] = al7 = a4 & 65535 | b4 << 16;
    pos += 128;
    n2 -= 128;
  }
  return n2;
}
function crypto_hash(out, m4, n2) {
  const hh = new Int32Array(8);
  const hl = new Int32Array(8);
  const x5 = new Uint8Array(256);
  const b4 = n2;
  hh[0] = 1779033703;
  hh[1] = 3144134277;
  hh[2] = 1013904242;
  hh[3] = 2773480762;
  hh[4] = 1359893119;
  hh[5] = 2600822924;
  hh[6] = 528734635;
  hh[7] = 1541459225;
  hl[0] = 4089235720;
  hl[1] = 2227873595;
  hl[2] = 4271175723;
  hl[3] = 1595750129;
  hl[4] = 2917565137;
  hl[5] = 725511199;
  hl[6] = 4215389547;
  hl[7] = 327033209;
  crypto_hashblocks_hl(hh, hl, m4, n2);
  n2 %= 128;
  for (let i4 = 0; i4 < n2; i4++)
    x5[i4] = m4[b4 - n2 + i4];
  x5[n2] = 128;
  n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
  x5[n2 - 9] = 0;
  ts64(x5, n2 - 8, b4 / 536870912 | 0, b4 << 3);
  crypto_hashblocks_hl(hh, hl, x5, n2);
  for (let i4 = 0; i4 < 8; i4++)
    ts64(out, 8 * i4, hh[i4], hl[i4]);
  return 0;
}
var HashState = class {
  constructor() {
    this.hh = new Int32Array(8);
    this.hl = new Int32Array(8);
    this.next = new Uint8Array(128);
    this.p = 0;
    this.total = 0;
    this.hh[0] = 1779033703;
    this.hh[1] = 3144134277;
    this.hh[2] = 1013904242;
    this.hh[3] = 2773480762;
    this.hh[4] = 1359893119;
    this.hh[5] = 2600822924;
    this.hh[6] = 528734635;
    this.hh[7] = 1541459225;
    this.hl[0] = 4089235720;
    this.hl[1] = 2227873595;
    this.hl[2] = 4271175723;
    this.hl[3] = 1595750129;
    this.hl[4] = 2917565137;
    this.hl[5] = 725511199;
    this.hl[6] = 4215389547;
    this.hl[7] = 327033209;
  }
  update(data) {
    this.total += data.length;
    let i4 = 0;
    while (i4 < data.length) {
      const r3 = 128 - this.p;
      if (r3 > data.length - i4) {
        for (let j4 = 0; i4 + j4 < data.length; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        this.p += data.length - i4;
        break;
      } else {
        for (let j4 = 0; this.p + j4 < 128; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        crypto_hashblocks_hl(this.hh, this.hl, this.next, 128);
        i4 += 128 - this.p;
        this.p = 0;
      }
    }
    return this;
  }
  finish() {
    const out = new Uint8Array(64);
    let n2 = this.p;
    const x5 = new Uint8Array(256);
    const b4 = this.total;
    for (let i4 = 0; i4 < n2; i4++)
      x5[i4] = this.next[i4];
    x5[n2] = 128;
    n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
    x5[n2 - 9] = 0;
    ts64(x5, n2 - 8, b4 / 536870912 | 0, b4 << 3);
    crypto_hashblocks_hl(this.hh, this.hl, x5, n2);
    for (let i4 = 0; i4 < 8; i4++)
      ts64(out, 8 * i4, this.hh[i4], this.hl[i4]);
    return out;
  }
};
function add(p4, q5) {
  const a4 = gf(), b4 = gf(), c4 = gf(), d4 = gf(), e4 = gf(), f3 = gf(), g4 = gf(), h3 = gf(), t4 = gf();
  Z(a4, p4[1], p4[0]);
  Z(t4, q5[1], q5[0]);
  M(a4, a4, t4);
  A(b4, p4[0], p4[1]);
  A(t4, q5[0], q5[1]);
  M(b4, b4, t4);
  M(c4, p4[3], q5[3]);
  M(c4, c4, D2);
  M(d4, p4[2], q5[2]);
  A(d4, d4, d4);
  Z(e4, b4, a4);
  Z(f3, d4, c4);
  A(g4, d4, c4);
  A(h3, b4, a4);
  M(p4[0], e4, f3);
  M(p4[1], h3, g4);
  M(p4[2], g4, f3);
  M(p4[3], e4, h3);
}
function cswap(p4, q5, b4) {
  let i4;
  for (i4 = 0; i4 < 4; i4++) {
    sel25519(p4[i4], q5[i4], b4);
  }
}
function pack(r3, p4) {
  const tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p4[2]);
  M(tx, p4[0], zi);
  M(ty, p4[1], zi);
  pack25519(r3, ty);
  r3[31] ^= par25519(tx) << 7;
}
function scalarmult(p4, q5, s4) {
  let b4, i4;
  set25519(p4[0], gf0);
  set25519(p4[1], gf1);
  set25519(p4[2], gf1);
  set25519(p4[3], gf0);
  for (i4 = 255; i4 >= 0; --i4) {
    b4 = s4[i4 / 8 | 0] >> (i4 & 7) & 1;
    cswap(p4, q5, b4);
    add(q5, p4);
    add(p4, p4);
    cswap(p4, q5, b4);
  }
}
function scalarbase(p4, s4) {
  const q5 = [gf(), gf(), gf(), gf()];
  set25519(q5[0], X);
  set25519(q5[1], Y);
  set25519(q5[2], gf1);
  M(q5[3], X, Y);
  scalarmult(p4, q5, s4);
}
function crypto_sign_keypair(pk, sk, seeded) {
  const d4 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  if (!seeded)
    randombytes(sk, 32);
  crypto_hash(d4, sk, 32);
  d4[0] &= 248;
  d4[31] &= 127;
  d4[31] |= 64;
  scalarbase(p4, d4);
  pack(pk, p4);
  for (let i4 = 0; i4 < 32; i4++)
    sk[i4 + 32] = pk[i4];
  return 0;
}
var L = new Float64Array([
  237,
  211,
  245,
  92,
  26,
  99,
  18,
  88,
  214,
  156,
  247,
  162,
  222,
  249,
  222,
  20,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  16
]);
function modL(r3, x5) {
  let carry, i4, j4, k5;
  for (i4 = 63; i4 >= 32; --i4) {
    carry = 0;
    for (j4 = i4 - 32, k5 = i4 - 12; j4 < k5; ++j4) {
      x5[j4] += carry - 16 * x5[i4] * L[j4 - (i4 - 32)];
      carry = Math.floor((x5[j4] + 128) / 256);
      x5[j4] -= carry * 256;
    }
    x5[j4] += carry;
    x5[i4] = 0;
  }
  carry = 0;
  for (j4 = 0; j4 < 32; j4++) {
    x5[j4] += carry - (x5[31] >> 4) * L[j4];
    carry = x5[j4] >> 8;
    x5[j4] &= 255;
  }
  for (j4 = 0; j4 < 32; j4++)
    x5[j4] -= carry * L[j4];
  for (i4 = 0; i4 < 32; i4++) {
    x5[i4 + 1] += x5[i4] >> 8;
    r3[i4] = x5[i4] & 255;
  }
}
function reduce(r3) {
  const x5 = new Float64Array(64);
  for (let i4 = 0; i4 < 64; i4++)
    x5[i4] = r3[i4];
  for (let i4 = 0; i4 < 64; i4++)
    r3[i4] = 0;
  modL(r3, x5);
}
function crypto_sign(sm, m4, n2, sk) {
  const d4 = new Uint8Array(64), h3 = new Uint8Array(64), r3 = new Uint8Array(64);
  let i4, j4;
  const x5 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  crypto_hash(d4, sk, 32);
  d4[0] &= 248;
  d4[31] &= 127;
  d4[31] |= 64;
  const smlen = n2 + 64;
  for (i4 = 0; i4 < n2; i4++)
    sm[64 + i4] = m4[i4];
  for (i4 = 0; i4 < 32; i4++)
    sm[32 + i4] = d4[32 + i4];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i4 = 32; i4 < 64; i4++)
    sm[i4] = sk[i4];
  crypto_hash(h3, sm, n2 + 64);
  reduce(h3);
  for (i4 = 0; i4 < 64; i4++)
    x5[i4] = 0;
  for (i4 = 0; i4 < 32; i4++)
    x5[i4] = r3[i4];
  for (i4 = 0; i4 < 32; i4++) {
    for (j4 = 0; j4 < 32; j4++) {
      x5[i4 + j4] += h3[i4] * d4[j4];
    }
  }
  modL(sm.subarray(32), x5);
  return smlen;
}
function unpackpos(r3, p4) {
  const q5 = [gf(), gf(), gf(), gf()];
  if (unpackneg(q5, p4))
    return -1;
  const scalar0 = new Uint8Array(32);
  const scalar1 = new Uint8Array(32);
  scalar1[0] = 1;
  const scalarNeg1 = crypto_core_ed25519_scalar_sub(scalar0, scalar1);
  scalarmult(r3, q5, scalarNeg1);
  return 0;
}
function unpackneg(r3, p4) {
  const t4 = gf();
  const chk = gf();
  const num = gf();
  const den = gf();
  const den2 = gf();
  const den4 = gf();
  const den6 = gf();
  set25519(r3[2], gf1);
  unpack25519(r3[1], p4);
  S(num, r3[1]);
  M(den, num, D);
  Z(num, num, r3[2]);
  A(den, r3[2], den);
  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t4, den6, num);
  M(t4, t4, den);
  pow2523(t4, t4);
  M(t4, t4, num);
  M(t4, t4, den);
  M(t4, t4, den);
  M(r3[0], t4, den);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    M(r3[0], r3[0], I);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    return -1;
  if (par25519(r3[0]) === p4[31] >> 7)
    Z(r3[0], gf0, r3[0]);
  M(r3[3], r3[0], r3[1]);
  return 0;
}
function crypto_scalarmult_ed25519_base_noclamp(s4) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  scalarbase(p4, s4);
  pack(r3, p4);
  return r3;
}
function crypto_scalarmult_ed25519_noclamp(s4, q5) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  const ql = [gf(), gf(), gf(), gf()];
  if (unpackpos(ql, q5))
    throw new Error();
  scalarmult(p4, ql, s4);
  pack(r3, p4);
  return r3;
}
function crypto_sign_open(m4, sm, n2, pk) {
  let i4, mlen;
  const t4 = new Uint8Array(32), h3 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()], q5 = [gf(), gf(), gf(), gf()];
  mlen = -1;
  if (n2 < 64)
    return -1;
  if (unpackneg(q5, pk))
    return -1;
  for (i4 = 0; i4 < n2; i4++)
    m4[i4] = sm[i4];
  for (i4 = 0; i4 < 32; i4++)
    m4[i4 + 32] = pk[i4];
  crypto_hash(h3, m4, n2);
  reduce(h3);
  scalarmult(p4, q5, h3);
  scalarbase(q5, sm.subarray(32));
  add(p4, q5);
  pack(t4, p4);
  n2 -= 64;
  if (crypto_verify_32(sm, 0, t4, 0)) {
    for (i4 = 0; i4 < n2; i4++)
      m4[i4] = 0;
    return -1;
  }
  for (i4 = 0; i4 < n2; i4++)
    m4[i4] = sm[i4 + 64];
  mlen = n2;
  return mlen;
}
var crypto_secretbox_KEYBYTES = 32;
var crypto_secretbox_NONCEBYTES = 24;
var crypto_secretbox_ZEROBYTES = 32;
var crypto_secretbox_BOXZEROBYTES = 16;
var crypto_sign_BYTES = 64;
var crypto_sign_PUBLICKEYBYTES = 32;
var crypto_sign_SECRETKEYBYTES = 64;
var crypto_sign_SEEDBYTES = 32;
var crypto_hash_BYTES = 64;
function checkLengths(k5, n2) {
  if (k5.length !== crypto_secretbox_KEYBYTES)
    throw new Error("bad key size");
  if (n2.length !== crypto_secretbox_NONCEBYTES)
    throw new Error("bad nonce size");
}
function checkArrayTypes(...args) {
  for (let i4 = 0; i4 < args.length; i4++) {
    if (!(args[i4] instanceof Uint8Array))
      throw new TypeError("unexpected type, use Uint8Array");
  }
}
function randomBytes(n2) {
  const b4 = new Uint8Array(n2);
  randombytes(b4, n2);
  return b4;
}
function sign(msg, secretKey) {
  checkArrayTypes(msg, secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error("bad secret key size");
  const signedMsg = new Uint8Array(crypto_sign_BYTES + msg.length);
  crypto_sign(signedMsg, msg, msg.length, secretKey);
  return signedMsg;
}
function sign_detached(msg, secretKey) {
  const signedMsg = sign(msg, secretKey);
  const sig = new Uint8Array(crypto_sign_BYTES);
  for (let i4 = 0; i4 < sig.length; i4++)
    sig[i4] = signedMsg[i4];
  return sig;
}
function crypto_sign_keyPair_fromSeed(seed) {
  checkArrayTypes(seed);
  if (seed.length !== crypto_sign_SEEDBYTES)
    throw new Error(`bad seed size: ${seed.length}`);
  const pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  const sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  for (let i4 = 0; i4 < 32; i4++)
    sk[i4] = seed[i4];
  crypto_sign_keypair(pk, sk, true);
  return { publicKey: pk, secretKey: sk };
}
function hash(msg) {
  checkArrayTypes(msg);
  const h3 = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h3, msg, msg.length);
  return h3;
}
function setPRNG(fn2) {
  randombytes = fn2;
}
function secretbox(msg, nonce, key) {
  checkArrayTypes(msg, nonce, key);
  checkLengths(key, nonce);
  var m4 = new Uint8Array(crypto_secretbox_ZEROBYTES + msg.length);
  var c4 = new Uint8Array(m4.length);
  for (var i4 = 0; i4 < msg.length; i4++)
    m4[i4 + crypto_secretbox_ZEROBYTES] = msg[i4];
  crypto_secretbox(c4, m4, m4.length, nonce, key);
  return c4.subarray(crypto_secretbox_BOXZEROBYTES);
}
function crypto_core_ed25519_scalar_reduce(x5) {
  const len = x5.length;
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < len; i4++)
    z5[i4] = x5[i4];
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_core_ed25519_scalar_sub(x5, y4) {
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < 32; i4++) {
    z5[i4] = x5[i4] - y4[i4];
  }
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_edx25519_private_key_create() {
  const seed = new Uint8Array(32);
  randombytes(seed, 32);
  return crypto_edx25519_private_key_create_from_seed(seed);
}
function crypto_edx25519_private_key_create_from_seed(seed) {
  const pk = hash(seed);
  pk[0] &= 248;
  pk[31] &= 127;
  pk[31] |= 64;
  return pk;
}
function crypto_edx25519_get_public(priv) {
  return crypto_scalarmult_ed25519_base_noclamp(priv.subarray(0, 32));
}
function crypto_edx25519_sign_detached(m4, skx, pkx) {
  const n2 = m4.length;
  const h3 = new Uint8Array(64);
  const r3 = new Uint8Array(64);
  let i4, j4;
  const x5 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  const sm = new Uint8Array(n2 + 64);
  for (i4 = 0; i4 < n2; i4++)
    sm[64 + i4] = m4[i4];
  for (i4 = 0; i4 < 32; i4++)
    sm[32 + i4] = skx[32 + i4];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i4 = 32; i4 < 64; i4++)
    sm[i4] = pkx[i4 - 32];
  crypto_hash(h3, sm, n2 + 64);
  reduce(h3);
  for (i4 = 0; i4 < 64; i4++)
    x5[i4] = 0;
  for (i4 = 0; i4 < 32; i4++)
    x5[i4] = r3[i4];
  for (i4 = 0; i4 < 32; i4++) {
    for (j4 = 0; j4 < 32; j4++) {
      x5[i4 + j4] += h3[i4] * skx[j4];
    }
  }
  modL(sm.subarray(32), x5);
  return sm.subarray(0, 64);
}
function crypto_edx25519_sign_detached_verify(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error("bad signature size");
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error("bad public key size");
  const sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  const m4 = new Uint8Array(crypto_sign_BYTES + msg.length);
  let i4;
  for (i4 = 0; i4 < crypto_sign_BYTES; i4++)
    sm[i4] = sig[i4];
  for (i4 = 0; i4 < msg.length; i4++)
    sm[i4 + crypto_sign_BYTES] = msg[i4];
  return crypto_sign_open(m4, sm, sm.length, publicKey) >= 0;
}

// ../taler-util/lib/prng-browser.js
function loadBrowserPrng() {
  const cr = typeof self !== "undefined" ? self.crypto || self.msCrypto : null;
  const QUOTA = 65536;
  setPRNG(function(x5, n2) {
    let i4;
    const v3 = new Uint8Array(n2);
    for (i4 = 0; i4 < n2; i4 += QUOTA) {
      cr.getRandomValues(v3.subarray(i4, i4 + Math.min(n2 - i4, QUOTA)));
    }
    for (i4 = 0; i4 < n2; i4++)
      x5[i4] = v3[i4];
    for (i4 = 0; i4 < v3.length; i4++)
      v3[i4] = 0;
  });
}

// ../taler-util/lib/punycode.js
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = "-";
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/;
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
var errors = {
  overflow: "Overflow: input needs wider integers to process",
  "not-basic": "Illegal input >= 0x80 (not a basic code point)",
  "invalid-input": "Invalid input"
};
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;
function error(type) {
  throw new RangeError(errors[type]);
}
function map(array, fn2) {
  const result = [];
  let length = array.length;
  while (length--) {
    result[length] = fn2(array[length]);
  }
  return result;
}
function mapDomain(string, fn2) {
  const parts = string.split("@");
  let result = "";
  if (parts.length > 1) {
    result = parts[0] + "@";
    string = parts[1];
  }
  string = string.replace(regexSeparators, ".");
  const labels = string.split(".");
  const encoded = map(labels, fn2).join(".");
  return result + encoded;
}
function ucs2decode(string) {
  const output = [];
  let counter2 = 0;
  const length = string.length;
  while (counter2 < length) {
    const value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      const extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
var ucs2encode = (array) => String.fromCodePoint(...array);
var basicToDigit = function(codePoint) {
  if (codePoint - 48 < 10) {
    return codePoint - 22;
  }
  if (codePoint - 65 < 26) {
    return codePoint - 65;
  }
  if (codePoint - 97 < 26) {
    return codePoint - 97;
  }
  return base;
};
var digitToBasic = function(digit, flag) {
  return digit + 22 + 75 * Number(digit < 26) - (Number(flag != 0) << 5);
};
var adapt = function(delta, numPoints, firstTime) {
  let k5 = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (
    ;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1;
    k5 += base
  ) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k5 + (baseMinusTMin + 1) * delta / (delta + skew));
};
var decode = function(input) {
  const output = [];
  const inputLength = input.length;
  let i4 = 0;
  let n2 = initialN;
  let bias = initialBias;
  let basic = input.lastIndexOf(delimiter);
  if (basic < 0) {
    basic = 0;
  }
  for (let j4 = 0; j4 < basic; ++j4) {
    if (input.charCodeAt(j4) >= 128) {
      error("not-basic");
    }
    output.push(input.charCodeAt(j4));
  }
  for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
    let oldi = i4;
    for (let w5 = 1, k5 = base; ; k5 += base) {
      if (index >= inputLength) {
        error("invalid-input");
      }
      const digit = basicToDigit(input.charCodeAt(index++));
      if (digit >= base || digit > floor((maxInt - i4) / w5)) {
        error("overflow");
      }
      i4 += digit * w5;
      const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
      if (digit < t4) {
        break;
      }
      const baseMinusT = base - t4;
      if (w5 > floor(maxInt / baseMinusT)) {
        error("overflow");
      }
      w5 *= baseMinusT;
    }
    const out = output.length + 1;
    bias = adapt(i4 - oldi, out, oldi == 0);
    if (floor(i4 / out) > maxInt - n2) {
      error("overflow");
    }
    n2 += floor(i4 / out);
    i4 %= out;
    output.splice(i4++, 0, n2);
  }
  return String.fromCodePoint(...output);
};
var encode = function(inputArg) {
  const output = [];
  let input = ucs2decode(inputArg);
  let inputLength = input.length;
  let n2 = initialN;
  let delta = 0;
  let bias = initialBias;
  for (const currentValue of input) {
    if (currentValue < 128) {
      output.push(stringFromCharCode(currentValue));
    }
  }
  let basicLength = output.length;
  let handledCPCount = basicLength;
  if (basicLength) {
    output.push(delimiter);
  }
  while (handledCPCount < inputLength) {
    let m4 = maxInt;
    for (const currentValue of input) {
      if (currentValue >= n2 && currentValue < m4) {
        m4 = currentValue;
      }
    }
    const handledCPCountPlusOne = handledCPCount + 1;
    if (m4 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
      error("overflow");
    }
    delta += (m4 - n2) * handledCPCountPlusOne;
    n2 = m4;
    for (const currentValue of input) {
      if (currentValue < n2 && ++delta > maxInt) {
        error("overflow");
      }
      if (currentValue == n2) {
        let q5 = delta;
        for (let k5 = base; ; k5 += base) {
          const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
          if (q5 < t4) {
            break;
          }
          const qMinusT = q5 - t4;
          const baseMinusT = base - t4;
          output.push(stringFromCharCode(digitToBasic(t4 + qMinusT % baseMinusT, 0)));
          q5 = floor(qMinusT / baseMinusT);
        }
        output.push(stringFromCharCode(digitToBasic(q5, 0)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }
    ++delta;
    ++n2;
  }
  return output.join("");
};
var toUnicode = function(input) {
  return mapDomain(input, function(string) {
    return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
  });
};
var toASCII = function(input) {
  return mapDomain(input, function(string) {
    return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
  });
};
var punycode = {
  /**
   * A string representing the current Punycode.js version number.
   * @memberOf punycode
   * @type String
   */
  version: "2.1.0",
  /**
   * An object of methods to convert from JavaScript's internal character
   * representation (UCS-2) to Unicode code points, and back.
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode
   * @type Object
   */
  ucs2: {
    decode: ucs2decode,
    encode: ucs2encode
  },
  decode,
  encode,
  toASCII,
  toUnicode
};

// ../taler-util/lib/whatwg-url.js
var utf8Encoder = new TextEncoder();
var utf8Decoder = new TextDecoder("utf-8", { ignoreBOM: true });
function utf8Encode(string) {
  return utf8Encoder.encode(string);
}
function utf8DecodeWithoutBOM(bytes) {
  return utf8Decoder.decode(bytes);
}
function parseUrlencoded(input) {
  const sequences = strictlySplitByteSequence(input, p("&"));
  const output = [];
  for (const bytes of sequences) {
    if (bytes.length === 0) {
      continue;
    }
    let name, value;
    const indexOfEqual = bytes.indexOf(p("="));
    if (indexOfEqual >= 0) {
      name = bytes.slice(0, indexOfEqual);
      value = bytes.slice(indexOfEqual + 1);
    } else {
      name = bytes;
      value = new Uint8Array(0);
    }
    name = replaceByteInByteSequence(name, 43, 32);
    value = replaceByteInByteSequence(value, 43, 32);
    const nameString = utf8DecodeWithoutBOM(percentDecodeBytes(name));
    const valueString = utf8DecodeWithoutBOM(percentDecodeBytes(value));
    output.push([nameString, valueString]);
  }
  return output;
}
function parseUrlencodedString(input) {
  return parseUrlencoded(utf8Encode(input));
}
function serializeUrlencoded(tuples, encodingOverride = void 0) {
  let encoding = "utf-8";
  if (encodingOverride !== void 0) {
    encoding = encodingOverride;
  }
  let output = "";
  for (const [i4, tuple] of tuples.entries()) {
    const name = utf8PercentEncodeString(tuple[0], isURLEncodedPercentEncode, true);
    let value = tuple[1];
    if (tuple.length > 2 && tuple[2] !== void 0) {
      if (tuple[2] === "hidden" && name === "_charset_") {
        value = encoding;
      } else if (tuple[2] === "file") {
        value = value.name;
      }
    }
    value = utf8PercentEncodeString(value, isURLEncodedPercentEncode, true);
    if (i4 !== 0) {
      output += "&";
    }
    output += `${name}=${value}`;
  }
  return output;
}
function strictlySplitByteSequence(buf, cp) {
  const list = [];
  let last = 0;
  let i4 = buf.indexOf(cp);
  while (i4 >= 0) {
    list.push(buf.slice(last, i4));
    last = i4 + 1;
    i4 = buf.indexOf(cp, last);
  }
  if (last !== buf.length) {
    list.push(buf.slice(last));
  }
  return list;
}
function replaceByteInByteSequence(buf, from, to) {
  let i4 = buf.indexOf(from);
  while (i4 >= 0) {
    buf[i4] = to;
    i4 = buf.indexOf(from, i4 + 1);
  }
  return buf;
}
function p(char) {
  return char.codePointAt(0);
}
function percentEncode(c4) {
  let hex = c4.toString(16).toUpperCase();
  if (hex.length === 1) {
    hex = `0${hex}`;
  }
  return `%${hex}`;
}
function percentDecodeBytes(input) {
  const output = new Uint8Array(input.byteLength);
  let outputIndex = 0;
  for (let i4 = 0; i4 < input.byteLength; ++i4) {
    const byte = input[i4];
    if (byte !== 37) {
      output[outputIndex++] = byte;
    } else if (byte === 37 && (!isASCIIHex(input[i4 + 1]) || !isASCIIHex(input[i4 + 2]))) {
      output[outputIndex++] = byte;
    } else {
      const bytePoint = parseInt(String.fromCodePoint(input[i4 + 1], input[i4 + 2]), 16);
      output[outputIndex++] = bytePoint;
      i4 += 2;
    }
  }
  return output.slice(0, outputIndex);
}
function percentDecodeString(input) {
  const bytes = utf8Encode(input);
  return percentDecodeBytes(bytes);
}
function isC0ControlPercentEncode(c4) {
  return c4 <= 31 || c4 > 126;
}
var extraFragmentPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("<"),
  p(">"),
  p("`")
]);
function isFragmentPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraFragmentPercentEncodeSet.has(c4);
}
var extraQueryPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("#"),
  p("<"),
  p(">")
]);
function isQueryPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraQueryPercentEncodeSet.has(c4);
}
function isSpecialQueryPercentEncode(c4) {
  return isQueryPercentEncode(c4) || c4 === p("'");
}
var extraPathPercentEncodeSet = /* @__PURE__ */ new Set([p("?"), p("`"), p("{"), p("}")]);
function isPathPercentEncode(c4) {
  return isQueryPercentEncode(c4) || extraPathPercentEncodeSet.has(c4);
}
var extraUserinfoPercentEncodeSet = /* @__PURE__ */ new Set([
  p("/"),
  p(":"),
  p(";"),
  p("="),
  p("@"),
  p("["),
  p("\\"),
  p("]"),
  p("^"),
  p("|")
]);
function isUserinfoPercentEncode(c4) {
  return isPathPercentEncode(c4) || extraUserinfoPercentEncodeSet.has(c4);
}
var extraComponentPercentEncodeSet = /* @__PURE__ */ new Set([
  p("$"),
  p("%"),
  p("&"),
  p("+"),
  p(",")
]);
function isComponentPercentEncode(c4) {
  return isUserinfoPercentEncode(c4) || extraComponentPercentEncodeSet.has(c4);
}
var extraURLEncodedPercentEncodeSet = /* @__PURE__ */ new Set([
  p("!"),
  p("'"),
  p("("),
  p(")"),
  p("~")
]);
function isURLEncodedPercentEncode(c4) {
  return isComponentPercentEncode(c4) || extraURLEncodedPercentEncodeSet.has(c4);
}
function utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate) {
  const bytes = utf8Encode(codePoint);
  let output = "";
  for (const byte of bytes) {
    if (!percentEncodePredicate(byte)) {
      output += String.fromCharCode(byte);
    } else {
      output += percentEncode(byte);
    }
  }
  return output;
}
function utf8PercentEncodeCodePoint(codePoint, percentEncodePredicate) {
  return utf8PercentEncodeCodePointInternal(String.fromCodePoint(codePoint), percentEncodePredicate);
}
function utf8PercentEncodeString(input, percentEncodePredicate, spaceAsPlus = false) {
  let output = "";
  for (const codePoint of input) {
    if (spaceAsPlus && codePoint === " ") {
      output += "+";
    } else {
      output += utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate);
    }
  }
  return output;
}
function isASCIIDigit(c4) {
  return c4 >= 48 && c4 <= 57;
}
function isASCIIAlpha(c4) {
  return c4 >= 65 && c4 <= 90 || c4 >= 97 && c4 <= 122;
}
function isASCIIAlphanumeric(c4) {
  return isASCIIAlpha(c4) || isASCIIDigit(c4);
}
function isASCIIHex(c4) {
  return isASCIIDigit(c4) || c4 >= 65 && c4 <= 70 || c4 >= 97 && c4 <= 102;
}
var URLSearchParamsImpl = class {
  constructor(init, { doNotStripQMark = false } = {}) {
    this._list = [];
    this._url = null;
    if (!doNotStripQMark && typeof init === "string" && init[0] === "?") {
      init = init.slice(1);
    }
    if (Array.isArray(init)) {
      for (const pair of init) {
        if (pair.length !== 2) {
          throw new TypeError("Failed to construct 'URLSearchParams': parameter 1 sequence's element does not contain exactly two elements.");
        }
        this._list.push([pair[0], pair[1]]);
      }
    } else if (typeof init === "object" && Object.getPrototypeOf(init) === null) {
      for (const name of Object.keys(init)) {
        const value = init[name];
        this._list.push([name, value]);
      }
    } else {
      this._list = parseUrlencodedString(init);
    }
  }
  _updateSteps() {
    if (this._url !== null) {
      let query = serializeUrlencoded(this._list);
      if (query === "") {
        query = null;
      }
      this._url._url.query = query;
    }
  }
  append(name, value) {
    this._list.push([name, value]);
    this._updateSteps();
  }
  delete(name) {
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        this._list.splice(i4, 1);
      } else {
        i4++;
      }
    }
    this._updateSteps();
  }
  get(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return tuple[1];
      }
    }
    return null;
  }
  getAll(name) {
    const output = [];
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        output.push(tuple[1]);
      }
    }
    return output;
  }
  entries() {
    return [...this._list.map((x5) => [x5[0], x5[1]])];
  }
  forEach(callbackfn, thisArg) {
    for (const tuple of this._list) {
      callbackfn.call(thisArg, tuple[1], tuple[0], this);
    }
  }
  has(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return true;
      }
    }
    return false;
  }
  set(name, value) {
    let found = false;
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        if (found) {
          this._list.splice(i4, 1);
        } else {
          found = true;
          this._list[i4][1] = value;
          i4++;
        }
      } else {
        i4++;
      }
    }
    if (!found) {
      this._list.push([name, value]);
    }
    this._updateSteps();
  }
  sort() {
    this._list.sort((a4, b4) => {
      if (a4[0] < b4[0]) {
        return -1;
      }
      if (a4[0] > b4[0]) {
        return 1;
      }
      return 0;
    });
    this._updateSteps();
  }
  [Symbol.iterator]() {
    return this._list[Symbol.iterator]();
  }
  toString() {
    return serializeUrlencoded(this._list);
  }
};
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};
var failure = Symbol("failure");
function countSymbols(str) {
  return [...str].length;
}
function at(input, idx) {
  const c4 = input[idx];
  return isNaN(c4) ? void 0 : String.fromCodePoint(c4);
}
function isSingleDot(buffer) {
  return buffer === "." || buffer.toLowerCase() === "%2e";
}
function isDoubleDot(buffer) {
  buffer = buffer.toLowerCase();
  return buffer === ".." || buffer === "%2e." || buffer === ".%2e" || buffer === "%2e%2e";
}
function isWindowsDriveLetterCodePoints(cp1, cp2) {
  return isASCIIAlpha(cp1) && (cp2 === p(":") || cp2 === p("|"));
}
function isWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && (string[1] === ":" || string[1] === "|");
}
function isNormalizedWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && string[1] === ":";
}
function containsForbiddenHostCodePoint(string) {
  return string.search(/\u0000|\u0009|\u000A|\u000D|\u0020|#|\/|:|<|>|\?|@|\[|\\|\]|\^|\|/u) !== -1;
}
function containsForbiddenDomainCodePoint(string) {
  return containsForbiddenHostCodePoint(string) || string.search(/[\u0000-\u001F]|%|\u007F/u) !== -1;
}
function isSpecialScheme(scheme) {
  return specialSchemes[scheme] !== void 0;
}
function isSpecial(url) {
  return isSpecialScheme(url.scheme);
}
function isNotSpecial(url) {
  return !isSpecialScheme(url.scheme);
}
function defaultPort(scheme) {
  return specialSchemes[scheme];
}
function parseIPv4Number(input) {
  if (input === "") {
    return failure;
  }
  let R3 = 10;
  if (input.length >= 2 && input.charAt(0) === "0" && input.charAt(1).toLowerCase() === "x") {
    input = input.substring(2);
    R3 = 16;
  } else if (input.length >= 2 && input.charAt(0) === "0") {
    input = input.substring(1);
    R3 = 8;
  }
  if (input === "") {
    return 0;
  }
  let regex = /[^0-7]/u;
  if (R3 === 10) {
    regex = /[^0-9]/u;
  }
  if (R3 === 16) {
    regex = /[^0-9A-Fa-f]/u;
  }
  if (regex.test(input)) {
    return failure;
  }
  return parseInt(input, R3);
}
function parseIPv4(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length > 1) {
      parts.pop();
    }
  }
  if (parts.length > 4) {
    return failure;
  }
  const numbers = [];
  for (const part of parts) {
    const n2 = parseIPv4Number(part);
    if (n2 === failure) {
      return failure;
    }
    numbers.push(n2);
  }
  for (let i4 = 0; i4 < numbers.length - 1; ++i4) {
    if (numbers[i4] > 255) {
      return failure;
    }
  }
  if (numbers[numbers.length - 1] >= 256 ** (5 - numbers.length)) {
    return failure;
  }
  let ipv4 = numbers.pop();
  let counter2 = 0;
  for (const n2 of numbers) {
    ipv4 += n2 * 256 ** (3 - counter2);
    ++counter2;
  }
  return ipv4;
}
function serializeIPv4(address) {
  let output = "";
  let n2 = address;
  for (let i4 = 1; i4 <= 4; ++i4) {
    output = String(n2 % 256) + output;
    if (i4 !== 4) {
      output = `.${output}`;
    }
    n2 = Math.floor(n2 / 256);
  }
  return output;
}
function parseIPv6(inputArg) {
  const address = [0, 0, 0, 0, 0, 0, 0, 0];
  let pieceIndex = 0;
  let compress3 = null;
  let pointer = 0;
  const input = Array.from(inputArg, (c4) => c4.codePointAt(0));
  if (input[pointer] === p(":")) {
    if (input[pointer + 1] !== p(":")) {
      return failure;
    }
    pointer += 2;
    ++pieceIndex;
    compress3 = pieceIndex;
  }
  while (pointer < input.length) {
    if (pieceIndex === 8) {
      return failure;
    }
    if (input[pointer] === p(":")) {
      if (compress3 !== null) {
        return failure;
      }
      ++pointer;
      ++pieceIndex;
      compress3 = pieceIndex;
      continue;
    }
    let value = 0;
    let length = 0;
    while (length < 4 && isASCIIHex(input[pointer])) {
      value = value * 16 + parseInt(at(input, pointer), 16);
      ++pointer;
      ++length;
    }
    if (input[pointer] === p(".")) {
      if (length === 0) {
        return failure;
      }
      pointer -= length;
      if (pieceIndex > 6) {
        return failure;
      }
      let numbersSeen = 0;
      while (input[pointer] !== void 0) {
        let ipv4Piece = null;
        if (numbersSeen > 0) {
          if (input[pointer] === p(".") && numbersSeen < 4) {
            ++pointer;
          } else {
            return failure;
          }
        }
        if (!isASCIIDigit(input[pointer])) {
          return failure;
        }
        while (isASCIIDigit(input[pointer])) {
          const number = parseInt(at(input, pointer));
          if (ipv4Piece === null) {
            ipv4Piece = number;
          } else if (ipv4Piece === 0) {
            return failure;
          } else {
            ipv4Piece = ipv4Piece * 10 + number;
          }
          if (ipv4Piece > 255) {
            return failure;
          }
          ++pointer;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        ++numbersSeen;
        if (numbersSeen === 2 || numbersSeen === 4) {
          ++pieceIndex;
        }
      }
      if (numbersSeen !== 4) {
        return failure;
      }
      break;
    } else if (input[pointer] === p(":")) {
      ++pointer;
      if (input[pointer] === void 0) {
        return failure;
      }
    } else if (input[pointer] !== void 0) {
      return failure;
    }
    address[pieceIndex] = value;
    ++pieceIndex;
  }
  if (compress3 !== null) {
    let swaps = pieceIndex - compress3;
    pieceIndex = 7;
    while (pieceIndex !== 0 && swaps > 0) {
      const temp = address[compress3 + swaps - 1];
      address[compress3 + swaps - 1] = address[pieceIndex];
      address[pieceIndex] = temp;
      --pieceIndex;
      --swaps;
    }
  } else if (compress3 === null && pieceIndex !== 8) {
    return failure;
  }
  return address;
}
function serializeIPv6(address) {
  let output = "";
  const compress3 = findLongestZeroSequence(address);
  let ignore0 = false;
  for (let pieceIndex = 0; pieceIndex <= 7; ++pieceIndex) {
    if (ignore0 && address[pieceIndex] === 0) {
      continue;
    } else if (ignore0) {
      ignore0 = false;
    }
    if (compress3 === pieceIndex) {
      const separator = pieceIndex === 0 ? "::" : ":";
      output += separator;
      ignore0 = true;
      continue;
    }
    output += address[pieceIndex].toString(16);
    if (pieceIndex !== 7) {
      output += ":";
    }
  }
  return output;
}
function parseHost(input, isNotSpecialArg = false) {
  if (input[0] === "[") {
    if (input[input.length - 1] !== "]") {
      return failure;
    }
    return parseIPv6(input.substring(1, input.length - 1));
  }
  if (isNotSpecialArg) {
    return parseOpaqueHost(input);
  }
  const domain = utf8DecodeWithoutBOM(percentDecodeString(input));
  const asciiDomain = domainToASCII(domain);
  if (asciiDomain === failure) {
    return failure;
  }
  if (containsForbiddenDomainCodePoint(asciiDomain)) {
    return failure;
  }
  if (endsInANumber(asciiDomain)) {
    return parseIPv4(asciiDomain);
  }
  return asciiDomain;
}
function endsInANumber(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length === 1) {
      return false;
    }
    parts.pop();
  }
  const last = parts[parts.length - 1];
  if (parseIPv4Number(last) !== failure) {
    return true;
  }
  if (/^[0-9]+$/u.test(last)) {
    return true;
  }
  return false;
}
function parseOpaqueHost(input) {
  if (containsForbiddenHostCodePoint(input)) {
    return failure;
  }
  return utf8PercentEncodeString(input, isC0ControlPercentEncode);
}
function findLongestZeroSequence(arr) {
  let maxIdx = null;
  let maxLen = 1;
  let currStart = null;
  let currLen = 0;
  for (let i4 = 0; i4 < arr.length; ++i4) {
    if (arr[i4] !== 0) {
      if (currLen > maxLen) {
        maxIdx = currStart;
        maxLen = currLen;
      }
      currStart = null;
      currLen = 0;
    } else {
      if (currStart === null) {
        currStart = i4;
      }
      ++currLen;
    }
  }
  if (currLen > maxLen) {
    return currStart;
  }
  return maxIdx;
}
function serializeHost(host) {
  if (typeof host === "number") {
    return serializeIPv4(host);
  }
  if (host instanceof Array) {
    return `[${serializeIPv6(host)}]`;
  }
  return host;
}
function domainToASCII(domain, beStrict = false) {
  let result;
  try {
    result = punycode.toASCII(domain);
  } catch (e4) {
    return failure;
  }
  if (result === null || result === "") {
    return failure;
  }
  return result;
}
function trimControlChars(url) {
  return url.replace(/^[\u0000-\u001F\u0020]+|[\u0000-\u001F\u0020]+$/gu, "");
}
function trimTabAndNewline(url) {
  return url.replace(/\u0009|\u000A|\u000D/gu, "");
}
function shortenPath(url) {
  const { path } = url;
  if (path.length === 0) {
    return;
  }
  if (url.scheme === "file" && path.length === 1 && isNormalizedWindowsDriveLetter(path[0])) {
    return;
  }
  path.pop();
}
function includesCredentials(url) {
  return url.username !== "" || url.password !== "";
}
function cannotHaveAUsernamePasswordPort(url) {
  return url.host === null || url.host === "" || url.scheme === "file";
}
function hasAnOpaquePath(url) {
  return typeof url.path === "string";
}
function isNormalizedWindowsDriveLetter(string) {
  return /^[A-Za-z]:$/u.test(string);
}
var URLStateMachine = class {
  constructor(input, base2, encodingOverride, url, stateOverride) {
    this.table = {
      "parse scheme start": this.parseSchemeStart,
      "parse scheme": this.parseScheme,
      "parse no scheme": this.parseNoScheme,
      "parse special relative or authority": this.parseSpecialRelativeOrAuthority,
      "parse path or authority": this.parsePathOrAuthority,
      "parse relative": this.parseRelative,
      "parse relative slash": this.parseRelativeSlash,
      "parse special authority slashes": this.parseSpecialAuthoritySlashes,
      "parse special authority ignore slashes": this.parseSpecialAuthorityIgnoreSlashes,
      "parse authority": this.parseAuthority,
      "parse host": this.parseHostName,
      "parse hostname": this.parseHostName,
      "parse port": this.parsePort,
      "parse file": this.parseFile,
      "parse file slash": this.parseFileSlash,
      "parse file host": this.parseFileHost,
      "parse path start": this.parsePathStart,
      "parse path": this.parsePath,
      "parse opaque path": this.parseOpaquePath,
      "parse query": this.parseQuery,
      "parse fragment": this.parseFragment
    };
    this.pointer = 0;
    this.base = base2 || null;
    this.encodingOverride = encodingOverride || "utf-8";
    this.url = url;
    this.failure = false;
    this.parseError = false;
    if (!this.url) {
      this.url = {
        scheme: "",
        username: "",
        password: "",
        host: null,
        port: null,
        path: [],
        query: null,
        fragment: null
      };
      const res2 = trimControlChars(input);
      if (res2 !== input) {
        this.parseError = true;
      }
      input = res2;
    }
    const res = trimTabAndNewline(input);
    if (res !== input) {
      this.parseError = true;
    }
    input = res;
    this.state = stateOverride || "scheme start";
    this.buffer = "";
    this.atFlag = false;
    this.arrFlag = false;
    this.passwordTokenSeenFlag = false;
    this.input = Array.from(input, (c4) => c4.codePointAt(0));
    for (; this.pointer <= this.input.length; ++this.pointer) {
      const c4 = this.input[this.pointer];
      const cStr = isNaN(c4) ? void 0 : String.fromCodePoint(c4);
      const ret = this.table[`parse ${this.state}`].call(this, c4, cStr);
      if (!ret) {
        break;
      } else if (ret === failure) {
        this.failure = true;
        break;
      }
    }
  }
  parseSchemeStart(c4, cStr) {
    if (isASCIIAlpha(c4)) {
      this.buffer += cStr.toLowerCase();
      this.state = "scheme";
    } else if (!this.stateOverride) {
      this.state = "no scheme";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseScheme(c4, cStr) {
    if (isASCIIAlphanumeric(c4) || c4 === p("+") || c4 === p("-") || c4 === p(".")) {
      this.buffer += cStr.toLowerCase();
    } else if (c4 === p(":")) {
      if (this.stateOverride) {
        if (isSpecial(this.url) && !isSpecialScheme(this.buffer)) {
          return false;
        }
        if (!isSpecial(this.url) && isSpecialScheme(this.buffer)) {
          return false;
        }
        if ((includesCredentials(this.url) || this.url.port !== null) && this.buffer === "file") {
          return false;
        }
        if (this.url.scheme === "file" && this.url.host === "") {
          return false;
        }
      }
      this.url.scheme = this.buffer;
      if (this.stateOverride) {
        if (this.url.port === defaultPort(this.url.scheme)) {
          this.url.port = null;
        }
        return false;
      }
      this.buffer = "";
      if (this.url.scheme === "file") {
        if (this.input[this.pointer + 1] !== p("/") || this.input[this.pointer + 2] !== p("/")) {
          this.parseError = true;
        }
        this.state = "file";
      } else if (isSpecial(this.url) && this.base !== null && this.base.scheme === this.url.scheme) {
        this.state = "special relative or authority";
      } else if (isSpecial(this.url)) {
        this.state = "special authority slashes";
      } else if (this.input[this.pointer + 1] === p("/")) {
        this.state = "path or authority";
        ++this.pointer;
      } else {
        this.url.path = [""];
        this.state = "opaque path";
      }
    } else if (!this.stateOverride) {
      this.buffer = "";
      this.state = "no scheme";
      this.pointer = -1;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseNoScheme(c4) {
    if (this.base === null || hasAnOpaquePath(this.base) && c4 !== p("#")) {
      return failure;
    } else if (hasAnOpaquePath(this.base) && c4 === p("#")) {
      this.url.scheme = this.base.scheme;
      this.url.path = this.base.path;
      this.url.query = this.base.query;
      this.url.fragment = "";
      this.state = "fragment";
    } else if (this.base.scheme === "file") {
      this.state = "file";
      --this.pointer;
    } else {
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parseSpecialRelativeOrAuthority(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parsePathOrAuthority(c4) {
    if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseRelative(c4) {
    this.url.scheme = this.base.scheme;
    if (c4 === p("/")) {
      this.state = "relative slash";
    } else if (isSpecial(this.url) && c4 === p("\\")) {
      this.parseError = true;
      this.state = "relative slash";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        this.url.path.pop();
        this.state = "path";
        --this.pointer;
      }
    }
    return true;
  }
  parseRelativeSlash(c4) {
    if (isSpecial(this.url) && (c4 === p("/") || c4 === p("\\"))) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "special authority ignore slashes";
    } else if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthoritySlashes(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "special authority ignore slashes";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthorityIgnoreSlashes(c4) {
    if (c4 !== p("/") && c4 !== p("\\")) {
      this.state = "authority";
      --this.pointer;
    } else {
      this.parseError = true;
    }
    return true;
  }
  parseAuthority(c4, cStr) {
    if (c4 === p("@")) {
      this.parseError = true;
      if (this.atFlag) {
        this.buffer = `%40${this.buffer}`;
      }
      this.atFlag = true;
      const len = countSymbols(this.buffer);
      for (let pointer = 0; pointer < len; ++pointer) {
        const codePoint = this.buffer.codePointAt(pointer);
        if (codePoint === p(":") && !this.passwordTokenSeenFlag) {
          this.passwordTokenSeenFlag = true;
          continue;
        }
        const encodedCodePoints = utf8PercentEncodeCodePoint(codePoint, isUserinfoPercentEncode);
        if (this.passwordTokenSeenFlag) {
          this.url.password += encodedCodePoints;
        } else {
          this.url.username += encodedCodePoints;
        }
      }
      this.buffer = "";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      if (this.atFlag && this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      this.pointer -= countSymbols(this.buffer) + 1;
      this.buffer = "";
      this.state = "host";
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parseHostName(c4, cStr) {
    if (this.stateOverride && this.url.scheme === "file") {
      --this.pointer;
      this.state = "file host";
    } else if (c4 === p(":") && !this.arrFlag) {
      if (this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      if (this.stateOverride === "hostname") {
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "port";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      --this.pointer;
      if (isSpecial(this.url) && this.buffer === "") {
        this.parseError = true;
        return failure;
      } else if (this.stateOverride && this.buffer === "" && (includesCredentials(this.url) || this.url.port !== null)) {
        this.parseError = true;
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "path start";
      if (this.stateOverride) {
        return false;
      }
    } else {
      if (c4 === p("[")) {
        this.arrFlag = true;
      } else if (c4 === p("]")) {
        this.arrFlag = false;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parsePort(c4, cStr) {
    if (isASCIIDigit(c4)) {
      this.buffer += cStr;
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\") || this.stateOverride) {
      if (this.buffer !== "") {
        const port = parseInt(this.buffer);
        if (port > 2 ** 16 - 1) {
          this.parseError = true;
          return failure;
        }
        this.url.port = port === defaultPort(this.url.scheme) ? null : port;
        this.buffer = "";
      }
      if (this.stateOverride) {
        return false;
      }
      this.state = "path start";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseFile(c4) {
    this.url.scheme = "file";
    this.url.host = "";
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file slash";
    } else if (this.base !== null && this.base.scheme === "file") {
      this.url.host = this.base.host;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        if (!startsWithWindowsDriveLetter(this.input, this.pointer)) {
          shortenPath(this.url);
        } else {
          this.parseError = true;
          this.url.path = [];
        }
        this.state = "path";
        --this.pointer;
      }
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileSlash(c4) {
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file host";
    } else {
      if (this.base !== null && this.base.scheme === "file") {
        if (!startsWithWindowsDriveLetter(this.input, this.pointer) && isNormalizedWindowsDriveLetterString(this.base.path[0])) {
          this.url.path.push(this.base.path[0]);
        }
        this.url.host = this.base.host;
      }
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileHost(c4, cStr) {
    if (isNaN(c4) || c4 === p("/") || c4 === p("\\") || c4 === p("?") || c4 === p("#")) {
      --this.pointer;
      if (!this.stateOverride && isWindowsDriveLetterString(this.buffer)) {
        this.parseError = true;
        this.state = "path";
      } else if (this.buffer === "") {
        this.url.host = "";
        if (this.stateOverride) {
          return false;
        }
        this.state = "path start";
      } else {
        let host = parseHost(this.buffer, isNotSpecial(this.url));
        if (host === failure) {
          return failure;
        }
        if (host === "localhost") {
          host = "";
        }
        this.url.host = host;
        if (this.stateOverride) {
          return false;
        }
        this.buffer = "";
        this.state = "path start";
      }
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parsePathStart(c4) {
    if (isSpecial(this.url)) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "path";
      if (c4 !== p("/") && c4 !== p("\\")) {
        --this.pointer;
      }
    } else if (!this.stateOverride && c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (!this.stateOverride && c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else if (c4 !== void 0) {
      this.state = "path";
      if (c4 !== p("/")) {
        --this.pointer;
      }
    } else if (this.stateOverride && this.url.host === null) {
      this.url.path.push("");
    }
    return true;
  }
  parsePath(c4) {
    if (isNaN(c4) || c4 === p("/") || isSpecial(this.url) && c4 === p("\\") || !this.stateOverride && (c4 === p("?") || c4 === p("#"))) {
      if (isSpecial(this.url) && c4 === p("\\")) {
        this.parseError = true;
      }
      if (isDoubleDot(this.buffer)) {
        shortenPath(this.url);
        if (c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
          this.url.path.push("");
        }
      } else if (isSingleDot(this.buffer) && c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
        this.url.path.push("");
      } else if (!isSingleDot(this.buffer)) {
        if (this.url.scheme === "file" && this.url.path.length === 0 && isWindowsDriveLetterString(this.buffer)) {
          this.buffer = `${this.buffer[0]}:`;
        }
        this.url.path.push(this.buffer);
      }
      this.buffer = "";
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      }
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += utf8PercentEncodeCodePoint(c4, isPathPercentEncode);
    }
    return true;
  }
  parseOpaquePath(c4) {
    if (c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else {
      if (!isNaN(c4) && c4 !== p("%")) {
        this.parseError = true;
      }
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      if (!isNaN(c4)) {
        this.url.path += utf8PercentEncodeCodePoint(c4, isC0ControlPercentEncode);
      }
    }
    return true;
  }
  parseQuery(c4, cStr) {
    if (!isSpecial(this.url) || this.url.scheme === "ws" || this.url.scheme === "wss") {
      this.encodingOverride = "utf-8";
    }
    if (!this.stateOverride && c4 === p("#") || isNaN(c4)) {
      const queryPercentEncodePredicate = isSpecial(this.url) ? isSpecialQueryPercentEncode : isQueryPercentEncode;
      this.url.query += utf8PercentEncodeString(this.buffer, queryPercentEncodePredicate);
      this.buffer = "";
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parseFragment(c4) {
    if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.url.fragment += utf8PercentEncodeCodePoint(c4, isFragmentPercentEncode);
    }
    return true;
  }
};
var fileOtherwiseCodePoints = /* @__PURE__ */ new Set([p("/"), p("\\"), p("?"), p("#")]);
function startsWithWindowsDriveLetter(input, pointer) {
  const length = input.length - pointer;
  return length >= 2 && isWindowsDriveLetterCodePoints(input[pointer], input[pointer + 1]) && (length === 2 || fileOtherwiseCodePoints.has(input[pointer + 2]));
}
function serializeURL(url, excludeFragment) {
  let output = `${url.scheme}:`;
  if (url.host !== null) {
    output += "//";
    if (url.username !== "" || url.password !== "") {
      output += url.username;
      if (url.password !== "") {
        output += `:${url.password}`;
      }
      output += "@";
    }
    output += serializeHost(url.host);
    if (url.port !== null) {
      output += `:${url.port}`;
    }
  }
  if (url.host === null && !hasAnOpaquePath(url) && url.path.length > 1 && url.path[0] === "") {
    output += "/.";
  }
  output += serializePath(url);
  if (url.query !== null) {
    output += `?${url.query}`;
  }
  if (!excludeFragment && url.fragment !== null) {
    output += `#${url.fragment}`;
  }
  return output;
}
function serializeOrigin(tuple) {
  let result = `${tuple.scheme}://`;
  result += serializeHost(tuple.host);
  if (tuple.port !== null) {
    result += `:${tuple.port}`;
  }
  return result;
}
function serializePath(url) {
  if (typeof url.path === "string") {
    return url.path;
  }
  let output = "";
  for (const segment of url.path) {
    output += `/${segment}`;
  }
  return output;
}
function serializeURLOrigin(url) {
  switch (url.scheme) {
    case "blob":
      try {
        return serializeURLOrigin(parseURL(serializePath(url)));
      } catch (e4) {
        return "null";
      }
    case "ftp":
    case "http":
    case "https":
    case "ws":
    case "wss":
      return serializeOrigin({
        scheme: url.scheme,
        host: url.host,
        port: url.port
      });
    case "file":
      return "null";
    default:
      return "null";
  }
}
function basicURLParse(input, options) {
  if (options === void 0) {
    options = {};
  }
  const usm = new URLStateMachine(input, options.baseURL, options.encodingOverride, options.url, options.stateOverride);
  if (usm.failure) {
    return null;
  }
  return usm.url;
}
function setTheUsername(url, username) {
  url.username = utf8PercentEncodeString(username, isUserinfoPercentEncode);
}
function setThePassword(url, password) {
  url.password = utf8PercentEncodeString(password, isUserinfoPercentEncode);
}
function serializeInteger(integer) {
  return String(integer);
}
function parseURL(input, options) {
  if (options === void 0) {
    options = {};
  }
  return basicURLParse(input, {
    baseURL: options.baseURL,
    encodingOverride: options.encodingOverride
  });
}
var NativeURL = typeof URL !== "undefined" ? URL : void 0;
var URLImpl = class {
  //Include URL type for "url" and "base" params.
  constructor(url, base2) {
    let parsedBase = null;
    if (base2 !== void 0) {
      if (base2 instanceof URL) {
        base2 = base2.href;
      }
      parsedBase = basicURLParse(base2);
      if (parsedBase === null) {
        throw new TypeError(`Invalid base URL: ${base2}`);
      }
    }
    if (url instanceof URL) {
      url = url.href;
    }
    const parsedURL = basicURLParse(url, { baseURL: parsedBase });
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${url}`);
    }
    const query = parsedURL.query !== null ? parsedURL.query : "";
    this._url = parsedURL;
    this._query = new URLSearchParamsImpl(query, {
      doNotStripQMark: true
    });
    this._query._url = this;
  }
  get href() {
    return serializeURL(this._url);
  }
  set href(v3) {
    const parsedURL = basicURLParse(v3);
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${v3}`);
    }
    this._url = parsedURL;
    this._query._list.splice(0);
    const { query } = parsedURL;
    if (query !== null) {
      this._query._list = parseUrlencodedString(query);
    }
  }
  get origin() {
    return serializeURLOrigin(this._url);
  }
  get protocol() {
    return `${this._url.scheme}:`;
  }
  set protocol(v3) {
    basicURLParse(`${v3}:`, {
      url: this._url,
      stateOverride: "scheme start"
    });
  }
  get username() {
    return this._url.username;
  }
  set username(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setTheUsername(this._url, v3);
  }
  get password() {
    return this._url.password;
  }
  set password(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setThePassword(this._url, v3);
  }
  get host() {
    const url = this._url;
    if (url.host === null) {
      return "";
    }
    if (url.port === null) {
      return serializeHost(url.host);
    }
    return `${serializeHost(url.host)}:${serializeInteger(url.port)}`;
  }
  set host(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "host" });
  }
  get hostname() {
    if (this._url.host === null) {
      return "";
    }
    return serializeHost(this._url.host);
  }
  set hostname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "hostname" });
  }
  get port() {
    if (this._url.port === null) {
      return "";
    }
    return serializeInteger(this._url.port);
  }
  set port(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    if (v3 === "") {
      this._url.port = null;
    } else {
      basicURLParse(v3, { url: this._url, stateOverride: "port" });
    }
  }
  get pathname() {
    return serializePath(this._url);
  }
  set pathname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    this._url.path = [];
    basicURLParse(v3, { url: this._url, stateOverride: "path start" });
  }
  get search() {
    if (this._url.query === null || this._url.query === "") {
      return "";
    }
    return `?${this._url.query}`;
  }
  set search(v3) {
    const url = this._url;
    if (v3 === "") {
      url.query = null;
      this._query._list = [];
      return;
    }
    const input = v3[0] === "?" ? v3.substring(1) : v3;
    url.query = "";
    basicURLParse(input, { url, stateOverride: "query" });
    this._query._list = parseUrlencodedString(input);
  }
  get searchParams() {
    return this._query;
  }
  get hash() {
    if (this._url.fragment === null || this._url.fragment === "") {
      return "";
    }
    return `#${this._url.fragment}`;
  }
  set hash(v3) {
    if (v3 === "") {
      this._url.fragment = null;
      return;
    }
    const input = v3[0] === "#" ? v3.substring(1) : v3;
    this._url.fragment = "";
    basicURLParse(input, { url: this._url, stateOverride: "fragment" });
  }
  toJSON() {
    return this.href;
  }
  static createObjectURL(blob) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.createObjectURL(blob);
  }
  static revokeObjectURL(url) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.revokeObjectURL(url);
  }
};

// ../taler-util/lib/url.js
(function() {
  if (typeof globalThis === "object")
    return;
  Object.defineProperty(Object.prototype, "__magic__", {
    get: function() {
      return this;
    },
    configurable: true
    // This makes it possible to `delete` the getter later.
  });
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
})();
var useOwnUrlImp = true;
var _URL = globalThis.URL;
if (useOwnUrlImp || !_URL) {
  globalThis.URL = _URL = URLImpl;
  _URL = URLImpl;
}
var URL2 = _URL;
var _URLSearchParams = globalThis.URLSearchParams;
if (useOwnUrlImp || !_URLSearchParams) {
  globalThis.URLSearchParams = URLSearchParamsImpl;
  _URLSearchParams = URLSearchParamsImpl;
}
var URLSearchParams2 = _URLSearchParams;

// ../taler-util/lib/helpers.js
function canonicalizeBaseUrl(url) {
  if (!url.startsWith("http") && !url.startsWith("https")) {
    url = "https://" + url;
  }
  const x5 = new URL2(url);
  if (!x5.pathname.endsWith("/")) {
    x5.pathname = x5.pathname + "/";
  }
  x5.search = "";
  x5.hash = "";
  return x5.href;
}
function canonicalJson(obj) {
  obj = JSON.parse(JSON.stringify(obj));
  if (typeof obj === "string") {
    return JSON.stringify(obj);
  }
  if (typeof obj === "number" || typeof obj === "boolean" || obj === null) {
    return JSON.stringify(obj);
  }
  if (Array.isArray(obj)) {
    const objs = obj.map((e4) => canonicalJson(e4));
    return `[${objs.join(",")}]`;
  }
  const keys = [];
  for (const key in obj) {
    keys.push(key);
  }
  keys.sort();
  let s4 = "{";
  for (let i4 = 0; i4 < keys.length; i4++) {
    const key = keys[i4];
    s4 += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
    if (i4 !== keys.length - 1) {
      s4 += ",";
    }
  }
  return s4 + "}";
}
function strcmp(s1, s23) {
  if (s1 < s23) {
    return -1;
  }
  if (s1 > s23) {
    return 1;
  }
  return 0;
}
function j2s(x5) {
  return JSON.stringify(x5, void 0, 2);
}

// ../taler-util/lib/logging.js
var isNode = typeof process !== "undefined" && typeof process.release !== "undefined" && process.release.name === "node";
var LogLevel;
(function(LogLevel2) {
  LogLevel2["Trace"] = "trace";
  LogLevel2["Message"] = "message";
  LogLevel2["Info"] = "info";
  LogLevel2["Warn"] = "warn";
  LogLevel2["Error"] = "error";
  LogLevel2["None"] = "none";
})(LogLevel || (LogLevel = {}));
var globalLogLevel = LogLevel.Info;
var byTagLogLevel = {};
var nativeLogging = false;
Error.prototype.toString = function() {
  if (this === null || typeof this !== "object" && typeof this !== "function") {
    throw new TypeError();
  }
  let name = this.name;
  name = name === void 0 ? "Error" : `${name}`;
  let msg = this.message;
  msg = msg === void 0 ? "" : `${msg}`;
  let cause = "";
  if ("cause" in this) {
    cause = `
 Caused by: ${this.cause}`;
  }
  return `${name}: ${msg}${cause}`;
};
function getGlobalLogLevel() {
  return globalLogLevel;
}
function setGlobalLogLevelFromString(logLevelStr) {
  globalLogLevel = getLevelForString(logLevelStr);
}
function getLevelForString(logLevelStr) {
  switch (logLevelStr.toLowerCase()) {
    case "trace":
      return LogLevel.Trace;
    case "info":
      return LogLevel.Info;
    case "warn":
    case "warning":
      return LogLevel.Warn;
    case "error":
      return LogLevel.Error;
    case "none":
      return LogLevel.None;
    default:
      if (isNode) {
        process.stderr.write(`Invalid log level, defaulting to WARNING
`);
      } else {
        console.warn(`Invalid log level, defaulting to WARNING`);
      }
      return LogLevel.Warn;
  }
}
function writeNativeLog(message, tag, level, args) {
  const logFn = globalThis.__nativeLog;
  if (logFn) {
    let m4;
    if (args.length == 0) {
      m4 = message;
    } else {
      m4 = message + " " + args.toString();
    }
    logFn(level, tag, message);
  }
}
function writeNodeLog(message, tag, level, args) {
  try {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} ${tag} ${level} ${message}`;
    if (args.length != 0) {
      msg += ` ${JSON.stringify(args, void 0, 2)}
`;
    } else {
      msg += `
`;
    }
    process.stderr.write(msg);
  } catch (e4) {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} (logger) FATAL `;
    if (e4 instanceof Error) {
      msg += `failed to write log: ${e4.message}
`;
    } else {
      msg += "failed to write log\n";
    }
    process.stderr.write(msg);
  }
}
var Logger = class {
  constructor(tag) {
    this.tag = tag;
  }
  getGlobalLogLevel() {
    return globalLogLevel;
  }
  shouldLogTrace() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
        return true;
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogInfo() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
        return true;
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogWarn() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
        return true;
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogError() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
        return true;
      case LogLevel.None:
        return false;
    }
  }
  info(message, ...args) {
    if (!this.shouldLogInfo()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 2, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "INFO", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  warn(message, ...args) {
    if (!this.shouldLogWarn()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 3, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "WARN", args);
    } else {
      console.warn(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  error(message, ...args) {
    if (!this.shouldLogError()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 4, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "ERROR", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} ERROR ` + message, ...args);
    }
  }
  trace(message, ...args) {
    if (!this.shouldLogTrace()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 1, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "TRACE", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} TRACE ` + message, ...args);
    }
  }
  reportBreak() {
    if (!this.shouldLogError()) {
      return;
    }
    const location2 = new Error("programming error");
    this.error(`assertion failed: ${location2.stack}`);
  }
};

// ../taler-util/lib/codec.js
var logger = new Logger("codec.ts");
var DecodingError = class _DecodingError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _DecodingError.prototype);
    this.name = "DecodingError";
  }
};
function renderContext(c4) {
  const p4 = c4?.path;
  if (p4) {
    return p4.join(".");
  } else {
    return "(unknown)";
  }
}
function joinContext(c4, part) {
  const path = c4?.path ?? [];
  return {
    path: path.concat([part])
  };
}
var ObjectCodecBuilder = class {
  constructor() {
    this.propList = [];
    this.deprecatedProps = /* @__PURE__ */ new Set();
    this._allowExtra = false;
  }
  /**
   * Define a property for the object.
   */
  property(x5, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x5, codec });
    return this;
  }
  /**
   * Define a property for the object.
   */
  propertyStrict(x5, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x5, codec });
    return this;
  }
  /**
   * Concatenate properties from @a codec.
   *
   * @param other codec to concat properties from
   *
   * FIXME: do proper union of all `other' props.
   */
  mixin(other) {
    this.propList.push(...other.getProps());
    return this;
  }
  /**
   * Define a deprecated property for the object.
   *
   * Deprecated properties won't be validated, their presence will
   * be validated in TRACE mode.
   */
  deprecatedProperty(x5) {
    this.deprecatedProps.add(x5);
    return this;
  }
  /**
   * Do not log warnings if the object has extra properties.
   */
  allowExtra() {
    this._allowExtra = true;
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const propList = this.propList;
    const allowExtra = this._allowExtra;
    const deprecatedPros = this.deprecatedProps;
    return {
      decode(x5, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        if (typeof x5 !== "object") {
          throw new DecodingError(`expected object for ${objectDisplayName} at ${renderContext(c4)} but got ${typeof x5}`);
        }
        const obj = {};
        for (const prop of propList) {
          const propRawVal = x5[prop.name];
          const propVal = prop.codec.decode(propRawVal, joinContext(c4, prop.name));
          obj[prop.name] = propVal;
        }
        for (const prop in x5) {
          if (prop in obj) {
            continue;
          }
          if (allowExtra) {
            obj[prop] = x5[prop];
          } else if (deprecatedPros.has(prop)) {
            logger.trace(`Deprecated property ${prop} for ${objectDisplayName} at ${renderContext(c4)}`);
          } else {
            logger.warn(`Extra property ${prop} for ${objectDisplayName} at ${renderContext(c4)}`);
          }
        }
        return obj;
      },
      getProps() {
        return propList;
      }
    };
  }
};
var UnionCodecBuilder = class {
  constructor(discriminator, baseCodec) {
    this.discriminator = discriminator;
    this.baseCodec = baseCodec;
    this.alternatives = /* @__PURE__ */ new Map();
  }
  /**
   * Define a property for the object.
   */
  alternative(tagValue, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.alternatives.set(tagValue, { codec, tagValue });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const alternatives = this.alternatives;
    const discriminator = this.discriminator;
    const baseCodec = this.baseCodec;
    return {
      decode(x5, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        const d4 = x5[discriminator];
        if (d4 === void 0 && !alternatives.has(d4)) {
          throw new DecodingError(`expected tag for ${objectDisplayName} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const alt = alternatives.get(d4);
        if (!alt) {
          throw new DecodingError(`unknown tag for ${objectDisplayName} ${d4} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const altDecoded = alt.codec.decode(x5);
        if (baseCodec) {
          const baseDecoded = baseCodec.decode(x5, c4);
          return { ...baseDecoded, ...altDecoded };
        } else {
          return altDecoded;
        }
      }
    };
  }
};
var UnionCodecPreBuilder = class {
  discriminateOn(discriminator, baseCodec) {
    return new UnionCodecBuilder(discriminator, baseCodec);
  }
};
function buildCodecForObject() {
  return new ObjectCodecBuilder();
}
function buildCodecForUnion() {
  return new UnionCodecPreBuilder();
}
function codecForMap(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x5, c4) {
      const map2 = {};
      if (typeof x5 !== "object") {
        throw new DecodingError(`expected object at ${renderContext(c4)}`);
      }
      for (const i4 in x5) {
        map2[i4] = innerCodec.decode(x5[i4], joinContext(c4, `[${i4}]`));
      }
      return map2;
    }
  };
}
function codecForList(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x5, c4) {
      const arr = [];
      if (!Array.isArray(x5)) {
        throw new DecodingError(`expected array at ${renderContext(c4)}`);
      }
      for (const i4 in x5) {
        arr.push(innerCodec.decode(x5[i4], joinContext(c4, `[${i4}]`)));
      }
      return arr;
    }
  };
}
function codecForNumber() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "number") {
        return x5;
      }
      throw new DecodingError(`expected number at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForBoolean() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "boolean") {
        return x5;
      }
      throw new DecodingError(`expected boolean at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForString() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "string") {
        return x5;
      }
      throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForAny() {
  return {
    decode(x5, c4) {
      return x5;
    }
  };
}
function codecForConstString(s4) {
  return {
    decode(x5, c4) {
      if (x5 === s4) {
        return x5;
      }
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string constant "${s4}" at ${renderContext(c4)} but got ${typeof x5}`);
      }
      throw new DecodingError(`expected string constant "${s4}" at ${renderContext(c4)} but got string value "${x5}"`);
    }
  };
}
function codecForConstNumber(n2) {
  return {
    decode(x5, c4) {
      if (x5 === n2) {
        return x5;
      }
      throw new DecodingError(`expected number constant "${n2}" at ${renderContext(c4)}  but got ${typeof x5}`);
    }
  };
}
function codecOptional(innerCodec) {
  return {
    decode(x5, c4) {
      if (x5 === void 0 || x5 === null) {
        return void 0;
      }
      return innerCodec.decode(x5, c4);
    }
  };
}
function codecOptionalDefault(innerCodec, def) {
  return {
    decode(x5, c4) {
      if (x5 === void 0 || x5 === null) {
        return def;
      }
      return innerCodec.decode(x5, c4);
    }
  };
}
function codecForEither(...alts) {
  return {
    decode(x5, c4) {
      for (const alt of alts) {
        try {
          return alt.decode(x5, c4);
        } catch (e4) {
          continue;
        }
      }
      if (logger.shouldLogTrace()) {
        logger.trace(`offending value: ${j2s(x5)}`);
      }
      throw new DecodingError(`No alternative matched at ${renderContext(c4)}`);
    }
  };
}

// ../taler-util/lib/errors.js
function makeErrorDetail(code, detail, hint) {
  if (!hint && !detail.hint) {
    hint = getDefaultTalerErrorHint(code);
  }
  const when = AbsoluteTime.now();
  return { code, when, hint, ...detail };
}
function getDefaultTalerErrorHint(code) {
  const errName = TalerErrorCode[code];
  if (errName) {
    return `Error (${errName})`;
  } else {
    return `Error (<unknown>)`;
  }
}
var TalerError = class _TalerError extends Error {
  constructor(d4, cause) {
    super(d4.hint ?? `Error (code ${d4.code})`);
    this.errorDetail = d4;
    this.cause = cause;
    Object.setPrototypeOf(this, _TalerError.prototype);
  }
  static fromDetail(code, detail, hint, cause) {
    if (!hint) {
      hint = getDefaultTalerErrorHint(code);
    }
    const when = AbsoluteTime.now();
    return new _TalerError({ code, when, hint, ...detail }, cause);
  }
  static fromUncheckedDetail(d4, c4) {
    return new _TalerError({ ...d4 }, c4);
  }
  static fromException(e4) {
    const errDetail = getErrorDetailFromException(e4);
    return new _TalerError(errDetail, e4);
  }
  hasErrorCode(code) {
    return this.errorDetail.code === code;
  }
  toString() {
    return `TalerError: ${JSON.stringify(this.errorDetail)}`;
  }
};
function getErrorDetailFromException(e4) {
  if (e4 instanceof TalerError) {
    return e4.errorDetail;
  }
  if (e4 instanceof CancellationToken.CancellationError) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_CORE_REQUEST_CANCELLED, {});
    return err2;
  }
  if (e4 instanceof Error) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {
      stack: e4.stack
    }, `unexpected exception (message: ${e4.message})`);
    return err2;
  }
  let excString;
  try {
    excString = e4.toString();
  } catch (e5) {
    excString = "can't stringify exception";
  }
  const err = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {}, `unexpected exception (not an exception, ${excString})`);
  return err;
}
function assertUnreachable(x5) {
  throw new Error("Didn't expect to get here");
}

// ../taler-util/lib/taler-error-codes.js
var TalerErrorCode;
(function(TalerErrorCode2) {
  TalerErrorCode2[TalerErrorCode2["NONE"] = 0] = "NONE";
  TalerErrorCode2[TalerErrorCode2["INVALID"] = 1] = "INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_INTERNAL_ERROR"] = 2] = "GENERIC_CLIENT_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION"] = 3] = "GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INVALID_RESPONSE"] = 10] = "GENERIC_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TIMEOUT"] = 11] = "GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_VERSION_MALFORMED"] = 12] = "GENERIC_VERSION_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_REPLY_MALFORMED"] = 13] = "GENERIC_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CONFIGURATION_INVALID"] = 14] = "GENERIC_CONFIGURATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNEXPECTED_REQUEST_ERROR"] = 15] = "GENERIC_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_PERMISSION_INSUFFICIENT"] = 16] = "GENERIC_TOKEN_PERMISSION_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_METHOD_INVALID"] = 20] = "GENERIC_METHOD_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ENDPOINT_UNKNOWN"] = 21] = "GENERIC_ENDPOINT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_INVALID"] = 22] = "GENERIC_JSON_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_HTTP_HEADERS_MALFORMED"] = 23] = "GENERIC_HTTP_HEADERS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PAYTO_URI_MALFORMED"] = 24] = "GENERIC_PAYTO_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MISSING"] = 25] = "GENERIC_PARAMETER_MISSING";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MALFORMED"] = 26] = "GENERIC_PARAMETER_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_RESERVE_PUB_MALFORMED"] = 27] = "GENERIC_RESERVE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_COMPRESSION_INVALID"] = 28] = "GENERIC_COMPRESSION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PATH_SEGMENT_MALFORMED"] = 29] = "GENERIC_PATH_SEGMENT_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURRENCY_MISMATCH"] = 30] = "GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_URI_TOO_LONG"] = 31] = "GENERIC_URI_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UPLOAD_EXCEEDS_LIMIT"] = 32] = "GENERIC_UPLOAD_EXCEEDS_LIMIT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNAUTHORIZED"] = 40] = "GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_UNKNOWN"] = 41] = "GENERIC_TOKEN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_EXPIRED"] = 42] = "GENERIC_TOKEN_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_MALFORMED"] = 43] = "GENERIC_TOKEN_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FORBIDDEN"] = 44] = "GENERIC_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SETUP_FAILED"] = 50] = "GENERIC_DB_SETUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_START_FAILED"] = 51] = "GENERIC_DB_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_STORE_FAILED"] = 52] = "GENERIC_DB_STORE_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_FETCH_FAILED"] = 53] = "GENERIC_DB_FETCH_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_COMMIT_FAILED"] = 54] = "GENERIC_DB_COMMIT_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SOFT_FAILURE"] = 55] = "GENERIC_DB_SOFT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_INVARIANT_FAILURE"] = 56] = "GENERIC_DB_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INTERNAL_INVARIANT_FAILURE"] = 60] = "GENERIC_INTERNAL_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_JSON_HASH"] = 61] = "GENERIC_FAILED_COMPUTE_JSON_HASH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_AMOUNT"] = 62] = "GENERIC_FAILED_COMPUTE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARSER_OUT_OF_MEMORY"] = 70] = "GENERIC_PARSER_OUT_OF_MEMORY";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ALLOCATION_FAILURE"] = 71] = "GENERIC_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_ALLOCATION_FAILURE"] = 72] = "GENERIC_JSON_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURL_ALLOCATION_FAILURE"] = 73] = "GENERIC_CURL_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_LOAD_TEMPLATE"] = 74] = "GENERIC_FAILED_TO_LOAD_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_EXPAND_TEMPLATE"] = 75] = "GENERIC_FAILED_TO_EXPAND_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FEATURE_NOT_IMPLEMENTED"] = 76] = "GENERIC_FEATURE_NOT_IMPLEMENTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BAD_CONFIGURATION"] = 1e3] = "EXCHANGE_GENERIC_BAD_CONFIGURATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_OPERATION_UNKNOWN"] = 1001] = "EXCHANGE_GENERIC_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 1002] = "EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY"] = 1003] = "EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB"] = 1004] = "EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN"] = 1005] = "EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_SIGNATURE_INVALID"] = 1006] = "EXCHANGE_DENOMINATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KEYS_MISSING"] = 1007] = "EXCHANGE_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE"] = 1008] = "EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_EXPIRED"] = 1009] = "EXCHANGE_GENERIC_DENOMINATION_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_REVOKED"] = 1010] = "EXCHANGE_GENERIC_DENOMINATION_REVOKED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_SECMOD_TIMEOUT"] = 1011] = "EXCHANGE_GENERIC_SECMOD_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INSUFFICIENT_FUNDS"] = 1012] = "EXCHANGE_GENERIC_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED"] = 1013] = "EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS"] = 1014] = "EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH"] = 1015] = "EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION"] = 1016] = "EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CIPHER_MISMATCH"] = 1017] = "EXCHANGE_GENERIC_CIPHER_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE"] = 1018] = "EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_UNKNOWN"] = 1019] = "EXCHANGE_GENERIC_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CLOCK_SKEW"] = 1020] = "EXCHANGE_GENERIC_CLOCK_SKEW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE"] = 1021] = "EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_GLOBAL_FEES_MISSING"] = 1022] = "EXCHANGE_GENERIC_GLOBAL_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WIRE_FEES_MISSING"] = 1023] = "EXCHANGE_GENERIC_WIRE_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_PUB_MALFORMED"] = 1024] = "EXCHANGE_GENERIC_PURSE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_UNKNOWN"] = 1025] = "EXCHANGE_GENERIC_PURSE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_EXPIRED"] = 1026] = "EXCHANGE_GENERIC_PURSE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_RESERVE_UNKNOWN"] = 1027] = "EXCHANGE_GENERIC_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_REQUIRED"] = 1028] = "EXCHANGE_GENERIC_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT"] = 1029] = "EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE"] = 1030] = "EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_DELETED"] = 1031] = "EXCHANGE_GENERIC_PURSE_DELETED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED"] = 1032] = "EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID"] = 1033] = "EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED"] = 1034] = "EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PENDING"] = 1035] = "EXCHANGE_GENERIC_AML_PENDING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_FROZEN"] = 1036] = "EXCHANGE_GENERIC_AML_FROZEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_CONVERTER_FAILED"] = 1037] = "EXCHANGE_GENERIC_KYC_CONVERTER_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FAILED"] = 1038] = "EXCHANGE_GENERIC_KYC_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_FAILED"] = 1039] = "EXCHANGE_GENERIC_KYC_FALLBACK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN"] = 1040] = "EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN"] = 1041] = "EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED"] = 1042] = "EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED"] = 1043] = "EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_TYPST_TEMPLATE_FAILURE"] = 1044] = "EXCHANGE_GENERIC_TYPST_TEMPLATE_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PDFTK_FAILURE"] = 1045] = "EXCHANGE_GENERIC_PDFTK_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_TYPST_CRASH"] = 1046] = "EXCHANGE_GENERIC_TYPST_CRASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PDFTK_CRASH"] = 1047] = "EXCHANGE_GENERIC_PDFTK_CRASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NO_TYPST_OR_PDFTK"] = 1048] = "EXCHANGE_GENERIC_NO_TYPST_OR_PDFTK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_NOT_FOUND"] = 1100] = "EXCHANGE_DEPOSITS_GET_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE"] = 1101] = "EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB"] = 1102] = "EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS"] = 1103] = "EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB"] = 1104] = "EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1105] = "EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID"] = 1106] = "EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED"] = 1107] = "EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1150] = "EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1151] = "EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW"] = 1152] = "EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_SIGNATURE_FAILED"] = 1153] = "EXCHANGE_WITHDRAW_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID"] = 1154] = "EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS"] = 1155] = "EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE"] = 1156] = "EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST"] = 1158] = "EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_UNBLIND_FAILURE"] = 1159] = "EXCHANGE_WITHDRAW_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_NONCE_REUSE"] = 1160] = "EXCHANGE_WITHDRAW_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN"] = 1161] = "EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW"] = 1162] = "EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT"] = 1163] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH"] = 1164] = "EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE"] = 1165] = "EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET"] = 1175] = "EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1205] = "EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT"] = 1206] = "EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE"] = 1207] = "EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE"] = 1208] = "EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER"] = 1209] = "EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON"] = 1210] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT"] = 1211] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1221] = "EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT"] = 1222] = "EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT"] = 1240] = "EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_COIN_HISTORY_BAD_SIGNATURE"] = 1251] = "EXCHANGE_COIN_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE"] = 1252] = "EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION"] = 1302] = "EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_SIGNATURE_INVALID"] = 1303] = "EXCHANGE_MELT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE"] = 1305] = "EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1306] = "EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION"] = 1353] = "EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR"] = 1354] = "EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN"] = 1355] = "EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID"] = 1356] = "EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH"] = 1358] = "EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW"] = 1359] = "EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT"] = 1360] = "EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID"] = 1361] = "EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_INVALID_RCH"] = 1362] = "EXCHANGE_REFRESHES_REVEAL_INVALID_RCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID"] = 1363] = "EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED"] = 1364] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID"] = 1365] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_LINK_COIN_UNKNOWN"] = 1400] = "EXCHANGE_LINK_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_MALFORMED"] = 1450] = "EXCHANGE_TRANSFERS_GET_WTID_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND"] = 1451] = "EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND"] = 1452] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT"] = 1453] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_INVALID_WAIT_TARGET"] = 1475] = "EXCHANGE_PURSES_INVALID_WAIT_TARGET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1476] = "EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_COIN_NOT_FOUND"] = 1500] = "EXCHANGE_REFUND_COIN_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT"] = 1501] = "EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_DEPOSIT_NOT_FOUND"] = 1502] = "EXCHANGE_REFUND_DEPOSIT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_ALREADY_PAID"] = 1503] = "EXCHANGE_REFUND_MERCHANT_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_TOO_LOW"] = 1504] = "EXCHANGE_REFUND_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_ABOVE_AMOUNT"] = 1505] = "EXCHANGE_REFUND_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID"] = 1506] = "EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED"] = 1507] = "EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE"] = 1508] = "EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE"] = 1509] = "EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INCONSISTENT_AMOUNT"] = 1510] = "EXCHANGE_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_SIGNATURE_INVALID"] = 1550] = "EXCHANGE_RECOUP_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND"] = 1551] = "EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_ZERO"] = 1552] = "EXCHANGE_RECOUP_COIN_BALANCE_ZERO";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_BLINDING_FAILED"] = 1553] = "EXCHANGE_RECOUP_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE"] = 1554] = "EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_NOT_ELIGIBLE"] = 1555] = "EXCHANGE_RECOUP_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID"] = 1575] = "EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND"] = 1576] = "EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED"] = 1578] = "EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE"] = 1580] = "EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN"] = 1600] = "EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_SIGNATURE_INVALID"] = 1650] = "EXCHANGE_WIRE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED"] = 1651] = "EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED"] = 1652] = "EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_FEES_NOT_CONFIGURED"] = 1653] = "EXCHANGE_WIRE_FEES_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA"] = 1675] = "EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA"] = 1676] = "EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS"] = 1677] = "EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW"] = 1678] = "EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_ALREADY_DECIDED"] = 1679] = "EXCHANGE_PURSE_DELETE_ALREADY_DECIDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID"] = 1680] = "EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED"] = 1681] = "EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE"] = 1700] = "EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_BUG"] = 1701] = "EXCHANGE_DENOMINATION_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_TOO_EARLY"] = 1702] = "EXCHANGE_DENOMINATION_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID"] = 1725] = "EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE"] = 1750] = "EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_BUG"] = 1751] = "EXCHANGE_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_TOO_EARLY"] = 1752] = "EXCHANGE_SIGNKEY_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING"] = 1753] = "EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW"] = 1775] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER"] = 1776] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID"] = 1777] = "EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID"] = 1778] = "EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE"] = 1785] = "EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE"] = 1786] = "EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE"] = 1787] = "EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT"] = 1788] = "EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS"] = 1789] = "EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND"] = 1800] = "EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT"] = 1801] = "EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID"] = 1802] = "EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID"] = 1803] = "EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID"] = 1804] = "EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID"] = 1805] = "EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT"] = 1806] = "EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN"] = 1807] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID"] = 1808] = "EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID"] = 1809] = "EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID"] = 1810] = "EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND"] = 1811] = "EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID"] = 1812] = "EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH"] = 1813] = "EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID"] = 1814] = "EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID"] = 1815] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH"] = 1816] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID"] = 1817] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID"] = 1818] = "EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID"] = 1825] = "EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_INVALID_OFFICER"] = 1826] = "EXCHANGE_AML_DECISION_INVALID_OFFICER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT"] = 1827] = "EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_UNKNOWN_CHECK"] = 1828] = "EXCHANGE_AML_DECISION_UNKNOWN_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID"] = 1830] = "EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT"] = 1831] = "EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA"] = 1832] = "EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA"] = 1833] = "EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA"] = 1850] = "EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED"] = 1851] = "EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID"] = 1852] = "EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW"] = 1853] = "EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER"] = 1854] = "EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID"] = 1855] = "EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID"] = 1856] = "EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID"] = 1857] = "EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA"] = 1858] = "EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA"] = 1859] = "EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE"] = 1860] = "EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE"] = 1876] = "EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE"] = 1877] = "EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_NOT_FULL"] = 1878] = "EXCHANGE_PURSE_NOT_FULL";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID"] = 1879] = "EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN"] = 1880] = "EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID"] = 1890] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT"] = 1891] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID"] = 1900] = "EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_UNKNOWN"] = 1901] = "EXCHANGE_AUDITORS_AUDITOR_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_INACTIVE"] = 1902] = "EXCHANGE_AUDITORS_AUDITOR_INACTIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT"] = 1918] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED"] = 1919] = "EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_RECURSIVE_RULE_DETECTED"] = 1920] = "EXCHANGE_KYC_RECURSIVE_RULE_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_FORM_INCOMPLETE"] = 1921] = "EXCHANGE_KYC_AML_FORM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE"] = 1922] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_NOT_A_FORM"] = 1923] = "EXCHANGE_KYC_NOT_A_FORM";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_CHECK_GONE"] = 1924] = "EXCHANGE_KYC_GENERIC_CHECK_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WALLET_SIGNATURE_INVALID"] = 1925] = "EXCHANGE_KYC_WALLET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE"] = 1926] = "EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_ERROR"] = 1927] = "EXCHANGE_KYC_PROOF_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED"] = 1928] = "EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN"] = 1929] = "EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED"] = 1930] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN"] = 1931] = "EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_GONE"] = 1932] = "EXCHANGE_KYC_GENERIC_LOGIC_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_BUG"] = 1933] = "EXCHANGE_KYC_GENERIC_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED"] = 1934] = "EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT"] = 1935] = "EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY"] = 1936] = "EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED"] = 1937] = "EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED"] = 1938] = "EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN"] = 1939] = "EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN"] = 1940] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_FORM_ALREADY_UPLOADED"] = 1941] = "EXCHANGE_KYC_FORM_ALREADY_UPLOADED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURES_MALFORMED"] = 1942] = "EXCHANGE_KYC_MEASURES_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURE_INDEX_INVALID"] = 1943] = "EXCHANGE_KYC_MEASURE_INDEX_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK"] = 1944] = "EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_FAILURE"] = 1945] = "EXCHANGE_KYC_AML_PROGRAM_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT"] = 1946] = "EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY"] = 1947] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT"] = 1948] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG"] = 1949] = "EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_UNKNOWN"] = 1950] = "EXCHANGE_CONTRACTS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB"] = 1951] = "EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECRYPTION_FAILED"] = 1952] = "EXCHANGE_CONTRACTS_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_SIGNATURE_INVALID"] = 1953] = "EXCHANGE_CONTRACTS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECODING_FAILED"] = 1954] = "EXCHANGE_CONTRACTS_DECODING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1975] = "EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY"] = 1976] = "EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_BUSY"] = 1977] = "EXCHANGE_KYC_INFO_BUSY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TOTP_KEY_INVALID"] = 1980] = "EXCHANGE_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_UNKNOWN"] = 2e3] = "MERCHANT_GENERIC_INSTANCE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE"] = 2001] = "MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED"] = 2002] = "MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CATEGORY_UNKNOWN"] = 2003] = "MERCHANT_GENERIC_CATEGORY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNIT_UNKNOWN"] = 2004] = "MERCHANT_GENERIC_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ORDER_UNKNOWN"] = 2005] = "MERCHANT_GENERIC_ORDER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PRODUCT_UNKNOWN"] = 2006] = "MERCHANT_GENERIC_PRODUCT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_REWARD_ID_UNKNOWN"] = 2007] = "MERCHANT_GENERIC_REWARD_ID_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID"] = 2008] = "MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER"] = 2009] = "MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE"] = 2010] = "MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_TIMEOUT"] = 2011] = "MERCHANT_GENERIC_EXCHANGE_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE"] = 2012] = "MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED"] = 2013] = "MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS"] = 2014] = "MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNAUTHORIZED"] = 2015] = "MERCHANT_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_DELETED"] = 2016] = "MERCHANT_GENERIC_INSTANCE_DELETED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TRANSFER_UNKNOWN"] = 2017] = "MERCHANT_GENERIC_TRANSFER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TEMPLATE_UNKNOWN"] = 2018] = "MERCHANT_GENERIC_TEMPLATE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_WEBHOOK_UNKNOWN"] = 2019] = "MERCHANT_GENERIC_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN"] = 2020] = "MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN"] = 2021] = "MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ACCOUNT_UNKNOWN"] = 2022] = "MERCHANT_GENERIC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_H_WIRE_MALFORMED"] = 2023] = "MERCHANT_GENERIC_H_WIRE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CURRENCY_MISMATCH"] = 2024] = "MERCHANT_GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNTRUSTED"] = 2025] = "MERCHANT_GENERIC_EXCHANGE_UNTRUSTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN"] = 2026] = "MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN"] = 2027] = "MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_NOT_CONFIGURED"] = 2028] = "MERCHANT_GENERIC_DONAU_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN"] = 2029] = "MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE"] = 2030] = "MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_MFA_MISSING"] = 2031] = "MERCHANT_GENERIC_MFA_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_INVALID_RESPONSE"] = 2032] = "MERCHANT_GENERIC_DONAU_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNIT_BUILTIN"] = 2033] = "MERCHANT_GENERIC_UNIT_BUILTIN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE"] = 2100] = "MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE"] = 2103] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE"] = 2104] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_TOKEN"] = 2105] = "MERCHANT_GET_ORDERS_ID_INVALID_TOKEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH"] = 2106] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION"] = 2107] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_FAILED"] = 2125] = "MERCHANT_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_UNKNOWN"] = 2126] = "MERCHANT_TAN_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_MANY_ATTEMPTS"] = 2127] = "MERCHANT_TAN_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_MFA_HELPER_EXEC_FAILED"] = 2128] = "MERCHANT_TAN_MFA_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_SOLVED"] = 2129] = "MERCHANT_TAN_CHALLENGE_SOLVED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_EARLY"] = 2130] = "MERCHANT_TAN_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_MFA_FORBIDDEN"] = 2131] = "MERCHANT_MFA_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS"] = 2150] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND"] = 2151] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE"] = 2152] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW"] = 2153] = "MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT"] = 2154] = "MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES"] = 2155] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT"] = 2156] = "MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID"] = 2157] = "MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED"] = 2158] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE"] = 2159] = "MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID"] = 2160] = "MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED"] = 2161] = "MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING"] = 2162] = "MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN"] = 2163] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED"] = 2165] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED"] = 2166] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDED"] = 2167] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS"] = 2168] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS";
  TalerErrorCode2[TalerErrorCode2["DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2169] = "DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED"] = 2170] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING"] = 2171] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH"] = 2172] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED"] = 2173] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING"] = 2174] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED"] = 2175] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING"] = 2176] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS"] = 2177] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH"] = 2178] = "MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID"] = 2179] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID"] = 2180] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH"] = 2181] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH"] = 2182] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID"] = 2183] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2184] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH"] = 2185] = "MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH"] = 2200] = "MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID"] = 2201] = "MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_TOKEN_FAMILY_CONFLICT"] = 2225] = "MERCHANT_POST_TOKEN_FAMILY_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND"] = 2226] = "MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED"] = 2251] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED"] = 2252] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND"] = 2253] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2254] = "MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH"] = 2255] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY"] = 2256] = "MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS"] = 2258] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST"] = 2259] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE"] = 2260] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND"] = 2261] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED"] = 2262] = "MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE"] = 2263] = "MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE"] = 2264] = "MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND"] = 2300] = "MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED"] = 2301] = "MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE"] = 2302] = "MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED"] = 2350] = "MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE"] = 2400] = "MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR"] = 2403] = "MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_SUMMATION_FAILED"] = 2404] = "MERCHANT_REWARD_PICKUP_SUMMATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_HAS_EXPIRED"] = 2405] = "MERCHANT_REWARD_PICKUP_HAS_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING"] = 2406] = "MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN"] = 2407] = "MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE"] = 2500] = "MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME"] = 2501] = "MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR"] = 2502] = "MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS"] = 2503] = "MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE"] = 2504] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST"] = 2505] = "MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER"] = 2506] = "MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST"] = 2507] = "MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST"] = 2508] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD"] = 2509] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT"] = 2510] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE"] = 2511] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2512] = "MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS"] = 2513] = "MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY"] = 2514] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT"] = 2520] = "MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID"] = 2521] = "MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT"] = 2530] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID"] = 2531] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT"] = 2532] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN"] = 2533] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID"] = 2534] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN"] = 2550] = "MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR"] = 2551] = "MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS"] = 2552] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS"] = 2553] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE"] = 2554] = "MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND"] = 2555] = "MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED"] = 2556] = "MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION"] = 2557] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN"] = 2558] = "MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS"] = 2563] = "MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS"] = 2600] = "MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH"] = 2601] = "MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH"] = 2602] = "MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED"] = 2603] = "MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED"] = 2625] = "MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT"] = 2626] = "MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_EXISTS"] = 2627] = "MERCHANT_PRIVATE_ACCOUNT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS"] = 2650] = "MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS"] = 2651] = "MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED"] = 2660] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS"] = 2661] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED"] = 2662] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED"] = 2663] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS"] = 2670] = "MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK"] = 2680] = "MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD"] = 2700] = "MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED"] = 2701] = "MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE"] = 2710] = "MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED"] = 2750] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN"] = 2751] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS"] = 2752] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND"] = 2753] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE"] = 2800] = "MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS"] = 2850] = "MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS"] = 2851] = "MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT"] = 2860] = "MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT"] = 2861] = "MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT"] = 2862] = "MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY"] = 2863] = "MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS"] = 2900] = "MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS"] = 2910] = "MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_UNAUTHORIZED"] = 3001] = "AUDITOR_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_METHOD_NOT_ALLOWED"] = 3002] = "AUDITOR_GENERIC_METHOD_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID"] = 3100] = "AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED"] = 3101] = "AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_RESOURCE_NOT_FOUND"] = 3102] = "AUDITOR_RESOURCE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_URI_MISSING_PATH_COMPONENT"] = 3103] = "AUDITOR_URI_MISSING_PATH_COMPONENT";
  TalerErrorCode2[TalerErrorCode2["BANK_SAME_ACCOUNT"] = 5101] = "BANK_SAME_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_UNALLOWED_DEBIT"] = 5102] = "BANK_UNALLOWED_DEBIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NEGATIVE_NUMBER_AMOUNT"] = 5103] = "BANK_NEGATIVE_NUMBER_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_NUMBER_TOO_BIG"] = 5104] = "BANK_NUMBER_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_ACCOUNT"] = 5106] = "BANK_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSACTION_NOT_FOUND"] = 5107] = "BANK_TRANSACTION_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_FORMAT_AMOUNT"] = 5108] = "BANK_BAD_FORMAT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_REJECT_NO_RIGHTS"] = 5109] = "BANK_REJECT_NO_RIGHTS";
  TalerErrorCode2[TalerErrorCode2["BANK_UNMANAGED_EXCEPTION"] = 5110] = "BANK_UNMANAGED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_SOFT_EXCEPTION"] = 5111] = "BANK_SOFT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_REQUEST_UID_REUSED"] = 5112] = "BANK_TRANSFER_REQUEST_UID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT"] = 5113] = "BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_DUPLICATE_RESERVE_PUB_SUBJECT"] = 5114] = "BANK_DUPLICATE_RESERVE_PUB_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["BANK_ANCIENT_TRANSACTION_GONE"] = 5115] = "BANK_ANCIENT_TRANSACTION_GONE";
  TalerErrorCode2[TalerErrorCode2["BANK_ABORT_CONFIRM_CONFLICT"] = 5116] = "BANK_ABORT_CONFIRM_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_ABORT_CONFLICT"] = 5117] = "BANK_CONFIRM_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_CONFLICT"] = 5118] = "BANK_REGISTER_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_POST_WITHDRAWAL_OPERATION_REQUIRED"] = 5119] = "BANK_POST_WITHDRAWAL_OPERATION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_RESERVED_USERNAME_CONFLICT"] = 5120] = "BANK_RESERVED_USERNAME_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_USERNAME_REUSE"] = 5121] = "BANK_REGISTER_USERNAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_PAYTO_URI_REUSE"] = 5122] = "BANK_REGISTER_PAYTO_URI_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_BALANCE_NOT_ZERO"] = 5123] = "BANK_ACCOUNT_BALANCE_NOT_ZERO";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_CREDITOR"] = 5124] = "BANK_UNKNOWN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_DEBTOR"] = 5125] = "BANK_UNKNOWN_DEBTOR";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_EXCHANGE"] = 5126] = "BANK_ACCOUNT_IS_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_NOT_EXCHANGE"] = 5127] = "BANK_ACCOUNT_IS_NOT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_CONVERSION"] = 5128] = "BANK_BAD_CONVERSION";
  TalerErrorCode2[TalerErrorCode2["BANK_MISSING_TAN_INFO"] = 5129] = "BANK_MISSING_TAN_INFO";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_INCOMPLETE"] = 5130] = "BANK_CONFIRM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_RATE_LIMITED"] = 5131] = "BANK_TAN_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_NOT_SUPPORTED"] = 5132] = "BANK_TAN_CHANNEL_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_SCRIPT_FAILED"] = 5133] = "BANK_TAN_CHANNEL_SCRIPT_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_FAILED"] = 5134] = "BANK_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_LEGAL_NAME"] = 5135] = "BANK_NON_ADMIN_PATCH_LEGAL_NAME";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_DEBT_LIMIT"] = 5136] = "BANK_NON_ADMIN_PATCH_DEBT_LIMIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD"] = 5137] = "BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_BAD_OLD_PASSWORD"] = 5138] = "BANK_PATCH_BAD_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_ADMIN_EXCHANGE"] = 5139] = "BANK_PATCH_ADMIN_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CASHOUT"] = 5140] = "BANK_NON_ADMIN_PATCH_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CONTACT"] = 5141] = "BANK_NON_ADMIN_PATCH_CONTACT";
  TalerErrorCode2[TalerErrorCode2["BANK_ADMIN_CREDITOR"] = 5142] = "BANK_ADMIN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_CHALLENGE_NOT_FOUND"] = 5143] = "BANK_CHALLENGE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_EXPIRED"] = 5144] = "BANK_TAN_CHALLENGE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_TAN_CHANNEL"] = 5145] = "BANK_NON_ADMIN_SET_TAN_CHANNEL";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_MIN_CASHOUT"] = 5146] = "BANK_NON_ADMIN_SET_MIN_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_AMOUNT_TO_SMALL"] = 5147] = "BANK_CONVERSION_AMOUNT_TO_SMALL";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_DIFFERS"] = 5148] = "BANK_AMOUNT_DIFFERS";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_REQUIRED"] = 5149] = "BANK_AMOUNT_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_SHORT"] = 5150] = "BANK_PASSWORD_TOO_SHORT";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_LONG"] = 5151] = "BANK_PASSWORD_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_LOCKED"] = 5152] = "BANK_ACCOUNT_LOCKED";
  TalerErrorCode2[TalerErrorCode2["BANK_UPDATE_ABORT_CONFLICT"] = 5153] = "BANK_UPDATE_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_WTID_REUSED"] = 5154] = "BANK_TRANSFER_WTID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS"] = 5155] = "BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_RATE_CLASS_UNKNOWN"] = 5156] = "BANK_CONVERSION_RATE_CLASS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["BANK_NAME_REUSE"] = 5157] = "BANK_NAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["SYNC_ACCOUNT_UNKNOWN"] = 6100] = "SYNC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_NONE_MATCH"] = 6101] = "SYNC_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_MATCH"] = 6102] = "SYNC_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_SYNC_SIGNATURE"] = 6103] = "SYNC_BAD_SYNC_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_SIGNATURE"] = 6104] = "SYNC_INVALID_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_MALFORMED_CONTENT_LENGTH"] = 6105] = "SYNC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_EXCESSIVE_CONTENT_LENGTH"] = 6106] = "SYNC_EXCESSIVE_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 6107] = "SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_UPLOAD"] = 6108] = "SYNC_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_GENERIC_TIMEOUT"] = 6109] = "SYNC_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_CREATE_BACKEND_ERROR"] = 6110] = "SYNC_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_PREVIOUS_BACKUP_UNKNOWN"] = 6111] = "SYNC_PREVIOUS_BACKUP_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_MISSING_CONTENT_LENGTH"] = 6112] = "SYNC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_ERROR"] = 6113] = "SYNC_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_TIMEOUT"] = 6114] = "SYNC_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE"] = 7e3] = "WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_EXCEPTION"] = 7001] = "WALLET_UNEXPECTED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["WALLET_RECEIVED_MALFORMED_RESPONSE"] = 7002] = "WALLET_RECEIVED_MALFORMED_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["WALLET_NETWORK_ERROR"] = 7003] = "WALLET_NETWORK_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_THROTTLED"] = 7004] = "WALLET_HTTP_REQUEST_THROTTLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_REQUEST_ERROR"] = 7005] = "WALLET_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT"] = 7006] = "WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_OPERATION_UNKNOWN"] = 7007] = "WALLET_CORE_API_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["WALLET_INVALID_TALER_PAY_URI"] = 7008] = "WALLET_INVALID_TALER_PAY_URI";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_COIN_SIGNATURE_INVALID"] = 7009] = "WALLET_EXCHANGE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_NOT_AVAILABLE"] = 7011] = "WALLET_CORE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK"] = 7012] = "WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_GENERIC_TIMEOUT"] = 7013] = "WALLET_HTTP_REQUEST_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_CLAIMED"] = 7014] = "WALLET_ORDER_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_GROUP_INCOMPLETE"] = 7015] = "WALLET_WITHDRAWAL_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REWARD_COIN_SIGNATURE_INVALID"] = 7016] = "WALLET_REWARD_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE"] = 7017] = "WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH"] = 7018] = "WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_SIGNATURE_INVALID"] = 7019] = "WALLET_CONTRACT_TERMS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_MALFORMED"] = 7020] = "WALLET_CONTRACT_TERMS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PENDING_OPERATION_FAILED"] = 7021] = "WALLET_PENDING_OPERATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_SERVER_ERROR"] = 7022] = "WALLET_PAY_MERCHANT_SERVER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_ERROR"] = 7023] = "WALLET_CRYPTO_WORKER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_BAD_REQUEST"] = 7024] = "WALLET_CRYPTO_WORKER_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_KYC_REQUIRED"] = 7025] = "WALLET_WITHDRAWAL_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE"] = 7026] = "WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE"] = 7027] = "WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE"] = 7028] = "WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REFRESH_GROUP_INCOMPLETE"] = 7029] = "WALLET_REFRESH_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_BASE_URL_MISMATCH"] = 7030] = "WALLET_EXCHANGE_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_PAID"] = 7031] = "WALLET_ORDER_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_UNAVAILABLE"] = 7032] = "WALLET_EXCHANGE_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_USED"] = 7033] = "WALLET_EXCHANGE_ENTRY_USED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DB_UNAVAILABLE"] = 7034] = "WALLET_DB_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TALER_URI_MALFORMED"] = 7035] = "WALLET_TALER_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_REQUEST_CANCELLED"] = 7036] = "WALLET_CORE_REQUEST_CANCELLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_TOS_NOT_ACCEPTED"] = 7037] = "WALLET_EXCHANGE_TOS_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT"] = 7038] = "WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_OUTDATED"] = 7039] = "WALLET_EXCHANGE_ENTRY_OUTDATED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_KYC_MISSING"] = 7040] = "WALLET_PAY_MERCHANT_KYC_MISSING";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_DEBIT_PURSE_GONE"] = 7041] = "WALLET_PEER_PULL_DEBIT_PURSE_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABORTED_BY_USER"] = 7042] = "WALLET_TRANSACTION_ABORTED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABANDONED_BY_USER"] = 7043] = "WALLET_TRANSACTION_ABANDONED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_ORDER_GONE"] = 7044] = "WALLET_PAY_MERCHANT_ORDER_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_NOT_FOUND"] = 7045] = "WALLET_EXCHANGE_ENTRY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED"] = 7046] = "WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_PROTOCOL_VIOLATION"] = 7047] = "WALLET_TRANSACTION_PROTOCOL_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_BAD_REQUEST"] = 7048] = "WALLET_CORE_API_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_MERCHANT_ORDER_NOT_FOUND"] = 7049] = "WALLET_MERCHANT_ORDER_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_TIMEOUT"] = 8e3] = "ANASTASIS_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST"] = 8001] = "ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_ERROR"] = 8002] = "ANASTASIS_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH"] = 8003] = "ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH"] = 8004] = "ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR"] = 8005] = "ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED"] = 8006] = "ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED"] = 8007] = "ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PROVIDER_UNREACHABLE"] = 8008] = "ANASTASIS_GENERIC_PROVIDER_UNREACHABLE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_PAYMENT_GENERIC_TIMEOUT"] = 8009] = "ANASTASIS_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNKNOWN"] = 8108] = "ANASTASIS_TRUTH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED"] = 8109] = "ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED"] = 8110] = "ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_FAILED"] = 8111] = "ANASTASIS_TRUTH_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_UNKNOWN"] = 8112] = "ANASTASIS_TRUTH_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED"] = 8114] = "ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_KEY_SHARE_GONE"] = 8115] = "ANASTASIS_TRUTH_KEY_SHARE_GONE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_ORDER_DISAPPEARED"] = 8116] = "ANASTASIS_TRUTH_ORDER_DISAPPEARED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD"] = 8117] = "ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS"] = 8118] = "ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR"] = 8119] = "ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_DECRYPTION_FAILED"] = 8120] = "ANASTASIS_TRUTH_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_RATE_LIMITED"] = 8121] = "ANASTASIS_TRUTH_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD"] = 8123] = "ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS"] = 8150] = "ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED"] = 8151] = "ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_PHONE_INVALID"] = 8200] = "ANASTASIS_SMS_PHONE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_EXEC_FAILED"] = 8201] = "ANASTASIS_SMS_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_COMMAND_FAILED"] = 8202] = "ANASTASIS_SMS_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_INVALID"] = 8210] = "ANASTASIS_EMAIL_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_EXEC_FAILED"] = 8211] = "ANASTASIS_EMAIL_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_COMMAND_FAILED"] = 8212] = "ANASTASIS_EMAIL_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_INVALID"] = 8220] = "ANASTASIS_POST_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_EXEC_FAILED"] = 8221] = "ANASTASIS_POST_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_COMMAND_FAILED"] = 8222] = "ANASTASIS_POST_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_INVALID"] = 8230] = "ANASTASIS_IBAN_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_MISSING_TRANSFER"] = 8231] = "ANASTASIS_IBAN_MISSING_TRANSFER";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_MISSING"] = 8240] = "ANASTASIS_TOTP_KEY_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_INVALID"] = 8241] = "ANASTASIS_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_NONE_MATCH"] = 8301] = "ANASTASIS_POLICY_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 8304] = "ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_SIGNATURE"] = 8305] = "ANASTASIS_POLICY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_MATCH"] = 8306] = "ANASTASIS_POLICY_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_INVALID_UPLOAD"] = 8307] = "ANASTASIS_POLICY_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_NOT_FOUND"] = 8350] = "ANASTASIS_POLICY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_ACTION_INVALID"] = 8400] = "ANASTASIS_REDUCER_ACTION_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_STATE_INVALID"] = 8401] = "ANASTASIS_REDUCER_STATE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID"] = 8402] = "ANASTASIS_REDUCER_INPUT_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED"] = 8403] = "ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE"] = 8404] = "ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKEND_FAILURE"] = 8405] = "ANASTASIS_REDUCER_BACKEND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MALFORMED"] = 8406] = "ANASTASIS_REDUCER_RESOURCE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MISSING"] = 8407] = "ANASTASIS_REDUCER_RESOURCE_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_REGEX_FAILED"] = 8408] = "ANASTASIS_REDUCER_INPUT_REGEX_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED"] = 8409] = "ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED"] = 8410] = "ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED"] = 8411] = "ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED"] = 8412] = "ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_MALFORMED"] = 8413] = "ANASTASIS_REDUCER_POLICY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_NETWORK_FAILED"] = 8414] = "ANASTASIS_REDUCER_NETWORK_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_MALFORMED"] = 8415] = "ANASTASIS_REDUCER_SECRET_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG"] = 8416] = "ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_TOO_BIG"] = 8417] = "ANASTASIS_REDUCER_SECRET_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG"] = 8418] = "ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INTERNAL_ERROR"] = 8419] = "ANASTASIS_REDUCER_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED"] = 8420] = "ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_KEYS_MISSING"] = 8607] = "DONAU_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_SIGNATURE_INVALID"] = 8608] = "DONAU_CHARITY_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_NOT_FOUND"] = 8609] = "DONAU_CHARITY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["DONAU_EXCEEDING_DONATION_LIMIT"] = 8610] = "DONAU_EXCEEDING_DONATION_LIMIT";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_DONATION_UNIT_UNKNOWN"] = 8611] = "DONAU_GENERIC_DONATION_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_UNIT_HELPER_UNAVAILABLE"] = 8612] = "DONAU_DONATION_UNIT_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_UNAVAILABLE"] = 8613] = "DONAU_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_BUG"] = 8614] = "DONAU_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 8615] = "DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_RECEIPT_SIGNATURE_INVALID"] = 8616] = "DONAU_DONATION_RECEIPT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONOR_IDENTIFIER_NONCE_REUSE"] = 8617] = "DONAU_DONOR_IDENTIFIER_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_PUB_EXISTS"] = 8618] = "DONAU_CHARITY_PUB_EXISTS";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_GENERIC_ERROR"] = 9e3] = "LIBEUFIN_NEXUS_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION"] = 9001] = "LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_GENERIC_ERROR"] = 9500] = "LIBEUFIN_SANDBOX_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION"] = 9501] = "LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["TALDIR_METHOD_NOT_SUPPORTED"] = 9600] = "TALDIR_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["TALDIR_REGISTER_RATE_LIMITED"] = 9601] = "TALDIR_REGISTER_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_UNKNOWN"] = 9750] = "CHALLENGER_GENERIC_CLIENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI"] = 9751] = "CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_HELPER_EXEC_FAILED"] = 9752] = "CHALLENGER_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GRANT_UNKNOWN"] = 9753] = "CHALLENGER_GRANT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE"] = 9754] = "CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_VALIDATION_UNKNOWN"] = 9755] = "CHALLENGER_GENERIC_VALIDATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE"] = 9756] = "CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_TOO_MANY_ATTEMPTS"] = 9757] = "CHALLENGER_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_INVALID_PIN"] = 9758] = "CHALLENGER_INVALID_PIN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_MISSING_ADDRESS"] = 9759] = "CHALLENGER_MISSING_ADDRESS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY"] = 9760] = "CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY";
  TalerErrorCode2[TalerErrorCode2["END"] = 9999] = "END";
})(TalerErrorCode || (TalerErrorCode = {}));

// ../taler-util/lib/time.js
var opaque_AbsoluteTime = Symbol("opaque_AbsoluteTime");
var TalerPreciseTimestamp;
(function(TalerPreciseTimestamp2) {
  function now() {
    const absNow = AbsoluteTime.now();
    return AbsoluteTime.toPreciseTimestamp(absNow);
  }
  TalerPreciseTimestamp2.now = now;
  function round(t4) {
    return {
      t_s: t4.t_s
    };
  }
  TalerPreciseTimestamp2.round = round;
  function fromSeconds(s4) {
    return {
      t_s: Math.floor(s4),
      off_us: Math.floor((s4 - Math.floor(s4)) / 1e3 / 1e3)
    };
  }
  TalerPreciseTimestamp2.fromSeconds = fromSeconds;
  function fromMilliseconds(ms) {
    return {
      t_s: Math.floor(ms / 1e3),
      off_us: Math.floor((ms - Math.floor(ms / 1e3) * 1e3) * 1e3)
    };
  }
  TalerPreciseTimestamp2.fromMilliseconds = fromMilliseconds;
})(TalerPreciseTimestamp || (TalerPreciseTimestamp = {}));
var TalerProtocolDuration;
(function(TalerProtocolDuration3) {
  function fromSpec(d4) {
    return Duration.toTalerProtocolDuration(Duration.fromSpec(d4));
  }
  TalerProtocolDuration3.fromSpec = fromSpec;
  function forever() {
    return {
      d_us: "forever"
    };
  }
  TalerProtocolDuration3.forever = forever;
})(TalerProtocolDuration || (TalerProtocolDuration = {}));
var TalerProtocolTimestamp;
(function(TalerProtocolTimestamp3) {
  function isTimestamp(x5) {
    return typeof x5 === "object" && x5 !== null && "t_s" in x5 && (typeof x5.t_s === "number" || x5.t_s === "never");
  }
  TalerProtocolTimestamp3.isTimestamp = isTimestamp;
  function now() {
    return AbsoluteTime.toProtocolTimestamp(AbsoluteTime.now());
  }
  TalerProtocolTimestamp3.now = now;
  function zero() {
    return {
      t_s: 0
    };
  }
  TalerProtocolTimestamp3.zero = zero;
  function never() {
    return {
      t_s: "never"
    };
  }
  TalerProtocolTimestamp3.never = never;
  function isNever(t4) {
    return t4.t_s === "never";
  }
  TalerProtocolTimestamp3.isNever = isNever;
  function fromSeconds(s4) {
    return {
      t_s: s4
    };
  }
  TalerProtocolTimestamp3.fromSeconds = fromSeconds;
  function min(t1, t22) {
    if (t1.t_s === "never") {
      return { t_s: t22.t_s };
    }
    if (t22.t_s === "never") {
      return { t_s: t1.t_s };
    }
    return { t_s: Math.min(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp3.min = min;
  function max(t1, t22) {
    if (t1.t_s === "never" || t22.t_s === "never") {
      return { t_s: "never" };
    }
    return { t_s: Math.max(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp3.max = max;
})(TalerProtocolTimestamp || (TalerProtocolTimestamp = {}));
var timeshift = 0;
var Duration;
(function(Duration2) {
  function toMilliseconds(d4) {
    if (d4.d_ms === "forever") {
      return Number.MAX_VALUE;
    }
    return d4.d_ms;
  }
  Duration2.toMilliseconds = toMilliseconds;
  function getRemaining(deadline, now = AbsoluteTime.now()) {
    if (deadline.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (now.t_ms === "never") {
      throw Error("invalid argument for 'now'");
    }
    if (deadline.t_ms < now.t_ms) {
      return { d_ms: 0 };
    }
    return { d_ms: deadline.t_ms - now.t_ms };
  }
  Duration2.getRemaining = getRemaining;
  function fromPrettyString(s4) {
    let dMs = 0;
    let currentNum = "";
    let parsingNum = true;
    for (let i4 = 0; i4 < s4.length; i4++) {
      const cc = s4.charCodeAt(i4);
      if (cc >= "0".charCodeAt(0) && cc <= "9".charCodeAt(0)) {
        if (!parsingNum) {
          throw Error("invalid duration, unexpected number");
        }
        currentNum += s4[i4];
        continue;
      }
      if (s4[i4] == " ") {
        if (currentNum != "") {
          parsingNum = false;
        }
        continue;
      }
      if (currentNum == "") {
        throw Error("invalid duration, missing number");
      }
      if (s4[i4] === "s") {
        if (s4.startsWith("seconds", i4)) {
          i4 += "seconds".length - 1;
        }
        dMs += 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "m") {
        if (s4.startsWith("minutes", i4)) {
          i4 += "minutes".length - 1;
        }
        dMs += 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "h") {
        if (s4.startsWith("hours", i4)) {
          i4 += "hours".length - 1;
        }
        dMs += 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "d") {
        if (s4.startsWith("days", i4)) {
          i4 += "days".length - 1;
        }
        dMs += 24 * 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else {
        throw Error("invalid duration, unsupported unit");
      }
      currentNum = "";
      parsingNum = true;
    }
    return {
      d_ms: dMs
    };
  }
  Duration2.fromPrettyString = fromPrettyString;
  function cmp(d1, d23) {
    if (d1.d_ms === "forever") {
      if (d23.d_ms === "forever") {
        return 0;
      }
      return 1;
    }
    if (d23.d_ms === "forever") {
      return -1;
    }
    if (d1.d_ms == d23.d_ms) {
      return 0;
    }
    if (d1.d_ms > d23.d_ms) {
      return 1;
    }
    return -1;
  }
  Duration2.cmp = cmp;
  function add4(d1, d23) {
    if (d1.d_ms === "forever") {
      return Duration2.getForever();
    }
    if (d23.d_ms === "forever") {
      return Duration2.getForever();
    }
    return Duration2.fromMilliseconds(d1.d_ms + d23.d_ms);
  }
  Duration2.add = add4;
  function max(d1, d23) {
    return durationMax(d1, d23);
  }
  Duration2.max = max;
  function min(d1, d23) {
    return durationMin(d1, d23);
  }
  Duration2.min = min;
  function multiply(d1, n2) {
    return durationMul(d1, n2);
  }
  Duration2.multiply = multiply;
  function toIntegerYears(d4) {
    if (typeof d4.d_ms !== "number") {
      throw Error("infinite duration");
    }
    return Math.ceil(d4.d_ms / 1e3 / 60 / 60 / 24 / 365);
  }
  Duration2.toIntegerYears = toIntegerYears;
  function fromSpec(spec) {
    let d_ms = 0;
    d_ms += (spec.seconds ?? 0) * SECONDS;
    d_ms += (spec.minutes ?? 0) * MINUTES;
    d_ms += (spec.hours ?? 0) * HOURS;
    d_ms += (spec.days ?? 0) * DAYS;
    d_ms += (spec.months ?? 0) * MONTHS;
    d_ms += (spec.years ?? 0) * YEARS;
    return { d_ms };
  }
  Duration2.fromSpec = fromSpec;
  function fromSpecOrUndefined(spec) {
    if (spec.seconds == void 0 && spec.minutes == void 0 && spec.hours == void 0 && spec.days == void 0 && spec.months == void 0 && spec.years == void 0) {
      return void 0;
    }
    return Duration2.fromSpec(spec);
  }
  Duration2.fromSpecOrUndefined = fromSpecOrUndefined;
  function toSpec({ d_ms }) {
    if (d_ms === "forever")
      return void 0;
    const ms = d_ms > 0 ? d_ms : 0;
    const Y_rest = ms % YEARS;
    const M_rest = Y_rest % MONTHS;
    const D_rest = M_rest % DAYS;
    const h_rest = D_rest % HOURS;
    const m_rest = h_rest % MINUTES;
    const millis = m_rest % SECONDS;
    return {
      years: (ms - Y_rest) / YEARS,
      month: (Y_rest - M_rest) / MONTHS,
      days: (M_rest - D_rest) / DAYS,
      hours: (D_rest - h_rest) / HOURS,
      minutes: (h_rest - m_rest) / MINUTES,
      seconds: (m_rest - millis) / SECONDS
    };
  }
  Duration2.toSpec = toSpec;
  function getForever() {
    return { d_ms: "forever" };
  }
  Duration2.getForever = getForever;
  function getZero() {
    return { d_ms: 0 };
  }
  Duration2.getZero = getZero;
  function fromTalerProtocolDuration(d4) {
    if (d4.d_us === "forever") {
      return {
        d_ms: "forever"
      };
    }
    return {
      d_ms: Math.floor(d4.d_us / 1e3)
    };
  }
  Duration2.fromTalerProtocolDuration = fromTalerProtocolDuration;
  function toTalerProtocolDuration(d4) {
    if (d4.d_ms === "forever") {
      return {
        d_us: "forever"
      };
    }
    return {
      d_us: d4.d_ms * 1e3
    };
  }
  Duration2.toTalerProtocolDuration = toTalerProtocolDuration;
  function fromMilliseconds(ms) {
    return {
      d_ms: ms
    };
  }
  Duration2.fromMilliseconds = fromMilliseconds;
  function clamp(args) {
    return durationMax(durationMin(args.value, args.upper), args.lower);
  }
  Duration2.clamp = clamp;
})(Duration || (Duration = {}));
var AbsoluteTime;
(function(AbsoluteTime3) {
  function getStampMsNow() {
    return (/* @__PURE__ */ new Date()).getTime();
  }
  AbsoluteTime3.getStampMsNow = getStampMsNow;
  function getStampMsNever() {
    return Number.MAX_SAFE_INTEGER;
  }
  AbsoluteTime3.getStampMsNever = getStampMsNever;
  function now() {
    return {
      t_ms: (/* @__PURE__ */ new Date()).getTime() + timeshift,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.now = now;
  function zero() {
    return {
      t_ms: 0,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.zero = zero;
  function never() {
    return {
      t_ms: "never",
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.never = never;
  function fromMilliseconds(ms) {
    return {
      t_ms: ms,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromMilliseconds = fromMilliseconds;
  function cmp(t1, t22) {
    if (t1.t_ms === "never") {
      if (t22.t_ms === "never") {
        return 0;
      }
      return 1;
    }
    if (t22.t_ms === "never") {
      return -1;
    }
    if (t1.t_ms == t22.t_ms) {
      return 0;
    }
    if (t1.t_ms > t22.t_ms) {
      return 1;
    }
    return -1;
  }
  AbsoluteTime3.cmp = cmp;
  function min(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.min(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.min = min;
  function max(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.max = max;
  function difference(t1, t22) {
    if (t1.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (t22.t_ms === "never") {
      return { d_ms: "forever" };
    }
    return { d_ms: Math.abs(t1.t_ms - t22.t_ms) };
  }
  AbsoluteTime3.difference = difference;
  function isExpired(t4) {
    return cmp(t4, now()) <= 0;
  }
  AbsoluteTime3.isExpired = isExpired;
  function isNever(t4) {
    return t4.t_ms === "never";
  }
  AbsoluteTime3.isNever = isNever;
  function fromProtocolTimestamp(t4) {
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return {
      t_ms: t4.t_s * 1e3,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromProtocolTimestamp = fromProtocolTimestamp;
  function fromStampMs(stampMs) {
    return {
      t_ms: stampMs,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromStampMs = fromStampMs;
  function fromPreciseTimestamp(t4) {
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    const offsetUs = t4.off_us ?? 0;
    return {
      t_ms: t4.t_s * 1e3 + Math.floor(offsetUs / 1e3),
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromPreciseTimestamp = fromPreciseTimestamp;
  function toStampMs(at2) {
    if (at2.t_ms === "never") {
      return Number.MAX_SAFE_INTEGER;
    }
    return at2.t_ms;
  }
  AbsoluteTime3.toStampMs = toStampMs;
  function toPreciseTimestamp(at2) {
    if (at2.t_ms == "never") {
      return {
        t_s: "never"
      };
    }
    const t_s = Math.floor(at2.t_ms / 1e3);
    const off_us = Math.floor(1e3 * (at2.t_ms - t_s * 1e3));
    return {
      t_s,
      off_us
    };
  }
  AbsoluteTime3.toPreciseTimestamp = toPreciseTimestamp;
  function toProtocolTimestamp(at2) {
    if (at2.t_ms === "never") {
      return { t_s: "never" };
    }
    return {
      t_s: Math.floor(at2.t_ms / 1e3)
    };
  }
  AbsoluteTime3.toProtocolTimestamp = toProtocolTimestamp;
  function isBetween(t4, start, end) {
    if (cmp(t4, start) < 0) {
      return false;
    }
    if (cmp(t4, end) > 0) {
      return false;
    }
    return true;
  }
  AbsoluteTime3.isBetween = isBetween;
  function toIsoString(t4) {
    if (t4.t_ms === "never") {
      return "<never>";
    } else {
      return new Date(t4.t_ms).toISOString();
    }
  }
  AbsoluteTime3.toIsoString = toIsoString;
  function addDuration(t1, d4) {
    if (t1.t_ms === "never" || d4.d_ms === "forever") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: t1.t_ms + d4.d_ms, [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.addDuration = addDuration;
  function remaining(t1) {
    if (t1.t_ms === "never") {
      return Duration.getForever();
    }
    const stampNow = now();
    if (stampNow.t_ms === "never") {
      throw Error("invariant violated");
    }
    return Duration.fromMilliseconds(Math.max(0, t1.t_ms - stampNow.t_ms));
  }
  AbsoluteTime3.remaining = remaining;
  function subtractDuraction(t1, d4) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (d4.d_ms === "forever") {
      return { t_ms: 0, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(0, t1.t_ms - d4.d_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.subtractDuraction = subtractDuraction;
  function stringify(t4) {
    if (t4.t_ms === "never") {
      return "never";
    }
    return new Date(t4.t_ms).toISOString();
  }
  AbsoluteTime3.stringify = stringify;
})(AbsoluteTime || (AbsoluteTime = {}));
var SECONDS = 1e3;
var MINUTES = SECONDS * 60;
var HOURS = MINUTES * 60;
var DAYS = HOURS * 24;
var MONTHS = DAYS * 30;
var YEARS = DAYS * 365;
function durationMin(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: d23.d_ms };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: d1.d_ms };
  }
  return { d_ms: Math.min(d1.d_ms, d23.d_ms) };
}
function durationMax(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.max(d1.d_ms, d23.d_ms) };
}
function durationMul(d4, n2) {
  if (d4.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.round(d4.d_ms * n2) };
}
var codecForAbsoluteTime = {
  decode(x5, c4) {
    if (x5 === void 0) {
      throw Error(`got undefined and expected absolute time at ${renderContext(c4)}`);
    }
    const t_ms = x5.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_ms: "never", [opaque_AbsoluteTime]: true };
      }
    } else if (typeof t_ms === "number") {
      return { t_ms, [opaque_AbsoluteTime]: true };
    }
    throw Error(`expected timestamp at ${renderContext(c4)}`);
  }
};
var codecForTimestamp = {
  decode(x5, c4) {
    if (x5 === void 0) {
      throw Error(`got undefined and expected timestamp at ${renderContext(c4)}`);
    }
    const t_ms = x5.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    const t_s = x5.t_s;
    if (typeof t_s === "string") {
      if (t_s === "never") {
        return { t_s: "never" };
      }
      throw Error(`expected timestamp at ${renderContext(c4)}`);
    }
    if (typeof t_s === "number") {
      return { t_s };
    }
    throw Error(`expected protocol timestamp at ${renderContext(c4)}`);
  }
};
var codecForDuration = {
  decode(x5, c4) {
    const d_us = x5.d_us;
    if (typeof d_us === "string") {
      if (d_us === "forever") {
        return { d_us: "forever" };
      }
      throw Error(`expected duration at ${renderContext(c4)}`);
    }
    if (typeof d_us === "number") {
      return { d_us };
    }
    throw Error(`expected duration at ${renderContext(c4)}`);
  }
};

// ../taler-util/lib/http-common.js
var textEncoder = new TextEncoder();
var logger2 = new Logger("http.ts");
var DEFAULT_REQUEST_TIMEOUT_MS = 6e4;
var HeadersImpl = class {
  constructor() {
    this.headerMap = /* @__PURE__ */ new Map();
  }
  get(name) {
    const r3 = this.headerMap.get(name.toLowerCase());
    if (r3) {
      return r3;
    }
    return null;
  }
  set(name, value) {
    const normalizedName = name.toLowerCase();
    const existing = this.headerMap.get(normalizedName);
    if (existing !== void 0) {
      this.headerMap.set(normalizedName, existing + "," + value);
    } else {
      this.headerMap.set(normalizedName, value);
    }
  }
  toJSON() {
    const m4 = {};
    this.headerMap.forEach((v3, k5) => m4[k5] = v3);
    return m4;
  }
};
async function readTalerErrorResponse(httpResponse) {
  const contentType = httpResponse.headers.get("content-type");
  if (contentType !== "application/json") {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      contentType: contentType || "<null>"
    }, "Error response did not even contain JSON. The request URL might be wrong or the service might be unavailable.");
  }
  let errJson;
  try {
    errJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from error response");
  }
  const talerErrorCode = errJson.code;
  if (typeof talerErrorCode !== "number") {
    logger2.warn(`malformed error response (status ${httpResponse.status}): ${j2s(errJson)}`);
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text()
    }, "Error response did not contain error code");
  }
  return errJson;
}
async function readSuccessResponseJsonOrErrorCode(httpResponse, codec) {
  if (!(httpResponse.status >= 200 && httpResponse.status < 300)) {
    return {
      isError: true,
      talerErrorResponse: await readTalerErrorResponse(httpResponse)
    };
  }
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Response invalid");
  }
  return {
    isError: false,
    response: parsedResponse
  };
}
async function readResponseJsonOrThrow(httpResponse, codec) {
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Response invalid");
  }
  return parsedResponse;
}
function throwUnexpectedRequestError(httpResponse, talerErrorResponse) {
  const errorDetails = {
    requestUrl: httpResponse.requestUrl,
    requestMethod: httpResponse.requestMethod,
    httpStatusCode: httpResponse.status,
    errorResponse: talerErrorResponse
  };
  logger2.trace(`unexpected request error: ${j2s(errorDetails)}`);
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, errorDetails, `Unexpected HTTP status ${httpResponse.status} in response`);
}
async function readSuccessResponseJsonOrThrow(httpResponse, codec) {
  const r3 = await readSuccessResponseJsonOrErrorCode(httpResponse, codec);
  if (!r3.isError) {
    return r3.response;
  }
  throwUnexpectedRequestError(httpResponse, r3.talerErrorResponse);
}
function encodeBody(body) {
  if (body == null) {
    return new ArrayBuffer(0);
  }
  if (typeof body === "string") {
    return textEncoder.encode(body).buffer;
  } else if (ArrayBuffer.isView(body)) {
    return body.buffer;
  } else if (body instanceof ArrayBuffer) {
    return body;
  } else if (body instanceof URLSearchParams) {
    return textEncoder.encode(body.toString()).buffer;
  } else if (typeof body === "object" && body.constructor.name === "FormData") {
    return body;
  } else if (typeof body === "object") {
    return textEncoder.encode(JSON.stringify(body)).buffer;
  }
  throw new TypeError("unsupported request body type");
}
function getDefaultHeaders(method) {
  const headers = {};
  if (method === "POST" || method === "PUT" || method === "PATCH") {
    headers["Content-Type"] = "application/json";
  }
  headers["Accept"] = "application/json";
  return headers;
}
function makeBasicAuthHeader(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}

// ../taler-util/lib/libtool-version.js
var LibtoolVersion;
(function(LibtoolVersion2) {
  function compare2(me, other) {
    const meVer = parseVersion(me);
    const otherVer = parseVersion(other);
    if (!(meVer && otherVer)) {
      return void 0;
    }
    const compatible = meVer.current - meVer.age <= otherVer.current && meVer.current >= otherVer.current - otherVer.age;
    const currentCmp = Math.sign(meVer.current - otherVer.current);
    return { compatible, currentCmp };
  }
  LibtoolVersion2.compare = compare2;
  function parseVersionOrThrow(v3) {
    const res = parseVersion(v3);
    if (!res) {
      throw Error("invalid libtool version");
    }
    return res;
  }
  LibtoolVersion2.parseVersionOrThrow = parseVersionOrThrow;
  function parseVersion(v3) {
    const [currentStr, revisionStr, ageStr, ...rest] = v3.split(":");
    if (rest.length !== 0) {
      return void 0;
    }
    const current = Number.parseInt(currentStr);
    const revision = Number.parseInt(revisionStr);
    const age = Number.parseInt(ageStr);
    if (Number.isNaN(current)) {
      return void 0;
    }
    if (Number.isNaN(revision)) {
      return void 0;
    }
    if (Number.isNaN(age)) {
      return void 0;
    }
    return { current, revision, age };
  }
  LibtoolVersion2.parseVersion = parseVersion;
})(LibtoolVersion || (LibtoolVersion = {}));

// ../taler-util/lib/types-taler-common.js
var codecForURLString = codecForString;
var codecForCurrencyName = codecForString;
var codecForDecimalNumber = codecForString;
var codecForEddsaPublicKey = codecForString;
var codecForEddsaSignature = codecForString;
var codecForInternationalizedString = () => codecForMap(codecForString());
var codecForCurrencySpecificiation = () => buildCodecForObject().property("name", codecForString()).property("num_fractional_input_digits", codecForNumber()).property("num_fractional_normal_digits", codecForNumber()).property("num_fractional_trailing_zero_digits", codecForNumber()).property("alt_unit_names", codecForMap(codecForString())).property("common_amounts", codecOptional(codecForList(codecForAmountString()))).deprecatedProperty("currency").build("CurrencySpecification");
var codecForTalerCommonConfigResponse = () => buildCodecForObject().allowExtra().property("name", codecForString()).property("version", codecForString()).build("TalerCommonConfigResponse");
var ExchangeProtocolVersion;
(function(ExchangeProtocolVersion2) {
  ExchangeProtocolVersion2[ExchangeProtocolVersion2["V12"] = 12] = "V12";
})(ExchangeProtocolVersion || (ExchangeProtocolVersion = {}));
var MerchantProtocolVersion;
(function(MerchantProtocolVersion2) {
  MerchantProtocolVersion2[MerchantProtocolVersion2["V3"] = 3] = "V3";
})(MerchantProtocolVersion || (MerchantProtocolVersion = {}));
var codecForTokenInfo = () => buildCodecForObject().property("creation_time", codecForTimestamp).property("expiration", codecForTimestamp).property("scope", codecForString()).property("refreshable", codecForBoolean()).property("description", codecOptional(codecForString())).property("serial", codecForNumber()).build("TokenInfo");
var codecForTokenInfoList = () => buildCodecForObject().property("tokens", codecForList(codecForTokenInfo())).build("TokenInfoList");
var codecForAccessToken = codecForString;
var codecForTokenSuccessResponse = () => buildCodecForObject().property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).build("TalerAuthentication.TokenSuccessResponse");
var codecForURN = codecForString;

// ../taler-util/lib/operation.js
function isOperationOk(c4) {
  return c4.type === "ok";
}
function isOperationFail(c4) {
  return c4.type === "fail";
}
async function opSuccessFromHttp(resp, codec) {
  const body = await readSuccessResponseJsonOrThrow(resp, codec);
  return { type: "ok", case: "ok", body };
}
function opFixedSuccess(body) {
  return { type: "ok", case: "ok", body };
}
function opEmptySuccess() {
  return { type: "ok", case: "ok", body: void 0 };
}
function opKnownFailure(case_) {
  return { type: "fail", case: case_ };
}
function opKnownFailureWithBody(case_, body) {
  return { type: "fail", case: case_, body };
}
async function carefullyParseConfig(expectedName, clientVersion, httpResponse, codec) {
  const minBody = await readSuccessResponseJsonOrThrow(httpResponse, codecForTalerCommonConfigResponse());
  if (minBody.name !== expectedName) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_UNEXPECTED_REQUEST_ERROR,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unexpected server component name (got ${minBody.name}, expected ${expectedName}})`
    });
  }
  if (!LibtoolVersion.compare(clientVersion, minBody.version)) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unsupported protocol version, client supports ${clientVersion}, server supports ${minBody.version}`
    });
  }
  const body = await readSuccessResponseJsonOrThrow(httpResponse, codec);
  return opFixedSuccess(body);
}
async function opKnownAlternativeHttpFailure(resp, s4, codec) {
  const body = await readResponseJsonOrThrow(resp, codec);
  return { type: "fail", case: s4, body };
}
async function opKnownHttpFailure(_case, resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  return { type: "fail", case: _case, detail };
}
async function opUnknownHttpFailure(resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: resp.requestUrl,
    requestMethod: resp.requestMethod,
    httpStatusCode: resp.status,
    errorResponse: detail
  }, `Unexpected HTTP status ${resp.status} in response`);
}
function opKnownTalerFailure(_case, detail) {
  return { type: "fail", case: _case, detail };
}
function opUnknownFailure(error2) {
  throw TalerError.fromException(error2);
}
function succeedOrThrow(resp) {
  if (isOperationOk(resp)) {
    return resp.body;
  }
  if (isOperationFail(resp)) {
    throw TalerError.fromUncheckedDetail({ ...resp, case: resp.case });
  }
  throw TalerError.fromException(resp);
}

// ../taler-util/lib/amounts.js
var amountFractionalBase = 1e8;
var amountFractionalLength = 8;
var amountMaxValue = 2 ** 52;
var FRAC_SEPARATOR = ".";
var CURRENCY_SEPARATOR = ":";
var Amount = class _Amount {
  static from(a4) {
    return new _Amount(Amounts.parseOrThrow(a4), 0);
  }
  static zeroOfCurrency(currency) {
    return new _Amount(Amounts.zeroOfCurrency(currency), 0);
  }
  add(...a4) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.add(this.val, ...a4);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  isZero() {
    return this.val.fraction === 0 && this.val.value === 0;
  }
  sub(...a4) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.sub(this.val, ...a4);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  mult(n2) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.mult(this, n2);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  toJson() {
    return { ...this.val };
  }
  toString() {
    return Amounts.stringify(this.val);
  }
  constructor(val, saturated) {
    this.val = val;
    this.saturated = saturated;
  }
};
function codecForAmountString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (Amounts.parse(x5) === void 0) {
        throw new DecodingError(`invalid amount at ${renderContext(c4)} got "${x5}"`);
      }
      return x5;
    }
  };
}
var AmountParseError;
(function(AmountParseError2) {
  AmountParseError2[AmountParseError2["MISSING_CURRENCY"] = 0] = "MISSING_CURRENCY";
  AmountParseError2[AmountParseError2["CURRENCY_TOO_LONG"] = 1] = "CURRENCY_TOO_LONG";
  AmountParseError2[AmountParseError2["BAD_CURRENCY"] = 2] = "BAD_CURRENCY";
  AmountParseError2[AmountParseError2["BAD_NUMBER"] = 3] = "BAD_NUMBER";
  AmountParseError2[AmountParseError2["TOO_HIGH"] = 4] = "TOO_HIGH";
  AmountParseError2[AmountParseError2["TOO_PRECISE"] = 5] = "TOO_PRECISE";
})(AmountParseError || (AmountParseError = {}));
var Amounts = class _Amounts {
  constructor() {
    throw Error("not instantiable");
  }
  static currencyOf(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return amt.currency;
  }
  static zeroOfAmount(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return {
      currency: amt.currency,
      fraction: 0,
      value: 0
    };
  }
  /**
   * Get an amount that represents zero units of a currency.
   */
  static zeroOfCurrency(currency) {
    return {
      currency,
      fraction: 0,
      value: 0
    };
  }
  static jsonifyAmount(amt) {
    if (typeof amt === "string") {
      return _Amounts.parseOrThrow(amt);
    }
    if (amt instanceof Amount) {
      return amt.toJson();
    }
    return amt;
  }
  static divmod(a1, a23) {
    const am1 = _Amounts.jsonifyAmount(a1);
    const am2 = _Amounts.jsonifyAmount(a23);
    if (am1.currency != am2.currency) {
      throw Error(`incompatible currency (${am1.currency} vs${am2.currency})`);
    }
    const x1 = BigInt(am1.value) * BigInt(amountFractionalBase) + BigInt(am1.fraction);
    const x22 = BigInt(am2.value) * BigInt(amountFractionalBase) + BigInt(am2.fraction);
    const quotient = x1 / x22;
    const remainderScaled = x1 % x22;
    return {
      quotient: Number(quotient),
      remainder: {
        currency: am1.currency,
        value: Number(remainderScaled / BigInt(amountFractionalBase)),
        fraction: Number(remainderScaled % BigInt(amountFractionalBase))
      }
    };
  }
  static sum(amounts) {
    if (amounts.length <= 0) {
      throw Error("can't sum zero amounts");
    }
    const jsonAmounts = amounts.map((x5) => _Amounts.jsonifyAmount(x5));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  static sumOrZero(currency, amounts) {
    if (amounts.length <= 0) {
      return {
        amount: _Amounts.zeroOfCurrency(currency),
        saturated: false
      };
    }
    const jsonAmounts = amounts.map((x5) => _Amounts.jsonifyAmount(x5));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  /**
   * Add two amounts.  Return the result and whether
   * the addition overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static add(first, ...rest) {
    const firstJ = _Amounts.jsonifyAmount(first);
    const currency = firstJ.currency;
    let value = firstJ.value + Math.floor(firstJ.fraction / amountFractionalBase);
    if (value > amountMaxValue) {
      return {
        amount: {
          currency,
          value: amountMaxValue,
          fraction: amountFractionalBase - 1
        },
        saturated: true
      };
    }
    let fraction = firstJ.fraction % amountFractionalBase;
    for (const x5 of rest) {
      const xJ = _Amounts.jsonifyAmount(x5);
      if (xJ.currency.toUpperCase() !== currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${xJ.currency} and ${currency}`);
      }
      value = value + xJ.value + Math.floor((fraction + xJ.fraction) / amountFractionalBase);
      fraction = Math.floor((fraction + xJ.fraction) % amountFractionalBase);
      if (value > amountMaxValue) {
        return {
          amount: {
            currency,
            value: amountMaxValue,
            fraction: amountFractionalBase - 1
          },
          saturated: true
        };
      }
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Subtract two amounts.  Return the result and whether
   * the subtraction overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static sub(a4, ...rest) {
    const aJ = _Amounts.jsonifyAmount(a4);
    const currency = aJ.currency;
    let value = aJ.value;
    let fraction = aJ.fraction;
    for (const b4 of rest) {
      const bJ = _Amounts.jsonifyAmount(b4);
      if (bJ.currency.toUpperCase() !== aJ.currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${bJ.currency} and ${currency}`);
      }
      if (fraction < bJ.fraction) {
        if (value < 1) {
          return {
            amount: { currency, value: 0, fraction: 0 },
            saturated: true
          };
        }
        value--;
        fraction += amountFractionalBase;
      }
      console.assert(fraction >= bJ.fraction);
      fraction -= bJ.fraction;
      if (value < bJ.value) {
        return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
      }
      value -= bJ.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Compare two amounts.  Returns 0 when equal, -1 when a < b
   * and +1 when a > b.  Throws when currencies don't match.
   */
  static cmp(a4, b4) {
    a4 = _Amounts.jsonifyAmount(a4);
    b4 = _Amounts.jsonifyAmount(b4);
    if (a4.currency !== b4.currency) {
      throw Error(`Mismatched currency: ${a4.currency} and ${b4.currency}`);
    }
    const av = a4.value + Math.floor(a4.fraction / amountFractionalBase);
    const af = a4.fraction % amountFractionalBase;
    const bv = b4.value + Math.floor(b4.fraction / amountFractionalBase);
    const bf = b4.fraction % amountFractionalBase;
    switch (true) {
      case av < bv:
        return -1;
      case av > bv:
        return 1;
      case af < bf:
        return -1;
      case af > bf:
        return 1;
      case af === bf:
        return 0;
      default:
        throw Error("assertion failed");
    }
  }
  /**
   * Create a copy of an amount.
   */
  static copy(a4) {
    return {
      currency: a4.currency,
      fraction: a4.fraction,
      value: a4.value
    };
  }
  /**
   * Divide an amount.  Throws on division by zero.
   */
  static divide(a4, n2) {
    if (n2 === 0) {
      throw Error(`Division by 0`);
    }
    if (n2 === 1) {
      return { value: a4.value, fraction: a4.fraction, currency: a4.currency };
    }
    const r3 = a4.value % n2;
    return {
      currency: a4.currency,
      fraction: Math.floor((r3 * amountFractionalBase + a4.fraction) / n2),
      value: Math.floor(a4.value / n2)
    };
  }
  /**
   * Check if an amount is non-zero.
   */
  static isNonZero(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    return a4.value > 0 || a4.fraction > 0;
  }
  static isZero(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    return a4.value === 0 && a4.fraction === 0;
  }
  /**
   * Check whether a string is a valid currency for a Taler amount.
   */
  static isCurrency(s4) {
    return /^[a-zA-Z]{1,11}$/.test(s4);
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parseWithError(s4) {
    const c_idx = s4.indexOf(CURRENCY_SEPARATOR);
    if (c_idx === -1 || c_idx === 0) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    if (c_idx > 11) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    const currency = s4.substring(0, c_idx).toUpperCase();
    if (!/^[a-zA-Z]+$/.test(currency)) {
      return opKnownFailure(AmountParseError.BAD_CURRENCY);
    }
    const number = s4.substring(c_idx + 1);
    const d_idx = number.indexOf(FRAC_SEPARATOR);
    const integerStr = d_idx === -1 ? number : number.substring(0, d_idx);
    const fractStr = d_idx === -1 || d_idx === number.length ? "0" : number.substring(d_idx + 1);
    if (!/^[0-9]+$/.test(integerStr) || !/^[0-9]+$/.test(fractStr)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    const value = Number.parseInt(integerStr, 10);
    const fraction = Math.round(amountFractionalBase * Number.parseFloat(FRAC_SEPARATOR + fractStr));
    if (!Number.isInteger(value) || !Number.isInteger(fraction)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    if (value > amountMaxValue) {
      return opKnownFailure(AmountParseError.TOO_HIGH);
    }
    if (fractStr.length > amountFractionalLength) {
      return opKnownFailure(AmountParseError.TOO_PRECISE);
    }
    return opFixedSuccess({
      currency,
      fraction,
      value
    });
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parse(s4) {
    const res = s4.match(/^([a-zA-Z]{1,11}):([0-9]+)([.][0-9]{1,8})?$/);
    if (!res) {
      return void 0;
    }
    const tail = res[3] || FRAC_SEPARATOR + "0";
    if (tail.length > amountFractionalLength + 1) {
      return void 0;
    }
    const value = Number.parseInt(res[2]);
    if (value > amountMaxValue) {
      return void 0;
    }
    return {
      currency: res[1].toUpperCase(),
      fraction: Math.round(amountFractionalBase * Number.parseFloat(tail)),
      value
    };
  }
  /**
   * Parse amount in standard string form (like 'EUR:20.5'),
   * throw if the input is not a valid amount.
   */
  static parseOrThrow(s4) {
    if (s4 instanceof Amount) {
      return s4.toJson();
    }
    if (typeof s4 === "object") {
      if (typeof s4.currency !== "string") {
        throw Error("invalid amount object");
      }
      if (typeof s4.value !== "number") {
        throw Error("invalid amount object");
      }
      if (typeof s4.fraction !== "number") {
        throw Error("invalid amount object");
      }
      return { currency: s4.currency, value: s4.value, fraction: s4.fraction };
    } else if (typeof s4 === "string") {
      const res = _Amounts.parse(s4);
      if (!res) {
        throw Error(`Can't parse amount: "${s4}"`);
      }
      return res;
    } else {
      throw Error("invalid amount (illegal type)");
    }
  }
  static min(a4, b4) {
    const cr = _Amounts.cmp(a4, b4);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(b4);
    } else {
      return _Amounts.jsonifyAmount(a4);
    }
  }
  static max(a4, b4) {
    const cr = _Amounts.cmp(a4, b4);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(a4);
    } else {
      return _Amounts.jsonifyAmount(b4);
    }
  }
  static mult(a4, n2) {
    a4 = this.jsonifyAmount(a4);
    if (!Number.isInteger(n2)) {
      throw Error("amount can only be multiplied by an integer");
    }
    if (n2 < 0) {
      throw Error("amount can only be multiplied by a positive integer");
    }
    if (n2 == 0) {
      return {
        amount: _Amounts.zeroOfCurrency(a4.currency),
        saturated: false
      };
    }
    let x5 = a4;
    let acc = _Amounts.zeroOfCurrency(a4.currency);
    while (n2 > 1) {
      if (n2 % 2 == 0) {
        n2 = n2 / 2;
      } else {
        n2 = (n2 - 1) / 2;
        const r23 = _Amounts.add(acc, x5);
        if (r23.saturated) {
          return r23;
        }
        acc = r23.amount;
      }
      const r22 = _Amounts.add(x5, x5);
      if (r22.saturated) {
        return r22;
      }
      x5 = r22.amount;
    }
    return _Amounts.add(acc, x5);
  }
  /**
   * Check if the argument is a valid amount in string form.
   */
  static check(a4) {
    if (typeof a4 !== "string") {
      return false;
    }
    try {
      const parsedAmount = _Amounts.parse(a4);
      return !!parsedAmount;
    } catch {
      return false;
    }
  }
  /**
   * Convert to standard human-readable string representation that's
   * also used in JSON formats.
   */
  static stringify(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    const s4 = this.stringifyValue(a4);
    return `${a4.currency}:${s4}`;
  }
  /**
   * Show an amount in a form suitable for the user.
   * FIXME:  In the future, this should consider currency-specific
   * settings such as significant digits or currency symbols.
   */
  static toPretty(amount) {
    const x5 = amount.value + amount.fraction / amountFractionalBase;
    return `${x5} ${amount.currency}`;
  }
  static amountHasSameCurrency(a1, a23) {
    const x1 = this.jsonifyAmount(a1);
    const x22 = this.jsonifyAmount(a23);
    return x1.currency.toUpperCase() === x22.currency.toUpperCase();
  }
  static isSameCurrency(curr1, curr2) {
    return curr1.toLowerCase() === curr2.toLowerCase();
  }
  static stringifyValue(a4, minFractional = 0) {
    const aJ = _Amounts.jsonifyAmount(a4);
    const av = aJ.value + Math.floor(aJ.fraction / amountFractionalBase);
    const af = aJ.fraction % amountFractionalBase;
    let s4 = av.toString();
    if (af || minFractional) {
      s4 = s4 + FRAC_SEPARATOR;
      let n2 = af;
      for (let i4 = 0; i4 < amountFractionalLength; i4++) {
        if (!n2 && i4 >= minFractional) {
          break;
        }
        s4 = s4 + Math.floor(n2 / amountFractionalBase * 10).toString();
        n2 = n2 * 10 % amountFractionalBase;
      }
    }
    return s4;
  }
  /**
   * Number of fractional digits needed to fully represent the amount
   * @param a amount
   * @returns
   */
  static maxFractionalDigits(a4) {
    if (a4.fraction === 0)
      return 0;
    if (a4.fraction < 0) {
      console.error("amount fraction can not be negative", a4);
      return 0;
    }
    let i4 = 0;
    let check = true;
    let rest = a4.fraction;
    while (rest > 0 && check) {
      check = rest % 10 === 0;
      rest = rest / 10;
      i4++;
    }
    return amountFractionalLength - i4 + 1;
  }
  static stringifyValueWithSpec(value, spec) {
    const strValue = _Amounts.stringifyValue(value);
    const pos = strValue.indexOf(FRAC_SEPARATOR);
    const originalPosition = pos < 0 ? strValue.length : pos;
    let currency = value.currency;
    const names2 = Object.keys(spec.alt_unit_names);
    let FRAC_POS_NEW_POSITION = originalPosition;
    if (names2.length > 0) {
      let unitIndex = "0";
      names2.forEach((index) => {
        const i4 = Number.parseInt(index, 10);
        if (Number.isNaN(i4))
          return;
        if (originalPosition - i4 <= 0)
          return;
        if (originalPosition - i4 < FRAC_POS_NEW_POSITION) {
          FRAC_POS_NEW_POSITION = originalPosition - i4;
          unitIndex = index;
        }
      });
      currency = spec.alt_unit_names[unitIndex];
    }
    if (originalPosition === FRAC_POS_NEW_POSITION) {
      const { normal: normal2, small: small2 } = splitNormalAndSmall(strValue, originalPosition, spec);
      return { currency, normal: normal2, small: small2 };
    }
    const intPart = strValue.substring(0, originalPosition);
    const fracPArt = strValue.substring(originalPosition + 1);
    const newValue = intPart.substring(0, FRAC_POS_NEW_POSITION) + FRAC_SEPARATOR + intPart.substring(FRAC_POS_NEW_POSITION) + fracPArt;
    const { normal, small } = splitNormalAndSmall(newValue, FRAC_POS_NEW_POSITION, spec);
    return { currency, normal, small };
  }
};
function splitNormalAndSmall(decimal, fracSeparatorIndex, spec) {
  let normal;
  let small;
  if (decimal.length - fracSeparatorIndex - 1 > spec.num_fractional_normal_digits) {
    const limit = fracSeparatorIndex + spec.num_fractional_normal_digits + 1;
    normal = decimal.substring(0, limit);
    small = decimal.substring(limit);
  } else {
    normal = decimal;
    small = void 0;
  }
  return { normal, small };
}

// ../taler-util/lib/http-impl.missing.js
var HttpLibImpl = class {
  fetch(url, opt) {
    throw new Error("Method not implemented.");
  }
};

// ../taler-util/lib/http.js
function createPlatformHttpLib(args) {
  return new HttpLibImpl(args);
}

// ../taler-util/lib/bank-api-client.js
var logger3 = new Logger("bank-api-client.ts");
var CreditDebitIndicator;
(function(CreditDebitIndicator2) {
  CreditDebitIndicator2["Credit"] = "credit";
  CreditDebitIndicator2["Debit"] = "debit";
})(CreditDebitIndicator || (CreditDebitIndicator = {}));

// ../taler-util/lib/base64.js
function base64FromArrayBuffer(arrayBuffer) {
  var base64 = "";
  var encodings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var bytes = new Uint8Array(arrayBuffer);
  var byteLength = bytes.byteLength;
  var byteRemainder = byteLength % 3;
  var mainLength = byteLength - byteRemainder;
  var a4, b4, c4, d4;
  var chunk;
  for (var i4 = 0; i4 < mainLength; i4 = i4 + 3) {
    chunk = bytes[i4] << 16 | bytes[i4 + 1] << 8 | bytes[i4 + 2];
    a4 = (chunk & 16515072) >> 18;
    b4 = (chunk & 258048) >> 12;
    c4 = (chunk & 4032) >> 6;
    d4 = chunk & 63;
    base64 += encodings[a4] + encodings[b4] + encodings[c4] + encodings[d4];
  }
  if (byteRemainder == 1) {
    chunk = bytes[mainLength];
    a4 = (chunk & 252) >> 2;
    b4 = (chunk & 3) << 4;
    base64 += encodings[a4] + encodings[b4] + "==";
  } else if (byteRemainder == 2) {
    chunk = bytes[mainLength] << 8 | bytes[mainLength + 1];
    a4 = (chunk & 64512) >> 10;
    b4 = (chunk & 1008) >> 4;
    c4 = (chunk & 15) << 2;
    base64 += encodings[a4] + encodings[b4] + encodings[c4] + "=";
  }
  return base64;
}

// ../taler-util/lib/bech32.js
var CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
var GENERATOR = [996825010, 642813549, 513874426, 1027748829, 705979059];
function polymod(values) {
  var chk = 1;
  for (var p4 = 0; p4 < values.length; ++p4) {
    var top = chk >> 25;
    chk = (chk & 33554431) << 5 ^ values[p4];
    for (var i4 = 0; i4 < 5; ++i4) {
      if (top >> i4 & 1) {
        chk ^= GENERATOR[i4];
      }
    }
  }
  return chk;
}
function hrpExpand(hrp) {
  const ret = [];
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) >> 5);
  }
  ret.push(0);
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) & 31);
  }
  return ret;
}
function getEncodingConst(enc) {
  switch (enc) {
    case BitcoinBech32.Encodings.BECH32:
      return 1;
    case BitcoinBech32.Encodings.BECH32M:
      return 734539939;
    default: {
      assertUnreachable(enc);
    }
  }
}
function verifyChecksum(hrp, data, enc) {
  return polymod(hrpExpand(hrp).concat(data)) === getEncodingConst(enc);
}
function createChecksum(hrp, data, enc) {
  const values = hrpExpand(hrp).concat(data).concat([0, 0, 0, 0, 0, 0]);
  const mod = polymod(values) ^ getEncodingConst(enc);
  const ret = [];
  for (let p4 = 0; p4 < 6; ++p4) {
    ret.push(mod >> 5 * (5 - p4) & 31);
  }
  return ret;
}
var BitcoinBech32;
(function(BitcoinBech322) {
  let Encodings;
  (function(Encodings2) {
    Encodings2["BECH32"] = "bech32";
    Encodings2["BECH32M"] = "bech32m";
  })(Encodings = BitcoinBech322.Encodings || (BitcoinBech322.Encodings = {}));
  ;
  function encode2(hrp, data, enc) {
    var combined = data.concat(createChecksum(hrp, data, enc));
    var ret = hrp + "1";
    for (var p4 = 0; p4 < combined.length; ++p4) {
      ret += CHARSET.charAt(combined[p4]);
    }
    return ret;
  }
  BitcoinBech322.encode = encode2;
  let BitcoinParseError;
  (function(BitcoinParseError2) {
    BitcoinParseError2[BitcoinParseError2["WRONG_CHARSET"] = 0] = "WRONG_CHARSET";
    BitcoinParseError2[BitcoinParseError2["MIXING_UPPER_AND_LOWER"] = 1] = "MIXING_UPPER_AND_LOWER";
    BitcoinParseError2[BitcoinParseError2["MISSING_HRP"] = 2] = "MISSING_HRP";
    BitcoinParseError2[BitcoinParseError2["TOO_LONG"] = 3] = "TOO_LONG";
    BitcoinParseError2[BitcoinParseError2["TOO_SHORT"] = 4] = "TOO_SHORT";
    BitcoinParseError2[BitcoinParseError2["WRONG_CHECKSUM"] = 5] = "WRONG_CHECKSUM";
  })(BitcoinParseError = BitcoinBech322.BitcoinParseError || (BitcoinBech322.BitcoinParseError = {}));
  function decode2(bechString, enc) {
    let p4;
    let has_lower = false;
    let has_upper = false;
    for (p4 = 0; p4 < bechString.length; ++p4) {
      if (bechString.charCodeAt(p4) < 33 || bechString.charCodeAt(p4) > 126) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      if (bechString.charCodeAt(p4) >= 97 && bechString.charCodeAt(p4) <= 122) {
        has_lower = true;
      }
      if (bechString.charCodeAt(p4) >= 65 && bechString.charCodeAt(p4) <= 90) {
        has_upper = true;
      }
    }
    if (has_lower && has_upper) {
      return opKnownFailure(BitcoinParseError.MIXING_UPPER_AND_LOWER);
    }
    bechString = bechString.toLowerCase();
    const pos = bechString.lastIndexOf("1");
    if (pos < 1) {
      return opKnownFailure(BitcoinParseError.MISSING_HRP);
    }
    if (pos + 7 > bechString.length) {
      return opKnownFailure(BitcoinParseError.TOO_SHORT);
    }
    if (bechString.length > 90) {
      return opKnownFailure(BitcoinParseError.TOO_LONG);
    }
    const hrp = bechString.substring(0, pos);
    var data = [];
    for (p4 = pos + 1; p4 < bechString.length; ++p4) {
      var d4 = CHARSET.indexOf(bechString.charAt(p4));
      if (d4 === -1) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      data.push(d4);
    }
    if (enc && !verifyChecksum(hrp, data, enc)) {
      return opKnownFailure(BitcoinParseError.WRONG_CHECKSUM);
    }
    return opFixedSuccess({ hrp, data: data.slice(0, data.length - 6) });
  }
  BitcoinBech322.decode = decode2;
})(BitcoinBech32 || (BitcoinBech32 = {}));

// ../taler-util/lib/segwit_addr.js
function convertbits(data, frombits, tobits, pad) {
  let acc = 0;
  let bits = 0;
  const ret = [];
  const maxv = (1 << tobits) - 1;
  for (let p4 = 0; p4 < data.length; ++p4) {
    const value = data[p4];
    if (value < 0 || value >> frombits !== 0) {
      return null;
    }
    acc = acc << frombits | value;
    bits += frombits;
    while (bits >= tobits) {
      bits -= tobits;
      ret.push(acc >> bits & maxv);
    }
  }
  if (pad) {
    if (bits > 0) {
      ret.push(acc << tobits - bits & maxv);
    }
  } else if (bits >= frombits || acc << tobits - bits & maxv) {
    return null;
  }
  return ret;
}
var BitcoinSewgit;
(function(BitcoinSewgit2) {
  let BitcoinSewgitParseError;
  (function(BitcoinSewgitParseError2) {
    BitcoinSewgitParseError2["INVALID_DATA"] = "invalid-data";
    BitcoinSewgitParseError2["DECODING_PROBLEM"] = "decoding-problem";
  })(BitcoinSewgitParseError = BitcoinSewgit2.BitcoinSewgitParseError || (BitcoinSewgit2.BitcoinSewgitParseError = {}));
  function decode2(addr, enc) {
    const decResp = BitcoinBech32.decode(addr, enc);
    if (decResp.type === "fail") {
      return decResp;
    }
    const { body: dec } = decResp;
    if (dec.data.length < 1 || dec.data[0] > 16) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const res = convertbits(dec.data.slice(1), 5, 8, false);
    if (res === null || res.length < 2 || res.length > 40) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && res.length !== 20 && res.length !== 32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && enc === BitcoinBech32.Encodings.BECH32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] !== 0 && enc === BitcoinBech32.Encodings.BECH32M) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    return opFixedSuccess({ version: dec.data[0], program: res });
  }
  BitcoinSewgit2.decode = decode2;
  function encode2(hrp, version, program) {
    const enc = version > 0 ? BitcoinBech32.Encodings.BECH32M : BitcoinBech32.Encodings.BECH32;
    const bits = convertbits(program, 8, 5, true);
    if (!bits) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const ret = BitcoinBech32.encode(hrp, [version].concat(bits), enc);
    return opFixedSuccess(ret);
  }
  BitcoinSewgit2.encode = encode2;
})(BitcoinSewgit || (BitcoinSewgit = {}));

// ../taler-util/lib/bitcoin.js
var GenerateSegwitAddrError;
(function(GenerateSegwitAddrError2) {
  GenerateSegwitAddrError2["WRONG_RESERVE_PUB"] = "wrong-reserve-pub";
  GenerateSegwitAddrError2["WRONG_PREFIX"] = "wrong-prefix";
  GenerateSegwitAddrError2["INVALID_SEGWIT"] = "invalid-segwit";
})(GenerateSegwitAddrError || (GenerateSegwitAddrError = {}));
function generateFakeSegwitAddress(pub, addr) {
  const first_rnd = new Uint8Array(4);
  first_rnd.set(pub.subarray(0, 4));
  const second_rnd = new Uint8Array(4);
  second_rnd.set(pub.subarray(0, 4));
  first_rnd[0] = first_rnd[0] & 127;
  second_rnd[0] = second_rnd[0] | 128;
  const first_part = new Uint8Array(first_rnd.length + pub.length / 2);
  first_part.set(first_rnd, 0);
  first_part.set(pub.subarray(0, 16), 4);
  const second_part = new Uint8Array(first_rnd.length + pub.length / 2);
  second_part.set(second_rnd, 0);
  second_part.set(pub.subarray(16, 32), 4);
  const prefix = addr[0] === "t" && addr[1] == "b" ? "tb" : addr[0] === "b" && addr[1] == "c" && addr[2] === "r" && addr[3] == "t" ? "bcrt" : addr[0] === "b" && addr[1] == "c" ? "bc" : void 0;
  if (prefix === void 0) {
    return opKnownFailure(GenerateSegwitAddrError.WRONG_PREFIX);
  }
  const addr1 = BitcoinSewgit.encode(prefix, 0, Array.from(first_part));
  if (addr1.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const addr2 = BitcoinSewgit.encode(prefix, 0, Array.from(second_part));
  if (addr2.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const result = [addr1.body, addr2.body];
  return opFixedSuccess(result);
}

// ../taler-util/lib/CancellationToken.js
var NOOP = () => {
};
var CancellationToken = class _CancellationToken {
  /**
   * Whether the token has been cancelled.
   */
  get isCancelled() {
    return this._isCancelled;
  }
  /**
   * Whether the token can be cancelled.
   */
  get canBeCancelled() {
    return this._canBeCancelled;
  }
  /**
   * Why this token has been cancelled.
   */
  get reason() {
    if (this.isCancelled) {
      return this._reason;
    } else {
      throw new Error("This token is not cancelled.");
    }
  }
  /**
   * Make a promise that resolves when the async operation resolves,
   * or rejects when the operation is rejected or this token is cancelled.
   */
  racePromise(asyncOperation) {
    if (!this.canBeCancelled) {
      return asyncOperation;
    }
    return new Promise((resolve, reject) => {
      const unregister = this.onCancelled((reason) => reject(new _CancellationToken.CancellationError(reason)));
      asyncOperation.then((value) => {
        resolve(value);
        unregister();
      }, (err) => {
        reject(err);
        unregister();
      });
    });
  }
  /**
   * Throw a {CancellationToken.CancellationError} if this token is cancelled.
   */
  throwIfCancelled() {
    if (this._isCancelled) {
      throw new _CancellationToken.CancellationError(this._reason);
    }
  }
  /**
   * Invoke the callback when this token is cancelled.
   * If this token is already cancelled, the callback is invoked immediately.
   * Returns a function that unregisters the cancellation callback.
   */
  onCancelled(cb) {
    if (!this.canBeCancelled) {
      return NOOP;
    }
    if (this.isCancelled) {
      cb(this.reason);
      return NOOP;
    }
    this._callbacks?.add(cb);
    return () => this._callbacks?.delete(cb);
  }
  constructor(_isCancelled, _canBeCancelled) {
    this._isCancelled = _isCancelled;
    this._canBeCancelled = _canBeCancelled;
    this._callbacks = /* @__PURE__ */ new Set();
  }
  /**
   * Create a {CancellationTokenSource}.
   */
  static create() {
    const token = new _CancellationToken(false, true);
    const cancel = (reason) => {
      if (token._isCancelled)
        return;
      token._isCancelled = true;
      token._reason = reason;
      token._callbacks?.forEach((cb) => cb(reason));
      dispose();
    };
    const dispose = () => {
      token._canBeCancelled = token.isCancelled;
      delete token._callbacks;
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationTokenSource}.
   * The token will be cancelled automatically after the specified timeout in milliseconds.
   */
  static timeout(ms) {
    const { token, cancel: originalCancel, dispose: originalDispose } = _CancellationToken.create();
    let timer2;
    timer2 = setTimeout(() => originalCancel(`CancellationToken.timeout ${ms}`), ms);
    const disposeTimer = () => {
      if (timer2 == null)
        return;
      clearTimeout(timer2);
      timer2 = null;
    };
    const cancel = (reason) => {
      disposeTimer();
      originalCancel(reason);
    };
    const dispose = () => {
      disposeTimer();
      originalDispose();
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationToken} that is cancelled when all of the given tokens are cancelled.
   *
   * This is like {Promise<T>.all} for {CancellationToken}s.
   */
  static all(...tokens) {
    if (tokens.some((token) => !token.canBeCancelled)) {
      return _CancellationToken.CONTINUE;
    }
    const combined = _CancellationToken.create();
    let countdown = tokens.length;
    const handleNextTokenCancelled = () => {
      if (--countdown === 0) {
        const reasons = tokens.map((token) => token._reason);
        combined.cancel(reasons);
      }
    };
    tokens.forEach((token) => token.onCancelled(handleNextTokenCancelled));
    return combined.token;
  }
  /**
   * Create a {CancellationToken} that is cancelled when at least one of the given tokens is cancelled.
   *
   * This is like {Promise<T>.race} for {CancellationToken}s.
   */
  static race(...tokens) {
    for (const token of tokens) {
      if (token._isCancelled) {
        return token;
      }
    }
    const combined = _CancellationToken.create();
    let unregistrations;
    const handleAnyTokenCancelled = (reason) => {
      unregistrations.forEach((unregister) => unregister());
      combined.cancel(reason);
    };
    unregistrations = tokens.map((token) => token.onCancelled(handleAnyTokenCancelled));
    return combined.token;
  }
};
CancellationToken.CANCELLED = new CancellationToken(true, true);
CancellationToken.CONTINUE = new CancellationToken(false, false);
(function(CancellationToken2) {
  class CancellationError extends Error {
    constructor(reason) {
      super("Operation cancelled");
      this.reason = reason;
      Object.setPrototypeOf(this, CancellationError.prototype);
    }
  }
  CancellationToken2.CancellationError = CancellationError;
})(CancellationToken || (CancellationToken = {}));

// ../taler-util/lib/taler-crypto.js
var import_big_integer = __toESM(require_BigInteger(), 1);

// ../taler-util/lib/sha256.js
var digestLength = 32;
var blockSize = 64;
var K2 = new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]);
function hashBlocks(w5, v3, p4, pos, len) {
  let a4, b4, c4, d4, e4, f3, g4, h3, u4, i4, j4, t1, t22;
  while (len >= 64) {
    a4 = v3[0];
    b4 = v3[1];
    c4 = v3[2];
    d4 = v3[3];
    e4 = v3[4];
    f3 = v3[5];
    g4 = v3[6];
    h3 = v3[7];
    for (i4 = 0; i4 < 16; i4++) {
      j4 = pos + i4 * 4;
      w5[i4] = (p4[j4] & 255) << 24 | (p4[j4 + 1] & 255) << 16 | (p4[j4 + 2] & 255) << 8 | p4[j4 + 3] & 255;
    }
    for (i4 = 16; i4 < 64; i4++) {
      u4 = w5[i4 - 2];
      t1 = (u4 >>> 17 | u4 << 32 - 17) ^ (u4 >>> 19 | u4 << 32 - 19) ^ u4 >>> 10;
      u4 = w5[i4 - 15];
      t22 = (u4 >>> 7 | u4 << 32 - 7) ^ (u4 >>> 18 | u4 << 32 - 18) ^ u4 >>> 3;
      w5[i4] = (t1 + w5[i4 - 7] | 0) + (t22 + w5[i4 - 16] | 0);
    }
    for (i4 = 0; i4 < 64; i4++) {
      t1 = (((e4 >>> 6 | e4 << 32 - 6) ^ (e4 >>> 11 | e4 << 32 - 11) ^ (e4 >>> 25 | e4 << 32 - 25)) + (e4 & f3 ^ ~e4 & g4) | 0) + (h3 + (K2[i4] + w5[i4] | 0) | 0) | 0;
      t22 = ((a4 >>> 2 | a4 << 32 - 2) ^ (a4 >>> 13 | a4 << 32 - 13) ^ (a4 >>> 22 | a4 << 32 - 22)) + (a4 & b4 ^ a4 & c4 ^ b4 & c4) | 0;
      h3 = g4;
      g4 = f3;
      f3 = e4;
      e4 = d4 + t1 | 0;
      d4 = c4;
      c4 = b4;
      b4 = a4;
      a4 = t1 + t22 | 0;
    }
    v3[0] += a4;
    v3[1] += b4;
    v3[2] += c4;
    v3[3] += d4;
    v3[4] += e4;
    v3[5] += f3;
    v3[6] += g4;
    v3[7] += h3;
    pos += 64;
    len -= 64;
  }
  return pos;
}
var HashSha256 = class {
  constructor() {
    this.digestLength = digestLength;
    this.blockSize = blockSize;
    this.state = new Int32Array(8);
    this.temp = new Int32Array(64);
    this.buffer = new Uint8Array(128);
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    this.reset();
  }
  // Resets hash state making it possible
  // to reuse this instance to hash other data.
  reset() {
    this.state[0] = 1779033703;
    this.state[1] = 3144134277;
    this.state[2] = 1013904242;
    this.state[3] = 2773480762;
    this.state[4] = 1359893119;
    this.state[5] = 2600822924;
    this.state[6] = 528734635;
    this.state[7] = 1541459225;
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    return this;
  }
  // Cleans internal buffers and re-initializes hash state.
  clean() {
    for (let i4 = 0; i4 < this.buffer.length; i4++) {
      this.buffer[i4] = 0;
    }
    for (let i4 = 0; i4 < this.temp.length; i4++) {
      this.temp[i4] = 0;
    }
    this.reset();
  }
  // Updates hash state with the given data.
  //
  // Optionally, length of the data can be specified to hash
  // fewer bytes than data.length.
  //
  // Throws error when trying to update already finalized hash:
  // instance must be reset to use it again.
  update(data, dataLength = data.length) {
    if (this.finished) {
      throw new Error("SHA256: can't update because hash was finished.");
    }
    let dataPos = 0;
    this.bytesHashed += dataLength;
    if (this.bufferLength > 0) {
      while (this.bufferLength < 64 && dataLength > 0) {
        this.buffer[this.bufferLength++] = data[dataPos++];
        dataLength--;
      }
      if (this.bufferLength === 64) {
        hashBlocks(this.temp, this.state, this.buffer, 0, 64);
        this.bufferLength = 0;
      }
    }
    if (dataLength >= 64) {
      dataPos = hashBlocks(this.temp, this.state, data, dataPos, dataLength);
      dataLength %= 64;
    }
    while (dataLength > 0) {
      this.buffer[this.bufferLength++] = data[dataPos++];
      dataLength--;
    }
    return this;
  }
  // Finalizes hash state and puts hash into out.
  //
  // If hash was already finalized, puts the same value.
  finish(out) {
    if (!this.finished) {
      const bytesHashed = this.bytesHashed;
      const left = this.bufferLength;
      const bitLenHi = bytesHashed / 536870912 | 0;
      const bitLenLo = bytesHashed << 3;
      const padLength = bytesHashed % 64 < 56 ? 64 : 128;
      this.buffer[left] = 128;
      for (let i4 = left + 1; i4 < padLength - 8; i4++) {
        this.buffer[i4] = 0;
      }
      this.buffer[padLength - 8] = bitLenHi >>> 24 & 255;
      this.buffer[padLength - 7] = bitLenHi >>> 16 & 255;
      this.buffer[padLength - 6] = bitLenHi >>> 8 & 255;
      this.buffer[padLength - 5] = bitLenHi >>> 0 & 255;
      this.buffer[padLength - 4] = bitLenLo >>> 24 & 255;
      this.buffer[padLength - 3] = bitLenLo >>> 16 & 255;
      this.buffer[padLength - 2] = bitLenLo >>> 8 & 255;
      this.buffer[padLength - 1] = bitLenLo >>> 0 & 255;
      hashBlocks(this.temp, this.state, this.buffer, 0, padLength);
      this.finished = true;
    }
    for (let i4 = 0; i4 < 8; i4++) {
      out[i4 * 4 + 0] = this.state[i4] >>> 24 & 255;
      out[i4 * 4 + 1] = this.state[i4] >>> 16 & 255;
      out[i4 * 4 + 2] = this.state[i4] >>> 8 & 255;
      out[i4 * 4 + 3] = this.state[i4] >>> 0 & 255;
    }
    return this;
  }
  // Returns the final hash digest.
  digest() {
    const out = new Uint8Array(this.digestLength);
    this.finish(out);
    return out;
  }
  // Internal function for use in HMAC for optimization.
  _saveState(out) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      out[i4] = this.state[i4];
    }
  }
  // Internal function for use in HMAC for optimization.
  _restoreState(from, bytesHashed) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      this.state[i4] = from[i4];
    }
    this.bytesHashed = bytesHashed;
    this.finished = false;
    this.bufferLength = 0;
  }
};
function sha256(data) {
  const h3 = new HashSha256().update(data);
  const digest = h3.digest();
  h3.clean();
  return digest;
}

// ../taler-util/lib/kdf.js
function sha512(data) {
  return hash(data);
}
function hmac(digest, blockSize2, key, message) {
  if (key.byteLength > blockSize2) {
    key = digest(key);
  }
  if (key.byteLength < blockSize2) {
    const k5 = key;
    key = new Uint8Array(blockSize2);
    key.set(k5, 0);
  }
  const okp = new Uint8Array(blockSize2);
  const ikp = new Uint8Array(blockSize2);
  for (let i4 = 0; i4 < blockSize2; i4++) {
    ikp[i4] = key[i4] ^ 54;
    okp[i4] = key[i4] ^ 92;
  }
  const b1 = new Uint8Array(blockSize2 + message.byteLength);
  b1.set(ikp, 0);
  b1.set(message, blockSize2);
  const h0 = digest(b1);
  const b22 = new Uint8Array(blockSize2 + h0.length);
  b22.set(okp, 0);
  b22.set(h0, blockSize2);
  return digest(b22);
}
function hmacSha512(key, message) {
  return hmac(sha512, 128, key, message);
}
function hmacSha256(key, message) {
  return hmac(sha256, 64, key, message);
}

// ../taler-util/lib/iban.js
var ParseIbanError;
(function(ParseIbanError2) {
  ParseIbanError2[ParseIbanError2["UNSUPPORTED_COUNTRY"] = 0] = "UNSUPPORTED_COUNTRY";
  ParseIbanError2[ParseIbanError2["TOO_LONG"] = 1] = "TOO_LONG";
  ParseIbanError2[ParseIbanError2["TOO_SHORT"] = 2] = "TOO_SHORT";
  ParseIbanError2[ParseIbanError2["INVALID_CHARSET"] = 3] = "INVALID_CHARSET";
  ParseIbanError2[ParseIbanError2["INVALID_CHECKSUM"] = 4] = "INVALID_CHECKSUM";
})(ParseIbanError || (ParseIbanError = {}));
var ccZero = "0".charCodeAt(0);
var ccNine = "9".charCodeAt(0);
var ccA = "A".charCodeAt(0);
var ccZ = "Z".charCodeAt(0);
function appendDigit(digits, cc) {
  if (cc >= ccZero && cc <= ccNine) {
    digits.push(cc - ccZero);
  } else if (cc >= ccA && cc <= ccZ) {
    const n2 = cc - ccA + 10;
    digits.push(Math.floor(n2 / 10) % 10);
    digits.push(n2 % 10);
  } else {
    return false;
  }
  return true;
}
function mod97(digits) {
  let i4 = 0;
  let modAccum = 0;
  while (i4 < digits.length) {
    let n2 = 0;
    while (n2 < 9 && i4 < digits.length) {
      modAccum = modAccum * 10 + digits[i4];
      i4++;
      n2++;
    }
    modAccum = modAccum % 97;
  }
  return modAccum;
}
function parseIban(ibanString) {
  if (ibanString.length < 4) {
    return opKnownFailure(ParseIbanError.TOO_SHORT);
  }
  if (ibanString.length > 34) {
    return opKnownFailure(ParseIbanError.TOO_LONG);
  }
  const myIban = ibanString.toUpperCase().replace(/[\s-\._]/g, "");
  const countryCode = myIban.substring(0, 2);
  const countryInfo = ibanCountryInfoTable[countryCode];
  if (!countryInfo) {
    return opKnownFailure(ParseIbanError.UNSUPPORTED_COUNTRY);
  }
  let digits = [];
  for (let i4 = 4; i4 < myIban.length; i4++) {
    const cc = myIban.charCodeAt(i4);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  for (let i4 = 0; i4 < 4; i4++) {
    const cc = myIban.charCodeAt(i4);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  const rem = mod97(digits);
  if (rem === 1) {
    return opFixedSuccess(myIban);
  } else {
    return opKnownFailure(ParseIbanError.INVALID_CHECKSUM);
  }
}
var ibanCountryInfoTable = {
  AE: { name: "U.A.E." },
  AF: { name: "Afghanistan" },
  AL: { name: "Albania" },
  AM: { name: "Armenia" },
  AN: { name: "Netherlands Antilles" },
  AR: { name: "Argentina" },
  AT: { name: "Austria" },
  AU: { name: "Australia" },
  AZ: { name: "Azerbaijan" },
  BA: { name: "Bosnia and Herzegovina" },
  BD: { name: "Bangladesh" },
  BE: { name: "Belgium" },
  BG: { name: "Bulgaria" },
  BH: { name: "Bahrain" },
  BN: { name: "Brunei Darussalam" },
  BO: { name: "Bolivia" },
  BR: { name: "Brazil" },
  BT: { name: "Bhutan" },
  BY: { name: "Belarus" },
  BZ: { name: "Belize" },
  CA: { name: "Canada" },
  CG: { name: "Congo" },
  CH: { name: "Switzerland" },
  CI: { name: "Cote d'Ivoire" },
  CL: { name: "Chile" },
  CM: { name: "Cameroon" },
  CN: { name: "People's Republic of China" },
  CO: { name: "Colombia" },
  CR: { name: "Costa Rica" },
  CS: { name: "Serbia and Montenegro" },
  CZ: { name: "Czech Republic" },
  DE: { name: "Germany" },
  DK: { name: "Denmark" },
  DO: { name: "Dominican Republic" },
  DZ: { name: "Algeria" },
  EC: { name: "Ecuador" },
  EE: { name: "Estonia" },
  EG: { name: "Egypt" },
  ER: { name: "Eritrea" },
  ES: { name: "Spain" },
  ET: { name: "Ethiopia" },
  FI: { name: "Finland" },
  FO: { name: "Faroe Islands" },
  FR: { name: "France" },
  GB: { name: "United Kingdom" },
  GD: { name: "Caribbean" },
  GE: { name: "Georgia" },
  GL: { name: "Greenland" },
  GR: { name: "Greece" },
  GT: { name: "Guatemala" },
  HK: { name: "Hong Kong S.A.R." },
  HN: { name: "Honduras" },
  HR: { name: "Croatia" },
  HT: { name: "Haiti" },
  HU: { name: "Hungary" },
  ID: { name: "Indonesia" },
  IE: { name: "Ireland" },
  IL: { name: "Israel" },
  IN: { name: "India" },
  IQ: { name: "Iraq" },
  IR: { name: "Iran" },
  IS: { name: "Iceland" },
  IT: { name: "Italy" },
  JM: { name: "Jamaica" },
  JO: { name: "Jordan" },
  JP: { name: "Japan" },
  KE: { name: "Kenya" },
  KG: { name: "Kyrgyzstan" },
  KH: { name: "Cambodia" },
  KR: { name: "South Korea" },
  KW: { name: "Kuwait" },
  KZ: { name: "Kazakhstan" },
  LA: { name: "Laos" },
  LB: { name: "Lebanon" },
  LI: { name: "Liechtenstein" },
  LK: { name: "Sri Lanka" },
  LT: { name: "Lithuania" },
  LU: { name: "Luxembourg" },
  LV: { name: "Latvia" },
  LY: { name: "Libya" },
  MA: { name: "Morocco" },
  MC: { name: "Principality of Monaco" },
  MD: { name: "Moldava" },
  ME: { name: "Montenegro" },
  MK: { name: "Former Yugoslav Republic of Macedonia" },
  ML: { name: "Mali" },
  MM: { name: "Myanmar" },
  MN: { name: "Mongolia" },
  MO: { name: "Macau S.A.R." },
  MT: { name: "Malta" },
  MV: { name: "Maldives" },
  MX: { name: "Mexico" },
  MY: { name: "Malaysia" },
  NG: { name: "Nigeria" },
  NI: { name: "Nicaragua" },
  NL: { name: "Netherlands" },
  NO: { name: "Norway" },
  NP: { name: "Nepal" },
  NZ: { name: "New Zealand" },
  OM: { name: "Oman" },
  PA: { name: "Panama" },
  PE: { name: "Peru" },
  PH: { name: "Philippines" },
  PK: { name: "Islamic Republic of Pakistan" },
  PL: { name: "Poland" },
  PR: { name: "Puerto Rico" },
  PT: { name: "Portugal" },
  PY: { name: "Paraguay" },
  QA: { name: "Qatar" },
  RE: { name: "Reunion" },
  RO: { name: "Romania" },
  RS: { name: "Serbia" },
  RU: { name: "Russia" },
  RW: { name: "Rwanda" },
  SA: { name: "Saudi Arabia" },
  SE: { name: "Sweden" },
  SG: { name: "Singapore" },
  SI: { name: "Slovenia" },
  SK: { name: "Slovak" },
  SN: { name: "Senegal" },
  SO: { name: "Somalia" },
  SR: { name: "Suriname" },
  SV: { name: "El Salvador" },
  SY: { name: "Syria" },
  TH: { name: "Thailand" },
  TJ: { name: "Tajikistan" },
  TM: { name: "Turkmenistan" },
  TN: { name: "Tunisia" },
  TR: { name: "Turkey" },
  TT: { name: "Trinidad and Tobago" },
  TW: { name: "Taiwan" },
  TZ: { name: "Tanzania" },
  UA: { name: "Ukraine" },
  US: { name: "United States" },
  UY: { name: "Uruguay" },
  VA: { name: "Vatican" },
  VE: { name: "Venezuela" },
  VN: { name: "Viet Nam" },
  YE: { name: "Yemen" },
  ZA: { name: "South Africa" },
  ZW: { name: "Zimbabwe" }
};

// ../taler-util/lib/payto.js
var PAYTO_PREFIX = "payto://";
var PaytoType;
(function(PaytoType2) {
  PaytoType2["IBAN"] = "iban";
  PaytoType2["Bitcoin"] = "bitcoin";
  PaytoType2["TalerBank"] = "x-taler-bank";
  PaytoType2["TalerReserve"] = "taler-reserve";
  PaytoType2["TalerReserveHttp"] = "taler-reserve-http";
  PaytoType2["Ethereum"] = "ethereum";
})(PaytoType || (PaytoType = {}));
var ReservePubParseError;
(function(ReservePubParseError2) {
  ReservePubParseError2[ReservePubParseError2["WRONG_LENGTH"] = 0] = "WRONG_LENGTH";
  ReservePubParseError2[ReservePubParseError2["DECODE_ERROR"] = 1] = "DECODE_ERROR";
})(ReservePubParseError || (ReservePubParseError = {}));
var PaytoParseError;
(function(PaytoParseError2) {
  PaytoParseError2[PaytoParseError2["WRONG_PREFIX"] = 0] = "WRONG_PREFIX";
  PaytoParseError2[PaytoParseError2["INCOMPLETE"] = 1] = "INCOMPLETE";
  PaytoParseError2[PaytoParseError2["UNSUPPORTED"] = 2] = "UNSUPPORTED";
  PaytoParseError2[PaytoParseError2["COMPONENTS_LENGTH"] = 3] = "COMPONENTS_LENGTH";
  PaytoParseError2[PaytoParseError2["INVALID_TARGET_PATH"] = 4] = "INVALID_TARGET_PATH";
})(PaytoParseError || (PaytoParseError = {}));
var Paytos;
(function(Paytos2) {
  const supported_targets = {
    iban: true,
    bitcoin: true,
    "x-taler-bank": true,
    "taler-reserve": true,
    "taler-reserve-http": true,
    ethereum: true
  };
  function hash4(p4) {
    return hashTruncate32(stringToBytes(p4 + "\0"));
  }
  Paytos2.hash = hash4;
  function toNormalizedString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.normalizedPath}`);
    return url.href;
  }
  Paytos2.toNormalizedString = toNormalizedString;
  function toFullString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.fullPath}`);
    const paramList = !p4.params ? [] : Object.entries(p4.params);
    url.search = createSearchParams(paramList);
    return url.href;
  }
  Paytos2.toFullString = toFullString;
  function parseReservePub(reserve) {
    if (!reserve)
      return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
    try {
      const pub = decodeCrock(reserve);
      if (!pub || pub.length !== 32) {
        return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
      }
      return opFixedSuccess(pub);
    } catch (e4) {
      return opKnownFailureWithBody(ReservePubParseError.DECODE_ERROR, {
        message: String(e4)
      });
    }
  }
  Paytos2.parseReservePub = parseReservePub;
  function parseHostPortPath2(hostname, path, scheme = "https") {
    try {
      if (path === void 0) {
        path = "";
      }
      if (!path.endsWith("/")) {
        path = path + "/";
      }
      const url = new URL(path, `${scheme}://${hostname.toLowerCase()}`);
      url.search = "";
      url.password = "";
      url.username = "";
      url.hash = "";
      return url.href;
    } catch (e4) {
      console.log(e4);
      return void 0;
    }
  }
  Paytos2.parseHostPortPath2 = parseHostPortPath2;
  function withoutScheme(h3) {
    return h3.startsWith("http://") ? h3.substring(7) : h3.startsWith("https://") ? h3.substring(8) : h3;
  }
  function parseHostPortPath(hostnameAndPath) {
    const [host, path] = hostnameAndPath.split("/", 1);
    return parseHostPortPath2(host, path ?? "");
  }
  Paytos2.parseHostPortPath = parseHostPortPath;
  function parseEthereumAddress(str) {
    if (!str) {
      return void 0;
    }
    return str;
  }
  Paytos2.parseEthereumAddress = parseEthereumAddress;
  function parseTalerBankAccount(account) {
    if (!account) {
      return void 0;
    }
    return account;
  }
  Paytos2.parseTalerBankAccount = parseTalerBankAccount;
  function createUnsupported(targetType, path, params = {}) {
    return {
      targetType: void 0,
      target: targetType,
      params,
      normalizedPath: path.toLocaleLowerCase(),
      fullPath: path,
      displayName: path
    };
  }
  Paytos2.createUnsupported = createUnsupported;
  function createIban(iban, bic, params = {}) {
    iban = iban.toUpperCase();
    return {
      targetType: PaytoType.IBAN,
      iban,
      bic,
      params,
      normalizedPath: iban,
      fullPath: !bic ? iban : `${bic}/${iban}`,
      displayName: iban
    };
  }
  Paytos2.createIban = createIban;
  function createBitcoin(address, reservePub, params = {}) {
    const sgRes = !reservePub ? void 0 : generateFakeSegwitAddress(reservePub, address);
    const segwitAddrs = !sgRes || sgRes.type === "fail" ? [] : sgRes.body;
    return {
      targetType: PaytoType.Bitcoin,
      address,
      reservePub,
      segwitAddrs,
      params,
      normalizedPath: address.toLocaleLowerCase(),
      fullPath: !reservePub ? address : `${address}/${encodeCrock(reservePub)}`,
      displayName: address
    };
  }
  Paytos2.createBitcoin = createBitcoin;
  function createEthereum(address, params = {}) {
    return {
      targetType: PaytoType.Ethereum,
      address,
      params,
      normalizedPath: address,
      fullPath: address,
      displayName: address
    };
  }
  Paytos2.createEthereum = createEthereum;
  function createTalerReserve(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserve,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserve = createTalerReserve;
  function createTalerReserveHttp(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserveHttp,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserveHttp = createTalerReserveHttp;
  function createTalerBank(url, account, params = {}) {
    const path = withoutScheme(url);
    const host = path.endsWith("/") ? path.substring(0, path.length - 1) : path;
    return {
      targetType: PaytoType.TalerBank,
      host,
      url,
      account,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${account}`,
      fullPath: `${path}${account}`,
      displayName: `${account}@${url}`
    };
  }
  Paytos2.createTalerBank = createTalerBank;
  function asString(p4) {
    return succeedOrThrow(fromString(p4));
  }
  Paytos2.asString = asString;
  function fromString(s4, opts = {}) {
    if (!s4.startsWith(PAYTO_PREFIX)) {
      return opKnownFailure(PaytoParseError.WRONG_PREFIX);
    }
    const [acct, search] = s4.slice(PAYTO_PREFIX.length).split("?", 2);
    const firstSlashPos = acct.indexOf("/");
    const targetType = firstSlashPos === -1 ? acct : acct.slice(0, firstSlashPos);
    if (!opts.allowUnsupported && !supported_targets[targetType]) {
      const d4 = opKnownFailureWithBody(PaytoParseError.UNSUPPORTED, {
        targetType
      });
      return d4;
    }
    const targetPath = acct.slice(firstSlashPos + 1);
    if (firstSlashPos === -1 || !targetPath) {
      return opKnownFailureWithBody(PaytoParseError.INCOMPLETE, { targetType });
    }
    const params = {};
    if (search) {
      const searchParams = new URLSearchParams2(search);
      searchParams.forEach((v3, k5) => {
        params[k5] = v3;
      });
    }
    const cs = targetPath.split("/");
    switch (targetType) {
      case PaytoType.IBAN: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const bic = cs.length === 2 ? cs[0] : void 0;
        const iban = cs.length === 1 ? cs[0] : cs[1];
        const ibaRes = parseIban(iban);
        if (!opts.ignoreComponentError && ibaRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: ibaRes
          });
        }
        return opFixedSuccess(createIban(iban, bic, params));
      }
      case PaytoType.Bitcoin: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = cs[0].toLocaleLowerCase();
        const btRes = BitcoinBech32.decode(address, BitcoinBech32.Encodings.BECH32);
        if (!opts.ignoreComponentError && btRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: btRes
          });
        }
        const pubRes = cs.length === 1 ? void 0 : parseReservePub(cs[1]);
        if (!opts.ignoreComponentError && pubRes && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createBitcoin(address, pubRes && pubRes.type === "ok" ? pubRes.body : void 0, params));
      }
      case PaytoType.TalerBank: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const host = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !host) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: host
          });
        }
        const account = parseTalerBankAccount(cs[cs.length - 1]);
        if (!opts.ignoreComponentError && !account) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: account
          });
        }
        return opFixedSuccess(createTalerBank(host ?? cs[0], account ?? cs[1], params));
      }
      case PaytoType.TalerReserve: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserve(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.TalerReserveHttp: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), "http");
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserveHttp(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.Ethereum: {
        if (cs.length !== 1) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = parseEthereumAddress(cs[0]);
        if (!opts.ignoreComponentError && !address) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: address
          });
        }
        return opFixedSuccess(createEthereum(address ?? cs[0], params));
      }
      default: {
        if (opts.allowUnsupported) {
          return opFixedSuccess(createUnsupported(targetType, targetPath, params));
        }
        assertUnreachable(targetType);
      }
    }
  }
  Paytos2.fromString = fromString;
})(Paytos || (Paytos = {}));
function codecForPaytoHash() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      return x5;
    }
  };
}
function codecFullForPaytoString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (!x5.startsWith(PAYTO_PREFIX)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c4)} but got "${x5}"`);
      }
      return x5;
    }
  };
}
function codecForPaytoString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (!x5.startsWith(PAYTO_PREFIX)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c4)} but got "${x5}"`);
      }
      return x5;
    }
  };
}
function encodeRFC3986URIComponent(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, (c4) => `%${c4.charCodeAt(0).toString(16).toUpperCase()}`);
}
var rfc3986 = encodeRFC3986URIComponent;
function createSearchParams(paramList) {
  return paramList.map(([key, value]) => `${rfc3986(key)}=${rfc3986(value)}`).join("&");
}

// ../taler-util/lib/taler-form-attributes.js
var TalerFormAttributes = {
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS",
  /**
   * Description: Date for the signature.
   *
   * GANA Type: AbsoluteDateTime
   */
  SIGN_DATE: "SIGN_DATE",
  /**
   * Description: Name of the contracting party for the purpose of signing.
   *
   * GANA Type: String
   */
  SIGNATURE: "SIGNATURE",
  /**
   * Description: Basic customer type classification to distinguish which basic info is relevant.
   *
   * GANA Type: 'NATURAL_PERSON' | 'LEGAL_ENTITY'
   */
  CUSTOMER_TYPE: "CUSTOMER_TYPE",
  /**
   * Description: Date of birth for natural persons. It should be in the past and less than 120 years.
   *
   * GANA Type: ISO Date
   */
  DATE_OF_BIRTH: "DATE_OF_BIRTH",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: File
   */
  PERSONAL_IDENTIFICATION_DOCUMENT_COPY: "PERSONAL_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Is the customer a sole proprietor?
   *
   * GANA Type: Boolean
   */
  CUSTOMER_IS_SOLE_PROPRIETOR: "CUSTOMER_IS_SOLE_PROPRIETOR",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: String
   */
  COMPANY_NAME: "COMPANY_NAME",
  /**
   * Description:
   *
   * GANA Type: String
   */
  REGISTERED_OFFICE_ADDRESS: "REGISTERED_OFFICE_ADDRESS",
  /**
   * Description: Digital copy of the identification document for a legal entity.
   *
   * GANA Type: FileUpload
   */
  LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY: "LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Full name of the contact person.
   *
   * GANA Type: String
   */
  CONTACT_PERSON_NAME: "CONTACT_PERSON_NAME",
  /**
   * Description: Free-form description.
   *
   * GANA Type: String
   */
  DESCRIPTION: "DESCRIPTION",
  /**
   * Description:
   *
   * GANA Type: FileUpload[]
   */
  FILE: "FILE",
  /**
   * Description: List of founder with the fields below.
   *
   * GANA Type: Form<VQF_902_1_founder>[]
   */
  ESTABLISHER_LIST: "ESTABLISHER_LIST",
  /**
   * Description: Full name of a natural person.
   *
   * GANA Type: String
   */
  FULL_NAME: "FULL_NAME",
  /**
   * Description: Domicile address. A domicile is a place where you live, an address is just a place where you receive mail. A residential address is somewhere you live but not necessarily your primary place.
   *
   * GANA Type: ResidentialAddress
   */
  DOMICILE_ADDRESS: "DOMICILE_ADDRESS",
  /**
   * Description: Nationality, expressed as a country code.
   *
   * GANA Type: CountryCode
   */
  NATIONALITY: "NATIONALITY",
  /**
   * Description: Signatory of representation (single, collective two, ...)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE: "SIGNING_AUTHORITY_TYPE",
  /**
   * Description: Signatory of representation (other type)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE_OTHER: "SIGNING_AUTHORITY_TYPE_OTHER",
  /**
   * Description:
   *
   * GANA Type: 'CR' | 'MANDATE' | 'OTHER'
   */
  SIGNING_AUTHORITY_EVIDENCE: "SIGNING_AUTHORITY_EVIDENCE",
  /**
   * Description:
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_EVIDENCE_OTHER: "SIGNING_AUTHORITY_EVIDENCE_OTHER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY: "SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY",
  /**
   * Description: Conclusion of the conract
   *
   * GANA Type: AbsoluteDate
   */
  ACCEPTANCE_DATE: "ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'FACE_TO_FACE' | 'AUTHENTICATED_COPY' | 'RESIDENTIAL_ADDRESS_VALIDATED'
   */
  ACCEPTANCE_METHOD: "ACCEPTANCE_METHOD",
  /**
   * Description: Correspondence language of the customer.
   *
   * GANA Type: LangCode
   */
  CORRESPONDENCE_LANGUAGE: "CORRESPONDENCE_LANGUAGE",
  /**
   * Description: Further information on the acceptance of a customer.
   *
   * GANA Type: String
   */
  ACCEPTANCE_FURTHER_INFO: "ACCEPTANCE_FURTHER_INFO",
  /**
   * Description: Customer type under the VQF classification. Establishment of the beneficial owner of the assets and/or controlling person
   *
   * GANA Type: 'NATURAL_PERSON' | 'OPERATIONAL' | 'FOUNDATION' | 'TRUST' | 'LIFE_INSURANCE' | 'OTHER'
   */
  CUSTOMER_TYPE_VQF: "CUSTOMER_TYPE_VQF",
  /**
   * Description: Verification whether the customer, beneficial owners of the assets, controlling persons, authorised representatives or other involved persons are listed on an embargo-/terrorism list (date of verification/result)
   *
   * GANA Type: Paragraph
   */
  EMBARGO_TERRORISM_INFO: "EMBARGO_TERRORISM_INFO",
  /**
   * Description: Verification date in the sancations lists. It should be in the past and less than 120 years.
   *
   * GANA Type: Date
   */
  EMBARGO_TERRORISM_CHECK_DATE: "EMBARGO_TERRORISM_CHECK_DATE",
  /**
   * Description: Verification date.
   *
   * GANA Type: 'NOT_LISTED' | 'LISTED'
   */
  EMBARGO_TERRORISM_CHECK_RESULT: "EMBARGO_TERRORISM_CHECK_RESULT",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 1'
   *
   * GANA Type: Boolean
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 2'
   *
   * GANA Type: Boolean
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 3'
   *
   * GANA Type: Boolean
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  PEP_ACCEPTANCE_DATE: "PEP_ACCEPTANCE_DATE",
  /**
   * Description: True if the person is in a country for which FATF requires increased dilegence.
   *
   * GANA Type: Boolean
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  HIGH_RISK_ACCEPTANCE_DATE: "HIGH_RISK_ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'NATIONALITY_CUSTOMER' | 'NATIONALITY_OWNER' | 'DOMICILE_CUSTOMER' | 'DOMICILE_OWNER' | 'DOMICILE_CONTROLLING'
   */
  COUNTRY_RISK_NATIONALITY_TYPE: "COUNTRY_RISK_NATIONALITY_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_NATIONALITY_LEVEL: "COUNTRY_RISK_NATIONALITY_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  COUNTRY_RISK_BUSINESS_TYPE: "COUNTRY_RISK_BUSINESS_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_BUSINESS_LEVEL: "COUNTRY_RISK_BUSINESS_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  INDUSTRY_RISK_TYPE: "INDUSTRY_RISK_TYPE",
  /**
   * Description:
   *
   * GANA Type: 'TRANSPARENT' | 'HIGH_CASH_TRANSACTION' | 'NOT_WELL_KNOWN' | 'HIGH_RISK_TRADE' | 'UNKNOWN_INDUSTRY'
   */
  INDUSTRY_RISK_LEVEL: "INDUSTRY_RISK_LEVEL",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  CONTACT_RISK_LEVEL: "CONTACT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'EASY' | 'SOPHISTICATED' | 'OFFSHORE' | 'COMPLEX_STRUCTURE' | 'LARGE_NUMBER_OF_ACCOUNTS' | 'COMPLEX_SERVICE' | 'FREQ_TRANS_WITH_HIGH_RISK'
   */
  PRODUCT_RISK_LEVEL: "PRODUCT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'HIGH_RISK' | 'NO_HIGH_RISK'
   */
  RISK_CLASSIFICATION_LEVEL: "RISK_CLASSIFICATION_LEVEL",
  /**
   * Description: Justification for differing risk assessment
   *
   * GANA Type: Paragraph
   */
  RISK_RATIONALE: "RISK_RATIONALE",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  RISK_ACCEPTANCE_DATE: "RISK_ACCEPTANCE_DATE",
  /**
   * Description: Profession, business activities, etc. (former, current, potentially planned)
   *
   * GANA Type: String
   */
  BIZREL_PROFESSION: "BIZREL_PROFESSION",
  /**
   * Description: Income and assets, liabilities (estimated)
   *
   * GANA Type: String
   */
  BIZREL_INCOME: "BIZREL_INCOME",
  /**
   * Description: Does the customer have assets that will be deposited?
   *
   * GANA Type: Boolean
   */
  BIZREL_HAVE_ASSETS: "BIZREL_HAVE_ASSETS",
  /**
   * Description: Nature of the involved assets (amount, currency, ...).
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_NATURE: "BIZREL_ORIGIN_NATURE",
  /**
   * Description:
   *
   * GANA Type: 'SAVINGS' | 'OWN_BUSINESS' | 'INHERITANCE' | 'OTHER'
   */
  BIZREL_ORIGIN_CATEGORY: "BIZREL_ORIGIN_CATEGORY",
  /**
   * Description:
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_CATEGORY_OTHER: "BIZREL_ORIGIN_CATEGORY_OTHER",
  /**
   * Description: Detailed description of the origins.
   *
   * GANA Type: Paragraph
   */
  BIZREL_ORIGIN_DETAIL: "BIZREL_ORIGIN_DETAIL",
  /**
   * Description: Purpose of the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_PURPOSE: "BIZREL_PURPOSE",
  /**
   * Description: Information on the planned development of the business relationship and the assets.
   *
   * GANA Type: String
   */
  BIZREL_DEVELOPMENT: "BIZREL_DEVELOPMENT",
  /**
   * Description: In the case of cash or money and asset transfer transacction with regular customer
   *
   * GANA Type: String
   */
  BIZREL_FINANCIAL_VOLUME: "BIZREL_FINANCIAL_VOLUME",
  /**
   * Description: Relation of the customer to the beneficial owner, controlling persons, authorised signatories and other persons involved in the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_RELATIONSHIP: "BIZREL_THIRDPARTY_RELATIONSHIP",
  /**
   * Description: Relation to other AMLA-files.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_AMLA_FILES: "BIZREL_THIRDPARTY_AMLA_FILES",
  /**
   * Description: Introducer / agents / references.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_REFERENCES: "BIZREL_THIRDPARTY_REFERENCES",
  /**
   * Description: Other relevant information.
   *
   * GANA Type: String
   */
  BIZREL_FURTHER_INFO: "BIZREL_FURTHER_INFO",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  IDENTITY_CONTRACTING_PARTNER: "IDENTITY_CONTRACTING_PARTNER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  ATTACHMENT_SIGNED_DOCUMENT: "ATTACHMENT_SIGNED_DOCUMENT",
  /**
   * Description: The beneficial owners of the assets involved in the business relationship.
   *
   * GANA Type: Form<VQF_902_9_identity>[]
   */
  IDENTITY_LIST: "IDENTITY_LIST",
  /**
   * Description: Party that is filling out the form.
   *
   * GANA Type: 'AML_OFFICER' | 'CUSTOMER'
   */
  SUBMITTED_BY: "SUBMITTED_BY",
  /**
   * Description:
   *
   * GANA Type: 'HAS_25_MORE_RIGHTS' | 'OTHER_WAY' | 'DIRECTOR'
   */
  CONTROL_REASON: "CONTROL_REASON",
  /**
   * Description: Is a third person the beneficial owner of the assets?
   *
   * GANA Type: Boolean
   */
  THIRD_PARTY_OWNERSHIP: "THIRD_PARTY_OWNERSHIP",
  /**
   * Description: Description of the circumstances/transactions, which triggered the special clarifications
   *
   * GANA Type: String
   */
  INCRISK_REASON: "INCRISK_REASON",
  /**
   * Description:
   *
   * GANA Type: 'GATHERING' | 'CONSULTATION' | 'ENQUIRIES' | 'OTHER'
   */
  INCRISK_MEANS: "INCRISK_MEANS",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_MEANS_OTHER: "INCRISK_MEANS_OTHER",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  INCRISK_SUMMARY: "INCRISK_SUMMARY",
  /**
   * Description: Gathered or consulted documents
   *
   * GANA Type: Paragraph
   */
  INCRISK_DOCUMENTS: "INCRISK_DOCUMENTS",
  /**
   * Description:
   *
   * GANA Type: 'NO_SUSPICION' | 'REASONABLE_SUSPICION' | 'SIMPLE_SUSPICION' | 'OTHER'
   */
  INCRISK_RESULT: "INCRISK_RESULT",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_RESULT_OTHER: "INCRISK_RESULT_OTHER",
  /**
   * Description: First name(s) as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_FIRST_NAMES: "PERSON_FIRST_NAMES",
  /**
   * Description: Last name of an individual as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_LAST_NAME: "PERSON_LAST_NAME",
  /**
   * Description: Identification number or string of national identity card.
   *
   * GANA Type: String
   */
  PERSON_NATIONAL_ID: "PERSON_NATIONAL_ID",
  /**
   * Description: Scan of a recognized national identity card of an individual.
   *
   * GANA Type: File
   */
  PERSON_NATIONAL_ID_SCAN: "PERSON_NATIONAL_ID_SCAN",
  /**
   * Description: Nationality of an individual. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  PERSON_NATIONALITY: "PERSON_NATIONALITY",
  /**
   * Description: Confirmation that the wallet user is a private customer, not a business.
   *
   * GANA Type: Boolean
   */
  WALLET_USER_IS_PRIVATE_CUSTOMER: "WALLET_USER_IS_PRIVATE_CUSTOMER",
  /**
   * Description: Name of the company or business.
   *
   * GANA Type: String
   */
  BUSINESS_DISPLAY_NAME: "BUSINESS_DISPLAY_NAME",
  /**
   * Description: Type of company form or business (selection from fixed list).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE: "BUSINESS_TYPE",
  /**
   * Description: Type of company form or business (free-form entry for OTHER).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE_OTHER: "BUSINESS_TYPE_OTHER",
  /**
   * Description: Registration id on legal entity of the company or business.
   *
   * GANA Type: String
   */
  COMMERCIAL_REGISTER_NUMBER: "COMMERCIAL_REGISTER_NUMBER",
  /**
   * Description: City or location where the company or business is registered.
   *
   * GANA Type: String
   */
  REGISTER_COURT_LOCATION: "REGISTER_COURT_LOCATION",
  /**
   * Description: Registration founding date of the company or business. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDate
   */
  FOUNDING_DATE: "FOUNDING_DATE",
  /**
   * Description: True if the company or business is a non-profit.
   *
   * GANA Type: Boolean
   */
  BUSINESS_IS_NON_PROFIT: "BUSINESS_IS_NON_PROFIT",
  /**
   * Description: Industry in which the company or business mainly operate.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY: "BUSINESS_INDUSTRY",
  /**
   * Description: Free-form industry, when BUSINESS_INDUSTRY is OTHER.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY_OTHER: "BUSINESS_INDUSTRY_OTHER",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: GLS_BusinessRepresentative[]
   */
  BUSINESS_PERSONS: "BUSINESS_PERSONS",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: LEGAL_REPRESENTATIVE | SHAREHOLDER_GT_25_PERCENT | AUTHORIZED_EMPLOYEE
   */
  REPRESENTATIVE_TYPE: "REPRESENTATIVE_TYPE",
  /**
   * Description: DNS domain name owned by the individual or business.
   *
   * GANA Type: Hostname
   */
  CONTACT_DNS_DOMAIN: "CONTACT_DNS_DOMAIN",
  /**
   * Description: Web site owned by the individual or business.
   *
   * GANA Type: HttpHostnamePath
   */
  CONTACT_WEBSITE: "CONTACT_WEBSITE",
  /**
   * Description: E-mail address to contact the individual or business. Can be validated via E-mail with TAN.
   *
   * GANA Type: Email
   */
  CONTACT_EMAIL: "CONTACT_EMAIL",
  /**
   * Description: Phone number to contact the individual or business. Can be validated via SMS-TAN or phone call.
   *
   * GANA Type: Phone
   */
  CONTACT_PHONE: "CONTACT_PHONE",
  /**
   * Description: Natural person full-name or name of the business to contact.
   *
   * GANA Type: String
   */
  CONTACT_NAME: "CONTACT_NAME",
  /**
   * Description: Country where the individual or business resides. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  ADDRESS_COUNTRY: "ADDRESS_COUNTRY",
  /**
   * Description: Street address name of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NAME: "ADDRESS_STREET_NAME",
  /**
   * Description: Street address number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NUMBER: "ADDRESS_STREET_NUMBER",
  /**
   * Description: Additional address information of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_LINES: "ADDRESS_LINES",
  /**
   * Description: Building name of the of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NAME: "ADDRESS_BUILDING_NAME",
  /**
   * Description: Building number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NUMBER: "ADDRESS_BUILDING_NUMBER",
  /**
   * Description: Postal code of the city where the individual or business resides.
   *
   * GANA Type: String
   */
  ADDRESS_ZIPCODE: "ADDRESS_ZIPCODE",
  /**
   * Description: Town location of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_LOCATION: "ADDRESS_TOWN_LOCATION",
  /**
   * Description: Town district of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_DISTRICT: "ADDRESS_TOWN_DISTRICT",
  /**
   * Description: Country subdivision of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_COUNTRY_SUBDIVISION: "ADDRESS_COUNTRY_SUBDIVISION",
  /**
   * Description: Country name of of the individual or business.
   *
   * GANA Type: CountryCode
   */
  TAX_COUNTRY: "TAX_COUNTRY",
  /**
   * Description: Tax identifier of the individual or business.
   *
   * GANA Type: String
   */
  TAX_ID: "TAX_ID",
  /**
   * Description: Is business founded or under USA law.
   *
   * GANA Type: Boolean
   */
  TAX_IS_USA_LAW: "TAX_IS_USA_LAW",
  /**
   * Description: Is the individual or business economically active or passive.
   *
   * GANA Type: Boolean
   */
  TAX_IS_ACTIVE: "TAX_IS_ACTIVE",
  /**
   * Description: Is the business entitled to deduct input tax.
   *
   * GANA Type: Boolean
   */
  TAX_IS_DEDUCTED: "TAX_IS_DEDUCTED",
  /**
   * Description: Wirtschafts-Identifikationsnummer / Steuernummer.
   *
   * GANA Type: Boolean
   */
  DE_BUSINESS_OR_TAX_ID: "DE_BUSINESS_OR_TAX_ID",
  /**
   * Description: Name of the version of the terms of service accepted by the customer.
   *
   * GANA Type: Boolean
   */
  ACCEPTED_TERMS_OF_SERVICE: "ACCEPTED_TERMS_OF_SERVICE",
  /**
   * Description: True if the customer read or downloaded the terms of service. It should be set automatically.
   *
   * GANA Type: Boolean
   */
  DOWNLOADED_TERMS_OF_SERVICE: "DOWNLOADED_TERMS_OF_SERVICE",
  /**
   * Description: Name of the form completed by the user.
   *
   * GANA Type: String
   */
  FORM_ID: "FORM_ID",
  /**
   * Description: Version of the form completed by the user.
   *
   * GANA Type: Number
   */
  FORM_VERSION: "FORM_VERSION",
  /**
   * Description: High entropy value used in forms where hash is going to be stored in plain text.
   *
   * GANA Type: String
   */
  FORM_SALT: "FORM_SALT",
  /**
   * Description: List of supplemental file attachments.
   *
   * GANA Type: List of records, usually the file upload and a description.
   */
  SUPPLEMENTAL_FILES_LIST: "SUPPLEMENTAL_FILES_LIST",
  /**
   * Description: Generic note description
   *
   * GANA Type: String
   */
  NOTE_TEXT: "NOTE_TEXT",
  /**
   * Description: Context for form submitted by the user.
   *
   * GANA Type: JSON
   */
  FORM_CONTEXT: "FORM_CONTEXT",
  /**
   * Description: Map of uploaded files.
   *
   * GANA Type: MapStrFile
   */
  FILE_MAP: "FILE_MAP"
};

// ../taler-util/lib/types-taler-exchange.js
var DenominationPubKey;
(function(DenominationPubKey2) {
  function cmp(p1, p22) {
    if (p1.cipher < p22.cipher) {
      return -1;
    } else if (p1.cipher > p22.cipher) {
      return 1;
    } else if (p1.cipher === DenomKeyType.Rsa && p22.cipher === DenomKeyType.Rsa) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.rsa_public_key, p22.rsa_public_key);
    } else if (p1.cipher === DenomKeyType.ClauseSchnorr && p22.cipher === DenomKeyType.ClauseSchnorr) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.cs_public_key, p22.cs_public_key);
    } else {
      throw Error("unsupported cipher");
    }
  }
  DenominationPubKey2.cmp = cmp;
})(DenominationPubKey || (DenominationPubKey = {}));
var codecForNgDenominations = codecForAny();
var DenomKeyType;
(function(DenomKeyType2) {
  DenomKeyType2["Rsa"] = "RSA";
  DenomKeyType2["ClauseSchnorr"] = "CS";
})(DenomKeyType || (DenomKeyType = {}));
(function(DenomKeyType2) {
  function toIntTag(t4) {
    switch (t4) {
      case DenomKeyType2.Rsa:
        return 1;
      case DenomKeyType2.ClauseSchnorr:
        return 2;
    }
  }
  DenomKeyType2.toIntTag = toIntTag;
})(DenomKeyType || (DenomKeyType = {}));
var codecForRsaBlindedDenominationSignature = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.Rsa)).property("blinded_rsa_signature", codecForString()).build("RsaBlindedDenominationSignature");
var codecForBlindedDenominationSignature = () => buildCodecForUnion().discriminateOn("cipher").alternative(DenomKeyType.Rsa, codecForRsaBlindedDenominationSignature()).build("BlindedDenominationSignature");
var codecForExchangeWithdrawResponse = () => buildCodecForObject().property("ev_sigs", codecForList(codecForBlindedDenominationSignature())).build("WithdrawResponse");
var codecForExchangeMeltResponse = () => buildCodecForObject().property("exchange_pub", codecForEddsaPublicKey()).property("exchange_sig", codecForEddsaSignature()).property("noreveal_index", codecForNumber()).property("refresh_base_url", codecOptional(codecForString())).build("ExchangeMeltResponse");
var codecForExchangeGetContractResponse = () => buildCodecForObject().property("purse_pub", codecForString()).property("econtract_sig", codecForString()).property("econtract", codecForString()).build("ExchangeGetContractResponse");
var codecForExchangeMergeSuccessResponse = () => buildCodecForObject().property("merge_amount", codecForAmountString()).property("exchange_timestamp", codecForTimestamp).property("exchange_sig", codecForEddsaSignature()).property("exchange_pub", codecForEddsaPublicKey()).build("ExchangeMergeSuccessResponse");
var codecForExchangeMergeConflictResponse = () => buildCodecForObject().property("merge_timestamp", codecForTimestamp).property("merge_sig", codecForEddsaSignature()).property("reserve_pub", codecForEddsaPublicKey()).property("partner_url", codecOptional(codecForString())).build("ExchangeMergeConflictResponse");
var codecForExchangePurseStatus = () => buildCodecForObject().property("balance", codecForAmountString()).property("deposit_timestamp", codecOptional(codecForTimestamp)).property("merge_timestamp", codecOptional(codecForTimestamp)).build("ExchangePurseStatus");
var AmlSpaDialect;
(function(AmlSpaDialect2) {
  AmlSpaDialect2["TOPS"] = "tops";
  AmlSpaDialect2["GLS"] = "gls";
  AmlSpaDialect2["TESTING"] = "testing";
})(AmlSpaDialect || (AmlSpaDialect = {}));
var LimitOperationType;
(function(LimitOperationType2) {
  LimitOperationType2["withdraw"] = "WITHDRAW";
  LimitOperationType2["deposit"] = "DEPOSIT";
  LimitOperationType2["merge"] = "MERGE";
  LimitOperationType2["aggregate"] = "AGGREGATE";
  LimitOperationType2["balance"] = "BALANCE";
  LimitOperationType2["refund"] = "REFUND";
  LimitOperationType2["close"] = "CLOSE";
  LimitOperationType2["transaction"] = "TRANSACTION";
})(LimitOperationType || (LimitOperationType = {}));
var AmlState;
(function(AmlState2) {
  AmlState2[AmlState2["normal"] = 0] = "normal";
  AmlState2[AmlState2["pending"] = 1] = "pending";
  AmlState2[AmlState2["frozen"] = 2] = "frozen";
})(AmlState || (AmlState = {}));
var codecForAmlSpaDialect = codecForEither(codecForConstString(AmlSpaDialect.GLS), codecForConstString(AmlSpaDialect.TOPS), codecForConstString(AmlSpaDialect.TESTING));
var codecForExchangeConfig = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("taler-exchange")).property("implementation", codecOptional(codecForURN())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_kyc_requirements", codecForList(codecForString())).property("aml_spa_dialect", codecOptional(codecForAmlSpaDialect)).deprecatedProperty("shopping_url").deprecatedProperty("wallet_balance_limit_without_kyc").build("TalerExchangeApi.ExchangeVersionResponse");
var codecForExchangeKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForURLString()).property("currency", codecForString()).property("accounts", codecForAny()).property("asset_type", codecForAny()).property("auditors", codecForAny()).property("currency_specification", codecForAny()).property("zero_limits", codecForAny()).property("hard_limits", codecForAny()).property("denominations", codecForAny()).property("exchange_pub", codecForAny()).property("exchange_sig", codecForAny()).property("extensions", codecForAny()).property("extensions_sig", codecForAny()).property("global_fees", codecForAny()).property("list_issue_date", codecForAny()).property("master_public_key", codecForAny()).property("recoup", codecForAny()).property("reserve_closing_delay", codecForAny()).property("signkeys", codecForAny()).property("stefan_abs", codecForAny()).property("stefan_lin", codecForAny()).property("stefan_log", codecForAny()).property("wads", codecForAny()).property("wallet_balance_limit_without_kyc", codecForAny()).property("wire_fees", codecForAny()).property("kyc_enabled", codecOptional(codecForBoolean())).property("shopping_url", codecOptional(codecForString())).property("tiny_amount", codecOptional(codecForAmountString())).property("disable_direct_deposit", codecOptional(codecForBoolean())).property("bank_compliance_language", codecOptional(codecForString())).property("open_banking_gateway", codecOptional(codecForURLString())).deprecatedProperty("rewards_allowed").build("TalerExchangeApi.ExchangeKeysResponse");
var codecForAmlStatisticsResponse = () => buildCodecForObject().property("statistics", codecForList(codecForEventCounter())).build("TalerExchangeApi.AmlStatisticsResponse");
var codecForEventCounter = () => buildCodecForObject().property("name", codecForString()).property("counter", codecForNumber()).build("TalerExchangeApi.EventCounter");
var codecForLegitimizationMeasuresList = () => buildCodecForObject().property("measures", codecForList(codecForLegitimizationMeasureDetails())).build("TalerExchangeApi.LegitimizationMeasuresList");
var codecForLegitimizationMeasureDetails = () => buildCodecForObject().property("h_payto", codecForAny()).property("rowid", codecForAny()).property("start_time", codecForAny()).property("measures", codecForAny()).property("is_finished", codecForAny()).build("TalerExchangeApi.LegitimizationMeasureDetails");
var codecForAvailableMeasureSummary = () => buildCodecForObject().property("checks", codecForMap(codecForKycCheckInformation())).property("programs", codecForMap(codecForAmlProgramRequirement())).property("roots", codecForMap(codecForMeasureInformation())).property("default_rules", codecForList(codecForKycRules())).build("TalerExchangeApi.AvailableMeasureSummary");
var codecForAmlProgramRequirement = () => buildCodecForObject().property("description", codecForString()).property("context", codecForList(codecForString())).property("inputs", codecForList(codecForString())).build("TalerExchangeApi.AmlProgramRequirement");
var codecForKycCheckInformation = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("fallback", codecForString()).property("outputs", codecForList(codecForString())).property("requires", codecForList(codecForString())).build("TalerExchangeApi.KycCheckInformation");
var codecForMeasureInformation = () => buildCodecForObject().property("prog_name", codecOptional(codecForString())).property("check_name", codecForString()).property("context", codecForAny()).property("operation_type", codecOptional(codecForOperationType)).property("voluntary", codecOptional(codecForBoolean())).build("TalerExchangeApi.MeasureInformation");
var codecForAmlDecisionsResponse = () => buildCodecForObject().property("records", codecForList(codecForAmlDecision())).build("TalerExchangeApi.AmlDecisionsResponse");
var codecForAmlCustomerAccountSummary = () => buildCodecForObject().property("h_payto", codecForPaytoHash()).property("close_time", codecForTimestamp).property("open_time", codecForTimestamp).property("comments", codecOptional(codecForString())).property("full_payto", codecFullForPaytoString()).property("high_risk", codecForBoolean()).property("rowid", codecForNumber()).property("to_investigate", codecForBoolean()).build("TalerExchangeApi.CustomerAccountSummary");
var codecForAmlDecisionsAccounts = () => buildCodecForObject().property("accounts", codecForList(codecForAmlCustomerAccountSummary())).build("TalerExchangeApi.AmlAccountsResponse");
var codecForAmlDecision = () => buildCodecForObject().property("h_payto", codecForString()).property("full_payto", codecOptional(codecForString())).property("rowid", codecForNumber()).property("is_wallet", codecForBoolean()).property("justification", codecOptional(codecForString())).property("decision_time", codecForTimestamp).property("properties", codecOptional(codecForAccountProperties())).property("limits", codecForLegitimizationRuleSet()).property("to_investigate", codecForBoolean()).property("is_active", codecForBoolean()).build("TalerExchangeApi.AmlDecision");
var codecForAccountProperties = () => buildCodecForObject().property("pep", codecOptional(codecForBoolean())).property("sanctioned", codecOptional(codecForBoolean())).property("high_risk", codecOptional(codecForBoolean())).property("business_domain", codecOptional(codecForString())).property("is_frozen", codecOptional(codecForBoolean())).property("was_reported", codecOptional(codecForBoolean())).allowExtra().build("TalerExchangeApi.AccountProperties");
var codecForLegitimizationRuleSet = () => buildCodecForObject().property("expiration_time", codecForTimestamp).property("successor_measure", codecOptional(codecForString())).property("rules", codecForList(codecForKycRules())).property("custom_measures", codecForMap(codecForMeasureInformation())).build("TalerExchangeApi.LegitimizationRuleSet");
var codecForKycRules = () => buildCodecForObject().property("operation_type", codecForOperationType).property("threshold", codecForAmountString()).property("timeframe", codecForDuration).property("measures", codecForList(codecForString())).property("display_priority", codecForNumber()).property("exposed", codecOptional(codecForBoolean())).property("is_and_combinator", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.KycRule");
var codecForAmlKycAttributes = () => buildCodecForObject().property("details", codecForList(codecForKycAttributeCollectionEvent())).build("TalerExchangeApi.KycAttributes");
var codecForKycAttributeCollectionEvent = () => buildCodecForObject().property("rowid", codecForNumber()).property("provider_name", codecOptional(codecForString())).property("collection_time", codecForTimestamp).property("attributes", codecOptional(codecForAny())).build("TalerExchangeApi.KycAttributeCollectionEvent");
var codecForAmlWalletKycCheckResponse = () => buildCodecForObject().property("next_threshold", codecOptional(codecForAmountString())).property("expiration_time", codecForTimestamp).build("TalerExchangeApi.WalletKycCheckResponse");
var codecForLegitimizationNeededResponse = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecOptional(codecForString())).property("h_payto", codecForString()).property("account_pub", codecOptional(codecForEddsaPublicKey())).property("requirement_row", codecForNumber()).property("bad_kyc_auth", codecOptional(codecForBoolean())).build("TalerExchangeApi.LegitimizationNeededResponse");
var codecForAccountKycStatus = () => buildCodecForObject().property("aml_review", codecForBoolean()).property("access_token", codecForAccessToken()).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("rule_gen", codecForNumber()).build("TalerExchangeApi.AccountKycStatus");
var codecForOperationType = codecForEither(codecForConstString(LimitOperationType.withdraw), codecForConstString(LimitOperationType.deposit), codecForConstString(LimitOperationType.merge), codecForConstString(LimitOperationType.balance), codecForConstString(LimitOperationType.close), codecForConstString(LimitOperationType.aggregate), codecForConstString(LimitOperationType.transaction), codecForConstString(LimitOperationType.refund));
var codecForAccountLimit = () => buildCodecForObject().property("operation_type", codecForOperationType).property("timeframe", codecForDuration).property("threshold", codecForAmountString()).property("soft_limit", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.AccountLimit");
var codecForKycRequirementInformationId = () => codecForString();
var codecForKycFormId = () => codecForString();
var codecForKycRequirementInformation = () => buildCodecForObject().property("form", codecForEither(codecForConstString("LINK"), codecForConstString("INFO"), codecForKycFormId())).property("description", codecForString()).property("context", codecOptional(codecForAny())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("id", codecOptional(codecForKycRequirementInformationId())).build("TalerExchangeApi.KycRequirementInformation");
var codecForKycProcessClientInformation = () => buildCodecForObject().property("requirements", codecOptionalDefault(codecForList(codecForKycRequirementInformation()), [])).property("is_and_combinator", codecOptional(codecForBoolean())).property("voluntary_measures", codecOptional(codecForList(codecForKycRequirementInformation()))).build("TalerExchangeApi.KycProcessClientInformation");
var codecForExchangeTransferList = () => buildCodecForObject().property("transfers", codecForList(codecForExchangeTransferListEntry())).build("TalerExchangeApi.ExchangeTransferList");
var codecForExchangeTransferListEntry = () => buildCodecForObject().property("rowid", codecForNumber()).property("payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("execution_time", codecForTimestamp).build("TalerExchangeApi.ExchangeTransferListEntry");
var codecForKycProcessStartInformation = () => buildCodecForObject().property("redirect_url", codecForURLString()).build("TalerExchangeApi.KycProcessStartInformation");
var TransactionHistoryType;
(function(TransactionHistoryType2) {
  TransactionHistoryType2["setup"] = "SETUP";
  TransactionHistoryType2["withdraw"] = "WITHDRAW";
  TransactionHistoryType2["ageWithdraw"] = "AGEWITHDRAW";
  TransactionHistoryType2["credit"] = "CREDIT";
  TransactionHistoryType2["closing"] = "CLOSING";
  TransactionHistoryType2["open"] = "OPEN";
  TransactionHistoryType2["close"] = "CLOSE";
  TransactionHistoryType2["merge"] = "MERGE";
})(TransactionHistoryType || (TransactionHistoryType = {}));
var codecForPurseConflict = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_GENERIC_INSUFFICIENT_FUNDS, codecForDepositDoubleSpendError()).alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflict");
var codecForPurseConflictPartial = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflictPartial");
var codecForDepositDoubleSpendError = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("coin_pub", codecForString()).build("DepositDoubleSpendError");
var codecForPurseCreateConflict = () => buildCodecForObject().property("code", codecForNumber()).property("amount", codecForAmountString()).property("min_age", codecForNumber()).property("purse_expiration", codecForTimestamp).property("purse_sig", codecForString()).property("h_contract_terms", codecForString()).property("merge_pub", codecForString()).build("PurseCreateConflict");
var codecForPurseDepositConflict = () => buildCodecForObject().property("code", codecForNumber()).property("coin_pub", codecForString()).property("partner_url", codecOptional(codecForString())).property("amount", codecForAmountString()).build("PurseDepositConflict");
var codecForPurseContractConflict = () => buildCodecForObject().property("code", codecForNumber()).property("h_econtract", codecForString()).property("econtract_sig", codecForString()).property("contract_pub", codecForString()).build("PurseContractConflict");

// ../taler-util/lib/taler_signatures.js
var TalerSignaturePurpose;
(function(TalerSignaturePurpose2) {
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_AML_KEY"] = 1017] = "MASTER_AML_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DRAIN_PROFIT"] = 1018] = "MASTER_DRAIN_PROFIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_PARTNER_DETAILS"] = 1019] = "MASTER_PARTNER_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_SIGNING_KEY_REVOKED"] = 1020] = "MASTER_SIGNING_KEY_REVOKED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_ADD_WIRE"] = 1021] = "MASTER_ADD_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_GLOBAL_FEES"] = 1022] = "MASTER_GLOBAL_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DEL_WIRE"] = 1023] = "MASTER_DEL_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_SIGNING_KEY_VALIDITY"] = 1024] = "MASTER_SIGNING_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_ADD_AUDITOR"] = 1026] = "MASTER_ADD_AUDITOR";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DEL_AUDITOR"] = 1027] = "MASTER_DEL_AUDITOR";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_REVOKED"] = 1029] = "MASTER_DENOMINATION_KEY_REVOKED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_DETAILS"] = 1030] = "MASTER_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_EXTENSION"] = 1031] = "MASTER_EXTENSION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_STATUS"] = 1032] = "EXCHANGE_RESERVE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_DEPOSIT"] = 1033] = "EXCHANGE_CONFIRM_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_MELT"] = 1034] = "EXCHANGE_CONFIRM_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_KEY_SET"] = 1035] = "EXCHANGE_KEY_SET";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WIRE"] = 1036] = "EXCHANGE_CONFIRM_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WIRE_DEPOSIT"] = 1037] = "EXCHANGE_CONFIRM_WIRE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_REFUND"] = 1038] = "EXCHANGE_CONFIRM_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP"] = 1039] = "EXCHANGE_CONFIRM_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_CLOSED"] = 1040] = "EXCHANGE_RESERVE_CLOSED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP_REFRESH"] = 1041] = "EXCHANGE_CONFIRM_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_AFFIRM_DENOM_UNKNOWN"] = 1042] = "EXCHANGE_AFFIRM_DENOM_UNKNOWN";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_AFFIRM_DENOM_EXPIRED"] = 1043] = "EXCHANGE_AFFIRM_DENOM_EXPIRED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_CREATION"] = 1045] = "EXCHANGE_CONFIRM_PURSE_CREATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_MERGED"] = 1046] = "EXCHANGE_CONFIRM_PURSE_MERGED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_PURSE_STATUS"] = 1047] = "EXCHANGE_PURSE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_ATTEST_DETAILS"] = 1048] = "EXCHANGE_RESERVE_ATTEST_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_REFUND"] = 1049] = "EXCHANGE_CONFIRM_PURSE_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WITHDRAW"] = 1050] = "EXCHANGE_CONFIRM_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AUDITOR_EXCHANGE_KEYS"] = 1064] = "AUDITOR_EXCHANGE_KEYS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_CONTRACT"] = 1101] = "MERCHANT_CONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_REFUND"] = 1102] = "MERCHANT_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TRACK_TRANSACTION"] = 1103] = "MERCHANT_TRACK_TRANSACTION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_WIRE_DETAILS"] = 1107] = "MERCHANT_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TOKEN_ISSUE"] = 1108] = "MERCHANT_TOKEN_ISSUE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_WITHDRAW"] = 1200] = "WALLET_RESERVE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP"] = 1203] = "WALLET_COIN_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_LINK"] = 1204] = "WALLET_COIN_LINK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_SETUP"] = 1205] = "WALLET_ACCOUNT_SETUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP_REFRESH"] = 1206] = "WALLET_COIN_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_AGE_ATTESTATION"] = 1207] = "WALLET_AGE_ATTESTATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_HISTORY"] = 1208] = "WALLET_RESERVE_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_HISTORY"] = 1209] = "WALLET_COIN_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_CREATE"] = 1210] = "WALLET_PURSE_CREATE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DEPOSIT"] = 1211] = "WALLET_PURSE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_STATUS"] = 1212] = "WALLET_PURSE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_MERGE"] = 1213] = "WALLET_PURSE_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_MERGE"] = 1214] = "WALLET_ACCOUNT_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_CLOSE"] = 1215] = "WALLET_RESERVE_CLOSE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_ECONTRACT"] = 1216] = "WALLET_PURSE_ECONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_OPEN"] = 1217] = "WALLET_RESERVE_OPEN";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_OPEN_DEPOSIT"] = 1218] = "WALLET_RESERVE_OPEN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_ATTEST_DETAILS"] = 1219] = "WALLET_RESERVE_ATTEST_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DELETE"] = 1220] = "WALLET_PURSE_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_AGE_WITHDRAW"] = 1221] = "WALLET_RESERVE_AGE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_TOKEN_USE"] = 1222] = "WALLET_TOKEN_USE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_RSA_DENOMINATION_KEY"] = 1250] = "SM_RSA_DENOMINATION_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_SIGNING_KEY"] = 1251] = "SM_SIGNING_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_CS_DENOMINATION_KEY"] = 1252] = "SM_CS_DENOMINATION_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["CLIENT_TEST_EDDSA"] = 1302] = "CLIENT_TEST_EDDSA";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_TEST_EDDSA"] = 1303] = "EXCHANGE_TEST_EDDSA";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_DECISION"] = 1350] = "AML_DECISION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_QUERY"] = 1351] = "AML_QUERY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["KYC_AUTH"] = 1360] = "KYC_AUTH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_UPLOAD"] = 1400] = "ANASTASIS_POLICY_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SYNC_BACKUP_UPLOAD"] = 1450] = "SYNC_BACKUP_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MAILBOX_MESSAGES_DELETE"] = 1551] = "MAILBOX_MESSAGES_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MAILBOX_KEYS_UPDATE"] = 1552] = "MAILBOX_KEYS_UPDATE";
})(TalerSignaturePurpose || (TalerSignaturePurpose = {}));

// ../taler-util/lib/taler-crypto.js
var isEddsaPubP = Symbol("isEddsaPubP");
var isEddsaPrivP = Symbol("isEddsaPrivP");
var isEddsaSigP = Symbol("isEddsaSigP");
var isEdx25519PublicKey = Symbol("isEdx25519PublicKey");
var isEdx25519PrivateKey = Symbol("isEdx25519PrivateKey");
var isEcdhePrivP = Symbol("isEcdhePrivP");
var isEdx25519Signature = Symbol("isEdx25519Signature");
var isEdx25519PublicKeyEnc = Symbol("isEdx25519PublicKeyEnc");
var isEdx25519PrivateKeyEnc = Symbol("isEdx25519PrivateKeyEnc");
var isEncryptionNonce = Symbol("isEncryptionNone");
function getRandomBytes(n2) {
  return randomBytes(n2);
}
var useNative = true;
var tart;
if (useNative) {
  tart = globalThis._tart;
}
var encTable = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
var EncodingError = class _EncodingError extends Error {
  constructor() {
    super("Encoding error");
    Object.setPrototypeOf(this, _EncodingError.prototype);
  }
};
function getValue(chr) {
  let a4 = chr;
  switch (chr) {
    case "O":
    case "o":
      a4 = "0";
      break;
    case "i":
    case "I":
    case "l":
    case "L":
      a4 = "1";
      break;
    case "u":
    case "U":
      a4 = "V";
  }
  if (a4 >= "0" && a4 <= "9") {
    return a4.charCodeAt(0) - "0".charCodeAt(0);
  }
  if (a4 >= "a" && a4 <= "z")
    a4 = a4.toUpperCase();
  let dec = 0;
  if (a4 >= "A" && a4 <= "Z") {
    if ("I" < a4)
      dec++;
    if ("L" < a4)
      dec++;
    if ("O" < a4)
      dec++;
    if ("U" < a4)
      dec++;
    return a4.charCodeAt(0) - "A".charCodeAt(0) + 10 - dec;
  }
  throw new EncodingError();
}
function encodeCrock(data) {
  if (tart) {
    return tart.encodeCrock(data);
  }
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d4 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d4;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable[v3];
    numBits -= 5;
  }
  return sb;
}
function kdf(outputLength, ikm, salt, info) {
  if (tart) {
    return tart.kdf(outputLength, ikm, salt, info);
  }
  salt = salt ?? new Uint8Array(64);
  const prk = hmacSha512(salt, ikm);
  info = info ?? new Uint8Array(0);
  const N3 = Math.ceil(outputLength / 32);
  const output = new Uint8Array(N3 * 32);
  for (let i4 = 0; i4 < N3; i4++) {
    let buf;
    if (i4 == 0) {
      buf = new Uint8Array(info.byteLength + 1);
      buf.set(info, 0);
    } else {
      buf = new Uint8Array(info.byteLength + 1 + 32);
      for (let j4 = 0; j4 < 32; j4++) {
        buf[j4] = output[(i4 - 1) * 32 + j4];
      }
      buf.set(info, 32);
    }
    buf[buf.length - 1] = i4 + 1;
    const chunk = hmacSha256(prk, buf);
    output.set(chunk, i4 * 32);
  }
  return output.slice(0, outputLength);
}
function kdfKw(args) {
  return kdf(args.outputLength, args.ikm, args.salt, args.info);
}
function decodeCrock(encoded) {
  if (tart) {
    return tart.decodeCrock(encoded);
  }
  const size = encoded.length;
  let bitpos = 0;
  let bitbuf = 0;
  let readPosition = 0;
  const outLen = Math.floor(size * 5 / 8);
  const out = new Uint8Array(outLen);
  let outPos = 0;
  while (readPosition < size || bitpos > 0) {
    if (readPosition < size) {
      const v3 = getValue(encoded[readPosition++]);
      bitbuf = bitbuf << 5 | v3;
      bitpos += 5;
    }
    while (bitpos >= 8) {
      const d4 = bitbuf >>> bitpos - 8 & 255;
      out[outPos++] = d4;
      bitpos -= 8;
    }
    if (readPosition == size && bitpos > 0) {
      bitbuf = bitbuf << 8 - bitpos & 255;
      bitpos = bitbuf == 0 ? 0 : 8;
    }
  }
  return out;
}
function eddsaGetPublic(eddsaPriv) {
  if (tart) {
    return tart.eddsaGetPublic(eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return pair.publicKey;
}
var encoder;
function stringToBytes(s4) {
  if (!encoder) {
    encoder = new TextEncoder();
  }
  return encoder.encode(s4);
}
function typedArrayConcat(chunks) {
  let payloadLen = 0;
  for (const c4 of chunks) {
    payloadLen += c4.byteLength;
  }
  const buf = new ArrayBuffer(payloadLen);
  const u8buf = new Uint8Array(buf);
  let p4 = 0;
  for (const c4 of chunks) {
    u8buf.set(c4, p4);
    p4 += c4.byteLength;
  }
  return u8buf;
}
function createEddsaKeyPair() {
  const eddsaPriv = randomBytes(32);
  const eddsaPub = eddsaGetPublic(eddsaPriv);
  return { eddsaPriv, eddsaPub };
}
function hash2(d4) {
  if (tart) {
    return tart.hash(d4);
  }
  return hash(d4);
}
function hashTruncate32(d4) {
  const sha512HashCode = hash2(d4);
  return sha512HashCode.subarray(0, 32);
}
var logger4 = new Logger("talerCrypto.ts");
function eddsaSign(msg, eddsaPriv) {
  if (tart) {
    return tart.eddsaSign(msg, eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return sign_detached(msg, pair.secretKey);
}
function bufferForUint32(n2) {
  const arrBuf = new ArrayBuffer(4);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  dv.setUint32(0, n2);
  return buf;
}
function bufferForUint64(n2) {
  const arrBuf = new ArrayBuffer(8);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  if (n2 < 0 || !Number.isInteger(n2)) {
    throw Error("non-negative integer expected");
  }
  dv.setBigUint64(0, BigInt(n2));
  return buf;
}
var WalletAccountMergeFlags;
(function(WalletAccountMergeFlags2) {
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["None"] = 0] = "None";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["MergeFullyPaidPurse"] = 1] = "MergeFullyPaidPurse";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateFromPurseQuota"] = 2] = "CreateFromPurseQuota";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateWithPurseFee"] = 3] = "CreateWithPurseFee";
})(WalletAccountMergeFlags || (WalletAccountMergeFlags = {}));
var SignaturePurposeBuilder = class {
  constructor(purposeNum) {
    this.purposeNum = purposeNum;
    this.chunks = [];
  }
  put(bytes) {
    this.chunks.push(Uint8Array.from(bytes));
    return this;
  }
  build() {
    let payloadLen = 0;
    for (const c4 of this.chunks) {
      payloadLen += c4.byteLength;
    }
    const buf = new ArrayBuffer(4 + 4 + payloadLen);
    const u8buf = new Uint8Array(buf);
    let p4 = 8;
    for (const c4 of this.chunks) {
      u8buf.set(c4, p4);
      p4 += c4.byteLength;
    }
    const dvbuf = new DataView(buf);
    dvbuf.setUint32(0, payloadLen + 4 + 4);
    dvbuf.setUint32(4, this.purposeNum);
    return u8buf;
  }
};
function buildSigPS(purposeNum) {
  return new SignaturePurposeBuilder(purposeNum);
}
function bigintToNaclArr(x5, size) {
  const byteArr = new Uint8Array(size);
  const arr = x5.toArray(256).value.reverse();
  byteArr.set(arr, 0);
  return byteArr;
}
function bigintFromNaclArr(arr) {
  let rev = new Uint8Array(arr);
  rev = rev.reverse();
  return import_big_integer.default.fromArray(Array.from(rev), 256, false);
}
var Edx25519;
(function(Edx255192) {
  const revL = [
    237,
    211,
    245,
    92,
    26,
    99,
    18,
    88,
    214,
    156,
    247,
    162,
    222,
    249,
    222,
    20,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    16
  ];
  const L5 = import_big_integer.default.fromArray(revL.reverse(), 256, false);
  async function keyCreateFromSeed(seed) {
    return crypto_edx25519_private_key_create_from_seed(seed);
  }
  Edx255192.keyCreateFromSeed = keyCreateFromSeed;
  async function keyCreate() {
    return crypto_edx25519_private_key_create();
  }
  Edx255192.keyCreate = keyCreate;
  async function getPublic(priv) {
    return crypto_edx25519_get_public(priv);
  }
  Edx255192.getPublic = getPublic;
  function sign2(msg, key) {
    throw Error("not implemented");
  }
  Edx255192.sign = sign2;
  async function deriveFactor(pub, seed) {
    const res = kdfKw({
      outputLength: 64,
      ikm: pub,
      salt: stringToBytes("edx25519-derivation"),
      info: seed
    });
    return res;
  }
  async function privateKeyDerive(priv, seed) {
    const pub = await getPublic(priv);
    const privDec = priv;
    const a4 = bigintFromNaclArr(privDec.subarray(0, 32));
    const factorEnc = await deriveFactor(pub, seed);
    const factorModL = bigintFromNaclArr(factorEnc).mod(L5);
    const aPrime = a4.divide(8).multiply(factorModL).mod(L5).multiply(8).mod(L5);
    const bPrime = hash(typedArrayConcat([privDec.subarray(32, 64), factorEnc])).subarray(0, 32);
    const newPriv = typedArrayConcat([bigintToNaclArr(aPrime, 32), bPrime]);
    return newPriv;
  }
  Edx255192.privateKeyDerive = privateKeyDerive;
  async function publicKeyDerive(pub, seed) {
    const factorEnc = await deriveFactor(pub, seed);
    const factorReduced = crypto_core_ed25519_scalar_reduce(factorEnc);
    const res = crypto_scalarmult_ed25519_noclamp(factorReduced, pub);
    return res;
  }
  Edx255192.publicKeyDerive = publicKeyDerive;
})(Edx25519 || (Edx25519 = {}));
function invariant(cond) {
  if (!cond) {
    throw Error("invariant failed");
  }
}
var AgeRestriction;
(function(AgeRestriction2) {
  AgeRestriction2.AGE_UNRESTRICTED = 32;
  function hashCommitment(ac) {
    const hc = new HashState();
    for (const pub of ac.publicKeys) {
      hc.update(decodeCrock(pub));
    }
    return encodeCrock(hc.finish().subarray(0, 32));
  }
  AgeRestriction2.hashCommitment = hashCommitment;
  function countAgeGroups(mask) {
    let count = 0;
    let m4 = mask;
    while (m4 > 0) {
      count += m4 & 1;
      m4 = m4 >> 1;
    }
    return count;
  }
  AgeRestriction2.countAgeGroups = countAgeGroups;
  function getAgeGroupsFromMask(mask) {
    const groups = [];
    let age = 1;
    let m4 = mask >> 1;
    while (m4 > 0) {
      if (m4 & 1) {
        groups.push(age);
      }
      m4 = m4 >> 1;
      age++;
    }
    return groups;
  }
  AgeRestriction2.getAgeGroupsFromMask = getAgeGroupsFromMask;
  function getAgeGroupIndex(mask, age) {
    invariant((mask & 1) === 1);
    let i4 = 0;
    let m4 = mask;
    let a4 = age;
    while (m4 > 0) {
      if (a4 <= 0) {
        break;
      }
      m4 = m4 >> 1;
      i4 += m4 & 1;
      a4--;
    }
    return i4;
  }
  AgeRestriction2.getAgeGroupIndex = getAgeGroupIndex;
  function ageGroupSpecToMask(ageGroupSpec) {
    throw Error("not implemented");
  }
  AgeRestriction2.ageGroupSpecToMask = ageGroupSpecToMask;
  async function restrictionCommit(ageMask, age) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i4 = 0; i4 < numPubs; i4++) {
      const priv = await Edx25519.keyCreate();
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      if (i4 < numPrivs) {
        privs.push(priv);
      }
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: privs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.restrictionCommit = restrictionCommit;
  const PublishedAgeRestrictionBaseKey = decodeCrock("CH0VKFDZ2GWRWHQBBGEK9MWV5YDQVJ0RXEE0KYT3NMB69F0R96TG");
  async function restrictionCommitSeeded(ageMask, age, seed) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i4 = 0; i4 < numPrivs; i4++) {
      const privSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-commitment"),
        salt: bufferForUint32(i4)
      });
      const priv = await Edx25519.keyCreateFromSeed(privSeed);
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      privs.push(priv);
    }
    for (let i4 = numPrivs; i4 < numPubs; i4++) {
      const deriveSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-factor"),
        salt: bufferForUint32(i4)
      });
      const pub = await Edx25519.publicKeyDerive(PublishedAgeRestrictionBaseKey, deriveSeed);
      pubs.push(pub);
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: privs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.restrictionCommitSeeded = restrictionCommitSeeded;
  async function commitCompare(c1, c22, salt) {
    if (c1.publicKeys.length != c22.publicKeys.length) {
      return false;
    }
    for (let i4 = 0; i4 < c1.publicKeys.length; i4++) {
      const k1 = decodeCrock(c1.publicKeys[i4]);
      const k22 = await Edx25519.publicKeyDerive(decodeCrock(c22.publicKeys[i4]), salt);
      if (k1 != k22) {
        return false;
      }
    }
    return true;
  }
  AgeRestriction2.commitCompare = commitCompare;
  async function commitmentDerive(commitmentProof, salt) {
    const newPrivs = [];
    const newPubs = [];
    for (const oldPub of commitmentProof.commitment.publicKeys) {
      newPubs.push(await Edx25519.publicKeyDerive(decodeCrock(oldPub), salt));
    }
    for (const oldPriv of commitmentProof.proof.privateKeys) {
      newPrivs.push(await Edx25519.privateKeyDerive(decodeCrock(oldPriv), salt));
    }
    return {
      commitment: {
        mask: commitmentProof.commitment.mask,
        publicKeys: newPubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: newPrivs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.commitmentDerive = commitmentDerive;
  function commitmentAttest(commitmentProof, age) {
    const d4 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitmentProof.commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitmentProof.commitment.mask, age);
    if (group === 0) {
      return new Uint8Array(64);
    }
    const priv = commitmentProof.proof.privateKeys[group - 1];
    const pub = commitmentProof.commitment.publicKeys[group - 1];
    const sig = crypto_edx25519_sign_detached(d4, decodeCrock(priv), decodeCrock(pub));
    return sig;
  }
  AgeRestriction2.commitmentAttest = commitmentAttest;
  function commitmentVerify(commitment, sig, age) {
    const d4 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitment.mask, age);
    if (group === 0) {
      return true;
    }
    const pub = commitment.publicKeys[group - 1];
    return crypto_edx25519_sign_detached_verify(d4, decodeCrock(sig), decodeCrock(pub));
  }
  AgeRestriction2.commitmentVerify = commitmentVerify;
})(AgeRestriction || (AgeRestriction = {}));
async function deriveKey(keySeed, nonce, salt) {
  return kdfKw({
    outputLength: 32,
    salt: nonce,
    ikm: keySeed,
    info: stringToBytes(salt)
  });
}
async function encryptWithDerivedKey(nonce, keySeed, plaintext, salt) {
  const key = await deriveKey(keySeed, nonce, salt);
  const cipherText = secretbox(plaintext, nonce, key);
  return typedArrayConcat([nonce, cipherText]);
}
var ContractFormatTag;
(function(ContractFormatTag2) {
  ContractFormatTag2[ContractFormatTag2["PaymentOffer"] = 0] = "PaymentOffer";
  ContractFormatTag2[ContractFormatTag2["PaymentRequest"] = 1] = "PaymentRequest";
})(ContractFormatTag || (ContractFormatTag = {}));
function bufferFromAmount(amount) {
  const amountJ = Amounts.jsonifyAmount(amount);
  const buffer = new ArrayBuffer(8 + 4 + 12);
  const dvbuf = new DataView(buffer);
  const u8buf = new Uint8Array(buffer);
  const curr = stringToBytes(amountJ.currency);
  if (typeof dvbuf.setBigUint64 !== "undefined") {
    dvbuf.setBigUint64(0, BigInt(amountJ.value));
  } else {
    const arr = (0, import_big_integer.default)(amountJ.value).toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i4 = 0; i4 < arr.length; i4++) {
      dvbuf.setUint8(offset++, arr[i4]);
    }
  }
  dvbuf.setUint32(8, amountJ.fraction);
  u8buf.set(curr, 8 + 4);
  return u8buf;
}
var foreverNum = 2n ** 64n - 1n;
function timestampRoundedToBuffer(ts) {
  const b4 = new ArrayBuffer(8);
  const v3 = new DataView(b4);
  const numVal = ts.t_s === "never" ? foreverNum : BigInt(ts.t_s) * 1000n * 1000n;
  if (typeof v3.setBigUint64 !== "undefined") {
    v3.setBigUint64(0, numVal);
  } else {
    const s4 = ts.t_s === "never" ? (0, import_big_integer.default)(foreverNum) : (0, import_big_integer.default)(ts.t_s).multiply(1e3 * 1e3);
    const arr = s4.toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i4 = 0; i4 < arr.length; i4++) {
      v3.setUint8(offset++, arr[i4]);
    }
  }
  return new Uint8Array(b4);
}
var HpkeRole;
(function(HpkeRole2) {
  HpkeRole2[HpkeRole2["Sender"] = 0] = "Sender";
  HpkeRole2[HpkeRole2["Receiver"] = 1] = "Receiver";
})(HpkeRole || (HpkeRole = {}));
var HpkeMode;
(function(HpkeMode2) {
  HpkeMode2[HpkeMode2["Base"] = 0] = "Base";
  HpkeMode2[HpkeMode2["PSK"] = 1] = "PSK";
})(HpkeMode || (HpkeMode = {}));

// ../taler-util/lib/types-taler-merchant.js
var MerchantContractVersion;
(function(MerchantContractVersion2) {
  MerchantContractVersion2[MerchantContractVersion2["V0"] = 0] = "V0";
  MerchantContractVersion2[MerchantContractVersion2["V1"] = 1] = "V1";
})(MerchantContractVersion || (MerchantContractVersion = {}));
var MerchantContractInputType;
(function(MerchantContractInputType2) {
  MerchantContractInputType2["Token"] = "token";
})(MerchantContractInputType || (MerchantContractInputType = {}));
var MerchantContractOutputType;
(function(MerchantContractOutputType2) {
  MerchantContractOutputType2["Token"] = "token";
  MerchantContractOutputType2["TaxReceipt"] = "tax-receipt";
})(MerchantContractOutputType || (MerchantContractOutputType = {}));
var MerchantContractTokenKind;
(function(MerchantContractTokenKind2) {
  MerchantContractTokenKind2["Subscription"] = "subscription";
  MerchantContractTokenKind2["Discount"] = "discount";
})(MerchantContractTokenKind || (MerchantContractTokenKind = {}));
var codecForLocation = () => buildCodecForObject().property("country", codecOptional(codecForString())).property("country_subdivision", codecOptional(codecForString())).property("building_name", codecOptional(codecForString())).property("building_number", codecOptional(codecForString())).property("district", codecOptional(codecForString())).property("street", codecOptional(codecForString())).property("post_code", codecOptional(codecForString())).property("town", codecOptional(codecForString())).property("town_location", codecOptional(codecForString())).property("address_lines", codecOptional(codecForList(codecForString()))).build("Location");
var codecForMerchantInfo = () => buildCodecForObject().property("name", codecForString()).property("address", codecOptional(codecForLocation())).property("jurisdiction", codecOptional(codecForLocation())).build("MerchantInfo");
var codecForMerchantContractTermsCommon = () => buildCodecForObject().property("order_id", codecForString()).property("fulfillment_url", codecOptional(codecForString())).property("fulfillment_message", codecOptional(codecForString())).property("fulfillment_message_i18n", codecOptional(codecForInternationalizedString())).property("public_reorder_url", codecOptional(codecForString())).property("merchant_base_url", codecForString()).property("h_wire", codecForString()).property("auto_refund", codecOptional(codecForDuration)).property("wire_method", codecForString()).property("summary", codecForString()).property("summary_i18n", codecOptional(codecForInternationalizedString())).property("nonce", codecForString()).property("pay_deadline", codecForTimestamp).property("refund_deadline", codecForTimestamp).property("wire_transfer_deadline", codecForTimestamp).property("timestamp", codecForTimestamp).property("delivery_location", codecOptional(codecForLocation())).property("delivery_date", codecOptional(codecForTimestamp)).property("merchant", codecForMerchantInfo()).property("merchant_pub", codecForString()).property("exchanges", codecForList(codecForExchange())).property("products", codecOptional(codecForList(codecForProduct()))).property("extra", codecForAny()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractTermsCommon");
var codecForMerchantContractTermsV0 = () => buildCodecForObject().property("version", codecOptional(codecForConstNumber(MerchantContractVersion.V0))).property("amount", codecForAmountString()).property("max_fee", codecForAmountString()).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV0");
var codecForMerchantContractTermsV1 = () => buildCodecForObject().property("version", codecForConstNumber(MerchantContractVersion.V1)).property("choices", codecForList(codecForMerchantContractChoice())).property("token_families", codecForMap(codecForMerchantContractTokenFamily())).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV1");
var codecForMerchantContractTerms = () => buildCodecForUnion().discriminateOn("version").alternative(void 0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V1, codecForMerchantContractTermsV1()).build("TalerMerchantApi.ContractTerms");
var codecForMerchantContractChoice = () => buildCodecForObject().property("amount", codecForAmountString()).property("description", codecOptional(codecForString())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("inputs", codecForList(codecForMerchantContractInput())).property("outputs", codecForList(codecForMerchantContractOutput())).property("max_fee", codecForAmountString()).build("TalerMerchantApi.ContractChoice");
var codecForMerchantContractInput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractInputType.Token, codecForMerchantContractInputToken()).build("TalerMerchantApi.ContractInput");
var codecForMerchantContractInputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractInputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractInputToken");
var codecForMerchantContractOutput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractOutputType.Token, codecForMerchantContractOutputToken()).alternative(MerchantContractOutputType.TaxReceipt, codecForMerchantContractOutputTaxReceipt()).build("TalerMerchantApi.ContractOutput");
var codecForMerchantContractOutputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).property("key_index", codecForNumber()).build("TalerMerchantApi.ContractOutputToken");
var codecForMerchantContractOutputTaxReceipt = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.TaxReceipt)).property("donau_urls", codecForList(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.ContractOutputTaxReceipt");
var codecForMerchantContractTokenFamily = () => buildCodecForObject().property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("keys", codecForList(codecForTokenIssuePublicKey())).property("details", codecForMerchantContractTokenDetails()).property("critical", codecForBoolean()).build("TalerMerchantApi.ContractTokenFamily");
var codecForTokenIssuePublicKey = () => buildCodecForUnion().discriminateOn("cipher").alternative("RSA", codecForTokenIssueRsaPublicKey()).alternative("CS", codecForTokenIssueCsPublicKey()).build("TalerMerchantApi.TokenIssuePublicKey");
var codecForTokenIssueRsaPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("RSA")).property("rsa_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForTokenIssueCsPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("CS")).property("cs_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForMerchantContractTokenDetails = () => buildCodecForUnion().discriminateOn("class").alternative(MerchantContractTokenKind.Subscription, codecForMerchantContractSubscriptionTokenDetails()).alternative(MerchantContractTokenKind.Discount, codecForMerchantContractDiscountTokenDetails()).build("TalerMerchantApi.ContractTokenDetails");
var codecForMerchantContractSubscriptionTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Subscription)).property("trusted_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractSubscriptionTokenDetails");
var codecForMerchantContractDiscountTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Discount)).property("expected_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractDiscountTokenDetails");
var RoundingInterval;
(function(RoundingInterval2) {
  RoundingInterval2["NONE"] = "NONE";
  RoundingInterval2["SECOND"] = "SECOND";
  RoundingInterval2["MINUTE"] = "MINUTE";
  RoundingInterval2["HOUR"] = "HOUR";
  RoundingInterval2["DAY"] = "DAY";
  RoundingInterval2["WEEK"] = "WEEK";
  RoundingInterval2["MONTH"] = "MONTH";
  RoundingInterval2["QUARTER"] = "QUARTER";
  RoundingInterval2["YEAR"] = "YEAR";
})(RoundingInterval || (RoundingInterval = {}));
var KycStatusLongPollingReason;
(function(KycStatusLongPollingReason2) {
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AUTH_TRANSFER"] = 1] = "AUTH_TRANSFER";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AML_INVESTIGATION"] = 2] = "AML_INVESTIGATION";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["TO_BE_OK"] = 3] = "TO_BE_OK";
})(KycStatusLongPollingReason || (KycStatusLongPollingReason = {}));
var LoginTokenScope;
(function(LoginTokenScope2) {
  LoginTokenScope2["ReadOnly"] = "readonly";
  LoginTokenScope2["All"] = "all";
  LoginTokenScope2["Spa"] = "spa";
  LoginTokenScope2["OrderSimple"] = "order-simple";
  LoginTokenScope2["OrderPos"] = "order-pos";
  LoginTokenScope2["OrderManagement"] = "order-mgmt";
  LoginTokenScope2["OrderFull"] = "order-full";
  LoginTokenScope2["ReadOnly_Refreshable"] = "readonly:refreshable";
  LoginTokenScope2["All_Refreshable"] = "all:refreshable";
  LoginTokenScope2["Spa_Refreshable"] = "spa:refreshable";
  LoginTokenScope2["OrderSimple_Refreshable"] = "order-simple:refreshable";
  LoginTokenScope2["OrderPos_Refreshable"] = "order-pos:refreshable";
  LoginTokenScope2["OrderManagement_Refreshable"] = "order-mgmt:refreshable";
  LoginTokenScope2["OrderFull_Refreshable"] = "order-full:refreshable";
})(LoginTokenScope || (LoginTokenScope = {}));
var MerchantAuthMethod;
(function(MerchantAuthMethod2) {
  MerchantAuthMethod2["TOKEN"] = "token";
})(MerchantAuthMethod || (MerchantAuthMethod = {}));
var MerchantAccountKycStatus;
(function(MerchantAccountKycStatus2) {
  MerchantAccountKycStatus2["NO_EXCHANGE_KEY"] = "no-exchange-keys";
  MerchantAccountKycStatus2["KYC_WIRE_IMPOSSIBLE"] = "kyc-wire-impossible";
  MerchantAccountKycStatus2["KYC_WIRE_REQUIRED"] = "kyc-wire-required";
  MerchantAccountKycStatus2["KYC_REQUIRED"] = "kyc-required";
  MerchantAccountKycStatus2["AWAITING_AML_REVIEW"] = "awaiting-aml-review";
  MerchantAccountKycStatus2["READY"] = "ready";
  MerchantAccountKycStatus2["LOGIC_BUG"] = "logic-bug";
  MerchantAccountKycStatus2["EXCHANGE_INTERNAL_ERROR"] = "exchange-internal-error";
  MerchantAccountKycStatus2["EXCHANGE_GATEWAY_TIMEOUT"] = "exchange-gateway-timeout";
  MerchantAccountKycStatus2["EXCHANGE_UNREACHABLE"] = "exchange-unreachable";
  MerchantAccountKycStatus2["EXCHANGE_STATUS_INVALID"] = "exchange-status-invalid";
})(MerchantAccountKycStatus || (MerchantAccountKycStatus = {}));
var MerchantAccountKycStatusSimplified;
(function(MerchantAccountKycStatusSimplified2) {
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["OK"] = 0] = "OK";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ACTION_REQUIRED"] = 100] = "ACTION_REQUIRED";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["WARNING"] = 200] = "WARNING";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ERROR"] = 300] = "ERROR";
})(MerchantAccountKycStatusSimplified || (MerchantAccountKycStatusSimplified = {}));
var TokenFamilyKind;
(function(TokenFamilyKind2) {
  TokenFamilyKind2["Discount"] = "discount";
  TokenFamilyKind2["Subscription"] = "subscription";
})(TokenFamilyKind || (TokenFamilyKind = {}));
var StatisticBucketRange;
(function(StatisticBucketRange2) {
  StatisticBucketRange2["Hour"] = "hour";
  StatisticBucketRange2["Day"] = "day";
  StatisticBucketRange2["Week"] = "week";
  StatisticBucketRange2["Month"] = "month";
  StatisticBucketRange2["Quarter"] = "quarter";
  StatisticBucketRange2["Year"] = "year";
})(StatisticBucketRange || (StatisticBucketRange = {}));
var OrderInputType;
(function(OrderInputType2) {
  OrderInputType2["Token"] = "token";
})(OrderInputType || (OrderInputType = {}));
var OrderOutputType;
(function(OrderOutputType2) {
  OrderOutputType2["Token"] = "token";
  OrderOutputType2["TaxReceipt"] = "tax-receipt";
})(OrderOutputType || (OrderOutputType = {}));
var OrderVersion;
(function(OrderVersion2) {
  OrderVersion2[OrderVersion2["V0"] = 0] = "V0";
  OrderVersion2[OrderVersion2["V1"] = 1] = "V1";
})(OrderVersion || (OrderVersion = {}));
var codecForExchangeConfigInfo = () => buildCodecForObject().property("base_url", codecForString()).property("currency", codecForString()).property("master_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.ExchangeConfigInfo");
var codecForTalerMerchantConfigResponse = () => buildCodecForObject().property("name", codecForConstString("taler-merchant")).property("currency", codecForString()).property("default_persona", codecOptionalDefault(codecForEither(codecForConstString("expert"), codecForConstString("offline-vending-machine"), codecForConstString("point-of-sale"), codecForConstString("digital-publishing"), codecForConstString("e-commerce")), "expert")).property("version", codecForString()).property("currencies", codecForMap(codecForCurrencySpecificiation())).property("exchanges", codecForList(codecForExchangeConfigInfo())).property("implementation", codecOptional(codecForString())).property("have_self_provisioning", codecOptionalDefault(codecForBoolean(), false)).property("have_donau", codecOptionalDefault(codecForBoolean(), false)).property("mandatory_tan_channels", codecOptionalDefault(codecForList(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))), [])).property("default_pay_delay", codecOptional(codecForDuration)).property("default_refund_delay", codecOptional(codecForDuration)).property("default_wire_transfer_delay", codecOptional(codecForDuration)).property("payment_target_regex", codecOptionalDefault(codecForString(), "*")).property("payment_target_types", codecOptionalDefault(codecForString(), "*")).property("default_wire_transfer_rounding_interval", codecOptional(codecForRoundingInterval)).build("TalerMerchantApi.VersionResponse");
var codecForRoundingInterval = codecForEither(codecForConstString(RoundingInterval.NONE), codecForConstString(RoundingInterval.SECOND), codecForConstString(RoundingInterval.MINUTE), codecForConstString(RoundingInterval.HOUR), codecForConstString(RoundingInterval.DAY), codecForConstString(RoundingInterval.WEEK), codecForConstString(RoundingInterval.MONTH), codecForConstString(RoundingInterval.QUARTER), codecForConstString(RoundingInterval.YEAR));
var codecForClaimResponse = () => buildCodecForObject().property("contract_terms", codecForAny()).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.ClaimResponse");
var codecForPaymentResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.PaymentResponse");
var codecForPaymentDeniedLegallyResponse = () => buildCodecForObject().property("exchange_base_urls", codecOptionalDefault(codecForList(codecForString()), [])).build("TalerMerchantApi.PaymentDeniedLegallyResponse");
var codecForStatusPaid = () => buildCodecForObject().property("refund_amount", codecForAmountString()).property("refund_pending", codecForBoolean()).property("refund_taken", codecForAmountString()).property("refunded", codecForBoolean()).property("type", codecForConstString("paid")).build("TalerMerchantApi.StatusPaid");
var codecForStatusGoto = () => buildCodecForObject().property("public_reorder_url", codecForURLString()).property("type", codecForConstString("goto")).build("TalerMerchantApi.StatusGotoResponse");
var codecForStatusStatusUnpaid = () => buildCodecForObject().property("type", codecForConstString("unpaid")).property("already_paid_order_id", codecOptional(codecForString())).property("fulfillment_url", codecOptional(codecForString())).property("taler_pay_uri", codecForTalerUriString()).build("TalerMerchantApi.PaymentResponse");
var codecForPaidRefundStatusResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("refunded", codecForBoolean()).build("TalerMerchantApi.PaidRefundStatusResponse");
var codecForMerchantAbortPayRefundSuccessStatus = () => buildCodecForObject().property("exchange_pub", codecForString()).property("exchange_sig", codecForString()).property("exchange_status", codecForConstNumber(200)).property("type", codecForConstString("success")).build("TalerMerchantApi.MerchantAbortPayRefundSuccessStatus");
var codecForMerchantAbortPayRefundFailureStatus = () => buildCodecForObject().property("exchange_code", codecForNumber()).property("exchange_reply", codecForAny()).property("exchange_status", codecForNumber()).property("type", codecForConstString("failure")).build("TalerMerchantApi.MerchantAbortPayRefundFailureStatus");
var codecForMerchantAbortPayRefundUndepositedStatus = () => buildCodecForObject().property("type", codecForConstString("undeposited")).build("TalerMerchantApi.MerchantAbortPayRefundUndepositedStatus");
var codecForMerchantAbortPayRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantAbortPayRefundSuccessStatus()).alternative("failure", codecForMerchantAbortPayRefundFailureStatus()).alternative("undeposited", codecForMerchantAbortPayRefundUndepositedStatus()).build("TalerMerchantApi.MerchantAbortPayRefundStatus");
var codecForAbortResponse = () => buildCodecForObject().property("refunds", codecForList(codecForMerchantAbortPayRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForWalletRefundResponse = () => buildCodecForObject().property("merchant_pub", codecForEddsaPublicKey()).property("refund_amount", codecForAmountString()).property("refunds", codecForList(codecForMerchantCoinRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForMerchantCoinRefundSuccessStatus = () => buildCodecForObject().property("type", codecForConstString("success")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForConstNumber(200)).property("exchange_sig", codecForEddsaSignature()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_pub", codecForEddsaPublicKey()).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundSuccessStatus");
var codecForMerchantCoinRefundFailureStatus = () => buildCodecForObject().property("type", codecForConstString("failure")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForNumber()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_code", codecOptional(codecForNumber())).property("exchange_reply", codecOptional(codecForAny())).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundFailureStatus");
var codecForMerchantCoinRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantCoinRefundSuccessStatus()).alternative("failure", codecForMerchantCoinRefundFailureStatus()).build("TalerMerchantApi.MerchantCoinRefundStatus");
var codecForMerchantAuthMethod = codecForEither(codecForConstString(MerchantAuthMethod.TOKEN));
var codecForQueryInstancesResponse = () => buildCodecForObject().property("name", codecForString()).property("email", codecOptional(codecForString())).property("phone_number", codecOptional(codecForString())).property("website", codecOptional(codecForString())).property("email_validated", codecOptional(codecForBoolean())).property("phone_validated", codecOptional(codecForBoolean())).property("logo", codecOptional(codecForString())).property("merchant_pub", codecForEddsaPublicKey()).property("address", codecForLocation()).property("jurisdiction", codecForLocation()).property("use_stefan", codecForBoolean()).property("default_wire_transfer_delay", codecForDuration).property("default_pay_delay", codecForDuration).property("default_refund_delay", codecForDuration).property("default_wire_transfer_rounding_interval", codecOptional(codecForRoundingInterval)).property("auth", buildCodecForObject().property("method", codecForMerchantAuthMethod).build("TalerMerchantApi.QueryInstancesResponse.auth")).build("TalerMerchantApi.QueryInstancesResponse");
var codecForAccountKycRedirects = () => buildCodecForObject().property("kyc_data", codecForList(codecForMerchantAccountKycRedirect())).build("TalerMerchantApi.MerchantAccountKycRedirectsResponse");
var codecForMerchantAccountKycStatus = codecForEither(codecForConstString(MerchantAccountKycStatus.AWAITING_AML_REVIEW), codecForConstString(MerchantAccountKycStatus.EXCHANGE_GATEWAY_TIMEOUT), codecForConstString(MerchantAccountKycStatus.EXCHANGE_INTERNAL_ERROR), codecForConstString(MerchantAccountKycStatus.EXCHANGE_STATUS_INVALID), codecForConstString(MerchantAccountKycStatus.EXCHANGE_UNREACHABLE), codecForConstString(MerchantAccountKycStatus.KYC_REQUIRED), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_IMPOSSIBLE), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_REQUIRED), codecForConstString(MerchantAccountKycStatus.LOGIC_BUG), codecForConstString(MerchantAccountKycStatus.NO_EXCHANGE_KEY), codecForConstString(MerchantAccountKycStatus.READY));
var codecForMerchantAccountKycRedirect = () => buildCodecForObject().property("status", codecForMerchantAccountKycStatus).property("h_wire", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("exchange_http_status", codecForNumber()).property("no_keys", codecForBoolean()).property("auth_conflict", codecForBoolean()).property("exchange_code", codecOptional(codecForNumber())).property("access_token", codecOptional(codecForAccessToken())).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("payto_kycauths", codecOptional(codecForList(codecForString()))).build("TalerMerchantApi.MerchantAccountKycRedirect");
var codecForTokenScope = codecForEither(codecForConstString(LoginTokenScope.All), codecForConstString(LoginTokenScope.Spa), codecForConstString(LoginTokenScope.OrderFull), codecForConstString(LoginTokenScope.OrderManagement), codecForConstString(LoginTokenScope.OrderPos), codecForConstString(LoginTokenScope.OrderSimple), codecForConstString(LoginTokenScope.ReadOnly), codecForConstString(LoginTokenScope.All_Refreshable), codecForConstString(LoginTokenScope.Spa_Refreshable), codecForConstString(LoginTokenScope.OrderFull_Refreshable), codecForConstString(LoginTokenScope.OrderManagement_Refreshable), codecForConstString(LoginTokenScope.OrderPos_Refreshable), codecForConstString(LoginTokenScope.OrderSimple_Refreshable), codecForConstString(LoginTokenScope.ReadOnly_Refreshable));
var codecForLoginTokenSuccessResponse = () => buildCodecForObject().property("scope", codecForTokenScope).property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).property("refreshable", codecForBoolean()).build("TalerMerchantApi.LoginTokenSuccessResponse");
var codecForAccountAddResponse = () => buildCodecForObject().property("h_wire", codecForString()).property("salt", codecForString()).build("TalerMerchantApi.AccountAddResponse");
var codecForAccountsSummaryResponse = () => buildCodecForObject().property("accounts", codecForList(codecForBankAccountEntry())).build("TalerMerchantApi.AccountsSummaryResponse");
var codecForBankAccountEntry = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForBankAccountDetail = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("salt", codecForString()).property("credit_facade_url", codecOptional(codecForURLString())).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForCategoryListResponse = () => buildCodecForObject().property("categories", codecForList(codecForCategoryListEntry())).build("TalerMerchantApi.CategoryListResponse");
var codecForCategoryListEntry = () => buildCodecForObject().property("category_id", codecForNumber()).property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("product_count", codecForNumber()).build("TalerMerchantApi.CategoryListEntry");
var codecForCategoryProductList = () => buildCodecForObject().property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("products", codecForList(codecForProductSummary())).build("TalerMerchantApi.CategoryProductList");
var codecForProductSummary = () => buildCodecForObject().property("product_id", codecForString()).build("TalerMerchantApi.ProductSummary");
var codecForInventorySummaryResponse = () => buildCodecForObject().property("products", codecForList(codecForInventoryEntry())).build("TalerMerchantApi.InventorySummaryResponse");
var codecForInventoryEntry = () => buildCodecForObject().property("product_id", codecForString()).property("product_serial", codecForNumber()).build("TalerMerchantApi.InventoryEntry");
var codecForMerchantPosProductDetail = () => buildCodecForObject().property("product_serial", codecForNumber()).property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("categories", codecForList(codecForNumber())).property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("price", codecForAmountString()).property("image", codecForString()).property("taxes", codecOptional(codecForList(codecForTax()))).property("total_stock", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.MerchantPosProductDetail");
var codecForProductDetail = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("product_name", codecOptional(codecForString())).property("price", codecForAmountString()).property("image", codecForString()).property("categories", codecForList(codecForNumber())).property("taxes", codecOptional(codecForList(codecForTax()))).property("address", codecOptional(codecForLocation())).property("next_restock", codecOptional(codecForTimestamp)).property("total_stock", codecForNumber()).property("total_sold", codecForNumber()).property("total_lost", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ProductDetail");
var codecForTax = () => buildCodecForObject().property("name", codecForString()).property("tax", codecForAmountString()).build("TalerMerchantApi.Tax");
var codecForPostOrderResponse = () => buildCodecForObject().property("order_id", codecForString()).property("pay_deadline", codecOptional(codecForTimestamp)).property("token", codecOptional(codecForString())).build("TalerMerchantApi.PostOrderResponse");
var codecForOutOfStockResponse = () => buildCodecForObject().property("product_id", codecForString()).property("available_quantity", codecForNumber()).property("requested_quantity", codecForNumber()).property("restock_expected", codecForTimestamp).build("TalerMerchantApi.OutOfStockResponse");
var codecForOrderHistory = () => buildCodecForObject().property("orders", codecForList(codecForOrderHistoryEntry())).build("TalerMerchantApi.OrderHistory");
var codecForOrderHistoryEntry = () => buildCodecForObject().property("order_id", codecForString()).property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).property("refund_amount", codecOptional(codecForAmountString())).property("pending_refund_amount", codecOptional(codecForAmountString())).property("summary", codecForString()).property("refundable", codecForBoolean()).property("paid", codecForBoolean()).build("TalerMerchantApi.OrderHistoryEntry");
var codecForExchange = () => buildCodecForObject().property("master_pub", codecForEddsaPublicKey()).property("priority", codecForNumber()).property("url", codecForString()).property("max_contribution", codecOptional(codecForAmountString())).build("TalerMerchantApi.Exchange");
var codecForProduct = () => buildCodecForObject().property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("quantity", codecOptional(codecForNumber())).property("unit", codecOptional(codecForString())).property("price", codecOptional(codecForAmountString())).property("image", codecOptional(codecForString())).property("taxes", codecOptional(codecForList(codecForTax()))).property("delivery_date", codecOptional(codecForTimestamp)).build("TalerMerchantApi.Product");
var codecForCheckPaymentPaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("paid")).property("refunded", codecForBoolean()).property("refund_pending", codecForBoolean()).property("wired", codecForBoolean()).property("deposit_total", codecForAmountString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("refund_amount", codecForAmountString()).property("contract_terms", codecForMerchantContractTerms()).property("choice_index", codecOptional(codecForNumber())).property("last_payment", codecForTimestamp).property("wire_reports", codecForList(codecForTransactionWireReport())).property("wire_details", codecForList(codecForTransactionWireTransfer())).property("refund_details", codecForList(codecForRefundDetails())).property("order_status_url", codecForURLString()).build("TalerMerchantApi.CheckPaymentPaidResponse");
var codecForCheckPaymentUnpaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("unpaid")).property("taler_pay_uri", codecForTalerUriString()).property("creation_time", codecForTimestamp).property("pay_deadline", codecOptional(codecForTimestamp)).property("summary", codecForString()).property("total_amount", codecOptional(codecForAmountString())).property("already_paid_order_id", codecOptional(codecForString())).property("already_paid_fulfillment_url", codecOptional(codecForString())).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentUnpaidResponse");
var codecForCheckPaymentClaimedResponse = () => buildCodecForObject().property("order_status", codecForConstString("claimed")).property("contract_terms", codecForMerchantContractTerms()).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentClaimedResponse");
var codecForMerchantOrderPrivateStatusResponse = () => buildCodecForUnion().discriminateOn("order_status").alternative("paid", codecForCheckPaymentPaidResponse()).alternative("unpaid", codecForCheckPaymentUnpaidResponse()).alternative("claimed", codecForCheckPaymentClaimedResponse()).build("TalerMerchantApi.MerchantOrderStatusResponse");
var codecForRefundDetails = () => buildCodecForObject().property("reason", codecForString()).property("pending", codecForBoolean()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).build("TalerMerchantApi.RefundDetails");
var codecForTransactionWireTransfer = () => buildCodecForObject().property("exchange_url", codecForURLString()).property("wtid", codecForString()).property("execution_time", codecForTimestamp).property("amount", codecForAmountString()).property("confirmed", codecForBoolean()).build("TalerMerchantApi.TransactionWireTransfer");
var codecForTransactionWireReport = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("coin_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.TransactionWireReport");
var codecForMerchantRefundResponse = () => buildCodecForObject().property("taler_refund_uri", codecForTalerUriString()).property("h_contract", codecForString()).build("TalerMerchantApi.MerchantRefundResponse");
var codecForTansferList = () => buildCodecForObject().property("transfers", codecForList(codecForTransferDetails())).build("TalerMerchantApi.TransferList");
var codecForIncomingTansferList = () => buildCodecForObject().property("incoming", codecForList(codecForIncomingTransferDetails())).build("TalerMerchantApi.IncomingTransferList");
var codecForTransferDetails = () => buildCodecForObject().property("credit_amount", codecForAmountString()).property("wtid", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("transfer_serial_id", codecForNumber()).property("execution_time", codecOptional(codecForTimestamp)).property("verified", codecOptional(codecForBoolean())).property("confirmed", codecOptional(codecForBoolean())).build("TalerMerchantApi.TransferDetails");
var codecForIncomingTransferDetails = () => buildCodecForObject().property("expected_credit_amount", codecOptional(codecForAmountString())).property("expected_transfer_serial_id", codecOptional(codecForNumber())).property("execution_time", codecOptional(codecForTimestamp)).property("wtid", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("validated", codecForBoolean()).property("confirmed", codecForBoolean()).property("last_http_status", codecForNumber()).property("last_ec", codecForNumber()).property("last_error_detail", codecOptional(codecForAny())).build("TalerMerchantApi.IncomingTransferDetails");
var codecForOtpDeviceSummaryResponse = () => buildCodecForObject().property("otp_devices", codecForList(codecForOtpDeviceEntry())).build("TalerMerchantApi.OtpDeviceSummaryResponse");
var codecForOtpDeviceEntry = () => buildCodecForObject().property("otp_device_id", codecForString()).property("device_description", codecForString()).build("TalerMerchantApi.OtpDeviceEntry");
var codecForOtpDeviceDetails = () => buildCodecForObject().property("device_description", codecForString()).property("otp_algorithm", codecForNumber()).property("otp_ctr", codecOptional(codecForNumber())).property("otp_timestamp", codecForNumber()).property("otp_code", codecOptional(codecForString())).build("TalerMerchantApi.OtpDeviceDetails");
var codecForTemplateSummaryResponse = () => buildCodecForObject().property("templates", codecForList(codecForTemplateEntry())).build("TalerMerchantApi.TemplateSummaryResponse");
var codecForTemplateEntry = () => buildCodecForObject().property("template_id", codecForString()).property("template_description", codecForString()).build("TalerMerchantApi.TemplateEntry");
var codecForTemplateDetails = () => buildCodecForObject().property("template_description", codecForString()).property("otp_id", codecOptional(codecForString())).property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.TemplateDetails");
var codecForTemplateContractDetails = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).property("minimum_age", codecForNumber()).property("pay_duration", codecForDuration).build("TalerMerchantApi.TemplateContractDetails");
var codecForTemplateContractDetailsDefaults = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.TemplateContractDetailsDefaults");
var codecForWalletTemplateDetails = () => buildCodecForObject().property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.WalletTemplateDetails");
var codecForWebhookSummaryResponse = () => buildCodecForObject().property("webhooks", codecForList(codecForWebhookEntry())).build("TalerMerchantApi.WebhookSummaryResponse");
var codecForWebhookEntry = () => buildCodecForObject().property("webhook_id", codecForString()).property("event_type", codecForString()).build("TalerMerchantApi.WebhookEntry");
var codecForWebhookDetails = () => buildCodecForObject().property("event_type", codecForString()).property("url", codecForString()).property("http_method", codecForString()).property("header_template", codecOptional(codecForString())).property("body_template", codecOptional(codecForString())).build("TalerMerchantApi.WebhookDetails");
var codecForTokenFamilyKind = codecForEither(codecForConstString(TokenFamilyKind.Discount), codecForConstString(TokenFamilyKind.Subscription));
var codecForTokenFamilyDetails = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("duration", codecForDuration).property("kind", codecForTokenFamilyKind).property("issued", codecForNumber()).property("used", codecForNumber()).build("TalerMerchantApi.TokenFamilyDetails");
var codecForTokenFamiliesList = () => buildCodecForObject().property("token_families", codecForList(codecForTokenFamilySummary())).build("TalerMerchantApi.TokenFamiliesList");
var codecForTokenFamilySummary = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("kind", codecForTokenFamilyKind).build("TalerMerchantApi.TokenFamilySummary");
var codecForStatisticBucketRange = codecForEither(codecForConstString(StatisticBucketRange.Day), codecForConstString(StatisticBucketRange.Hour), codecForConstString(StatisticBucketRange.Day), codecForConstString(StatisticBucketRange.Week), codecForConstString(StatisticBucketRange.Month), codecForConstString(StatisticBucketRange.Quarter), codecForConstString(StatisticBucketRange.Year));
var TanChannel;
(function(TanChannel2) {
  TanChannel2["SMS"] = "sms";
  TanChannel2["EMAIL"] = "email";
})(TanChannel || (TanChannel = {}));
var codecForChallenge = () => buildCodecForObject().property("challenge_id", codecForString()).property("tan_channel", codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))).property("tan_info", codecForString()).build("MFA.Challenge");
var codecForChallengeResponse = () => buildCodecForObject().property("challenges", codecForList(codecForChallenge())).property("combi_and", codecForBoolean()).build("MFA.ChallengeResponse");
var codecForChallengeRequestResponse = () => buildCodecForObject().property("solve_expiration", codecOptional(codecForTimestamp)).property("earliest_retransmission", codecOptional(codecForTimestamp)).build("MFA.ChallengeRequestResponse");

// ../taler-util/lib/contract-terms.js
var logger5 = new Logger("contractTerms.ts");
var ContractTermsUtil;
(function(ContractTermsUtil2) {
  function forgetAllImpl(anyJson, path, pred) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = forgetAllImpl(dup[i4], [...path, `${i4}`], pred);
      }
    } else if (typeof dup === "object" && dup != null) {
      if (typeof dup.$forgettable === "object") {
        for (const x5 of Object.keys(dup.$forgettable)) {
          if (!pred([...path, x5])) {
            continue;
          }
          if (!dup.$forgotten) {
            dup.$forgotten = {};
          }
          if (!dup.$forgotten[x5]) {
            const membValCanon = stringToBytes(canonicalJson(scrub(dup[x5])) + "\0");
            const membSalt = stringToBytes(dup.$forgettable[x5] + "\0");
            const h3 = kdf(64, membValCanon, membSalt, new Uint8Array([]));
            dup.$forgotten[x5] = encodeCrock(h3);
          }
          delete dup[x5];
          delete dup.$forgettable[x5];
        }
        if (Object.keys(dup.$forgettable).length === 0) {
          delete dup.$forgettable;
        }
      }
      for (const x5 of Object.keys(dup)) {
        if (x5.startsWith("$")) {
          continue;
        }
        dup[x5] = forgetAllImpl(dup[x5], [...path, x5], pred);
      }
    }
    return dup;
  }
  ContractTermsUtil2.forgetAllImpl = forgetAllImpl;
  function scrub(anyJson) {
    return forgetAllImpl(anyJson, [], () => true);
  }
  ContractTermsUtil2.scrub = scrub;
  function forgetAll(anyJson, pred) {
    return forgetAllImpl(anyJson, [], pred);
  }
  ContractTermsUtil2.forgetAll = forgetAll;
  function saltForgettable(anyJson) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = saltForgettable(dup[i4]);
      }
    } else if (typeof dup === "object" && dup !== null) {
      if (typeof dup.$forgettable === "object") {
        for (const k5 of Object.keys(dup.$forgettable)) {
          if (dup.$forgettable[k5] === true) {
            dup.$forgettable[k5] = encodeCrock(getRandomBytes(32));
          }
        }
      }
      for (const x5 of Object.keys(dup)) {
        if (x5.startsWith("$")) {
          continue;
        }
        dup[x5] = saltForgettable(dup[x5]);
      }
    }
    return dup;
  }
  ContractTermsUtil2.saltForgettable = saltForgettable;
  const nameRegex = /^[0-9A-Za-z_]+$/;
  function validateForgettable(anyJson) {
    if (anyJson === void 0) {
      return true;
    }
    if (typeof anyJson === "string") {
      return true;
    }
    if (typeof anyJson === "number") {
      return Number.isInteger(anyJson) && anyJson >= Number.MIN_SAFE_INTEGER && anyJson <= Number.MAX_SAFE_INTEGER;
    }
    if (typeof anyJson === "boolean") {
      return true;
    }
    if (anyJson === null) {
      return true;
    }
    if (Array.isArray(anyJson)) {
      return anyJson.every((x5) => validateForgettable(x5));
    }
    if (typeof anyJson === "object") {
      for (const k5 of Object.keys(anyJson)) {
        if (k5.match(nameRegex)) {
          if (validateForgettable(anyJson[k5])) {
            continue;
          } else {
            return false;
          }
        }
        if (k5 === "$forgettable") {
          const fga = anyJson.$forgettable;
          if (!fga || typeof fga !== "object") {
            return false;
          }
          for (const fk of Object.keys(fga)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (!(fk in anyJson)) {
              return false;
            }
            const fv = anyJson.$forgettable[fk];
            if (typeof fv !== "string") {
              return false;
            }
          }
        } else if (k5 === "$forgotten") {
          const fgo = anyJson.$forgotten;
          if (!fgo || typeof fgo !== "object") {
            return false;
          }
          for (const fk of Object.keys(fgo)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (fk in anyJson) {
              return false;
            }
            const fv = anyJson.$forgotten[fk];
            if (typeof fv !== "string") {
              return false;
            }
            try {
              const decFv = decodeCrock(fv);
              if (decFv.length != 64) {
                return false;
              }
            } catch (e4) {
              return false;
            }
            if (anyJson.$forgettable?.[k5] !== void 0) {
              return false;
            }
          }
        } else {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  ContractTermsUtil2.validateForgettable = validateForgettable;
  function validateNothingForgotten(contractTerms) {
    throw Error("not implemented yet");
  }
  ContractTermsUtil2.validateNothingForgotten = validateNothingForgotten;
  function validateParsed(contractTerms) {
    if (contractTerms.version === MerchantContractVersion.V1) {
      const regex = new RegExp("^(\\*\\.)?([\\w\\d]+\\.)+[\\w\\d]+$");
      for (const slug in contractTerms.token_families) {
        const family = contractTerms.token_families[slug];
        var domains = [];
        switch (family.details.class) {
          case MerchantContractTokenKind.Subscription:
            domains.push(...family.details.trusted_domains);
            break;
          case MerchantContractTokenKind.Discount:
            domains.push(...family.details.expected_domains);
            break;
          default:
            assertUnreachable(family.details);
        }
        for (const domain in domains) {
          if (domain !== "*" && !regex.test(domain)) {
            return false;
          }
        }
      }
    }
    return true;
  }
  ContractTermsUtil2.validateParsed = validateParsed;
  function hashContractTerms(contractTerms) {
    const cleaned = scrub(contractTerms);
    const canon = canonicalJson(cleaned) + "\0";
    const bytes = stringToBytes(canon);
    return encodeCrock(hash2(bytes));
  }
  ContractTermsUtil2.hashContractTerms = hashContractTerms;
  function extractAmounts(contractTerms, choiceIndex) {
    let amountRaw;
    let maxFee;
    switch (contractTerms.version) {
      case void 0:
      case MerchantContractVersion.V0:
        amountRaw = contractTerms.amount;
        maxFee = contractTerms.max_fee;
        break;
      case MerchantContractVersion.V1:
        if (choiceIndex === void 0) {
          logger5.trace("choice index not specified for contract v1");
          return {
            available: false,
            amountRaw: void 0,
            maxFee: void 0
          };
        }
        if (contractTerms.choices[choiceIndex] === void 0)
          throw Error(`invalid choice index ${choiceIndex}`);
        amountRaw = contractTerms.choices[choiceIndex].amount;
        maxFee = contractTerms.choices[choiceIndex].max_fee;
        break;
      default:
        assertUnreachable(contractTerms);
    }
    return {
      available: true,
      amountRaw,
      maxFee
    };
  }
  ContractTermsUtil2.extractAmounts = extractAmounts;
  function getV0CompatChoiceIndex(terms) {
    let firstGood = void 0;
    for (let i4 = 0; i4 < terms.choices.length; i4++) {
      if (terms.choices[i4].inputs.length == 0) {
        firstGood = i4;
        break;
      }
    }
    if (firstGood != null) {
      return firstGood;
    }
    return void 0;
  }
  ContractTermsUtil2.getV0CompatChoiceIndex = getV0CompatChoiceIndex;
  function downgradeContractTerms(terms) {
    if (terms.version == MerchantContractVersion.V0) {
      return terms;
    }
    if (terms.version !== MerchantContractVersion.V1) {
      return void 0;
    }
    const firstGood = getV0CompatChoiceIndex(terms);
    if (firstGood == null) {
      return void 0;
    }
    return {
      amount: terms.choices[firstGood].amount,
      exchanges: terms.exchanges,
      h_wire: terms.h_wire,
      max_fee: terms.choices[firstGood].max_fee,
      merchant: terms.merchant,
      merchant_base_url: terms.merchant_base_url,
      merchant_pub: terms.merchant_pub,
      nonce: terms.nonce,
      order_id: terms.order_id,
      pay_deadline: terms.pay_deadline,
      refund_deadline: terms.refund_deadline,
      summary: terms.summary,
      timestamp: terms.timestamp,
      wire_method: terms.wire_method,
      wire_transfer_deadline: terms.wire_transfer_deadline,
      auto_refund: terms.auto_refund,
      delivery_date: terms.delivery_date,
      delivery_location: terms.delivery_location,
      extra: terms.extra,
      fulfillment_message: terms.fulfillment_message,
      fulfillment_message_i18n: terms.fulfillment_message_i18n,
      fulfillment_url: terms.fulfillment_url,
      minimum_age: terms.minimum_age,
      products: terms.products,
      public_reorder_url: terms.public_reorder_url,
      summary_i18n: terms.summary_i18n,
      version: MerchantContractVersion.V0
    };
  }
  ContractTermsUtil2.downgradeContractTerms = downgradeContractTerms;
})(ContractTermsUtil || (ContractTermsUtil = {}));

// ../taler-util/lib/fnutils.js
var fnutil;
(function(fnutil2) {
  function all(arr, f3) {
    for (const x5 of arr) {
      if (!f3(x5)) {
        return false;
      }
    }
    return true;
  }
  fnutil2.all = all;
  function any(arr, f3) {
    for (const x5 of arr) {
      if (f3(x5)) {
        return true;
      }
    }
    return false;
  }
  fnutil2.any = any;
})(fnutil || (fnutil = {}));

// ../taler-util/lib/http-status-codes.js
var HttpStatusCode;
(function(HttpStatusCode2) {
  HttpStatusCode2[HttpStatusCode2["Continue"] = 100] = "Continue";
  HttpStatusCode2[HttpStatusCode2["SwitchingProtocols"] = 101] = "SwitchingProtocols";
  HttpStatusCode2[HttpStatusCode2["Processing"] = 102] = "Processing";
  HttpStatusCode2[HttpStatusCode2["Ok"] = 200] = "Ok";
  HttpStatusCode2[HttpStatusCode2["Created"] = 201] = "Created";
  HttpStatusCode2[HttpStatusCode2["Accepted"] = 202] = "Accepted";
  HttpStatusCode2[HttpStatusCode2["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
  HttpStatusCode2[HttpStatusCode2["NoContent"] = 204] = "NoContent";
  HttpStatusCode2[HttpStatusCode2["ResetContent"] = 205] = "ResetContent";
  HttpStatusCode2[HttpStatusCode2["PartialContent"] = 206] = "PartialContent";
  HttpStatusCode2[HttpStatusCode2["MultiStatus"] = 207] = "MultiStatus";
  HttpStatusCode2[HttpStatusCode2["AlreadyReported"] = 208] = "AlreadyReported";
  HttpStatusCode2[HttpStatusCode2["ImUsed"] = 226] = "ImUsed";
  HttpStatusCode2[HttpStatusCode2["MultipleChoices"] = 300] = "MultipleChoices";
  HttpStatusCode2[HttpStatusCode2["MovedPermanently"] = 301] = "MovedPermanently";
  HttpStatusCode2[HttpStatusCode2["Found"] = 302] = "Found";
  HttpStatusCode2[HttpStatusCode2["SeeOther"] = 303] = "SeeOther";
  HttpStatusCode2[HttpStatusCode2["NotModified"] = 304] = "NotModified";
  HttpStatusCode2[HttpStatusCode2["UseProxy"] = 305] = "UseProxy";
  HttpStatusCode2[HttpStatusCode2["SwitchProxy"] = 306] = "SwitchProxy";
  HttpStatusCode2[HttpStatusCode2["TemporaryRedirect"] = 307] = "TemporaryRedirect";
  HttpStatusCode2[HttpStatusCode2["PermanentRedirect"] = 308] = "PermanentRedirect";
  HttpStatusCode2[HttpStatusCode2["BadRequest"] = 400] = "BadRequest";
  HttpStatusCode2[HttpStatusCode2["Unauthorized"] = 401] = "Unauthorized";
  HttpStatusCode2[HttpStatusCode2["PaymentRequired"] = 402] = "PaymentRequired";
  HttpStatusCode2[HttpStatusCode2["Forbidden"] = 403] = "Forbidden";
  HttpStatusCode2[HttpStatusCode2["NotFound"] = 404] = "NotFound";
  HttpStatusCode2[HttpStatusCode2["MethodNotAllowed"] = 405] = "MethodNotAllowed";
  HttpStatusCode2[HttpStatusCode2["NotAcceptable"] = 406] = "NotAcceptable";
  HttpStatusCode2[HttpStatusCode2["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
  HttpStatusCode2[HttpStatusCode2["RequestTimeout"] = 408] = "RequestTimeout";
  HttpStatusCode2[HttpStatusCode2["Conflict"] = 409] = "Conflict";
  HttpStatusCode2[HttpStatusCode2["Gone"] = 410] = "Gone";
  HttpStatusCode2[HttpStatusCode2["LengthRequired"] = 411] = "LengthRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionFailed"] = 412] = "PreconditionFailed";
  HttpStatusCode2[HttpStatusCode2["PayloadTooLarge"] = 413] = "PayloadTooLarge";
  HttpStatusCode2[HttpStatusCode2["UriTooLong"] = 414] = "UriTooLong";
  HttpStatusCode2[HttpStatusCode2["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
  HttpStatusCode2[HttpStatusCode2["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
  HttpStatusCode2[HttpStatusCode2["ExpectationFailed"] = 417] = "ExpectationFailed";
  HttpStatusCode2[HttpStatusCode2["IAmATeapot"] = 418] = "IAmATeapot";
  HttpStatusCode2[HttpStatusCode2["MisdirectedRequest"] = 421] = "MisdirectedRequest";
  HttpStatusCode2[HttpStatusCode2["UnprocessableEntity"] = 422] = "UnprocessableEntity";
  HttpStatusCode2[HttpStatusCode2["Locked"] = 423] = "Locked";
  HttpStatusCode2[HttpStatusCode2["FailedDependency"] = 424] = "FailedDependency";
  HttpStatusCode2[HttpStatusCode2["TooEarly"] = 425] = "TooEarly";
  HttpStatusCode2[HttpStatusCode2["UpgradeRequired"] = 426] = "UpgradeRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionRequired"] = 428] = "PreconditionRequired";
  HttpStatusCode2[HttpStatusCode2["TooManyRequests"] = 429] = "TooManyRequests";
  HttpStatusCode2[HttpStatusCode2["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
  HttpStatusCode2[HttpStatusCode2["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
  HttpStatusCode2[HttpStatusCode2["InternalServerError"] = 500] = "InternalServerError";
  HttpStatusCode2[HttpStatusCode2["NotImplemented"] = 501] = "NotImplemented";
  HttpStatusCode2[HttpStatusCode2["BadGateway"] = 502] = "BadGateway";
  HttpStatusCode2[HttpStatusCode2["ServiceUnavailable"] = 503] = "ServiceUnavailable";
  HttpStatusCode2[HttpStatusCode2["GatewayTimeout"] = 504] = "GatewayTimeout";
  HttpStatusCode2[HttpStatusCode2["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
  HttpStatusCode2[HttpStatusCode2["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
  HttpStatusCode2[HttpStatusCode2["InsufficientStorage"] = 507] = "InsufficientStorage";
  HttpStatusCode2[HttpStatusCode2["LoopDetected"] = 508] = "LoopDetected";
  HttpStatusCode2[HttpStatusCode2["NotExtended"] = 510] = "NotExtended";
  HttpStatusCode2[HttpStatusCode2["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

// ../taler-util/lib/types-taler-bank-conversion.js
var codecForCashoutConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashoutConversionResponse");
var codecForCashinConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashinConversionResponse");
var codecForConversionRate = () => buildCodecForObject().property("cashin_fee", codecForAmountString()).property("cashin_min_amount", codecForAmountString()).property("cashin_ratio", codecForDecimalNumber()).property("cashin_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashin_tiny_amount", codecForAmountString()).property("cashout_fee", codecForAmountString()).property("cashout_min_amount", codecForAmountString()).property("cashout_ratio", codecForDecimalNumber()).property("cashout_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashout_tiny_amount", codecForAmountString()).build("ConversionBankConfig.ConversionInfo");
var codecForConversionBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-conversion-info")).property("version", codecForString()).property("regional_currency", codecForString()).property("regional_currency_specification", codecForCurrencySpecificiation()).property("fiat_currency", codecForString()).property("fiat_currency_specification", codecForCurrencySpecificiation()).property("conversion_rate", codecForConversionRate()).build("ConversionBankConfig.IntegrationConfig");

// ../taler-util/lib/types-taler-wallet.js
var ScopeType;
(function(ScopeType2) {
  ScopeType2["Global"] = "global";
  ScopeType2["Exchange"] = "exchange";
  ScopeType2["Auditor"] = "auditor";
})(ScopeType || (ScopeType = {}));
var TransactionAmountMode;
(function(TransactionAmountMode2) {
  TransactionAmountMode2["Effective"] = "effective";
  TransactionAmountMode2["Raw"] = "raw";
})(TransactionAmountMode || (TransactionAmountMode = {}));
var codecForConvertAmountRequest = buildCodecForObject().property("amount", codecForAmountString()).property("depositPaytoUri", codecForPaytoString()).property("type", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).build("ConvertAmountRequest");
var BalanceFlag;
(function(BalanceFlag2) {
  BalanceFlag2["IncomingKyc"] = "incoming-kyc";
  BalanceFlag2["IncomingAml"] = "incoming-aml";
  BalanceFlag2["IncomingConfirmation"] = "incoming-confirmation";
  BalanceFlag2["OutgoingKyc"] = "outgoing-kyc";
})(BalanceFlag || (BalanceFlag = {}));
var CoinStatus;
(function(CoinStatus2) {
  CoinStatus2["Fresh"] = "fresh";
  CoinStatus2["DenomLoss"] = "denom-loss";
  CoinStatus2["FreshSuspended"] = "fresh-suspended";
  CoinStatus2["Dormant"] = "dormant";
})(CoinStatus || (CoinStatus = {}));
var ConfirmPayResultType;
(function(ConfirmPayResultType2) {
  ConfirmPayResultType2["Done"] = "done";
  ConfirmPayResultType2["Pending"] = "pending";
})(ConfirmPayResultType || (ConfirmPayResultType = {}));
var codecForTalerErrorDetail = () => buildCodecForObject().property("code", codecForNumber()).property("when", codecOptional(codecForAbsoluteTime)).property("hint", codecOptional(codecForString())).build("TalerErrorDetail");
var PreparePayResultType;
(function(PreparePayResultType2) {
  PreparePayResultType2["PaymentPossible"] = "payment-possible";
  PreparePayResultType2["InsufficientBalance"] = "insufficient-balance";
  PreparePayResultType2["AlreadyConfirmed"] = "already-confirmed";
  PreparePayResultType2["ChoiceSelection"] = "choice-selection";
})(PreparePayResultType || (PreparePayResultType = {}));
var InsufficientBalanceHint;
(function(InsufficientBalanceHint2) {
  InsufficientBalanceHint2["MerchantAcceptInsufficient"] = "merchant-accept-insufficient";
  InsufficientBalanceHint2["MerchantDepositInsufficient"] = "merchant-deposit-insufficient";
  InsufficientBalanceHint2["AgeRestricted"] = "age-restricted";
  InsufficientBalanceHint2["WalletBalanceMaterialInsufficient"] = "wallet-balance-material-insufficient";
  InsufficientBalanceHint2["WalletBalanceAvailableInsufficient"] = "wallet-balance-available-insufficient";
  InsufficientBalanceHint2["ExchangeMissingGlobalFees"] = "exchange-missing-global-fees";
  InsufficientBalanceHint2["FeesNotCovered"] = "fees-not-covered";
})(InsufficientBalanceHint || (InsufficientBalanceHint = {}));
var TokenAvailabilityHint;
(function(TokenAvailabilityHint2) {
  TokenAvailabilityHint2["WalletTokensAvailableInsufficient"] = "wallet-tokens-available-insufficient";
  TokenAvailabilityHint2["MerchantUnexpected"] = "merchant-unexpected";
  TokenAvailabilityHint2["MerchantUntrusted"] = "merchant-untrusted";
})(TokenAvailabilityHint || (TokenAvailabilityHint = {}));
var RefreshReason;
(function(RefreshReason2) {
  RefreshReason2["Manual"] = "manual";
  RefreshReason2["PayMerchant"] = "pay-merchant";
  RefreshReason2["PayDeposit"] = "pay-deposit";
  RefreshReason2["PayPeerPush"] = "pay-peer-push";
  RefreshReason2["PayPeerPull"] = "pay-peer-pull";
  RefreshReason2["Refund"] = "refund";
  RefreshReason2["AbortPay"] = "abort-pay";
  RefreshReason2["AbortDeposit"] = "abort-deposit";
  RefreshReason2["AbortPeerPushDebit"] = "abort-peer-push-debit";
  RefreshReason2["AbortPeerPullDebit"] = "abort-peer-pull-debit";
  RefreshReason2["Recoup"] = "recoup";
  RefreshReason2["BackupRestored"] = "backup-restored";
  RefreshReason2["Scheduled"] = "scheduled";
})(RefreshReason || (RefreshReason = {}));
var ExchangeTosStatus;
(function(ExchangeTosStatus2) {
  ExchangeTosStatus2["Pending"] = "pending";
  ExchangeTosStatus2["Proposed"] = "proposed";
  ExchangeTosStatus2["Accepted"] = "accepted";
  ExchangeTosStatus2["MissingTos"] = "missing-tos";
})(ExchangeTosStatus || (ExchangeTosStatus = {}));
var ExchangeEntryStatus;
(function(ExchangeEntryStatus2) {
  ExchangeEntryStatus2["Preset"] = "preset";
  ExchangeEntryStatus2["Ephemeral"] = "ephemeral";
  ExchangeEntryStatus2["Used"] = "used";
})(ExchangeEntryStatus || (ExchangeEntryStatus = {}));
var ExchangeUpdateStatus;
(function(ExchangeUpdateStatus2) {
  ExchangeUpdateStatus2["Initial"] = "initial";
  ExchangeUpdateStatus2["InitialUpdate"] = "initial-update";
  ExchangeUpdateStatus2["Suspended"] = "suspended";
  ExchangeUpdateStatus2["UnavailableUpdate"] = "unavailable-update";
  ExchangeUpdateStatus2["Ready"] = "ready";
  ExchangeUpdateStatus2["ReadyUpdate"] = "ready-update";
  ExchangeUpdateStatus2["OutdatedUpdate"] = "outdated-update";
})(ExchangeUpdateStatus || (ExchangeUpdateStatus = {}));
var ExchangeWalletKycStatus;
(function(ExchangeWalletKycStatus2) {
  ExchangeWalletKycStatus2["Done"] = "done";
  ExchangeWalletKycStatus2["LegiInit"] = "legi-init";
  ExchangeWalletKycStatus2["Legi"] = "legi";
})(ExchangeWalletKycStatus || (ExchangeWalletKycStatus = {}));
var ChoiceSelectionDetailType;
(function(ChoiceSelectionDetailType2) {
  ChoiceSelectionDetailType2["PaymentPossible"] = "payment-possible";
  ChoiceSelectionDetailType2["InsufficientBalance"] = "insufficient-balance";
})(ChoiceSelectionDetailType || (ChoiceSelectionDetailType = {}));
var RecoveryMergeStrategy;
(function(RecoveryMergeStrategy2) {
  RecoveryMergeStrategy2["Ours"] = "ours";
  RecoveryMergeStrategy2["Theirs"] = "theirs";
})(RecoveryMergeStrategy || (RecoveryMergeStrategy = {}));
var AttentionPriority;
(function(AttentionPriority2) {
  AttentionPriority2["High"] = "high";
  AttentionPriority2["Medium"] = "medium";
  AttentionPriority2["Low"] = "low";
})(AttentionPriority || (AttentionPriority = {}));
var AttentionType;
(function(AttentionType2) {
  AttentionType2["KycWithdrawal"] = "kyc-withdrawal";
  AttentionType2["BackupUnpaid"] = "backup-unpaid";
  AttentionType2["BackupExpiresSoon"] = "backup-expires-soon";
  AttentionType2["MerchantRefund"] = "merchant-refund";
  AttentionType2["ExchangeTosChanged"] = "exchange-tos-changed";
  AttentionType2["ExchangeKeyExpired"] = "exchange-key-expired";
  AttentionType2["ExchangeKeyExpiresSoon"] = "exchange-key-expires-soon";
  AttentionType2["ExchangeDenominationsExpired"] = "exchange-denominations-expired";
  AttentionType2["ExchangeDenominationsExpiresSoon"] = "exchange-denominations-expires-soon";
  AttentionType2["AuditorTosChanged"] = "auditor-tos-changed";
  AttentionType2["AuditorKeyExpires"] = "auditor-key-expires";
  AttentionType2["AuditorDenominationsExpires"] = "auditor-denominations-expires";
  AttentionType2["PullPaymentPaid"] = "pull-payment-paid";
  AttentionType2["PushPaymentReceived"] = "push-payment-withdrawn";
})(AttentionType || (AttentionType = {}));
var UserAttentionPriority = {
  "kyc-withdrawal": AttentionPriority.Medium,
  "backup-unpaid": AttentionPriority.High,
  "backup-expires-soon": AttentionPriority.Medium,
  "merchant-refund": AttentionPriority.Medium,
  "exchange-tos-changed": AttentionPriority.Medium,
  "exchange-key-expired": AttentionPriority.High,
  "exchange-key-expires-soon": AttentionPriority.Medium,
  "exchange-denominations-expired": AttentionPriority.High,
  "exchange-denominations-expires-soon": AttentionPriority.Medium,
  "auditor-tos-changed": AttentionPriority.Medium,
  "auditor-key-expires": AttentionPriority.Medium,
  "auditor-denominations-expires": AttentionPriority.Medium,
  "pull-payment-paid": AttentionPriority.High,
  "push-payment-withdrawn": AttentionPriority.High
};
var ProviderPaymentType;
(function(ProviderPaymentType2) {
  ProviderPaymentType2["Unpaid"] = "unpaid";
  ProviderPaymentType2["Pending"] = "pending";
  ProviderPaymentType2["InsufficientBalance"] = "insufficient-balance";
  ProviderPaymentType2["Paid"] = "paid";
  ProviderPaymentType2["TermsChanged"] = "terms-changed";
})(ProviderPaymentType || (ProviderPaymentType = {}));
var codecForEmptyObject = () => buildCodecForObject().build("EmptyObject");

// ../taler-util/lib/http-client/utils.js
function makeBasicAuthHeader2(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}
function makeBearerTokenAuthHeader(token) {
  return `Bearer ${token}`;
}
function createAuthorizationHeader(auth) {
  if (!auth)
    return void 0;
  switch (auth.type) {
    case "basic": {
      return makeBasicAuthHeader2(auth.username, auth.password);
    }
    case "bearer": {
      return makeBearerTokenAuthHeader(auth.token);
    }
  }
  return void 0;
}
function addPaginationParams(url, pagination) {
  if (!pagination)
    return;
  if (pagination.offset) {
    url.searchParams.set("offset", pagination.offset);
  }
  const order = !pagination || pagination.order === "asc" ? 1 : -1;
  const limit = !pagination || !pagination.limit || pagination.limit === 0 ? 5 : Math.abs(pagination.limit);
  url.searchParams.set("limit", String(order * limit));
}
function addLongPollingParam(url, param) {
  if (!param)
    return;
  if (param.timeoutMs) {
    url.searchParams.set("timeout_ms", String(param.timeoutMs));
  }
}
var nullEvictor = {
  notifySuccess: () => Promise.resolve()
};

// ../taler-util/lib/http-client/bank-conversion.js
var TalerBankConversionCacheEviction;
(function(TalerBankConversionCacheEviction3) {
  TalerBankConversionCacheEviction3[TalerBankConversionCacheEviction3["UPDATE_RATE"] = 0] = "UPDATE_RATE";
})(TalerBankConversionCacheEviction || (TalerBankConversionCacheEviction = {}));
var TalerBankConversionHttpClient = class _TalerBankConversionHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-conversion-info", _TalerBankConversionHttpClient.PROTOCOL_VERSION, resp, codecForConversionBankConfig());
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--rate
   *
   */
  async getRate(auth) {
    const url = new URL(`rate`, this.baseUrl);
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRate());
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashin-rate
   *
   */
  async getCashinRate(auth, conversion) {
    const url = new URL(`cashin-rate`, this.baseUrl);
    if (conversion.debit) {
      url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
    }
    if (conversion.credit) {
      url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
    }
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashinConversionResponse());
      case HttpStatusCode.BadRequest: {
        const body = await resp.json();
        const details = codecForTalerErrorDetail().decode(body);
        switch (details.code) {
          case TalerErrorCode.GENERIC_PARAMETER_MISSING:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashout-rate
   *
   */
  async getCashoutRate(auth, conversion) {
    const url = new URL(`cashout-rate`, this.baseUrl);
    if (conversion.debit) {
      url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
    }
    if (conversion.credit) {
      url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
    }
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashoutConversionResponse());
      case HttpStatusCode.BadRequest: {
        const body = await resp.json();
        const details = codecForTalerErrorDetail().decode(body);
        switch (details.code) {
          case TalerErrorCode.GENERIC_PARAMETER_MISSING:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
            return opKnownHttpFailure(resp.status, resp);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#post--conversion-rate
   *
   */
  async updateConversionRate(auth, body) {
    const url = new URL(`conversion-rate`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerBankConversionCacheEviction.UPDATE_RATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerBankConversionHttpClient.PROTOCOL_VERSION = "0:0:0";

// ../taler-util/lib/result.js
var Result = {
  of(value) {
    return { tag: "ok", value };
  },
  error(error2) {
    return { tag: "error", error: error2 };
  }
};

// ../taler-util/lib/taleruri.js
function codecForTalerUriString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (parseTalerUri(x5) === void 0) {
        throw new DecodingError(`invalid taler URI at ${renderContext(c4)} but got "${x5}"`);
      }
      return x5;
    }
  };
}
var TALER_PREFIX = "taler://";
var TALER_HTTP_PREFIX = "taler+http://";
var TalerUriParseError;
(function(TalerUriParseError2) {
  TalerUriParseError2[TalerUriParseError2["WRONG_PREFIX"] = 0] = "WRONG_PREFIX";
  TalerUriParseError2[TalerUriParseError2["INCOMPLETE"] = 1] = "INCOMPLETE";
  TalerUriParseError2[TalerUriParseError2["UNSUPPORTED"] = 2] = "UNSUPPORTED";
  TalerUriParseError2[TalerUriParseError2["COMPONENTS_LENGTH"] = 3] = "COMPONENTS_LENGTH";
  TalerUriParseError2[TalerUriParseError2["INVALID_TARGET_PATH"] = 4] = "INVALID_TARGET_PATH";
  TalerUriParseError2[TalerUriParseError2["INVALID_PARAMETER"] = 5] = "INVALID_PARAMETER";
})(TalerUriParseError || (TalerUriParseError = {}));
var TalerUris;
(function(TalerUris2) {
  const supported_targets = {
    "add-contact": true,
    "add-exchange": true,
    "dev-experiment": true,
    pay: true,
    "pay-pull": true,
    "pay-template": true,
    "pay-push": true,
    "withdraw-exchange": true,
    refund: true,
    restore: true,
    withdraw: true,
    "withdrawal-transfer-result": true
  };
  function createTalerPay(merchantBaseUrl, orderId, sessionId, opts = {}) {
    return {
      type: TalerUriAction.Pay,
      merchantBaseUrl,
      orderId,
      sessionId,
      ...opts
    };
  }
  TalerUris2.createTalerPay = createTalerPay;
  function createTalerWithdraw(bankIntegrationApiBaseUrl, withdrawalOperationId, opts = {}) {
    return {
      type: TalerUriAction.Withdraw,
      bankIntegrationApiBaseUrl,
      withdrawalOperationId,
      ...opts
    };
  }
  TalerUris2.createTalerWithdraw = createTalerWithdraw;
  function createTalerRefund(merchantBaseUrl, orderId) {
    return {
      type: TalerUriAction.Refund,
      merchantBaseUrl,
      orderId
    };
  }
  TalerUris2.createTalerRefund = createTalerRefund;
  function createTalerPayPull(exchangeBaseUrl, contractPriv) {
    return {
      type: TalerUriAction.PayPull,
      exchangeBaseUrl,
      contractPriv
    };
  }
  TalerUris2.createTalerPayPull = createTalerPayPull;
  function createTalerPayPush(exchangeBaseUrl, contractPriv) {
    return {
      type: TalerUriAction.PayPush,
      exchangeBaseUrl,
      contractPriv
    };
  }
  TalerUris2.createTalerPayPush = createTalerPayPush;
  function createTalerPayTemplate(merchantBaseUrl, templateId) {
    return {
      type: TalerUriAction.PayTemplate,
      merchantBaseUrl,
      templateId
    };
  }
  TalerUris2.createTalerPayTemplate = createTalerPayTemplate;
  function createTalerRestore(walletRootPriv, providers) {
    return {
      type: TalerUriAction.Restore,
      providers,
      walletRootPriv
    };
  }
  TalerUris2.createTalerRestore = createTalerRestore;
  function createTalerDevExperiment(devExperimentId, query) {
    return {
      type: TalerUriAction.DevExperiment,
      devExperimentId,
      query
    };
  }
  TalerUris2.createTalerDevExperiment = createTalerDevExperiment;
  function createTalerWithdrawExchange(exchangeBaseUrl, opts = {}) {
    return {
      type: TalerUriAction.WithdrawExchange,
      exchangeBaseUrl,
      ...opts
    };
  }
  TalerUris2.createTalerWithdrawExchange = createTalerWithdrawExchange;
  function createTalerAddExchange(exchangeBaseUrl) {
    return {
      type: TalerUriAction.AddExchange,
      exchangeBaseUrl
    };
  }
  TalerUris2.createTalerAddExchange = createTalerAddExchange;
  function createTalerAddContact(aliasType, alias, mailboxUri, mailboxIdentity, sourceBaseUrl) {
    return {
      type: TalerUriAction.AddContact,
      alias,
      aliasType,
      mailboxBaseUri: mailboxUri,
      mailboxIdentity,
      sourceBaseUrl
    };
  }
  TalerUris2.createTalerAddContact = createTalerAddContact;
  function createTalerWithdrawalTransferResult(ref, opts = {}) {
    return {
      type: TalerUriAction.WithdrawalTransferResult,
      ref,
      ...opts
    };
  }
  TalerUris2.createTalerWithdrawalTransferResult = createTalerWithdrawalTransferResult;
  function asHost(s4) {
    const b4 = new URL2(s4);
    return `${b4.host}${b4.pathname}`;
  }
  function getTalerParamList(p4) {
    const result = [];
    switch (p4.type) {
      case TalerUriAction.Withdraw: {
        if (p4.externalConfirmation)
          result.push(["external-confirmation", "1"]);
        return result;
      }
      case TalerUriAction.Pay: {
        if (p4.claimToken)
          result.push(["c", p4.claimToken]);
        if (p4.noncePriv)
          result.push(["n", p4.noncePriv]);
        return result;
      }
      case TalerUriAction.WithdrawExchange: {
        if (p4.amount)
          result.push(["a", p4.amount]);
        return result;
      }
      case TalerUriAction.WithdrawalTransferResult: {
        result.push(["ref", p4.ref]);
        if (p4.status)
          result.push(["status", p4.status]);
        return result;
      }
      case TalerUriAction.AddContact: {
        if (p4.sourceBaseUrl)
          result.push(["sourceBaseUrl", p4.sourceBaseUrl]);
        return result;
      }
      case TalerUriAction.Refund:
      case TalerUriAction.PayPush:
      case TalerUriAction.PayPull:
      case TalerUriAction.PayTemplate:
      case TalerUriAction.Restore:
      case TalerUriAction.DevExperiment:
      case TalerUriAction.AddExchange: {
        return result;
      }
      default: {
        assertUnreachable(p4);
      }
    }
  }
  function getTalerPrefix(p4) {
    switch (p4.type) {
      case TalerUriAction.Withdraw:
        return p4.bankIntegrationApiBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.Pay:
      case TalerUriAction.Refund:
      case TalerUriAction.PayTemplate:
        return p4.merchantBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.PayPush:
      case TalerUriAction.PayPull:
      case TalerUriAction.AddExchange:
      case TalerUriAction.WithdrawExchange:
        return p4.exchangeBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.Restore:
      case TalerUriAction.DevExperiment:
      case TalerUriAction.WithdrawalTransferResult:
      case TalerUriAction.AddContact:
        return TALER_PREFIX;
      default:
        assertUnreachable(p4);
    }
  }
  function getTalerPath(p4) {
    switch (p4.type) {
      case TalerUriAction.Withdraw:
        return `/${asHost(p4.bankIntegrationApiBaseUrl)}${p4.withdrawalOperationId}`;
      case TalerUriAction.Pay:
        return `/${asHost(p4.merchantBaseUrl)}${p4.orderId}/${p4.sessionId}`;
      case TalerUriAction.Refund:
        return `/${asHost(p4.merchantBaseUrl)}${p4.orderId}/`;
      case TalerUriAction.PayTemplate:
        return `/${asHost(p4.merchantBaseUrl)}${p4.templateId}`;
      case TalerUriAction.PayPush:
        return `/${asHost(p4.exchangeBaseUrl)}${p4.contractPriv}`;
      case TalerUriAction.PayPull:
        return `/${asHost(p4.exchangeBaseUrl)}${p4.contractPriv}`;
      case TalerUriAction.AddExchange:
        return `/${asHost(p4.exchangeBaseUrl)}`;
      case TalerUriAction.WithdrawExchange:
        return `/${asHost(p4.exchangeBaseUrl)}`;
      case TalerUriAction.Restore:
        return `/${p4.walletRootPriv}/${p4.providers.map((d4) => encodeURIComponent(d4)).join(",")}`;
      case TalerUriAction.DevExperiment:
        return `/${p4.devExperimentId}`;
      case TalerUriAction.WithdrawalTransferResult:
        return `/`;
      case TalerUriAction.AddContact:
        return `/${p4.aliasType}/${p4.alias}/${asHost(p4.mailboxBaseUri)}/${p4.mailboxIdentity}`;
      default:
        assertUnreachable(p4);
    }
  }
  function toString(p4) {
    const prefix = getTalerPrefix(p4);
    const path = getTalerPath(p4);
    const paramList = getTalerParamList(p4);
    const url = new URL2(`${prefix}${p4.type}${path}`);
    url.search = createSearchParams2(paramList);
    return url.href;
  }
  TalerUris2.toString = toString;
  function fromString(s4, opts = {}) {
    let isHttp = false;
    if (!s4.startsWith(TALER_PREFIX) && !(isHttp = s4.startsWith(TALER_HTTP_PREFIX))) {
      return opKnownFailure(TalerUriParseError.WRONG_PREFIX);
    }
    const scheme = isHttp ? "http" : "https";
    const [path, search] = s4.slice((isHttp ? TALER_HTTP_PREFIX : TALER_PREFIX).length).split("?", 2);
    const firstSlashPos = path.indexOf("/");
    const uriType = firstSlashPos === -1 ? path : path.slice(0, firstSlashPos);
    if (!supported_targets[uriType]) {
      const d4 = opKnownFailureWithBody(TalerUriParseError.UNSUPPORTED, {
        uriType
      });
      return d4;
    }
    const targetPath = path.slice(firstSlashPos + 1);
    if (firstSlashPos === -1 || !targetPath) {
      return opKnownFailureWithBody(TalerUriParseError.INCOMPLETE, {
        uriType
      });
    }
    const params = {};
    if (search) {
      const searchParams = new URLSearchParams2(search);
      searchParams.forEach((v3, k5) => {
        params[k5] = v3;
      });
    }
    const cs = targetPath.split("/");
    switch (uriType) {
      case TalerUriAction.Pay: {
        if (cs.length < 3) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -2).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const orderId = cs[cs.length - 2];
        const sessionId = cs[cs.length - 1];
        return opFixedSuccess(createTalerPay(merchant ?? cs[0], orderId, sessionId, {
          claimToken: params["c"],
          noncePriv: params["n"]
        }));
      }
      case TalerUriAction.Withdraw: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const bank = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !bank) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: bank
          });
        }
        const operationId = cs[cs.length - 1];
        const externalConfirmation = !params["external-confirmation"] ? void 0 : params["external-confirmation"] === "1";
        return opFixedSuccess(createTalerWithdraw(bank ?? cs[0], operationId, {
          externalConfirmation
        }));
      }
      case TalerUriAction.Refund: {
        if (cs.length < 3) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        if (cs[cs.length - 1]) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 1,
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -2).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const orderId = cs[cs.length - 2];
        return opFixedSuccess(createTalerRefund(merchant ?? cs[0], orderId));
      }
      case TalerUriAction.PayPull: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayPull(exchange ?? cs[0], contractPriv));
      }
      case TalerUriAction.PayPush: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayPush(exchange ?? cs[0], contractPriv));
      }
      case TalerUriAction.PayTemplate: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayTemplate(merchant ?? cs[0], contractPriv));
      }
      case TalerUriAction.Restore: {
        if (cs.length !== 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const walletPriv = cs[0];
        const providers = [];
        cs[1].split(",").map((name) => {
          const url = decodeURIComponent(name);
          let isHttp2 = false;
          const withoutScheme = url.startsWith("https://") ? url.substring(8) : (isHttp2 = url.startsWith("http://")) ? url.substring(7) : url;
          const thisScheme = url === withoutScheme ? scheme : isHttp2 ? "http" : "https";
          const [hostname, path2] = withoutScheme.split("/", 1);
          const host = Paytos.parseHostPortPath2(hostname, path2, thisScheme);
          providers.push(host);
        });
        return opFixedSuccess(createTalerRestore(walletPriv ?? cs[0], providers));
      }
      case TalerUriAction.DevExperiment: {
        if (cs.length !== 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const experimentId = cs[0];
        const query = new URLSearchParams2(search);
        return opFixedSuccess(createTalerDevExperiment(experimentId, query));
      }
      case TalerUriAction.WithdrawExchange: {
        if (cs.length < 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        if (cs.length > 1 && cs[cs.length - 1]) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 1,
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const amountRes = !params["a"] ? void 0 : Amounts.parseWithError(params["a"]);
        if (!opts.ignoreComponentError && amountRes && amountRes.type === "fail") {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_PARAMETER, {
            name: "a",
            uriType,
            error: amountRes
          });
        }
        const amount = amountRes && amountRes.type === "ok" ? Amounts.stringify(amountRes.body) : void 0;
        return opFixedSuccess(createTalerWithdrawExchange(exchange ?? cs[0], {
          amount
        }));
      }
      case TalerUriAction.AddExchange: {
        if (cs.length === 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        return opFixedSuccess(createTalerAddExchange(exchange ?? cs[0]));
      }
      case TalerUriAction.WithdrawalTransferResult: {
        if (cs.length === 0) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const ref = params["ref"];
        const status = params["status"] !== "aborted" && params["status"] !== "success" ? void 0 : params["status"];
        return opFixedSuccess(createTalerWithdrawalTransferResult(ref, {
          status
        }));
      }
      case TalerUriAction.AddContact: {
        if (cs.length < 4) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const mailboxBaseUri = Paytos.parseHostPortPath2(cs[2], cs.slice(2, cs.length - 2).join("/"), scheme);
        if (!mailboxBaseUri) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: mailboxBaseUri
          });
        }
        const mailboxIdentity = cs[cs.length - 1];
        return opFixedSuccess(createTalerAddContact(cs[0], cs[1], mailboxBaseUri, mailboxIdentity, params["sourceBaseUrl"]));
      }
      default: {
        assertUnreachable(uriType);
      }
    }
  }
  TalerUris2.fromString = fromString;
})(TalerUris || (TalerUris = {}));
function parseWithdrawUriWithError(s4) {
  const pi = parseProtoInfoWithError(s4, "withdraw");
  if (pi.tag === "error") {
    return pi;
  }
  const c4 = pi.value.rest.split("?", 2);
  const path = c4[0];
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const parts = path.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const withdrawId = parts[parts.length - 1];
  const result = {
    type: TalerUriAction.Withdraw,
    bankIntegrationApiBaseUrl: Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.value.innerProto),
    withdrawalOperationId: withdrawId,
    externalConfirmation: q5.get("external-confirmation") == "1"
  };
  return Result.of(result);
}
function parseWithdrawUri(s4) {
  const r3 = parseWithdrawUriWithError(s4);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
function parseAddExchangeUriWithError(s4) {
  const pi = parseProtoInfoWithError(s4, "add-exchange");
  if (pi.tag === "error") {
    return pi;
  }
  const parts = pi.value.rest.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const result = {
    type: TalerUriAction.AddExchange,
    exchangeBaseUrl: Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.value.innerProto)
  };
  return Result.of(result);
}
function parseAddContactUriWithError(s4) {
  const pi = parseProtoInfoWithError(s4, "add-contact");
  if (pi.tag === "error") {
    return pi;
  }
  const parts = pi.value.rest.split("/");
  if (parts.length < 4) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const mailboxBaseUri = parts[2];
  const pathSegments = parts.slice(3, parts.length - 2);
  const lastPart = parts[parts.length - 1];
  const q5 = new URLSearchParams2(lastPart ?? "");
  const mailboxIdentity = lastPart.split("?")[0];
  const sourceBaseUrl = q5.get("sourceBaseUrl") ?? "";
  const mailboxHostPort = Paytos.parseHostPortPath2(mailboxBaseUri, pathSegments.join("/"), pi.value.innerProto);
  const result = {
    type: TalerUriAction.AddContact,
    aliasType: parts[0],
    alias: parts[1],
    mailboxBaseUri: mailboxHostPort,
    mailboxIdentity,
    sourceBaseUrl
  };
  return Result.of(result);
}
function parseAddExchangeUri(s4) {
  const r3 = parseAddExchangeUriWithError(s4);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
function parseAddContactUri(s4) {
  const r3 = parseAddContactUriWithError(s4);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
var TalerUriAction;
(function(TalerUriAction2) {
  TalerUriAction2["Withdraw"] = "withdraw";
  TalerUriAction2["Pay"] = "pay";
  TalerUriAction2["Refund"] = "refund";
  TalerUriAction2["PayPush"] = "pay-push";
  TalerUriAction2["PayPull"] = "pay-pull";
  TalerUriAction2["PayTemplate"] = "pay-template";
  TalerUriAction2["Restore"] = "restore";
  TalerUriAction2["DevExperiment"] = "dev-experiment";
  TalerUriAction2["AddExchange"] = "add-exchange";
  TalerUriAction2["WithdrawExchange"] = "withdraw-exchange";
  TalerUriAction2["WithdrawalTransferResult"] = "withdrawal-transfer-result";
  TalerUriAction2["AddContact"] = "add-contact";
})(TalerUriAction || (TalerUriAction = {}));
function parseProtoInfo(s4, action) {
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s4.toLowerCase().startsWith(pfxPlain)) {
    return {
      innerProto: "https",
      rest: s4.substring(pfxPlain.length)
    };
  } else if (s4.toLowerCase().startsWith(pfxHttp)) {
    return {
      innerProto: "http",
      rest: s4.substring(pfxHttp.length)
    };
  } else {
    return void 0;
  }
}
function parseProtoInfoWithError(s4, action) {
  if (!s4.toLowerCase().startsWith("taler://") && !s4.toLowerCase().startsWith("taler+http://")) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s4.toLowerCase().startsWith(pfxPlain)) {
    return Result.of({
      innerProto: "https",
      rest: s4.substring(pfxPlain.length)
    });
  } else if (s4.toLowerCase().startsWith(pfxHttp)) {
    return Result.of({
      innerProto: "http",
      rest: s4.substring(pfxHttp.length)
    });
  } else {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
}
var parsers = {
  [TalerUriAction.Pay]: parsePayUri,
  [TalerUriAction.PayPull]: parsePayPullUri,
  [TalerUriAction.PayPush]: parsePayPushUri,
  [TalerUriAction.PayTemplate]: parsePayTemplateUri,
  [TalerUriAction.Restore]: parseRestoreUri,
  [TalerUriAction.Refund]: parseRefundUri,
  [TalerUriAction.Withdraw]: parseWithdrawUri,
  [TalerUriAction.DevExperiment]: parseDevExperimentUri,
  [TalerUriAction.WithdrawExchange]: parseWithdrawExchangeUri,
  [TalerUriAction.AddExchange]: parseAddExchangeUri,
  [TalerUriAction.AddContact]: parseAddContactUri,
  [TalerUriAction.WithdrawalTransferResult]: () => {
    throw new Error("not supported");
  }
};
function parseTalerUri(string) {
  const https = string.startsWith("taler://");
  const http = string.startsWith("taler+http://");
  if (!https && !http)
    return void 0;
  const actionStart = https ? 8 : 13;
  const actionEnd = string.indexOf("/", actionStart + 1);
  const action = string.substring(actionStart, actionEnd);
  const found = Object.values(TalerUriAction).find((x5) => x5 === action);
  if (!found)
    return void 0;
  return parsers[found](string);
}
function stringifyTalerUri(uri) {
  switch (uri.type) {
    case TalerUriAction.DevExperiment: {
      return stringifyDevExperimentUri(uri);
    }
    case TalerUriAction.Pay: {
      return stringifyPayUri(uri);
    }
    case TalerUriAction.PayPull: {
      return stringifyPayPullUri(uri);
    }
    case TalerUriAction.PayPush: {
      return stringifyPayPushUri(uri);
    }
    case TalerUriAction.PayTemplate: {
      return stringifyPayTemplateUri(uri);
    }
    case TalerUriAction.Restore: {
      return stringifyRestoreUri(uri);
    }
    case TalerUriAction.Refund: {
      return stringifyRefundUri(uri);
    }
    case TalerUriAction.Withdraw: {
      return stringifyWithdrawUri(uri);
    }
    case TalerUriAction.WithdrawExchange: {
      return stringifyWithdrawExchange(uri);
    }
    case TalerUriAction.AddExchange: {
      return stringifyAddExchange(uri);
    }
    case TalerUriAction.AddContact: {
      return stringifyAddContact(uri);
    }
    case TalerUriAction.WithdrawalTransferResult: {
      throw Error("not supported");
    }
  }
}
function parsePayUri(s4) {
  const pi = parseProtoInfo(s4, "pay");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const claimToken = q5.get("c") ?? void 0;
  const noncePriv = q5.get("n") ?? void 0;
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.Pay,
    merchantBaseUrl,
    orderId,
    sessionId,
    claimToken,
    noncePriv
  };
}
function parsePayTemplateUri(uriString) {
  const pi = parseProtoInfo(uriString, TalerUriAction.PayTemplate);
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const params = {};
  q5.forEach((v3, k5) => {
    params[k5] = v3;
  });
  const host = parts[0].toLowerCase();
  const templateId = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayTemplate,
    merchantBaseUrl,
    templateId
  };
}
function parsePayPushUri(s4) {
  const pi = parseProtoInfo(s4, TalerUriAction.PayPush);
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayPush,
    exchangeBaseUrl,
    contractPriv
  };
}
function parsePayPullUri(s4) {
  const pi = parseProtoInfo(s4, TalerUriAction.PayPull);
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayPull,
    exchangeBaseUrl,
    contractPriv
  };
}
function parseWithdrawExchangeUri(s4) {
  const pi = parseProtoInfo(s4, "withdraw-exchange");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 1) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const lastPathComponent = parts.length > 1 ? parts[parts.length - 1] : void 0;
  if (lastPathComponent) {
    return void 0;
  }
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const amount = q5.get("a") ?? void 0;
  return {
    type: TalerUriAction.WithdrawExchange,
    exchangeBaseUrl,
    amount
  };
}
function parseRefundUri(s4) {
  const pi = parseProtoInfo(s4, "refund");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.Refund,
    merchantBaseUrl,
    orderId
  };
}
function parseDevExperimentUri(s4) {
  const pi = parseProtoInfo(s4, "dev-experiment");
  const c4 = pi?.rest.split("?");
  if (!c4) {
    return void 0;
  }
  const parts = c4[0].split("/");
  return {
    type: TalerUriAction.DevExperiment,
    devExperimentId: parts[0],
    query: new URLSearchParams2(c4[1] ?? "")
  };
}
function parseRestoreUri(uri) {
  const pi = parseProtoInfo(uri, "restore");
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const walletRootPriv = parts[0];
  if (!walletRootPriv)
    return void 0;
  const providers = new Array();
  parts[1].split(",").map((name) => {
    const url = decodeURIComponent(name);
    let isHttp = false;
    const withoutScheme = url.startsWith("https://") ? url.substring(8) : (isHttp = url.startsWith("http://")) ? url.substring(7) : url;
    const scheme = url === withoutScheme ? pi.innerProto : isHttp ? "http" : "https";
    const [hostname, path] = withoutScheme.split("/", 1);
    const host = Paytos.parseHostPortPath2(hostname, path ?? "/", scheme);
    providers.push(host);
  });
  return {
    type: TalerUriAction.Restore,
    walletRootPriv,
    providers
  };
}
function stringifyPayUri({ merchantBaseUrl, orderId, sessionId, claimToken, noncePriv }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl, {
    c: claimToken,
    n: noncePriv
  });
  return `${proto}://pay/${path}${orderId}/${sessionId}${query}`;
}
function stringifyPayPullUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-pull/${path}${contractPriv}`;
}
function stringifyPayPushUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-push/${path}${contractPriv}`;
}
function stringifyRestoreUri({ providers, walletRootPriv }) {
  const list = providers.map((url) => `${encodeURIComponent(new URL2(url).href)}`).join(",");
  return `taler://restore/${walletRootPriv}/${list}`;
}
function stringifyWithdrawExchange({ exchangeBaseUrl, amount }) {
  const { proto, path, query } = getUrlInfo(exchangeBaseUrl, {
    a: amount
  });
  return `${proto}://withdraw-exchange/${path}${query}`;
}
function stringifyAddExchange({ exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://add-exchange/${path}`;
}
function stringifyAddContact({ alias, aliasType, mailboxBaseUri, mailboxIdentity, sourceBaseUrl }) {
  const { proto, path } = getUrlInfo(mailboxBaseUri);
  const baseUri = `${proto}://add-contact/${aliasType}/${alias}/${path}${mailboxIdentity}`;
  if (sourceBaseUrl) {
    return baseUri + `?sourceBaseUrl=${encodeURIComponent(sourceBaseUrl)}`;
  } else {
    return baseUri;
  }
}
function stringifyDevExperimentUri({ devExperimentId }) {
  return `taler://dev-experiment/${devExperimentId}`;
}
function stringifyPayTemplateUri({ merchantBaseUrl, templateId }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl);
  return `${proto}://pay-template/${path}${templateId}${query}`;
}
function stringifyRefundUri({ merchantBaseUrl, orderId }) {
  const { proto, path } = getUrlInfo(merchantBaseUrl);
  return `${proto}://refund/${path}${orderId}/`;
}
function stringifyWithdrawUri({ bankIntegrationApiBaseUrl, withdrawalOperationId }) {
  const { proto, path } = getUrlInfo(bankIntegrationApiBaseUrl);
  return `${proto}://withdraw/${path}${withdrawalOperationId}`;
}
function getUrlInfo(baseUrl, params = {}) {
  const url = new URL2(baseUrl);
  let proto;
  if (url.protocol === "https:") {
    proto = "taler";
  } else if (url.protocol === "http:") {
    proto = "taler+http";
  } else {
    throw Error(`Unsupported URL protocol in ${baseUrl}`);
  }
  let path = url.hostname;
  if (url.port) {
    path = path + ":" + url.port;
  }
  if (url.pathname) {
    path = path + url.pathname;
  }
  if (!path.endsWith("/")) {
    path = path + "/";
  }
  const qp = new URLSearchParams2();
  let withParams = false;
  Object.entries(params).forEach(([name, value]) => {
    if (value !== void 0) {
      withParams = true;
      qp.append(name, value);
    }
  });
  const query = withParams ? "?" + qp.toString() : "";
  return { proto, path, query };
}
function encodeRFC3986URIComponent2(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, (c4) => `%${c4.charCodeAt(0).toString(16).toUpperCase()}`);
}
var rfc39862 = encodeRFC3986URIComponent2;
function createSearchParams2(paramList) {
  return paramList.map(([key, value]) => `${rfc39862(key)}=${rfc39862(value)}`).join("&");
}

// ../taler-util/lib/types-taler-corebank.js
var MonitorTimeframeParam;
(function(MonitorTimeframeParam2) {
  MonitorTimeframeParam2[MonitorTimeframeParam2["hour"] = 0] = "hour";
  MonitorTimeframeParam2[MonitorTimeframeParam2["day"] = 1] = "day";
  MonitorTimeframeParam2[MonitorTimeframeParam2["month"] = 2] = "month";
  MonitorTimeframeParam2[MonitorTimeframeParam2["year"] = 3] = "year";
  MonitorTimeframeParam2[MonitorTimeframeParam2["decade"] = 4] = "decade";
})(MonitorTimeframeParam || (MonitorTimeframeParam = {}));
var codecForIntegrationBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-bank-integration")).property("version", codecForString()).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("implementation", codecOptional(codecForString())).build("TalerCorebankApi.IntegrationConfig");
var codecForCoreBankConfig = () => buildCodecForObject().property("name", codecForEither(codecForConstString("taler-corebank"), codecForConstString("libeufin-bank"))).property("version", codecForString()).property("bank_name", codecOptional(codecForString())).property("base_url", codecOptional(codecForString())).property("allow_conversion", codecOptional(codecForBoolean())).property("allow_registrations", codecOptional(codecForBoolean())).property("allow_deletions", codecOptional(codecForBoolean())).property("allow_edit_name", codecOptional(codecForBoolean())).property("allow_edit_cashout_payto_uri", codecOptional(codecForBoolean())).property("default_debit_threshold", codecOptional(codecForAmountString())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_tan_channels", codecOptional(codecForList(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))))).property("wire_type", codecOptionalDefault(codecForString(), "iban")).property("wire_transfer_fees", codecOptional(codecForAmountString())).property("min_wire_transfer_amount", codecOptional(codecForAmountString())).property("max_wire_transfer_amount", codecOptional(codecForAmountString())).build("TalerCorebankApi.Config");
var codecForBalance = () => buildCodecForObject().property("amount", codecForAmountString()).property("credit_debit_indicator", codecForEither(codecForConstString("credit"), codecForConstString("debit"))).build("TalerCorebankApi.Balance");
var codecForPublicAccount = () => buildCodecForObject().property("username", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).property("is_taler_exchange", codecForBoolean()).property("row_id", codecOptional(codecForNumber())).build("TalerCorebankApi.PublicAccount");
var codecForPublicAccountsResponse = () => buildCodecForObject().property("public_accounts", codecForList(codecForPublicAccount())).build("TalerCorebankApi.PublicAccountsResponse");
var codecForAccountMinimalData = () => buildCodecForObject().property("username", codecForString()).property("name", codecForString()).property("payto_uri", codecForPaytoString()).property("balance", codecForBalance()).property("row_id", codecForNumber()).property("debit_threshold", codecForAmountString()).property("is_public", codecForBoolean()).property("is_taler_exchange", codecForBoolean()).property("status", codecOptional(codecForEither(codecForConstString("active"), codecForConstString("locked"), codecForConstString("deleted")))).property("conversion_rate_class_id", codecOptional(codecForNumber())).property("conversion_rate", codecOptional(codecForConversionRate())).build("TalerCorebankApi.AccountMinimalData");
var codecForListBankAccountsResponse = () => buildCodecForObject().property("accounts", codecForList(codecForAccountMinimalData())).build("TalerCorebankApi.ListBankAccountsResponse");
var codecForAccountData = () => buildCodecForObject().property("name", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).property("debit_threshold", codecForAmountString()).property("contact_data", codecOptional(codecForChallengeContactData())).property("cashout_payto_uri", codecOptional(codecForPaytoString())).property("is_public", codecForBoolean()).property("is_taler_exchange", codecForBoolean()).property("conversion_rate_class_id", codecOptional(codecForNumber())).property("tan_channel", codecOptional(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL)))).property("status", codecOptional(codecForEither(codecForConstString("active"), codecForConstString("locked"), codecForConstString("deleted")))).build("TalerCorebankApi.AccountData");
var codecForConversionRateClassResponse = () => buildCodecForObject().property("conversion_rate_class_id", codecForNumber()).build("TalerCorebankApi.ConversionRateClassResponse");
var codecForConversionRateClass = () => buildCodecForObject().property("cashin_fee", codecOptional(codecForAmountString())).property("cashin_min_amount", codecOptional(codecForAmountString())).property("cashin_ratio", codecOptional(codecForDecimalNumber())).property("cashin_rounding_mode", codecOptional(codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest")))).property("cashout_fee", codecOptional(codecForAmountString())).property("cashout_min_amount", codecOptional(codecForAmountString())).property("cashout_ratio", codecOptional(codecForDecimalNumber())).property("cashout_rounding_mode", codecOptional(codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest")))).property("conversion_rate_class_id", codecForNumber()).property("description", codecOptional(codecForString())).property("name", codecForString()).property("num_users", codecForNumber()).build("TalerCorebankApi.ConversionRateClass");
var codecForConversionRateClasses = () => buildCodecForObject().property("classes", codecForList(codecForConversionRateClass())).build("TalerCorebankApi.ConversionRateClasses");
var codecForChallengeContactData = () => buildCodecForObject().property("email", codecOptional(codecForString())).property("phone", codecOptional(codecForString())).build("TalerCorebankApi.ChallengeContactData");
var codecForWithdrawalPublicInfo = () => buildCodecForObject().property("status", codecForEither(codecForConstString("pending"), codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("amount", codecOptional(codecForAmountString())).property("suggested_amount", codecOptional(codecForAmountString())).property("username", codecForString()).property("selected_reserve_pub", codecOptional(codecForString())).property("selected_exchange_account", codecOptional(codecForPaytoString())).property("no_amount_to_wallet", codecOptional(codecForBoolean())).build("TalerCorebankApi.WithdrawalPublicInfo");
var codecForBankAccountTransactionsResponse = () => buildCodecForObject().property("transactions", codecForList(codecForBankAccountTransactionInfo())).build("TalerCorebankApi.BankAccountTransactionsResponse");
var codecForBankAccountTransactionInfo = () => buildCodecForObject().property("creditor_payto_uri", codecForPaytoString()).property("debtor_payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("direction", codecForEither(codecForConstString("debit"), codecForConstString("credit"))).property("subject", codecForString()).property("row_id", codecForNumber()).property("date", codecForTimestamp).build("TalerCorebankApi.BankAccountTransactionInfo");
var codecForCreateTransactionResponse = () => buildCodecForObject().property("row_id", codecForNumber()).build("TalerCorebankApi.CreateTransactionResponse");
var codecForRegisterAccountResponse = () => buildCodecForObject().property("internal_payto_uri", codecForPaytoString()).build("TalerCorebankApi.RegisterAccountResponse");
var codecForBankAccountCreateWithdrawalResponse = () => buildCodecForObject().property("taler_withdraw_uri", codecForTalerUriString()).property("withdrawal_id", codecForString()).build("TalerCorebankApi.BankAccountCreateWithdrawalResponse");
var codecForCashoutPending = () => buildCodecForObject().property("cashout_id", codecForNumber()).build("TalerCorebankApi.CashoutPending");
var codecForCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForCashoutInfo())).build("TalerCorebankApi.Cashouts");
var codecForCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).build("TalerCorebankApi.CashoutInfo");
var codecForGlobalCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForGlobalCashoutInfo())).build("TalerCorebankApi.GlobalCashouts");
var codecForGlobalCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).property("username", codecForString()).build("TalerCorebankApi.GlobalCashoutInfo");
var codecForCashoutStatusResponse = () => buildCodecForObject().property("amount_debit", codecForAmountString()).property("amount_credit", codecForAmountString()).property("subject", codecForString()).property("creation_time", codecForTimestamp).build("TalerCorebankApi.CashoutStatusResponse");
var codecForMonitorResponse = () => buildCodecForUnion().discriminateOn("type").alternative("no-conversions", codecForMonitorNoConversion()).alternative("with-conversions", codecForMonitorWithCashout()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForMonitorNoConversion = () => buildCodecForObject().property("type", codecForConstString("no-conversions")).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorJustPayouts");
var codecForMonitorWithCashout = () => buildCodecForObject().property("type", codecForConstString("with-conversions")).property("cashinCount", codecForNumber()).property("cashinFiatVolume", codecForAmountString()).property("cashinRegionalVolume", codecForAmountString()).property("cashoutCount", codecForNumber()).property("cashoutFiatVolume", codecForAmountString()).property("cashoutRegionalVolume", codecForAmountString()).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorWithCashout");

// ../taler-util/lib/http-client/bank-core.js
var TalerCoreBankCacheEviction;
(function(TalerCoreBankCacheEviction3) {
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["DELETE_ACCOUNT"] = 0] = "DELETE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_ACCOUNT"] = 1] = "CREATE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_ACCOUNT"] = 2] = "UPDATE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_PASSWORD"] = 3] = "UPDATE_PASSWORD";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_TRANSACTION"] = 4] = "CREATE_TRANSACTION";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CONFIRM_WITHDRAWAL"] = 5] = "CONFIRM_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["ABORT_WITHDRAWAL"] = 6] = "ABORT_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_WITHDRAWAL"] = 7] = "CREATE_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_CASHOUT"] = 8] = "CREATE_CASHOUT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_CONVERSION_RATE_CLASS"] = 9] = "CREATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_CONVERSION_RATE_CLASS"] = 10] = "UPDATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["DELETE_CONVERSION_RATE_CLASS"] = 11] = "DELETE_CONVERSION_RATE_CLASS";
})(TalerCoreBankCacheEviction || (TalerCoreBankCacheEviction = {}));
var TalerCoreBankHttpClient = class _TalerCoreBankHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   *
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
   */
  async createAccessToken(username, cred, body, params = {}) {
    const url = new URL(`accounts/${username}/token`, this.baseUrl);
    const headers = {};
    switch (cred.type) {
      case "basic": {
        headers.Authorization = makeBasicAuthHeader2(username, cred.password);
        break;
      }
      case "bearer": {
        headers.Authorization = makeBearerTokenAuthHeader(cred.accessToken);
        break;
      }
      default: {
        assertUnreachable(cred);
      }
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenSuccessResponse());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.GENERIC_FORBIDDEN:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_LOCKED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * @deprecated use createAccessToken
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
   */
  async createAccessTokenBasic(username, password, body) {
    return this.createAccessToken(username, { type: "basic", password }, body);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#delete--accounts-$USERNAME-token
   */
  async deleteAccessToken(user, token) {
    const url = new URL(`accounts/${user}/token`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-tokens
   *
   */
  async getAccessTokenList(user, pagination) {
    const url = new URL(`accounts/${user}/token`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenInfoList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ public_accounts: [] });
      case HttpStatusCode.NotFound:
        return opFixedSuccess({ public_accounts: [] });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-corebank", _TalerCoreBankHttpClient.PROTOCOL_VERSION, resp, codecForCoreBankConfig());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // ACCOUNTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts
   *
   */
  async createAccount(auth, body) {
    const url = new URL(`accounts`, this.baseUrl);
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_ACCOUNT);
        return opSuccessFromHttp(resp, codecForRegisterAccountResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_REGISTER_USERNAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_REGISTER_PAYTO_URI_REUSE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_DEBT_LIMIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_TAN_CHANNEL:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_MISSING_TAN_INFO:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONVERSION_RATE_CLASS_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#delete--accounts-$USERNAME
   *
   */
  async deleteAccount(auth, params = {}) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.DELETE_ACCOUNT);
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_BALANCE_NOT_ZERO:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME
   *
   */
  async updateAccount(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.UPDATE_ACCOUNT);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_LEGAL_NAME:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_CASHOUT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_DEBT_LIMIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_MISSING_TAN_INFO:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONVERSION_RATE_CLASS_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME-auth
   *
   */
  async updatePassword(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/auth`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PATCH_BAD_OLD_PASSWORD:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--public-accounts
   *
   */
  async getPublicAccounts(filter = {}, pagination) {
    const url = new URL(`public-accounts`, this.baseUrl);
    addPaginationParams(url, pagination);
    if (filter.account !== void 0) {
      url.searchParams.set("filter_name", filter.account);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForPublicAccountsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ public_accounts: [] });
      case HttpStatusCode.NotFound:
        return opFixedSuccess({ public_accounts: [] });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts
   *
   */
  async listAccounts(auth, params) {
    const url = new URL(`accounts`, this.baseUrl);
    addPaginationParams(url, params);
    if (params?.account !== void 0) {
      url.searchParams.set("filter_name", params.account);
    }
    if (params?.conversionRateId !== void 0) {
      url.searchParams.set("conversion_rate_class_id", String(params.conversionRateId));
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForListBankAccountsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ accounts: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME
   *
   */
  async getAccount(auth) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountData());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // TRANSACTIONS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-transactions
   *
   */
  async getTransactions(auth, params) {
    const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
    addPaginationParams(url, params);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountTransactionsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transactions: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-transactions-$TRANSACTION_ID
   *
   */
  async getTransactionById(auth, txid) {
    const url = new URL(`accounts/${auth.username}/transactions/${String(txid)}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountTransactionInfo());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-transactions
   *
   */
  async createTransaction(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_TRANSACTION);
        return opSuccessFromHttp(resp, codecForCreateTransactionResponse());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_ADMIN_CREDITOR:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_SAME_ACCOUNT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNKNOWN_CREDITOR:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TRANSFER_REQUEST_UID_REUSED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // WITHDRAWALS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals
   *
   */
  async createWithdrawal(auth, body) {
    const url = new URL(`accounts/${auth.username}/withdrawals`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_WITHDRAWAL);
        return opSuccessFromHttp(resp, codecForBankAccountCreateWithdrawalResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals-$WITHDRAWAL_ID-confirm
   *
   */
  async confirmWithdrawalById(auth, body, wid, params = {}) {
    const url = new URL(`accounts/${auth.username}/withdrawals/${wid}/confirm`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CONFIRM_WITHDRAWAL);
        return opEmptySuccess();
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_CONFIRM_ABORT_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_DIFFERS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_REQUIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals-$WITHDRAWAL_ID-abort
   *
   */
  async abortWithdrawalById(auth, wid) {
    const url = new URL(`accounts/${auth.username}/withdrawals/${wid}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.ABORT_WITHDRAWAL);
        return opEmptySuccess();
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--withdrawals-$WITHDRAWAL_ID
   *
   */
  async getWithdrawalById(wid, params) {
    const url = new URL(`withdrawals/${wid}`, this.baseUrl);
    addLongPollingParam(url, params);
    if (params) {
      url.searchParams.set("old_state", !params.old_state ? "pending" : params.old_state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWithdrawalPublicInfo());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // CASHOUTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-cashouts
   *
   */
  async createCashout(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_CASHOUT);
        return opSuccessFromHttp(resp, codecForCashoutPending());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details2 = await readTalerErrorResponse(resp);
        switch (details2.code) {
          case TalerErrorCode.BANK_TRANSFER_REQUEST_UID_REUSED:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_BAD_CONVERSION:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_CONVERSION_AMOUNT_TO_SMALL:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
            return opKnownTalerFailure(details2.code, details2);
          default:
            return opUnknownHttpFailure(resp, details2);
        }
      }
      case HttpStatusCode.BadGateway: {
        const details2 = await readTalerErrorResponse(resp);
        switch (details2.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_SCRIPT_FAILED:
            return opKnownTalerFailure(details2.code, details2);
          default:
            return opUnknownHttpFailure(resp, details2);
        }
      }
      case HttpStatusCode.NotImplemented:
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opKnownHttpFailure(resp.status, resp);
        }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts-$CASHOUT_ID
   *
   */
  async getCashoutById(auth, cid) {
    const url = new URL(`accounts/${auth.username}/cashouts/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashoutStatusResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts
   *
   */
  async getAccountCashouts(auth, pagination) {
    const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashouts());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ cashouts: [] });
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--cashouts
   *
   */
  async getGlobalCashouts(auth, pagination) {
    const url = new URL(`cashouts`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForGlobalCashouts());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ cashouts: [] });
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // CONVERSION RATE CLASS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--conversion-rate-classes
   *
   */
  async createConversionRateClass(auth, body) {
    const url = new URL(`conversion-rate-classes`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_CONVERSION_RATE_CLASS);
        return opSuccessFromHttp(resp, codecForConversionRateClassResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--conversion-rate-classes-CLASS_ID
   *
   */
  async updateConversionRateClass(auth, cid, body) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.UPDATE_CONVERSION_RATE_CLASS);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts
   *
   */
  async deleteConversionRateClass(auth, cid) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.DELETE_CONVERSION_RATE_CLASS);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--conversion-rate-classes-CLASS_ID
   *
   */
  async getConversionRateClass(auth, cid) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRateClass());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--conversion-rate-classes
   *
   */
  async listConversionRateClasses(auth, params = {}) {
    const url = new URL(`conversion-rate-classes`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.className) {
      url.searchParams.set("filter_name", params.className);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRateClasses());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ classes: [], default: {} });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // 2FA
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-challenge-$CHALLENGE_ID
   *
   */
  async sendChallenge(username, cid) {
    const url = new URL(`accounts/${username}/challenge/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeRequestResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({});
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_SCRIPT_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID-confirm
   *
   */
  async confirmChallenge(username, cid, body) {
    const url = new URL(`accounts/${username}/challenge/${cid}/confirm`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHALLENGE_FAILED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHALLENGE_EXPIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TRANSACTION_NOT_FOUND:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHALLENGE_EXPIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        return opKnownHttpFailure(resp.status, resp);
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // MONITOR
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get--monitor
   *
   */
  async getMonitor(auth, params = {}) {
    const url = new URL(`monitor`, this.baseUrl);
    if (params.timeframe) {
      url.searchParams.set("timeframe", MonitorTimeframeParam[params.timeframe]);
    }
    if (params.date) {
      const { t_s: seconds } = AbsoluteTime.toProtocolTimestamp(params.date);
      if (seconds !== "never") {
        url.searchParams.set("date_s", String(seconds));
      }
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMonitorResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Others API
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getIntegrationAPI() {
    return new URL(`taler-integration/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getWireGatewayAPI(username) {
    return new URL(`accounts/${username}/taler-wire-gateway/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getRevenueAPI(username) {
    return new URL(`accounts/${username}/taler-revenue/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--accounts-$USERNAME-conversion-info-*
   *
   */
  getConversionInfoAPIForUser(username) {
    return new URL(`accounts/${username}/conversion-info/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--conversion-rate-classes-$CLASS_ID-conversion-info-*
   *
   */
  getConversionInfoAPIForClass(classId) {
    return new URL(`conversion-rate-classes/${String(classId)}/conversion-info/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--conversion-info-*
   *
   */
  getConversionInfoAPI() {
    return new URL(`conversion-info/`, this.baseUrl);
  }
};
TalerCoreBankHttpClient.PROTOCOL_VERSION = "10:0:2";

// ../taler-util/lib/types-taler-bank-integration.js
var codecForBankWithdrawalOperationStatus = () => buildCodecForObject().property("status", codecForEither(codecForConstString("pending"), codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("currency", codecOptional(codecForCurrencyName())).property("amount", codecOptional(codecForAmountString())).property("suggested_amount", codecOptional(codecForAmountString())).property("min_amount", codecOptional(codecForAmountString())).property("max_amount", codecOptional(codecForAmountString())).property("card_fees", codecOptional(codecForAmountString())).property("sender_wire", codecOptional(codecForPaytoString())).property("suggested_exchange", codecOptional(codecForURLString())).property("required_exchange", codecOptional(codecForURLString())).property("confirm_transfer_url", codecOptional(codecForURLString())).property("wire_types", codecForList(codecForString())).property("selected_reserve_pub", codecOptional(codecForString())).property("selected_exchange_account", codecOptional(codecForString())).property("no_amount_to_wallet", codecOptional(codecForBoolean())).deprecatedProperty("aborted").deprecatedProperty("selection_done").deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationStatus");
var codecForBankWithdrawalOperationPostResponse = () => buildCodecForObject().property("status", codecForEither(codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("confirm_transfer_url", codecOptional(codecForURLString())).deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationPostResponse");

// ../taler-util/lib/http-client/bank-integration.js
var logger6 = new Logger("bank-integration.ts");
var TalerBankIntegrationHttpClient = class _TalerBankIntegrationHttpClient {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-bank-integration", _TalerBankIntegrationHttpClient.PROTOCOL_VERSION, resp, codecForIntegrationBankConfig());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--withdrawal-operation-$WITHDRAWAL_ID
   *
   */
  async getWithdrawalOperationById(woid, params) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    addLongPollingParam(url, params);
    if (params) {
      url.searchParams.set("old_state", !params.old_state ? "pending" : params.old_state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationStatus());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * FIXME: This is a misnomer!
   *
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   */
  async completeWithdrawalOperationById(woid, body) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationPostResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const body2 = await readTalerErrorResponse(resp);
        const details = codecForTalerErrorDetail().decode(body2);
        switch (details.code) {
          case TalerErrorCode.BANK_UPDATE_ABORT_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_DUPLICATE_RESERVE_PUB_SUBJECT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNKNOWN_ACCOUNT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_IS_NOT_EXCHANGE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_DIFFERS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   *
   */
  async abortWithdrawalOperationById(woid) {
    const url = new URL(`withdrawal-operation/${woid}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerBankIntegrationHttpClient.PROTOCOL_VERSION = "5:0:0";

// ../taler-util/lib/types-taler-revenue.js
var codecForRevenueConfig = () => buildCodecForObject().property("name", codecForConstString("taler-revenue")).property("version", codecForString()).property("currency", codecForString()).property("implementation", codecOptional(codecForString())).build("TalerRevenueApi.RevenueConfig");
var codecForRevenueIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForRevenueIncomingBankTransaction())).build("TalerRevenueApi.MerchantIncomingHistory");
var codecForRevenueIncomingBankTransaction = () => buildCodecForObject().property("row_id", codecForNumber()).property("date", codecForTimestamp).property("amount", codecForAmountString()).property("debit_account", codecForPaytoString()).property("subject", codecForString()).build("TalerRevenueApi.RevenueIncomingBankTransaction");

// ../taler-util/lib/http-client/bank-revenue.js
var TalerRevenueHttpClient = class _TalerRevenueHttpClient {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-revenue.html#get--config
   *
   */
  async getConfig(auth) {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: createAuthorizationHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-revenue", _TalerRevenueHttpClient.PROTOCOL_VERSION, resp, codecForRevenueConfig());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-revenue.html#get--history
   *
   * @returns
   */
  async getHistory(auth, params) {
    const url = new URL(`history`, this.baseUrl);
    addPaginationParams(url, params);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: createAuthorizationHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForRevenueIncomingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          incoming_transactions: [],
          credit_account: ""
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerRevenueHttpClient.PROTOCOL_VERSION = "1:0:0";

// ../taler-util/lib/types-taler-wire-gateway.js
var codecForWireConfigResponse = () => buildCodecForObject().property("currency", codecForString()).property("implementation", codecForString()).property("name", codecForConstString("taler-wire-gateway")).property("support_account_check", codecForBoolean()).property("version", codecForString()).build("TalerWireGatewayApi.WireConfig");
var codecForTransferResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.TransferResponse");
var codecForIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForIncomingBankTransaction())).build("TalerWireGatewayApi.IncomingHistory");
var codecForIncomingBankTransaction = () => buildCodecForUnion().discriminateOn("type").alternative("RESERVE", codecForIncomingReserveTransaction()).alternative("KYCAUTH", codecForIncomingKycAuthTransaction()).alternative("WAD", codecForIncomingWadTransaction()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForIncomingReserveTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("reserve_pub", codecForEddsaPublicKey()).property("row_id", codecForNumber()).property("type", codecForConstString("RESERVE")).build("TalerWireGatewayApi.IncomingReserveTransaction");
var codecForIncomingKycAuthTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("account_pub", codecForEddsaPublicKey()).property("row_id", codecForNumber()).property("type", codecForConstString("KYCAUTH")).build("TalerWireGatewayApi.IncomingKycAuthTransaction");
var codecForIncomingWadTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("origin_exchange_url", codecForString()).property("row_id", codecForNumber()).property("type", codecForConstString("WAD")).property("wad_id", codecForString()).build("TalerWireGatewayApi.IncomingWadTransaction");
var codecForOutgoingHistory = () => buildCodecForObject().property("debit_account", codecForPaytoString()).property("outgoing_transactions", codecForList(codecForOutgoingBankTransaction())).build("TalerWireGatewayApi.OutgoingHistory");
var codecForOutgoingBankTransaction = () => buildCodecForObject().property("row_id", codecForNumber()).property("date", codecForTimestamp).property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("wtid", codecForString()).property("exchange_base_url", codecForString()).build("TalerWireGatewayApi.OutgoingBankTransaction");
var codecForAddIncomingResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.AddIncomingResponse");
var codecForBankWireTransferList = () => buildCodecForObject().property("debit_account", codecForPaytoString()).property("transfers", codecForList(codecForBankWireTransferListStatus())).build("TalerWireGatewayApi.BankWireTransferList");
var codecForBankWireTransferListStatus = () => buildCodecForObject().property("row_id", codecForNumber()).property("status", codecForEither(codecForConstString("pending"), codecForConstString("transient_failure"), codecForConstString("permanent_failure"), codecForConstString("success"))).property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.BankWireTransferListStatus");

// ../taler-util/lib/http-client/bank-wire.js
var TalerWireGatewayHttpClient = class _TalerWireGatewayHttpClient {
  constructor(baseUrl, options = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = options.httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-wire-gateway", _TalerWireGatewayHttpClient.PROTOCOL_VERSION, resp, codecForWireConfigResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--transfer
   *
   */
  async makeWireTransfer(req) {
    const url = new URL(`transfer`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTransferResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--transfers
   *
   */
  async getTransfers(req) {
    const url = new URL(`transfers`, this.baseUrl);
    if (req.params) {
      if (req.params.status) {
        url.searchParams.set("status", req.params.status);
      }
    }
    addPaginationParams(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWireTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          transfers: [],
          debit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--transfers-$ROW_ID
   *
   */
  async getTransferStatus(req) {
    const url = new URL(`transfers/${req.rowId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWireTransferList());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--history-incoming
   *
   */
  async getHistoryIncoming(req) {
    const url = new URL(`history/incoming`, this.baseUrl);
    addPaginationParams(url, req.params);
    addLongPollingParam(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIncomingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          incoming_transactions: [],
          credit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--history-outgoing
   *
   */
  async getHistoryOutgoing(req) {
    const url = new URL(`history/outgoing`, this.baseUrl);
    addPaginationParams(url, req.params);
    addLongPollingParam(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOutgoingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          outgoing_transactions: [],
          debit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--admin-add-incoming
   *
   */
  async addIncoming(req) {
    const url = new URL(`admin/add-incoming`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAddIncomingResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--admin-add-kycauth
   *
   */
  async addKycAuth(req) {
    const url = new URL(`admin/add-kycauth`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAddIncomingResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerWireGatewayHttpClient.PROTOCOL_VERSION = "4:0:0";

// ../taler-util/lib/types-taler-challenger.js
var codecForChallengerTermsOfServiceResponse = () => buildCodecForObject().property("name", codecForConstString("challenger")).property("version", codecForString()).property("implementation", codecOptional(codecForString())).property("restrictions", codecOptional(codecForMap(codecForAny()))).property("address_type", codecForEither(codecForConstString("phone"), codecForConstString("email"), codecForConstString("postal"), codecForConstString("postal-ch"))).build("ChallengerApi.ChallengerTermsOfServiceResponse");
var codecForChallengeSetupResponse = () => buildCodecForObject().property("nonce", codecForString()).build("ChallengerApi.ChallengeSetupResponse");
var codecForChallengeStatus = () => buildCodecForObject().property("fix_address", codecForBoolean()).property("solved", codecForBoolean()).property("last_address", codecOptional(codecForMap(codecForAny()))).property("changes_left", codecForNumber()).property("retransmission_time", codecForTimestamp).property("pin_transmissions_left", codecForNumber()).property("auth_attempts_left", codecForNumber()).build("ChallengerApi.ChallengeStatus");
var codecForChallengeResponse2 = () => buildCodecForUnion().discriminateOn("type").alternative("completed", codecForChallengeRedirect()).alternative("created", codecForChallengeCreateResponse()).build("ChallengerApi.ChallengeResponse");
var codecForChallengeCreateResponse = () => buildCodecForObject().property("attempts_left", codecForNumber()).property("type", codecForConstString("created")).property("nonce", codecOptional(codecForString())).property("address", codecForAny()).property("transmitted", codecForBoolean()).property("retransmission_time", codecForTimestamp).build("ChallengerApi.ChallengeCreateResponse");
var codecForChallengeRedirect = () => buildCodecForObject().property("type", codecForConstString("completed")).property("redirect_url", codecForString()).build("ChallengerApi.ChallengeRedirect");
var codecForChallengeInvalidPinResponse = () => buildCodecForObject().property("ec", codecOptional(codecForNumber())).property("code", codecOptional(codecForNumber())).property("hint", codecForAny()).property("type", codecForConstString("pending")).property("addresses_left", codecForNumber()).property("pin_transmissions_left", codecForNumber()).property("auth_attempts_left", codecForNumber()).property("exhausted", codecForBoolean()).property("no_challenge", codecForBoolean()).build("ChallengerApi.InvalidPinResponse");
var codecForChallengeSolveResponse = () => buildCodecForUnion().discriminateOn("type").alternative("completed", codecForChallengeRedirect()).alternative("pending", codecForChallengeInvalidPinResponse()).build("ChallengerApi.ChallengeSolveResponse");
var codecForChallengerAuthResponse = () => buildCodecForObject().property("access_token", codecForString()).property("token_type", codecForAny()).property("expires_in", codecForNumber()).build("ChallengerApi.ChallengerAuthResponse");
var codecForChallengerInfoResponse = () => buildCodecForObject().property("id", codecForNumber()).property("address", codecForAny()).property("address_type", codecForString()).property("expires", codecForTimestamp).build("ChallengerApi.ChallengerInfoResponse");

// ../taler-util/lib/http-client/challenger.js
var ChallengerCacheEviction;
(function(ChallengerCacheEviction3) {
  ChallengerCacheEviction3[ChallengerCacheEviction3["CREATE_CHALLENGE"] = 0] = "CREATE_CHALLENGE";
  ChallengerCacheEviction3[ChallengerCacheEviction3["SOLVE_CHALLENGE"] = 1] = "SOLVE_CHALLENGE";
})(ChallengerCacheEviction || (ChallengerCacheEviction = {}));
var ChallengerHttpClient = class _ChallengerHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-challenger.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("challenger", _ChallengerHttpClient.PROTOCOL_VERSION, resp, codecForChallengerTermsOfServiceResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-challenger.html#post--setup-$CLIENT_ID
   *
   */
  async setup(clientId, token, body) {
    const url = new URL(`setup/${clientId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeSetupResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // LOGIN
  /**
   * https://docs.taler.net/core/api-challenger.html#post--authorize-$NONCE
   *
   */
  async login(nonce, clientId, redirectUri, state) {
    const url = new URL(`authorize/${nonce}`, this.baseUrl);
    url.searchParams.set("response_type", "code");
    url.searchParams.set("client_id", clientId);
    url.searchParams.set("redirect_uri", redirectUri);
    if (state) {
      url.searchParams.set("state", state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeStatus());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // CHALLENGE
  /**
   * https://docs.taler.net/core/api-challenger.html#post--challenge-$NONCE
   *
   */
  async challenge(nonce, body) {
    const url = new URL(`challenge/${nonce}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(ChallengerCacheEviction.CREATE_CHALLENGE);
        return opSuccessFromHttp(resp, codecForChallengeResponse2());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // SOLVE
  /**
   * https://docs.taler.net/core/api-challenger.html#post--solve-$NONCE
   *
   */
  async solve(nonce, body) {
    const url = new URL(`solve/${nonce}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body: new URLSearchParams(Object.entries(body)).toString(),
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      redirect: "manual"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(ChallengerCacheEviction.SOLVE_CHALLENGE);
        return opSuccessFromHttp(resp, codecForChallengeSolveResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownAlternativeHttpFailure(resp, HttpStatusCode.Forbidden, codecForChallengeInvalidPinResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // AUTH
  /**
   * https://docs.taler.net/core/api-challenger.html#post--token
   *
   */
  async token(client_id, redirect_uri, client_secret, code) {
    const url = new URL(`token`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: new URLSearchParams(Object.entries({
        client_id,
        redirect_uri,
        client_secret,
        code,
        grant_type: "authorization_code"
      })).toString()
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengerAuthResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // INFO
  /**
   * https://docs.taler.net/core/api-challenger.html#get--info
   *
   */
  async info(token) {
    const url = new URL(`info`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengerInfoResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
ChallengerHttpClient.PROTOCOL_VERSION = "2:0:0";

// ../taler-util/lib/types-donau.js
var codecForDonauVersionResponse = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("donau")).property("currency", codecForString()).property("legal_domain", codecForString()).build("DonauApi.DonauVersionResponse");
var codecForDonationUnitKeyGroup = codecForAny();
var codecForDonauKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForString()).property("currency", codecForString()).property("signkeys", codecForAny()).property("donation_units", codecForList(codecForDonationUnitKeyGroup)).build("DonauApi.DonauKeysResponse");
var codecForIssuePrepareResponse = () => buildCodecForUnion().discriminateOn("cipher").alternative("CS", codecForAny()).alternative("RSA", codecForAny()).build("DonauApi.IssuePrepareResponse");
var codecForDonauCharityResponse = () => buildCodecForObject().property("charity_id", codecForNumber()).build("DonauApi.DonauCharityResponse");
var codecForDonauDonationStatementResponse = () => buildCodecForObject().property("total", codecForAmountString()).property("donau_pub", codecForEddsaPublicKey()).property("donation_statement_sig", codecForEddsaSignature()).build("DonauApi.DonationStatementResponse");

// ../taler-util/lib/http-client/donau-client.js
var DonauHttpClient = class _DonauHttpClient {
  constructor(baseUrl, params = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = params.httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--keys
   *
   * @returns
   */
  async getKeys() {
    const url = new URL(`keys`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForDonauKeysResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--seed
   *
   */
  async getSeed() {
    const url = new URL(`keys`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        const buffer = await resp.bytes();
        const uintar = new Uint8Array(buffer);
        return opFixedSuccess(uintar);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--config
   *
   * @returns
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("donau", _DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION, resp, codecForDonauVersionResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#csr-issue
   *
   * @param args
   * @returns
   */
  async prepareIssueReceipt(body) {
    const url = new URL(`csr-issue`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIssuePrepareResponse());
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Gone:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--batch-issue-$CHARITY_ID
   *
   * @param args
   * @returns
   */
  async issueReceipts(charityId, body) {
    const url = new URL(`batch-issue/${charityId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Conflict:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Gone:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--batch-submit
   *
   * @param args
   * @returns
   */
  async submitDonationReceipts(body) {
    const url = new URL(`batch-submit`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Created:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--donation-statement-$YEAR-$HASH_DONOR_ID
   *
   * @param args
   * @returns
   */
  async getDonationStatement(year, hash4) {
    const url = new URL(`donation-statement/${year}/${hash4}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForDonauDonationStatementResponse());
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--charities
   *
   * @param args
   * @returns
   */
  async getCharities(token) {
    const url = new URL(`charities`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          charities: []
        });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--charities-$CHARITY_ID
   */
  async getCharitiesById(token, id) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--charities
   *
   * @param args
   * @returns
   */
  async createCharity(token, body) {
    const url = new URL(`charities`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Created:
        return opSuccessFromHttp(resp, codecForDonauCharityResponse());
      case HttpStatusCode.NoContent:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#patch--charities-id
   *
   * @returns
   */
  async updateCharity(token, id, body) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#patch--charities-id
   *
   * @returns
   */
  async deleteCharity(token, id) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION = "0:0:0";

// ../taler-util/lib/http-client/exchange-client.js
var TalerExchangeCacheEviction;
(function(TalerExchangeCacheEviction3) {
  TalerExchangeCacheEviction3[TalerExchangeCacheEviction3["UPLOAD_KYC_FORM"] = 0] = "UPLOAD_KYC_FORM";
  TalerExchangeCacheEviction3[TalerExchangeCacheEviction3["MAKE_AML_DECISION"] = 1] = "MAKE_AML_DECISION";
})(TalerExchangeCacheEviction || (TalerExchangeCacheEviction = {}));
var TalerExchangeHttpClient = class _TalerExchangeHttpClient {
  constructor(baseUrl, params = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = params.httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = params.cacheEvictor ?? nullEvictor;
    this.preventCompression = !!params.preventCompression;
    this.cancelationToken = params.cancelationToken ?? CancellationToken.CONTINUE;
    this.longPollQueue = params.longPollQueue ?? new LongpollQueue();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  async fetch(url_or_path, opts = {}, longpoll = false) {
    const url = typeof url_or_path == "string" ? new URL(url_or_path, this.baseUrl) : url_or_path;
    if (longpoll || url.searchParams.has("timeout_ms")) {
      return this.longPollQueue.run(url, this.cancelationToken, async (timeoutMs) => {
        url.searchParams.set("timeout_ms", String(timeoutMs));
        return this.httpLib.fetch(url.href, {
          cancellationToken: this.cancelationToken,
          ...opts
        });
      });
    } else {
      return this.httpLib.fetch(url.href, {
        cancellationToken: this.cancelationToken,
        ...opts
      });
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--seed
   *
   */
  async getSeed() {
    const resp = await this.fetch("seed");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        const buffer = await resp.bytes();
        const uintar = new Uint8Array(buffer);
        return opFixedSuccess(uintar);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--config
   *
   */
  async getConfig() {
    const resp = await this.fetch("config");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-exchange", _TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION, resp, codecForExchangeConfig());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--config
   *
   * PARTIALLY IMPLEMENTED!!
   */
  async getKeys() {
    const resp = await this.fetch("keys");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeKeysResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WALLET TO WALLET
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-merge
   *
   */
  async getPurseStatusAtMerge(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-deposit
   *
   */
  async getPurseStatusAtDeposit(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-create
   *
   */
  async createPurseFromDeposit(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/create`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.TooEarly:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#delete--purses-$PURSE_PUB
   *
   */
  async deletePurse(pursePub, purseSig) {
    const resp = await this.fetch(`purses/${pursePub}`, {
      method: "DELETE",
      headers: {
        "taler-purse-signature": purseSig
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * POST /purses/$PURSE_PUB/merge
   *
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-merge
   */
  async postPurseMerge(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMergeSuccessResponse());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForExchangeMergeConflictResponse());
      case HttpStatusCode.Gone:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--reserves-$RESERVE_PUB-purse
   *
   */
  async createPurseFromReserve(pursePub, body) {
    const resp = await this.fetch(`reserves/${pursePub}/purse`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.PaymentRequired:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflictPartial());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--contracts-$CONTRACT_PUB
   *
   */
  async getContract(pursePub) {
    const resp = await this.fetch(`contracts/${pursePub}`);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeGetContractResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-deposit
   *
   */
  async depositIntoPurse(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WADS
  /**
   * https://docs.taler.net/core/api-exchange.html#get--wads-$WAD_ID
   *
   */
  async getWadInfo() {
    throw Error("not yet implemented");
  }
  //
  // KYC
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-wallet
   *
   */
  async notifyKycBalanceLimit(body) {
    const url = new URL(`kyc-wallet`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlWalletKycCheckResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-check-$H_NORMALIZED_PAYTO
   *
   */
  async checkKycStatus(args) {
    const { paytoHash, accountPub, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig,
        "Account-Owner-Pub": accountPub
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Do a /kyc-check request, but don't specify
   * the account pub explicitly.
   *
   * Deprecated, but used in tests.
   */
  async testingCheckKycStatusNoPub(args) {
    const { paytoHash, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-info-$ACCESS_TOKEN
   *
   */
  async checkKycInfo(token, known = [], longpoll = false) {
    const resp = await this.fetch(`kyc-info/${token}`, {
      method: "GET",
      headers: {
        "If-None-Match": known.length ? known.join(",") : void 0
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessClientInformation());
      case HttpStatusCode.Accepted:
      case HttpStatusCode.NoContent:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForEmptyObject());
      case HttpStatusCode.NotModified:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * SPA-Specific version of checkKycInfo
   */
  async checkKycInfoSpa(token, etag, params = {}) {
    const url = new URL(`kyc-info/${token}`, this.baseUrl);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        "If-None-Match": etag
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        const etag2 = resp.headers.get("etag") ?? void 0;
        const body = await readSuccessResponseJsonOrThrow(resp, codecForKycProcessClientInformation());
        return opFixedSuccess({
          ...body,
          etag: etag2
        });
      }
      case HttpStatusCode.Accepted:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NoContent:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotModified:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-upload-$ID
   *
   */
  async uploadKycForm(requirement, body) {
    const resp = await this.fetch(`kyc-upload/${requirement}`, {
      method: "POST",
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.UPLOAD_KYC_FORM);
        return opEmptySuccess();
      }
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-start-$ID
   *
   */
  async startExternalKycProcess(requirement, body = {}) {
    const resp = await this.fetch(`kyc-start/${requirement}`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessStartInformation());
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-proof-$PROVIDER_NAME?state=$H_PAYTO
   *
   */
  async completeExternalKycProcess(provider, state, code) {
    const resp = await this.fetch(`kyc-proof/${provider}?state=${state}&code=${code}`, {
      method: "GET",
      redirect: "manual"
    });
    switch (resp.status) {
      case HttpStatusCode.SeeOther:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // AML operations
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-measures
   *
   */
  async getAmlMeasures(auth) {
    const resp = await this.fetch(`aml/${auth.id}/measures`, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAvailableMeasureSummary());
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-kyc-statistics-$NAMES
   *
   */
  async getAmlKycStatistics(auth, names2, filter = {}) {
    const url = new URL(`aml/${auth.id}/kyc-statistics/${names2.join(" ")}`, this.baseUrl);
    if (filter.since !== void 0 && filter.since.t_ms !== "never") {
      url.searchParams.set("start_date", String(filter.since.t_ms));
    }
    if (filter.until !== void 0 && filter.until.t_ms !== "never") {
      url.searchParams.set("end_date", String(filter.until.t_ms));
    }
    const resp = await this.fetch(url, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlStatisticsResponse());
      case HttpStatusCode.NoContent: {
        return opFixedSuccess({
          statistics: names2.map((name) => ({ counter: 0, name }))
        });
      }
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-decisions
   *
   */
  async getAmlAccounts(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/accounts`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.investigation !== void 0) {
      url.searchParams.set("investigation", params.investigation ? "YES" : "NO");
    }
    if (params.open !== void 0 && params.open) {
      url.searchParams.set("open", "YES");
    }
    if (params.highRisk !== void 0 && params.highRisk) {
      url.searchParams.set("high_risk", "YES");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlDecisionsAccounts());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ accounts: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-decisions
   *
   */
  async getAmlDecisions(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/decisions`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    if (params.investigation !== void 0) {
      url.searchParams.set("investigation", params.investigation ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlDecisionsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ records: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-legitimizations
   */
  async getAmlLegitimizations(officer, params = {}) {
    const url = new URL(`aml/${officer.id}/legitimizations`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    const resp = await this.httpLib.fetch(url.href, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(officer.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForLegitimizationMeasuresList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          measures: []
        });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-attributes-$H_PAYTO
   *
   */
  async getAmlAttributesForAccount(auth, account, params = {}) {
    const url = new URL(`aml/${auth.id}/attributes/${account}`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlKycAttributes());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ details: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async getAmlAttributesForAccountAsPdf(auth, account, params = {}) {
    const url = new URL(`aml/${auth.id}/attributes/${account}`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.fetch(url, {
      headers: {
        Accept: "application/pdf",
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        return opFixedSuccess(await resp.bytes());
      }
      case HttpStatusCode.NoContent:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async getAmlAccountsAsOtherFormat(auth, mime) {
    const url = new URL(`aml/${auth.id}/accounts`, this.baseUrl);
    const resp = await this.fetch(url, {
      headers: {
        Accept: mime,
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        return opFixedSuccess(await resp.bytes());
      }
      case HttpStatusCode.NoContent:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--aml-$OFFICER_PUB-decision
   *
   */
  async makeAmlDesicion(auth, decision) {
    const body = {
      officer_sig: encodeCrock(signAmlDecision(auth.signingKey, decision)),
      ...decision
    };
    const resp = await this.fetch(`aml/${auth.id}/decision`, {
      method: "POST",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      },
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.MAKE_AML_DECISION);
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-credit
   *
   */
  async getTransfersCredit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-credit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-debit
   *
   */
  async getTransfersDebit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-debit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-kycauth
   *
   */
  async getTransfersKycAuth(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-kycauth`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /withdraw
   *
   * https://docs.taler.net/core/api-exchange.html#withdrawal
   */
  async withdraw(args) {
    const url = new URL(`withdraw`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /melt
   *
   * https://docs.taler.net/core/api-exchange.html#post--melt
   */
  async postMelt(args) {
    const url = new URL(`melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMeltResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async postRevealMelt(args) {
    const url = new URL(`reveal-melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION = "31:0:6";

// ../taler-util/lib/http-client/merchant.js
var TalerMerchantInstanceCacheEviction;
(function(TalerMerchantInstanceCacheEviction3) {
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_ORDER"] = 0] = "CREATE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_ORDER"] = 1] = "UPDATE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_ORDER"] = 2] = "DELETE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_CURRENT_INSTANCE"] = 3] = "UPDATE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_CURRENT_INSTANCE"] = 4] = "DELETE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_BANK_ACCOUNT"] = 5] = "CREATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_BANK_ACCOUNT"] = 6] = "UPDATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_BANK_ACCOUNT"] = 7] = "DELETE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_PRODUCT"] = 8] = "CREATE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_PRODUCT"] = 9] = "UPDATE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_PRODUCT"] = 10] = "DELETE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_CATEGORY"] = 11] = "CREATE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_CATEGORY"] = 12] = "UPDATE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_CATEGORY"] = 13] = "DELETE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TRANSFER"] = 14] = "CREATE_TRANSFER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TRANSFER"] = 15] = "DELETE_TRANSFER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_DEVICE"] = 16] = "CREATE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_DEVICE"] = 17] = "UPDATE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_DEVICE"] = 18] = "DELETE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TEMPLATE"] = 19] = "CREATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_TEMPLATE"] = 20] = "UPDATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TEMPLATE"] = 21] = "DELETE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_WEBHOOK"] = 22] = "CREATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_WEBHOOK"] = 23] = "UPDATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_WEBHOOK"] = 24] = "DELETE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TOKENFAMILY"] = 25] = "CREATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_TOKENFAMILY"] = 26] = "UPDATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TOKENFAMILY"] = 27] = "DELETE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_ACCESSTOKEN"] = 28] = "CREATE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_ACCESSTOKEN"] = 29] = "DELETE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["LAST"] = 30] = "LAST";
})(TalerMerchantInstanceCacheEviction || (TalerMerchantInstanceCacheEviction = {}));
var TalerMerchantManagementCacheEviction;
(function(TalerMerchantManagementCacheEviction3) {
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["CREATE_INSTANCE"] = 31] = "CREATE_INSTANCE";
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["UPDATE_INSTANCE"] = 32] = "UPDATE_INSTANCE";
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["DELETE_INSTANCE"] = 33] = "DELETE_INSTANCE";
})(TalerMerchantManagementCacheEviction || (TalerMerchantManagementCacheEviction = {}));
var TalerMerchantInstanceHttpClient = class _TalerMerchantInstanceHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor, cancellationToken) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
    this.cancellationToken = cancellationToken;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerMerchantInstanceHttpClient.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--config
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-merchant", _TalerMerchantInstanceHttpClient.PROTOCOL_VERSION, resp, codecForTalerMerchantConfigResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Auth
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-token
   *
   */
  async createAccessToken(instance, password, body, params = {}) {
    const url = new URL(`private/token`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBasicAuthHeader2(instance, password);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_ACCESSTOKEN);
        return opSuccessFromHttp(resp, codecForLoginTokenSuccessResponse());
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-tokens
   *
   */
  async listAccessTokens(token, params = {}) {
    const url = new URL(`private/tokens`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenInfoList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ tokens: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-tokens-$SERIAL
   *
   */
  async deleteAccessToken(token, serial) {
    const url = new URL(`private/tokens/${String(serial)}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_ACCESSTOKEN);
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Wallet API
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-orders-$ORDER_ID-claim
   */
  async claimOrder(args) {
    const { orderId, body } = args;
    const url = new URL(`orders/${orderId}/claim`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForClaimResponse());
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound: {
        const body2 = await resp.json();
        const details = codecForTalerErrorDetail().decode(body2);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-orders-$ORDER_ID-pay
   */
  async makePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/pay`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForPaymentResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.PaymentRequired:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.RequestTimeout:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.PreconditionFailed:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.GatewayTimeout:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-orders-$ORDER_ID
   */
  async getPaymentStatus(orderId, params = {}) {
    const url = new URL(`orders/${orderId}`, this.baseUrl);
    if (params.allowRefundedForRepurchase !== void 0) {
      url.searchParams.set("allow_refunded_for_repurchase", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.awaitRefundObtained !== void 0) {
      url.searchParams.set("await_refund_obtained", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.claimToken !== void 0) {
      url.searchParams.set("token", params.claimToken);
    }
    if (params.contractTermHash !== void 0) {
      url.searchParams.set("h_contract", params.contractTermHash);
    }
    if (params.refund !== void 0) {
      url.searchParams.set("refund", params.refund);
    }
    if (params.sessionId !== void 0) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.timeout !== void 0) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
      // body,
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForStatusPaid());
      case HttpStatusCode.Accepted:
        return opSuccessFromHttp(resp, codecForStatusGoto());
      case HttpStatusCode.PaymentRequired:
        return opSuccessFromHttp(resp, codecForStatusStatusUnpaid());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#demonstrating-payment
   */
  async demostratePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/paid`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForPaidRefundStatusResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#aborting-incomplete-payments
   */
  async abortIncompletePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForAbortResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#obtaining-refunds
   */
  async obtainRefund(orderId, body) {
    const url = new URL(`orders/${orderId}/refund`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForWalletRefundResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Management
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-auth
   */
  async updateCurrentInstanceAuthentication(token, body, params = {}) {
    const url = new URL(`private/auth`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private
   */
  async updateCurrentInstance(token, body, params = {}) {
    const url = new URL(`private`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_CURRENT_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private
   *
   */
  async getCurrentInstanceDetails(token) {
    const url = new URL(`private`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForQueryInstancesResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private
   */
  async deleteCurrentInstance(token, params = {}) {
    const url = new URL(`private`, this.baseUrl);
    if (params.purge !== void 0) {
      url.searchParams.set("purge", params.purge ? "YES" : "NO");
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_CURRENT_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--instances-$INSTANCE-private-kyc
   */
  async getCurrentInstanceKycStatus(token, params = {}) {
    const url = new URL(`private/kyc`, this.baseUrl);
    if (params.wireHash) {
      url.searchParams.set("h_wire", params.wireHash);
    }
    if (params.exchangeURL) {
      url.searchParams.set("exchange_url", params.exchangeURL);
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    if (params.reason) {
      url.searchParams.set("lpt", String(params.reason));
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountKycRedirects());
      case HttpStatusCode.Accepted:
        return opSuccessFromHttp(resp, codecForAccountKycRedirects());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycRedirects());
      case HttpStatusCode.ServiceUnavailable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.GatewayTimeout:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Bank Accounts
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-accounts
   */
  async addBankAccount(token, body, params = {}) {
    const url = new URL(`private/accounts`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_BANK_ACCOUNT);
        return opSuccessFromHttp(resp, codecForAccountAddResponse());
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async updateBankAccount(token, wireAccount, body) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_BANK_ACCOUNT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-accounts
   */
  async listBankAccounts(token, params) {
    const url = new URL(`private/accounts`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountsSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async getBankAccountDetails(token, wireAccount) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountDetail());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async deleteBankAccount(token, wireAccount) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_BANK_ACCOUNT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Inventory Management
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-categories
   */
  async listCategories(token, params) {
    const url = new URL(`private/categories`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCategoryListResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-categories-$CATEGORY_ID
   */
  async getCategoryDetails(token, cId) {
    const url = new URL(`private/categories/${cId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCategoryProductList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-categories
   */
  async addCategory(token, body) {
    const url = new URL(`private/categories`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-categories
   */
  async updateCategory(token, cid, body) {
    const url = new URL(`private/categories/${cid}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-categories-$CATEGORY_ID
   */
  async deleteCategory(token, cId) {
    const url = new URL(`private/categories/${cId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-products
   */
  async addProduct(token, body) {
    const url = new URL(`private/products`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async updateProduct(token, productId, body) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-products
   */
  async listProducts(token, params = {}) {
    const url = new URL(`private/products`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.category) {
      url.searchParams.set("category_filter", params.category);
    }
    if (params.name) {
      url.searchParams.set("name_filter", params.name);
    }
    if (params.description) {
      url.searchParams.set("description_filter", params.description);
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForInventorySummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-pos
   */
  async getPointOfSaleInventory(token) {
    const url = new URL(`private/pos`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMerchantPosProductDetail());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async getProductDetails(token, productId) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForProductDetail());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-products-$PRODUCT_ID-lock
   */
  async lockProduct(token, productId, body) {
    const url = new URL(`private/products/${productId}/lock`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async deleteProduct(token, productId) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Payment processing
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-orders
   */
  async createOrder(token, body) {
    const url = new URL(`private/orders`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    return this.procesOrderCreationResponse(resp);
  }
  async procesOrderCreationResponse(resp) {
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_ORDER);
        return opSuccessFromHttp(resp, codecForPostOrderResponse());
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForOutOfStockResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#inspecting-orders
   */
  async listOrders(token, params = {}) {
    const url = new URL(`private/orders`, this.baseUrl);
    if (params.paid !== void 0) {
      url.searchParams.set("paid", params.paid ? "YES" : "NO");
    }
    if (params.refunded !== void 0) {
      url.searchParams.set("refunded", params.refunded ? "YES" : "NO");
    }
    if (params.wired !== void 0) {
      url.searchParams.set("wired", params.wired ? "YES" : "NO");
    }
    if (params.date && !AbsoluteTime.isNever(params.date)) {
      const time = AbsoluteTime.toProtocolTimestamp(params.date);
      url.searchParams.set("date_s", String(time.t_s));
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    if (params.sessionId) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.fulfillmentUrl) {
      url.searchParams.set("fulfillment_url", params.fulfillmentUrl);
    }
    if (params.summary) {
      url.searchParams.set("summary_filter", params.summary);
    }
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOrderHistory());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-orders-$ORDER_ID
   */
  async getOrderDetails(token, orderId, params = {}) {
    const url = new URL(`private/orders/${orderId}`, this.baseUrl);
    if (params.allowRefundedForRepurchase !== void 0) {
      url.searchParams.set("allow_refunded_for_repurchase", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.sessionId) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMerchantOrderPrivateStatusResponse());
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_GENERIC_ORDER_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.MERCHANT_GENERIC_INSTANCE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#private-order-data-cleanup
   */
  async forgetOrder(token, orderId, body) {
    const url = new URL(`private/orders/${orderId}/forget`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opEmptySuccess();
      }
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-orders-$ORDER_ID
   */
  async deleteOrder(token, orderId, force = false) {
    const url = new URL(`private/orders/${orderId}`, this.baseUrl);
    if (force) {
      url.searchParams.set("force", "yes");
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_ORDER);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Refunds
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-orders-$ORDER_ID-refund
   */
  async addRefund(token, orderId, body) {
    const url = new URL(`private/orders/${orderId}/refund`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForMerchantRefundResponse());
      }
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Wire Transfer
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-transfers
   */
  async informWireTransfer(token, body) {
    const url = new URL(`private/transfers`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TRANSFER);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-transfers
   */
  async listConfirmedWireTransfers(token, params = {}) {
    const url = new URL(`private/transfers`, this.baseUrl);
    if (params.paytoURI) {
      url.searchParams.set("payto_uri", params.paytoURI);
    }
    if (params.before) {
      url.searchParams.set("before", String(params.before));
    }
    if (params.after) {
      url.searchParams.set("after", String(params.after));
    }
    if (params.expected !== void 0) {
      url.searchParams.set("expected", params.expected ? "YES" : "NO");
    }
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTansferList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-incoming
   */
  async listIncomingWireTransfers(token, params = {}) {
    const url = new URL(`private/incoming`, this.baseUrl);
    if (params.paytoURI) {
      url.searchParams.set("payto_uri", params.paytoURI);
    }
    if (params.before) {
      url.searchParams.set("before", String(params.before));
    }
    if (params.after) {
      url.searchParams.set("after", String(params.after));
    }
    if (params.verified !== void 0) {
      url.searchParams.set("verified", params.verified ? "YES" : "NO");
    }
    if (params.confirmed !== void 0) {
      url.searchParams.set("verified", params.confirmed ? "YES" : "NO");
    }
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIncomingTansferList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // /**
  //  * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-transfers-$TID
  //  * @deprecated
  //  */
  // async deleteWireTransfer(token: AccessToken | undefined, transferId: string) {
  //   const url = new URL(`private/transfers/${transferId}`, this.baseUrl);
  //   const headers: Record<string, string> = {};
  //   if (token) {
  //     headers.Authorization = makeBearerTokenAuthHeader(token);
  //   }
  //   const resp = await this.httpLib.fetch(url.href, {
  //     method: "DELETE",
  //     headers,
  //   });
  //   switch (resp.status) {
  //     case HttpStatusCode.NoContent: {
  //       this.cacheEvictor.notifySuccess(
  //         TalerMerchantInstanceCacheEviction.DELETE_TRANSFER,
  //       );
  //       return opEmptySuccess();
  //     }
  //     case HttpStatusCode.Unauthorized: // FIXME: missing in docs
  //       return opKnownHttpFailure(resp.status, resp);
  //     case HttpStatusCode.NotFound:
  //       return opKnownHttpFailure(resp.status, resp);
  //     case HttpStatusCode.Conflict:
  //       return opKnownHttpFailure(resp.status, resp);
  //     default:
  //       return opUnknownHttpFailure(resp);
  //   }
  // }
  //
  // OTP Devices
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-otp-devices
   */
  async addOtpDevice(token, body) {
    const url = new URL(`private/otp-devices`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async updateOtpDevice(token, deviceId, body) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-otp-devices
   */
  async listOtpDevices(token, params) {
    const url = new URL(`private/otp-devices`, this.baseUrl);
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOtpDeviceSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async getOtpDeviceDetails(token, deviceId, params = {}) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    if (params.faketime) {
      url.searchParams.set("faketime", String(params.faketime));
    }
    if (params.price) {
      url.searchParams.set("price", params.price);
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOtpDeviceDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async deleteOtpDevice(token, deviceId) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Templates
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-templates
   */
  async addTemplate(token, body) {
    const url = new URL(`private/templates`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async updateTemplate(token, templateId, body) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#inspecting-template
   */
  async listTemplates(token, params) {
    const url = new URL(`private/templates`, this.baseUrl);
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTemplateSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async getTemplateDetails(token, templateId) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTemplateDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async deleteTemplate(token, templateId) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-templates-$TEMPLATE_ID
   */
  async useTemplateGetInfo(templateId) {
    const url = new URL(`templates/${templateId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWalletTemplateDetails());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-templates-$TEMPLATE_ID
   */
  async useTemplateCreateOrder(templateId, body) {
    const url = new URL(`templates/${templateId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    return this.procesOrderCreationResponse(resp);
  }
  //
  // Webhooks
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-private-webhooks
   */
  async addWebhook(token, body) {
    const url = new URL(`private/webhooks`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async updateWebhook(token, webhookId, body) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-webhooks
   */
  async listWebhooks(token, params) {
    const url = new URL(`private/webhooks`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWebhookSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async getWebhookDetails(token, webhookId) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWebhookDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async deleteWebhook(token, webhookId) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // token families
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-private-tokenfamilies
   */
  async createTokenFamily(token, body) {
    const url = new URL(`private/tokenfamilies`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async updateTokenFamily(token, tokenSlug, body) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TOKENFAMILY);
        return opSuccessFromHttp(resp, codecForTokenFamilyDetails());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-tokenfamilies
   */
  async listTokenFamilies(token, params) {
    const url = new URL(`private/tokenfamilies`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenFamiliesList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async getTokenFamilyDetails(token, tokenSlug) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenFamilyDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async deleteTokenFamily(token, tokenSlug) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID
   *
   */
  async sendChallenge(cid) {
    const url = new URL(`challenge/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      // FIXME: this should be removed
      body: {}
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeRequestResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({});
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Gone: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_SOLVED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_TOO_EARLY:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.BadGateway: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_MFA_HELPER_EXEC_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID-confirm
   *
   */
  async confirmChallenge(cid, body) {
    const url = new URL(`challenge/${cid}/confirm`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_TOO_MANY_ATTEMPTS:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post--instances-$INSTANCE-forgot-password
   */
  async forgotPasswordSelfProvision(body, params = {}) {
    const url = new URL(`forgot-password`, this.baseUrl);
    const headers = {};
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async postDonau(args) {
    const headers = {};
    if (args.token) {
      headers.Authorization = makeBearerTokenAuthHeader(args.token);
    }
    const url = new URL(`private/donau`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
      case HttpStatusCode.Created:
      case HttpStatusCode.Ok: {
        return opEmptySuccess();
      }
      case HttpStatusCode.BadGateway:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Get the auth api against the current instance
   *
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-token
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-token
   */
  getAuthenticationAPI() {
    return new URL(`private/`, this.baseUrl);
  }
};
TalerMerchantInstanceHttpClient.PROTOCOL_VERSION = "24:0:1";

// ../taler-util/lib/http-client/mailbox.js
var TalerMailboxInstanceHttpClient = class _TalerMailboxInstanceHttpClient {
  constructor(baseUrl, httpClient, cancellationToken) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cancellationToken = cancellationToken;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerMailboxInstanceHttpClient.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#get--config
   */
  async getConfig() {
    const url = new URL(`/config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-mailbox", _TalerMailboxInstanceHttpClient.PROTOCOL_VERSION, resp, codecForTalerMailboxConfigResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#post--$H_MAILBOX
   */
  async sendMessage(args) {
    const { h_address: hAddress, body } = args;
    const url = new URL(`${hAddress.toUpperCase()}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        return opEmptySuccess();
      }
      case HttpStatusCode.PaymentRequired: {
        return opKnownHttpFailure(resp.status, resp);
      }
      case HttpStatusCode.Forbidden: {
        return opKnownHttpFailure(resp.status, resp);
      }
      case HttpStatusCode.TooManyRequests: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForTalerMailboxRateLimitedResponse());
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#get--$H_MAILBOX
   */
  async getMessages(args) {
    const { hMailbox } = args;
    const url = new URL(`${hMailbox.toUpperCase()}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        const uintar = await resp.bytes();
        const etag = resp.headers.get("etag");
        const index = etag ? etag : "0";
        return opFixedSuccess({ messages: uintar, etag: index });
      }
      case HttpStatusCode.NoContent: {
        return opEmptySuccess();
      }
      case HttpStatusCode.TooManyRequests: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForTalerMailboxRateLimitedResponse());
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#delete--$ADDRESS
   */
  async deleteMessages(args) {
    const { mailboxConf, matchIf: etag, count, signature } = args;
    const mailboxPubkeyString = encodeCrock(eddsaGetPublic(decodeCrock(mailboxConf.privateKey)));
    const url = new URL(`${mailboxPubkeyString.toUpperCase()}?count=${count}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        "If-Match": etag,
        "Taler-Mailbox-Delete-Signature": signature
      },
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#get--info-$H_MAILBOX
   */
  async getMailboxInfo(hMailbox) {
    const url = new URL(`info/${hMailbox.toUpperCase()}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        return opSuccessFromHttp(resp, codecForTalerMailboxMetadata());
      }
      case HttpStatusCode.NotFound: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForEmptyObject());
      }
      case HttpStatusCode.TooManyRequests: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForTalerMailboxRateLimitedResponse());
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-mailbox.html#post--register
   */
  async registerMailbox(req) {
    const url = new URL(`register`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body: req,
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        return opFixedSuccess({ status: "ok" });
      }
      case HttpStatusCode.Forbidden: {
        return opKnownHttpFailure(resp.status, resp);
      }
      case HttpStatusCode.PaymentRequired: {
        return { type: "fail", case: resp.status, body: { status: "payment-required", talerUri: resp.headers.get("Taler") } };
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerMailboxInstanceHttpClient.PROTOCOL_VERSION = "1:0:0";

// ../taler-util/lib/http-client/officer-account.js
async function createNewWalletKycAccount(extraNonce, password) {
  const { eddsaPriv, eddsaPub } = createEddsaKeyPair();
  const mergedRnd = extraNonce && password ? kdf(24, stringToBytes("aml-officer"), extraNonce, getRandomBytes(24)) : getRandomBytes(24);
  const protectedPrivKey = password ? await encryptWithDerivedKey(mergedRnd, stringToBytes(password), eddsaPriv, password) : void 0;
  const signingKey = eddsaPriv;
  const accountId = encodeCrock(eddsaPub);
  const safe = protectedPrivKey ? encodeCrock(protectedPrivKey) : void 0;
  return { id: accountId, signingKey, safe };
}

// ../taler-util/lib/i18n.js
var jedLib = __toESM(require_jed(), 1);
var logger7 = new Logger("i18n/index.ts");
var jed = void 0;
function setupI18n(lang, strings2) {
  lang = lang.replace("_", "-");
  if (!strings2[lang]) {
    strings2[lang] = {};
  }
  jed = new jedLib.Jed(strings2[lang]);
}
function toI18nString(stringSeq) {
  let s4 = "";
  for (let i4 = 0; i4 < stringSeq.length; i4++) {
    s4 += stringSeq[i4];
    if (i4 < stringSeq.length - 1) {
      s4 += `%${i4 + 1}$s`;
    }
  }
  return s4;
}
function singular(stringSeq, ...values) {
  const s4 = toI18nString(stringSeq);
  if (!s4)
    return "";
  const tr = jed.translate(s4).ifPlural(1, s4).fetch(...values);
  return tr;
}
function withContext(ctx) {
  return function(t4, ...v3) {
    const s4 = toI18nString(t4);
    const tr = jed.translate(s4).withContext(ctx).ifPlural(1, s4).fetch(...v3);
    return tr;
  };
}
function translate(stringSeq, ...values) {
  const s4 = toI18nString(stringSeq);
  if (!s4)
    return [];
  const translation = jed.ngettext(s4, s4, 1);
  return replacePlaceholderWithValues(translation, values);
}
function Translate({ children, debug, context: ctx }) {
  const c4 = [].concat(children);
  const s4 = stringifyArray(c4);
  if (!s4)
    return [];
  const translation = ctx ? jed.npgettext(ctx, s4, s4, 1) : jed.ngettext(s4, s4, 1);
  if (debug) {
    console.log("looking for ", s4, "got", translation);
  }
  return replacePlaceholderWithValues(translation, c4);
}
function replacePlaceholderWithValues(translation, childArray) {
  const tr = translation.split(/%(\d+)\$s/);
  const placeholderChildren = [];
  for (let i4 = 0; i4 < childArray.length; i4++) {
    const x5 = childArray[i4];
    if (x5 === void 0) {
      continue;
    } else if (typeof x5 === "string") {
      continue;
    } else {
      placeholderChildren.push(x5);
    }
  }
  const result = [];
  for (let i4 = 0; i4 < tr.length; i4++) {
    if (i4 % 2 == 0) {
      result.push(tr[i4]);
    } else {
      const childIdx = Number.parseInt(tr[i4]) - 1;
      result.push(placeholderChildren[childIdx]);
    }
  }
  return result;
}
function stringifyArray(children) {
  let n2 = 1;
  const ss = children.map((c4) => {
    if (typeof c4 === "string") {
      return c4;
    }
    return `%${n2++}$s`;
  });
  const s4 = ss.join("").replace(/ +/g, " ").trim();
  return s4;
}
var i18n = {
  str: singular,
  ctx: withContext,
  singular,
  Translate,
  translate
};

// ../taler-util/lib/promises.js
function openPromise() {
  let resolve = null;
  let promiseReject = null;
  const promise = new Promise((res, rej) => {
    resolve = res;
    promiseReject = rej;
  });
  if (!(resolve && promiseReject)) {
    throw Error("JS implementation is broken");
  }
  const result = { resolve, reject: promiseReject, promise };
  function saveLastError(reason) {
    result.lastError = reason;
    promiseReject(reason);
  }
  result.reject = saveLastError;
  return result;
}

// ../taler-util/lib/longpool-queue.js
var logger8 = new Logger("longpoll-queue.ts");
var PERMITS = 20;
var LongpollQueue = class {
  constructor() {
    this.idCounter = 0;
    this.queue = [];
    this.permits = PERMITS;
  }
  async run(url, cancellationToken, f3) {
    const hostname = url.hostname;
    const rid = this.idCounter++;
    const triggerNextLongpoll = () => {
      logger8.trace(`cleaning up after long-poll ${rid} to ${hostname}`);
      const next = this.queue.shift();
      if (next != null) {
        next();
      } else {
        this.permits++;
      }
    };
    const doRunLongpoll = async () => {
      const numWaiting = this.queue.length;
      const numConcurrent = PERMITS - this.permits;
      logger8.info(`running long-poll ${rid} to ${hostname} with ${numWaiting} waiting and ${numConcurrent} running`);
      try {
        const timeoutMs = Math.round(Math.max(1e4, 3e4 / (numWaiting + 1)));
        return await f3(timeoutMs);
      } finally {
        triggerNextLongpoll();
      }
    };
    if (this.permits > 0) {
      this.permits--;
      return doRunLongpoll();
    } else {
      logger8.info(`long-poll ${rid} to ${hostname} queued`);
      const promcap = openPromise();
      this.queue.push(promcap.resolve);
      try {
        await cancellationToken.racePromise(promcap.promise);
      } finally {
        logger8.info(`long-poll ${rid} to ${hostname} cancelled while queued`);
        triggerNextLongpoll();
      }
      return doRunLongpoll();
    }
  }
};

// ../taler-util/lib/notifications.js
var NotificationType;
(function(NotificationType2) {
  NotificationType2["BalanceChange"] = "balance-change";
  NotificationType2["BankAccountChange"] = "bank-account-change";
  NotificationType2["BackupOperationError"] = "backup-error";
  NotificationType2["ContactAdded"] = "contact-added";
  NotificationType2["ContactDeleted"] = "contact-deleted";
  NotificationType2["MailboxMessageAdded"] = "mailbox-message-added";
  NotificationType2["MailboxMessageDeleted"] = "mailbox-message-deleted";
  NotificationType2["TransactionStateTransition"] = "transaction-state-transition";
  NotificationType2["ExchangeStateTransition"] = "exchange-state-transition";
  NotificationType2["Idle"] = "idle";
  NotificationType2["TaskObservabilityEvent"] = "task-observability-event";
  NotificationType2["RequestObservabilityEvent"] = "request-observability-event";
})(NotificationType || (NotificationType = {}));
var ObservabilityEventType;
(function(ObservabilityEventType2) {
  ObservabilityEventType2["HttpFetchStart"] = "http-fetch-start";
  ObservabilityEventType2["HttpFetchFinishError"] = "http-fetch-finish-error";
  ObservabilityEventType2["HttpFetchFinishSuccess"] = "http-fetch-finish-success";
  ObservabilityEventType2["DbQueryStart"] = "db-query-start";
  ObservabilityEventType2["DbQueryFinishSuccess"] = "db-query-finish-success";
  ObservabilityEventType2["DbQueryFinishError"] = "db-query-finish-error";
  ObservabilityEventType2["RequestStart"] = "request-start";
  ObservabilityEventType2["RequestFinishSuccess"] = "request-finish-success";
  ObservabilityEventType2["RequestFinishError"] = "request-finish-error";
  ObservabilityEventType2["TaskStart"] = "task-start";
  ObservabilityEventType2["TaskStop"] = "task-stop";
  ObservabilityEventType2["TaskReset"] = "task-reset";
  ObservabilityEventType2["ShepherdTaskResult"] = "shepherd-task-result";
  ObservabilityEventType2["DeclareTaskDependency"] = "declare-task-dependency";
  ObservabilityEventType2["CryptoStart"] = "crypto-start";
  ObservabilityEventType2["CryptoFinishSuccess"] = "crypto-finish-success";
  ObservabilityEventType2["CryptoFinishError"] = "crypto-finish-error";
  ObservabilityEventType2["Message"] = "message";
  ObservabilityEventType2["DeclareConcernsTransaction"] = "declare-concerns-transaction";
})(ObservabilityEventType || (ObservabilityEventType = {}));

// ../taler-util/lib/observability.js
var seqId = 1e3;
var ObservableHttpClientLibrary = class {
  constructor(impl, oc) {
    this.impl = impl;
    this.oc = oc;
    this.cancelatorById = /* @__PURE__ */ new Map();
  }
  cancelRequest(id) {
    const cancelator = this.cancelatorById.get(id);
    if (!cancelator)
      return;
    cancelator.cancel();
  }
  async fetch(url, opt) {
    const id = `req-${seqId}`;
    seqId = seqId + 1;
    const cancelator = CancellationToken.create();
    if (opt?.cancellationToken) {
      opt.cancellationToken.onCancelled(cancelator.cancel);
    }
    this.cancelatorById.set(id, cancelator);
    this.oc.observe({
      id,
      when: AbsoluteTime.now(),
      type: ObservabilityEventType.HttpFetchStart,
      url
    });
    const optsWithCancel = opt ?? {};
    optsWithCancel.cancellationToken = cancelator.token;
    try {
      const res = await this.impl.fetch(url, optsWithCancel);
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishSuccess,
        url,
        status: res.status
      });
      return res;
    } catch (e4) {
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishError,
        url,
        error: getErrorDetailFromException(e4)
      });
      throw e4;
    } finally {
      this.cancelatorById.delete(id);
    }
  }
};

// ../taler-util/lib/RequestThrottler.js
var logger9 = new Logger("RequestThrottler.ts");
var MAX_PER_SECOND = 100;
var MAX_PER_MINUTE = 500;
var MAX_PER_HOUR = 2e3;
var OriginState = class {
  constructor() {
    this.tokensSecond = MAX_PER_SECOND;
    this.tokensMinute = MAX_PER_MINUTE;
    this.tokensHour = MAX_PER_HOUR;
    this.lastUpdate = AbsoluteTime.now();
  }
  refill() {
    const now = AbsoluteTime.now();
    if (AbsoluteTime.cmp(now, this.lastUpdate) < 0) {
      this.lastUpdate = now;
      return;
    }
    const d4 = AbsoluteTime.difference(now, this.lastUpdate);
    if (d4.d_ms === "forever") {
      throw Error("assertion failed");
    }
    if (d4.d_ms < 1e3 / MAX_PER_SECOND) {
      return;
    }
    this.tokensSecond = Math.min(MAX_PER_SECOND, this.tokensSecond + d4.d_ms / 1e3 * MAX_PER_SECOND);
    this.tokensMinute = Math.min(MAX_PER_MINUTE, this.tokensMinute + d4.d_ms / 1e3 / 60 * MAX_PER_MINUTE);
    this.tokensHour = Math.min(MAX_PER_HOUR, this.tokensHour + d4.d_ms / 1e3 / 60 / 60 * MAX_PER_HOUR);
    this.lastUpdate = now;
  }
  /**
   * Return true if the request for this origin should be throttled.
   * Otherwise, take a token out of the respective buckets.
   */
  applyThrottle() {
    this.refill();
    if (this.tokensSecond < 1) {
      logger9.warn("request throttled (per second limit exceeded)");
      return true;
    }
    if (this.tokensMinute < 1) {
      logger9.warn("request throttled (per minute limit exceeded)");
      return true;
    }
    if (this.tokensHour < 1) {
      logger9.warn("request throttled (per hour limit exceeded)");
      return true;
    }
    this.tokensSecond--;
    this.tokensMinute--;
    this.tokensHour--;
    return false;
  }
};
var RequestThrottler = class {
  constructor() {
    this.perOriginInfo = {};
  }
  /**
   * Get the throttling state for an origin, or
   * initialize if no state is associated with the
   * origin yet.
   */
  getState(origin) {
    const s4 = this.perOriginInfo[origin];
    if (s4) {
      return s4;
    }
    const ns = this.perOriginInfo[origin] = new OriginState();
    return ns;
  }
  /**
   * Apply throttling to a request.
   *
   * @returns whether the request should be throttled.
   */
  applyThrottle(requestUrl) {
    const origin = new URL(requestUrl).origin;
    return this.getState(origin).applyThrottle();
  }
  /**
   * Get the throttle statistics for a particular URL.
   */
  getThrottleStats(requestUrl) {
    const origin = new URL(requestUrl).origin;
    const state = this.getState(origin);
    return {
      tokensHour: state.tokensHour,
      tokensMinute: state.tokensMinute,
      tokensSecond: state.tokensSecond,
      maxTokensHour: MAX_PER_HOUR,
      maxTokensMinute: MAX_PER_MINUTE,
      maxTokensSecond: MAX_PER_SECOND
    };
  }
};

// ../taler-util/lib/ReserveTransaction.js
var ReserveTransactionType;
(function(ReserveTransactionType2) {
  ReserveTransactionType2["Withdraw"] = "WITHDRAW";
  ReserveTransactionType2["Credit"] = "CREDIT";
  ReserveTransactionType2["Recoup"] = "RECOUP";
  ReserveTransactionType2["Closing"] = "CLOSING";
})(ReserveTransactionType || (ReserveTransactionType = {}));

// ../taler-util/lib/TaskThrottler.js
var logger10 = new Logger("OperationThrottler.ts");

// ../taler-util/lib/timer.js
var logger11 = new Logger("timer.ts");
var IntervalHandle = class {
  constructor(h3) {
    this.h = h3;
  }
  clear() {
    clearInterval(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var TimeoutHandle = class {
  constructor(h3) {
    this.h = h3;
  }
  clear() {
    clearTimeout(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var performanceNow = (() => {
  if (typeof process !== "undefined" && process.hrtime) {
    return () => {
      return process.hrtime.bigint();
    };
  }
  if (typeof performance !== "undefined") {
    return () => BigInt(Math.floor(performance.now() * 1e3)) * BigInt(1e3);
  }
  return () => BigInt((/* @__PURE__ */ new Date()).getTime()) * BigInt(1e3) * BigInt(1e3);
})();
var SetTimeoutTimerAPI = class {
  /**
   * Call a function every time the delay given in milliseconds passes.
   */
  every(delayMs2, callback) {
    return new IntervalHandle(setInterval(callback, delayMs2));
  }
  /**
   * Call a function after the delay given in milliseconds passes.
   */
  after(delayMs2, callback) {
    return new TimeoutHandle(setTimeout(callback, delayMs2));
  }
};
var timer = new SetTimeoutTimerAPI();

// ../taler-util/lib/types-taler-wallet-transactions.js
var TransactionMajorState;
(function(TransactionMajorState2) {
  TransactionMajorState2["None"] = "none";
  TransactionMajorState2["Pending"] = "pending";
  TransactionMajorState2["Done"] = "done";
  TransactionMajorState2["Aborting"] = "aborting";
  TransactionMajorState2["Aborted"] = "aborted";
  TransactionMajorState2["Dialog"] = "dialog";
  TransactionMajorState2["Finalizing"] = "finalizing";
  TransactionMajorState2["Suspended"] = "suspended";
  TransactionMajorState2["SuspendedFinalizing"] = "suspended-finalizing";
  TransactionMajorState2["SuspendedAborting"] = "suspended-aborting";
  TransactionMajorState2["Failed"] = "failed";
  TransactionMajorState2["Expired"] = "expired";
  TransactionMajorState2["Deleted"] = "deleted";
})(TransactionMajorState || (TransactionMajorState = {}));
var TransactionMinorState;
(function(TransactionMinorState2) {
  TransactionMinorState2["Unknown"] = "unknown";
  TransactionMinorState2["Deposit"] = "deposit";
  TransactionMinorState2["KycRequired"] = "kyc";
  TransactionMinorState2["KycInit"] = "kyc-init";
  TransactionMinorState2["MergeKycRequired"] = "merge-kyc";
  TransactionMinorState2["BalanceKycRequired"] = "balance-kyc";
  TransactionMinorState2["BalanceKycInit"] = "balance-kyc-init";
  TransactionMinorState2["KycAuthRequired"] = "kyc-auth";
  TransactionMinorState2["Track"] = "track";
  TransactionMinorState2["SubmitPayment"] = "submit-payment";
  TransactionMinorState2["RebindSession"] = "rebind-session";
  TransactionMinorState2["Refresh"] = "refresh";
  TransactionMinorState2["Pickup"] = "pickup";
  TransactionMinorState2["AutoRefund"] = "auto-refund";
  TransactionMinorState2["User"] = "user";
  TransactionMinorState2["Bank"] = "bank";
  TransactionMinorState2["Exchange"] = "exchange";
  TransactionMinorState2["ClaimProposal"] = "claim-proposal";
  TransactionMinorState2["CheckRefund"] = "check-refund";
  TransactionMinorState2["CreatePurse"] = "create-purse";
  TransactionMinorState2["DeletePurse"] = "delete-purse";
  TransactionMinorState2["RefreshExpired"] = "refresh-expired";
  TransactionMinorState2["Ready"] = "ready";
  TransactionMinorState2["Merge"] = "merge";
  TransactionMinorState2["Repurchase"] = "repurchase";
  TransactionMinorState2["BankRegisterReserve"] = "bank-register-reserve";
  TransactionMinorState2["BankConfirmTransfer"] = "bank-confirm-transfer";
  TransactionMinorState2["WithdrawCoins"] = "withdraw-coins";
  TransactionMinorState2["ExchangeWaitReserve"] = "exchange-wait-reserve";
  TransactionMinorState2["AbortingBank"] = "aborting-bank";
  TransactionMinorState2["Aborting"] = "aborting";
  TransactionMinorState2["Refused"] = "refused";
  TransactionMinorState2["Withdraw"] = "withdraw";
  TransactionMinorState2["MerchantOrderProposed"] = "merchant-order-proposed";
  TransactionMinorState2["Proposed"] = "proposed";
  TransactionMinorState2["RefundAvailable"] = "refund-available";
  TransactionMinorState2["AcceptRefund"] = "accept-refund";
  TransactionMinorState2["PaidByOther"] = "paid-by-other";
  TransactionMinorState2["CompletedByOtherWallet"] = "completed-by-other-wallet";
})(TransactionMinorState || (TransactionMinorState = {}));
var TransactionAction;
(function(TransactionAction2) {
  TransactionAction2["Delete"] = "delete";
  TransactionAction2["Suspend"] = "suspend";
  TransactionAction2["Resume"] = "resume";
  TransactionAction2["Abort"] = "abort";
  TransactionAction2["Fail"] = "fail";
  TransactionAction2["Retry"] = "retry";
})(TransactionAction || (TransactionAction = {}));
var TransactionType;
(function(TransactionType2) {
  TransactionType2["Withdrawal"] = "withdrawal";
  TransactionType2["InternalWithdrawal"] = "internal-withdrawal";
  TransactionType2["Payment"] = "payment";
  TransactionType2["Refund"] = "refund";
  TransactionType2["Refresh"] = "refresh";
  TransactionType2["Deposit"] = "deposit";
  TransactionType2["PeerPushDebit"] = "peer-push-debit";
  TransactionType2["PeerPushCredit"] = "peer-push-credit";
  TransactionType2["PeerPullDebit"] = "peer-pull-debit";
  TransactionType2["PeerPullCredit"] = "peer-pull-credit";
  TransactionType2["Recoup"] = "recoup";
  TransactionType2["DenomLoss"] = "denom-loss";
})(TransactionType || (TransactionType = {}));
var WithdrawalType;
(function(WithdrawalType2) {
  WithdrawalType2["TalerBankIntegrationApi"] = "taler-bank-integration-api";
  WithdrawalType2["ManualTransfer"] = "manual-transfer";
})(WithdrawalType || (WithdrawalType = {}));
var DenomLossEventType;
(function(DenomLossEventType2) {
  DenomLossEventType2["DenomExpired"] = "denom-expired";
  DenomLossEventType2["DenomVanished"] = "denom-vanished";
  DenomLossEventType2["DenomUnoffered"] = "denom-unoffered";
})(DenomLossEventType || (DenomLossEventType = {}));
var PaymentStatus;
(function(PaymentStatus2) {
  PaymentStatus2["Aborted"] = "aborted";
  PaymentStatus2["Failed"] = "failed";
  PaymentStatus2["Paid"] = "paid";
  PaymentStatus2["Accepted"] = "accepted";
})(PaymentStatus || (PaymentStatus = {}));

// ../taler-util/lib/transaction-test-data.js
var sampleWalletCoreTransactions = [
  {
    type: TransactionType.Payment,
    txState: {
      major: TransactionMajorState.Done
    },
    amountRaw: "KUDOS:10",
    amountEffective: "KUDOS:10",
    totalRefundRaw: "KUDOS:0",
    totalRefundEffective: "KUDOS:0",
    status: PaymentStatus.Paid,
    refundPending: void 0,
    posConfirmation: void 0,
    pending: false,
    refunds: [],
    timestamp: {
      t_s: 1677166045
    },
    transactionId: "txn:payment:NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    proposalId: "NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    info: {
      merchant: {
        name: "woocommerce",
        website: "woocommerce.demo.taler.net",
        email: "foo@example.com",
        address: {},
        jurisdiction: {}
      },
      orderId: "wc_order_KQCRldghIgDRB-100",
      products: [
        {
          description: "Using GCC",
          quantity: 1,
          price: "KUDOS:10",
          product_id: "28"
        }
      ],
      summary: "WooTalerShop #100",
      contractTermsHash: "A02E1M6ARWKBJ87K2TV4S6WQ4X5YH7BRVR6MYCHCTVAED8MBXTFD6PZ5Q50Y7Z5K18PYBTDA14NQ56XPC1VCQW1EVRWTSB7ZYT65B5G",
      fulfillmentUrl: "https://woocommerce.demo.taler.net/?wc-api=wc_gnutaler_gateway&order_id=wc_order_KQCRldghIgDRB-100"
    },
    refundQueryActive: false,
    frozen: false
  },
  {
    type: TransactionType.Refresh,
    txState: {
      major: TransactionMajorState.Pending
    },
    refreshReason: RefreshReason.PayMerchant,
    amountEffective: "KUDOS:0",
    amountRaw: "KUDOS:0",
    refreshInputAmount: "KUDOS:1.5",
    refreshOutputAmount: "KUDOS:1.4",
    originatingTransactionId: "txn:proposal:ZCGBZFE8KZ1CBYYGSC3ZC8E40KVJWV16VYCTHGC8FFSVZ5HD24BG",
    pending: true,
    timestamp: {
      t_s: 1681376214
    },
    transactionId: "txn:refresh:QQSWHHXCRQ269G0E3RW14JMC6F7NFDYDW26NSFHRTXSKDS6CMCZ0",
    frozen: false,
    error: {
      code: 7029,
      when: {
        t_ms: 1681376473665
      },
      hint: "Error (WALLET_REFRESH_GROUP_INCOMPLETE)",
      numErrors: 1,
      errors: [
        {
          code: 7001,
          when: {
            t_ms: 1681376473189
          },
          hint: "unexpected exception (message: exchange wire fee signature invalid)",
          stack: "    at validateWireInfo (../taler-wallet-core-qjs.mjs:23166)\n"
        }
      ]
    }
  }
];

// ../taler-util/lib/types-taler-mailbox.js
var codecForTalerMailboxConfigResponse = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("taler-mailbox")).property("monthly_fee", codecForAmountString()).property("registration_update_fee", codecForAmountString()).property("message_body_bytes", codecForNumber()).property("message_response_limit", codecForNumber()).property("delivery_period", codecForDuration).build("TalerMailboxApi.VersionResponse");
var codecForTalerMailboxMetadata = () => buildCodecForObject().property("signing_key", codecForEddsaPublicKey()).property("signing_key_type", codecForConstString("EdDSA")).property("encryption_key", codecForString()).property("encryption_key_type", codecForConstString("X25519")).property("expiration", codecForTimestamp).build("TalerMailboxApi.MailboxMessageKeys");
var codecForTalerMailboxRateLimitedResponse = () => buildCodecForObject().property("code", codecForNumber()).property("retry_delay", codecForDuration).property("hint", codecForString()).build("TalerMailboxApi.MailboxRateLimitedResponse");

// ../taler-util/lib/taler-signatures.js
function signAmlDecision(priv, decision) {
  const builder = buildSigPS(TalerSignaturePurpose.AML_DECISION);
  const flags = decision.keep_investigating ? 1 : 0;
  builder.put(timestampRoundedToBuffer(decision.decision_time));
  builder.put(timestampRoundedToBuffer(decision.attributes_expiration ?? TalerProtocolTimestamp.fromSeconds(0)));
  builder.put(decodeCrock(decision.h_payto));
  builder.put(hash2(stringToBytes(decision.justification)));
  builder.put(hash2(stringToBytes(canonicalJson(decision.properties) + "\0")));
  builder.put(hash2(stringToBytes(canonicalJson(decision.new_rules) + "\0")));
  if (decision.new_measures != null) {
    builder.put(hash2(stringToBytes(decision.new_measures)));
  } else {
    builder.put(new Uint8Array(64));
  }
  if (decision.attributes != null) {
    builder.put(hash2(stringToBytes(canonicalJson(decision.attributes) + "\0")));
  } else {
    builder.put(new Uint8Array(64));
  }
  builder.put(bufferForUint64(flags));
  const sigBlob = builder.build();
  return eddsaSign(sigBlob, priv);
}
function signAmlQuery(key) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.AML_QUERY).build();
  return eddsaSign(sigBlob, key);
}
function signWalletAccountSetup(key, balance) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.WALLET_ACCOUNT_SETUP).put(bufferFromAmount(balance)).build();
  return eddsaSign(sigBlob, key);
}
function signKycAuth(key) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.KYC_AUTH).build();
  return eddsaSign(sigBlob, key);
}

// ../taler-util/lib/taler-account-properties.js
var TalerAmlProperties = {
  /**
   * Description: Current note on the GWG file.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  FILE_NOTE: "FILE_NOTE",
  /**
   * Description: Customer name or internal alias.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  CUSTOMER_LABEL: "CUSTOMER_LABEL",
  /**
   * Description: Boolean flag indicating whether the account has been opened. The definition of opening an account is deployment-specific.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_OPEN: "ACCOUNT_OPEN",
  /**
   * Description: True if the customer is a domestic PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the customer is a foreign PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the customer is a international organization PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: True if the customer is a  high-risk business.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_CUSTOMER: "HIGH_RISK_CUSTOMER",
  /**
   * Description: True if the customer is associated with a high-risk country.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The account has been marked as idle.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_IDLE: "ACCOUNT_IDLE",
  /**
   * Description: The MROS reporting state for the account.
   *
   * GANA Type: 'NONE' | 'INVESTIGATION_PENDING' | 'INVESTIGATION_COMPLETED_WITHOUT_SUSPICION' | 'REPORTED_SUSPICION_SIMPLE' | 'REPORTED_SUSPICION_SUBSTANTIATED'
   * Deployment: TOPS
   */
  INVESTIGATION_STATE: "INVESTIGATION_STATE",
  /**
   * Description: Informal reason why the AML investigation was triggered. Examples include suspicious transaction or (automated) sanction list match
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  INVESTIGATION_TRIGGER: "INVESTIGATION_TRIGGER",
  /**
   * Description: Identifies the sanction list entry that the account matched against (best match, does not mean it was a good match)
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  SANCTION_LIST_BEST_MATCH: "SANCTION_LIST_BEST_MATCH",
  /**
   * Description: Score for how good the sanction list match was (0: none, 10**9: perfect match)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_RATING: "SANCTION_LIST_RATING",
  /**
   * Description: Score for how much supporting data we had for the sanction list match (0: none, 10**9: all fields available)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_CONFIDENCE: "SANCTION_LIST_CONFIDENCE",
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS"
};

// ../taler-util/lib/aml/properties.js
var TOPS_AccountProperties = [
  TalerAmlProperties.FILE_NOTE,
  TalerAmlProperties.CUSTOMER_LABEL,
  TalerAmlProperties.ACCOUNT_OPEN,
  TalerAmlProperties.PEP_DOMESTIC,
  TalerAmlProperties.PEP_FOREIGN,
  TalerAmlProperties.PEP_INTERNATIONAL_ORGANIZATION,
  TalerAmlProperties.HIGH_RISK_CUSTOMER,
  TalerAmlProperties.HIGH_RISK_COUNTRY,
  TalerAmlProperties.ACCOUNT_IDLE,
  TalerAmlProperties.INVESTIGATION_TRIGGER,
  TalerAmlProperties.INVESTIGATION_STATE,
  TalerAmlProperties.SANCTION_LIST_BEST_MATCH,
  TalerAmlProperties.SANCTION_LIST_RATING,
  TalerAmlProperties.SANCTION_LIST_CONFIDENCE,
  TalerAmlProperties.SANCTION_LIST_SUPPRESS
];
var GLS_AccountProperties = [TalerAmlProperties.FILE_NOTE];
var KnownForms;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms || (KnownForms = {}));

// ../taler-util/lib/aml/events.js
var TOPS_AmlEventsName;
(function(TOPS_AmlEventsName2) {
  TOPS_AmlEventsName2["INCR_ACCOUNT_OPEN"] = "INCR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["DECR_ACCOUNT_OPEN"] = "DECR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_CUSTOMER"] = "INCR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_CUSTOMER"] = "DECR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_COUNTRY"] = "INCR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_COUNTRY"] = "DECR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["INCR_PEP"] = "INCR_PEP";
  TOPS_AmlEventsName2["DECR_PEP"] = "DECR_PEP";
  TOPS_AmlEventsName2["INCR_PEP_FOREIGN"] = "INCR_PEP_FOREIGN";
  TOPS_AmlEventsName2["DECR_PEP_FOREIGN"] = "DECR_PEP_FOREIGN";
  TOPS_AmlEventsName2["INCR_PEP_DOMESTIC"] = "INCR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["DECR_PEP_DOMESTIC"] = "DECR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["INCR_PEP_INTERNATIONAL_ORGANIZATION"] = "INCR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["DECR_PEP_INTERNATIONAL_ORGANIZATION"] = "DECR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SIMPLE"] = "MROS_REPORTED_SUSPICION_SIMPLE";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SUBSTANTIATED"] = "MROS_REPORTED_SUSPICION_SUBSTANTIATED";
  TOPS_AmlEventsName2["INCR_INVESTIGATION_CONCLUDED"] = "INCR_INVESTIGATION_CONCLUDED";
  TOPS_AmlEventsName2["DECR_INVESTIGATION_CONCLUDED"] = "DECR_INVESTIGATION_CONCLUDED";
})(TOPS_AmlEventsName || (TOPS_AmlEventsName = {}));
var GLS_AmlEventsName;
(function(GLS_AmlEventsName2) {
  GLS_AmlEventsName2["ACCOUNT_OPENED"] = "ACCOUNT_OPENED";
  GLS_AmlEventsName2["ACCOUNT_CLOSED"] = "ACCOUNT_CLOSED";
})(GLS_AmlEventsName || (GLS_AmlEventsName = {}));
var KnownForms2;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms2 || (KnownForms2 = {}));

// ../taler-util/lib/iso-3166.js
var countryNamesByCode = {
  [
    "AF"
    /* CountryCode.AF */
  ]: (i18n2) => i18n2.str`Afghanistan`,
  [
    "AL"
    /* CountryCode.AL */
  ]: (i18n2) => i18n2.str`Albania`,
  [
    "DZ"
    /* CountryCode.DZ */
  ]: (i18n2) => i18n2.str`Algeria`,
  [
    "US"
    /* CountryCode.US */
  ]: (i18n2) => i18n2.str`United States`,
  [
    "AD"
    /* CountryCode.AD */
  ]: (i18n2) => i18n2.str`Andorra`,
  [
    "AO"
    /* CountryCode.AO */
  ]: (i18n2) => i18n2.str`Angola`,
  [
    "AG"
    /* CountryCode.AG */
  ]: (i18n2) => i18n2.str`Antigua and Barbuda`,
  [
    "AR"
    /* CountryCode.AR */
  ]: (i18n2) => i18n2.str`Argentina`,
  [
    "AM"
    /* CountryCode.AM */
  ]: (i18n2) => i18n2.str`Armenia`,
  [
    "AU"
    /* CountryCode.AU */
  ]: (i18n2) => i18n2.str`Australia`,
  [
    "AT"
    /* CountryCode.AT */
  ]: (i18n2) => i18n2.str`Austria`,
  [
    "AZ"
    /* CountryCode.AZ */
  ]: (i18n2) => i18n2.str`Azerbaijan`,
  [
    "BS"
    /* CountryCode.BS */
  ]: (i18n2) => i18n2.str`Bahamas`,
  [
    "BH"
    /* CountryCode.BH */
  ]: (i18n2) => i18n2.str`Bahrain`,
  [
    "BD"
    /* CountryCode.BD */
  ]: (i18n2) => i18n2.str`Bangladesh`,
  [
    "BB"
    /* CountryCode.BB */
  ]: (i18n2) => i18n2.str`Barbados`,
  [
    "BW"
    /* CountryCode.BW */
  ]: (i18n2) => i18n2.str`Botswana`,
  [
    "BY"
    /* CountryCode.BY */
  ]: (i18n2) => i18n2.str`Belarus`,
  [
    "BE"
    /* CountryCode.BE */
  ]: (i18n2) => i18n2.str`Belgium`,
  [
    "BZ"
    /* CountryCode.BZ */
  ]: (i18n2) => i18n2.str`Belize`,
  [
    "BJ"
    /* CountryCode.BJ */
  ]: (i18n2) => i18n2.str`Benin`,
  [
    "BT"
    /* CountryCode.BT */
  ]: (i18n2) => i18n2.str`Bhutan`,
  [
    "BO"
    /* CountryCode.BO */
  ]: (i18n2) => i18n2.str`Bolivia`,
  [
    "BA"
    /* CountryCode.BA */
  ]: (i18n2) => i18n2.str`Bosnia and Herzegovina`,
  [
    "BR"
    /* CountryCode.BR */
  ]: (i18n2) => i18n2.str`Brazil`,
  [
    "GB"
    /* CountryCode.GB */
  ]: (i18n2) => i18n2.str`United Kingdom`,
  [
    "BN"
    /* CountryCode.BN */
  ]: (i18n2) => i18n2.str`Brunei`,
  [
    "BG"
    /* CountryCode.BG */
  ]: (i18n2) => i18n2.str`Bulgaria`,
  [
    "BF"
    /* CountryCode.BF */
  ]: (i18n2) => i18n2.str`Burkina Faso`,
  [
    "MM"
    /* CountryCode.MM */
  ]: (i18n2) => i18n2.str`Myanmar`,
  [
    "BI"
    /* CountryCode.BI */
  ]: (i18n2) => i18n2.str`Burundi`,
  [
    "KH"
    /* CountryCode.KH */
  ]: (i18n2) => i18n2.str`Cambodia`,
  [
    "CM"
    /* CountryCode.CM */
  ]: (i18n2) => i18n2.str`Cameroon`,
  [
    "CA"
    /* CountryCode.CA */
  ]: (i18n2) => i18n2.str`Canada`,
  [
    "CV"
    /* CountryCode.CV */
  ]: (i18n2) => i18n2.str`Cape Verde`,
  [
    "CF"
    /* CountryCode.CF */
  ]: (i18n2) => i18n2.str`Central African Republic`,
  [
    "TD"
    /* CountryCode.TD */
  ]: (i18n2) => i18n2.str`Chad`,
  [
    "CL"
    /* CountryCode.CL */
  ]: (i18n2) => i18n2.str`Chile`,
  [
    "CN"
    /* CountryCode.CN */
  ]: (i18n2) => i18n2.str`China`,
  [
    "CO"
    /* CountryCode.CO */
  ]: (i18n2) => i18n2.str`Colombia`,
  [
    "KM"
    /* CountryCode.KM */
  ]: (i18n2) => i18n2.str`Comoros`,
  [
    "CD"
    /* CountryCode.CD */
  ]: (i18n2) => i18n2.str`Democratic Republic of the Congo`,
  [
    "CG"
    /* CountryCode.CG */
  ]: (i18n2) => i18n2.str`Republic of the Congo`,
  [
    "CR"
    /* CountryCode.CR */
  ]: (i18n2) => i18n2.str`Costa Rica`,
  [
    "HR"
    /* CountryCode.HR */
  ]: (i18n2) => i18n2.str`Croatia`,
  [
    "CU"
    /* CountryCode.CU */
  ]: (i18n2) => i18n2.str`Cuba`,
  [
    "CY"
    /* CountryCode.CY */
  ]: (i18n2) => i18n2.str`Cyprus`,
  [
    "CZ"
    /* CountryCode.CZ */
  ]: (i18n2) => i18n2.str`Czech Republic`,
  [
    "DK"
    /* CountryCode.DK */
  ]: (i18n2) => i18n2.str`Denmark`,
  [
    "DJ"
    /* CountryCode.DJ */
  ]: (i18n2) => i18n2.str`Djibouti`,
  [
    "DO"
    /* CountryCode.DO */
  ]: (i18n2) => i18n2.str`Dominican Republic`,
  [
    "NL"
    /* CountryCode.NL */
  ]: (i18n2) => i18n2.str`Netherlands`,
  [
    "TL"
    /* CountryCode.TL */
  ]: (i18n2) => i18n2.str`Timor-Leste`,
  [
    "EC"
    /* CountryCode.EC */
  ]: (i18n2) => i18n2.str`Ecuador`,
  [
    "EG"
    /* CountryCode.EG */
  ]: (i18n2) => i18n2.str`Egypt`,
  [
    "AE"
    /* CountryCode.AE */
  ]: (i18n2) => i18n2.str`United Arab Emirates`,
  [
    "GQ"
    /* CountryCode.GQ */
  ]: (i18n2) => i18n2.str`Equatorial Guinea`,
  [
    "ER"
    /* CountryCode.ER */
  ]: (i18n2) => i18n2.str`Eritrea`,
  [
    "EE"
    /* CountryCode.EE */
  ]: (i18n2) => i18n2.str`Estonia`,
  [
    "ET"
    /* CountryCode.ET */
  ]: (i18n2) => i18n2.str`Ethiopia`,
  [
    "FJ"
    /* CountryCode.FJ */
  ]: (i18n2) => i18n2.str`Fiji`,
  [
    "PH"
    /* CountryCode.PH */
  ]: (i18n2) => i18n2.str`Philippines`,
  [
    "FI"
    /* CountryCode.FI */
  ]: (i18n2) => i18n2.str`Finland`,
  [
    "FR"
    /* CountryCode.FR */
  ]: (i18n2) => i18n2.str`France`,
  [
    "GA"
    /* CountryCode.GA */
  ]: (i18n2) => i18n2.str`Gabon`,
  [
    "GM"
    /* CountryCode.GM */
  ]: (i18n2) => i18n2.str`Gambia`,
  [
    "GE"
    /* CountryCode.GE */
  ]: (i18n2) => i18n2.str`Georgia`,
  [
    "DE"
    /* CountryCode.DE */
  ]: (i18n2) => i18n2.str`Germany`,
  [
    "GH"
    /* CountryCode.GH */
  ]: (i18n2) => i18n2.str`Ghana`,
  [
    "GR"
    /* CountryCode.GR */
  ]: (i18n2) => i18n2.str`Greece`,
  [
    "GD"
    /* CountryCode.GD */
  ]: (i18n2) => i18n2.str`Grenada`,
  [
    "GT"
    /* CountryCode.GT */
  ]: (i18n2) => i18n2.str`Guatemala`,
  [
    "GW"
    /* CountryCode.GW */
  ]: (i18n2) => i18n2.str`Guinea-Bissau`,
  [
    "GN"
    /* CountryCode.GN */
  ]: (i18n2) => i18n2.str`Guinea`,
  [
    "GY"
    /* CountryCode.GY */
  ]: (i18n2) => i18n2.str`Guyana`,
  [
    "HT"
    /* CountryCode.HT */
  ]: (i18n2) => i18n2.str`Haiti`,
  [
    "HN"
    /* CountryCode.HN */
  ]: (i18n2) => i18n2.str`Honduras`,
  [
    "HU"
    /* CountryCode.HU */
  ]: (i18n2) => i18n2.str`Hungary`,
  [
    "KI"
    /* CountryCode.KI */
  ]: (i18n2) => i18n2.str`Kiribati`,
  [
    "IS"
    /* CountryCode.IS */
  ]: (i18n2) => i18n2.str`Iceland`,
  [
    "IN"
    /* CountryCode.IN */
  ]: (i18n2) => i18n2.str`India`,
  [
    "ID"
    /* CountryCode.ID */
  ]: (i18n2) => i18n2.str`Indonesia`,
  [
    "IR"
    /* CountryCode.IR */
  ]: (i18n2) => i18n2.str`Iran`,
  [
    "IQ"
    /* CountryCode.IQ */
  ]: (i18n2) => i18n2.str`Iraq`,
  [
    "IE"
    /* CountryCode.IE */
  ]: (i18n2) => i18n2.str`Ireland`,
  [
    "IL"
    /* CountryCode.IL */
  ]: (i18n2) => i18n2.str`Israel`,
  [
    "IT"
    /* CountryCode.IT */
  ]: (i18n2) => i18n2.str`Italy`,
  [
    "CI"
    /* CountryCode.CI */
  ]: (i18n2) => i18n2.str`Ivory Coast`,
  [
    "JM"
    /* CountryCode.JM */
  ]: (i18n2) => i18n2.str`Jamaica`,
  [
    "JP"
    /* CountryCode.JP */
  ]: (i18n2) => i18n2.str`Japan`,
  [
    "JO"
    /* CountryCode.JO */
  ]: (i18n2) => i18n2.str`Jordan`,
  [
    "KZ"
    /* CountryCode.KZ */
  ]: (i18n2) => i18n2.str`Kazakhstan`,
  [
    "KE"
    /* CountryCode.KE */
  ]: (i18n2) => i18n2.str`Kenya`,
  [
    "KN"
    /* CountryCode.KN */
  ]: (i18n2) => i18n2.str`Saint Kitts and Nevis`,
  [
    "KW"
    /* CountryCode.KW */
  ]: (i18n2) => i18n2.str`Kuwait`,
  [
    "KG"
    /* CountryCode.KG */
  ]: (i18n2) => i18n2.str`Kyrgyzstan`,
  [
    "LA"
    /* CountryCode.LA */
  ]: (i18n2) => i18n2.str`Laos`,
  [
    "LV"
    /* CountryCode.LV */
  ]: (i18n2) => i18n2.str`Latvia`,
  [
    "LB"
    /* CountryCode.LB */
  ]: (i18n2) => i18n2.str`Lebanon`,
  [
    "LR"
    /* CountryCode.LR */
  ]: (i18n2) => i18n2.str`Liberia`,
  [
    "LY"
    /* CountryCode.LY */
  ]: (i18n2) => i18n2.str`Libya`,
  [
    "LI"
    /* CountryCode.LI */
  ]: (i18n2) => i18n2.str`Liechtenstein`,
  [
    "LT"
    /* CountryCode.LT */
  ]: (i18n2) => i18n2.str`Lithuania`,
  [
    "LU"
    /* CountryCode.LU */
  ]: (i18n2) => i18n2.str`Luxembourg`,
  [
    "MK"
    /* CountryCode.MK */
  ]: (i18n2) => i18n2.str`North Macedonia`,
  [
    "MG"
    /* CountryCode.MG */
  ]: (i18n2) => i18n2.str`Madagascar`,
  [
    "MW"
    /* CountryCode.MW */
  ]: (i18n2) => i18n2.str`Malawi`,
  [
    "MY"
    /* CountryCode.MY */
  ]: (i18n2) => i18n2.str`Malaysia`,
  [
    "MV"
    /* CountryCode.MV */
  ]: (i18n2) => i18n2.str`Maldives`,
  [
    "ML"
    /* CountryCode.ML */
  ]: (i18n2) => i18n2.str`Mali`,
  [
    "MT"
    /* CountryCode.MT */
  ]: (i18n2) => i18n2.str`Malta`,
  [
    "MH"
    /* CountryCode.MH */
  ]: (i18n2) => i18n2.str`Marshall Islands`,
  [
    "MR"
    /* CountryCode.MR */
  ]: (i18n2) => i18n2.str`Mauritania`,
  [
    "MU"
    /* CountryCode.MU */
  ]: (i18n2) => i18n2.str`Mauritius`,
  [
    "MX"
    /* CountryCode.MX */
  ]: (i18n2) => i18n2.str`Mexico`,
  [
    "FM"
    /* CountryCode.FM */
  ]: (i18n2) => i18n2.str`Micronesia`,
  [
    "MD"
    /* CountryCode.MD */
  ]: (i18n2) => i18n2.str`Moldova`,
  [
    "MC"
    /* CountryCode.MC */
  ]: (i18n2) => i18n2.str`Monaco`,
  [
    "MN"
    /* CountryCode.MN */
  ]: (i18n2) => i18n2.str`Mongolia`,
  [
    "MA"
    /* CountryCode.MA */
  ]: (i18n2) => i18n2.str`Morocco`,
  [
    "LS"
    /* CountryCode.LS */
  ]: (i18n2) => i18n2.str`Lesotho`,
  [
    "MZ"
    /* CountryCode.MZ */
  ]: (i18n2) => i18n2.str`Mozambique`,
  [
    "NA"
    /* CountryCode.NA */
  ]: (i18n2) => i18n2.str`Namibia`,
  [
    "NR"
    /* CountryCode.NR */
  ]: (i18n2) => i18n2.str`Nauru`,
  [
    "NP"
    /* CountryCode.NP */
  ]: (i18n2) => i18n2.str`Nepal`,
  [
    "NZ"
    /* CountryCode.NZ */
  ]: (i18n2) => i18n2.str`New Zealand`,
  [
    "VU"
    /* CountryCode.VU */
  ]: (i18n2) => i18n2.str`Vanuatu`,
  [
    "NI"
    /* CountryCode.NI */
  ]: (i18n2) => i18n2.str`Nicaragua`,
  [
    "NG"
    /* CountryCode.NG */
  ]: (i18n2) => i18n2.str`Nigeria`,
  [
    "NE"
    /* CountryCode.NE */
  ]: (i18n2) => i18n2.str`Niger`,
  [
    "KP"
    /* CountryCode.KP */
  ]: (i18n2) => i18n2.str`North Korea`,
  [
    "NO"
    /* CountryCode.NO */
  ]: (i18n2) => i18n2.str`Norway`,
  [
    "OM"
    /* CountryCode.OM */
  ]: (i18n2) => i18n2.str`Oman`,
  [
    "PK"
    /* CountryCode.PK */
  ]: (i18n2) => i18n2.str`Pakistan`,
  [
    "PW"
    /* CountryCode.PW */
  ]: (i18n2) => i18n2.str`Palau`,
  [
    "PA"
    /* CountryCode.PA */
  ]: (i18n2) => i18n2.str`Panama`,
  [
    "PG"
    /* CountryCode.PG */
  ]: (i18n2) => i18n2.str`Papua New Guinea`,
  [
    "PY"
    /* CountryCode.PY */
  ]: (i18n2) => i18n2.str`Paraguay`,
  [
    "PE"
    /* CountryCode.PE */
  ]: (i18n2) => i18n2.str`Peru`,
  [
    "PL"
    /* CountryCode.PL */
  ]: (i18n2) => i18n2.str`Poland`,
  [
    "PT"
    /* CountryCode.PT */
  ]: (i18n2) => i18n2.str`Portugal`,
  [
    "QA"
    /* CountryCode.QA */
  ]: (i18n2) => i18n2.str`Qatar`,
  [
    "RO"
    /* CountryCode.RO */
  ]: (i18n2) => i18n2.str`Romania`,
  [
    "RU"
    /* CountryCode.RU */
  ]: (i18n2) => i18n2.str`Russia`,
  [
    "RW"
    /* CountryCode.RW */
  ]: (i18n2) => i18n2.str`Rwanda`,
  [
    "LC"
    /* CountryCode.LC */
  ]: (i18n2) => i18n2.str`Saint Lucia`,
  [
    "SV"
    /* CountryCode.SV */
  ]: (i18n2) => i18n2.str`El Salvador`,
  [
    "WS"
    /* CountryCode.WS */
  ]: (i18n2) => i18n2.str`Samoa`,
  [
    "SM"
    /* CountryCode.SM */
  ]: (i18n2) => i18n2.str`San Marino`,
  [
    "ST"
    /* CountryCode.ST */
  ]: (i18n2) => i18n2.str`São Tomé and Príncipe`,
  [
    "SA"
    /* CountryCode.SA */
  ]: (i18n2) => i18n2.str`Saudi Arabia`,
  [
    "SN"
    /* CountryCode.SN */
  ]: (i18n2) => i18n2.str`Senegal`,
  [
    "RS"
    /* CountryCode.RS */
  ]: (i18n2) => i18n2.str`Serbia`,
  [
    "SC"
    /* CountryCode.SC */
  ]: (i18n2) => i18n2.str`Seychelles`,
  [
    "SL"
    /* CountryCode.SL */
  ]: (i18n2) => i18n2.str`Sierra Leone`,
  [
    "SG"
    /* CountryCode.SG */
  ]: (i18n2) => i18n2.str`Singapore`,
  [
    "SK"
    /* CountryCode.SK */
  ]: (i18n2) => i18n2.str`Slovakia`,
  [
    "SI"
    /* CountryCode.SI */
  ]: (i18n2) => i18n2.str`Slovenia`,
  [
    "SB"
    /* CountryCode.SB */
  ]: (i18n2) => i18n2.str`Solomon Islands`,
  [
    "SO"
    /* CountryCode.SO */
  ]: (i18n2) => i18n2.str`Somalia`,
  [
    "ZA"
    /* CountryCode.ZA */
  ]: (i18n2) => i18n2.str`South Africa`,
  [
    "KR"
    /* CountryCode.KR */
  ]: (i18n2) => i18n2.str`South Korea`,
  [
    "ES"
    /* CountryCode.ES */
  ]: (i18n2) => i18n2.str`Spain`,
  [
    "LK"
    /* CountryCode.LK */
  ]: (i18n2) => i18n2.str`Sri Lanka`,
  [
    "SD"
    /* CountryCode.SD */
  ]: (i18n2) => i18n2.str`Sudan`,
  [
    "SR"
    /* CountryCode.SR */
  ]: (i18n2) => i18n2.str`Suriname`,
  [
    "SZ"
    /* CountryCode.SZ */
  ]: (i18n2) => i18n2.str`Eswatini`,
  [
    "SE"
    /* CountryCode.SE */
  ]: (i18n2) => i18n2.str`Sweden`,
  [
    "CH"
    /* CountryCode.CH */
  ]: (i18n2) => i18n2.str`Switzerland`,
  [
    "SY"
    /* CountryCode.SY */
  ]: (i18n2) => i18n2.str`Syria`,
  [
    "TW"
    /* CountryCode.TW */
  ]: (i18n2) => i18n2.str`Taiwan`,
  [
    "TJ"
    /* CountryCode.TJ */
  ]: (i18n2) => i18n2.str`Tajikistan`,
  [
    "TZ"
    /* CountryCode.TZ */
  ]: (i18n2) => i18n2.str`Tanzania`,
  [
    "TH"
    /* CountryCode.TH */
  ]: (i18n2) => i18n2.str`Thailand`,
  [
    "TG"
    /* CountryCode.TG */
  ]: (i18n2) => i18n2.str`Togo`,
  [
    "TO"
    /* CountryCode.TO */
  ]: (i18n2) => i18n2.str`Tonga`,
  [
    "TT"
    /* CountryCode.TT */
  ]: (i18n2) => i18n2.str`Trinidad and Tobago`,
  [
    "TN"
    /* CountryCode.TN */
  ]: (i18n2) => i18n2.str`Tunisia`,
  [
    "TR"
    /* CountryCode.TR */
  ]: (i18n2) => i18n2.str`Turkey`,
  [
    "TV"
    /* CountryCode.TV */
  ]: (i18n2) => i18n2.str`Tuvalu`,
  [
    "UG"
    /* CountryCode.UG */
  ]: (i18n2) => i18n2.str`Uganda`,
  [
    "UA"
    /* CountryCode.UA */
  ]: (i18n2) => i18n2.str`Ukraine`,
  [
    "UY"
    /* CountryCode.UY */
  ]: (i18n2) => i18n2.str`Uruguay`,
  [
    "UZ"
    /* CountryCode.UZ */
  ]: (i18n2) => i18n2.str`Uzbekistan`,
  [
    "VE"
    /* CountryCode.VE */
  ]: (i18n2) => i18n2.str`Venezuela`,
  [
    "VN"
    /* CountryCode.VN */
  ]: (i18n2) => i18n2.str`Vietnam`,
  [
    "YE"
    /* CountryCode.YE */
  ]: (i18n2) => i18n2.str`Yemen`,
  [
    "ZM"
    /* CountryCode.ZM */
  ]: (i18n2) => i18n2.str`Zambia`,
  [
    "ZW"
    /* CountryCode.ZW */
  ]: (i18n2) => i18n2.str`Zimbabwe`
};
var countryNationalitiesByCode = {
  [
    "AF"
    /* CountryCode.AF */
  ]: (i18n2) => i18n2.str`Afghan`,
  [
    "AL"
    /* CountryCode.AL */
  ]: (i18n2) => i18n2.str`Albanian`,
  [
    "DZ"
    /* CountryCode.DZ */
  ]: (i18n2) => i18n2.str`Algerian`,
  [
    "US"
    /* CountryCode.US */
  ]: (i18n2) => i18n2.str`American`,
  [
    "AD"
    /* CountryCode.AD */
  ]: (i18n2) => i18n2.str`Andorran`,
  [
    "AO"
    /* CountryCode.AO */
  ]: (i18n2) => i18n2.str`Angolan`,
  [
    "AG"
    /* CountryCode.AG */
  ]: (i18n2) => i18n2.str`Antiguan`,
  [
    "AR"
    /* CountryCode.AR */
  ]: (i18n2) => i18n2.str`Argentinean`,
  [
    "AM"
    /* CountryCode.AM */
  ]: (i18n2) => i18n2.str`Armenian`,
  [
    "AU"
    /* CountryCode.AU */
  ]: (i18n2) => i18n2.str`Australian`,
  [
    "AT"
    /* CountryCode.AT */
  ]: (i18n2) => i18n2.str`Austrian`,
  [
    "AZ"
    /* CountryCode.AZ */
  ]: (i18n2) => i18n2.str`Azerbaijani`,
  [
    "BS"
    /* CountryCode.BS */
  ]: (i18n2) => i18n2.str`Bahamian`,
  [
    "BH"
    /* CountryCode.BH */
  ]: (i18n2) => i18n2.str`Bahraini`,
  [
    "BD"
    /* CountryCode.BD */
  ]: (i18n2) => i18n2.str`Bangladeshi`,
  [
    "BB"
    /* CountryCode.BB */
  ]: (i18n2) => i18n2.str`Barbadian`,
  [
    "BW"
    /* CountryCode.BW */
  ]: (i18n2) => i18n2.str`Batswana`,
  [
    "BY"
    /* CountryCode.BY */
  ]: (i18n2) => i18n2.str`Belarusian`,
  [
    "BE"
    /* CountryCode.BE */
  ]: (i18n2) => i18n2.str`Belgian`,
  [
    "BZ"
    /* CountryCode.BZ */
  ]: (i18n2) => i18n2.str`Belizean`,
  [
    "BJ"
    /* CountryCode.BJ */
  ]: (i18n2) => i18n2.str`Beninese`,
  [
    "BT"
    /* CountryCode.BT */
  ]: (i18n2) => i18n2.str`Bhutanese`,
  [
    "BO"
    /* CountryCode.BO */
  ]: (i18n2) => i18n2.str`Bolivian`,
  [
    "BA"
    /* CountryCode.BA */
  ]: (i18n2) => i18n2.str`Bosnian`,
  [
    "BR"
    /* CountryCode.BR */
  ]: (i18n2) => i18n2.str`Brazilian`,
  [
    "GB"
    /* CountryCode.GB */
  ]: (i18n2) => i18n2.str`British`,
  [
    "BN"
    /* CountryCode.BN */
  ]: (i18n2) => i18n2.str`Bruneian`,
  [
    "BG"
    /* CountryCode.BG */
  ]: (i18n2) => i18n2.str`Bulgarian`,
  [
    "BF"
    /* CountryCode.BF */
  ]: (i18n2) => i18n2.str`Burkinabe`,
  [
    "MM"
    /* CountryCode.MM */
  ]: (i18n2) => i18n2.str`Burmese`,
  [
    "BI"
    /* CountryCode.BI */
  ]: (i18n2) => i18n2.str`Burundian`,
  [
    "KH"
    /* CountryCode.KH */
  ]: (i18n2) => i18n2.str`Cambodian`,
  [
    "CM"
    /* CountryCode.CM */
  ]: (i18n2) => i18n2.str`Cameroonian`,
  [
    "CA"
    /* CountryCode.CA */
  ]: (i18n2) => i18n2.str`Canadian`,
  [
    "CV"
    /* CountryCode.CV */
  ]: (i18n2) => i18n2.str`Cape Verdean`,
  [
    "CF"
    /* CountryCode.CF */
  ]: (i18n2) => i18n2.str`Central African`,
  [
    "TD"
    /* CountryCode.TD */
  ]: (i18n2) => i18n2.str`Chadian`,
  [
    "CL"
    /* CountryCode.CL */
  ]: (i18n2) => i18n2.str`Chilean`,
  [
    "CN"
    /* CountryCode.CN */
  ]: (i18n2) => i18n2.str`Chinese`,
  [
    "CO"
    /* CountryCode.CO */
  ]: (i18n2) => i18n2.str`Colombian`,
  [
    "KM"
    /* CountryCode.KM */
  ]: (i18n2) => i18n2.str`Comoran`,
  [
    "CD"
    /* CountryCode.CD */
  ]: (i18n2) => i18n2.str`Congolese`,
  [
    "CG"
    /* CountryCode.CG */
  ]: (i18n2) => i18n2.str`Congolese`,
  [
    "CR"
    /* CountryCode.CR */
  ]: (i18n2) => i18n2.str`Costa Rican`,
  [
    "HR"
    /* CountryCode.HR */
  ]: (i18n2) => i18n2.str`Croatian`,
  [
    "CU"
    /* CountryCode.CU */
  ]: (i18n2) => i18n2.str`Cuban`,
  [
    "CY"
    /* CountryCode.CY */
  ]: (i18n2) => i18n2.str`Cypriot`,
  [
    "CZ"
    /* CountryCode.CZ */
  ]: (i18n2) => i18n2.str`Czech`,
  [
    "DK"
    /* CountryCode.DK */
  ]: (i18n2) => i18n2.str`Danish`,
  [
    "DJ"
    /* CountryCode.DJ */
  ]: (i18n2) => i18n2.str`Djiboutian`,
  [
    "DO"
    /* CountryCode.DO */
  ]: (i18n2) => i18n2.str`Dominican`,
  [
    "NL"
    /* CountryCode.NL */
  ]: (i18n2) => i18n2.str`Dutch`,
  [
    "TL"
    /* CountryCode.TL */
  ]: (i18n2) => i18n2.str`East Timorese`,
  [
    "EC"
    /* CountryCode.EC */
  ]: (i18n2) => i18n2.str`Ecuadorean`,
  [
    "EG"
    /* CountryCode.EG */
  ]: (i18n2) => i18n2.str`Egyptian`,
  [
    "AE"
    /* CountryCode.AE */
  ]: (i18n2) => i18n2.str`Emirati`,
  [
    "GQ"
    /* CountryCode.GQ */
  ]: (i18n2) => i18n2.str`Equatorial Guinean`,
  [
    "ER"
    /* CountryCode.ER */
  ]: (i18n2) => i18n2.str`Eritrean`,
  [
    "EE"
    /* CountryCode.EE */
  ]: (i18n2) => i18n2.str`Estonian`,
  [
    "ET"
    /* CountryCode.ET */
  ]: (i18n2) => i18n2.str`Ethiopian`,
  [
    "FJ"
    /* CountryCode.FJ */
  ]: (i18n2) => i18n2.str`Fijian`,
  [
    "PH"
    /* CountryCode.PH */
  ]: (i18n2) => i18n2.str`Filipino`,
  [
    "FI"
    /* CountryCode.FI */
  ]: (i18n2) => i18n2.str`Finnish`,
  [
    "FR"
    /* CountryCode.FR */
  ]: (i18n2) => i18n2.str`French`,
  [
    "GA"
    /* CountryCode.GA */
  ]: (i18n2) => i18n2.str`Gabonese`,
  [
    "GM"
    /* CountryCode.GM */
  ]: (i18n2) => i18n2.str`Gambian`,
  [
    "GE"
    /* CountryCode.GE */
  ]: (i18n2) => i18n2.str`Georgian`,
  [
    "DE"
    /* CountryCode.DE */
  ]: (i18n2) => i18n2.str`German`,
  [
    "GH"
    /* CountryCode.GH */
  ]: (i18n2) => i18n2.str`Ghanaian`,
  [
    "GR"
    /* CountryCode.GR */
  ]: (i18n2) => i18n2.str`Greek`,
  [
    "GD"
    /* CountryCode.GD */
  ]: (i18n2) => i18n2.str`Grenadian`,
  [
    "GT"
    /* CountryCode.GT */
  ]: (i18n2) => i18n2.str`Guatemalan`,
  [
    "GW"
    /* CountryCode.GW */
  ]: (i18n2) => i18n2.str`Guinea-Bissauan`,
  [
    "GN"
    /* CountryCode.GN */
  ]: (i18n2) => i18n2.str`Guinean`,
  [
    "GY"
    /* CountryCode.GY */
  ]: (i18n2) => i18n2.str`Guyanese`,
  [
    "HT"
    /* CountryCode.HT */
  ]: (i18n2) => i18n2.str`Haitian`,
  [
    "HN"
    /* CountryCode.HN */
  ]: (i18n2) => i18n2.str`Honduran`,
  [
    "HU"
    /* CountryCode.HU */
  ]: (i18n2) => i18n2.str`Hungarian`,
  [
    "KI"
    /* CountryCode.KI */
  ]: (i18n2) => i18n2.str`I-Kiribati`,
  [
    "IS"
    /* CountryCode.IS */
  ]: (i18n2) => i18n2.str`Icelander`,
  [
    "IN"
    /* CountryCode.IN */
  ]: (i18n2) => i18n2.str`Indian`,
  [
    "ID"
    /* CountryCode.ID */
  ]: (i18n2) => i18n2.str`Indonesian`,
  [
    "IR"
    /* CountryCode.IR */
  ]: (i18n2) => i18n2.str`Iranian`,
  [
    "IQ"
    /* CountryCode.IQ */
  ]: (i18n2) => i18n2.str`Iraqi`,
  [
    "IE"
    /* CountryCode.IE */
  ]: (i18n2) => i18n2.str`Irish`,
  [
    "IL"
    /* CountryCode.IL */
  ]: (i18n2) => i18n2.str`Israeli`,
  [
    "IT"
    /* CountryCode.IT */
  ]: (i18n2) => i18n2.str`Italian`,
  [
    "CI"
    /* CountryCode.CI */
  ]: (i18n2) => i18n2.str`Ivorian`,
  [
    "JM"
    /* CountryCode.JM */
  ]: (i18n2) => i18n2.str`Jamaican`,
  [
    "JP"
    /* CountryCode.JP */
  ]: (i18n2) => i18n2.str`Japanese`,
  [
    "JO"
    /* CountryCode.JO */
  ]: (i18n2) => i18n2.str`Jordanian`,
  [
    "KZ"
    /* CountryCode.KZ */
  ]: (i18n2) => i18n2.str`Kazakhstani`,
  [
    "KE"
    /* CountryCode.KE */
  ]: (i18n2) => i18n2.str`Kenyan`,
  [
    "KN"
    /* CountryCode.KN */
  ]: (i18n2) => i18n2.str`Kittian and Nevisian`,
  [
    "KW"
    /* CountryCode.KW */
  ]: (i18n2) => i18n2.str`Kuwaiti`,
  [
    "KG"
    /* CountryCode.KG */
  ]: (i18n2) => i18n2.str`Kyrgyz`,
  [
    "LA"
    /* CountryCode.LA */
  ]: (i18n2) => i18n2.str`Laotian`,
  [
    "LV"
    /* CountryCode.LV */
  ]: (i18n2) => i18n2.str`Latvian`,
  [
    "LB"
    /* CountryCode.LB */
  ]: (i18n2) => i18n2.str`Lebanese`,
  [
    "LR"
    /* CountryCode.LR */
  ]: (i18n2) => i18n2.str`Liberian`,
  [
    "LY"
    /* CountryCode.LY */
  ]: (i18n2) => i18n2.str`Libyan`,
  [
    "LI"
    /* CountryCode.LI */
  ]: (i18n2) => i18n2.str`Liechtensteiner`,
  [
    "LT"
    /* CountryCode.LT */
  ]: (i18n2) => i18n2.str`Lithuanian`,
  [
    "LU"
    /* CountryCode.LU */
  ]: (i18n2) => i18n2.str`Luxembourger`,
  [
    "MK"
    /* CountryCode.MK */
  ]: (i18n2) => i18n2.str`Macedonian`,
  [
    "MG"
    /* CountryCode.MG */
  ]: (i18n2) => i18n2.str`Malagasy`,
  [
    "MW"
    /* CountryCode.MW */
  ]: (i18n2) => i18n2.str`Malawian`,
  [
    "MY"
    /* CountryCode.MY */
  ]: (i18n2) => i18n2.str`Malaysian`,
  [
    "MV"
    /* CountryCode.MV */
  ]: (i18n2) => i18n2.str`Maldivian`,
  [
    "ML"
    /* CountryCode.ML */
  ]: (i18n2) => i18n2.str`Malian`,
  [
    "MT"
    /* CountryCode.MT */
  ]: (i18n2) => i18n2.str`Maltese`,
  [
    "MH"
    /* CountryCode.MH */
  ]: (i18n2) => i18n2.str`Marshallese`,
  [
    "MR"
    /* CountryCode.MR */
  ]: (i18n2) => i18n2.str`Mauritanian`,
  [
    "MU"
    /* CountryCode.MU */
  ]: (i18n2) => i18n2.str`Mauritian`,
  [
    "MX"
    /* CountryCode.MX */
  ]: (i18n2) => i18n2.str`Mexican`,
  [
    "FM"
    /* CountryCode.FM */
  ]: (i18n2) => i18n2.str`Micronesian`,
  [
    "MD"
    /* CountryCode.MD */
  ]: (i18n2) => i18n2.str`Moldovan`,
  [
    "MC"
    /* CountryCode.MC */
  ]: (i18n2) => i18n2.str`Monacan`,
  [
    "MN"
    /* CountryCode.MN */
  ]: (i18n2) => i18n2.str`Mongolian`,
  [
    "MA"
    /* CountryCode.MA */
  ]: (i18n2) => i18n2.str`Moroccan`,
  [
    "LS"
    /* CountryCode.LS */
  ]: (i18n2) => i18n2.str`Mosotho`,
  [
    "MZ"
    /* CountryCode.MZ */
  ]: (i18n2) => i18n2.str`Mozambican`,
  [
    "NA"
    /* CountryCode.NA */
  ]: (i18n2) => i18n2.str`Namibian`,
  [
    "NR"
    /* CountryCode.NR */
  ]: (i18n2) => i18n2.str`Nauruan`,
  [
    "NP"
    /* CountryCode.NP */
  ]: (i18n2) => i18n2.str`Nepalese`,
  [
    "NZ"
    /* CountryCode.NZ */
  ]: (i18n2) => i18n2.str`New Zealander`,
  [
    "VU"
    /* CountryCode.VU */
  ]: (i18n2) => i18n2.str`Ni-Vanuatu`,
  [
    "NI"
    /* CountryCode.NI */
  ]: (i18n2) => i18n2.str`Nicaraguan`,
  [
    "NG"
    /* CountryCode.NG */
  ]: (i18n2) => i18n2.str`Nigerian`,
  [
    "NE"
    /* CountryCode.NE */
  ]: (i18n2) => i18n2.str`Nigerien`,
  [
    "KP"
    /* CountryCode.KP */
  ]: (i18n2) => i18n2.str`North Korean`,
  [
    "NO"
    /* CountryCode.NO */
  ]: (i18n2) => i18n2.str`Norwegian`,
  [
    "OM"
    /* CountryCode.OM */
  ]: (i18n2) => i18n2.str`Omani`,
  [
    "PK"
    /* CountryCode.PK */
  ]: (i18n2) => i18n2.str`Pakistani`,
  [
    "PW"
    /* CountryCode.PW */
  ]: (i18n2) => i18n2.str`Palauan`,
  [
    "PA"
    /* CountryCode.PA */
  ]: (i18n2) => i18n2.str`Panamanian`,
  [
    "PG"
    /* CountryCode.PG */
  ]: (i18n2) => i18n2.str`Papua New Guinean`,
  [
    "PY"
    /* CountryCode.PY */
  ]: (i18n2) => i18n2.str`Paraguayan`,
  [
    "PE"
    /* CountryCode.PE */
  ]: (i18n2) => i18n2.str`Peruvian`,
  [
    "PL"
    /* CountryCode.PL */
  ]: (i18n2) => i18n2.str`Polish`,
  [
    "PT"
    /* CountryCode.PT */
  ]: (i18n2) => i18n2.str`Portuguese`,
  [
    "QA"
    /* CountryCode.QA */
  ]: (i18n2) => i18n2.str`Qatari`,
  [
    "RO"
    /* CountryCode.RO */
  ]: (i18n2) => i18n2.str`Romanian`,
  [
    "RU"
    /* CountryCode.RU */
  ]: (i18n2) => i18n2.str`Russian`,
  [
    "RW"
    /* CountryCode.RW */
  ]: (i18n2) => i18n2.str`Rwandan`,
  [
    "LC"
    /* CountryCode.LC */
  ]: (i18n2) => i18n2.str`Saint Lucian`,
  [
    "SV"
    /* CountryCode.SV */
  ]: (i18n2) => i18n2.str`Salvadoran`,
  [
    "WS"
    /* CountryCode.WS */
  ]: (i18n2) => i18n2.str`Samoan`,
  [
    "SM"
    /* CountryCode.SM */
  ]: (i18n2) => i18n2.str`San Marinese`,
  [
    "ST"
    /* CountryCode.ST */
  ]: (i18n2) => i18n2.str`Sao Tomean`,
  [
    "SA"
    /* CountryCode.SA */
  ]: (i18n2) => i18n2.str`Saudi`,
  [
    "SN"
    /* CountryCode.SN */
  ]: (i18n2) => i18n2.str`Senegalese`,
  [
    "RS"
    /* CountryCode.RS */
  ]: (i18n2) => i18n2.str`Serbian`,
  [
    "SC"
    /* CountryCode.SC */
  ]: (i18n2) => i18n2.str`Seychellois`,
  [
    "SL"
    /* CountryCode.SL */
  ]: (i18n2) => i18n2.str`Sierra Leonean`,
  [
    "SG"
    /* CountryCode.SG */
  ]: (i18n2) => i18n2.str`Singaporean`,
  [
    "SK"
    /* CountryCode.SK */
  ]: (i18n2) => i18n2.str`Slovakian`,
  [
    "SI"
    /* CountryCode.SI */
  ]: (i18n2) => i18n2.str`Slovenian`,
  [
    "SB"
    /* CountryCode.SB */
  ]: (i18n2) => i18n2.str`Solomon Islander`,
  [
    "SO"
    /* CountryCode.SO */
  ]: (i18n2) => i18n2.str`Somali`,
  [
    "ZA"
    /* CountryCode.ZA */
  ]: (i18n2) => i18n2.str`South African`,
  [
    "KR"
    /* CountryCode.KR */
  ]: (i18n2) => i18n2.str`South Korean`,
  [
    "ES"
    /* CountryCode.ES */
  ]: (i18n2) => i18n2.str`Spanish`,
  [
    "LK"
    /* CountryCode.LK */
  ]: (i18n2) => i18n2.str`Sri Lankan`,
  [
    "SD"
    /* CountryCode.SD */
  ]: (i18n2) => i18n2.str`Sudanese`,
  [
    "SR"
    /* CountryCode.SR */
  ]: (i18n2) => i18n2.str`Surinamer`,
  [
    "SZ"
    /* CountryCode.SZ */
  ]: (i18n2) => i18n2.str`Swazi`,
  [
    "SE"
    /* CountryCode.SE */
  ]: (i18n2) => i18n2.str`Swedish`,
  [
    "CH"
    /* CountryCode.CH */
  ]: (i18n2) => i18n2.str`Swiss`,
  [
    "SY"
    /* CountryCode.SY */
  ]: (i18n2) => i18n2.str`Syrian`,
  [
    "TW"
    /* CountryCode.TW */
  ]: (i18n2) => i18n2.str`Taiwanese`,
  [
    "TJ"
    /* CountryCode.TJ */
  ]: (i18n2) => i18n2.str`Tajik`,
  [
    "TZ"
    /* CountryCode.TZ */
  ]: (i18n2) => i18n2.str`Tanzanian`,
  [
    "TH"
    /* CountryCode.TH */
  ]: (i18n2) => i18n2.str`Thai`,
  [
    "TG"
    /* CountryCode.TG */
  ]: (i18n2) => i18n2.str`Togolese`,
  [
    "TO"
    /* CountryCode.TO */
  ]: (i18n2) => i18n2.str`Tongan`,
  [
    "TT"
    /* CountryCode.TT */
  ]: (i18n2) => i18n2.str`Trinidadian or Tobagonian`,
  [
    "TN"
    /* CountryCode.TN */
  ]: (i18n2) => i18n2.str`Tunisian`,
  [
    "TR"
    /* CountryCode.TR */
  ]: (i18n2) => i18n2.str`Turkish`,
  [
    "TV"
    /* CountryCode.TV */
  ]: (i18n2) => i18n2.str`Tuvaluan`,
  [
    "UG"
    /* CountryCode.UG */
  ]: (i18n2) => i18n2.str`Ugandan`,
  [
    "UA"
    /* CountryCode.UA */
  ]: (i18n2) => i18n2.str`Ukrainian`,
  [
    "UY"
    /* CountryCode.UY */
  ]: (i18n2) => i18n2.str`Uruguayan`,
  [
    "UZ"
    /* CountryCode.UZ */
  ]: (i18n2) => i18n2.str`Uzbekistani`,
  [
    "VE"
    /* CountryCode.VE */
  ]: (i18n2) => i18n2.str`Venezuelan`,
  [
    "VN"
    /* CountryCode.VN */
  ]: (i18n2) => i18n2.str`Vietnamese`,
  [
    "YE"
    /* CountryCode.YE */
  ]: (i18n2) => i18n2.str`Yemenite`,
  [
    "ZM"
    /* CountryCode.ZM */
  ]: (i18n2) => i18n2.str`Zambian`,
  [
    "ZW"
    /* CountryCode.ZW */
  ]: (i18n2) => i18n2.str`Zimbabwean`
};

// ../taler-util/lib/aml/reporting.js
var EventReporting_TOPS_queries = {
  // Number of accounts that are opened
  accounts_open_incr: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  accounts_open_decr: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  // Number of new GwG files in the last year
  gwg_files_new_last_year: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files closed in the last year
  gwg_files_closed_last_year: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files of high-risk customers
  gwg_files_high_risk_incr: {
    event: TOPS_AmlEventsName.INCR_HIGH_RISK_CUSTOMER,
    //FIXME: spec refers to INCR_HIGH_RISK
    start: void 0,
    end: void 0
  },
  gwg_files_high_risk_decr: {
    event: TOPS_AmlEventsName.DECR_HIGH_RISK_CUSTOMER,
    start: void 0,
    end: void 0
  },
  // Number of GwG files managed with “increased risk” due to PEP status
  gwg_files_pep_incr: {
    event: TOPS_AmlEventsName.INCR_PEP,
    start: void 0,
    end: void 0
  },
  gwg_files_pep_decr: {
    event: TOPS_AmlEventsName.DECR_PEP,
    start: void 0,
    end: void 0
  },
  // Number of MROS reports based on Art 9 Abs. 1 GwG (per year)
  mros_reports_art9_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SUBSTANTIATED,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of MROS reports based on Art 305ter Abs. 2 StGB (per year)
  mros_reports_art305_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SIMPLE,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of customers involved in proceedings for which Art 6 GwG did apply
  accounts_involed_in_proceedings_last_year: {
    event: TOPS_AmlEventsName.INCR_INVESTIGATION_CONCLUDED,
    //FIXME: spec refers to INCR_INVESTIGATION
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  }
};

// ../taler-util/lib/index.browser.js
loadBrowserPrng();

// ../web-util/lib/index.browser.mjs
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_compat_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
var __defProp2 = Object.defineProperty;
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var utils_exports = {};
__export2(utils_exports, {
  compose: () => compose,
  composeRef: () => composeRef,
  doAutoFocus: () => doAutoFocus,
  doAutoFocusWithScroll: () => doAutoFocusWithScroll,
  onComponentUnload: () => onComponentUnload,
  preconnectAs: () => preconnectAs,
  recursive: () => recursive,
  saveRef: () => saveRef,
  saveVNodeForInspection: () => saveVNodeForInspection
});
function compose(hook, viewMap) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      const statusName = state.status;
      const viewComponent = viewMap[statusName];
      return h(viewComponent, state);
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h54 = withHook(() => hook(p4));
    return h54();
  };
}
function recursive(hook) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      return state;
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h54 = withHook(() => hook(p4));
    return h54();
  };
}
function onComponentUnload(callback) {
  const ref = _2();
  ref.current = callback;
  h2(() => {
    return () => {
      ref.current();
    };
  }, []);
}
var ownerDocument = typeof document === "undefined" ? null : document;
var preconnectsSet = /* @__PURE__ */ new Set();
function preconnectAs(pre) {
  if (ownerDocument) {
    pre.forEach(({ rel, href, crossOrigin }) => {
      const key = `${rel}${href}${crossOrigin}`;
      if (preconnectsSet.has(key))
        return;
      preconnectsSet.add(key);
      const instance = ownerDocument.createElement("link");
      instance.setAttribute("rel", rel);
      instance.setAttribute("crossOrigin", crossOrigin);
      instance.setAttribute("href", href);
      ownerDocument.head.appendChild(instance);
    });
  }
}
function composeRef(...fn2) {
  return (element) => {
    fn2.forEach((handler) => {
      handler(element);
    });
  };
}
function saveRef(ref) {
  return (element) => {
    if (element) {
      ref.current = element;
    }
  };
}
function doAutoFocus(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
    }, 100);
  }
}
function doAutoFocusWithScroll(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
      element.scrollIntoView({
        behavior: "smooth",
        block: "center",
        inline: "center"
      });
    }, 100);
  }
}
function saveVNodeForInspection(obj) {
  window["showVNodeInfo"] = function showVNodeInfo() {
    inspect(obj);
  };
  return obj;
}
function inspect(obj) {
  if (!obj)
    return;
  if (obj.__c && obj.__c.__H) {
    const componentName = obj.__c.constructor.name;
    const hookState = obj.__c.__H;
    const stateList = hookState.__;
    console.log("==============", componentName);
    stateList.forEach((hook) => {
      const { __: value, c: context, __h: factory, __H: args } = hook;
      if (typeof context !== "undefined") {
        const { __c: contextId } = context;
        console.log("context:", contextId, hook);
      } else if (typeof factory === "function") {
        console.log("memo:", value, "deps:", args);
      } else if (typeof value === "function") {
        const effectName = value.name;
        console.log("effect:", effectName, "deps:", args);
      } else if (typeof value.current !== "undefined") {
        const ref = value.current;
        console.log("ref:", ref instanceof Element ? ref.outerHTML : ref);
      } else if (value instanceof Array) {
        console.log("state:", value[0]);
      } else {
        console.log(hook);
      }
    });
  }
  const children = obj.__k;
  if (children instanceof Array) {
    children.forEach((e22) => inspect(e22));
  } else {
    inspect(children);
  }
}
function Attention({ type = "info", title, children, onClose, timeout = Duration.getForever() }) {
  return /* @__PURE__ */ h("div", { class: `group attention-${type} mt-2 shadow-lg` }, /* @__PURE__ */ h("div", { "data-timed": timeout.d_ms !== "forever", class: "rounded-md data-[timed=true]:rounded-b-none group-[.attention-info]:bg-blue-50 group-[.attention-low]:bg-gray-100 group-[.attention-warning]:bg-yellow-50 group-[.attention-danger]:bg-red-50 group-[.attention-success]:bg-green-50 p-4 shadow" }, /* @__PURE__ */ h("div", { class: "flex" }, /* @__PURE__ */ h("div", null, type === "low" ? void 0 : /* @__PURE__ */ h("svg", { xmlns: "http://www.w3.org/2000/svg", stroke: "none", viewBox: "0 0 24 24", fill: "currentColor", class: "w-8 h-8 group-[.attention-info]:text-blue-400 group-[.attention-warning]:text-yellow-400 group-[.attention-danger]:text-red-400 group-[.attention-success]:text-green-400" }, (() => {
    switch (type) {
      case "info":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a.75.75 0 000 1.5h.253a.25.25 0 01.244.304l-.459 2.066A1.75 1.75 0 0010.747 15H11a.75.75 0 000-1.5h-.253a.25.25 0 01-.244-.304l.459-2.066A1.75 1.75 0 009.253 9H9z" });
      case "warning":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M9.401 3.003c1.155-2 4.043-2 5.197 0l7.355 12.748c1.154 2-.29 4.5-2.599 4.5H4.645c-2.309 0-3.752-2.5-2.598-4.5L9.4 3.003zM12 8.25a.75.75 0 01.75.75v3.75a.75.75 0 01-1.5 0V9a.75.75 0 01.75-.75zm0 8.25a.75.75 0 100-1.5.75.75 0 000 1.5z" });
      case "danger":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12zM12 8.25a.75.75 0 01.75.75v3.75a.75.75 0 01-1.5 0V9a.75.75 0 01.75-.75zm0 8.25a.75.75 0 100-1.5.75.75 0 000 1.5z" });
      case "success":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M7.493 18.75c-.425 0-.82-.236-.975-.632A7.48 7.48 0 016 15.375c0-1.75.599-3.358 1.602-4.634.151-.192.373-.309.6-.397.473-.183.89-.514 1.212-.924a9.042 9.042 0 012.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 00.322-1.672V3a.75.75 0 01.75-.75 2.25 2.25 0 012.25 2.25c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 01-2.649 7.521c-.388.482-.987.729-1.605.729H14.23c-.483 0-.964-.078-1.423-.23l-3.114-1.04a4.501 4.501 0 00-1.423-.23h-.777zM2.331 10.977a11.969 11.969 0 00-.831 4.398 12 12 0 00.52 3.507c.26.85 1.084 1.368 1.973 1.368H4.9c.445 0 .72-.498.523-.898a8.963 8.963 0 01-.924-3.977c0-1.708.476-3.305 1.302-4.666.245-.403-.028-.959-.5-.959H4.25c-.832 0-1.612.453-1.918 1.227z" });
      default:
        assertUnreachable(type);
    }
  })())), /* @__PURE__ */ h("div", { class: "ml-3 w-full" }, /* @__PURE__ */ h("h3", { class: "text-sm font-bold group-[.attention-info]:text-blue-800 group-[.attention-success]:text-green-800 group-[.attention-warning]:text-yellow-800 group-[.attention-danger]:text-red-800" }, title), /* @__PURE__ */ h("div", { class: "mt-2 text-sm group-[.attention-info]:text-blue-700 group-[.attention-warning]:text-yellow-700 group-[.attention-danger]:text-red-700 group-[.attention-success]:text-green-700" }, children)), onClose && /* @__PURE__ */ h("div", null, /* @__PURE__ */ h(
    "button",
    {
      type: "button",
      class: "font-semibold items-center rounded bg-transparent px-2 py-1 text-xs text-gray-900  hover:bg-gray-50",
      onClick: (e22) => {
        e22.preventDefault();
        onClose();
      }
    },
    /* @__PURE__ */ h("svg", { class: "h-5 w-5", viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, /* @__PURE__ */ h("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" }))
  )))), timeout.d_ms === "forever" ? void 0 : /* @__PURE__ */ h("div", { class: "meter group-[.attention-info]:bg-blue-50 group-[.attention-low]:bg-gray-100 group-[.attention-warning]:bg-yellow-50 group-[.attention-danger]:bg-red-50 group-[.attention-success]:bg-green-50 h-1 relative overflow-hidden -mt-1" }, /* @__PURE__ */ h("span", { class: "w-full h-full block" }, /* @__PURE__ */ h("span", { class: "h-full block progress group-[.attention-info]:bg-blue-600 group-[.attention-low]:bg-gray-600 group-[.attention-warning]:bg-yellow-600 group-[.attention-danger]:bg-red-600 group-[.attention-success]:bg-green-600" }))));
}
function DebugInfo({ error: error2 }) {
  const { i18n: i18n4 } = useTranslationContext();
  const [{ showDebugInfo }, update] = useCommonPreferences();
  return /* @__PURE__ */ h("div", { class: "text-[grey]" }, /* @__PURE__ */ h("button", { onClick: () => update("showDebugInfo", !showDebugInfo) }, !showDebugInfo ? /* @__PURE__ */ h(i18n4.Translate, null, "Show more information") : /* @__PURE__ */ h(i18n4.Translate, null, "Hide debug info")), showDebugInfo && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces text-black" }, JSON.stringify(error2, void 0, 2)));
}
function ErrorLoading({ error: error2 }) {
  const { i18n: i18n4 } = useTranslationContext();
  switch (error2.errorDetail.code) {
    case TalerErrorCode.GENERIC_TIMEOUT: {
      if (error2.hasErrorCode(TalerErrorCode.GENERIC_TIMEOUT)) {
        return /* @__PURE__ */ h(
          Attention,
          {
            type: "danger",
            title: i18n4.str`The request reached a timeout, check your connection.`
          },
          error2.message,
          /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail })
        );
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.GENERIC_CLIENT_INTERNAL_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.GENERIC_CLIENT_INTERNAL_ERROR)) {
        const { requestMethod, requestUrl, timeoutMs } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`The request was cancelled.` }, error2.message, /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail }));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_GENERIC_TIMEOUT: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_HTTP_REQUEST_GENERIC_TIMEOUT)) {
        const { requestMethod, requestUrl, timeoutMs } = error2.errorDetail;
        return /* @__PURE__ */ h(
          Attention,
          {
            type: "danger",
            title: i18n4.str`The request reached a timeout, check your connection.`
          },
          error2.message,
          /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail })
        );
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_THROTTLED: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_HTTP_REQUEST_THROTTLED)) {
        const { requestMethod, requestUrl, throttleStats } = error2.errorDetail;
        return /* @__PURE__ */ h(
          Attention,
          {
            type: "danger",
            title: i18n4.str`Too many requests were made to the server, and this action was throttled.`
          },
          error2.message,
          /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail })
        );
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE)) {
        const { requestMethod, requestUrl, httpStatusCode, validationError } = error2.errorDetail;
        return /* @__PURE__ */ h(
          Attention,
          {
            type: "danger",
            title: i18n4.str`The server's response was malformed.`
          },
          error2.message,
          /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail })
        );
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_NETWORK_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_NETWORK_ERROR)) {
        const { requestMethod, requestUrl } = error2.errorDetail;
        return /* @__PURE__ */ h(
          Attention,
          {
            type: "danger",
            title: i18n4.str`Could not complete the request due to a network problem.`
          },
          error2.message,
          /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail })
        );
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR)) {
        const { requestMethod, requestUrl, httpStatusCode, errorResponse } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Unexpected request error` }, error2.message, /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail }));
      }
      assertUnreachable(1);
    }
    default:
      return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Unexpected error` }, error2.message, /* @__PURE__ */ h(DebugInfo, { error: error2.errorDetail }));
  }
}
var lang_default = 'data:image/svg+xml,<?xml version="1.0" encoding="utf-8"?>%0A<!-- Generator: Adobe Illustrator 19.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->%0A<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"%0A%09 viewBox="0 0 2411.2 2794" style="enable-background:new 0 0 2411.2 2794;" xml:space="preserve">%0A<style type="text/css">%0A%09.st0{fill:%23FFFFFF;}%0A%09.st1{fill-rule:evenodd;clip-rule:evenodd;}%0A%09.st2{fill-rule:evenodd;clip-rule:evenodd;fill:%23FFFFFF;}%0A</style>%0A<g id="Layer_2">%0A</g>%0A<g id="Layer_x5F_1_x5F_1">%0A%09<g>%0A%09%09<polygon points="1204.6,359.2 271.8,30 271.8,2060.1 1204.6,1758.3 %09%09"/>%0A%09%09<polygon class="st0" points="1182.2,358.1 2150.6,29 2150.6,2059 1182.2,1757.3 %09%09"/>%0A%09%09<polygon class="st0" points="30,2415.4 1182.2,2031.4 1182.2,357.9 30,742 %09%09"/>%0A%09%09<polygon points="1707.2,2440.7 1870.5,2709.4 1956.6,2459.8 %09%09"/>%0A%09%09<g>%0A%09%09%09<path d="M421.7,934.8c-6.1-6,8,49.1,27.6,68.9c34.8,35.1,61.9,39.6,76.4,40.2c32,1.3,71.5-8,94.9-17.8%0A%09%09%09%09c22.7-9.7,62.4-30,77.5-59.6c3.2-6.3,11.9-17,6.4-43.2c-4.2-20.2-17-27.3-32.7-26.2c-15.7,1.1-63.2,13.7-86.1,20.8%0A%09%09%09%09c-23,7-70.3,21.4-90.9,25.8C474.3,948.2,429,941.7,421.7,934.8z"/>%0A%09%09%09<path d="M1003.1,1593.7c-9.1-3.3-196.9-81.1-223.6-93.9c-21.8-10.5-75.2-33.1-100.4-43.3c70.8-109.2,115.5-191.6,121.5-204.1%0A%09%09%09%09c11-23,86-169.6,87.7-178.7c1.7-9.1,3.8-42.9,2.2-51c-1.7-8.2-29.1,7.6-66.4,20.2c-37.4,12.6-108.4,58.8-135.8,64.6%0A%09%09%09%09c-27.5,5.7-115.5,39.1-160.5,54c-45,14.9-130.2,40.9-165.2,50.4c-35.1,9.5-65.7,10.2-85.3,16.2c0,0,2.6,27.5,7.8,35.7%0A%09%09%09%09c5.2,8.2,23.7,28.4,45.3,34.1c21.6,5.7,57.3,3.4,73.6-0.3c16.3-3.8,44.4-17.5,48.2-23.6c3.8-6.1-2-24.9,4.5-30.6%0A%09%09%09%09c6.5-5.6,92.2-25.7,124.6-35.4c32.4-10,156.3-52.6,173.1-50.5c-5.3,17.7-105,215.1-137.1,274c-32.1,58.9-218.6,318-258.3,363.6%0A%09%09%09%09c-30.1,34.7-103.2,123.5-128.5,143.6c6.4,1.8,51.6-2.1,59.9-7.2c51.3-31.6,136.9-138.1,164.4-170.5%0A%09%09%09%09c81.9-96,153.8-196.8,210.8-283.4h0.1c11.1,4.6,100.9,77.8,124.4,94c23.4,16.2,115.9,67.8,136,76.4c20,8.7,97.1,44.2,100.3,32.2%0A%09%09%09%09C1029.4,1668,1012.2,1597.1,1003.1,1593.7z"/>%0A%09%09</g>%0A%09%09<path class="st1" d="M569,2572c18,11,35,20,54,29c38,19,81,39,122,54c56,21,112,38,168,51c31,7,65,13,98,18c3,0,92,11,110,11h90%0A%09%09%09c35-3,68-5,103-10c28-4,59-9,89-16c22-5,45-10,67-17c21-6,45-14,68-22c15-5,31-12,47-18c13-6,29-13,44-19c18-8,39-19,59-29%0A%09%09%09c16-8,34-18,51-28c13-7,43-30,59-30c18,0,30,16,30,30c0,29-39,38-57,51c-19,13-42,23-62,34c-40,21-81,39-120,54%0A%09%09%09c-51,19-107,37-157,49c-19,4-38,9-57,12c-10,2-114,18-143,18h-132c-35-3-72-7-107-12c-31-5-64-11-95-18c-24-5-50-12-73-19%0A%09%09%09c-40-11-79-25-117-40c-69-26-141-60-209-105c-12-8-13-16-13-25c0-15,11-29,29-29C531,2546,563,2569,569,2572z"/>%0A%09%09<path class="st1" d="M1151,2009L61,2372V764l1090-363V2009z M1212,354v1680c-1,5-3,10-7,15c-2,3-6,7-9,8c-25,10-1151,388-1166,388%0A%09%09%09c-12,0-23-8-29-21c0-1-1-2-1-4V739c2-5,3-12,7-16c8-11,22-13,31-16c17-6,1126-378,1142-378C1190,329,1212,336,1212,354z"/>%0A%09%09<path class="st1" d="M2120,2017l-907-282V380l907-308V2017z M2181,32v2023c-1,23-17,33-32,33c-13,0-107-32-123-37%0A%09%09%09c-126-39-253-78-378-117c-28-9-57-18-84-27c-24-7-50-15-74-23c-107-33-216-66-323-102c-4-1-14-15-14-18V351c2-5,4-11,9-15%0A%09%09%09c8-9,351-123,486-168c36-13,487-168,501-168C2167,0,2181,13,2181,32z"/>%0A%09%09<polygon points="2411.2,2440.7 1199.5,2054.5 1204.6,373.2 2411.2,757.2 %09%09"/>%0A%09%09<g>%0A%09%09%09<path class="st2" d="M1800.3,1124.6L1681.4,1412l218.6,66.3L1800.3,1124.6z M1729,853.2l156.1,47.3l284.4,1025l-160.3-48.7%0A%09%09%09%09l-57.6-210.4L1620.2,1566l-71.3,171.4l-160.4-48.7L1729,853.2z"/>%0A%09%09</g>%0A%09</g>%0A</g>%0A</svg>%0A';
var names = {
  uk: "\u0423\u043A\u0440\u0430\u0457\u043D\u0441\u044C\u043A\u0430 [uk]",
  tr: "T\xFCrk\xE7e [tr]",
  ru: "\u0420\u0443\u0301\u0441\u0441\u043A\u0438\u0439 \u044F\u0437\u044B\u0301\u043A [ru]",
  sv: "Svenska [sv]",
  it: "Italiano [it]",
  fr: "Fran\xE7ais [fr]",
  es: "Espa\xF1ol [es]",
  de: "Deutsch [de]",
  en: "English [en]"
};
function getLangName(s32) {
  if (names[s32])
    return names[s32];
  return String(s32);
}
function LangSelector({
  type = "select"
}) {
  const { lang, changeLanguage, completeness, supportedLang: supportedLang22 } = useTranslationContext();
  const [hidden, setHidden] = p3(true);
  h2(() => {
    function bodyKeyPress(event) {
      if (event.code === "Escape")
        setHidden(true);
    }
    function bodyOnClick(event) {
      setHidden(true);
    }
    document.body.addEventListener("click", bodyOnClick);
    document.body.addEventListener("keydown", bodyKeyPress);
    return () => {
      document.body.removeEventListener("keydown", bodyKeyPress);
      document.body.removeEventListener("click", bodyOnClick);
    };
  }, []);
  return /* @__PURE__ */ h("div", { class: "m-2 block" }, function() {
    switch (type) {
      case "select": {
        return /* @__PURE__ */ h(
          "button",
          {
            type: "button",
            class: "relative w-full   rounded-md bg-white py-1.5 pl-3 pr-10 text-left text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-600 sm:text-sm sm:leading-6",
            "aria-haspopup": "listbox",
            "aria-expanded": "true",
            "aria-labelledby": "listbox-label",
            onClick: (e22) => {
              setHidden(!hidden);
              e22.stopPropagation();
            }
          },
          /* @__PURE__ */ h("span", { class: "flex items-center" }, /* @__PURE__ */ h(
            "img",
            {
              alt: "language",
              class: "h-5 w-5 flex-shrink-0 rounded-full",
              src: lang_default
            }
          ), /* @__PURE__ */ h("span", { class: "ml-3 block truncate" }, getLangName(lang))),
          /* @__PURE__ */ h("span", { class: "pointer-events-none absolute inset-y-0 right-0 flex items-center pr-2" }, /* @__PURE__ */ h(
            "svg",
            {
              class: "h-5 w-5 text-gray-400",
              viewBox: "0 0 20 20",
              fill: "currentColor",
              "aria-hidden": "true"
            },
            /* @__PURE__ */ h(
              "path",
              {
                "fill-rule": "evenodd",
                d: "M10 3a.75.75 0 01.55.24l3.25 3.5a.75.75 0 11-1.1 1.02L10 4.852 7.3 7.76a.75.75 0 01-1.1-1.02l3.25-3.5A.75.75 0 0110 3zm-3.76 9.2a.75.75 0 011.06.04l2.7 2.908 2.7-2.908a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 01.04-1.06z",
                "clip-rule": "evenodd"
              }
            )
          ))
        );
      }
      case "icon": {
        return /* @__PURE__ */ h(
          "button",
          {
            type: "button",
            class: "relative w-full  rounded-md bg-white p-2 text-left text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-600",
            onClick: (e22) => {
              setHidden(!hidden);
              e22.stopPropagation();
            }
          },
          /* @__PURE__ */ h("div", { class: "flex h-7 w-7" }, /* @__PURE__ */ h(
            "img",
            {
              alt: "language",
              class: "h-7 w-7 flex-shrink-0 rounded-full",
              src: lang_default
            }
          ))
        );
      }
    }
  }(), !hidden && /* @__PURE__ */ h(
    "ul",
    {
      class: "absolute m-0 max-h-60 overflow-auto rounded-md bg-white py-1 text-base text-left shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm",
      tabIndex: -1,
      style: type === "icon" ? { marginLeft: -110 } : {},
      role: "listbox",
      "aria-labelledby": "listbox-label",
      "aria-activedescendant": "listbox-option-3"
    },
    type === "icon" ? /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h(
      "li",
      {
        class: "text-gray-900 relative border-b boder-gray-200 select-none py-2 pl-3 pr-9",
        role: "option"
      },
      /* @__PURE__ */ h("span", { class: "font-normal truncate flex justify-between " }, /* @__PURE__ */ h("span", null, getLangName(lang)), /* @__PURE__ */ h("span", null, completeness[lang], "%")),
      /* @__PURE__ */ h("span", { class: "text-indigo-600 absolute inset-y-0 right-0 flex items-center pr-4" })
    )) : /* @__PURE__ */ h(p2, null),
    Object.keys(supportedLang22).filter((l3) => l3 !== lang).map((lang2) => /* @__PURE__ */ h(
      "li",
      {
        class: "text-gray-900 hover:bg-primary hover:bg-gray-300 cursor-pointer relative select-none py-2 pl-3 pr-9",
        role: "option",
        onClick: () => {
          changeLanguage(lang2);
          setHidden(true);
        }
      },
      /* @__PURE__ */ h("span", { class: "font-normal truncate flex justify-between " }, /* @__PURE__ */ h("span", null, getLangName(lang2)), /* @__PURE__ */ h("span", null, completeness[lang2], "%")),
      /* @__PURE__ */ h("span", { class: "text-indigo-600 absolute inset-y-0 right-0 flex items-center pr-4" })
    ))
  ));
}
function Loading() {
  return /* @__PURE__ */ h(
    "div",
    {
      class: "columns is-centered is-vcentered",
      style: {
        width: "100%",
        height: "200px",
        display: "flex",
        margin: "auto",
        justifyContent: "center"
      }
    },
    /* @__PURE__ */ h(Spinner, null)
  );
}
function Spinner() {
  return /* @__PURE__ */ h("div", { class: "lds-ring m-auto" }, /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null));
}
var taler_logo_white_default = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMkAAABaCAYAAAASNHLoAAAAAXNSR0IArs4c6QAAEz5JREFUeJztnXvcXtOVx9dCVIIQ0qLUZVAlxCWkoQxRiqLuFJlBTetWl1GqHTNK1bUzLYZ2XEPr1gt1G0X5xCWpIkho0gZxyQiRiIgIUZHv/GE98fS8a5/L3ud58yY533/e5Jzn+Z31PM/e5+y99lprizQ0NOSiC9qAFsBAEdlURDYRkc1EpL+IrCgiK4jISvaymSJyiKreXUF3NdMdKCKbi8gapr2C6fe2l16tqv9S0eZBpr2x/V25TXfFzMufFZG/iMhY+/czqvpKles1LEYASwJDgH8D/gC8Rz4fAcOBVUpofxYYBlwDvFSgCzAO2K2k3dsDZwEPl9AtwzTgRuBAYKUSJjQs6gDrA/9pjaMsjwKbltAeBoysoDsDOKqE7kbAfwOzIjpBVR4DvgesUNuX3rBwAOwHjIhoNBcU6K4G/BSYWVF3LLBWgfYw4PEIm+tgFnBO83RZxAEU2B8YE9FI3gX2ydFeA7gc+CBC+2ZgmYDuksARwPMRup1gpg3v+nb0x2rIpSMTd2CwiFxlk/CqvCgie6rqeEe3t4icLyInRJp2kqpe7J0AviwiV4jIP0Tovi8iE0Vksoi8JSIz7G9vEekrIsvb31VEZFCE/nQR+VdV/WXEext6GsB5Fe+Ws4HfAadY5wrpbg1MrKj9hM2B9gT6BXSXt6dSFcbY5xwKrB7xHW0LnGqfe3aF694LrFn1eg09BGBjYEKFH/z6vCFVRvuCCrqPAycDa5TQ3QZ4uaTuBOC7wOdq+cI+saE38HXgjpJ2zAKOqdOGhm4A2KeEGxfgRbuDZtcQQrr9S7pb5wDXAZtVsPnbJRvlcGBI0hdU3qZ+wOklny63Act1h10NCQBLABeW+EFfsQnxEhW0twBeK9D9ELgC+GxFu68pYfPPFtTQBljVOmcR44u8dA0LGBtT5/E+cEqE7q4lnkx3A5+vqLss8FCB7sPA2hE2Xwa8ENCcCFwYoTkA+GOBvZOB9atqN3QYYGng/hKNrfKdGPga8Lcc3beAwyJ0Vyyx7nFyVd02/X7A7QX610Vqn1qg+zqwXqztDTVjd+Oile2TIrUPLdAdBawaobsy8EyO7iRg4xibnWsNs9X8EDdH6n4BGJ2j+1rME7ChZmwO8kDOD/UmsG2k9lBgbo72pcBSEbp9ChrXKKB/jM0511yzwGt2TYL2dTm6L8XcRBpqBLg65wd6JtY9CgyyVfYQhyfYfGeObvCubsOz8xKu+2ngyZxrfytB++wc3T/F6jYkYhG7Ie4Dlo/U/RwwNaA7E9ghweZLc2y+Pud9O7d51lLu+svZdxNimwTto3J0/ydWtyESC2sPcWui9iMB3dlATFhLS3ePHJuDE2jgEuf1R0Z/wI81RwXseC0l4regoxySYnNDRXJW0p+weKpY3RMCunOBnRJ0+wFvBLQfDK3XAIfkNLotEuxZMSe35Rexuqb9XwHdd5uJfDcB/DjwI7ySMuEF1slZC4ker5v2DQHdCUV37pxFvJeBPgk2rQ+8HdD+aqyuad8W0G3mJ53GVr1DbJ6oHcovuSJRd9eA7iygVIRvjjfs3ETbdgrovho7p5NPPHhjA9pHpNjcUEDO4ts3E3UPCOg+AyydqB2KFN67gsYawDsBnXUS7QsNj36aqLuBRThkmVY2Vq6hIrYo5vG7GrQnBbRjcjnadU8L6F4UobVvQOu2FBtNe3xA+wuJuqE53qWpNjdksMf364EvPCnoDzgjoHt+ou4qgejZFxI0Qwt3OyfaullA9/4UXdO+N6BdWCegwSe0gn24iHgrtz9S1UmJ1zzROTZVRH6UqHu8iHgT6+8kaB4nIsOd41MSNEVVx1hYv5sIlsjBVj4py6wOXGvxBXjOuRNNSfHumO63Ane5SvWuHN2lgemO7qMpug0NLsAugYZcWH6nhLY3Fp9QJc8koHtEwOatUm1uaOgCcJfT2LoUZYjQHRpoyHvWoP20o5s8vm9o6IKtDHuRuEnDIdO+1nuK1KC7SaDzfSVVu6FBnIn7oSKyZObYbBG5MeUiFuK+r3PqqhRd4yDn2BhVvS/HntVF5IYarh3iNFV9rMwLbah5V8bpMFdEvqaq76UYYa7f9jyZ51Q1KZohcJ1b2+o118UVqtql3dkidtU1pXnmHJokIuNFZKSqxnk9A8GGyQ0Z2NvR/QhYuQZtb80lty6XhYh0kt0r2L9/QKOOOeCjGc2nUjUD15nSge/we4FrhYbtVRkHHFsmR2n+hNnurl7CVFIAnnGgc+z3qjo9RdSquns5LL9O0e1mQuWBju9mOxYW6iqouJGIXCYiDxXdrNu9St4Y/h1VfbgGg7yq7XfUoLurc2yEqiatY3QXlpe+Y+D0gO4qZbSYs42IjMorz9TeSYY65+sIQdnU2atDROS3qdqdsrkbOa7gfFOErnvYQESCJWTbx2Nfds7fWYMBXkMerapvpYgCSwaGh4+UePt0ETmrxOvOcB7vl1it3zyeKxIGPiUi3yh42UHA8ar6TrGpPY6DEyMTXgwcxzk2TkS+XaC3lNVhPi4wRN8b2ENV7/KvCusGJjeFm+YUEajN9ZMadLd1dGsNvQi4w5OCMNu0D3e05zjHUsocLciJe1K0dM61dnSu9ccK718qJxX9Ae89reGWV07nJVV9I/rTfIKXgltHuIinO7IG3e7CG0p5x04Eesy2fT0A70niHXNR1bmqeq6I/Nw5vZ0XetXqJOs6byjdOwvolLZXjO3pGnQ7jqUCZyvoj1DV4SKS9d+vKSLRqcwNQby1ll4i0qUqaKuTeA2ujtVwr4N8oKqTU7UDna9wLtBDONY5drn9vcQ510zga0ZVnxeRN51Tn8keyOskL9Vgi6f7fA26ndbuGLZr1bDM4ekicov9+zoR+SBzfq+m6FxHmOocWzZ7oNVJvKrsE2swolO6Ie3oBKtu5HAR+VTm2FWqOlc+vsO944TMLCEiR3efiYsNXihNl6dLq5N4eeV1LMhlG0NduiHthSGxKLuSjoj8LHPMKy53VGpKQcMnABsFEgu7DNlb6yReg5tXgy1e55tbg25I+6OatDuCVaPMDhP/kM32VNUngHEiMqDt8KoistdCtFh6EzAn4n3/q6o/7oA987F4Lc+79bLn0W11kl7OG+pocJ3SlUDqcY/uJIEJeKgk6UUicqXz/oWlk3wx8n11DcddgA0tZusfndNuZHiroWXD46WmJ4nXkOt6knShNa7viVgQXTZdYIqI3B54y40icnEmhH4nYL3oMO9FA29NpG9BzejlRWRLi9MKudOnBDyL8xvxh865pHx2I+ulEduquSMAfVJzMDrI0c5N40pVdW9GqvoeMDwT36WmU3n3sEUIb2F1YxEZkaD5jm2L7nm75k/c33XOdXGFReBNpOsqlObZ3CM32rQJdza2aJ4zYc/ijZu/aXFfDfUwVUSGquro0Atad7bZzrmFoZNkO8VyAd/3gmZ3x5Nyd1FIv6qOA0aJyJfaDve1bMw68nw6SWyA4+sdsCXEzSJyStHidquTeI25jk7i3e07+STp2FAuEW/CvgdQOubI0evpneQxVa1jQTpLHXFso0RkmKq+XObFrU7iha1H7VqVYaZzLHo/jgxTHXfqOiIypib9WrCKl15yWApDgAGqOq5m3YWVV0Xk6sC5g0QkWz52cMDz6tLqJJ7brY5tj72eujagqhp7F20x0bwV7XjxXAuaY2tMOW3nBBFJzoNfRHhVVc/0Tljt5tEZD24vEbkeGFKmHbYm7l7MU/KWxzbWyw6LegVC86videwe1Uls0Sq5HFOAYakVNRcHVHWMiFzonBosIqV2iW49SbxOskGaefP5i4hkKyluLiLPJup6awUbJmrWzQEiki0y8HpktPKGmQjVPiJyWMAD1vD3nGm/RfbGfw5wZ6l1J6vI7pE8fwB+4ehW3grB0R3o6L5XZ4JSamZiYL/7r0fa4u2P+OeC9ywumYmFSXzA4MDv+VhRm1lCPn4kvSEirzjno3e+bcP7IZN2yTKeFZH3M8d6i8hmNWgnAwzIuG7FHBm3BN5SxPUiko2FGgB4ef4NGVT1cRHx0sYH2/wuSPsK8EgRWStzfoecsImyPOQcGwIso6oxAXAiH39oLLc5W8BiSA/JUPQqoVyjql50QyGqOtv2nc/uaX9MTtpydlK6GuBOcEsySVXLbtl9IvB2wrXGq2rd9dP+XUT2cYZd5wG3qar3oPgE4GjnUfTXVKsAtf0Ksxxcg/bZjm4d9bxa+lHDLdsEydtQKMljGCh+8WGouJoz3EplVOA6najg6D5xY4dbbe8fDMxzNIJVdtrzE7widBsASRN4c7F5cTX7p+gaXuX4XXvAHoH/7MS+jbSU0WhUdaQz6e+kB22Rw4Zd3px4W8AtSzS/k6jqeCsonGW/GmzzSrXsBiyTqPuIs2DZK1BWtTvxvuxs2Hssns6xTUWVSpwemINfCGSnHJLNdPOq2O1Tg1Fewa/eIpK0N4lF0Hr5Fdlxe7cBbJNJlhLryL+q6RLXOlHbnVjVX2RR1fetzkB2ztbbHCR///r2/wCbiMgzju5WeVGSZQAeFJHtM4dHq2rSblTAvgGP0Rft0Zqivb2zWv6nPIeDhaFk5y1vqar3vcbataUT3DlJVV/MvG7zGsOARERmqmoXp4jdGJK2FneY5oXd2FA668F07Soi8D2KiDyem3IR2LIt1m3ZrntoYIKW5MLM2S/x5lSbGxpcgGOcBjcPWDtRd2ngbUfbr71aTfvMQAfsMr5saEgG6AW85TS439Sg/ZNAY86O4avqfiZQR/faVJsbGlyAswKNORt1W1V3tYBuHU+TKwPaXcpWNjRUwXUbAp+2MPesr/+vqpoURAhcFijzebCqRs8jbMLsufVuUdWoNRnbScvzwN1vaxbR2HZnWRf4B6p6XqLu9qF9W1R1bIp2Qwbgh4E78w8SdVe1VeIs04F+idoXB2wO7SaVp9UnsB/jHKB/op2nBOw8O1G3f2CoPBXonaLd4GCNxPMafQgMTNT+eaCR3JSouxLwrqP7KlApHRm4qkMN+fMB3WlVbXS07wloNwW3OwVwfOBLHw+UTn90dPvZ3c3jkESbTw7olt5FGNg5oPF6apQA8HhAu2jXqyLdYQHdHpXOvEgCjAl8+cMTdb8a0J0DJIW7A08FtL25UPa9a9ld3cPbi76KXTcEdJ9I1N3Ecmk8BqVoN5QA2CDw5QMkFUkDbgroTgZWS9DdKMfm4JMK6Gv7e3v8PvqDfqx9Yo5N3q5dZXVXteGkx+UlJBrqIJAV1yI6/srmEJMDuk+kDG2AkwK6XWJz2t5zX+A9U1Im68AuOd/fiQm6fYDRAd0JTQ58NwPcmvNDRwfXAVvm6N6bMpnNDG9mAsHoYODqHDs8l2pZG3bMGQpFJ7RZB3kkoPte6gJtQwTAMsCTgR/lA2CXBO0Dcxroo7G59hYK86TlmrvDN9uN9dc51z804XNtH4gEwOZNUXd6+y1GBXTnpvwWDYmYH/7FnAaV3easinYoZAXg2djt0ABvN6PWueWBETnXPSPh8+yVo/tCKJuwhG5/4KEc7SQvWUMNAOvluG8Bzk/Q/mWO7ivAkBo/x+rA2Jzrebk1ZbVDi5oAM4CommbAlwpSZc+NtbmhZszlODPnx7oH8PY0LKN9fY4uwA9rsP+wQN59iwcjddcFni6w39s8poz2GQW6yQGoDTUDbFHQ0N4FvgtUSsYBlgB+U9Agnoqp62RDlbsLtO+JWJ1fGvhBzvwD+64ql2gCtspxS7e4yapFNvQ0gK0DsULtPBfjJgb2AL5juSJn2ur/fnbNSnkiQG9biffCbNpxdzoq0P6KfcY8XraNLKvo9i/wuLWInjc1dBPAmsCfS/yYD1ZtKDXY1ts6WlHJmw+rOh2AocDDJT73w3nOA0d3JeD8QAxaO+8Bu0d9MQ3dj/nsf1WiwQDcn+IFK2nPZsAFwBsl7Pm/KnkywP7W4cvgFWoO6W4CXFiic2ALhXUUHW/oboADclbQs8w0b9Z+QPLmO9bITi8xfm/nCiB3Czm7s+8J3BgoOOfxPLB1CZsHAf9R8knc4pzU76qhGrXXarIFsjNE5LSKbx0pIhOswv0LIjJZRGaIyAxVnWqT6b62k2pfEekvIltbWdOt7XhZnhORI0OJU8CRtoXbICvXU4XzVfX7Ad21ReRUq7JftUrMaBH5hqqmVuNv6CkA6xeEsiwI3iEnacxC+G+L1L7H9ggPaR9cciiV5U3g+I79UA0LHmCHEmsHnWaWTYaDmY/AdjnRtHk8AGSrx7frLgtcF6E7zTIYmyDFxQErmr0z8FvgbxENJpYZVtQiN/YLOC9C+66iCABgCDCxou4088g16baLK+b//35BzFQK44GLgN1K2LJDiTWOFrOB260uWe46DbAicHkFm58yz1blXPyGzrPAiyxbw9hORLYUkU0r7vo7R0TGWWnW0SJyh6q+WuKaK1tl8TxX9CTTfUpERqhqqVAV4J9ss5hQ/sls29horIg8YTb3xL3nG4wF3kmymDt4YGaDoXbmich0EXlDVd+MvMZAEfEW+Gabrlddv4xuP+voWT4SkWkiMlVVve3AGxoaGhZe/h9QuXqeN+/kOgAAAABJRU5ErkJggg==";
function Header({
  title,
  profileURL,
  notificationURL,
  iconLinkURL,
  sites,
  onLogout,
  children
}) {
  const { i18n: i18n4 } = useTranslationContext();
  const [open, setOpen] = p3(false);
  const ns = useNotifications();
  return /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h("header", { class: "bg-primary w-full mx-auto px-2 border-b border-opacity-25 border-indigo-400" }, /* @__PURE__ */ h("div", { class: "flex flex-row h-16 items-center " }, /* @__PURE__ */ h("div", { class: "flex px-2 justify-start" }, /* @__PURE__ */ h("div", { class: "flex-shrink-0 rounded-lg" }, /* @__PURE__ */ h("a", { href: iconLinkURL ?? "#", name: "logo" }, /* @__PURE__ */ h("img", { class: "h-8 w-auto m-1", src: taler_logo_white_default, alt: "GNU Taler" }))), /* @__PURE__ */ h("span", { class: "flex items-center text-white text-lg font-bold ml-4" }, title)), /* @__PURE__ */ h("div", { class: "flex-1 ml-6 " }, /* @__PURE__ */ h("div", { class: "flex flex-1 space-x-4" }, sites.map((site) => {
    if (site.length !== 2)
      return;
    const [name, url] = site;
    return /* @__PURE__ */ h(
      "a",
      {
        href: url,
        name: `site header ${name}`,
        class: "hidden sm:block text-white hover:bg-indigo-500 hover:bg-opacity-75 rounded-md py-2 px-3 text-sm font-medium"
      },
      name
    );
  }))), /* @__PURE__ */ h("div", { class: "flex justify-end" }, !notificationURL ? void 0 : /* @__PURE__ */ h(
    "a",
    {
      href: notificationURL,
      name: "notifications",
      class: "relative inline-flex items-center justify-center rounded-md bg-primary p-1 mr-2 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false"
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Show notifications")),
    ns.length > 0 ? /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 24 24",
        fill: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h("path", { d: "M5.85 3.5a.75.75 0 0 0-1.117-1 9.719 9.719 0 0 0-2.348 4.876.75.75 0 0 0 1.479.248A8.219 8.219 0 0 1 5.85 3.5ZM19.267 2.5a.75.75 0 1 0-1.118 1 8.22 8.22 0 0 1 1.987 4.124.75.75 0 0 0 1.48-.248A9.72 9.72 0 0 0 19.266 2.5Z" }),
      /* @__PURE__ */ h(
        "path",
        {
          "fill-rule": "evenodd",
          d: "M12 2.25A6.75 6.75 0 0 0 5.25 9v.75a8.217 8.217 0 0 1-2.119 5.52.75.75 0 0 0 .298 1.206c1.544.57 3.16.99 4.831 1.243a3.75 3.75 0 1 0 7.48 0 24.583 24.583 0 0 0 4.83-1.244.75.75 0 0 0 .298-1.205 8.217 8.217 0 0 1-2.118-5.52V9A6.75 6.75 0 0 0 12 2.25ZM9.75 18c0-.034 0-.067.002-.1a25.05 25.05 0 0 0 4.496 0l.002.1a2.25 2.25 0 1 1-4.5 0Z",
          "clip-rule": "evenodd"
        }
      )
    ) : /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "1.5",
        stroke: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M14.857 17.082a23.848 23.848 0 0 0 5.454-1.31A8.967 8.967 0 0 1 18 9.75V9A6 6 0 0 0 6 9v.75a8.967 8.967 0 0 1-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 0 1-5.714 0m5.714 0a3 3 0 1 1-5.714 0"
        }
      )
    )
  ), !profileURL ? void 0 : /* @__PURE__ */ h(
    "a",
    {
      href: profileURL,
      name: "profile",
      class: "relative inline-flex items-center justify-center rounded-md bg-primary p-1 mr-2 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false"
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Open profile")),
    /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "1.5",
        stroke: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"
        }
      )
    )
  ), /* @__PURE__ */ h(LangSelector, { type: "icon" }), /* @__PURE__ */ h(
    "button",
    {
      type: "button",
      name: "toggle sidebar",
      class: "relative inline-flex items-center justify-center rounded-md bg-primary p-1 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false",
      onClick: (e22) => {
        setOpen(!open);
      }
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Open settings")),
    /* @__PURE__ */ h(
      "svg",
      {
        class: "block h-10 w-10",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "2",
        stroke: "currentColor",
        "aria-hidden": "true"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"
        }
      )
    )
  )))), open && /* @__PURE__ */ h(
    "div",
    {
      class: "relative z-10",
      name: "sidebar overlay",
      "aria-labelledby": "slide-over-title",
      role: "dialog",
      "aria-modal": "true",
      onClick: () => {
        setOpen(false);
      }
    },
    /* @__PURE__ */ h("div", { class: "fixed inset-0" }),
    /* @__PURE__ */ h("div", { class: "fixed inset-0 overflow-hidden" }, /* @__PURE__ */ h("div", { class: "absolute inset-0 overflow-hidden" }, /* @__PURE__ */ h("div", { class: "pointer-events-none fixed inset-y-0 right-0 flex max-w-full pl-10" }, /* @__PURE__ */ h("div", { class: "pointer-events-auto w-screen max-w-md" }, /* @__PURE__ */ h(
      "div",
      {
        class: "flex h-full flex-col overflow-y-scroll bg-white py-6 shadow-xl",
        onClick: (e22) => {
          e22.stopPropagation();
        }
      },
      /* @__PURE__ */ h("div", { class: "px-4 sm:px-6" }, /* @__PURE__ */ h("div", { class: "flex items-start justify-between" }, /* @__PURE__ */ h(
        "h2",
        {
          class: "text-base font-semibold leading-6 text-gray-900",
          id: "slide-over-title"
        },
        /* @__PURE__ */ h(i18n4.Translate, null, "Menu")
      ), /* @__PURE__ */ h("div", { class: "ml-3 flex h-7 items-center" }, /* @__PURE__ */ h(
        "button",
        {
          type: "button",
          name: "close sidebar",
          class: "relative rounded-md bg-white text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2",
          onClick: (e22) => {
            setOpen(false);
          }
        },
        /* @__PURE__ */ h("span", { class: "absolute -inset-2.5" }),
        /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Close panel")),
        /* @__PURE__ */ h(
          "svg",
          {
            class: "h-6 w-6",
            fill: "none",
            viewBox: "0 0 24 24",
            "stroke-width": "1.5",
            stroke: "currentColor",
            "aria-hidden": "true"
          },
          /* @__PURE__ */ h(
            "path",
            {
              "stroke-linecap": "round",
              "stroke-linejoin": "round",
              d: "M6 18L18 6M6 6l12 12"
            }
          )
        )
      )))),
      /* @__PURE__ */ h("div", { class: "relative mt-6 flex-1 px-4 sm:px-6" }, /* @__PURE__ */ h("nav", { class: "flex flex-1 flex-col", "aria-label": "Sidebar" }, /* @__PURE__ */ h("ul", { role: "list", class: "flex flex-1 flex-col gap-y-7" }, onLogout ? /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(
        "a",
        {
          href: "#",
          name: "logout",
          class: "text-gray-700 hover:text-indigo-600 hover:bg-gray-100 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold",
          onClick: () => {
            onLogout();
            setOpen(false);
          }
        },
        /* @__PURE__ */ h(
          "svg",
          {
            class: "h-6 w-6 shrink-0 text-indigo-600",
            fill: "none",
            viewBox: "0 0 24 24",
            "stroke-width": "1.5",
            stroke: "currentColor",
            "aria-hidden": "true"
          },
          /* @__PURE__ */ h(
            "path",
            {
              "stroke-linecap": "round",
              "stroke-linejoin": "round",
              d: "M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
            }
          )
        ),
        /* @__PURE__ */ h(i18n4.Translate, null, "Log out")
      )) : void 0, /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(LangSelector, null)), children, sites.length > 0 ? /* @__PURE__ */ h("li", { class: "block sm:hidden" }, /* @__PURE__ */ h("div", { class: "text-xs font-semibold leading-6 text-gray-400" }, /* @__PURE__ */ h(i18n4.Translate, null, "Sites")), /* @__PURE__ */ h("ul", { role: "list", class: "space-y-1" }, sites.map(([name, url]) => {
        return /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(
          "a",
          {
            href: url,
            name: `site ${name}`,
            target: "_blank",
            rel: "noopener noreferrer",
            class: "text-gray-700 hover:text-indigo-600 hover:bg-gray-100 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"
          },
          /* @__PURE__ */ h("span", { class: "flex h-6 w-6 shrink-0 items-center justify-center rounded-lg border text-[0.625rem] font-medium bg-white text-gray-400 border-gray-200 group-hover:border-indigo-600 group-hover:text-indigo-600" }, ">"),
          /* @__PURE__ */ h("span", { class: "truncate" }, name)
        ));
      }))) : void 0)))
    )))))
  ));
}
function Footer({
  testingUrlKey,
  VERSION: VERSION2,
  GIT_HASH: GIT_HASH2
}) {
  const { i18n: i18n4 } = useTranslationContext();
  const testingUrl = testingUrlKey && typeof localStorage !== "undefined" && localStorage.getItem(testingUrlKey) ? localStorage.getItem(testingUrlKey) ?? void 0 : void 0;
  const versionText = VERSION2 ? GIT_HASH2 ? /* @__PURE__ */ h(
    "a",
    {
      href: `https://git.taler.net/wallet-core.git/tree/?id=${GIT_HASH2}`,
      target: "_blank",
      rel: "noreferrer noopener"
    },
    "Version ",
    VERSION2,
    " (",
    GIT_HASH2.substring(0, 8),
    ")"
  ) : VERSION2 : "";
  return /* @__PURE__ */ h("footer", { class: "bottom-4 my-4 mx-8 bg-slate-200" }, /* @__PURE__ */ h("div", null, /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-400" }, /* @__PURE__ */ h(i18n4.Translate, null, "Learn more about", " ", /* @__PURE__ */ h(
    "a",
    {
      target: "_blank",
      rel: "noreferrer noopener",
      class: "font-semibold text-gray-500 hover:text-gray-400",
      href: "https://taler.net"
    },
    "GNU Taler"
  )))), /* @__PURE__ */ h("div", { style: "flex-grow:1" }), /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-400" }, "Copyright \xA9 2014\u20142025 Taler Systems SA. ", versionText, " "), testingUrlKey && testingUrl && /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-300" }, "Testing with ", testingUrl, " ", /* @__PURE__ */ h(
    "a",
    {
      href: "",
      onClick: (e22) => {
        e22.preventDefault();
        localStorage.removeItem(testingUrlKey);
        window.location.reload();
      }
    },
    "stop testing"
  )));
}
function ButtonBetter({
  children,
  onClick,
  ...rest
}) {
  const [running, setRunning] = p3(false);
  return /* @__PURE__ */ h(
    "button",
    {
      type: "button",
      ...rest,
      disabled: running || !onClick || !onClick.args,
      onClick: (e22) => {
        e22.preventDefault();
        if (!onClick || !onClick.args) {
          return;
        }
        setRunning(true);
        onClick.call().finally(() => {
          setRunning(false);
        });
      }
    },
    running ? /* @__PURE__ */ h(Wait, null) : children
  );
}
function Wait() {
  return /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h("div", { id: "l1" }));
}
function LocalNotificationBanner({
  notification
}) {
  if (!notification)
    return /* @__PURE__ */ h(p2, null);
  switch (notification.message.type) {
    case "error":
      return /* @__PURE__ */ h("div", { class: "relative" }, /* @__PURE__ */ h("div", { class: "fixed top-0 left-0 right-0 z-20 w-full p-4" }, /* @__PURE__ */ h(
        Attention,
        {
          type: "danger",
          title: notification.message.title,
          onClose: () => {
            notification.acknowledge();
          }
        },
        notification.message.description && /* @__PURE__ */ h("div", { class: "mt-2 text-sm text-red-700" }, notification.message.description),
        /* @__PURE__ */ h(DebugInfo, { error: notification.message.debug })
      )));
    case "info":
      return /* @__PURE__ */ h("div", { class: "relative" }, /* @__PURE__ */ h("div", { class: "fixed top-0 left-0 right-0 z-20 w-full p-4" }, /* @__PURE__ */ h(
        Attention,
        {
          type: "success",
          title: notification.message.title,
          onClose: () => {
            notification.acknowledge();
          }
        }
      )));
  }
}
function ToastBanner({ debug }) {
  const notifs = useNotifications();
  if (notifs.length === 0)
    return /* @__PURE__ */ h(p2, null);
  const show = notifs.filter((e22) => !e22.message.ack && !e22.message.timeout);
  if (show.length === 0)
    return /* @__PURE__ */ h(p2, null);
  return /* @__PURE__ */ h(AttentionByType, { msg: show[0], debug });
}
function AttentionByType({
  msg,
  debug
}) {
  switch (msg.message.type) {
    case "error":
      return /* @__PURE__ */ h(
        Attention,
        {
          type: "danger",
          title: msg.message.title,
          onClose: () => {
            msg.acknowledge();
          },
          timeout: debug ? Duration.getForever() : GLOBAL_NOTIFICATION_TIMEOUT
        },
        msg.message.description && /* @__PURE__ */ h("div", { class: "mt-2 text-sm text-red-700" }, msg.message.description),
        !debug ? void 0 : /* @__PURE__ */ h("pre", null, msg.message.debug)
      );
    case "info":
      return /* @__PURE__ */ h(
        Attention,
        {
          type: "success",
          title: msg.message.title,
          onClose: () => {
            msg.acknowledge();
          },
          timeout: GLOBAL_NOTIFICATION_TIMEOUT
        }
      );
  }
}
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}
function _typeof2(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof2 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof2 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof2(obj);
}
function add2(dirtyDate, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof2(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var date = toDate(dirtyDate);
  var dateWithMonths = months || years ? addMonths(date, months + years * 12) : date;
  var dateWithDays = days || weeks ? addDays(dateWithMonths, days + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}
function addMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var timestamp = toDate(dirtyDate).getTime();
  var amount = toInteger(dirtyAmount);
  return new Date(timestamp + amount);
}
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}
function compareAsc(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var diff = dateLeft.getTime() - dateRight.getTime();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
var daysInYear = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute = 6e4;
var millisecondsInHour = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var secondsInHour = 3600;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;
function isSameDay(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
  var dateRightStartOfDay = startOfDay(dirtyDateRight);
  return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
}
function _typeof3(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof3 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof3 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof3(obj);
}
function isDate(value) {
  requiredArgs(1, arguments);
  return value instanceof Date || _typeof3(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}
function isValid(dirtyDate) {
  requiredArgs(1, arguments);
  if (!isDate(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate(dirtyDate);
  return !isNaN(Number(date));
}
function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
  var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
  return yearDiff * 12 + monthDiff;
}
function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  return dateLeft.getFullYear() - dateRight.getFullYear();
}
function compareLocalAsc(dateLeft, dateRight) {
  var diff = dateLeft.getFullYear() - dateRight.getFullYear() || dateLeft.getMonth() - dateRight.getMonth() || dateLeft.getDate() - dateRight.getDate() || dateLeft.getHours() - dateRight.getHours() || dateLeft.getMinutes() - dateRight.getMinutes() || dateLeft.getSeconds() - dateRight.getSeconds() || dateLeft.getMilliseconds() - dateRight.getMilliseconds();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
function differenceInDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareLocalAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarDays(dateLeft, dateRight));
  dateLeft.setDate(dateLeft.getDate() - sign2 * difference);
  var isLastDayNotFull = Number(compareLocalAsc(dateLeft, dateRight) === -sign2);
  var result = sign2 * (difference - isLastDayNotFull);
  return result === 0 ? 0 : result;
}
function differenceInMilliseconds(dateLeft, dateRight) {
  requiredArgs(2, arguments);
  return toDate(dateLeft).getTime() - toDate(dateRight).getTime();
}
var roundingMap = {
  ceil: Math.ceil,
  round: Math.round,
  floor: Math.floor,
  trunc: function trunc(value) {
    return value < 0 ? Math.ceil(value) : Math.floor(value);
  }
  // Math.trunc is not supported by IE
};
var defaultRoundingMethod = "trunc";
function getRoundingMethod(method) {
  return method ? roundingMap[method] : roundingMap[defaultRoundingMethod];
}
function differenceInHours(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInHour;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInMinutes(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInMinute;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function endOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function isLastDayOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  return endOfDay(date).getTime() === endOfMonth(date).getTime();
}
function differenceInMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarMonths(dateLeft, dateRight));
  var result;
  if (difference < 1) {
    result = 0;
  } else {
    if (dateLeft.getMonth() === 1 && dateLeft.getDate() > 27) {
      dateLeft.setDate(30);
    }
    dateLeft.setMonth(dateLeft.getMonth() - sign2 * difference);
    var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign2;
    if (isLastDayOfMonth(toDate(dirtyDateLeft)) && difference === 1 && compareAsc(dirtyDateLeft, dateRight) === 1) {
      isLastMonthNotFull = false;
    }
    result = sign2 * (difference - Number(isLastMonthNotFull));
  }
  return result === 0 ? 0 : result;
}
function differenceInSeconds(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / 1e3;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarYears(dateLeft, dateRight));
  dateLeft.setFullYear(1584);
  dateRight.setFullYear(1584);
  var isLastYearNotFull = compareAsc(dateLeft, dateRight) === -sign2;
  var result = sign2 * (difference - Number(isLastYearNotFull));
  return result === 0 ? 0 : result;
}
function eachDayOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate(interval.start);
  var endDate = toDate(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate(currentDate));
    currentDate.setDate(currentDate.getDate() + step);
    currentDate.setHours(0, 0, 0, 0);
  }
  return dates;
}
function startOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setDate(1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}
function subMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMilliseconds(dirtyDate, -amount);
}
var MILLISECONDS_IN_DAY2 = 864e5;
function getUTCDayOfYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference = timestamp - startOfYearTimestamp;
  return Math.floor(difference / MILLISECONDS_IN_DAY2) + 1;
}
function startOfUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getUTCISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek(fourthOfJanuary);
  return date;
}
var MILLISECONDS_IN_WEEK = 6048e5;
function getUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
}
function startOfUTCWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek(firstWeek, options);
  return date;
}
var MILLISECONDS_IN_WEEK2 = 6048e5;
function getUTCWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK2) + 1;
}
function addLeadingZeros(number, targetLength) {
  var sign2 = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign2 + output;
}
var formatters = {
  // Year
  y: function y3(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },
  // Month
  M: function M4(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },
  // Day of the month
  d: function d3(date, token) {
    return addLeadingZeros(date.getUTCDate(), token.length);
  },
  // AM or PM
  a: function a3(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h: function h12(date, token) {
    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
  },
  // Hour [0-23]
  H: function H3(date, token) {
    return addLeadingZeros(date.getUTCHours(), token.length);
  },
  // Minute
  m: function m3(date, token) {
    return addLeadingZeros(date.getUTCMinutes(), token.length);
  },
  // Second
  s: function s3(date, token) {
    return addLeadingZeros(date.getUTCSeconds(), token.length);
  },
  // Fraction of second
  S: function S3(date, token) {
    var numberOfDigits = token.length;
    var milliseconds = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros(fractionalSeconds, token.length);
  }
};
var lightFormatters_default = formatters;
var dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters2 = {
  // Era
  G: function G2(date, token, localize52) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize52.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize52.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize52.era(era, {
          width: "wide"
        });
    }
  },
  // Year
  y: function y22(date, token, localize52) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize52.ordinalNumber(year, {
        unit: "year"
      });
    }
    return lightFormatters_default.y(date, token);
  },
  // Local week-numbering year
  Y: function Y3(date, token, localize52, options) {
    var signedWeekYear = getUTCWeekYear(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize52.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros(weekYear, token.length);
  },
  // ISO week-numbering year
  R: function R2(date, token) {
    var isoWeekYear = getUTCISOWeekYear(date);
    return addLeadingZeros(isoWeekYear, token.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function u3(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros(year, token.length);
  },
  // Quarter
  Q: function Q2(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros(quarter, 2);
      case "Qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function q4(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros(quarter, 2);
      case "qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function M22(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters_default.M(date, token);
      case "Mo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize52.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize52.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone month
  L: function L4(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros(month + 1, 2);
      case "Lo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize52.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize52.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Local week of year
  w: function w4(date, token, localize52, options) {
    var week = getUTCWeek(date, options);
    if (token === "wo") {
      return localize52.ordinalNumber(week, {
        unit: "week"
      });
    }
    return addLeadingZeros(week, token.length);
  },
  // ISO week of year
  I: function I4(date, token, localize52) {
    var isoWeek = getUTCISOWeek(date);
    if (token === "Io") {
      return localize52.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros(isoWeek, token.length);
  },
  // Day of the month
  d: function d22(date, token, localize52) {
    if (token === "do") {
      return localize52.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return lightFormatters_default.d(date, token);
  },
  // Day of year
  D: function D4(date, token, localize52) {
    var dayOfYear = getUTCDayOfYear(date);
    if (token === "Do") {
      return localize52.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros(dayOfYear, token.length);
  },
  // Day of week
  E: function E2(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function e3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      case "eo":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function c3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      case "co":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function i3(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      case "io":
        return localize52.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function a22(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function b3(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function B4(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function h13(date, token, localize52) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0)
        hours = 12;
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return lightFormatters_default.h(date, token);
  },
  // Hour [0-23]
  H: function H22(date, token, localize52) {
    if (token === "Ho") {
      return localize52.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return lightFormatters_default.H(date, token);
  },
  // Hour [0-11]
  K: function K4(date, token, localize52) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Hour [1-24]
  k: function k4(date, token, localize52) {
    var hours = date.getUTCHours();
    if (hours === 0)
      hours = 24;
    if (token === "ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Minute
  m: function m22(date, token, localize52) {
    if (token === "mo") {
      return localize52.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return lightFormatters_default.m(date, token);
  },
  // Second
  s: function s22(date, token, localize52) {
    if (token === "so") {
      return localize52.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return lightFormatters_default.s(date, token);
  },
  // Fraction of second
  S: function S22(date, token) {
    return lightFormatters_default.S(date, token);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function X3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function x4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (GMT)
  O: function O3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (specific non-location)
  z: function z4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Seconds timestamp
  t: function t3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros(timestamp, token.length);
  },
  // Milliseconds timestamp
  T: function T4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros(timestamp, token.length);
  }
};
function formatTimezoneShort(offset, dirtyDelimiter) {
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign2 + String(hours);
  }
  var delimiter2 = dirtyDelimiter || "";
  return sign2 + String(hours) + delimiter2 + addLeadingZeros(minutes, 2);
}
function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
  if (offset % 60 === 0) {
    var sign2 = offset > 0 ? "-" : "+";
    return sign2 + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, dirtyDelimiter);
}
function formatTimezone(offset, dirtyDelimiter) {
  var delimiter2 = dirtyDelimiter || "";
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros(absOffset % 60, 2);
  return sign2 + hours + delimiter2 + minutes;
}
var formatters_default = formatters2;
var dateLongFormatter = function dateLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "P":
      return formatLong62.date({
        width: "short"
      });
    case "PP":
      return formatLong62.date({
        width: "medium"
      });
    case "PPP":
      return formatLong62.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong62.date({
        width: "full"
      });
  }
};
var timeLongFormatter = function timeLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "p":
      return formatLong62.time({
        width: "short"
      });
    case "pp":
      return formatLong62.time({
        width: "medium"
      });
    case "ppp":
      return formatLong62.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong62.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong62) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong62);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong62.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong62.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong62.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong62.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong62)).replace("{{time}}", timeLongFormatter(timePattern, formatLong62));
};
var longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter
};
var longFormatters_default = longFormatters;
var protectedDayOfYearTokens = ["D", "DD"];
var protectedWeekYearTokens = ["YY", "YYYY"];
function isProtectedDayOfYearToken(token) {
  return protectedDayOfYearTokens.indexOf(token) !== -1;
}
function isProtectedWeekYearToken(token) {
  return protectedWeekYearTokens.indexOf(token) !== -1;
}
function throwProtectedError(token, format22, input) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance = function formatDistance2(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance_default = formatDistance;
function buildFormatLongFn(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format22 = args.formats[width] || args.formats[args.defaultWidth];
    return format22;
  };
}
var dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full"
  })
};
var formatLong_default = formatLong;
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
var formatRelative_default = formatRelative;
function buildLocalizeFn(args) {
  return function(dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index];
  };
}
var eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize = {
  ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide"
  })
};
var localize_default = localize;
function buildMatchFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}
function buildMatchPatternFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult)
      return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult)
      return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any"
  })
};
var match_default = match;
var locale = {
  code: "en-US",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var en_US_default = locale;
var defaultLocale_default = en_US_default;
var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp = /^'([^]*?)'?$/;
var doubleQuoteRegExp = /''/g;
var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
function format(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions2 = getDefaultOptions();
  var locale62 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale62.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale62.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate(dirtyDate);
  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
  var utcDate = subMilliseconds(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale62,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale62.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString(substring);
    }
    var formatter = formatters_default[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale62.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString(input) {
  var matched = input.match(escapedStringRegExp);
  if (!matched) {
    return input;
  }
  return matched[1].replace(doubleQuoteRegExp, "'");
}
function assign(target, object) {
  if (target == null) {
    throw new TypeError("assign requires that input parameter not be null or undefined");
  }
  for (var property in object) {
    if (Object.prototype.hasOwnProperty.call(object, property)) {
      ;
      target[property] = object[property];
    }
  }
  return target;
}
function getMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  return month;
}
function getYear(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getFullYear();
}
function intervalToDuration(interval) {
  requiredArgs(1, arguments);
  var start = toDate(interval.start);
  var end = toDate(interval.end);
  if (isNaN(start.getTime()))
    throw new RangeError("Start Date is invalid");
  if (isNaN(end.getTime()))
    throw new RangeError("End Date is invalid");
  var duration = {};
  duration.years = Math.abs(differenceInYears(end, start));
  var sign2 = compareAsc(end, start);
  var remainingMonths = add2(start, {
    years: sign2 * duration.years
  });
  duration.months = Math.abs(differenceInMonths(end, remainingMonths));
  var remainingDays = add2(remainingMonths, {
    months: sign2 * duration.months
  });
  duration.days = Math.abs(differenceInDays(end, remainingDays));
  var remainingHours = add2(remainingDays, {
    days: sign2 * duration.days
  });
  duration.hours = Math.abs(differenceInHours(end, remainingHours));
  var remainingMinutes = add2(remainingHours, {
    hours: sign2 * duration.hours
  });
  duration.minutes = Math.abs(differenceInMinutes(end, remainingMinutes));
  var remainingSeconds = add2(remainingMinutes, {
    minutes: sign2 * duration.minutes
  });
  duration.seconds = Math.abs(differenceInSeconds(end, remainingSeconds));
  return duration;
}
function isFuture(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getTime() > Date.now();
}
function _typeof4(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof4 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof4 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof4(obj);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o3, p4) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf(o3, p4);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self2, call) {
  if (call && (_typeof4(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf(o3) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf(o3);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var TIMEZONE_UNIT_PRIORITY = 10;
var Setter = /* @__PURE__ */ function() {
  function Setter2() {
    _classCallCheck(this, Setter2);
    _defineProperty(this, "subPriority", 0);
  }
  _createClass(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = /* @__PURE__ */ function(_Setter) {
  _inherits(ValueSetter2, _Setter);
  var _super = _createSuper(ValueSetter2);
  function ValueSetter2(value, validateValue, setValue, priority, subPriority) {
    var _this;
    _classCallCheck(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue;
    _this.setValue = setValue;
    _this.priority = priority;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set(utcDate, flags, options) {
      return this.setValue(utcDate, flags, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
var DateToSystemTimezoneSetter = /* @__PURE__ */ function(_Setter2) {
  _inherits(DateToSystemTimezoneSetter2, _Setter2);
  var _super2 = _createSuper(DateToSystemTimezoneSetter2);
  function DateToSystemTimezoneSetter2() {
    var _this2;
    _classCallCheck(this, DateToSystemTimezoneSetter2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this2 = _super2.call.apply(_super2, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this2), "priority", TIMEZONE_UNIT_PRIORITY);
    _defineProperty(_assertThisInitialized(_this2), "subPriority", -1);
    return _this2;
  }
  _createClass(DateToSystemTimezoneSetter2, [{
    key: "set",
    value: function set(date, flags) {
      if (flags.timestampIsSet) {
        return date;
      }
      var convertedDate = /* @__PURE__ */ new Date(0);
      convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
      convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
      return convertedDate;
    }
  }]);
  return DateToSystemTimezoneSetter2;
}(Setter);
function _classCallCheck2(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties2(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass2(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties2(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties2(Constructor, staticProps);
  return Constructor;
}
var Parser = /* @__PURE__ */ function() {
  function Parser2() {
    _classCallCheck2(this, Parser2);
  }
  _createClass2(Parser2, [{
    key: "run",
    value: function run(dateString, token, match52, options) {
      var result = this.parse(dateString, token, match52, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();
function _typeof5(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof5 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof5 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof5(obj);
}
function _classCallCheck3(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties3(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass3(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties3(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties3(Constructor, staticProps);
  return Constructor;
}
function _inherits2(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf2(subClass, superClass);
}
function _setPrototypeOf2(o3, p4) {
  _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf2(o3, p4);
}
function _createSuper2(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct2();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf2(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf2(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn2(this, result);
  };
}
function _possibleConstructorReturn2(self2, call) {
  if (call && (_typeof5(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized2(self2);
}
function _assertThisInitialized2(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct2() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf2(o3) {
  _getPrototypeOf2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf2(o3);
}
function _defineProperty2(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var EraParser = /* @__PURE__ */ function(_Parser) {
  _inherits2(EraParser2, _Parser);
  var _super = _createSuper2(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck3(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty2(_assertThisInitialized2(_this), "priority", 140);
    _defineProperty2(_assertThisInitialized2(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass3(EraParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match52.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match52.era(dateString, {
            width: "wide"
          }) || match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      flags.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);
var numericPatterns = {
  month: /^(1[0-2]|0?\d)/,
  // 0 to 12
  date: /^(3[0-1]|[0-2]?\d)/,
  // 0 to 31
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  // 0 to 366
  week: /^(5[0-3]|[0-4]?\d)/,
  // 0 to 53
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  // 0 to 23
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  // 0 to 24
  hour11h: /^(1[0-1]|0?\d)/,
  // 0 to 11
  hour12h: /^(1[0-2]|0?\d)/,
  // 0 to 12
  minute: /^[0-5]?\d/,
  // 0 to 59
  second: /^[0-5]?\d/,
  // 0 to 59
  singleDigit: /^\d/,
  // 0 to 9
  twoDigits: /^\d{1,2}/,
  // 0 to 99
  threeDigits: /^\d{1,3}/,
  // 0 to 999
  fourDigits: /^\d{1,4}/,
  // 0 to 9999
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  // 0 to 9, -0 to -9
  twoDigitsSigned: /^-?\d{1,2}/,
  // 0 to 99, -0 to -99
  threeDigitsSigned: /^-?\d{1,3}/,
  // 0 to 999, -0 to -999
  fourDigitsSigned: /^-?\d{1,4}/
  // 0 to 9999, -0 to -9999
};
var timezonePatterns = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign2 = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign2 * (hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned(dateString) {
  return parseNumericPattern(numericPatterns.anyDigitsSigned, dateString);
}
function parseNDigits(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigit, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigits, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigits, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigits, dateString);
    default:
      return parseNumericPattern(new RegExp("^\\d{1," + n2 + "}"), dateString);
  }
}
function parseNDigitsSigned(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern(new RegExp("^-?\\d{1," + n2 + "}"), dateString);
  }
}
function dayPeriodEnumToHours(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function _typeof6(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof6 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof6 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof6(obj);
}
function _classCallCheck4(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties4(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass4(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties4(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties4(Constructor, staticProps);
  return Constructor;
}
function _inherits3(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf3(subClass, superClass);
}
function _setPrototypeOf3(o3, p4) {
  _setPrototypeOf3 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf3(o3, p4);
}
function _createSuper3(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct3();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf3(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf3(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn3(this, result);
  };
}
function _possibleConstructorReturn3(self2, call) {
  if (call && (_typeof6(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized3(self2);
}
function _assertThisInitialized3(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct3() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf3(o3) {
  _getPrototypeOf3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf3(o3);
}
function _defineProperty3(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var YearParser = /* @__PURE__ */ function(_Parser) {
  _inherits3(YearParser2, _Parser);
  var _super = _createSuper3(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck4(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty3(_assertThisInitialized3(_this), "priority", 130);
    _defineProperty3(_assertThisInitialized3(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass4(YearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits(4, dateString), valueCallback92);
        case "yo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback92);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);
function _typeof7(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof7 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof7 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof7(obj);
}
function _classCallCheck5(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties5(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass5(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties5(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties5(Constructor, staticProps);
  return Constructor;
}
f