This directory contain fuzzer main functions and scripts for the
Google OSS Fuzz project: https://github.com/google/oss-fuzz/

The main Dockerfile is in:
https://github.com/google/oss-fuzz/blob/master/projects/mapserver/Dockerfile
and use the build.sh script and fuzzer source code in this
(https://github.com/MapServer/MapServer/blob/main/fuzzers) directory.

The list of issues is in:
https://bugs.chromium.org/p/oss-fuzz/issues/list?q=mapserver

- Build fuzzer reproducer programs (BUILD_FUZZER_REPRODUCER=ON is the default)
  ```
    $ cmake -DBUILD_FUZZER_REPRODUCER=ON /path/to/source/root
    $ make
  ```

  Run one against a reproducer file (typically generated by OSS Fuzz):
  ```
    $ fuzzers/shapefuzzer_reproducer path_to_reproducer_file
  ```

- Run OSS Fuzz locally. Note you need to have Docker installed and the Docker daemon running for the Python script to run.
  The helper.py script builds and runs the Docker images, then the fuzzers can be run.

  ```
    $ git clone https://github.com/google/oss-fuzz.git
    $ cd oss-fuzz
    $ export PROJECT_NAME=mapserver
    # if you want to run it against your own MapServer fork & branch,
    # you need to edit projects/mapserver/Dockerfile and comment out the following line:
    # #RUN git clone --depth 1 https://github.com/MapServer/MapServer
    # and replace it with something like
    # RUN git clone --depth 1 --branch ossfuzz_run_live_and_minimal_gdal https://github.com/rouault/MapServer
    $ python infra/helper.py build_image $PROJECT_NAME
  ```

  Build fuzzers with the address sanitizer (could use undefined, etc...)
  ```
    $ python infra/helper.py build_fuzzers --sanitizer address $PROJECT_NAME
  ```

  Test a particular fuzzer (replace shapefuzzer by other fuzzers)
  ```
    $ python infra/helper.py run_fuzzer $PROJECT_NAME shapefuzzer
  ```

- Build fuzzer programs for local fuzzing against current MapServer build.
  Requires to use CLang as compiler.
  ```
    $ cmake -DBUILD_FUZZER_REPRODUCER=OFF -DFUZZER=ON /path/to/source/root
    $ make
  ```

  Run the shapefuzzer:
  ```
    $ fuzzers/shapefuzzer
  ```

How to deal with issues reported in https://bugs.chromium.org/p/oss-fuzz/issues/list?q=mapserver ?

    1. Leave a comment in (chromium database) bug entry to indicate that you work on it
    2. Work
    3. Commit a bug fix with commit message with a link to the bugs.chromium.org ticket
    4. Add in the bugs.chromium.org ticket a link to the github pull request or commit implementing the fix.
    5. Check chromium closed the bug (after one or two days typically)
