# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_keyring.py'
# DO NOT CHANGE! Change the original file instead.
from typing import Any

import pytest
from key_value.shared_test.cases import LARGE_DATA_CASES, PositiveCases
from typing_extensions import override

from key_value.sync.code_gen.stores.base import BaseStore
from key_value.sync.code_gen.stores.elasticsearch.store import ElasticsearchStore
from key_value.sync.code_gen.stores.keyring.store import (
    KeyringStore,
    KeyringV1CollectionSanitizationStrategy,
    KeyringV1KeySanitizationStrategy,
)
from tests.code_gen.conftest import detect_on_macos, detect_on_windows
from tests.code_gen.stores.base import BaseStoreTests


class BaseTestKeychainStore(BaseStoreTests):
    @override
    @pytest.fixture
    def store(self) -> KeyringStore:
        # Use a test-specific service name to avoid conflicts
        store = KeyringStore(service_name="py-key-value-test")
        store.delete_many(collection="test", keys=["test", "test_2"])
        store.delete_many(collection="test_collection", keys=["test_key"])

        return store

    @override
    @pytest.mark.skip(reason="We do not test boundedness of keyring stores")
    def test_not_unbounded(self, store: BaseStore): ...

    @override
    @pytest.mark.skipif(condition=detect_on_windows(), reason="Keyrings do not support large values on Windows")
    @PositiveCases.parametrize(cases=[LARGE_DATA_CASES])
    def test_get_large_put_get(self, store: BaseStore, data: dict[str, Any], json: str, round_trip: dict[str, Any]):
        super().test_get_large_put_get(store, data, json, round_trip=round_trip)


@pytest.mark.skipif(condition=not detect_on_macos(), reason="Keyrings do not support large values on MacOS")
@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class TestMacOSKeychainStore(BaseTestKeychainStore):
    pass


@pytest.mark.skipif(condition=not detect_on_windows(), reason="Keyrings do not support large values on Windows")
@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class TestWindowsKeychainStore(BaseTestKeychainStore):
    @pytest.fixture
    def sanitizing_store(self) -> KeyringStore:
        return KeyringStore(
            service_name="py-key-value-test",
            key_sanitization_strategy=KeyringV1KeySanitizationStrategy(),
            collection_sanitization_strategy=KeyringV1CollectionSanitizationStrategy(),
        )

    @override
    def test_long_collection_name(self, store: KeyringStore, sanitizing_store: ElasticsearchStore):  # pyright: ignore[reportIncompatibleMethodOverride]
        with pytest.raises(Exception):  # noqa: B017, PT011
            store.put(collection="test_collection" * 100, key="test_key", value={"test": "test"})

        sanitizing_store.put(collection="test_collection" * 50, key="test_key", value={"test": "test"})
        assert sanitizing_store.get(collection="test_collection" * 50, key="test_key") == {"test": "test"}

    @override
    def test_long_key_name(self, store: KeyringStore, sanitizing_store: KeyringStore):  # pyright: ignore[reportIncompatibleMethodOverride]
        "Tests that a long key name will not raise an error."
        with pytest.raises(Exception):  # noqa: B017, PT011
            store.put(collection="test_collection", key="test_key" * 100, value={"test": "test"})

        sanitizing_store.put(collection="test_collection", key="test_key" * 100, value={"test": "test"})
        assert sanitizing_store.get(collection="test_collection", key="test_key" * 100) == {"test": "test"}
