/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.Configuration;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.BracketedElementIterator;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTreeEventIterator;
import net.sf.saxon.trans.XPathException;

public class Decomposer
implements EventIterator {
    private EventIterator base;
    private Configuration config;

    public Decomposer(EventIterator base, Configuration config) {
        this.config = config;
        this.base = EventStackIterator.flatten(base);
    }

    public Decomposer(NodeInfo node) {
        this.config = node.getConfiguration();
        this.base = new SingletonEventIterator(node);
    }

    public PullEvent next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)pe;
            switch (node.getNodeKind()) {
                case 9: {
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    return new BracketedDocumentIterator(StartDocumentEvent.getInstance(), new Decomposer(contentEvents, this.config), EndDocumentEvent.getInstance());
                }
                case 1: {
                    NodeInfo att;
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    StartElementEvent see = new StartElementEvent(this.config);
                    see.setNameCode(node.getNameCode());
                    see.setTypeCode(node.getTypeAnnotation());
                    see.setLocalNamespaces(node.getDeclaredNamespaces(null));
                    AxisIterator atts = node.iterateAxis((byte)2);
                    while ((att = (NodeInfo)atts.next()) != null) {
                        see.addAttribute(att);
                    }
                    return new BracketedElementIterator(see, new Decomposer(contentEvents, this.config), EndElementEvent.getInstance());
                }
            }
            return node;
        }
        return pe;
    }

    public boolean isFlatSequence() {
        return false;
    }
}

