#!/usr/bin/env python
#
#
#    This file is part of DvdRip Queue
#    
#    DvdRip Queue is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    DvdRip Queue is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with DvdRip Queue.  If not, see <http://www.gnu.org/licenses/>.
#    

import gtk, gobject

def changeStockButtonText(button, text, stock_id):
    button.remove(button.child)    
    label = gobject.new(gtk.Label, label=text, use_underline=True)
    label.set_mnemonic_widget(button)
    image = gtk.image_new_from_stock(stock_id, gtk.ICON_SIZE_BUTTON)
    hbox = gtk.HBox(False, 2)
    align = gtk.Alignment(0.5, 0.5, 0.0, 0.0)
    hbox.pack_start(image, False, False, 0)
    hbox.pack_end(label, False, False, 0)
    align.add(hbox)
    button.add(align)
    align.show_all()
    button.hide()
    button.show()
    
    return button