# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class TrackedResource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.networkfunction.models.TrackedResourceSystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "TrackedResourceSystemData"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None


class AzureTrafficCollector(TrackedResource):
    """Azure Traffic Collector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.networkfunction.models.TrackedResourceSystemData
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar collector_policies: Collector Policies for Azure Traffic Collector.
    :vartype collector_policies: list[~azure.mgmt.networkfunction.models.ResourceReference]
    :ivar virtual_hub: The virtualHub to which the Azure Traffic Collector belongs.
    :vartype virtual_hub: ~azure.mgmt.networkfunction.models.ResourceReference
    :ivar provisioning_state: The provisioning state of the application rule collection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.networkfunction.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "etag": {"readonly": True},
        "collector_policies": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "TrackedResourceSystemData"},
        "etag": {"key": "etag", "type": "str"},
        "collector_policies": {"key": "properties.collectorPolicies", "type": "[ResourceReference]"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "ResourceReference"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        virtual_hub: Optional["_models.ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_hub: The virtualHub to which the Azure Traffic Collector belongs.
        :paramtype virtual_hub: ~azure.mgmt.networkfunction.models.ResourceReference
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = None
        self.collector_policies = None
        self.virtual_hub = virtual_hub
        self.provisioning_state = None


class AzureTrafficCollectorListResult(_serialization.Model):
    """Response for the ListTrafficCollectors API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of Traffic Collector resources.
    :vartype value: list[~azure.mgmt.networkfunction.models.AzureTrafficCollector]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureTrafficCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AzureTrafficCollector"]] = None, **kwargs):
        """
        :keyword value: A list of Traffic Collector resources.
        :paramtype value: list[~azure.mgmt.networkfunction.models.AzureTrafficCollector]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.networkfunction.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.networkfunction.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CollectorPolicy(TrackedResource):
    """Collector policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.networkfunction.models.TrackedResourceSystemData
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ingestion_policy: Ingestion policies.
    :vartype ingestion_policy: ~azure.mgmt.networkfunction.models.IngestionPolicyPropertiesFormat
    :ivar emission_policies: Emission policies.
    :vartype emission_policies:
     list[~azure.mgmt.networkfunction.models.EmissionPoliciesPropertiesFormat]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Updating",
     "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.networkfunction.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "TrackedResourceSystemData"},
        "etag": {"key": "etag", "type": "str"},
        "ingestion_policy": {"key": "properties.ingestionPolicy", "type": "IngestionPolicyPropertiesFormat"},
        "emission_policies": {"key": "properties.emissionPolicies", "type": "[EmissionPoliciesPropertiesFormat]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        ingestion_policy: Optional["_models.IngestionPolicyPropertiesFormat"] = None,
        emission_policies: Optional[List["_models.EmissionPoliciesPropertiesFormat"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword ingestion_policy: Ingestion policies.
        :paramtype ingestion_policy: ~azure.mgmt.networkfunction.models.IngestionPolicyPropertiesFormat
        :keyword emission_policies: Emission policies.
        :paramtype emission_policies:
         list[~azure.mgmt.networkfunction.models.EmissionPoliciesPropertiesFormat]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = None
        self.ingestion_policy = ingestion_policy
        self.emission_policies = emission_policies
        self.provisioning_state = None


class CollectorPolicyListResult(_serialization.Model):
    """Response for the ListCollectorPolicies API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of collection policies.
    :vartype value: list[~azure.mgmt.networkfunction.models.CollectorPolicy]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CollectorPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.CollectorPolicy"]] = None, **kwargs):
        """
        :keyword value: A list of collection policies.
        :paramtype value: list[~azure.mgmt.networkfunction.models.CollectorPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EmissionPoliciesPropertiesFormat(_serialization.Model):
    """Emission policy properties.

    :ivar emission_type: Emission format type. "IPFIX"
    :vartype emission_type: str or ~azure.mgmt.networkfunction.models.EmissionType
    :ivar emission_destinations: Emission policy destinations.
    :vartype emission_destinations:
     list[~azure.mgmt.networkfunction.models.EmissionPolicyDestination]
    """

    _attribute_map = {
        "emission_type": {"key": "emissionType", "type": "str"},
        "emission_destinations": {"key": "emissionDestinations", "type": "[EmissionPolicyDestination]"},
    }

    def __init__(
        self,
        *,
        emission_type: Optional[Union[str, "_models.EmissionType"]] = None,
        emission_destinations: Optional[List["_models.EmissionPolicyDestination"]] = None,
        **kwargs
    ):
        """
        :keyword emission_type: Emission format type. "IPFIX"
        :paramtype emission_type: str or ~azure.mgmt.networkfunction.models.EmissionType
        :keyword emission_destinations: Emission policy destinations.
        :paramtype emission_destinations:
         list[~azure.mgmt.networkfunction.models.EmissionPolicyDestination]
        """
        super().__init__(**kwargs)
        self.emission_type = emission_type
        self.emission_destinations = emission_destinations


class EmissionPolicyDestination(_serialization.Model):
    """Emission policy destination properties.

    :ivar destination_type: Emission destination type. "AzureMonitor"
    :vartype destination_type: str or ~azure.mgmt.networkfunction.models.DestinationType
    """

    _attribute_map = {
        "destination_type": {"key": "destinationType", "type": "str"},
    }

    def __init__(self, *, destination_type: Optional[Union[str, "_models.DestinationType"]] = None, **kwargs):
        """
        :keyword destination_type: Emission destination type. "AzureMonitor"
        :paramtype destination_type: str or ~azure.mgmt.networkfunction.models.DestinationType
        """
        super().__init__(**kwargs)
        self.destination_type = destination_type


class IngestionPolicyPropertiesFormat(_serialization.Model):
    """Ingestion Policy properties.

    :ivar ingestion_type: The ingestion type. "IPFIX"
    :vartype ingestion_type: str or ~azure.mgmt.networkfunction.models.IngestionType
    :ivar ingestion_sources: Ingestion Sources.
    :vartype ingestion_sources:
     list[~azure.mgmt.networkfunction.models.IngestionSourcesPropertiesFormat]
    """

    _attribute_map = {
        "ingestion_type": {"key": "ingestionType", "type": "str"},
        "ingestion_sources": {"key": "ingestionSources", "type": "[IngestionSourcesPropertiesFormat]"},
    }

    def __init__(
        self,
        *,
        ingestion_type: Optional[Union[str, "_models.IngestionType"]] = None,
        ingestion_sources: Optional[List["_models.IngestionSourcesPropertiesFormat"]] = None,
        **kwargs
    ):
        """
        :keyword ingestion_type: The ingestion type. "IPFIX"
        :paramtype ingestion_type: str or ~azure.mgmt.networkfunction.models.IngestionType
        :keyword ingestion_sources: Ingestion Sources.
        :paramtype ingestion_sources:
         list[~azure.mgmt.networkfunction.models.IngestionSourcesPropertiesFormat]
        """
        super().__init__(**kwargs)
        self.ingestion_type = ingestion_type
        self.ingestion_sources = ingestion_sources


class IngestionSourcesPropertiesFormat(_serialization.Model):
    """Ingestion policy properties.

    :ivar source_type: Ingestion source type. "Resource"
    :vartype source_type: str or ~azure.mgmt.networkfunction.models.SourceType
    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    """

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_type: Optional[Union[str, "_models.SourceType"]] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_type: Ingestion source type. "Resource"
        :paramtype source_type: str or ~azure.mgmt.networkfunction.models.SourceType
        :keyword resource_id: Resource ID.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.source_type = source_type
        self.resource_id = resource_id


class Operation(_serialization.Model):
    """Azure Traffic Collector REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.networkfunction.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: bool = False,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.networkfunction.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft NetworkFunction.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft NetworkFunction.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Azure Traffic Collector operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of operations supported by the Azure Traffic Collector resource provider.
    :vartype value: list[~azure.mgmt.networkfunction.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of operations supported by the Azure Traffic Collector resource provider.
        :paramtype value: list[~azure.mgmt.networkfunction.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProxyResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None


class ResourceReference(_serialization.Model):
    """Resource reference properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrackedResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.networkfunction.models.CreatedByType
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            **kwargs
        )
