/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmpatternedit.h"
#include "pmpattern.h"
#include "pmvectoredit.h"
#include "pmlineedits.h"
#include "pmvector.h"

#include <qwidget.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <ktabctl.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdialog.h>
#include <kfiledialog.h>
#include <kiconloader.h>

PMPatternEdit::PMPatternEdit( QWidget* parent, const char* name )
      : Base( parent, name )
{
   m_pDisplayedObject = 0;
}

void PMPatternEdit::createTopWidgets( )
{
   Base::createTopWidgets( );

   QGridLayout* layout;
   QHBoxLayout* hl;
   QVBoxLayout* vl;

   QLabel* label = new QLabel( i18n( "Type:" ), this );
   m_pTypeCombo = new QComboBox( false, this );
   m_pTypeCombo->insertItem( i18n( "Agate" ) );
   m_pTypeCombo->insertItem( i18n( "Average" ) );
   m_pTypeCombo->insertItem( i18n( "Boxed" ) );
   m_pTypeCombo->insertItem( i18n( "Bozo" ) );
   m_pTypeCombo->insertItem( i18n( "Bumps" ) );
   m_pTypeCombo->insertItem( i18n( "Crackle" ) );
   m_pTypeCombo->insertItem( i18n( "Cylindrical" ) );
   m_pTypeCombo->insertItem( i18n( "Density File" ) );
   m_pTypeCombo->insertItem( i18n( "Dents" ) );
   m_pTypeCombo->insertItem( i18n( "Gradient" ) );
   m_pTypeCombo->insertItem( i18n( "Granite" ) );
   m_pTypeCombo->insertItem( i18n( "Leopard" ) );
   m_pTypeCombo->insertItem( i18n( "Mandel" ) );
   m_pTypeCombo->insertItem( i18n( "Marble" ) );
   m_pTypeCombo->insertItem( i18n( "Onion" ) );
   m_pTypeCombo->insertItem( i18n( "Planar" ) );
   m_pTypeCombo->insertItem( i18n( "Quilt" ) );
   m_pTypeCombo->insertItem( i18n( "Radial" ) );
   m_pTypeCombo->insertItem( i18n( "Ripples" ) );
   m_pTypeCombo->insertItem( i18n( "Spherical" ) );
   m_pTypeCombo->insertItem( i18n( "Spiral1" ) );
   m_pTypeCombo->insertItem( i18n( "Spiral2" ) );
   m_pTypeCombo->insertItem( i18n( "Spotted" ) );
   m_pTypeCombo->insertItem( i18n( "Waves" ) );
   m_pTypeCombo->insertItem( i18n( "Wood" ) );
   m_pTypeCombo->insertItem( i18n( "Wrinkles" ) );

   layout = new QGridLayout( topLayout( ), 9, 2 );
   hl = new QHBoxLayout( KDialog::spacingHint( ) );
   hl->addWidget( label );
   hl->addWidget( m_pTypeCombo );
   hl->addStretch( 1 );
   layout->addMultiCellLayout( hl, 0, 0, 0, 1 );

   m_pAgateTurbulenceLabel = new QLabel( i18n( "Turbulence:" ), this );
   m_pAgateTurbulenceEdit = new PMFloatEdit( this );
   layout->addWidget( m_pAgateTurbulenceLabel, 1, 0 );
   layout->addWidget( m_pAgateTurbulenceEdit, 1, 1, AlignLeft );

   m_pGradientLabel = new QLabel( i18n( "Gradient:" ), this );
   m_pGradientEdit = new PMVectorEdit( "x", "y", "z", this );
   layout->addWidget( m_pGradientLabel, 2, 0 );
   layout->addWidget( m_pGradientEdit, 2, 1 );

   m_pSpiralNumberLabel = new QLabel( i18n( "Spiral number:" ), this );
   m_pSpiralNumberEdit = new PMIntEdit( this );
   layout->addWidget( m_pSpiralNumberLabel, 3, 0 );
   layout->addWidget( m_pSpiralNumberEdit, 3, 1, AlignLeft );

   m_pMaxIterationsLabel = new QLabel( i18n( "Maximum iterations:" ), this );
   m_pMaxIterationsEdit = new PMIntEdit( this );
   layout->addWidget( m_pMaxIterationsLabel, 4, 0 );
   layout->addWidget( m_pMaxIterationsEdit, 4, 1 );

   m_pQuiltControlsLabel = new QLabel( i18n( "Quilt controls:" ), this );
   m_pQuiltControl0Edit = new PMFloatEdit( this );
   m_pQuiltControl1Edit = new PMFloatEdit( this );
   hl = new QHBoxLayout( );
   hl->addWidget( m_pQuiltControl0Edit );
   hl->addWidget( m_pQuiltControl1Edit );
   hl->addStretch( 1 );
   layout->addWidget( m_pQuiltControlsLabel, 5, 0 );
   layout->addLayout( hl, 5, 1 );

   m_pDepthLabel = new QLabel( i18n( "Depth:" ), this );
   m_pDepthEdit = new PMFloatEdit( this );
   layout->addWidget( m_pDepthLabel, 6, 0 );
   layout->addWidget( m_pDepthEdit, 6, 1, AlignLeft );

   m_pDensityWidget = new QWidget( this );
   vl = new QVBoxLayout( m_pDensityWidget, 0, KDialog::spacingHint( ) );
   hl = new QHBoxLayout( vl );
   m_pDensityFileLabel = new QLabel( i18n( "File:" ), m_pDensityWidget );
   m_pDensityFile = new QLineEdit( m_pDensityWidget );
   m_pDensityFileBrowse = new QPushButton( m_pDensityWidget );
   m_pDensityFileBrowse->setPixmap( SmallIcon( "fileopen" ) );
   hl->addWidget( m_pDensityFileLabel );
   hl->addWidget( m_pDensityFile, 1 );
   hl->addWidget( m_pDensityFileBrowse );
   hl = new QHBoxLayout( vl );
   m_pDensityInterpolateLabel = new QLabel( i18n( "Interpolation:" ), m_pDensityWidget );
   m_pDensityInterpolate = new QComboBox( false, m_pDensityWidget );
   m_pDensityInterpolate->insertItem( i18n( "None" ) );
   m_pDensityInterpolate->insertItem( i18n( "Trilinear" ) );
   hl->addWidget( m_pDensityInterpolateLabel );
   hl->addWidget( m_pDensityInterpolate );
   hl->addStretch( 1 );
   layout->addMultiCellWidget( m_pDensityWidget, 7, 7, 0, 1 );


   m_pNoiseGeneratorLabel = new QLabel( i18n( "Noise generator:" ), this );
   m_pNoiseGenerator = new QComboBox( false, this );
   m_pNoiseGenerator->insertItem( i18n( "Use Global Setting" ) );
   m_pNoiseGenerator->insertItem( i18n( "Original" ) );
   m_pNoiseGenerator->insertItem( i18n( "Range Corrected" ) );
   m_pNoiseGenerator->insertItem( i18n( "Perlin" ) );
   layout->addWidget( m_pNoiseGeneratorLabel, 8, 0 );
   layout->addWidget( m_pNoiseGenerator, 8, 1 );

   m_pEnableTurbulenceEdit = new QCheckBox( i18n( "Turbulence" ), this );
   topLayout( )->addWidget( m_pEnableTurbulenceEdit );

   m_pValueVectorLabel = new QLabel( i18n( "Value:" ), this );
   m_pValueVectorEdit = new PMVectorEdit( "x", "y", "z", this );
   hl = new QHBoxLayout( topLayout( ) );
   hl->addWidget( m_pValueVectorLabel );
   hl->addWidget( m_pValueVectorEdit );

   hl = new QHBoxLayout( topLayout( ) );
   layout = new QGridLayout( hl, 3, 2 );
   m_pOctavesLabel = new QLabel( i18n( "Octaves:" ), this );
   m_pOctavesEdit = new PMIntEdit( this );
   layout->addWidget( m_pOctavesLabel, 0, 0 );
   layout->addWidget( m_pOctavesEdit, 0, 1 );
   m_pOmegaLabel = new QLabel( i18n( "Omega:" ), this );
   m_pOmegaEdit = new PMFloatEdit( this );
   layout->addWidget( m_pOmegaLabel, 1, 0 );
   layout->addWidget( m_pOmegaEdit, 1, 1 );
   m_pLambdaLabel = new QLabel( i18n( "Lambda:" ), this );
   m_pLambdaEdit = new PMFloatEdit( this );
   layout->addWidget( m_pLambdaLabel, 2, 0 );
   layout->addWidget( m_pLambdaEdit, 2, 1 );
   hl->addStretch( 1 );

   /* connect all signals to slots/signals */
   connect( m_pTypeCombo, SIGNAL( activated( int ) ), SLOT( slotComboChanged( int ) ) );
   connect( m_pAgateTurbulenceEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pGradientEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pSpiralNumberEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pQuiltControl0Edit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pQuiltControl1Edit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pMaxIterationsEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pNoiseGenerator, SIGNAL( activated( int ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pEnableTurbulenceEdit, SIGNAL( clicked( ) ), SLOT( slotTurbulenceClicked( ) ) );
   connect( m_pValueVectorEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pOctavesEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pOmegaEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pLambdaEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pDepthEdit, SIGNAL( dataChanged( ) ), SIGNAL( dataChanged( ) ) );
   connect( m_pDensityInterpolate, SIGNAL( activated( int ) ), SLOT( slotInterpolateChanged( int ) ) );
   connect( m_pDensityFile, SIGNAL( textChanged( const QString& ) ),
                                          SLOT( slotDensityFileNameChanged( const QString& ) ) );
   connect( m_pDensityFileBrowse, SIGNAL( clicked( ) ), SLOT( slotDensityFileBrowseClicked( ) ) );
}

void PMPatternEdit::displayObject( PMObject* o )
{
   QString str;
   bool readOnly;

   if( o->isA( "Pattern" ) )
   {
      m_pDisplayedObject = ( PMPattern* ) o;
      readOnly = m_pDisplayedObject->isReadOnly( );

      switch( m_pDisplayedObject->patternType( ) )
      {
         case PMPattern::PatternAgate:
            setPatternType( 0 );
            break;
         case PMPattern::PatternAverage:
            setPatternType( 1 );
            break;
         case PMPattern::PatternBoxed:
            setPatternType( 2 );
            break;
         case PMPattern::PatternBozo:
            setPatternType( 3 );
            break;
         case PMPattern::PatternBumps:
            setPatternType( 4 );
            break;
         case PMPattern::PatternCrackle:
            setPatternType( 5 );
            break;
         case PMPattern::PatternCylindrical:
            setPatternType( 6 );
            break;
         case PMPattern::PatternDensity:
            setPatternType( 7 );
            break;
         case PMPattern::PatternDents:
            setPatternType( 8 );
            break;
         case PMPattern::PatternGradient:
            setPatternType( 9 );
            break;
         case PMPattern::PatternGranite:
            setPatternType( 10 );
            break;
         case PMPattern::PatternLeopard:
            setPatternType( 11 );
            break;
         case PMPattern::PatternMandel:
            setPatternType( 12 );
            break;
         case PMPattern::PatternMarble:
            setPatternType( 13 );
            break;
         case PMPattern::PatternOnion:
            setPatternType( 14 );
            break;
         case PMPattern::PatternPlanar:
            setPatternType( 15 );
            break;
         case PMPattern::PatternQuilted:
            setPatternType( 16 );
            break;
         case PMPattern::PatternRadial:
            setPatternType( 17 );
            break;
         case PMPattern::PatternRipples:
            setPatternType( 18 );
            break;
         case PMPattern::PatternSpherical:
            setPatternType( 19 );
            break;
         case PMPattern::PatternSpiral1:
            setPatternType( 20 );
            break;
         case PMPattern::PatternSpiral2:
            setPatternType( 21 );
            break;
         case PMPattern::PatternSpotted:
            setPatternType( 22 );
            break;
         case PMPattern::PatternWaves:
            setPatternType( 23 );
            break;
         case PMPattern::PatternWood:
            setPatternType( 24 );
            break;
         case PMPattern::PatternWrinkles:
            setPatternType( 25 );
            break;
      }
      m_pTypeCombo->setEnabled( !readOnly );
      m_pAgateTurbulenceEdit->setValue( m_pDisplayedObject->agateTurbulence( ) );
      m_pAgateTurbulenceEdit->setReadOnly( readOnly );
      m_pSpiralNumberEdit->setValue( m_pDisplayedObject->spiralNumberArms( ) );
      m_pSpiralNumberEdit->setReadOnly( readOnly );
      m_pGradientEdit->setVector( m_pDisplayedObject->gradient( ) );
      m_pGradientEdit->setReadOnly( readOnly );
      m_pQuiltControl0Edit->setValue( m_pDisplayedObject->quiltControl0( ) );
      m_pQuiltControl0Edit->setReadOnly( readOnly );
      m_pQuiltControl1Edit->setValue( m_pDisplayedObject->quiltControl1( ) );
      m_pQuiltControl1Edit->setReadOnly( readOnly );
      m_pMaxIterationsEdit->setValue( m_pDisplayedObject->maxIterations( ) );
      m_pMaxIterationsEdit->setReadOnly( readOnly );
      m_pDensityFile->setText( m_pDisplayedObject->densityFile( ) );
      m_pDensityFile->setEnabled( !readOnly );
      m_pDensityInterpolate->setCurrentItem( m_pDisplayedObject->densityInterpolate( ) );
      m_pDensityInterpolate->setEnabled( !readOnly );
      m_pNoiseGenerator->setCurrentItem( m_pDisplayedObject->noiseGenerator( ) );
      m_pNoiseGenerator->setEnabled( !readOnly );

      m_pEnableTurbulenceEdit->setChecked( m_pDisplayedObject->isTurbulenceEnabled( ) );
      m_pEnableTurbulenceEdit->setEnabled( !readOnly );
      m_pValueVectorEdit->setVector( m_pDisplayedObject->valueVector( ) );
      m_pValueVectorEdit->setReadOnly( readOnly );
      m_pOctavesEdit->setValue( m_pDisplayedObject->octaves( ) );
      m_pOctavesEdit->setReadOnly( readOnly );
      m_pOmegaEdit->setValue( m_pDisplayedObject->omega( ) );
      m_pOmegaEdit->setReadOnly( readOnly );
      m_pLambdaEdit->setValue( m_pDisplayedObject->lambda( ) );
      m_pLambdaEdit->setReadOnly( readOnly );

      if( o->parent( ) && ( o->parent( )->type( ) == "Normal" ) )
      {
         m_pDepthEdit->setValue( m_pDisplayedObject->depth( ) );
         m_pDepthEdit->setReadOnly( readOnly );
         m_pDepthEdit->show( );
         m_pDepthLabel->show( );
         emit sizeChanged( );
      }
      else
      {
         m_pDepthEdit->hide( );
         m_pDepthLabel->hide( );
         emit sizeChanged( );
      }

      slotComboChanged( m_pTypeCombo->currentItem( ) );
      slotTurbulenceClicked( );
      Base::displayObject( o );
   }
   else
      kdError( PMArea ) << "PMPatternEdit: Can't display object\n";
}

void PMPatternEdit::setPatternType( int i )
{
   m_pTypeCombo->setCurrentItem( i );
   slotComboChanged( i );
}

void PMPatternEdit::saveContents( )
{
   if( m_pDisplayedObject )
   {
      Base::saveContents( );
      switch( m_pTypeCombo->currentItem( ) )
      {
         case 0:
            m_pDisplayedObject->setPatternType( PMPattern::PatternAgate );
            m_pDisplayedObject->setAgateTurbulence( m_pAgateTurbulenceEdit->value( ) );
            break;
         case 1:
            m_pDisplayedObject->setPatternType( PMPattern::PatternAverage );
            break;
         case 2:
            m_pDisplayedObject->setPatternType( PMPattern::PatternBoxed );
            break;
         case 3:
            m_pDisplayedObject->setPatternType( PMPattern::PatternBozo );
            m_pDisplayedObject->setNoiseGenerator(
               ( PMPattern::PMNoiseType ) m_pNoiseGenerator->currentItem( ) );
            break;
         case 4:
            m_pDisplayedObject->setPatternType( PMPattern::PatternBumps );
            m_pDisplayedObject->setNoiseGenerator(
               ( PMPattern::PMNoiseType ) m_pNoiseGenerator->currentItem( ) );
            break;
         case 5:
            m_pDisplayedObject->setPatternType( PMPattern::PatternCrackle );
            break;
         case 6:
            m_pDisplayedObject->setPatternType( PMPattern::PatternCylindrical );
            break;
         case 7:
            m_pDisplayedObject->setPatternType( PMPattern::PatternDensity );
            m_pDisplayedObject->setDensityFile( m_pDensityFile->text( ) );
            m_pDisplayedObject->setDensityInterpolate( m_pDensityInterpolate->currentItem( ) );
            break;
         case 8:
            m_pDisplayedObject->setPatternType( PMPattern::PatternDents );
            break;
         case 9:
            m_pDisplayedObject->setPatternType( PMPattern::PatternGradient );
            m_pDisplayedObject->setGradient( m_pGradientEdit->vector( ) );
            break;
         case 10:
            m_pDisplayedObject->setPatternType( PMPattern::PatternGranite );
            m_pDisplayedObject->setNoiseGenerator(
               ( PMPattern::PMNoiseType ) m_pNoiseGenerator->currentItem( ) );
            break;
         case 11:
            m_pDisplayedObject->setPatternType( PMPattern::PatternLeopard );
            break;
         case 12:
            m_pDisplayedObject->setPatternType( PMPattern::PatternMandel );
            break;
         case 13:
            m_pDisplayedObject->setPatternType( PMPattern::PatternMarble );
            break;
         case 14:
            m_pDisplayedObject->setPatternType( PMPattern::PatternOnion );
            break;
         case 15:
            m_pDisplayedObject->setPatternType( PMPattern::PatternPlanar );
            break;
         case 16:
            m_pDisplayedObject->setPatternType( PMPattern::PatternQuilted );
            m_pDisplayedObject->setQuiltControl0( m_pQuiltControl0Edit->value( ) );
            m_pDisplayedObject->setQuiltControl1( m_pQuiltControl1Edit->value( ) );
            break;
         case 17:
            m_pDisplayedObject->setPatternType( PMPattern::PatternRadial );
            break;
         case 18:
            m_pDisplayedObject->setPatternType( PMPattern::PatternRipples );
            break;
         case 19:
            m_pDisplayedObject->setPatternType( PMPattern::PatternSpherical );
            break;
         case 20:
            m_pDisplayedObject->setPatternType( PMPattern::PatternSpiral1 );
            m_pDisplayedObject->setSpiralNumberArms( m_pSpiralNumberEdit->value( ) );
            break;
         case 21:
            m_pDisplayedObject->setPatternType( PMPattern::PatternSpiral2 );
            m_pDisplayedObject->setSpiralNumberArms( m_pSpiralNumberEdit->value( ) );
            break;
         case 22:
            m_pDisplayedObject->setPatternType( PMPattern::PatternSpotted );
            break;
         case 23:
            m_pDisplayedObject->setPatternType( PMPattern::PatternWaves );
            break;
         case 24:
            m_pDisplayedObject->setPatternType( PMPattern::PatternWood );
            break;
         case 25:
            m_pDisplayedObject->setPatternType( PMPattern::PatternWrinkles );
            m_pDisplayedObject->setNoiseGenerator(
               ( PMPattern::PMNoiseType ) m_pNoiseGenerator->currentItem( ) );
            break;
      }
      m_pDisplayedObject->enableTurbulence( m_pEnableTurbulenceEdit->isChecked( ) );
      m_pDisplayedObject->setValueVector( m_pValueVectorEdit->vector( ) );
      m_pDisplayedObject->setOctaves( m_pOctavesEdit->value( ) );
      m_pDisplayedObject->setOmega( m_pOmegaEdit->value( ) );
      m_pDisplayedObject->setLambda( m_pLambdaEdit->value( ) );

      if( m_pDisplayedObject->parent( ) && 
          ( m_pDisplayedObject->parent( )->type( ) == "Normal" ) )
         m_pDisplayedObject->setDepth( m_pDepthEdit->value( ) );
   }
}

bool PMPatternEdit::isDataValid( )
{
   switch( m_pTypeCombo->currentItem( ) )
   {
      case 0:
         if( !m_pAgateTurbulenceEdit->isDataValid( ) )
            return false;
         break;
      case 9:
         if( !m_pGradientEdit->isDataValid( ) )
            return false;
         break;
      case 16:
         if( !m_pQuiltControl0Edit->isDataValid( ) )
            return false;
         if( !m_pQuiltControl1Edit->isDataValid( ) )
            return false;
         break;
      case 20:
         if( !m_pSpiralNumberEdit->isDataValid( ) )
            return false;
         break;
      case 21:
         if( !m_pSpiralNumberEdit->isDataValid( ) )
            return false;
         break;
      default:
         break;
   }
   if( m_pEnableTurbulenceEdit->isChecked( ) ) {
      if( !m_pValueVectorEdit->isDataValid( ) ) return false;
      if( !m_pOctavesEdit->isDataValid( ) ) return false;
      if( !m_pOmegaEdit->isDataValid( ) ) return false;
      if( !m_pLambdaEdit->isDataValid( ) ) return false;
   }
   if( m_pDisplayedObject->parent( ) &&
       m_pDisplayedObject->parent( )->type( ) == "Normal" && 
       !m_pDepthEdit->isDataValid( ) ) 
      return false;

   return Base::isDataValid( );
}

void PMPatternEdit::slotComboChanged( int c )
{
   switch( c )
   {
      case 0: /* Agate */
         m_pAgateTurbulenceEdit->show( );
         m_pAgateTurbulenceLabel->show( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 3:  /* Bozo */
      case 4:  /* Bumps */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->show( );
         m_pNoiseGenerator->show( );
         break;
      case 7:  /* Density File */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->show( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 9:  /* Gradient */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->show( );
         m_pGradientLabel->show( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 10:  /* Granite */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->show( );
         m_pNoiseGenerator->show( );
         break;
      case 12:  /* Mandel */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->show( );
         m_pMaxIterationsLabel->show( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 16:  /* Quilted */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->show( );
         m_pQuiltControl0Edit->show( );
         m_pQuiltControl1Edit->show( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 20:  /* Spiral1 */
      case 21:  /* Spiral2 */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->show( );
         m_pSpiralNumberLabel->show( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
      case 25:  /* Wrinkles */
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->show( );
         m_pNoiseGenerator->show( );
         break;
      default:
         m_pAgateTurbulenceEdit->hide( );
         m_pAgateTurbulenceLabel->hide( );
         m_pSpiralNumberEdit->hide( );
         m_pSpiralNumberLabel->hide( );
         m_pGradientEdit->hide( );
         m_pGradientLabel->hide( );
         m_pQuiltControlsLabel->hide( );
         m_pQuiltControl0Edit->hide( );
         m_pQuiltControl1Edit->hide( );
         m_pMaxIterationsEdit->hide( );
         m_pMaxIterationsLabel->hide( );
         m_pDensityWidget->hide( );
         m_pNoiseGeneratorLabel->hide( );
         m_pNoiseGenerator->hide( );
         break;
   }
   emit dataChanged( );
   emit sizeChanged( );
}

void PMPatternEdit::slotTurbulenceClicked( )
{
   if(m_pEnableTurbulenceEdit->isChecked( ) )
   {
      m_pValueVectorLabel->show( );
      m_pValueVectorEdit->show( );
      m_pOctavesLabel->show( );
      m_pOctavesEdit->show( );
      m_pOmegaLabel->show( );
      m_pOmegaEdit->show( );
      m_pLambdaLabel->show( );
      m_pLambdaEdit->show( );
   }
   else
   {
      m_pValueVectorLabel->hide( );
      m_pValueVectorEdit->hide( );
      m_pOctavesLabel->hide( );
      m_pOctavesEdit->hide( );
      m_pOmegaLabel->hide( );
      m_pOmegaEdit->hide( );
      m_pLambdaLabel->hide( );
      m_pLambdaEdit->hide( );
   }
   emit dataChanged( );
   emit sizeChanged( );
}

void PMPatternEdit::slotInterpolateChanged( const int /*a*/ )
{
   emit dataChanged( );
}

void PMPatternEdit::slotDensityFileNameChanged( const QString& /*a*/ )
{
   emit dataChanged( );
}

void PMPatternEdit::slotDensityFileBrowseClicked( )
{
   QString str = KFileDialog::getOpenFileName( QString::null, QString::null );

   if( !str.isEmpty() )
   {
      m_pDensityFile->setText( str );
      emit dataChanged( );
   }
}

#include "pmpatternedit.moc"
