/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef COMPENDIUMDATA_H
#define COMPENDIUMDATA_H


#include <kurl.h>
#include <qdict.h>
#include <qobject.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qptrlist.h>

namespace KBabel
{
class Catalog;
}

class CompendiumData : public QObject
{
    Q_OBJECT

public:
    CompendiumData(QObject *parent=0);

    bool load(KURL url);

    const KBabel::Catalog *catalog() const { return _catalog; }
    const int *exactDict(const QString text) const;
    const QValueList<int> *allDict(const QString text) const;
    const QValueList<int> *wordDict(const QString text) const;
    const QValueList<int> *textonlyDict(const QString text) const;

    bool active() const { return _active; }
    bool initialized() const { return _initialized; }
    bool hasErrors() const { return _error; }
    QString errorMsg() const { return _errorMsg; }

    /** registers an object, that uses this data */
    void registerObject(QObject *);
    /** 
     * unregisters an object, that uses this data 
     * 
     * @return true, if this was the last object
     */
    bool unregisterObject(QObject *);

    bool hasObjects() const;


    static QString simplify(const QString text);
    static QStringList wordList(const QString text);
    
signals:
    void progressStarts(const QString);
    void progressEnds();
    void progress(int);

    
private:
    bool _active;
    bool _error;
    bool _initialized;
    QString _errorMsg;

    KBabel::Catalog *_catalog;
    QDict<int> _exactDict;
    QDict< QValueList<int> > _allDict;
    QDict< QValueList<int> > _wordDict;
    QDict< QValueList<int> > _textonlyDict;

    QPtrList<QObject> _registered;
};

#endif
