/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 3388685877147921107L;
    int count;
    char[] value;
    boolean shared;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        this.value = new char[capacity];
    }

    public StringBuffer(String str) {
        this.count = str.count;
        this.value = new char[this.count + 16];
        str.getChars(0, this.count, this.value, 0);
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        this.ensureCapacity_unsynchronized(minimumCapacity);
    }

    public synchronized void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacity_unsynchronized(newLength);
        while (this.count < newLength) {
            this.value[this.count++] = '\u0000';
        }
        this.count = newLength;
    }

    public synchronized char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public synchronized void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        if (srcOffset < 0 || srcEnd > this.count || srcEnd < srcOffset) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, srcOffset, dst, dstOffset, srcEnd - srcOffset);
    }

    public synchronized void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[index] = ch;
    }

    public StringBuffer append(Object obj) {
        return this.append(obj == null ? "null" : obj.toString());
    }

    public synchronized StringBuffer append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity_unsynchronized(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            StringBuffer stringBuffer3;
            try {
                int len = stringBuffer.count;
                this.ensureCapacity_unsynchronized(this.count + len);
                System.arraycopy(stringBuffer.value, 0, this.value, this.count, len);
                this.count += len;
            }
            finally {
                stringBuffer3 = null;
            }
            stringBuffer3 = this;
            return stringBuffer3;
        }
    }

    public StringBuffer append(char[] data) {
        return this.append(data, 0, data.length);
    }

    public synchronized StringBuffer append(char[] data, int offset, int count) {
        if (offset < 0 || count < 0 || offset > data.length - count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + count);
        System.arraycopy(data, offset, this.value, this.count, count);
        this.count += count;
        return this;
    }

    public StringBuffer append(boolean bool) {
        return this.append(bool ? "true" : "false");
    }

    public synchronized StringBuffer append(char ch) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = ch;
        return this;
    }

    public native StringBuffer append(int var1);

    public StringBuffer append(long lnum) {
        return this.append(Long.toString(lnum, 10));
    }

    public StringBuffer append(float fnum) {
        return this.append(Float.toString(fnum));
    }

    public StringBuffer append(double dnum) {
        return this.append(Double.toString(dnum));
    }

    public synchronized StringBuffer delete(int start, int end) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - end != 0) {
            System.arraycopy(this.value, end, this.value, start, this.count - end);
        }
        this.count -= end - start;
        return this;
    }

    public StringBuffer deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    public synchronized StringBuffer replace(int start, int end, String str) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = str.count;
        int delta = len - (end > this.count ? this.count : end) + start;
        this.ensureCapacity_unsynchronized(this.count + delta);
        if (delta != 0 && end < this.count) {
            System.arraycopy(this.value, end, this.value, end + delta, this.count - end);
        }
        str.getChars(0, len, this.value, start);
        this.count += delta;
        return this;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public synchronized String substring(int beginIndex, int endIndex) {
        boolean share_buffer;
        int len = endIndex - beginIndex;
        if (beginIndex < 0 || endIndex > this.count || endIndex < beginIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len == 0) {
            return "";
        }
        boolean bl = share_buffer = len << 2 >= this.value.length;
        if (share_buffer) {
            this.shared = true;
        }
        return new String(this.value, beginIndex, len, share_buffer);
    }

    public synchronized StringBuffer insert(int offset, char[] str, int str_offset, int len) {
        if (offset < 0 || offset > this.count || len < 0 || str_offset < 0 || str_offset > str.length - len) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, str_offset, this.value, offset, len);
        this.count += len;
        return this;
    }

    public StringBuffer insert(int offset, Object obj) {
        return this.insert(offset, obj == null ? "null" : obj.toString());
    }

    public synchronized StringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.count;
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public StringBuffer insert(int offset, char[] data) {
        return this.insert(offset, data, 0, data.length);
    }

    public StringBuffer insert(int offset, boolean bool) {
        return this.insert(offset, bool ? "true" : "false");
    }

    public synchronized StringBuffer insert(int offset, char ch) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = ch;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int offset, int inum) {
        return this.insert(offset, String.valueOf(inum));
    }

    public StringBuffer insert(int offset, long lnum) {
        return this.insert(offset, Long.toString(lnum, 10));
    }

    public StringBuffer insert(int offset, float fnum) {
        return this.insert(offset, Float.toString(fnum));
    }

    public StringBuffer insert(int offset, double dnum) {
        return this.insert(offset, Double.toString(dnum));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = this.count - str.count;
        while (fromIndex <= limit) {
            if (this.regionMatches(fromIndex, str)) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count - str.count);
    }

    public synchronized int lastIndexOf(String str, int fromIndex) {
        for (fromIndex = Math.min(fromIndex, this.count - str.count); fromIndex >= 0; --fromIndex) {
            if (!this.regionMatches(fromIndex, str)) continue;
            return fromIndex;
        }
        return -1;
    }

    public synchronized StringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        int i = this.count >> 1;
        int j = this.count - i;
        while (--i >= 0) {
            char c = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = c;
            ++j;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    private void ensureCapacity_unsynchronized(int minimumCapacity) {
        if (this.shared || minimumCapacity > this.value.length) {
            int max = minimumCapacity > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
            this.shared = false;
        }
    }

    private native boolean regionMatches(int var1, String var2);
}

