/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class Handler {
    Formatter formatter;
    Filter filter;
    Level level;
    ErrorManager errorManager;
    String encoding;

    private /* synthetic */ void instinit$(Handler handler) {
        this.level = Level.ALL;
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        formatter.getClass();
        this.formatter = formatter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        LogManager.getLogManager().checkAccess();
        if (encoding != null) {
            new String(new byte[0], encoding);
        }
        this.encoding = encoding;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        this.filter = filter;
    }

    public ErrorManager getErrorManager() {
        LogManager.getLogManager().checkAccess();
        if (this.errorManager == null) {
            this.errorManager = new ErrorManager();
        }
        return this.errorManager;
    }

    public void setErrorManager(ErrorManager manager) {
        LogManager.getLogManager().checkAccess();
        manager.getClass();
        this.errorManager = manager;
    }

    protected void reportError(String message, Exception ex, int code) {
        if (this.errorManager == null) {
            this.errorManager = new ErrorManager();
        }
        this.errorManager.error(message, ex, code);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        LogManager.getLogManager().checkAccess();
        level.getClass();
        this.level = level;
    }

    public boolean isLoggable(LogRecord record) {
        if (record.getLevel().intValue() <= this.level.intValue()) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.isLoggable(record);
        }
        return true;
    }

    public Handler() {
        this.instinit$(this);
    }
}

