/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1985-2003 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*    If you have copied or used this software without agreeing     *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*            Information and Software Systems Research             *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*               Glenn Fowler <gsf@research.att.com>                *
*                David Korn <dgk@research.att.com>                 *
*                 Phong Vo <kpv@research.att.com>                  *
*                                                                  *
*******************************************************************/
#pragma prototyped

/*
 * Glenn Fowler
 * AT&T Research
 *
 * in-place character code map
 */

#ifdef GENERATE
#undef	const
#define const
#endif

#include <ast.h>
#include <ccode.h>

/*
 * the identity table
 */

static const unsigned char a2a[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0025,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0045,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0112,0113,0114,0115,0116,0117,
	0120,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0132,0133,0134,0135,0136,0137,
	0140,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0152,0153,0154,0155,0156,0157,
	0160,0161,0162,0163,0164,0165,0166,0167,
	0170,0171,0172,0173,0174,0175,0176,0177,
	0200,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0212,0213,0214,0215,0216,0217,
	0220,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0232,0233,0234,0235,0236,0237,
	0240,0241,0242,0243,0244,0245,0246,0247,
	0250,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0312,0313,0314,0315,0316,0317,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0350,0351,0352,0353,0354,0355,0356,0357,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0372,0373,0374,0375,0376,0377,
};

/*
 * the X/Open dd EBCDIC table
 */

static const unsigned char a2e[] =
{
	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0045,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0232,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0137,0007,
	0040,0041,0042,0043,0044,0025,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0341,
	0101,0102,0103,0104,0105,0106,0107,0110,
	0111,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0142,0143,0144,0145,0146,0147,
	0150,0151,0160,0161,0162,0163,0164,0165,
	0166,0167,0170,0200,0212,0213,0214,0215,
	0216,0217,0220,0152,0233,0234,0235,0236,
	0237,0240,0252,0253,0254,0112,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0241,0276,0277,
	0312,0313,0314,0315,0316,0317,0332,0333,
	0334,0335,0336,0337,0352,0353,0354,0355,
	0356,0357,0372,0373,0374,0375,0376,0377,
};

/*
 * the X/Open dd IBM table
 */

static const unsigned char a2i[] =
{
	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0045,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0137,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0241,0007,
	0040,0041,0042,0043,0044,0025,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0341,
	0101,0102,0103,0104,0105,0106,0107,0110,
	0111,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0142,0143,0144,0145,0146,0147,
	0150,0151,0160,0161,0162,0163,0164,0165,
	0166,0167,0170,0200,0212,0213,0214,0215,
	0216,0217,0220,0232,0233,0234,0235,0236,
	0237,0240,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0312,0313,0314,0315,0316,0317,0332,0333,
	0334,0335,0336,0337,0352,0353,0354,0355,
	0356,0357,0372,0373,0374,0375,0376,0377,
};

/*
 * the mvs OpenEdition EBCDIC table
 */

static const unsigned char a2o[] =
{
	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0025,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0137,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0241,0007,
	0040,0041,0042,0043,0044,0045,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0377,
	0101,0252,0112,0261,0237,0262,0152,0265,
	0273,0264,0232,0212,0260,0312,0257,0274,
	0220,0217,0352,0372,0276,0240,0266,0263,
	0235,0332,0233,0213,0267,0270,0271,0253,
	0144,0145,0142,0146,0143,0147,0236,0150,
	0164,0161,0162,0163,0170,0165,0166,0167,
	0254,0151,0355,0356,0353,0357,0354,0277,
	0200,0375,0376,0373,0374,0272,0256,0131,
	0104,0105,0102,0106,0103,0107,0234,0110,
	0124,0121,0122,0123,0130,0125,0126,0127,
	0214,0111,0315,0316,0313,0317,0314,0341,
	0160,0335,0336,0333,0334,0215,0216,0337,
};

/* the rest are generated from the above */

static const unsigned char e2a[] =
{
	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0241,0242,0243,0244,0245,0246,
	0247,0250,0325,0056,0074,0050,0053,0174,
	0046,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0041,0044,0052,0051,0073,0176,
	0055,0057,0262,0263,0264,0265,0266,0267,
	0270,0271,0313,0054,0045,0137,0076,0077,
	0272,0273,0274,0275,0276,0277,0300,0301,
	0302,0140,0072,0043,0100,0047,0075,0042,
	0303,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0304,0305,0306,0307,0310,0311,
	0312,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0136,0314,0315,0316,0317,0320,
	0321,0345,0163,0164,0165,0166,0167,0170,
	0171,0172,0322,0323,0324,0133,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0135,0346,0347,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0350,0351,0352,0353,0354,0355,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0356,0357,0360,0361,0362,0363,
	0134,0237,0123,0124,0125,0126,0127,0130,
	0131,0132,0364,0365,0366,0367,0370,0371,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0372,0373,0374,0375,0376,0377,
};

static const unsigned char e2i[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0025,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0045,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0255,0113,0114,0115,0116,0117,
	0120,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0132,0133,0134,0135,0136,0241,
	0140,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0232,0153,0154,0155,0156,0157,
	0160,0161,0162,0163,0164,0165,0166,0167,
	0170,0171,0172,0173,0174,0175,0176,0177,
	0200,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0212,0213,0214,0215,0216,0217,
	0220,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0137,0233,0234,0235,0236,0237,
	0240,0275,0242,0243,0244,0245,0246,0247,
	0250,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0312,0313,0314,0315,0316,0317,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0350,0351,0352,0353,0354,0355,0356,0357,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0372,0373,0374,0375,0376,0377,
};

static const unsigned char e2o[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0045,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0025,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0252,0112,0261,0237,0262,0152,
	0265,0273,0357,0113,0114,0115,0116,0117,
	0120,0264,0232,0212,0260,0312,0257,0274,
	0220,0217,0132,0133,0134,0135,0136,0241,
	0140,0141,0352,0372,0276,0240,0266,0263,
	0235,0332,0163,0153,0154,0155,0156,0157,
	0233,0213,0267,0270,0271,0253,0144,0145,
	0142,0171,0172,0173,0174,0175,0176,0177,
	0146,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0143,0147,0236,0150,0164,0161,
	0162,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0137,0170,0165,0166,0167,0254,
	0151,0107,0242,0243,0244,0245,0246,0247,
	0250,0251,0355,0356,0353,0255,0354,0277,
	0200,0375,0376,0373,0374,0272,0256,0131,
	0104,0105,0102,0106,0103,0275,0234,0110,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0124,0121,0122,0123,0130,0125,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0126,0127,0214,0111,0315,0316,
	0340,0377,0342,0343,0344,0345,0346,0347,
	0350,0351,0313,0317,0314,0341,0160,0335,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0336,0333,0334,0215,0216,0337,
};

static const unsigned char i2a[] =
{
	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0241,0242,0243,0244,0245,0246,
	0247,0250,0112,0056,0074,0050,0053,0174,
	0046,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0041,0044,0052,0051,0073,0136,
	0055,0057,0262,0263,0264,0265,0266,0267,
	0270,0271,0152,0054,0045,0137,0076,0077,
	0272,0273,0274,0275,0276,0277,0300,0301,
	0302,0140,0072,0043,0100,0047,0075,0042,
	0303,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0304,0305,0306,0307,0310,0311,
	0312,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0313,0314,0315,0316,0317,0320,
	0321,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0322,0323,0324,0133,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0135,0346,0347,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0350,0351,0352,0353,0354,0355,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0356,0357,0360,0361,0362,0363,
	0134,0237,0123,0124,0125,0126,0127,0130,
	0131,0132,0364,0365,0366,0367,0370,0371,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0372,0373,0374,0375,0376,0377,
};

static const unsigned char i2e[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0025,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0045,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0321,0113,0114,0115,0116,0117,
	0120,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0132,0133,0134,0135,0136,0232,
	0140,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0221,0153,0154,0155,0156,0157,
	0160,0161,0162,0163,0164,0165,0166,0167,
	0170,0171,0172,0173,0174,0175,0176,0177,
	0200,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0212,0213,0214,0215,0216,0217,
	0220,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0152,0233,0234,0235,0236,0237,
	0240,0137,0242,0243,0244,0245,0246,0247,
	0250,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0312,0313,0314,0315,0316,0317,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0350,0351,0352,0353,0354,0355,0356,0357,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0372,0373,0374,0375,0376,0377,
};

static const unsigned char i2o[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0045,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0025,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0252,0112,0261,0237,0262,0152,
	0265,0273,0321,0113,0114,0115,0116,0117,
	0120,0264,0232,0212,0260,0312,0257,0274,
	0220,0217,0132,0133,0134,0135,0136,0137,
	0140,0141,0352,0372,0276,0240,0266,0263,
	0235,0332,0221,0153,0154,0155,0156,0157,
	0233,0213,0267,0270,0271,0253,0144,0145,
	0142,0171,0172,0173,0174,0175,0176,0177,
	0146,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0143,0147,0236,0150,0164,0161,
	0162,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0163,0170,0165,0166,0167,0254,
	0151,0241,0242,0243,0244,0245,0246,0247,
	0250,0251,0355,0356,0353,0255,0354,0277,
	0200,0375,0376,0373,0374,0272,0256,0131,
	0104,0105,0102,0106,0103,0275,0234,0110,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0124,0121,0122,0123,0130,0125,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0126,0127,0214,0111,0315,0316,
	0340,0377,0342,0343,0344,0345,0346,0347,
	0350,0351,0313,0317,0314,0341,0160,0335,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0336,0333,0334,0215,0216,0337,
};

static const unsigned char o2a[] =
{
	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0012,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0205,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0342,0344,0340,0341,0343,0345,
	0347,0361,0242,0056,0074,0050,0053,0174,
	0046,0351,0352,0353,0350,0355,0356,0357,
	0354,0337,0041,0044,0052,0051,0073,0136,
	0055,0057,0302,0304,0300,0301,0303,0305,
	0307,0321,0246,0054,0045,0137,0076,0077,
	0370,0311,0312,0313,0310,0315,0316,0317,
	0314,0140,0072,0043,0100,0047,0075,0042,
	0330,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0253,0273,0360,0375,0376,0261,
	0260,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0252,0272,0346,0270,0306,0244,
	0265,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0241,0277,0320,0133,0336,0256,
	0254,0243,0245,0267,0251,0247,0266,0274,
	0275,0276,0335,0250,0257,0135,0264,0327,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0255,0364,0366,0362,0363,0365,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0271,0373,0374,0371,0372,0377,
	0134,0367,0123,0124,0125,0126,0127,0130,
	0131,0132,0262,0324,0326,0322,0323,0325,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0263,0333,0334,0331,0332,0237,
};

static const unsigned char o2e[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0045,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0025,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0272,0274,0270,0271,0273,0241,
	0277,0335,0103,0113,0114,0115,0116,0117,
	0120,0313,0314,0315,0312,0317,0332,0333,
	0316,0267,0132,0133,0134,0135,0136,0232,
	0140,0141,0170,0212,0166,0167,0200,0213,
	0215,0240,0107,0153,0154,0155,0156,0157,
	0356,0217,0220,0152,0216,0234,0235,0236,
	0233,0171,0172,0173,0174,0175,0176,0177,
	0260,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0123,0161,0334,0375,0376,0131,
	0130,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0122,0160,0276,0150,0214,0105,
	0145,0137,0242,0243,0244,0245,0246,0247,
	0250,0251,0102,0165,0237,0255,0266,0126,
	0124,0104,0106,0147,0121,0110,0146,0162,
	0163,0164,0265,0111,0127,0275,0144,0257,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0125,0352,0354,0336,0337,0353,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0151,0373,0374,0357,0372,0377,
	0340,0355,0342,0343,0344,0345,0346,0347,
	0350,0351,0142,0254,0256,0252,0253,0112,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0143,0263,0264,0261,0262,0341,
};

static const unsigned char o2i[] =
{
	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0045,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0025,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0272,0274,0270,0271,0273,0275,
	0277,0335,0103,0113,0114,0115,0116,0117,
	0120,0313,0314,0315,0312,0317,0332,0333,
	0316,0267,0132,0133,0134,0135,0136,0137,
	0140,0141,0170,0212,0166,0167,0200,0213,
	0215,0240,0107,0153,0154,0155,0156,0157,
	0356,0217,0220,0232,0216,0234,0235,0236,
	0233,0171,0172,0173,0174,0175,0176,0177,
	0260,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0123,0161,0334,0375,0376,0131,
	0130,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0122,0160,0276,0150,0214,0105,
	0145,0241,0242,0243,0244,0245,0246,0247,
	0250,0251,0102,0165,0237,0255,0266,0126,
	0124,0104,0106,0147,0121,0110,0146,0162,
	0163,0164,0265,0111,0127,0275,0144,0257,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0125,0352,0354,0336,0337,0353,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0151,0373,0374,0357,0372,0377,
	0340,0355,0342,0343,0344,0345,0346,0347,
	0350,0351,0142,0254,0256,0252,0253,0255,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0143,0263,0264,0261,0262,0341,
};

const unsigned char*	_cc_map[] =
{
	a2a,	a2e,	a2i,	a2o,
	e2a,	a2a,	e2i,	e2o,
	i2a,	i2e,	a2a,	i2o,
	o2a,	o2e,	o2i,	a2a,
};

#if !_BLD_DLL && _dll_import
const unsigned char** _imp___cc_map = _cc_map;
#endif

void*
_ccmaps(void* b, size_t n, int in, int out)
{
	register unsigned char*		s;
	register unsigned char*		e;
	register const unsigned char*	m;

	if (in != out)
	{
		m = CCMAP(in, out);
		for (e = (s = (unsigned char*)b) + n; s < e; s++)
			*s = m[*s];
	}
	return b;
}

#ifdef GENERATE

#undef	CC_MAPS
#define CC_MAPS	4

#include <stdio.h>

char	name[] = "aeio";

main()
{
	register int		i;
	register int		j;
	register int		n;
	register int		r;
	register int		c;
	register unsigned char*	a;
	register unsigned char*	z;
	register unsigned char*	m;

	for (j = 1; j < 4; j++)
	{
		a = CCMAP(0, j);
		z = CCMAP(j, 0);
		for (n = 0; n < 256; n++)
			z[n] = n;
		for (n = 255; n >= 0; n--)
			z[a[n]] = n;
	}
	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			if (i != j)
			{
				printf("static const unsigned char %c2%c[] =\n{\n", name[i], name[j]);
				m = CCMAP(i, j);
				if (i && j)
				{
					for (n = 0; n < 256; n++)
						m[n] = n;
					a = CCMAP(i, 0);
					z = CCMAP(0, j);
					for (n = 256; n >= 0; n--)
						m[n] = z[a[n]];
				}
				n = 0;
				for (r = 0; r < 32; r++)
				{
					printf("	");
					for (c = 0; c < 8; c++)
					{
						printf("%04o,", m[n]);
						n++;
					}
					printf("\n");
				}
				printf("};\n\n");
			}
	return 0;
}

#endif
