.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XGEEvent.man,v 1.2 2001/01/27 18:19:59 dawes Exp $
.\" $XdotOrg: xc/doc/man/X11/XGEEvent.man,v 1.2 2004/04/23 18:42:09 eich Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XGraphicsExposeEvent 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGraphicsExposeEvent, XNoExposeEvent \- GraphicsExpose and NoExpose event structures
.SH STRUCTURES
The structures for
.ZN GraphicsExpose
and
.ZN NoExpose
events contain:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int type;	/\(** GraphicsExpose */
	unsigned long serial;	/\(** # of last request processed by server */
	Bool send_event;	/\(** true if this came from a SendEvent request */
	Display *display;	/\(** Display the event was read from */
	Drawable drawable;
	int x, y;
	int width, height;
	int count;	/\(** if nonzero, at least this many more */
	int major_code;	/\(** core is CopyArea or CopyPlane */
	int minor_code;	/\(** not defined in the core */
} XGraphicsExposeEvent;
.De
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int type;	/\(** NoExpose */
	unsigned long serial;	/\(** # of last request processed by server */
	Bool send_event;	/\(** true if this came from a SendEvent request */
	Display *display;	/\(** Display the event was read from */
	Drawable drawable;
	int major_code;	/\(** core is CopyArea or CopyPlane */
	int minor_code;	/\(** not defined in the core */
} XNoExposeEvent;
.De
.LP
When you receive these events,
their structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.ZN GraphicsExpose
event to a client application, it sends an
.ZN XGraphicsExposeEvent
structure with the type member set to
.ZN GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.ZN True
if the event came from a
.ZN SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
Both structures have these common members: drawable, major_code, and minor_code.
The drawable member is set to the drawable of the destination region on 
which the graphics request was to be performed.
The major_code member is set to the graphics request initiated by the client
and can be either
.ZN X_CopyArea
or
.ZN X_CopyPlane .
If it is
.ZN X_CopyArea ,
a call to
.ZN XCopyArea
initiated the request.
If it is
.ZN X_CopyPlane ,
a call to
.ZN XCopyPlane
initiated the request.
These constants are defined in 
.hN X11/Xproto.h .
The minor_code member,
like the major_code member, 
indicates which graphics request was initiated by
the client. 
However, the minor_code member is not defined by the core
X protocol and will be zero in these cases, 
although it may be used by an extension.
.LP
The 
.ZN XGraphicsExposeEvent
structure has these additional members: x, y, width, height, and count. 
The x and y members are set to the coordinates relative to the drawable's origin
and indicate the upper-left corner of the rectangle.
The width and height members are set to the size (extent) of the rectangle.
The count member is set to the number of
.ZN GraphicsExpose
events to follow.
If count is zero, no more
.ZN GraphicsExpose
events follow for this window.
However, if count is nonzero, at least that number of
.ZN GraphicsExpose
events (and possibly more) are to follow for this window.
.SH "SEE ALSO"
XAnyEvent(3X11),
XButtonEvent(3X11),
XCreateWindowEvent(3X11),
XCirculateEvent(3X11),
XCirculateRequestEvent(3X11),
XColormapEvent(3X11),
XConfigureEvent(3X11),
XConfigureRequestEvent(3X11),
XCopyArea(3X11),
XCrossingEvent(3X11),
XDestroyWindowEvent(3X11),
XErrorEvent(3X11),
XExposeEvent(3X11),
XFocusChangeEvent(3X11),
XGravityEvent(3X11),
XKeymapEvent(3X11),
XMapEvent(3X11),
XMapRequestEvent(3X11),
XPropertyEvent(3X11),
XReparentEvent(3X11),
XResizeRequestEvent(3X11),
XSelectionClearEvent(3X11),
XSelectionEvent(3X11),
XSelectionRequestEvent(3X11),
XUnmapEvent(3X11),
XVisibilityEvent(3X11)
.br
\fI\*(xL\fP
