/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.xml.SimpleSAXAdapter;
import info.aduna.xml.SimpleSAXParser;
import info.aduna.xml.XMLReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.QueryResultParseException;
import org.xml.sax.SAXException;

public class SPARQLBooleanXMLParser
implements BooleanQueryResultParser {
    public BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return BooleanQueryResultFormat.SPARQL;
    }

    public boolean parse(InputStream in) throws IOException, QueryResultParseException {
        try {
            SPARQLBooleanParser valueParser = new SPARQLBooleanParser();
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
            simpleSAXParser.setListener(valueParser);
            simpleSAXParser.parse(in);
            return valueParser.getValue();
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc instanceof QueryResultParseException) {
                throw (QueryResultParseException)wrappedExc;
            }
            throw new QueryResultParseException(wrappedExc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SPARQLBooleanParser
    extends SimpleSAXAdapter {
        private Boolean value;

        private SPARQLBooleanParser() {
        }

        @Override
        public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
            if ("boolean".equals(tagName)) {
                if ("true".equals(text)) {
                    this.value = true;
                } else if ("false".equals(text)) {
                    this.value = false;
                } else {
                    throw new SAXException("Illegal value for element boolean: " + text);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.value == null) {
                throw new SAXException("Malformed document, boolean element not found");
            }
        }

        public boolean getValue() {
            return this.value != null && this.value != false;
        }
    }
}

