/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

/**
 * This list is generated from the output of the CssPropertiesActor. If a server
 * does not support the actor, this is loaded as a backup. This list does not
 * guarantee that the server actually supports these CSS properties.
 */
module.exports = {
  "align-content": {
    isInherited: false
  },
  "align-items": {
    isInherited: false
  },
  "align-self": {
    isInherited: false
  },
  "animation-delay": {
    isInherited: false
  },
  "animation-direction": {
    isInherited: false
  },
  "animation-duration": {
    isInherited: false
  },
  "animation-fill-mode": {
    isInherited: false
  },
  "animation-iteration-count": {
    isInherited: false
  },
  "animation-name": {
    isInherited: false
  },
  "animation-play-state": {
    isInherited: false
  },
  "animation-timing-function": {
    isInherited: false
  },
  "-moz-appearance": {
    isInherited: false
  },
  "backface-visibility": {
    isInherited: false
  },
  "background-attachment": {
    isInherited: false
  },
  "background-blend-mode": {
    isInherited: false
  },
  "background-clip": {
    isInherited: false
  },
  "background-color": {
    isInherited: false
  },
  "background-image": {
    isInherited: false
  },
  "background-origin": {
    isInherited: false
  },
  "background-position-x": {
    isInherited: false
  },
  "background-position-y": {
    isInherited: false
  },
  "background-repeat": {
    isInherited: false
  },
  "background-size": {
    isInherited: false
  },
  "-moz-binding": {
    isInherited: false
  },
  "block-size": {
    isInherited: false
  },
  "border-block-end-color": {
    isInherited: false
  },
  "border-block-end-style": {
    isInherited: false
  },
  "border-block-end-width": {
    isInherited: false
  },
  "border-block-start-color": {
    isInherited: false
  },
  "border-block-start-style": {
    isInherited: false
  },
  "border-block-start-width": {
    isInherited: false
  },
  "border-bottom-color": {
    isInherited: false
  },
  "-moz-border-bottom-colors": {
    isInherited: false
  },
  "border-bottom-left-radius": {
    isInherited: false
  },
  "border-bottom-right-radius": {
    isInherited: false
  },
  "border-bottom-style": {
    isInherited: false
  },
  "border-bottom-width": {
    isInherited: false
  },
  "border-collapse": {
    isInherited: true
  },
  "border-image-outset": {
    isInherited: false
  },
  "border-image-repeat": {
    isInherited: false
  },
  "border-image-slice": {
    isInherited: false
  },
  "border-image-source": {
    isInherited: false
  },
  "border-image-width": {
    isInherited: false
  },
  "border-inline-end-color": {
    isInherited: false
  },
  "border-inline-end-style": {
    isInherited: false
  },
  "border-inline-end-width": {
    isInherited: false
  },
  "border-inline-start-color": {
    isInherited: false
  },
  "border-inline-start-style": {
    isInherited: false
  },
  "border-inline-start-width": {
    isInherited: false
  },
  "border-left-color": {
    isInherited: false
  },
  "-moz-border-left-colors": {
    isInherited: false
  },
  "border-left-style": {
    isInherited: false
  },
  "border-left-width": {
    isInherited: false
  },
  "border-right-color": {
    isInherited: false
  },
  "-moz-border-right-colors": {
    isInherited: false
  },
  "border-right-style": {
    isInherited: false
  },
  "border-right-width": {
    isInherited: false
  },
  "border-spacing": {
    isInherited: true
  },
  "border-top-color": {
    isInherited: false
  },
  "-moz-border-top-colors": {
    isInherited: false
  },
  "border-top-left-radius": {
    isInherited: false
  },
  "border-top-right-radius": {
    isInherited: false
  },
  "border-top-style": {
    isInherited: false
  },
  "border-top-width": {
    isInherited: false
  },
  "bottom": {
    isInherited: false
  },
  "-moz-box-align": {
    isInherited: false
  },
  "box-decoration-break": {
    isInherited: false
  },
  "-moz-box-direction": {
    isInherited: false
  },
  "-moz-box-flex": {
    isInherited: false
  },
  "-moz-box-ordinal-group": {
    isInherited: false
  },
  "-moz-box-orient": {
    isInherited: false
  },
  "-moz-box-pack": {
    isInherited: false
  },
  "box-shadow": {
    isInherited: false
  },
  "box-sizing": {
    isInherited: false
  },
  "caption-side": {
    isInherited: true
  },
  "clear": {
    isInherited: false
  },
  "clip": {
    isInherited: false
  },
  "clip-path": {
    isInherited: false
  },
  "clip-rule": {
    isInherited: true
  },
  "color": {
    isInherited: true
  },
  "color-adjust": {
    isInherited: true
  },
  "color-interpolation": {
    isInherited: true
  },
  "color-interpolation-filters": {
    isInherited: true
  },
  "-moz-column-count": {
    isInherited: false
  },
  "-moz-column-fill": {
    isInherited: false
  },
  "-moz-column-gap": {
    isInherited: false
  },
  "-moz-column-rule-color": {
    isInherited: false
  },
  "-moz-column-rule-style": {
    isInherited: false
  },
  "-moz-column-rule-width": {
    isInherited: false
  },
  "-moz-column-width": {
    isInherited: false
  },
  "content": {
    isInherited: false
  },
  "-moz-control-character-visibility": {
    isInherited: true
  },
  "counter-increment": {
    isInherited: false
  },
  "counter-reset": {
    isInherited: false
  },
  "cursor": {
    isInherited: true
  },
  "direction": {
    isInherited: true
  },
  "display": {
    isInherited: false
  },
  "dominant-baseline": {
    isInherited: false
  },
  "empty-cells": {
    isInherited: true
  },
  "fill": {
    isInherited: true
  },
  "fill-opacity": {
    isInherited: true
  },
  "fill-rule": {
    isInherited: true
  },
  "filter": {
    isInherited: false
  },
  "flex-basis": {
    isInherited: false
  },
  "flex-direction": {
    isInherited: false
  },
  "flex-grow": {
    isInherited: false
  },
  "flex-shrink": {
    isInherited: false
  },
  "flex-wrap": {
    isInherited: false
  },
  "float": {
    isInherited: false
  },
  "-moz-float-edge": {
    isInherited: false
  },
  "flood-color": {
    isInherited: false
  },
  "flood-opacity": {
    isInherited: false
  },
  "font-family": {
    isInherited: true
  },
  "font-feature-settings": {
    isInherited: true
  },
  "font-kerning": {
    isInherited: true
  },
  "font-language-override": {
    isInherited: true
  },
  "font-size": {
    isInherited: true
  },
  "font-size-adjust": {
    isInherited: true
  },
  "font-stretch": {
    isInherited: true
  },
  "font-style": {
    isInherited: true
  },
  "font-synthesis": {
    isInherited: true
  },
  "font-variant-alternates": {
    isInherited: true
  },
  "font-variant-caps": {
    isInherited: true
  },
  "font-variant-east-asian": {
    isInherited: true
  },
  "font-variant-ligatures": {
    isInherited: true
  },
  "font-variant-numeric": {
    isInherited: true
  },
  "font-variant-position": {
    isInherited: true
  },
  "font-weight": {
    isInherited: true
  },
  "-moz-force-broken-image-icon": {
    isInherited: false
  },
  "grid-auto-columns": {
    isInherited: false
  },
  "grid-auto-flow": {
    isInherited: false
  },
  "grid-auto-rows": {
    isInherited: false
  },
  "grid-column-end": {
    isInherited: false
  },
  "grid-column-gap": {
    isInherited: false
  },
  "grid-column-start": {
    isInherited: false
  },
  "grid-row-end": {
    isInherited: false
  },
  "grid-row-gap": {
    isInherited: false
  },
  "grid-row-start": {
    isInherited: false
  },
  "grid-template-areas": {
    isInherited: false
  },
  "grid-template-columns": {
    isInherited: false
  },
  "grid-template-rows": {
    isInherited: false
  },
  "height": {
    isInherited: false
  },
  "hyphens": {
    isInherited: true
  },
  "image-orientation": {
    isInherited: true
  },
  "-moz-image-region": {
    isInherited: true
  },
  "image-rendering": {
    isInherited: true
  },
  "ime-mode": {
    isInherited: false
  },
  "inline-size": {
    isInherited: false
  },
  "isolation": {
    isInherited: false
  },
  "justify-content": {
    isInherited: false
  },
  "justify-items": {
    isInherited: false
  },
  "justify-self": {
    isInherited: false
  },
  "left": {
    isInherited: false
  },
  "letter-spacing": {
    isInherited: true
  },
  "lighting-color": {
    isInherited: false
  },
  "line-height": {
    isInherited: true
  },
  "list-style-image": {
    isInherited: true
  },
  "list-style-position": {
    isInherited: true
  },
  "list-style-type": {
    isInherited: true
  },
  "margin-block-end": {
    isInherited: false
  },
  "margin-block-start": {
    isInherited: false
  },
  "margin-bottom": {
    isInherited: false
  },
  "margin-inline-end": {
    isInherited: false
  },
  "margin-inline-start": {
    isInherited: false
  },
  "margin-left": {
    isInherited: false
  },
  "margin-right": {
    isInherited: false
  },
  "margin-top": {
    isInherited: false
  },
  "marker-end": {
    isInherited: true
  },
  "marker-mid": {
    isInherited: true
  },
  "marker-offset": {
    isInherited: false
  },
  "marker-start": {
    isInherited: true
  },
  "mask": {
    isInherited: false
  },
  "mask-type": {
    isInherited: false
  },
  "max-block-size": {
    isInherited: false
  },
  "max-height": {
    isInherited: false
  },
  "max-inline-size": {
    isInherited: false
  },
  "max-width": {
    isInherited: false
  },
  "min-block-size": {
    isInherited: false
  },
  "min-height": {
    isInherited: false
  },
  "min-inline-size": {
    isInherited: false
  },
  "min-width": {
    isInherited: false
  },
  "mix-blend-mode": {
    isInherited: false
  },
  "object-fit": {
    isInherited: false
  },
  "object-position": {
    isInherited: false
  },
  "offset-block-end": {
    isInherited: false
  },
  "offset-block-start": {
    isInherited: false
  },
  "offset-inline-end": {
    isInherited: false
  },
  "offset-inline-start": {
    isInherited: false
  },
  "opacity": {
    isInherited: false
  },
  "order": {
    isInherited: false
  },
  "-moz-orient": {
    isInherited: false
  },
  "-moz-osx-font-smoothing": {
    isInherited: true
  },
  "outline-color": {
    isInherited: false
  },
  "outline-offset": {
    isInherited: false
  },
  "-moz-outline-radius-bottomleft": {
    isInherited: false
  },
  "-moz-outline-radius-bottomright": {
    isInherited: false
  },
  "-moz-outline-radius-topleft": {
    isInherited: false
  },
  "-moz-outline-radius-topright": {
    isInherited: false
  },
  "outline-style": {
    isInherited: false
  },
  "outline-width": {
    isInherited: false
  },
  "overflow-x": {
    isInherited: false
  },
  "overflow-y": {
    isInherited: false
  },
  "padding-block-end": {
    isInherited: false
  },
  "padding-block-start": {
    isInherited: false
  },
  "padding-bottom": {
    isInherited: false
  },
  "padding-inline-end": {
    isInherited: false
  },
  "padding-inline-start": {
    isInherited: false
  },
  "padding-left": {
    isInherited: false
  },
  "padding-right": {
    isInherited: false
  },
  "padding-top": {
    isInherited: false
  },
  "page-break-after": {
    isInherited: false
  },
  "page-break-before": {
    isInherited: false
  },
  "page-break-inside": {
    isInherited: false
  },
  "paint-order": {
    isInherited: true
  },
  "perspective": {
    isInherited: false
  },
  "perspective-origin": {
    isInherited: false
  },
  "pointer-events": {
    isInherited: true
  },
  "position": {
    isInherited: false
  },
  "quotes": {
    isInherited: true
  },
  "resize": {
    isInherited: false
  },
  "right": {
    isInherited: false
  },
  "ruby-align": {
    isInherited: true
  },
  "ruby-position": {
    isInherited: true
  },
  "scroll-behavior": {
    isInherited: false
  },
  "scroll-snap-coordinate": {
    isInherited: false
  },
  "scroll-snap-destination": {
    isInherited: false
  },
  "scroll-snap-points-x": {
    isInherited: false
  },
  "scroll-snap-points-y": {
    isInherited: false
  },
  "scroll-snap-type-x": {
    isInherited: false
  },
  "scroll-snap-type-y": {
    isInherited: false
  },
  "shape-rendering": {
    isInherited: true
  },
  "-moz-stack-sizing": {
    isInherited: false
  },
  "stop-color": {
    isInherited: false
  },
  "stop-opacity": {
    isInherited: false
  },
  "stroke": {
    isInherited: true
  },
  "stroke-dasharray": {
    isInherited: true
  },
  "stroke-dashoffset": {
    isInherited: true
  },
  "stroke-linecap": {
    isInherited: true
  },
  "stroke-linejoin": {
    isInherited: true
  },
  "stroke-miterlimit": {
    isInherited: true
  },
  "stroke-opacity": {
    isInherited: true
  },
  "stroke-width": {
    isInherited: true
  },
  "-moz-tab-size": {
    isInherited: true
  },
  "table-layout": {
    isInherited: false
  },
  "text-align": {
    isInherited: true
  },
  "text-align-last": {
    isInherited: true
  },
  "text-anchor": {
    isInherited: true
  },
  "text-combine-upright": {
    isInherited: true
  },
  "text-decoration-color": {
    isInherited: false
  },
  "text-decoration-line": {
    isInherited: false
  },
  "text-decoration-style": {
    isInherited: false
  },
  "text-emphasis-color": {
    isInherited: true
  },
  "text-emphasis-position": {
    isInherited: true
  },
  "text-emphasis-style": {
    isInherited: true
  },
  "-webkit-text-fill-color": {
    isInherited: true
  },
  "text-indent": {
    isInherited: true
  },
  "text-orientation": {
    isInherited: true
  },
  "text-overflow": {
    isInherited: false
  },
  "text-rendering": {
    isInherited: true
  },
  "text-shadow": {
    isInherited: true
  },
  "-moz-text-size-adjust": {
    isInherited: true
  },
  "-webkit-text-stroke-color": {
    isInherited: true
  },
  "-webkit-text-stroke-width": {
    isInherited: true
  },
  "text-transform": {
    isInherited: true
  },
  "top": {
    isInherited: false
  },
  "transform": {
    isInherited: false
  },
  "transform-box": {
    isInherited: false
  },
  "transform-origin": {
    isInherited: false
  },
  "transform-style": {
    isInherited: false
  },
  "transition-delay": {
    isInherited: false
  },
  "transition-duration": {
    isInherited: false
  },
  "transition-property": {
    isInherited: false
  },
  "transition-timing-function": {
    isInherited: false
  },
  "unicode-bidi": {
    isInherited: false
  },
  "-moz-user-focus": {
    isInherited: true
  },
  "-moz-user-input": {
    isInherited: true
  },
  "-moz-user-modify": {
    isInherited: true
  },
  "-moz-user-select": {
    isInherited: false
  },
  "vector-effect": {
    isInherited: false
  },
  "vertical-align": {
    isInherited: false
  },
  "visibility": {
    isInherited: true
  },
  "white-space": {
    isInherited: true
  },
  "width": {
    isInherited: false
  },
  "will-change": {
    isInherited: false
  },
  "-moz-window-dragging": {
    isInherited: false
  },
  "word-break": {
    isInherited: true
  },
  "word-spacing": {
    isInherited: true
  },
  "overflow-wrap": {
    isInherited: true
  },
  "writing-mode": {
    isInherited: true
  },
  "z-index": {
    isInherited: false
  },
  "all": {
    isInherited: false
  },
  "animation": {
    isInherited: false
  },
  "background": {
    isInherited: false
  },
  "background-position": {
    isInherited: false
  },
  "border": {
    isInherited: false
  },
  "border-block-end": {
    isInherited: false
  },
  "border-block-start": {
    isInherited: false
  },
  "border-bottom": {
    isInherited: false
  },
  "border-color": {
    isInherited: false
  },
  "border-image": {
    isInherited: false
  },
  "border-inline-end": {
    isInherited: false
  },
  "border-inline-start": {
    isInherited: false
  },
  "border-left": {
    isInherited: false
  },
  "border-radius": {
    isInherited: false
  },
  "border-right": {
    isInherited: false
  },
  "border-style": {
    isInherited: false
  },
  "border-top": {
    isInherited: false
  },
  "border-width": {
    isInherited: false
  },
  "-moz-column-rule": {
    isInherited: false
  },
  "-moz-columns": {
    isInherited: false
  },
  "flex": {
    isInherited: false
  },
  "flex-flow": {
    isInherited: false
  },
  "font": {
    isInherited: true
  },
  "font-variant": {
    isInherited: true
  },
  "grid": {
    isInherited: false
  },
  "grid-area": {
    isInherited: false
  },
  "grid-column": {
    isInherited: false
  },
  "grid-gap": {
    isInherited: false
  },
  "grid-row": {
    isInherited: false
  },
  "grid-template": {
    isInherited: false
  },
  "list-style": {
    isInherited: true
  },
  "margin": {
    isInherited: false
  },
  "marker": {
    isInherited: true
  },
  "outline": {
    isInherited: false
  },
  "-moz-outline-radius": {
    isInherited: false
  },
  "overflow": {
    isInherited: false
  },
  "padding": {
    isInherited: false
  },
  "scroll-snap-type": {
    isInherited: false
  },
  "text-decoration": {
    isInherited: false
  },
  "text-emphasis": {
    isInherited: true
  },
  "-webkit-text-stroke": {
    isInherited: true
  },
  "-moz-transform": {
    isInherited: false
  },
  "transition": {
    isInherited: false
  },
  "word-wrap": {
    isInherited: true
  },
  "-moz-transform-origin": {
    isInherited: false
  },
  "-moz-perspective-origin": {
    isInherited: false
  },
  "-moz-perspective": {
    isInherited: false
  },
  "-moz-transform-style": {
    isInherited: false
  },
  "-moz-backface-visibility": {
    isInherited: false
  },
  "-moz-border-image": {
    isInherited: false
  },
  "-moz-transition": {
    isInherited: false
  },
  "-moz-transition-delay": {
    isInherited: false
  },
  "-moz-transition-duration": {
    isInherited: false
  },
  "-moz-transition-property": {
    isInherited: false
  },
  "-moz-transition-timing-function": {
    isInherited: false
  },
  "-moz-animation": {
    isInherited: false
  },
  "-moz-animation-delay": {
    isInherited: false
  },
  "-moz-animation-direction": {
    isInherited: false
  },
  "-moz-animation-duration": {
    isInherited: false
  },
  "-moz-animation-fill-mode": {
    isInherited: false
  },
  "-moz-animation-iteration-count": {
    isInherited: false
  },
  "-moz-animation-name": {
    isInherited: false
  },
  "-moz-animation-play-state": {
    isInherited: false
  },
  "-moz-animation-timing-function": {
    isInherited: false
  },
  "-moz-box-sizing": {
    isInherited: false
  },
  "-moz-font-feature-settings": {
    isInherited: true
  },
  "-moz-font-language-override": {
    isInherited: true
  },
  "-moz-padding-end": {
    isInherited: false
  },
  "-moz-padding-start": {
    isInherited: false
  },
  "-moz-margin-end": {
    isInherited: false
  },
  "-moz-margin-start": {
    isInherited: false
  },
  "-moz-border-end": {
    isInherited: false
  },
  "-moz-border-end-color": {
    isInherited: false
  },
  "-moz-border-end-style": {
    isInherited: false
  },
  "-moz-border-end-width": {
    isInherited: false
  },
  "-moz-border-start": {
    isInherited: false
  },
  "-moz-border-start-color": {
    isInherited: false
  },
  "-moz-border-start-style": {
    isInherited: false
  },
  "-moz-border-start-width": {
    isInherited: false
  },
  "-moz-hyphens": {
    isInherited: true
  },
  "-moz-text-align-last": {
    isInherited: true
  },
  "-webkit-animation": {
    isInherited: false
  },
  "-webkit-animation-delay": {
    isInherited: false
  },
  "-webkit-animation-direction": {
    isInherited: false
  },
  "-webkit-animation-duration": {
    isInherited: false
  },
  "-webkit-animation-fill-mode": {
    isInherited: false
  },
  "-webkit-animation-iteration-count": {
    isInherited: false
  },
  "-webkit-animation-name": {
    isInherited: false
  },
  "-webkit-animation-play-state": {
    isInherited: false
  },
  "-webkit-animation-timing-function": {
    isInherited: false
  },
  "-webkit-filter": {
    isInherited: false
  },
  "-webkit-text-size-adjust": {
    isInherited: true
  },
  "-webkit-transform": {
    isInherited: false
  },
  "-webkit-transform-origin": {
    isInherited: false
  },
  "-webkit-transform-style": {
    isInherited: false
  },
  "-webkit-backface-visibility": {
    isInherited: false
  },
  "-webkit-perspective": {
    isInherited: false
  },
  "-webkit-perspective-origin": {
    isInherited: false
  },
  "-webkit-transition": {
    isInherited: false
  },
  "-webkit-transition-delay": {
    isInherited: false
  },
  "-webkit-transition-duration": {
    isInherited: false
  },
  "-webkit-transition-property": {
    isInherited: false
  },
  "-webkit-transition-timing-function": {
    isInherited: false
  },
  "-webkit-border-radius": {
    isInherited: false
  },
  "-webkit-border-top-left-radius": {
    isInherited: false
  },
  "-webkit-border-top-right-radius": {
    isInherited: false
  },
  "-webkit-border-bottom-left-radius": {
    isInherited: false
  },
  "-webkit-border-bottom-right-radius": {
    isInherited: false
  },
  "-webkit-background-clip": {
    isInherited: false
  },
  "-webkit-background-origin": {
    isInherited: false
  },
  "-webkit-background-size": {
    isInherited: false
  },
  "-webkit-border-image": {
    isInherited: false
  },
  "-webkit-box-shadow": {
    isInherited: false
  },
  "-webkit-box-sizing": {
    isInherited: false
  },
  "-webkit-box-flex": {
    isInherited: false
  },
  "-webkit-box-ordinal-group": {
    isInherited: false
  },
  "-webkit-box-orient": {
    isInherited: false
  },
  "-webkit-box-direction": {
    isInherited: false
  },
  "-webkit-box-align": {
    isInherited: false
  },
  "-webkit-box-pack": {
    isInherited: false
  },
  "-webkit-flex-direction": {
    isInherited: false
  },
  "-webkit-flex-wrap": {
    isInherited: false
  },
  "-webkit-flex-flow": {
    isInherited: false
  },
  "-webkit-order": {
    isInherited: false
  },
  "-webkit-flex": {
    isInherited: false
  },
  "-webkit-flex-grow": {
    isInherited: false
  },
  "-webkit-flex-shrink": {
    isInherited: false
  },
  "-webkit-flex-basis": {
    isInherited: false
  },
  "-webkit-justify-content": {
    isInherited: false
  },
  "-webkit-align-items": {
    isInherited: false
  },
  "-webkit-align-self": {
    isInherited: false
  },
  "-webkit-align-content": {
    isInherited: false
  },
  "-webkit-user-select": {
    isInherited: false
  }
};
