#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdio.h>

#ifdef ELF_LIBRARY
#define execl _execl
#define fork _fork
#define wait _wait
#define sighold _sighold
#define sigrelse _sigrelse
#endif

/*
 * Urgh. If this works I'm surprised. Linus
 *
 * Should be updated to use sigactions, I think.
 */

int system(const char * cmd)
{
	int ret, pid, waitstat;

	if ((pid = fork()) == 0) {
		execl("/bin/sh", "sh", "-c", cmd, NULL);
		exit(127);
	}
	if (pid < 0) return(127 << 8);

	sighold (SIGINT);
	sighold (SIGQUIT);

	while ((waitstat = wait(&ret)) != pid && waitstat != -1);
	if (waitstat == -1) ret = -1;

	sigrelse (SIGINT);
	sigrelse (SIGQUIT);

	return(ret);
}
