/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"

#define	ABSDIFF(a,b)	((long)((a) - (b)) < 0 ? (b) - (a) : (a) - (b))

/*
 * Global variables
 */

static	Time		multi_t = 0;	/* Timer fuer Doppelclicks */



/*********************************************************
 * name:	startMulti
 * description:	ruecksetzen des Selction-bereichs und
 *		festlegen der Startposition des Multi-
 *		bereichs, sowie ein erstes Umranden
 *		des Bereichs
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	startMulti     (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	/*
	 * Nachpruefen ob Doppelclick fuer Multi
	 */
	if (ABSDIFF(e->time,multi_t) < defaults.click_interval &&
	    multi_vs < 16000 && multi_ve < 16000) {
		Dimension	i = multi_vs, j = 0;
		char		buf[2048];
		char		nbuf[2048];
		int		prog_type = folder->file[i]->prog_type;
		char		*dir;

		/*
		 * Diese Option gilt nur fuer Datenfiles
		 */
		if (prog_type == FILE_EXEC || prog_type == FILE_DIR ||
		    prog_type == FILE_LINK || prog_type == FILE_LOCK ||
		    prog_type == FILE_ROOT || prog_type == FILE_PLAIN)
			return;

		/*
		 * Feststellen was fuer ein Datentyp es ist
		 */
		while (filetypes[j].cmd && filetypes[j].type != prog_type)
			j++;

		if (!filetypes[j].type == prog_type)
			return;

		buf[0] = '\0';
		dir = getPath(folder->dir);
		if (!strcmp(dir,"/"))
			dir = "";

		/*
		 * Datenfiles zusammensuchen
		 */
		do {
			if (prog_type != folder->file[i]->prog_type)
				return;
			sprintf(buf,"%s %s/%s\0",buf,dir,folder->file[i]->name);

		} while (++i <= multi_ve);

		sprintf(nbuf,filetypes[j].cmd,buf);

		/*
		 * ausfuehren
		 */
		SYSTEM (nbuf);

		/*
		 * Multibereich loeschen
		 */
		clearMulti (w,NULL,NULL,NULL);
	}
	else {
		int		y;

		clearMulti (w,NULL,NULL,NULL);

		/*
		 * Die Anfangsposition des Multis belegen
		 */
		y = (e->y - 4)/DIR_Y_STEP;

		/*
		 * Ueberpruefen ob ueberhaupt ein Multi gebildet werden kann
		 */
		if (y >= 0 && y < folder->file_count) {
			multi_vs = y;
			multi_ve = y;

			multi_fo = folder;
			/*
			 * Neuen Multi markieren. Nur ein Eintrag
			 */
			XDrawRectangle (XtDisplay(w),XtWindow(w),selc_gc,
					16, y*DIR_Y_STEP + 4,
					folder->max_length + 50 + typelength, 20);
		}
		else
			multi_vs = 16000;
	}
}

/*********************************************************
 * name:	followMulti
 * description:	Ausdehnen des Multibereichs je nach Maus
 *		position
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	followMulti    (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	int		y;

	/*
	 * Die Anfangsposition des Multis belegen
	 */
	if (folder == multi_fo && multi_fo && multi_vs < 16000) {
		y = (e->y - 4)/DIR_Y_STEP;

		if (y < 0)
			y = 0;
		else if (y >= multi_fo->file_count - 1)
			y = multi_fo->file_count - 1;

		/*
		 * Ueberpruefen ob ueberhaupt ein Multi gebildet werden kann
		 */
		if (multi_ve != y) {
			Dimension mi,ma;

			/*
			 * Alten Multi-Rahmen loeschen
			 */
			if (multi_vs < multi_ve) {
				mi = multi_vs;
				ma = multi_ve;
			}
			else {
				mi = multi_ve;
				ma = multi_vs;
			}
			XDrawRectangle (XtDisplay(multi_fo->window),
					XtWindow(multi_fo->window),back_gc,
					16,mi*DIR_Y_STEP + 4,
					multi_fo->max_length + 50 + typelength,
					20 + (ma - mi)*DIR_Y_STEP);

			/*
			 * Neues Ende des Rahmens
			 */
			multi_ve = y;

			/*
			 * Neuen Multi-Rahmen zeichnen
			 */
			if (multi_vs < multi_ve) {
				mi = multi_vs;
				ma = multi_ve;
			}
			else {
				mi = multi_ve;
				ma = multi_vs;
			}
			XDrawRectangle (XtDisplay(multi_fo->window),
					XtWindow(multi_fo->window),selc_gc,
					16,mi*DIR_Y_STEP + 4,
					multi_fo->max_length + 50 + typelength, 
					20 + (ma - mi)*DIR_Y_STEP);
		}
	}
}

/*********************************************************
 * name:	endMulti
 * description:	beenden des Multi-bereichs, eigentlich
 *		nicht notwendig.
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	endMulti       (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	multi_t = e->time;
}

/*********************************************************
 * name:	clearMulti
 * description:	loeschen des Multibereichs
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/

XtActionProc	clearMulti     (Widget w, XEvent *e,
				String *s, Cardinal *c)
{
	Dimension mi,ma;

	if (multi_fo && multi_vs < 16000) {
		/*
		 * Alten Multi-Rahmen loeschen
		 */
		if (multi_vs < multi_ve) {
			mi = multi_vs;
			ma = multi_ve;
		}
		else {
			mi = multi_ve;
			ma = multi_vs;
		}
		XDrawRectangle (XtDisplay(multi_fo->window),
				XtWindow(multi_fo->window),back_gc,
				16,mi*DIR_Y_STEP + 4,
				multi_fo->max_length + 50 + typelength, 
				20 + (ma - mi)*DIR_Y_STEP);

		/*
		 * Werte zurueck setzen
		 */
		multi_vs = 16000;
		multi_ve = 16000;
		multi_fo = NULL;
		MULTI = FALSE;
	}
}

/*********************************************************
 * name:	refreshMulti
 * description:	Neuzeichnen des Multirahmens nach einem Expose
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/

XtActionProc	refreshMulti     (Widget w, XEvent *e,
				String *s, Cardinal *c)
{
	Dimension mi,ma;

	if (multi_fo && multi_fo->window == w && multi_vs < 16000) {
		/*
		 * Alten Multi-Rahmen loeschen
		 */
		if (multi_vs < multi_ve) {
			mi = multi_vs;
			ma = multi_ve;
		}
		else {
			mi = multi_ve;
			ma = multi_vs;
		}
		XDrawRectangle (XtDisplay(multi_fo->window),
				XtWindow(multi_fo->window),selc_gc,
				16,mi*DIR_Y_STEP + 4,
				multi_fo->max_length + 50 + typelength, 
				20 + (ma - mi)*DIR_Y_STEP);

	}
}


