// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// File   : FastMath.c[1.0]
// Name   : gamelib1.0
// Status : proposed
// Changed: Sun Jun 12 22:19:12 1994


#include <math.h>
#include "FastMath.h"
#include "iostream.h"

double FastMath::Vcos[TRIGSIZE+1];
double FastMath::Vsin[TRIGSIZE+1];
FixedPoint FastMath::VFcos[TRIGSIZE+1];
FixedPoint FastMath::VFsin[TRIGSIZE+1];

unsigned char FastMath::VintSqrt[SQRTSIZE];

void FastMath::init(int verbose)
	{
	double radian;
	int i;

	if (verbose)
		cout << "Building math tables ";

	for(i=0; i<(TRIGSIZE+1); i++)
		{
		radian = (M_PI/180.0) * (double)i * (360.0/(double)TRIGSIZE);
		
		Vcos[i] = ::cos( radian );
		VFcos[i] = FLOAT2FP( Vcos[i] );
		
		Vsin[i] = ::sin( radian );
		VFsin[i] = FLOAT2FP( Vsin[i] );

		if (verbose)
			if ( (i%40)==0 ) cout << '.' << flush;
		}

	for(i=0; i<SQRTSIZE; i++)
		{
		VintSqrt[i] = (unsigned char)sqrt(i);
		if (verbose)
			if ( (i%200)==0 ) cout << '.' << flush;
		}

	if (verbose) cout << endl;
	}

