/* This file is part of the GtkHTML library

   Copyright (C) 2001, Ximian Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef _HTMLMAP_H
#define _HTMLMAP_H

#include <glib.h>
#include "htmlobject.h"
#include "htmlshape.h"

#define HTML_MAP(x) ((HTMLMap *) x)
#define HTML_MAP_CLASS(x) ((HTMLMapClass *) x)

struct _HTMLMap {
	HTMLObject object;

	char *name;
        GPtrArray *shapes;
};

struct _HTMLMapClass {
	HTMLObjectClass object_class;
};


void         html_map_type_init   (void);
void         html_map_class_init  (HTMLMapClass    *klass,
				   HTMLType         type,
				   guint            object_size);
HTMLObject  *html_map_new         (const gchar     *name);
void         html_map_init        (HTMLMap         *map,
				   HTMLMapClass    *klass,
				   const gchar     *name);

char *       html_map_calc_point  (HTMLMap         *map,
				   gint             x,
				   gint             y);

void          html_map_add_shape  (HTMLMap         *map,
				   HTMLShape       *shape);

#endif /* _HTMLMAP_H */


