/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PAN_SOCKET_H__
#define __PAN_SOCKET_H__

#include <time.h>
#include <glib.h>
#include <pan/base/pan-object.h>

#define PAN_SOCKET(a) ((PanSocket *)a)

typedef struct _PanSocket           PanSocket;

struct _PanSocket
{
	/* parent class */
	PanObject parent;

	/* public fields */
	time_t last_action_time;

	/* public fields */
	gboolean error;

	/* private fields */  
	gboolean need_auth;
	gint sockfd;
	gchar * inbuf;
	gchar * endbuf;
	gchar * inptr;
	gchar * nntp_group_name;
	gchar * nntp_username;
	gchar * nntp_password;
	GArray * line_buffer;

	/* statistics */
	gchar * host;
	unsigned int bytes_read;
	unsigned int bytes_written;
	time_t byte_count_start_time;
};

/**
***  PROTECTED
**/

void         pan_socket_constructor          (PanSocket            * sock,
                                              PanObjectDestructor    dtor,
                                              const gchar          * address,
                                              int                    port);

void         pan_socket_destructor           (PanObject            * sock);

/**
***  PUBLIC - Life Cycle
**/

PanSocket*   pan_socket_new                  (const gchar          * address,
                                              int                    port);

void         pan_socket_set_nntp_auth        (PanSocket            * socket,
                                              gboolean               need_auth,
                                              const gchar          * username,
                                              const gchar          * password);
/**
***  PUBLIC - UTIL
**/

gint         fd_write                        (gint                   fd,
                                              const gchar          * buf,
                                              gint                   len);

/**
***  PUBLIC - I/O
**/

int          pan_socket_putline              (PanSocket            * sock,
                                              const gchar          * line);

int          pan_socket_putline_va           (PanSocket            * sock,
                                              const gchar          * fmt,
                                              ...);

int          pan_socket_getline              (PanSocket            * sock,
                                              const gchar         ** setme);

void         pan_socket_flush                (PanSocket            * sock);

/**
***  STATISTICS
**/

double       pan_socket_get_xfer_rate_KBps  (const PanSocket      * sock);

void         pan_socket_reset_statistics    (PanSocket            * sock);

gulong       pan_socket_get_total_xfer_K    (void);


#endif /* __PAN_SOCKET_H__ */
