/**
 ** On-Screen-Display for Noatun
 ** Copyright (c) 2001, Flaming Sword Productions
 ** All Rights Reserved under the BSD License
 **/
#ifndef __KOSD_H__
#define __KOSD_H__
#include <sys/types.h>
#include <qqueue.h>
#include <qobject.h>
#include <qtimer.h>
#include <qlabel.h>

// Nifty xosd replacement
class KOSD: public QLabel
{
Q_OBJECT

public:
	enum Status
	{
		Stopped = 0,
		Playing = 1,
		Paused = 2
	};

	enum Position
	{
		Bottom,
		Top
	};

	KOSD();
	~KOSD();

public slots:
	void setPosition( Position );
	void setDisplayTime( u_int );
	void setTextColor( const QColor& );
	void setTextFont( const QFont& );
	void showText( const QString& );
	void setStatus( KOSD::Status );
	void setVolume( int );

private slots:
	void _showLabel();
	void _setPosition();
	QString _volumeString();
	QString _statusString();

protected:
	virtual void updateMask(void);

protected:
	Position _position;
	Status _status;
	QFont _font;
	QColor _color;
	int _displayTime;
	int _volume;

	QString _lastMessage;

	QTimer *_displayTimer;
};

#endif
