/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCache;
import sun.plugin.net.protocol.http.HttpUtils;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.ProgressTracker;
import sun.plugin.usability.Trace;

public class CachedJarLoader {
    private URL url;
    private HttpURLConnection uc = null;
    private long lastModified = 0L;
    private long expiration = 0L;
    private boolean upToDate = false;
    private boolean upToDateChecked = false;
    private File dataFile = null;
    private File indexFile = null;
    private boolean cached = false;
    private long size = 0L;
    private FileVersion version = new FileVersion();

    public CachedJarLoader(URL uRL, boolean bl) throws IOException {
        this.url = uRL;
        this.cached = this.getCacheFile();
        if (bl) {
            if (this.cached) {
                this.upToDate = this.isUpToDate();
                this.upToDateChecked = true;
            } else {
                this.size = Cache.getFileSizeFromServer(uRL);
            }
        }
    }

    public long getJarSize() {
        return this.size;
    }

    public URL getURL() {
        return this.url;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public void setIndexFile(File file) {
        this.indexFile = file;
    }

    public void setLastModify(long l) {
        this.lastModified = l;
    }

    public void setExpiration(long l) {
        this.expiration = l;
    }

    public void setVersion(FileVersion fileVersion) {
        this.version = fileVersion;
    }

    public CachedJarFile load() throws IOException {
        CachedJarFile cachedJarFile = this.loadFromCache();
        if (cachedJarFile == null && (cachedJarFile = this.download()) != null && Cache.cleanupThread != null) {
            Cache.privileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    Cache.cleanupThread.addedJar(CachedJarLoader.this.dataFile.length() + CachedJarLoader.this.indexFile.length());
                    return null;
                }
            });
        }
        return cachedJarFile;
    }

    private CachedJarFile loadFromCache() {
        CachedJarFile cachedJarFile;
        block4: {
            cachedJarFile = null;
            try {
                if (!this.cached) break block4;
                if (!this.upToDateChecked) {
                    this.upToDate = this.isUpToDate();
                }
                if (this.upToDate) {
                    Cache.msgPrintln("cache.loading", new Object[]{this.url});
                    ProgressTracker.onProgressComplete(this.url);
                    cachedJarFile = (CachedJarFile)Cache.privileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            CachedJarLoader.this.indexFile.setLastModified(System.currentTimeMillis());
                            return CachedJarLoader.this.authenticateFromCache();
                        }
                    });
                    break block4;
                }
                Cache.privileged(new Cache.CacheIOAction(){

                    public Object run() throws IOException {
                        Cache.removeFromTable(CachedJarLoader.this.indexFile, JarCache.filesInCache);
                        if (!CachedJarLoader.this.dataFile.delete()) {
                            CachedJarLoader.this.dataFile.deleteOnExit();
                        }
                        if (!CachedJarLoader.this.indexFile.delete()) {
                            FileOutputStream fileOutputStream = new FileOutputStream(CachedJarLoader.this.indexFile);
                            fileOutputStream.write(1);
                            fileOutputStream.close();
                            CachedJarLoader.this.indexFile.deleteOnExit();
                        }
                        CachedJarLoader.this.dataFile = null;
                        CachedJarLoader.this.indexFile = null;
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Cache.msgPrintln("cache.load_warning", new Object[]{this.url});
            }
        }
        return cachedJarFile;
    }

    private boolean getCacheFile() throws IOException {
        final CachedJarLoader cachedJarLoader = this;
        return (Boolean)Cache.privileged(new Cache.CacheIOAction(){

            public Object run() throws IOException {
                boolean bl = false;
                bl = JarCache.getMatchingFile(cachedJarLoader);
                return bl;
            }
        });
    }

    public boolean isVersionUpToDate(FileVersion fileVersion) {
        boolean bl = false;
        this.upToDate = bl = this.version.isUpToDate(fileVersion);
        this.upToDateChecked = true;
        return bl;
    }

    private boolean isUpToDate() throws IOException {
        boolean bl = false;
        if (this.expiration != 0L && new Date().before(new Date(this.expiration))) {
            bl = true;
        }
        if (!bl && this.lastModified != 0L) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc.setIfModifiedSince(this.lastModified);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 304) {
                this.uc.disconnect();
                bl = true;
            } else if (n >= 200 && n <= 299) {
                long l = this.lastModified;
                long l2 = this.expiration;
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == l) {
                    this.uc.disconnect();
                    bl = true;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(l));
                    String string2 = dateFormat.format(new Date(this.lastModified));
                    Cache.msgPrintln("cache.out_of_date", new Object[]{this.url, string, string2});
                    this.size = this.uc.getContentLength();
                }
            } else {
                Cache.msgPrintln("cache.response_warning", new Object[]{String.valueOf(n), this.url});
            }
        }
        return bl;
    }

    private CachedJarFile download() throws IOException {
        if (this.uc == null) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n < 200 || n >= 300) {
                throw new IOException("Could not connect to " + this.url + " with response code " + n);
            }
            this.lastModified = this.uc.getLastModified();
            this.expiration = this.uc.getExpiration();
        }
        if (this.lastModified == 0L && this.expiration == 0L) {
            Trace.msgPrintln("cache.header_fields_missing");
            return null;
        }
        Cache.msgPrintln("cache.downloading", new Object[]{this.url});
        return (CachedJarFile)Cache.privileged(new Cache.CacheIOAction(){

            public Object run() throws IOException {
                String string = JarCache.generateCacheFileName(CachedJarLoader.this.url);
                CachedJarLoader.this.dataFile = new File(JarCache.directory, string + ".zip");
                CachedJarLoader.this.indexFile = new File(JarCache.directory, string + ".idx");
                CachedJarLoader.this.markAsIncomplete();
                CachedJarLoader.this.decompress();
                CachedJarFile cachedJarFile = CachedJarLoader.this.authenticate();
                Cache.msgPrintln("cache.cached_name", new Object[]{CachedJarLoader.this.dataFile.getName()});
                return cachedJarFile;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress() throws IOException {
        boolean bl = false;
        ZipInputStream zipInputStream = null;
        ZipInputStream zipInputStream2 = null;
        ZipOutputStream zipOutputStream = null;
        try {
            Object object;
            zipInputStream2 = new ZipInputStream(new BufferedInputStream(this.uc.getInputStream()));
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile)));
            zipOutputStream.setLevel(JarCache.compression);
            ZipEntry zipEntry = zipInputStream2.getNextEntry();
            if (this.url.toString().toLowerCase().endsWith(".jarjar")) {
                while (zipEntry != null) {
                    if (zipEntry.toString().toLowerCase().startsWith("meta-inf/")) {
                        zipEntry = zipInputStream2.getNextEntry();
                        continue;
                    }
                    if (zipEntry.toString().toLowerCase().endsWith(".jar")) break;
                    throw new IOException(ResourceHandler.getMessage("cache.jarjar.invalid_file"));
                }
                zipInputStream = zipInputStream2;
                zipInputStream2 = new ZipInputStream(zipInputStream2);
                zipEntry = zipInputStream2.getNextEntry();
            }
            byte[] byArray = new byte[2048];
            while (zipEntry != null) {
                int n;
                object = (ZipEntry)zipEntry.clone();
                ((ZipEntry)object).setCompressedSize(-1L);
                zipOutputStream.putNextEntry((ZipEntry)object);
                while ((n = zipInputStream2.read(byArray, 0, byArray.length)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                zipEntry = zipInputStream2.getNextEntry();
            }
            if (zipInputStream != null && (zipEntry = zipInputStream.getNextEntry()) != null) {
                object = null;
                object = !zipEntry.toString().toLowerCase().endsWith(".jar") ? ResourceHandler.getMessage("cache.jarjar.invalid_file") : ResourceHandler.getMessage("cache.jarjar.multiple_jar");
                throw new IOException((String)object);
            }
            bl = true;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (zipInputStream2 != null) {
                zipInputStream2.close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markAsIncomplete() throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
            Object var3_2 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedJarFile authenticate() throws IOException {
        boolean bl = false;
        JarFile jarFile = new JarFile(this.dataFile);
        ObjectOutputStream objectOutputStream = null;
        RandomAccessFile randomAccessFile = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Manifest manifest = null;
        try {
            block28: {
                randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
                randomAccessFile.writeByte(0);
                randomAccessFile.writeUTF(this.url.toString());
                randomAccessFile.writeLong(this.lastModified);
                randomAccessFile.writeLong(this.expiration);
                randomAccessFile.writeInt(1);
                randomAccessFile.writeUTF(this.version.getVersionAsString());
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(randomAccessFile.getFD())));
                manifest = jarFile.getManifest();
                if (manifest != null) {
                    block26: {
                        Object object;
                        Object object2;
                        Object object3;
                        byte[] byArray = new byte[2048];
                        Enumeration<JarEntry> enumeration = jarFile.entries();
                        while (true) {
                            Object object4;
                            Object object5;
                            block27: {
                                if (!enumeration.hasMoreElements()) {
                                    object5 = new ByteArrayOutputStream();
                                    manifest.write((OutputStream)object5);
                                    ((ByteArrayOutputStream)object5).close();
                                    object4 = ((ByteArrayOutputStream)object5).toByteArray();
                                    objectOutputStream.writeInt(((Object)object4).length);
                                    objectOutputStream.write((byte[])object4);
                                    if (!arrayList.isEmpty()) {
                                        break;
                                    }
                                    break block26;
                                }
                                object5 = enumeration.nextElement();
                                object4 = ((ZipEntry)object5).getName();
                                if (((String)object4).toLowerCase().startsWith("meta-inf/") && !((String)object4).equals("META-INF/INDEX.LIST")) continue;
                                object3 = null;
                                try {
                                    object3 = jarFile.getInputStream((ZipEntry)object5);
                                    while (((InputStream)object3).read(byArray, 0, byArray.length) != -1) {
                                    }
                                    object2 = null;
                                    if (object3 == null) break block27;
                                }
                                catch (Throwable throwable) {
                                    object2 = null;
                                    if (object3 != null) {
                                        ((InputStream)object3).close();
                                    }
                                    throw throwable;
                                }
                                ((InputStream)object3).close();
                            }
                            if ((object = ((JarEntry)object5).getCertificates()) != null && ((Certificate[])object).length > 0) {
                                object2 = new int[((Certificate[])object).length];
                                int n = 0;
                                while (true) {
                                    if (n >= ((Object)object).length) {
                                        hashMap.put(object4, object2);
                                        break;
                                    }
                                    int n2 = arrayList.indexOf(object[n]);
                                    if (n2 == -1) {
                                        n2 = arrayList.size();
                                        arrayList.add(object[n]);
                                    }
                                    object2[n] = n2;
                                    ++n;
                                }
                            }
                            this.removeSignature(manifest, (String)object4);
                        }
                        objectOutputStream.writeInt(arrayList.size());
                        object3 = arrayList.iterator();
                        while (true) {
                            if (!object3.hasNext()) break;
                            objectOutputStream.writeObject(object3.next());
                        }
                        object = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
                        object2 = hashMap.keySet().iterator();
                        String string = null;
                        block9: while (true) {
                            String string2;
                            if (!object2.hasNext()) {
                                ((BufferedWriter)object).flush();
                                break block28;
                            }
                            String string3 = (String)object2.next();
                            int[] nArray = (int[])hashMap.get(string3);
                            if (string3.indexOf("/") != -1) {
                                string2 = string3.substring(0, string3.lastIndexOf("/"));
                                if (string != null && string2.equals(string)) {
                                    string3 = string3.substring(string2.length());
                                }
                                string = string2;
                            }
                            ((Writer)object).write(string3);
                            ((BufferedWriter)object).newLine();
                            string2 = String.valueOf(nArray.length);
                            int n = 0;
                            while (true) {
                                if (n >= nArray.length) {
                                    ((BufferedWriter)object).write(string2, 0, string2.length());
                                    ((BufferedWriter)object).newLine();
                                    continue block9;
                                }
                                string2 = string2 + " " + nArray[n];
                                ++n;
                            }
                            break;
                        }
                    }
                    objectOutputStream.writeInt(0);
                } else {
                    objectOutputStream.writeInt(0);
                }
            }
            objectOutputStream.flush();
            randomAccessFile.seek(0L);
            randomAccessFile.writeByte(16);
            bl = true;
        }
        finally {
            jarFile.close();
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
            }
        }
        Certificate[] certificateArray2 = new Certificate[arrayList.size()];
        certificateArray2 = arrayList.toArray(certificateArray2);
        return new CachedJarFile(this.dataFile, certificateArray2, hashMap, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedJarFile authenticateFromCache() throws IOException {
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        Certificate[] certificateArray = null;
        Manifest manifest = null;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "r");
        ObjectInputStream objectInputStream = null;
        try {
            randomAccessFile.readByte();
            randomAccessFile.readUTF();
            randomAccessFile.readLong();
            randomAccessFile.readLong();
            randomAccessFile.readInt();
            randomAccessFile.readUTF();
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(randomAccessFile.getFD())));
            int n = objectInputStream.readInt();
            if (n > 0) {
                byte[] byArray = new byte[n];
                objectInputStream.readFully(byArray, 0, n);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                manifest = new Manifest();
                manifest.read(byteArrayInputStream);
                int n2 = objectInputStream.readInt();
                if (n2 > 0) {
                    certificateArray = new Certificate[n2];
                    try {
                        int n3 = 0;
                        while (n3 < n2) {
                            certificateArray[n3] = (Certificate)objectInputStream.readObject();
                            ++n3;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading certificates");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
                    String string = bufferedReader.readLine();
                    String string2 = null;
                    while (string != null && !string.equals("")) {
                        String string3 = string;
                        if (string3.startsWith("/")) {
                            string3 = string2 + string3;
                        } else {
                            int n4 = string3.lastIndexOf("/");
                            if (n4 != -1) {
                                string2 = string3.substring(0, n4);
                            }
                        }
                        string = bufferedReader.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n5];
                        int n6 = 0;
                        while (n6 < n5) {
                            nArray[n6] = Integer.parseInt(stringTokenizer.nextToken());
                            ++n6;
                        }
                        hashMap.put(string3, nArray);
                        string = bufferedReader.readLine();
                    }
                    Cache.msgPrintln("cache.cert_load", new Object[]{this.url});
                }
            }
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            randomAccessFile.close();
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            throw throwable;
        }
        randomAccessFile.close();
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        return new CachedJarFile(this.dataFile, certificateArray, hashMap, manifest);
    }

    private void removeSignature(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            Set<Object> set = ((Attributes)attributes.clone()).keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Attributes.Name name = (Attributes.Name)iterator.next();
                String string2 = name.toString();
                if (string2.endsWith("-Digest") || string2.indexOf("-Digest-") != -1) {
                    attributes.remove(name);
                }
                if (!string2.equals("Magic:")) continue;
                attributes.remove(name);
            }
            if (attributes.isEmpty()) {
                manifest.getEntries().remove(string);
            }
        }
    }
}

