class Q_EXPORT QPixmap
{
public:
    enum ColorMode {
	Auto,
	Color,
	Mono
    };
    enum Optimization {
	DefaultOptim,
	NoOptim,
	MemoryOptim,
	NormalOptim,
	BestOptim
    };

    QPixmap();
    QPixmap( int w, int h,  int depth = -1, Optimization = QPixmap::DefaultOptim );
    QPixmap( const QSize &, int depth = -1, Optimization = QPixmap::DefaultOptim );
    QPixmap( const QString& fileName, const char *format=0, ColorMode mode = QPixmap::Auto );
    QPixmap( const QString& fileName, const char *format, int conversion_flags );
    QPixmap( const QStringList& lst );
    QPixmap( const QImage& img );
    QPixmap( const QByteArray &data );
    QPixmap( const QPixmap & );

    bool	isNull()	const;

    int		width()		const prop(width);
    int		height()	const prop(height);
    QSize	size()		const prop(size);
    QRect	rect()		const prop(rect);
    int		depth()		const prop(depth);
    static int	defaultDepth();

    void	fill( const QColor &fillColor = Qt::white );
    void	fill( const QWidget *, int xofs, int yofs );
    void	fill( const QWidget *, const QPoint &ofs );
    void	resize( int width, int height );
    void	resize( const QSize & );

    QBitmap     mask() const prop(mask);
    void	setMask( const QBitmap & ) prop(mask);
    bool	selfMask() const prop(selfMask);
    QBitmap	createHeuristicMask( bool clipTight = TRUE ) const;

    static  QPixmap grabWidget( QWidget * widget, int x=0, int y=0, int w=-1, int h=-1 );

    QPixmap	    xForm( const QWMatrix & ) const;
    static QWMatrix trueMatrix( const QWMatrix &, int w, int h );

    QImage	convertToImage() const;
    bool	convertFromImage( const QImage &, ColorMode mode=QPixmap::Auto );
    bool	convertFromImage( const QImage &, int conversion_flags );

    static QString imageFormat( const QString &fileName );
    bool	load( const QString& fileName, const char *format=0, ColorMode mode=Auto );
    bool	load( const QString& fileName, const char *format, int conversion_flags );
    bool	loadFromData( const uchar *buf, uint len, const char* format=0, ColorMode mode=QPixmap::Auto );
    bool	loadFromData( const uchar *buf, uint len, const char* format, int conversion_flags );
    bool	loadFromData( const QByteArray &data, const char* format=0, int conversion_flags=0 );
    bool	save( const QString& fileName, const char* format ) const;

    int		serialNumber()	const prop(serialNumber);

    Optimization	optimization() const prop(optimization);
    void		setOptimization( Optimization ) prop(optimization);
    static Optimization defaultOptimization();
    static void		setDefaultOptimization( Optimization );

    virtual void detach();

    bool	isQBitmap() const prop(isQBitmap);
};
