/***************************************************************************
                            kde_HTMLTableCellElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLTABLECELLELEMENT
#define KDE_HTMLTABLECELLELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The object used to represent the <code> TH </code> and <code> TD
 </code> elements. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TD">
 TD element definition </a> in HTML 4.0.

 
 @short *
 The object used to represent the <code> TH </code> and <code> TD
 </code> elements.
*/
kde_HTMLTableCellElement * kde_new_HTMLTableCellElement();
kde_HTMLTableCellElement * kde_new_HTMLTableCellElement1(kde_HTMLTableCellElement* other);
kde_HTMLTableCellElement * kde_new_HTMLTableCellElement2(kde_DOMNode* other);
void kde_del_HTMLTableCellElement( kde_HTMLTableCellElement* p );

/** *
 The index of this cell in the row.

     
*/
long kde_HTMLTableCellElement_cellIndex(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref cellIndex

 This function is obsolete - the cellIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
void kde_HTMLTableCellElement_setCellIndex(kde_HTMLTableCellElement* instPointer,long arg1);

/** *
 Abbreviation for header cells. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-abbr">
 abbr attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_abbr(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref abbr
     
*/
void kde_HTMLTableCellElement_setAbbr(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Horizontal alignment of data in cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_align(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref align
     
*/
void kde_HTMLTableCellElement_setAlign(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Names group of related headers. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-axis">
 axis attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_axis(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref axis
     
*/
void kde_HTMLTableCellElement_setAxis(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Cell background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_bgColor(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref bgColor
     
*/
void kde_HTMLTableCellElement_setBgColor(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">
 char attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_ch(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref ch
     
*/
void kde_HTMLTableCellElement_setCh(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_chOff(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref chOff
     
*/
void kde_HTMLTableCellElement_setChOff(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Number of columns spanned by cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-colspan">
 colspan attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLTableCellElement_colSpan(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref colSpan
     
*/
void kde_HTMLTableCellElement_setColSpan(kde_HTMLTableCellElement* instPointer,long arg1);

/** *
 List of <code> id </code> attribute values for header cells.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-headers">
 headers attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_headers(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref headers
     
*/
void kde_HTMLTableCellElement_setHeaders(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Cell height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-height-TH">
 height attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_height(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref height
     
*/
void kde_HTMLTableCellElement_setHeight(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Suppress word wrapping. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-nowrap">
 nowrap attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
int kde_HTMLTableCellElement_noWrap(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref noWrap
     
*/
void kde_HTMLTableCellElement_setNoWrap(kde_HTMLTableCellElement* instPointer,int arg1);

/** *
 Number of rows spanned by cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-rowspan">
 rowspan attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLTableCellElement_rowSpan(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref rowSpan
     
*/
void kde_HTMLTableCellElement_setRowSpan(kde_HTMLTableCellElement* instPointer,long arg1);

/** *
 Scope covered by header cells. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-scope">
 scope attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_scope(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref scope
     
*/
void kde_HTMLTableCellElement_setScope(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Vertical alignment of data in cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_vAlign(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref vAlign
     
*/
void kde_HTMLTableCellElement_setVAlign(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

/** *
 Cell width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-TH">
 width attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableCellElement_width(kde_HTMLTableCellElement* instPointer);

/** *
 see @ref width
     
*/
void kde_HTMLTableCellElement_setWidth(kde_HTMLTableCellElement* instPointer,kde_DOMString* arg1);

#endif
