/***************************************************************************
                            kde_KTar.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTAR
#define KDE_KTAR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 @author Torben Weis <weis@kde.org>, David Faure <faure@kde.org>
 
 @short A class for reading/writing (optionnally compressed) tar archives.

*/

/** *
 Creates an instance that operates on the given filename.
 using the compression filter associated to given mimetype.

*/
kde_KTar * kde_new_KTar(qt_QString * filename, qt_QString * mimetype);

/** *
 Creates an instance that operates on the given device.
 The device can be compressed (KFilterDev) or not (QFile, etc.).
 WARNING: don't assume that giving a QFile here will decompress the file,
 in case it's compressed!
     
*/
kde_KTar * kde_new_KTar1(qt_QIODevice * dev);

/** *
 If the tar ball is still opened, then it will be
 closed automatically by the destructor.
     
*/
void kde_del_KTar( kde_KTar* p );

/** *
 The name of the tar file, as passed to the constructor
 Null if you used the QIODevice constructor.
     
*/
qt_QString * kde_KTar_fileName(kde_KTar* instPointer);

/** *
 Special function for setting the "original file name" in the gzip header,
 when writing a tar.gz file. It appears when using in the "file" command,
 for instance. Should only be called if the underlying device is a KFilterDev!
     
*/
void kde_KTar_setOrigFileName(kde_KTar* instPointer,qt_QCString* fileName);
int kde_KTar_writeDir(kde_KTar* instPointer,qt_QString * name, qt_QString * user, qt_QString * group);
int kde_KTar_prepareWriting(kde_KTar* instPointer,qt_QString * name, qt_QString * user, qt_QString * group, unsigned int size);
int kde_KTar_doneWriting(kde_KTar* instPointer,unsigned int size);

/** *
 Opens the archive for reading.
 Parses the directory listing of the archive
 and creates the KArchiveDirectory/KArchiveFile entries.

     
*/
int kde_KTar_openArchive(kde_KTar* instPointer,int mode);
int kde_KTar_closeArchive(kde_KTar* instPointer);
void kde_KTar_virtual_hook(kde_KTar* instPointer,int identifier, void* data);

#endif
