/***************************************************************************
                            kde_TreeWalker.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_TREEWALKER
#define KDE_TREEWALKER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 <code> TreeWalker </code> objects are used to navigate a document
 tree or subtree using the view of the document defined by its
 <code> whatToShow </code> flags and any filters that are defined
 for the <code> TreeWalker </code> . Any function which performs
 navigation using a <code> TreeWalker </code> will automatically
 support any view defined by a <code> TreeWalker </code> .

  Omitting nodes from the logical view of a subtree can result in a
 structure that is substantially different from the same subtree in
 the complete, unfiltered document. Nodes that are siblings in the
 TreeWalker view may be children of different, widely separated
 nodes in the original view. For instance, consider a Filter that
 skips all nodes except for Text nodes and the root node of a
 document. In the logical view that results, all text nodes will be
 siblings and appear as direct children of the root node, no matter
 how deeply nested the structure of the original document.

 
 @short *
 <code> TreeWalker </code> objects are used to navigate a document
 tree or subtree using the view of the document defined by its
 <code> whatToShow </code> flags and any filters that are defined
 for the <code> TreeWalker </code> .
*/
kde_TreeWalker * kde_new_TreeWalker();
kde_TreeWalker * kde_new_TreeWalker1(kde_TreeWalker* other);
void kde_del_TreeWalker( kde_TreeWalker* p );

/** *
 The root node of the TreeWalker, as specified when it was created.
     
*/
kde_DOMNode* kde_TreeWalker_root(kde_TreeWalker* instPointer);

/** *
 This attribute determines which node types are presented via the
 TreeWalker. The available set of constants is defined in the NodeFilter
 interface. Nodes not accepted by whatToShow will be skipped, but their
 children may still be considered. Note that this skip takes precedence
 over the filter, if any.
     
*/
unsigned long kde_TreeWalker_whatToShow(kde_TreeWalker* instPointer);

/** *
 The filter used to screen nodes.
     
*/
kde_NodeFilter* kde_TreeWalker_filter(kde_TreeWalker* instPointer);

/** *
 The value of this flag determines whether the children of entity
 reference nodes are visible to the TreeWalker. If false, they and their
 descendents will be rejected. Note that this rejection takes precedence
 over whatToShow and the filter, if any.

 To produce a view of the document that has entity references expanded
 and does not expose the entity reference node itself, use the whatToShow
 flags to hide the entity reference node and set expandEntityReferences
 to true when creating the TreeWalker. To produce a view of the document
 that has entity reference nodes but no entity expansion, use the
 whatToShow flags to show the entity reference node and set
 expandEntityReferences to false.
     
*/
int kde_TreeWalker_expandEntityReferences(kde_TreeWalker* instPointer);

/** *
 The node at which the TreeWalker is currently positioned.
 Alterations to the DOM tree may cause the current node to no longer be
 accepted by the TreeWalker's associated filter. currentNode may also be
 explicitly set to any node, whether or not it is within the subtree
 specified by the root node or would be accepted by the filter and
 whatToShow flags. Further traversal occurs relative to currentNode even
 if it is not part of the current view, by applying the filters in the
 requested direction; if no traversal is possible, currentNode is not changed.

*/
kde_DOMNode* kde_TreeWalker_currentNode(kde_TreeWalker* instPointer);

/** *
 see @ref currentNode
     
*/
void kde_TreeWalker_setCurrentNode(kde_TreeWalker* instPointer,kde_DOMNode* _currentNode);

/** *
 Moves to and returns the parent node of the current node. If
 there is no parent node, or if the current node is the root
 node from which this TreeWalker was created, retains the
 current position and returns null.

     
*/
kde_DOMNode* kde_TreeWalker_parentNode(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the first child of the
 current node, and returns the new node. If the current node has
 no children, returns <code> null </code> , and retains the
 current node.

     
*/
kde_DOMNode* kde_TreeWalker_firstChild(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the last child of the
 current node, and returns the new node. If the current node has
 no children, returns <code> null </code> , and retains the
 current node.

     
*/
kde_DOMNode* kde_TreeWalker_lastChild(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the previous sibling of
 the current node, and returns the new node. If the current node
 has no previous sibling, returns <code> null </code> , and
 retains the current node.

     
*/
kde_DOMNode* kde_TreeWalker_previousSibling(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the next sibling of the
 current node, and returns the new node. If the current node has
 no next sibling, returns <code> null </code> , and retains the
 current node.

     
*/
kde_DOMNode* kde_TreeWalker_nextSibling(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the previous node in
 document order relative to the current node, and returns the
 new node. If the current node has no previous node, returns
 <code> null </code> , and retains the current node.

     
*/
kde_DOMNode* kde_TreeWalker_previousNode(kde_TreeWalker* instPointer);

/** *
 Moves the <code> TreeWalker </code> to the next node in
 document order relative to the current node, and returns the
 new node. If the current node has no next node, returns <code>
 null </code> , and retains the current node.

     
*/
kde_DOMNode* kde_TreeWalker_nextNode(kde_TreeWalker* instPointer);

/** *

 not part of the DOM
     
*/
//kde_TreeWalkerImpl* kde_TreeWalker_handle(kde_TreeWalker* instPointer);
int kde_TreeWalker_isNull(kde_TreeWalker* instPointer);

#endif
