/***************************************************************************
                            DCOPObject.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides an interface for receiving DCOP messages.

 This class provides an interface for receiving DCOP messages.  To use it,
 simply multiply-inherit from DCOPObject and from some other class, and
 then implement the {@link DCOPObject#process} method.  Because this method is
 pure virtual, you must implement the method.

 Note that it is usually more convenient to mark a section in the class with
 "k_dcop:", add your DCOP methods there and let the IDL compiler do the rest.
 Read the tutorials for more information.

 @author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>
 
 @short *
 Provides an interface for receiving DCOP messages.
*/
public class  DCOPObject implements QtSupport, DCOPObjectInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DCOPObject(Class dummy){}

	private native void newDCOPObject();

/** 
 Creates a DCOPObject and calculates the object id
 using its physical memory address.
   
*/
	public DCOPObject() {
		newDCOPObject();
	}
	private native void newDCOPObject( QObject obj);

/** 
 Creates a DCOPObject and calculates the object id
 using {@link QObject#name}.

*/
	public DCOPObject( QObject obj) {
		newDCOPObject( obj);
	}
	private native void newDCOPObject( String objId);

/** 
 Creates a DCOPObject with object Id <code>objId.</code>

*/
	public DCOPObject( String objId) {
		newDCOPObject( objId);
	}

/** 
 Destroys the DCOPObject and removes it from the map
 of known objects.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the object id of the DCOPObject.

*/
	public native String objId();

/** 
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
	public native boolean setObjId( String objId);

/** 
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns false, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation. It handles the functions "functions()" and
 "interfaces()" which return the lists of supported functions
 and interfaces, respectively.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	public native ArrayList functionsDynamic();

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	public native ArrayList interfacesDynamic();

/** 
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/** 
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/** 
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/** 
 Connects to a DCOP signal.

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/** 
 Disconnects a DCOP signal.

 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/** 
 Returns the {@link DCOPClient} responsible for making the call. 
 Only call this function while you are handling a DCOP call.

*/
	public native DCOPClient callingDcopClient();

/** 

*/
	public native void setCallingDcopClient( DCOPClient arg1);

/** 
 Checks whether an object with the given id is known in this process.

 {@link DCOPObjectProxy}
   
*/
	public static native boolean hasObject( String objId);

/** 
 Try to find a dcop object with the given id.
 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/** 
 Tries to find an object using a partial object id.
 This function is used for multicasting a DCOP message to
 several objects inside a single process.

*/
//	public static native QPtrList<DCOPObject> match( String partialId);

/** 
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

/** 
 The object id of this DCOPObject.
   
*/
	protected native void virtual_hook( int identifier, int data);
}
