/***************************************************************************
                            KURLDrag.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is to be used instead of QUriDrag when using KURL.
 The reason is: QUriDrag (and the XDND/W3C standards) expect URLs to
 be encoded in UTF-8 (unicode), but KURL uses the current locale
 by default.
 The other reasons for using this class are:

 To create a drag object, use KURLDrag.newDrag() with a list of KURLs.
 To decode a drop, use KURLDrag.decode() or QUriDrag.decodeLocalFiles().
 
 See {@link KURLDragSignals} for signals emitted by KURLDrag.

 

 @short *
 This class is to be used instead of QUriDrag when using KURL.
*/
public class KURLDrag extends QUriDrag  {
	protected KURLDrag(Class dummy){super((Class) null);}

	private native void newKURLDrag( ArrayList urls, QWidget dragSource, String name);

/** 
 Constructs an object to drag the list of URLs in <code>urls.</code>
 The <code>dragSource</code> and <code>name</code> arguments are passed on to QUriDrag,
 and the list of urls is converted to UTF-8 before being passed
 to QUriDrag.

*/
	public KURLDrag( ArrayList urls, QWidget dragSource, String name) {
		super((Class) null);
		newKURLDrag( urls, dragSource, name);
	}
	private native void newKURLDrag( ArrayList urls, String metaData, QWidget dragSource, String name);

/** 
 Constructs an object to drag the list of URLs in <code>urls.</code>
 This version also includes metadata.

*/
	public KURLDrag( ArrayList urls, String metaData, QWidget dragSource, String name) {
		super((Class) null);
		newKURLDrag( urls, metaData, dragSource, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Meta-data to associate with those URLs (to be used after newDrag).
 This is an alternative way of setting the metadata:
 either use the constructor to pass it all at once, or use
 drag.metaData()["key"] = data;

*/
	public native String metaData();

/** 

   
*/
	public static native KURLDrag newDrag( ArrayList urls, QWidget dragSource, String name);
	public static native KURLDrag newDrag( ArrayList urls);

/** 

   
*/
	public static native KURLDrag newDrag( ArrayList urls, String metaData, QWidget dragSource, String name);
	public static native KURLDrag newDrag( ArrayList urls, String metaData);

/** 
 Convenience method that decodes the contents of <code>e</code>
 into a list of KURLs.

*/
	public static native boolean decode( QMimeSourceInterface e, ArrayList urls);

/** 
 Convenience method that decodes the contents of <code>e</code>
 into a list of KURLs and a set of metadata.
 You should be using this one, if possible.

*/
	public static native boolean decode( QMimeSourceInterface e, ArrayList urls, String metaData);
	private native void newKURLDrag( String[] urls, String metaData, QWidget dragSource, String name);

/** 
 Protected constructor - use {@link newDrag}
   
*/
	public KURLDrag( String[] urls, String metaData, QWidget dragSource, String name) {
		super((Class) null);
		newKURLDrag( urls, metaData, dragSource, name);
	}
	public native String format( int i);
	public native byte[] encodedData( String mime);
}
