/***************************************************************************
                            KComboBox.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOMBOBOX_H
#define KCOMBOBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KCompletionBase.h>
#include <qtobjc/QComboBox.h>

/**

 A combined button, line-edit and a popup list widget.

 This widget inherits from @ref QComboBox and implements
 the following additional functionalities:  a completion
 object that provides both automatic and manual text
 completion as well as text rotation features, configurable
 key-bindings to activate these features, and a popup-menu
 item that can be used to allow the user to set text completion
 modes on the fly based on their preference.

 To support these new features KComboBox also emits a few
 more additional signals as well.  The main ones are the
 @ref completion( const QString& ) and @ref textRotation( KeyBindgingType )
 signals.  The completion signal is intended to be connected to a slot
 that will assist the user in filling out the remaining text while
 the rotation signals is intended to be used to traverse through all
 possible matches whenever text completion results in multiple matches.
 The @ref -returnPressed and @ref returnPressed( const QString& )
 signal is emitted when the user presses the Enter/Return key.

 This widget by default creates a completion object when you invoke
 the @ref completionObject( bool ) member function for the first time
 or use @ref setCompletionObject( KCompletion*, bool ) to assign your
 own completion object.  Additionally, to make this widget more functional,
 KComboBox will by default handle the text rotation and completion
 events internally whenever a completion object is created through either
 one of the methods mentioned above.  If you do not need this functionality,
 simply use @ref -[KCompletionBase setHandleSignals]( bool ) or alternatively
 set the boolean parameter in the above methods to FALSE.

 The default key-bindings for completion and rotation is determined
 from the global settings in @ref KStdAccel.  These values, however,
 can be overriden locally by invoking @ref -[KCompletionBase setKeyBinding].
 The values can easily be reverted back to the default setting, by simply
 calling @ref -useGlobalSettings. An alternate method would be to default
 individual key-bindings by usning @ref -setKeyBinding with the default
 second argument.

 Note that if this widget is not editable ( i.e. select-only ), then only
 one completion mode, @p CompletionAuto, will work.  All the other modes are
 simply ignored.  The @p CompletionAuto mode in this case allows you to
 automatically select an item from the list by trying to match the pressed
 keycode with the first letter of the enteries in the combo box.

 To enable the basic completion feature:

 <pre>
 KComboBox *combo = new KComboBox( true, this, "mywidget" );
 KCompletion *comp = -[combo completionObject];
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 To use your own completion object:

 <pre>
 KComboBox *combo = new KComboBox( this,"mywidget" );
 KURLCompletion *comp = new -KURLCompletion;
 -[combo setCompletionObject]( comp );
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 Miscellaneous function calls:

 <pre>
 // Tell the widget not to handle completion and rotation
 -[combo setHandleSignals]( false );
 // Set your own completion key for manual completions.
 -[combo setKeyBinding]( -[KCompletionBase TextCompletion], -[Qt End]);
 // Hide the context (popup) menu
 -[combo setContextMenuEnabled]( false );
 // Temporarly disable signal emition
 -[combo disableSignals];
 // Default the all key-bindings to their system-wide settings.
 -[combo useGlobalKeyBindings];
 </pre>

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced combo box.

*/

@class KCompletionBox;
@class KURL;


@interface KComboBox : QComboBox

/** 
 Constructs a read-only or rather select-only combo box with a
 parent object and a name.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a "read-write" or "read-only" combo box depending on
 the value of the first argument( @p rw ) with a parent, a
 name.

*/
- initWithBOOL: (BOOL)rw parent: (QWidget *)parent name: (NSString *)name;
- initWithBOOL: (BOOL)rw ;

/** 
 Destructor.
    
*/
- (void) dealloc;

/** 
 Sets @p url into the edit field of the combobox. It uses
 @ref -[KURL prettyURL] so that the url is properly decoded for
 displaying.
     
*/
- setEditURL: (KURL*)url;

/** 
 Inserts @p url at position @p index into the combobox. The item will
 be appended if @p index is negative. @ref -[KURL prettyURL] is used
 so that the url is properly decoded for displaying.
     
*/
- insertURL: (KURL*)url index: (int)index;
- insertURL: (KURL*)url ;

/** 
 Inserts @p url with the pixmap &p pixmap at position @p index into
 the combobox. The item will be appended if @p index is negative.
 @ref -[KURL prettyURL] is used so that the url is properly decoded
 for displaying.
     
*/
- insertURL: (QPixmap *)pixmap url: (KURL*)url index: (int)index;
- insertURL: (QPixmap *)pixmap url: (KURL*)url ;

/** 
 Replaces the item at position @p index with @p url.
 @ref -[KURL prettyURL] is used so that the url is properly decoded
 for displaying.
     
*/
- changeURL: (KURL*)url index: (int)index;

/** 
 Replaces the item at position @p index with @p url and pixmap @p pixmap.
 @ref -[KURL prettyURL] is used so that the url is properly decoded
 for displaying.
     
*/
- changeURL: (QPixmap *)pixmap url: (KURL*)url index: (int)index;

/** 
 Returns the current cursor position.

 This method always returns a -1 if the combo-box is @em not
 editable (read-write).

*/
- (int) cursorPosition;

/** 
 Re-implemented from @ref QComboBox.

 If @p true, the completion mode will be set to automatic.
 Otherwise, it is defaulted to the global setting.  This
 method has been replaced by the more comprehensive
 @ref -setCompletionMode.

*/
- setAutoCompletion: (BOOL)autocomplete;

/** 
 Re-implemented from QComboBox.

 Returns @p true if the current completion mode is set
 to automatic.  See its more comprehensive replacement
 @ref -completionMode.

*/
- (BOOL) autoCompletion;

/** 
 Enables or disable the popup (context) menu.

 This method only works if this widget is editable, i.e.
 read-write and allows you to enable/disable the context
 menu.  It does nothing if invoked for a none-editable
 combo-box.  Note that by default the mode changer item
 is made visiable whenever the context menu is enabled.
 Use @ref -hideModechanger if you want to hide this
 item.    Also by default, the context menu is created if
 this widget is editable. Call this function with the
 argument set to false to disable the popup menu.

*/
- setContextMenuEnabled: (BOOL)showMenu;

/** 
 Returns @p true when the context menu is enabled.
    
*/
- (BOOL) isContextMenuEnabled;

/** 
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QComboBox is used, which inserts the encoded URL.

*/
- setURLDropsEnabled: (BOOL)enable;

/** 
 Returns @p true when decoded URL drops are enabled
     
*/
- (BOOL) isURLDropsEnabled;

/** 
 Convenience method which iterates over all items and checks if
 any of them is equal to @p text.

 If @p text is an empty string, @p false
 is returned.

*/
- (BOOL) contains: (NSString *)text;

/** 
 By default, KComboBox recognizes Key_Return and Key_Enter
 and emits
 the @ref -returnPressed signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with @p trap equal to true to make KComboBox
 stop these
 events. The signals will still be emitted of course.

 Only affects read-writable comboboxes.

*/
- setTrapReturnKey: (BOOL)trap;

/** 

*/
- (BOOL) trapReturnKey;

/** 

*/
- (KCompletionBox*) completionBox: (BOOL)create;
- (KCompletionBox*) completionBox;
- setLineEdit: (QLineEdit*)arg1;

/** 
 Iterates through all possible matches of the completed text
 or the history list.

 Depending on the value of the argument, this function either
 iterates through the history list of this widget or the all
 possible matches in whenever multiple matches result from a
 text completion request.  Note that the all-possible-match
 iteration will not work if there are no previous matches, i.e.
 no text has been completed and the *nix shell history list
 rotation is only available if the insertion policy for this
 widget is set either @p -[QComobBox AtTop]or @p -[QComboBox AtBottom].
 For other insertion modes whatever has been typed by the user
 when the rotation event was initiated will be lost.

*/
//- rotateText: (KCompletionBase_KeyBindingType*)arg1;

/** 
 Sets the completed text in the line-edit appropriately.

 This function is an implementation for
 @ref -[KCompletionBase setCompletedText].
     
*/
- setCompletedText: (NSString *)arg1;

/** 
 Sets @p items into the completion-box if @ref -completionMode is
 CompletionPopup. The popup will be shown immediately.
     
*/
- setCompletedItems: (NSArray *)items;

/** 
 Selects the first item that matches @p item. If there is no such item,
 it is inserted at position @p index if @p insert is true. Otherwise,
 no item is selected.
     
*/
- setCurrentItem: (NSString *)item insert: (BOOL)insert index: (int)index;
- setCurrentItem: (NSString *)item ;
- setCurrentItemId: (int)index;
- setCompletedText: (NSString *)arg1 bool: (BOOL)arg2;

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
- create: (unsigned int)arg1 initializeWindow: (BOOL)initializeWindow destroyOldWindow: (BOOL)destroyOldWindow;
- create;

/** 

    
*/
- itemSelected: (QListBoxItem *)arg1;

/** 
 Completes text according to the completion mode.

 Note: this method is @p not invoked if the completion mode is
 set to CompletionNone.  Also if the mode is set to @p CompletionShell
 and multiple matches are found, this method will complete the
 text to the first match with a beep to inidicate that there are
 more matches.  Then any successive completion key event iterates
 through the remaining matches.  This way the rotation functionality
 is left to iterate through the list as usual.
    
*/
- makeCompletion: (NSString *)arg1;
@end


@interface KComboBox (KCompletionBaseImplementation) <KCompletionBaseInterface>
@end

@class KCompletionBox; 
@class KURL; 

/** Override these methods in subclasses of KComboBox to customise event handling behaviour */
@protocol KComboBoxEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
