/***************************************************************************
                            KDatePicker.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDATEPICKER_H
#define KDATEPICKER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 Provides a widget for calendar date input.

     Different from the
     previous versions, it now emits two types of signals, either
     @ref -dateSelected or @ref -dateEntered (see documentation for both
     signals).

     A line edit has been added in the newer versions to allow the user
     to select a date directly by entering numbers like 19990101
     or 990101.

 @author Tim Gilman, Mirko Boehm

 @version $Id: KDatePicker.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short A date selection widget.

*/
@interface KDatePicker : QFrame 

/**  The usual constructor.  The given date will be displayed
 initially.

*/
- initWithWidget: (QWidget *)parent date: (NSDate *)arg1 name: (NSString *)name;
- init;

/** 
 The destructor.

*/
- (void) dealloc;

/**  The size hint for date pickers. The size hint recommends the
   minimum size of the widget so that all elements may be placed
  without clipping. This sometimes looks ugly, so when using the
  size hint, try adding 28 to each of the reported numbers of
  pixels.

*/
- (QSize*) sizeHint;

/** 
 Sets the date.

*/
- (BOOL) setDate: (NSDate *)arg1;

/** 
 Returns the selected date.

*/
- (NSDate *) getDate;

/** 
 Enables or disables the widget.

*/
- setEnabled: (BOOL)arg1;

/** 
 Sets the font size of the widgets elements.

*/
- setFontSize: (int)arg1;

/** 
 Returns the font size of the widget elements.
   
*/
- (int) fontSize;
- dateChangedSlot: (NSDate *)arg1;
- tableClickedSlot;
- monthForwardClicked;
- monthBackwardClicked;
- yearForwardClicked;
- yearBackwardClicked;
- selectMonthClicked;
- selectYearClicked;
- lineEnterPressed;
@end

/** Override these methods in subclasses of KDatePicker to customise event handling behaviour */
@protocol KDatePickerEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
