/***************************************************************************
                            KLibrary.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLIBRARY_H
#define KLIBRARY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


 KLibrary allows you to look up symbols of the shared library.

 @author Torben Weis <weis@kde.org>
 
 @short Represents a dynamically loaded library.

*/
@class KLibFactory; 

@interface KLibrary : QObject 

/** 

 Don't create KLibrary objects on your own. Instead use @ref KLibLoader.
     
*/
- initWithText: (NSString *)libname filename: (NSString *)filename handle: (void*)handle;

/** 

*/
- (NSString *) name;

/** 

*/
- (NSString *) fileName;

/** 

*/
- (KLibFactory*) factory;

/** 
 Looks up a symbol from the library. This is a very low level
 function that you usually don't want to use.
     
*/
- (void*) symbol: (NSString *)name;

/** 
 Unloads the library. 
 This typically results in the deletion of this object. You should
 not reference its pointer after calling this function.
     
*/
- unload;
@end

/** Override these methods in subclasses of KLibrary to customise event handling behaviour */
@protocol KLibraryEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
