/***************************************************************************
                            KPushButton.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPUSHBUTTON_H
#define KPUSHBUTTON_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QPushButton.h>

/**

 This is nothing but a QPushButton with drag-support and KGuiItem support. You have to call
 @ref setDragEnabled( true ) and override the virtual method 
 @ref -dragObject to specify the QDragObject to be used.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A QPushButton with drag-support and KGuiItem support.
*/
@class QDragObject; 

@class KGuiItem; 

@interface KPushButton : QPushButton 

/** 
 Default constructor.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructor, that sets the button-text to @p text
     
*/
- initWithText: (NSString *)text parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)text parent: (QWidget *)parent ;

/** 
 Constructor, that sets an icon and the button-text to @p text
     
*/
- initWithIconSet: (QIconSet*)icon text: (NSString *)text parent: (QWidget *)parent name: (NSString *)name;
- initWithIconSet: (QIconSet*)icon text: (NSString *)text parent: (QWidget *)parent ;

/** 
 Constructor that takes a KGuiItem for the text, the icon, the tooltip
 and the what's this help
     
*/
- initWithGuiItem: (KGuiItem*)item parent: (QWidget *)parent name: (NSString *)name;
- initWithGuiItem: (KGuiItem*)item parent: (QWidget *)parent ;

/** 
 Destructs the button.
     
*/
- (void) dealloc;

/** 
 Enables/disables drag-support. Default is enabled.
     
*/
- setDragEnabled: (BOOL)enable;

/** 

*/
- (BOOL) isDragEnabled;

/** 
 Reimplement this and return the QDragObject that should be used
 for the drag.
 Default implementation returns 0L, so that no drag is initiated.
     
*/
- (QDragObject*) dragObject;

/** 
 Starts a drag (-dragCopy by default) using @ref -dragObject
     
*/
- startDrag;
@end

/** Override these methods in subclasses of KPushButton to customise event handling behaviour */
@protocol KPushButtonEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 
 Reimplemented to add drag-support
     
*/
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 
 Reimplemented to add drag-support
     
*/
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
