/***************************************************************************
                            KServerSocket.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVERSOCKET_H
#define KSERVERSOCKET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


 Please use the more powerful KExtendedSocket class.

 You can use a KServerSocket to listen on a port for incoming
 connections. When a connection arrived in the port, a KSocket
 is created and the signal accepted is raised. Make sure you
 always connect to this signal. If you don't the ServerSocket will
 create new KSocket's and no one will delete them!

 If -socket is -1 or less the socket was not created properly.

 @author Torben Weis <weis@stud.uni-frankfurt.de>

 @version $Id: KServerSocket.h,v 1.4 2002/03/23 10:57:57 rdale Exp $

 @short Monitors a port for incoming TCP/IP connections.

*/
@interface KServerSocket : QObject 

/** 
 Constructor.

*/
- initWithUnsigned: (unsigned short)_port _bind: (BOOL)_bind;
- initWithUnsigned: (unsigned short)_port ;

/** 
 Creates a UNIX domain server socket.

*/
- initWithText: (NSString *)_path _bind: (BOOL)_bind;
- initWithText: (NSString *)_path ;

/**  
 Destructor. Closes the socket if it was not already closed.
     
*/
- (void) dealloc;

/** 
 Binds the socket and start listening. This should only be called
 once when the constructor was called with _bind false.

*/
- (BOOL) bindAndListen;

/**  
 Returns the file descriptor associated with the socket.
 Returns -1 when an error occured during construction or
 @ref bindAndListen
     
*/
- (int) socket;

/**  
 Returns the port number which is being monitored.
     
*/
- (unsigned short) port;

/**  
 The address.
 This is dumb. Don't use it
 Refer to @ref -[KExtendedSocket localAddress]

     
*/
- (unsigned long) ipv4_addr;

/**  
 Called when someone connected to our port.
     
*/
- slotAccept: (int)arg1;
- (BOOL) initWithId: (short)arg1;
- (BOOL) init: (NSString *)_path;
@end

/** Override these methods in subclasses of KServerSocket to customise event handling behaviour */
@protocol KServerSocketEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
