/***************************************************************************
                            ReadWritePart.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef READWRITEPART_H
#define READWRITEPART_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/ReadOnlyPart.h>

/**

 Base class for an "editor" part.

 This class handles network transparency for you.
 Anything that can open a URL, allow modifications, and save
 (to the same URL or a different one).

 A read-write part can be set to read-only mode, using @ref -setReadWrite.

 Part writers :
 Any part inheriting ReadWritePart should check @ref isReadWrite
 before allowing any action that modifies the part.
 The part probably wants to reimplement @ref setReadWrite, disable those
 actions. Don't forget to call the parent @ref setReadWrite.
 
 @short 
 Base class for an "editor" part.
*/
@class GUIActivateEvent; 
@class KURL; 
@class PartActivateEvent; 
@class PartSelectEvent; 

@interface ReadWritePart : ReadOnlyPart 

/** 
 Destructor
 Applications using a ReadWritePart should make sure, before
 destroying it, to call @ref  #--closeURL.
 In @ref -[KMainWindow queryClose], for instance, they should allow
 closing only if the return value of @ref  #--closeURL was true.
 This allows to cancel.
   
*/
- (void) dealloc;

/** 

*/
- (BOOL) isReadWrite;

/** 
 Changes the behaviour of this part to readonly or readwrite.

*/
- setReadWrite: (BOOL)readwrite;
- setReadWrite;

/** 

*/
- (BOOL) isModified;

/** 
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that @ref -openURL calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Reimplemented from ReadOnlyPart, to handle modified parts
 (and suggest saving in this case, with yes/no/cancel).

*/
- (BOOL) closeURL;

/** 
 Save the file to a new location.

 Calls @ref -save, no need to reimplement
   
*/
- (BOOL) saveAs: (KURL*)url;

/** 
  Sets the modified flag of the part.
   
*/
- setModified: (BOOL)modified;

/** 
 Call @ref -setModified whenever the contents get modified.
 This is a slot for convenience, so that you can connect it
 to a signal, like -textChanged.
   
*/
- setModified;

/** 
 Save the file in the location from which it was opened.
 You can connect this to the "save" action.
 Calls @ref -saveFile and @ref -saveToURL, no need to reimplement.
   
*/
- (BOOL) save;
@end

/** Override these methods in subclasses of ReadWritePart to customise event handling behaviour */
@protocol ReadWritePartEventHandling

/** 
 Convenience method which is called when the Part received a @ref PartActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and test for the event yourself
 or even install an event filter.
     
*/
- partActivateEvent:(PartActivateEvent*) event;

/** 
 Convenience method which is called when the Part received a
 @ref PartSelectEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/
- partSelectEvent:(PartSelectEvent*) event;
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) event;

/** 
 Reimplemented from Part, so that the window caption is set to
 the current url (decoded) when the part is activated
 This is the usual behaviour in 99% of the apps
 Reimplement if you don't like it - test for -[event activated] !

 Technical note : this is done with GUIActivateEvent and not with
 PartActivateEvent because it's handled by the mainwindow
 (which gets the even after the PartActivateEvent events have been sent)
   
*/
- guiActivateEvent:(GUIActivateEvent*) event;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
