/***************************************************************************
* $Id: DigitalClock.java,v 1.2 2002/03/07 04:02:11 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.util.Date;
import java.text.*;

class DigitalClock extends QLCDNumber		// digital clock widget
{

private boolean	showingColon;
private int		normalTimer;
private int		showDateTimer;




DigitalClock( )
{
	this(null, null);
}

//
// Constructs a DigitalClock widget with a parent and a name.
//
DigitalClock( QWidget parent )
{
	this(parent, null);
}

DigitalClock( QWidget parent, String name )
{
    super( parent, name );
    showingColon = false;
    setFrameStyle( QFrame.Panel | QFrame.Raised );
    setLineWidth( 2 );				// set frame line width
    showTime();					// display the current time
    normalTimer = startTimer( 500 );		// 1/2 second timer events
    showDateTimer = -1;				// not showing date
}


//
// Handles timer events for the digital clock widget.
// There are two different timers; one timer for updating the clock
// and another one for switching back from date mode to time mode.
//

void timerEvent( QTimerEvent e )
{
    if ( e.timerId() == showDateTimer )	// stop showing date
	stopDate();
    else {					// normal timer
	if ( showDateTimer == -1 )		// not showing date
	    showTime();
    }
}

//
// Enters date mode when the left mouse button is pressed.
//

void mousePressEvent( QMouseEvent e )
{
	if ( e.button() == QMouseEvent.LeftButton )		// left button pressed
	showDate();
}


//
// Shows the current date in the internal lcd widget.
// Fires a timer to stop showing the date.
//

void showDate()
{
	if ( showDateTimer != -1 )			// already showing date
	return;
	// Java always prints at least two digits for the year
	DateFormat dateFormat = new SimpleDateFormat( "yy d" );
    String s = dateFormat.format(new Date());
    display( s );				// sets the LCD number/text
    showDateTimer = startTimer( 2000 );		// keep this state for 2 secs
}

//
// Stops showing the date.
//

void stopDate()
{
    killTimer( showDateTimer );
    showDateTimer = -1;
    showTime();
}

//
// Shows the current time in the internal lcd widget.
//

void showTime()
{
    showingColon = !showingColon;		// toggle/blink colon
	DateFormat timeFormat = new SimpleDateFormat( (showingColon ? "HH:mm": "HH mm") );
    String s = timeFormat.format(new Date());
    display( s );				// set LCD number/text
}
}
