import org.kde.qt.*;

public class KillerFilter extends QObject {

	public boolean eventFilter( QObject object, QEvent event) {
		if (event.type() == QEvent.MouseButtonPress) {
			if ( ((QMouseEvent)event).button() == RightButton ) {
				((QWidget) object).close(true);
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
		
	public static void main(String[] args)
	{
		QApplication a = new QApplication(args);
		
		QWidget toplevel = new QWidget();
		toplevel.resize( 230, 130 );
		
		QObject killerFilter = new KillerFilter();
		
		QPushButton pb = new QPushButton(toplevel);
		pb.setGeometry(10, 10, 100, 50 );
		pb.setText( "pushbutton" );
		pb.installEventFilter( killerFilter );
		
		QLineEdit le = new QLineEdit( toplevel );
		le.setGeometry( 10, 70, 100, 50 );
		le.setText( "Line edit" );
		le.installEventFilter( killerFilter );
		
		QCheckBox cb = new QCheckBox( toplevel );
		cb.setGeometry( 120, 10, 100, 50 );
		cb.setText( "Check-box" );
		cb.installEventFilter( killerFilter );
		
		QRadioButton rb = new QRadioButton( toplevel );
		rb.setGeometry( 120, 70, 100, 50 );
		rb.setText( "Radio button" );
		rb.installEventFilter( killerFilter );
		
		a.setMainWidget(toplevel);
		toplevel.show();
		a.exec();
		return;
	}
	
	static {
                qtjava.initialize();
	}
}
