/***************************************************************************
                          geoline.h  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GEOLINE_H
#define GEOLINE_H

#include <geoobjects.h>

/**This class is the base class for all line-like objects.
  *@author Marc Bartsch
  */

class GeoLine : public GeoObjects
{
	public:

		GeoLine();
		virtual ~GeoLine();

		virtual void		getObjectOverlay( QList <QRect> & list );

	  virtual void 		paint( QPainter *p );
	  virtual bool		contains( QPoint *pt );

		virtual void 		move();
		virtual void 		moveMe( Coordinates & coords );
		virtual void 		moveMe( Coordinates & coords, double position );
		virtual double	positionMe( Coordinates & coords );

		virtual void 		writeToFile( KSimpleConfig *config );
		virtual void 		readFromFile( KSimpleConfig *config );

	protected:

		virtual	void	computeGoBeyond();
		virtual	void	computeArrow();
						void	computeArrow( pointInfo & infoCoord1, pointInfo & infoCoord2 );
};

#endif
